package io.reactivex.internal.operators.observable;

import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import ඓ.ⁱ.K.ඓ.C1252;
import 㴹.K.AbstractC2500;
import 㴹.K.AbstractC2518;
import 㴹.K.AbstractC2520;
import 㴹.K.Ԕ.ඓ.ῲ.AbstractC2445;
import 㴹.K.Ԕ.ῲ.C2456;
import 㴹.K.㑃.AbstractC2514;

public final class ObservableBuffer<T, U extends Collection<? super T>> extends AbstractC2445<T, U> {

    /* renamed from: ʬ  reason: contains not printable characters */
    public final int f3412;

    /* renamed from: ඓ  reason: contains not printable characters */
    public final Callable<U> f3413;

    /* renamed from: 㸾  reason: contains not printable characters */
    public final int f3414;

    public static final class BufferSkipObserver<T, U extends Collection<? super T>> extends AtomicBoolean implements AbstractC2520<T>, AbstractC2514 {
        public static final long serialVersionUID = -8223395059921494546L;
        public final AbstractC2520<? super U> actual;
        public final Callable<U> bufferSupplier;
        public final ArrayDeque<U> buffers = new ArrayDeque<>();
        public final int count;
        public long index;
        public AbstractC2514 s;
        public final int skip;

        public BufferSkipObserver(AbstractC2520<? super U> r1, int i, int i2, Callable<U> callable) {
            this.actual = r1;
            this.count = i;
            this.skip = i2;
            this.bufferSupplier = callable;
        }

        @Override // 㴹.K.㑃.AbstractC2514
        public void dispose() {
            this.s.dispose();
        }

        @Override // 㴹.K.㑃.AbstractC2514
        public boolean isDisposed() {
            return this.s.isDisposed();
        }

        @Override // 㴹.K.AbstractC2520
        public void onComplete() {
            while (!this.buffers.isEmpty()) {
                this.actual.onNext(this.buffers.poll());
            }
            this.actual.onComplete();
        }

        @Override // 㴹.K.AbstractC2520
        public void onError(Throwable th) {
            this.buffers.clear();
            this.actual.onError(th);
        }

        @Override // 㴹.K.AbstractC2520
        public void onNext(T t) {
            long j = this.index;
            this.index = 1 + j;
            if (j % ((long) this.skip) == 0) {
                try {
                    U call = this.bufferSupplier.call();
                    C2456.m6500(call, "The bufferSupplier returned a null collection. Null values are generally not allowed in 2.x operators and sources.");
                    this.buffers.offer(call);
                } catch (Throwable th) {
                    this.buffers.clear();
                    this.s.dispose();
                    this.actual.onError(th);
                    return;
                }
            }
            Iterator<U> it2 = this.buffers.iterator();
            while (it2.hasNext()) {
                U next = it2.next();
                next.add(t);
                if (this.count <= next.size()) {
                    it2.remove();
                    this.actual.onNext(next);
                }
            }
        }

        @Override // 㴹.K.AbstractC2520
        public void onSubscribe(AbstractC2514 r2) {
            if (DisposableHelper.validate(this.s, r2)) {
                this.s = r2;
                this.actual.onSubscribe(this);
            }
        }
    }

    /* renamed from: io.reactivex.internal.operators.observable.ObservableBuffer$K  reason: contains not printable characters */
    public static final class C0572<T, U extends Collection<? super T>> implements AbstractC2520<T>, AbstractC2514 {

        /* renamed from: ʬ  reason: contains not printable characters */
        public final int f3415;

        /* renamed from: ඓ  reason: contains not printable characters */
        public U f3416;

        /* renamed from: ῲ  reason: contains not printable characters */
        public final AbstractC2520<? super U> f3417;

        /* renamed from: ⁱ  reason: contains not printable characters */
        public AbstractC2514 f3418;

        /* renamed from: 㴹  reason: contains not printable characters */
        public int f3419;

        /* renamed from: 㸾  reason: contains not printable characters */
        public final Callable<U> f3420;

        public C0572(AbstractC2520<? super U> r1, int i, Callable<U> callable) {
            this.f3417 = r1;
            this.f3415 = i;
            this.f3420 = callable;
        }

        @Override // 㴹.K.㑃.AbstractC2514
        public void dispose() {
            this.f3418.dispose();
        }

        @Override // 㴹.K.㑃.AbstractC2514
        public boolean isDisposed() {
            return this.f3418.isDisposed();
        }

        @Override // 㴹.K.AbstractC2520
        public void onComplete() {
            U u = this.f3416;
            this.f3416 = null;
            if (u != null && !u.isEmpty()) {
                this.f3417.onNext(u);
            }
            this.f3417.onComplete();
        }

        @Override // 㴹.K.AbstractC2520
        public void onError(Throwable th) {
            this.f3416 = null;
            this.f3417.onError(th);
        }

        @Override // 㴹.K.AbstractC2520
        public void onNext(T t) {
            U u = this.f3416;
            if (u != null) {
                u.add(t);
                int i = this.f3419 + 1;
                this.f3419 = i;
                if (i >= this.f3415) {
                    this.f3417.onNext(u);
                    this.f3419 = 0;
                    m1949();
                }
            }
        }

        @Override // 㴹.K.AbstractC2520
        public void onSubscribe(AbstractC2514 r2) {
            if (DisposableHelper.validate(this.f3418, r2)) {
                this.f3418 = r2;
                this.f3417.onSubscribe(this);
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public boolean m1949() {
            try {
                U call = this.f3420.call();
                C2456.m6500(call, "Empty buffer supplied");
                this.f3416 = call;
                return true;
            } catch (Throwable th) {
                C1252.m3329(th);
                this.f3416 = null;
                AbstractC2514 r1 = this.f3418;
                if (r1 == null) {
                    EmptyDisposable.error(th, this.f3417);
                    return false;
                }
                r1.dispose();
                this.f3417.onError(th);
                return false;
            }
        }
    }

    public ObservableBuffer(AbstractC2518<T> r1, int i, int i2, Callable<U> callable) {
        super(r1);
        this.f3412 = i;
        this.f3414 = i2;
        this.f3413 = callable;
    }

    @Override // 㴹.K.AbstractC2500
    /* renamed from: ῲ  reason: contains not printable characters */
    public void m1948(AbstractC2520<? super U> r6) {
        int i = this.f3414;
        int i2 = this.f3412;
        if (i == i2) {
            C0572 k = new C0572(r6, i2, this.f3413);
            if (k.m1949()) {
                ((AbstractC2500) this.f8388).m6545((AbstractC2520) k);
                return;
            }
            return;
        }
        ((AbstractC2500) this.f8388).m6545((AbstractC2520) new BufferSkipObserver(r6, i2, i, this.f3413));
    }
}
