package io.reactivex.internal.observers;

import io.reactivex.exceptions.CompositeException;
import io.reactivex.internal.disposables.DisposableHelper;
import java.util.concurrent.atomic.AtomicReference;
import ඓ.ⁱ.K.ඓ.C1252;
import 㴹.K.AbstractC2520;
import 㴹.K.Ԕ.ῲ.C2457;
import 㴹.K.㑃.AbstractC2514;
import 㴹.K.䁗.AbstractC2522;
import 㴹.K.䁗.AbstractC2523;

public final class LambdaObserver<T> extends AtomicReference<AbstractC2514> implements AbstractC2520<T>, AbstractC2514 {
    public static final long serialVersionUID = -7251123623727029452L;
    public final AbstractC2523 onComplete;
    public final AbstractC2522<? super Throwable> onError;
    public final AbstractC2522<? super T> onNext;
    public final AbstractC2522<? super AbstractC2514> onSubscribe;

    public LambdaObserver(AbstractC2522<? super T> r1, AbstractC2522<? super Throwable> r2, AbstractC2523 k, AbstractC2522<? super AbstractC2514> r4) {
        this.onNext = r1;
        this.onError = r2;
        this.onComplete = k;
        this.onSubscribe = r4;
    }

    @Override // 㴹.K.㑃.AbstractC2514
    public void dispose() {
        DisposableHelper.dispose(this);
    }

    @Override // 㴹.K.㑃.AbstractC2514
    public boolean isDisposed() {
        return get() == DisposableHelper.DISPOSED;
    }

    @Override // 㴹.K.AbstractC2520
    public void onComplete() {
        if (!isDisposed()) {
            lazySet(DisposableHelper.DISPOSED);
            try {
                ((C2457.C2462) this.onComplete).m6502();
            } catch (Throwable th) {
                C1252.m3329(th);
                C1252.m3349(th);
            }
        }
    }

    @Override // 㴹.K.AbstractC2520
    public void onError(Throwable th) {
        if (!isDisposed()) {
            lazySet(DisposableHelper.DISPOSED);
            try {
                this.onError.accept(th);
            } catch (Throwable th2) {
                C1252.m3329(th2);
                C1252.m3349(new CompositeException(th, th2));
            }
        }
    }

    @Override // 㴹.K.AbstractC2520
    public void onNext(T t) {
        if (!isDisposed()) {
            try {
                this.onNext.accept(t);
            } catch (Throwable th) {
                C1252.m3329(th);
                ((AbstractC2514) get()).dispose();
                onError(th);
            }
        }
    }

    @Override // 㴹.K.AbstractC2520
    public void onSubscribe(AbstractC2514 r2) {
        if (DisposableHelper.setOnce(this, r2)) {
            try {
                this.onSubscribe.accept(this);
            } catch (Throwable th) {
                C1252.m3329(th);
                r2.dispose();
                onError(th);
            }
        }
    }
}
