package com.scwang.smartrefresh.layout.header;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import com.scwang.smartrefresh.layout.R$styleable;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.header.bezierradar.RippleView;
import com.scwang.smartrefresh.layout.header.bezierradar.RoundDotView;
import com.scwang.smartrefresh.layout.header.bezierradar.RoundProgressView;
import com.scwang.smartrefresh.layout.header.bezierradar.WaveView;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1391;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1396;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1401;
import ඓ.㿎.K.ῲ.ؿ.C1405;
import ඓ.㿎.K.ῲ.ؿ.C1406;
import ඓ.㿎.K.ῲ.ؿ.RunnableC1402;
import ඓ.㿎.K.ῲ.䀟.C1436;

public class BezierRadarHeader extends FrameLayout implements AbstractC1391 {

    /* renamed from: ʬ  reason: contains not printable characters */
    public RippleView f3295;

    /* renamed from: ඓ  reason: contains not printable characters */
    public RoundProgressView f3296;

    /* renamed from: ῲ  reason: contains not printable characters */
    public WaveView f3297;

    /* renamed from: 㸾  reason: contains not printable characters */
    public RoundDotView f3298;

    /* renamed from: com.scwang.smartrefresh.layout.header.BezierRadarHeader$K  reason: contains not printable characters */
    public class C0562 extends AnimatorListenerAdapter {
        public C0562() {
        }

        public void onAnimationEnd(Animator animator) {
            super.onAnimationEnd(animator);
            BezierRadarHeader.this.f3298.setVisibility(4);
            BezierRadarHeader.this.f3296.animate().scaleX(1.0f);
            BezierRadarHeader.this.f3296.animate().scaleY(1.0f);
            BezierRadarHeader.this.f3296.postDelayed(new RunnableC1402(this), 200);
        }
    }

    public BezierRadarHeader(Context context) {
        this(context, null);
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    public SpinnerStyle getSpinnerStyle() {
        return SpinnerStyle.Scale;
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    public View getView() {
        return this;
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    public void setPrimaryColors(int... iArr) {
        if (iArr.length > 0) {
            m1872(iArr[0]);
        }
        if (iArr.length > 1) {
            m1874(iArr[1]);
        }
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public BezierRadarHeader m1872(int i) {
        this.f3297.setWaveColor(i);
        this.f3296.setBackColor(i);
        return this;
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m1876(Context context, AttributeSet attributeSet) {
        setMinimumHeight(C1436.m3649(100.0f));
        this.f3297 = new WaveView(getContext());
        this.f3295 = new RippleView(getContext());
        this.f3298 = new RoundDotView(getContext());
        this.f3296 = new RoundProgressView(getContext());
        if (isInEditMode()) {
            addView(this.f3297, -1, -1);
            addView(this.f3296, -1, -1);
            this.f3297.setHeadHeight(1000);
        } else {
            addView(this.f3297, -1, -1);
            addView(this.f3298, -1, -1);
            addView(this.f3296, -1, -1);
            addView(this.f3295, -1, -1);
            this.f3296.setScaleX(0.0f);
            this.f3296.setScaleY(0.0f);
        }
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, R$styleable.BezierRadarHeader);
        int color = obtainStyledAttributes.getColor(R$styleable.BezierRadarHeader_srlPrimaryColor, 0);
        int color2 = obtainStyledAttributes.getColor(R$styleable.BezierRadarHeader_srlAccentColor, 0);
        if (color != 0) {
            m1872(color);
        }
        if (color2 != 0) {
            m1874(color);
        }
        obtainStyledAttributes.recycle();
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    /* renamed from: K  reason: contains not printable characters */
    public void m1877(AbstractC1396 r1, int i, int i2) {
    }

    public BezierRadarHeader(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public BezierRadarHeader(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        m1876(context, attributeSet);
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1391
    /* renamed from: ῲ  reason: contains not printable characters */
    public void m1873(float f, int i, int i2, int i3) {
        this.f3297.setHeadHeight(Math.min(i2, i));
        this.f3297.setWaveHeight((int) (((float) Math.max(0, i - i2)) * 1.9f));
        this.f3298.setFraction(f);
    }

    /* renamed from: K  reason: contains not printable characters */
    public BezierRadarHeader m1874(int i) {
        this.f3298.setDotColor(i);
        this.f3295.setFrontColor(i);
        this.f3296.setFrontColor(i);
        return this;
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1391
    /* renamed from: K  reason: contains not printable characters */
    public void m1875(float f, int i, int i2, int i3) {
        this.f3297.setHeadHeight(Math.min(i2, i));
        this.f3297.setWaveHeight((int) (((float) Math.max(0, i - i2)) * 1.9f));
        this.f3298.setFraction(f);
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    /* renamed from: K  reason: contains not printable characters */
    public void m1879(AbstractC1401 r5, int i, int i2) {
        this.f3297.setHeadHeight(i);
        ValueAnimator ofInt = ValueAnimator.ofInt(this.f3297.getWaveHeight(), 0, -((int) (((double) this.f3297.getWaveHeight()) * 0.8d)), 0, -((int) (((float) this.f3297.getWaveHeight()) * 0.4f)), 0);
        ofInt.addUpdateListener(new C1406(this));
        ofInt.setInterpolator(new DecelerateInterpolator());
        ofInt.setDuration(800L);
        ofInt.start();
        ValueAnimator ofFloat = ValueAnimator.ofFloat(1.0f, 0.0f);
        ofFloat.addListener(new C0562());
        ofFloat.setInterpolator(new DecelerateInterpolator());
        ofFloat.setDuration(300L);
        ofFloat.addUpdateListener(new C1405(this));
        ofFloat.start();
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    /* renamed from: K  reason: contains not printable characters */
    public void m1878(AbstractC1401 r2) {
        this.f3296.m1897();
        this.f3296.animate().scaleX(0.0f);
        this.f3296.animate().scaleY(0.0f);
        this.f3295.m1895();
    }

    @Override // ඓ.㿎.K.ῲ.ݜ.AbstractC1408
    /* renamed from: K  reason: contains not printable characters */
    public void m1880(AbstractC1401 r1, RefreshState refreshState, RefreshState refreshState2) {
        int ordinal = refreshState2.ordinal();
        if (ordinal == 0) {
            return;
        }
        if (ordinal == 1) {
            this.f3298.setAlpha(1.0f);
            this.f3298.setVisibility(0);
            this.f3296.setScaleX(0.0f);
            this.f3296.setScaleY(0.0f);
        } else if (ordinal == 2) {
        }
    }
}
