package com.scwang.smartrefresh.layout;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.webkit.WebView;
import android.widget.AbsListView;
import android.widget.ScrollView;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager.widget.ViewPager;
import com.scwang.smartrefresh.layout.constant.DimensionStatus;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.footer.BallPulseFooter;
import com.scwang.smartrefresh.layout.header.BezierRadarHeader;
import ඓ.㿎.K.ῲ.C1411;
import ඓ.㿎.K.ῲ.C1421;
import ඓ.㿎.K.ῲ.C1423;
import ඓ.㿎.K.ῲ.C1432;
import ඓ.㿎.K.ῲ.C1433;
import ඓ.㿎.K.ῲ.C1434;
import ඓ.㿎.K.ῲ.C1435;
import ඓ.㿎.K.ῲ.RunnableC1420;
import ඓ.㿎.K.ῲ.RunnableC1424;
import ඓ.㿎.K.ῲ.RunnableC1425;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1390;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1391;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1392;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1395;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1396;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1397;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1398;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1400;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1401;
import ඓ.㿎.K.ῲ.ݜ.AbstractC1409;
import ඓ.㿎.K.ῲ.ݜ.AbstractC1410;
import ඓ.㿎.K.ῲ.ᓣ.AbstractC1418;
import ඓ.㿎.K.ῲ.ᓣ.C1412;
import ඓ.㿎.K.ῲ.ᓣ.C1413;
import ඓ.㿎.K.ῲ.ᓣ.C1414;
import ඓ.㿎.K.ῲ.ᓣ.C1417;
import ඓ.㿎.K.ῲ.ᓣ.C1419;
import ῲ.ᨨ.ᨨ.AbstractC1735;
import ῲ.ᨨ.ᨨ.AbstractC1741;
import ῲ.ᨨ.ᨨ.AbstractC1746;
import ῲ.ᨨ.ᨨ.C1729;
import ῲ.ᨨ.ᨨ.C1751;
import ῲ.ᨨ.ᨨ.C1775;

public class SmartRefreshLayout extends ViewGroup implements AbstractC1741, AbstractC1746, AbstractC1401 {

    /* renamed from: ӯ  reason: contains not printable characters */
    public static AbstractC1395 f3224 = C1411.f5339;

    /* renamed from: ᴊ  reason: contains not printable characters */
    public static AbstractC1397 f3225 = C1434.f5391;

    /* renamed from: ʬ  reason: contains not printable characters */
    public int f3226;

    /* renamed from: Ϸ  reason: contains not printable characters */
    public Animator.AnimatorListener f3227;

    /* renamed from: В  reason: contains not printable characters */
    public int f3228;

    /* renamed from: ѷ  reason: contains not printable characters */
    public AbstractC1390 f3229;

    /* renamed from: Ԕ  reason: contains not printable characters */
    public boolean f3230;

    /* renamed from: Ԛ  reason: contains not printable characters */
    public boolean f3231;

    /* renamed from: ؿ  reason: contains not printable characters */
    public boolean f3232;

    /* renamed from: ݜ  reason: contains not printable characters */
    public boolean f3233;

    /* renamed from: ࠋ  reason: contains not printable characters */
    public Paint f3234;

    /* renamed from: ಯ  reason: contains not printable characters */
    public int f3235;

    /* renamed from: ඓ  reason: contains not printable characters */
    public int f3236;

    /* renamed from: ผ  reason: contains not printable characters */
    public int f3237;

    /* renamed from: ᆯ  reason: contains not printable characters */
    public AbstractC1392 f3238;

    /* renamed from: ሽ  reason: contains not printable characters */
    public int f3239;

    /* renamed from: ጒ  reason: contains not printable characters */
    public int f3240;

    /* renamed from: Ꮝ  reason: contains not printable characters */
    public ValueAnimator.AnimatorUpdateListener f3241;

    /* renamed from: ᑓ  reason: contains not printable characters */
    public int[] f3242;

    /* renamed from: ᑾ  reason: contains not printable characters */
    public DimensionStatus f3243;

    /* renamed from: ᓆ  reason: contains not printable characters */
    public AbstractC1410 f3244;

    /* renamed from: ᓣ  reason: contains not printable characters */
    public boolean f3245;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public Interpolator f3246;

    /* renamed from: ᝁ  reason: contains not printable characters */
    public AbstractC1396 f3247;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public float f3248;

    /* renamed from: ᶲ  reason: contains not printable characters */
    public AbstractC1400 f3249;

    /* renamed from: ῲ  reason: contains not printable characters */
    public RefreshState f3250;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public float f3251;

    /* renamed from: ⶍ  reason: contains not printable characters */
    public AbstractC1398 f3252;

    /* renamed from: ゎ  reason: contains not printable characters */
    public float f3253;

    /* renamed from: ト  reason: contains not printable characters */
    public boolean f3254;

    /* renamed from: ピ  reason: contains not printable characters */
    public MotionEvent f3255;

    /* renamed from: 㑃  reason: contains not printable characters */
    public int[] f3256;

    /* renamed from: 㒁  reason: contains not printable characters */
    public float f3257;

    /* renamed from: 㓚  reason: contains not printable characters */
    public ValueAnimator f3258;

    /* renamed from: 㗗  reason: contains not printable characters */
    public boolean f3259;

    /* renamed from: 㗽  reason: contains not printable characters */
    public boolean f3260;

    /* renamed from: 㮔  reason: contains not printable characters */
    public C1775 f3261;

    /* renamed from: 㮝  reason: contains not printable characters */
    public DimensionStatus f3262;

    /* renamed from: 㱶  reason: contains not printable characters */
    public int f3263;

    /* renamed from: 㳳  reason: contains not printable characters */
    public float f3264;

    /* renamed from: 㴪  reason: contains not printable characters */
    public int[] f3265;

    /* renamed from: 㴹  reason: contains not printable characters */
    public int f3266;

    /* renamed from: 㶋  reason: contains not printable characters */
    public AbstractC1409 f3267;

    /* renamed from: 㷛  reason: contains not printable characters */
    public AbstractC1391 f3268;

    /* renamed from: 㸾  reason: contains not printable characters */
    public int f3269;

    /* renamed from: 㹎  reason: contains not printable characters */
    public float f3270;

    /* renamed from: 㿎  reason: contains not printable characters */
    public float f3271;

    /* renamed from: 䀟  reason: contains not printable characters */
    public boolean f3272;

    /* renamed from: 䁗  reason: contains not printable characters */
    public boolean f3273;

    /* renamed from: 䃖  reason: contains not printable characters */
    public C1751 f3274;

    /* renamed from: com.scwang.smartrefresh.layout.SmartRefreshLayout$ʬ  reason: contains not printable characters */
    public class C0559 implements AbstractC1396 {
        public C0559() {
        }

        /* renamed from: K  reason: contains not printable characters */
        public AbstractC1396 m1854(AbstractC1392 r2) {
            AbstractC1392 r0 = SmartRefreshLayout.this.f3238;
            if (r0 != null) {
                ((AbstractC1418) r0).m3638(r2);
            }
            SmartRefreshLayout.this.f3238 = r2;
            return this;
        }
    }

    /* renamed from: com.scwang.smartrefresh.layout.SmartRefreshLayout$ῲ  reason: contains not printable characters */
    public static class C0560 extends ViewGroup.MarginLayoutParams {
        public C0560(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public C0560(int i, int i2) {
            super(i, i2);
        }

        public C0560(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }
    }

    /* renamed from: com.scwang.smartrefresh.layout.SmartRefreshLayout$K  reason: contains not printable characters */
    public class C0561 extends AnimatorListenerAdapter {
        public C0561() {
        }

        public void onAnimationEnd(Animator animator) {
            SmartRefreshLayout smartRefreshLayout;
            RefreshState refreshState;
            SmartRefreshLayout.this.f3258 = null;
            if (((Integer) ((ValueAnimator) animator).getAnimatedValue()).intValue() == 0 && (smartRefreshLayout = SmartRefreshLayout.this).f3250 != (refreshState = RefreshState.None)) {
                smartRefreshLayout.m1847(refreshState);
            }
        }
    }

    public SmartRefreshLayout(Context context) {
        super(context);
        this.f3250 = RefreshState.None;
        this.f3236 = 300;
        this.f3248 = 0.5f;
        this.f3273 = true;
        this.f3230 = true;
        this.f3259 = false;
        this.f3232 = false;
        this.f3245 = true;
        this.f3260 = true;
        this.f3233 = true;
        this.f3272 = false;
        this.f3231 = false;
        this.f3265 = new int[2];
        this.f3242 = new int[2];
        DimensionStatus dimensionStatus = DimensionStatus.DefaultUnNotify;
        this.f3243 = dimensionStatus;
        this.f3262 = dimensionStatus;
        this.f3270 = 2.0f;
        this.f3257 = 2.0f;
        this.f3237 = 0;
        this.f3263 = 0;
        this.f3255 = null;
        this.f3227 = new C0561();
        this.f3241 = new C1433(this);
        m1846(context, (AttributeSet) null);
    }

    public static void setDefaultRefreshFooterCreater(AbstractC1397 k) {
        f3225 = k;
    }

    public static void setDefaultRefreshHeaderCreater(AbstractC1395 r0) {
        f3224 = r0;
    }

    public boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof C0560;
    }

    public void dispatchDraw(Canvas canvas) {
        boolean z = this.f3233 && isInEditMode();
        if (this.f3237 != 0 && (this.f3269 > 0 || z)) {
            this.f3234.setColor(this.f3237);
            canvas.drawRect(0.0f, 0.0f, (float) getWidth(), (float) (z ? this.f3239 : this.f3269), this.f3234);
        } else if (this.f3263 != 0 && (this.f3269 < 0 || z)) {
            this.f3234.setColor(this.f3263);
            canvas.drawRect(0.0f, 0.0f, (float) getWidth(), (float) (getHeight() + (z ? -this.f3228 : this.f3269)), this.f3234);
        }
        super.dispatchDraw(canvas);
    }

    public boolean dispatchNestedFling(float f, float f2, boolean z) {
        return this.f3261.m4631(f, f2, z);
    }

    public boolean dispatchNestedPreFling(float f, float f2) {
        return this.f3261.m4630(f, f2);
    }

    public boolean dispatchNestedPreScroll(int i, int i2, int[] iArr, int[] iArr2) {
        return this.f3261.m4634(i, i2, iArr, iArr2);
    }

    public boolean dispatchNestedScroll(int i, int i2, int i3, int i4, int[] iArr) {
        return this.f3261.m4633(i, i2, i3, i4, iArr);
    }

    /* JADX WARNING: Code restructure failed: missing block: B:19:0x0033, code lost:
        if (r2 != 3) goto L_0x0161;
     */
    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        RefreshState refreshState;
        RefreshState refreshState2;
        if (isEnabled() && !this.f3254 && ((this.f3273 || (this.f3230 && !this.f3231)) && (refreshState = this.f3250) != RefreshState.Loading && refreshState != RefreshState.Refreshing)) {
            int action = motionEvent.getAction();
            if (action != 0) {
                if (action != 1) {
                    if (action == 2) {
                        float x = motionEvent.getX() - this.f3251;
                        float y = motionEvent.getY() - this.f3271;
                        if (this.f3250 == RefreshState.None) {
                            if (Math.abs(y) < ((float) this.f3226) || Math.abs(x) >= Math.abs(y)) {
                                return super.dispatchTouchEvent(motionEvent);
                            }
                            if (y > 0.0f && this.f3273) {
                                C1414 r6 = (C1414) this.f3229;
                                if (!C1414.m3623(r6.f5346, r6.f5344)) {
                                    this.f3264 = (this.f3271 + y) - ((float) this.f3226);
                                    m1851();
                                    motionEvent.setAction(3);
                                    super.dispatchTouchEvent(motionEvent);
                                }
                            }
                            if (y < 0.0f && this.f3230 && !this.f3231) {
                                C1414 r62 = (C1414) this.f3229;
                                if (!C1414.m3624(r62.f5346, r62.f5344)) {
                                    this.f3264 = this.f3271 + y + ((float) this.f3226);
                                    m1853();
                                    motionEvent.setAction(3);
                                    super.dispatchTouchEvent(motionEvent);
                                }
                            }
                            return super.dispatchTouchEvent(motionEvent);
                        }
                        float f = (y + this.f3271) - this.f3264;
                        RefreshState refreshState3 = this.f3250;
                        if (((refreshState3 == RefreshState.PullDownToRefresh || refreshState3 == RefreshState.ReleaseToRefresh) && f < 0.0f) || (((refreshState2 = this.f3250) == RefreshState.PullToUpLoad || refreshState2 == RefreshState.ReleaseToLoad) && f > 0.0f)) {
                            long currentTimeMillis = System.currentTimeMillis();
                            if (this.f3255 == null) {
                                this.f3255 = MotionEvent.obtain(currentTimeMillis, currentTimeMillis, 0, this.f3251 + x, this.f3264, 0);
                                super.dispatchTouchEvent(this.f3255);
                            }
                            super.dispatchTouchEvent(MotionEvent.obtain(currentTimeMillis, currentTimeMillis, 2, this.f3251 + x, this.f3264 + f, 0));
                            if (this.f3269 != 0) {
                                m1844(0.0f);
                            }
                            return true;
                        }
                        RefreshState refreshState4 = this.f3250;
                        if (refreshState4 == RefreshState.PullDownToRefresh || refreshState4 == RefreshState.ReleaseToRefresh || refreshState4 == RefreshState.PullToUpLoad || refreshState4 == RefreshState.ReleaseToLoad) {
                            m1844(f);
                            return true;
                        }
                    }
                    return super.dispatchTouchEvent(motionEvent);
                }
                float y2 = motionEvent.getY();
                AbstractC1390 r2 = this.f3229;
                if (r2 != null) {
                    ((C1414) r2).f5344 = null;
                }
                if (this.f3255 != null) {
                    this.f3255 = null;
                    long currentTimeMillis2 = System.currentTimeMillis();
                    super.dispatchTouchEvent(MotionEvent.obtain(currentTimeMillis2, currentTimeMillis2, 3, this.f3251, y2, 0));
                }
                if (m1838()) {
                    return true;
                }
                return super.dispatchTouchEvent(motionEvent);
            }
            this.f3251 = motionEvent.getX();
            this.f3271 = motionEvent.getY();
            AbstractC1390 r22 = this.f3229;
            if (r22 != null) {
                ((C1414) r22).m3627(motionEvent);
            }
            super.dispatchTouchEvent(motionEvent);
            return true;
        } else if (this.f3250 == RefreshState.Loading && this.f3232) {
            return true;
        } else {
            if ((this.f3250 != RefreshState.Refreshing || !this.f3259) && !super.dispatchTouchEvent(motionEvent)) {
                return false;
            }
            return true;
        }
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1401
    public SmartRefreshLayout getLayout() {
        return this;
    }

    public int getNestedScrollAxes() {
        return this.f3274.m4547();
    }

    public AbstractC1400 getRefreshFooter() {
        return this.f3249;
    }

    public AbstractC1391 getRefreshHeader() {
        return this.f3268;
    }

    public RefreshState getState() {
        return this.f3250;
    }

    public boolean hasNestedScrollingParent() {
        return this.f3261.m4629();
    }

    public boolean isNestedScrollingEnabled() {
        return this.f3261.f6118;
    }

    public void onAttachedToWindow() {
        AbstractC1400 r4;
        super.onAttachedToWindow();
        if (!isInEditMode()) {
            if (this.f3247 == null) {
                this.f3247 = new C0559();
            }
            if (this.f3229 == null) {
                int childCount = getChildCount();
                for (int i = 0; i < childCount; i++) {
                    View childAt = getChildAt(i);
                    AbstractC1391 r42 = this.f3268;
                    if ((r42 == null || childAt != r42.getView()) && ((r4 = this.f3249) == null || childAt != r4.getView())) {
                        this.f3229 = new C1414(childAt);
                    }
                }
                if (this.f3229 == null) {
                    this.f3229 = new C1414(getContext());
                    ((C1414) this.f3229).f5346.setLayoutParams(new C0560(-1, -1));
                }
            }
            AbstractC1390 r0 = this.f3229;
            boolean z = this.f3272;
            AbstractC1396 r3 = this.f3247;
            C1414 r02 = (C1414) r0;
            View view = r02.f5345;
            if (view != null && z) {
                if (view instanceof AbsListView) {
                    AbsListView absListView = (AbsListView) view;
                    absListView.setOnScrollListener(new C1412(r02, absListView, r3));
                } else if (view instanceof RecyclerView) {
                    ((RecyclerView) view).addOnScrollListener(new C1419(r02, r3));
                }
            }
            if (this.f3268 == null) {
                this.f3268 = ((C1411) f3224).m3616(getContext(), this);
                if (!(this.f3268.getView().getLayoutParams() instanceof ViewGroup.MarginLayoutParams)) {
                    if (this.f3268.getSpinnerStyle() == SpinnerStyle.Scale) {
                        addView(this.f3268.getView(), -1, -1);
                    } else {
                        addView(this.f3268.getView(), -1, -2);
                    }
                }
            }
            if (this.f3249 == null) {
                this.f3249 = ((C1434) f3225).m3648(getContext(), this);
                if (!(this.f3249.getView().getLayoutParams() instanceof ViewGroup.MarginLayoutParams)) {
                    if (this.f3249.getSpinnerStyle() == SpinnerStyle.Scale) {
                        addView(this.f3249.getView(), -1, -1);
                    } else {
                        addView(this.f3249.getView(), -1, -2);
                    }
                }
            }
            bringChildToFront(((C1414) this.f3229).f5346);
            if (this.f3268.getSpinnerStyle() != SpinnerStyle.FixedBehind) {
                bringChildToFront(this.f3268.getView());
            }
            if (this.f3249.getSpinnerStyle() != SpinnerStyle.FixedBehind) {
                bringChildToFront(this.f3249.getView());
            }
            if (this.f3267 == null) {
                this.f3267 = C1421.f5358;
            }
            if (this.f3244 == null) {
                this.f3244 = C1432.f5389;
            }
            int[] iArr = this.f3256;
            if (iArr != null) {
                this.f3268.setPrimaryColors(iArr);
                this.f3249.setPrimaryColors(this.f3256);
            }
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.f3247 = null;
        this.f3268 = null;
        this.f3249 = null;
    }

    public void onFinishInflate() {
        super.onFinishInflate();
        int childCount = getChildCount();
        if (childCount <= 3) {
            boolean[] zArr = new boolean[childCount];
            for (int i = 0; i < childCount; i++) {
                View childAt = getChildAt(i);
                if (this.f3229 == null && ((childAt instanceof AbsListView) || (childAt instanceof WebView) || (childAt instanceof ScrollView) || (childAt instanceof AbstractC1735) || (childAt instanceof AbstractC1746) || (childAt instanceof AbstractC1741) || (childAt instanceof ViewPager))) {
                    this.f3229 = new C1414(childAt);
                } else if ((childAt instanceof AbstractC1391) && this.f3268 == null) {
                    this.f3268 = (AbstractC1391) childAt;
                } else if (!(childAt instanceof AbstractC1400) || this.f3249 != null) {
                    zArr[i] = true;
                } else {
                    this.f3249 = (AbstractC1400) childAt;
                }
            }
            for (int i2 = 0; i2 < childCount; i2++) {
                if (zArr[i2]) {
                    View childAt2 = getChildAt(i2);
                    if (childCount == 1 && this.f3229 == null) {
                        this.f3229 = new C1414(childAt2);
                    } else if (i2 == 0 && this.f3268 == null) {
                        this.f3268 = new C1413(childAt2);
                    } else if (childCount == 2 && this.f3229 == null) {
                        this.f3229 = new C1414(childAt2);
                    } else if (i2 == 2 && this.f3249 == null) {
                        this.f3249 = new C1417(childAt2);
                    } else if (this.f3229 == null) {
                        this.f3229 = new C1414(childAt2);
                    }
                }
            }
            if (isInEditMode()) {
                int[] iArr = this.f3256;
                if (iArr != null) {
                    AbstractC1391 r1 = this.f3268;
                    if (r1 != null) {
                        r1.setPrimaryColors(iArr);
                    }
                    AbstractC1400 r0 = this.f3249;
                    if (r0 != null) {
                        r0.setPrimaryColors(this.f3256);
                    }
                }
                bringChildToFront(((C1414) this.f3229).f5346);
                AbstractC1391 r02 = this.f3268;
                if (!(r02 == null || r02.getSpinnerStyle() == SpinnerStyle.FixedBehind)) {
                    bringChildToFront(this.f3268.getView());
                }
                AbstractC1400 r03 = this.f3249;
                if (!(r03 == null || r03.getSpinnerStyle() == SpinnerStyle.FixedBehind)) {
                    bringChildToFront(this.f3249.getView());
                }
                if (this.f3247 == null) {
                    this.f3247 = new C0559();
                    return;
                }
                return;
            }
            return;
        }
        throw new RuntimeException("最多只支持3个子View，Most only support three sub view");
    }

    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        int i5;
        AbstractC1391 r0;
        int paddingLeft = getPaddingLeft();
        int paddingTop = getPaddingTop();
        getPaddingBottom();
        boolean isInEditMode = isInEditMode();
        AbstractC1390 r8 = this.f3229;
        if (r8 != null) {
            C0560 r82 = (C0560) ((C1414) r8).f5346.getLayoutParams();
            int i6 = paddingLeft + ((ViewGroup.MarginLayoutParams) r82).leftMargin;
            int i7 = paddingTop + ((ViewGroup.MarginLayoutParams) r82).topMargin;
            int measuredWidth = ((C1414) this.f3229).f5346.getMeasuredWidth() + i6;
            int measuredHeight = ((C1414) this.f3229).f5346.getMeasuredHeight() + i7;
            if (isInEditMode && this.f3233 && (r0 = this.f3268) != null && (this.f3245 || r0.getSpinnerStyle() == SpinnerStyle.FixedBehind)) {
                int i8 = this.f3239;
                i7 += i8;
                measuredHeight += i8;
            }
            ((C1414) this.f3229).f5346.layout(i6, i7, measuredWidth, measuredHeight);
        }
        AbstractC1391 r5 = this.f3268;
        if (r5 != null) {
            View view = r5.getView();
            C0560 r83 = (C0560) view.getLayoutParams();
            int i9 = ((ViewGroup.MarginLayoutParams) r83).leftMargin;
            int i10 = ((ViewGroup.MarginLayoutParams) r83).topMargin;
            int measuredWidth2 = view.getMeasuredWidth() + i9;
            int measuredHeight2 = view.getMeasuredHeight() + i10;
            if (!isInEditMode || !this.f3233) {
                if (this.f3268.getSpinnerStyle() == SpinnerStyle.Translate) {
                    i10 -= this.f3239;
                    i5 = view.getMeasuredHeight();
                } else if (this.f3268.getSpinnerStyle() == SpinnerStyle.Scale) {
                    i5 = Math.max(0, this.f3269);
                }
                measuredHeight2 = i5 + i10;
            }
            view.layout(i9, i10, measuredWidth2, measuredHeight2);
        }
        AbstractC1400 r52 = this.f3249;
        if (r52 != null) {
            View view2 = r52.getView();
            C0560 r84 = (C0560) view2.getLayoutParams();
            SpinnerStyle spinnerStyle = this.f3249.getSpinnerStyle();
            int i11 = ((ViewGroup.MarginLayoutParams) r84).leftMargin;
            int measuredHeight3 = getMeasuredHeight() + ((ViewGroup.MarginLayoutParams) r84).topMargin;
            if ((isInEditMode && this.f3233) || spinnerStyle == SpinnerStyle.FixedFront || spinnerStyle == SpinnerStyle.FixedBehind) {
                measuredHeight3 -= this.f3228;
            } else if (spinnerStyle == SpinnerStyle.Scale) {
                measuredHeight3 += Math.min(this.f3269, 0);
            }
            view2.layout(i11, measuredHeight3, view2.getMeasuredWidth() + i11, view2.getMeasuredHeight() + measuredHeight3);
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:36:0x0130  */
    /* JADX WARNING: Removed duplicated region for block: B:67:0x0246  */
    /* JADX WARNING: Removed duplicated region for block: B:70:0x024b  */
    public void onMeasure(int i, int i2) {
        int i3;
        AbstractC1400 r4;
        AbstractC1390 r42;
        AbstractC1400 r3;
        AbstractC1391 r7;
        boolean isInEditMode = isInEditMode();
        AbstractC1391 r43 = this.f3268;
        if (r43 != null) {
            View view = r43.getView();
            C0560 r12 = (C0560) view.getLayoutParams();
            int childMeasureSpec = ViewGroup.getChildMeasureSpec(i, ((ViewGroup.MarginLayoutParams) r12).leftMargin + ((ViewGroup.MarginLayoutParams) r12).rightMargin, ((ViewGroup.MarginLayoutParams) r12).width);
            if (((ViewGroup.MarginLayoutParams) r12).height > 0) {
                if (this.f3243.canReplaceWith(DimensionStatus.XmlExact)) {
                    this.f3243 = DimensionStatus.XmlExact;
                    this.f3239 = ((ViewGroup.MarginLayoutParams) r12).height + ((ViewGroup.MarginLayoutParams) r12).topMargin + ((ViewGroup.MarginLayoutParams) r12).bottomMargin;
                    this.f3235 = (int) Math.max((this.f3270 - 1.0f) * ((float) this.f3239), 0.0f);
                    this.f3268.m3604(this.f3247, this.f3239, this.f3235);
                }
                view.measure(childMeasureSpec, View.MeasureSpec.makeMeasureSpec(((ViewGroup.MarginLayoutParams) r12).height, 1073741824));
            } else if (((ViewGroup.MarginLayoutParams) r12).height == -2) {
                view.measure(childMeasureSpec, View.MeasureSpec.makeMeasureSpec((View.MeasureSpec.getSize(i2) - ((ViewGroup.MarginLayoutParams) r12).topMargin) - ((ViewGroup.MarginLayoutParams) r12).bottomMargin, Integer.MIN_VALUE));
                if (view.getMeasuredHeight() <= 0 || !this.f3243.canReplaceWith(DimensionStatus.XmlWrap)) {
                    int i4 = this.f3239;
                    if (i4 <= 0) {
                        view.measure(childMeasureSpec, View.MeasureSpec.makeMeasureSpec((i4 - ((ViewGroup.MarginLayoutParams) r12).topMargin) - ((ViewGroup.MarginLayoutParams) r12).bottomMargin, 1073741824));
                    }
                } else {
                    this.f3243 = DimensionStatus.XmlWrap;
                    this.f3239 = view.getMeasuredHeight() + ((ViewGroup.MarginLayoutParams) r12).topMargin + ((ViewGroup.MarginLayoutParams) r12).bottomMargin;
                    this.f3235 = (int) Math.max((this.f3270 - 1.0f) * ((float) this.f3239), 0.0f);
                    this.f3268.m3604(this.f3247, this.f3239, this.f3235);
                }
            } else if (((ViewGroup.MarginLayoutParams) r12).height == -1) {
                view.measure(childMeasureSpec, View.MeasureSpec.makeMeasureSpec((this.f3239 - ((ViewGroup.MarginLayoutParams) r12).topMargin) - ((ViewGroup.MarginLayoutParams) r12).bottomMargin, 1073741824));
            } else {
                view.measure(childMeasureSpec, i2);
            }
            if (this.f3268.getSpinnerStyle() == SpinnerStyle.Scale && !isInEditMode) {
                view.measure(childMeasureSpec, View.MeasureSpec.makeMeasureSpec((Math.max(0, this.f3269) - ((ViewGroup.MarginLayoutParams) r12).topMargin) - ((ViewGroup.MarginLayoutParams) r12).bottomMargin, 1073741824));
            }
            DimensionStatus dimensionStatus = this.f3243;
            if (!dimensionStatus.notifyed) {
                this.f3243 = dimensionStatus.notifyed();
                this.f3268.m3604(this.f3247, this.f3239, this.f3235);
            }
            if (isInEditMode && this.f3233) {
                i3 = view.getMeasuredHeight() + 0;
                r4 = this.f3249;
                if (r4 == null) {
                    View view2 = r4.getView();
                    C0560 r5 = (C0560) view2.getLayoutParams();
                    int childMeasureSpec2 = ViewGroup.getChildMeasureSpec(i, ((ViewGroup.MarginLayoutParams) r5).leftMargin + ((ViewGroup.MarginLayoutParams) r5).rightMargin, ((ViewGroup.MarginLayoutParams) r5).width);
                    if (((ViewGroup.MarginLayoutParams) r5).height > 0) {
                        if (this.f3262.canReplaceWith(DimensionStatus.XmlExact)) {
                            this.f3262 = DimensionStatus.XmlExact;
                            this.f3228 = ((ViewGroup.MarginLayoutParams) r5).height + ((ViewGroup.MarginLayoutParams) r5).topMargin + ((ViewGroup.MarginLayoutParams) r5).bottomMargin;
                            this.f3240 = (int) Math.max((this.f3257 - 1.0f) * ((float) this.f3228), 0.0f);
                            this.f3249.m3604(this.f3247, this.f3228, this.f3240);
                        }
                        view2.measure(childMeasureSpec2, View.MeasureSpec.makeMeasureSpec(((ViewGroup.MarginLayoutParams) r5).height, 1073741824));
                    } else if (((ViewGroup.MarginLayoutParams) r5).height == -2) {
                        view2.measure(childMeasureSpec2, View.MeasureSpec.makeMeasureSpec((View.MeasureSpec.getSize(i2) - ((ViewGroup.MarginLayoutParams) r5).topMargin) - ((ViewGroup.MarginLayoutParams) r5).bottomMargin, Integer.MIN_VALUE));
                        int measuredHeight = view2.getMeasuredHeight();
                        if (measuredHeight > 0 && this.f3262.canReplaceWith(DimensionStatus.XmlWrap)) {
                            this.f3262 = DimensionStatus.XmlWrap;
                            this.f3228 = view2.getMeasuredHeight() + ((ViewGroup.MarginLayoutParams) r5).topMargin + ((ViewGroup.MarginLayoutParams) r5).bottomMargin;
                            this.f3240 = (int) Math.max((this.f3257 - 1.0f) * ((float) this.f3228), 0.0f);
                            this.f3249.m3604(this.f3247, this.f3228, this.f3240);
                        } else if (measuredHeight <= 0) {
                            view2.measure(childMeasureSpec2, View.MeasureSpec.makeMeasureSpec((this.f3228 - ((ViewGroup.MarginLayoutParams) r5).topMargin) - ((ViewGroup.MarginLayoutParams) r5).bottomMargin, 1073741824));
                        }
                    } else if (((ViewGroup.MarginLayoutParams) r5).height == -1) {
                        view2.measure(childMeasureSpec2, View.MeasureSpec.makeMeasureSpec((this.f3228 - ((ViewGroup.MarginLayoutParams) r5).topMargin) - ((ViewGroup.MarginLayoutParams) r5).bottomMargin, 1073741824));
                    } else {
                        view2.measure(childMeasureSpec2, i2);
                    }
                    if (this.f3249.getSpinnerStyle() == SpinnerStyle.Scale && !isInEditMode) {
                        view2.measure(childMeasureSpec2, View.MeasureSpec.makeMeasureSpec((Math.max(0, -this.f3269) - ((ViewGroup.MarginLayoutParams) r5).topMargin) - ((ViewGroup.MarginLayoutParams) r5).bottomMargin, 1073741824));
                    }
                    DimensionStatus dimensionStatus2 = this.f3262;
                    if (!dimensionStatus2.notifyed) {
                        this.f3262 = dimensionStatus2.notifyed();
                        this.f3249.m3604(this.f3247, this.f3228, this.f3240);
                    }
                    if (isInEditMode && this.f3233) {
                        i3 += view2.getMeasuredHeight();
                    }
                }
                r42 = this.f3229;
                if (r42 != null) {
                    C0560 r44 = (C0560) ((C1414) r42).f5346.getLayoutParams();
                    ((C1414) this.f3229).f5346.measure(ViewGroup.getChildMeasureSpec(i, getPaddingRight() + getPaddingLeft() + ((ViewGroup.MarginLayoutParams) r44).leftMargin + ((ViewGroup.MarginLayoutParams) r44).rightMargin, ((ViewGroup.MarginLayoutParams) r44).width), ViewGroup.getChildMeasureSpec(i2, getPaddingBottom() + getPaddingTop() + ((ViewGroup.MarginLayoutParams) r44).topMargin + ((ViewGroup.MarginLayoutParams) r44).bottomMargin + ((!isInEditMode || !this.f3233 || (r7 = this.f3268) == null || (!this.f3245 && r7.getSpinnerStyle() != SpinnerStyle.FixedBehind)) ? 0 : this.f3239) + ((!isInEditMode || !this.f3233 || (r3 = this.f3249) == null || (!this.f3260 && r3.getSpinnerStyle() != SpinnerStyle.FixedBehind)) ? 0 : this.f3228), ((ViewGroup.MarginLayoutParams) r44).height));
                    i3 += ((C1414) this.f3229).f5346.getMeasuredHeight();
                }
                setMeasuredDimension(ViewGroup.resolveSize(getSuggestedMinimumWidth(), i), ViewGroup.resolveSize(i3, i2));
            }
        }
        i3 = 0;
        r4 = this.f3249;
        if (r4 == null) {
        }
        r42 = this.f3229;
        if (r42 != null) {
        }
        setMeasuredDimension(ViewGroup.resolveSize(getSuggestedMinimumWidth(), i), ViewGroup.resolveSize(i3, i2));
    }

    public boolean onNestedFling(View view, float f, float f2, boolean z) {
        return dispatchNestedFling(f, f2, z);
    }

    public boolean onNestedPreFling(View view, float f, float f2) {
        return dispatchNestedPreFling(f, f2);
    }

    /* JADX WARNING: Removed duplicated region for block: B:24:0x0061  */
    /* JADX WARNING: Removed duplicated region for block: B:26:? A[RETURN, SYNTHETIC] */
    public void onNestedPreScroll(View view, int i, int i2, int[] iArr) {
        int[] iArr2;
        if (this.f3273 && i2 > 0) {
            float f = this.f3253;
            if (f > 0.0f) {
                float f2 = (float) i2;
                if (f2 > f) {
                    iArr[1] = i2 - ((int) f);
                    this.f3253 = 0.0f;
                } else {
                    this.f3253 = f - f2;
                    iArr[1] = i2;
                }
                m1844((float) ((int) this.f3253));
                iArr2 = this.f3265;
                if (!dispatchNestedPreScroll(i - iArr[0], i2 - iArr[1], iArr2, null)) {
                    iArr[0] = iArr[0] + iArr2[0];
                    iArr[1] = iArr[1] + iArr2[1];
                    return;
                }
                return;
            }
        }
        if (this.f3230 && !this.f3231 && i2 < 0) {
            float f3 = this.f3253;
            if (f3 < 0.0f) {
                float f4 = (float) i2;
                if (f4 < f3) {
                    iArr[1] = i2 - ((int) f3);
                    this.f3253 = 0.0f;
                } else {
                    this.f3253 = f3 - f4;
                    iArr[1] = i2;
                }
                m1844((float) ((int) this.f3253));
            }
        }
        iArr2 = this.f3265;
        if (!dispatchNestedPreScroll(i - iArr[0], i2 - iArr[1], iArr2, null)) {
        }
    }

    /* JADX WARNING: Code restructure failed: missing block: B:6:0x0024, code lost:
        if (ඓ.㿎.K.ῲ.ᓣ.C1414.m3623(r7.f5346, r7.f5344) == false) goto L_0x0026;
     */
    public void onNestedScroll(View view, int i, int i2, int i3, int i4) {
        dispatchNestedScroll(i, i2, i3, i4, this.f3242);
        int i5 = i4 + this.f3242[1];
        if (this.f3273 && i5 < 0) {
            AbstractC1390 r7 = this.f3229;
            if (r7 != null) {
                C1414 r72 = (C1414) r7;
            }
            if (this.f3250 == RefreshState.None) {
                m1851();
            }
            this.f3253 += (float) Math.abs(i5);
            m1844(this.f3253);
            return;
        }
        if (this.f3230 && !this.f3231 && i5 > 0) {
            AbstractC1390 r73 = this.f3229;
            if (r73 != null) {
                C1414 r74 = (C1414) r73;
                if (C1414.m3624(r74.f5346, r74.f5344)) {
                    return;
                }
            }
            if (this.f3250 == RefreshState.None) {
                m1853();
            }
            this.f3253 -= (float) Math.abs(i5);
            m1844(this.f3253);
        }
    }

    public void onNestedScrollAccepted(View view, View view2, int i) {
        this.f3274.f6066 = i;
        startNestedScroll(i & 2);
        this.f3253 = 0.0f;
        this.f3254 = true;
    }

    public boolean onStartNestedScroll(View view, View view2, int i) {
        RefreshState refreshState;
        return isEnabled() && !((!this.f3273 && (!this.f3230 || this.f3231)) || (refreshState = this.f3250) == RefreshState.Loading || refreshState == RefreshState.Refreshing || (i & 2) == 0);
    }

    public void onStopNestedScroll(View view) {
        this.f3274.m4548(0);
        this.f3254 = false;
        if (this.f3253 != 0.0f) {
            m1838();
            this.f3253 = 0.0f;
        }
        stopNestedScroll();
    }

    public void requestDisallowInterceptTouchEvent(boolean z) {
        View view = ((C1414) this.f3229).f5345;
        int i = Build.VERSION.SDK_INT;
        if (view == null || C1729.m4455(view)) {
            super.requestDisallowInterceptTouchEvent(z);
        }
    }

    public void setNestedScrollingEnabled(boolean z) {
        C1775 r0 = this.f3261;
        if (r0.f6118) {
            C1729.m4441(r0.f6114);
        }
        r0.f6118 = z;
    }

    public boolean startNestedScroll(int i) {
        return this.f3261.m4632(i, 0);
    }

    public void stopNestedScroll() {
        this.f3261.m4624(0);
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public void m1829() {
        RefreshState refreshState = this.f3250;
        if (refreshState != RefreshState.None) {
            if (refreshState == RefreshState.Refreshing && this.f3268 != null) {
                m1847(RefreshState.RefreshFinish);
                this.f3268.m3605(this);
            } else if (this.f3250 == RefreshState.Loading && this.f3249 != null) {
                m1847(RefreshState.LoadingFinish);
                AbstractC1390 r0 = this.f3229;
                int i = this.f3228;
                View view = ((C1414) r0).f5345;
                if (view != null) {
                    if (view instanceof RecyclerView) {
                        ((RecyclerView) view).smoothScrollBy(0, i);
                    } else if (view instanceof ScrollView) {
                        ((ScrollView) view).smoothScrollBy(0, i);
                    } else if (view instanceof AbsListView) {
                        ((AbsListView) view).smoothScrollBy(i, 150);
                    } else {
                        try {
                            view.getClass().getDeclaredMethod("smoothScrollBy", Integer.class, Integer.class).invoke(view, 0, Integer.valueOf(i));
                        } catch (Exception unused) {
                            view.scrollBy(0, i);
                        }
                    }
                }
                this.f3249.m3605(this);
            }
            if (this.f3269 == 0) {
                m1847(RefreshState.None);
            }
        }
        if (this.f3269 != 0) {
            m1830(0);
        }
    }

    /* renamed from: ඓ  reason: contains not printable characters */
    public void m1831() {
        m1847(RefreshState.PullDownCanceled);
        m1829();
    }

    /* renamed from: ᕣ  reason: contains not printable characters */
    public void m1832() {
        m1847(RefreshState.ReleaseToRefresh);
    }

    /* renamed from: ᨨ  reason: contains not printable characters */
    public void m1833() {
        System.currentTimeMillis();
        m1847(RefreshState.Refreshing);
        m1830(this.f3239);
        AbstractC1409 r0 = this.f3267;
        if (r0 != null) {
            C1421 r02 = (C1421) r0;
            m3609((AbstractC1401) 3000);
        }
        AbstractC1391 r03 = this.f3268;
        if (r03 != null) {
            r03.m3606(this, this.f3239, this.f3235);
        }
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1401
    /* renamed from: ῲ  reason: contains not printable characters */
    public SmartRefreshLayout m1836(int i) {
        postDelayed(new RunnableC1420(this), (long) i);
        return this;
    }

    /* renamed from: ⁱ  reason: contains not printable characters */
    public void m1839() {
        m1847(RefreshState.PullUpCanceled);
        m1829();
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1401
    /* renamed from: K  reason: contains not printable characters */
    public SmartRefreshLayout m1842(int i) {
        postDelayed(new RunnableC1425(this), (long) i);
        return this;
    }

    /* renamed from: 㳳  reason: contains not printable characters */
    public void m1850() {
        m1847(RefreshState.ReleaseToLoad);
    }

    /* renamed from: 㴹  reason: contains not printable characters */
    public void m1851() {
        m1847(RefreshState.PullDownToRefresh);
    }

    /* renamed from: 㸾  reason: contains not printable characters */
    public void m1852() {
        System.currentTimeMillis();
        m1847(RefreshState.Loading);
        m1830(-this.f3228);
        AbstractC1410 k = this.f3244;
        if (k != null) {
            C1432 r0 = (C1432) k;
            m3611((AbstractC1401) 3000);
        }
        AbstractC1400 r02 = this.f3249;
        if (r02 != null) {
            r02.m3606(this, this.f3228, this.f3240);
        }
    }

    /* renamed from: 㿎  reason: contains not printable characters */
    public void m1853() {
        m1847(RefreshState.PullToUpLoad);
    }

    public C0560 generateDefaultLayoutParams() {
        return new C0560(-1, -1);
    }

    @Override // android.view.ViewGroup
    public C0560 generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new C0560(layoutParams);
    }

    @Override // android.view.ViewGroup
    public C0560 generateLayoutParams(AttributeSet attributeSet) {
        return new C0560(getContext(), attributeSet);
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public static /* synthetic */ AbstractC1391 m1822(Context context) {
        return new BezierRadarHeader(context);
    }

    /* renamed from: K  reason: contains not printable characters */
    public static /* synthetic */ AbstractC1400 m1825(Context context) {
        return new BallPulseFooter(context);
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m1846(Context context, AttributeSet attributeSet) {
        setClipToPadding(false);
        this.f3266 = context.getResources().getDisplayMetrics().heightPixels;
        this.f3246 = new DecelerateInterpolator();
        this.f3226 = ViewConfiguration.get(getContext()).getScaledTouchSlop();
        this.f3274 = new C1751();
        this.f3261 = new C1775(this);
        C1729.m4463((View) this, true);
        float f = Resources.getSystem().getDisplayMetrics().density;
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, R$styleable.SmartRefreshLayout);
        this.f3248 = obtainStyledAttributes.getFloat(R$styleable.SmartRefreshLayout_srlDragRate, this.f3248);
        this.f3270 = obtainStyledAttributes.getFloat(R$styleable.SmartRefreshLayout_srlHeaderMaxDragRate, this.f3270);
        this.f3257 = obtainStyledAttributes.getFloat(R$styleable.SmartRefreshLayout_srlFooterMaxDragRate, this.f3257);
        this.f3273 = obtainStyledAttributes.getBoolean(R$styleable.SmartRefreshLayout_srlEnableRefresh, this.f3273);
        this.f3236 = obtainStyledAttributes.getInt(R$styleable.SmartRefreshLayout_srlReboundDuration, this.f3236);
        this.f3230 = obtainStyledAttributes.getBoolean(R$styleable.SmartRefreshLayout_srlEnableLoadmore, this.f3230);
        this.f3239 = obtainStyledAttributes.getDimensionPixelOffset(R$styleable.SmartRefreshLayout_srlHeaderHeight, (int) ((100.0f * f) + 0.5f));
        this.f3228 = obtainStyledAttributes.getDimensionPixelOffset(R$styleable.SmartRefreshLayout_srlFooterHeight, (int) ((60.0f * f) + 0.5f));
        this.f3259 = obtainStyledAttributes.getBoolean(R$styleable.SmartRefreshLayout_srlDisableContentWhenRefresh, this.f3259);
        this.f3232 = obtainStyledAttributes.getBoolean(R$styleable.SmartRefreshLayout_srlDisableContentWhenLoading, this.f3232);
        this.f3245 = obtainStyledAttributes.getBoolean(R$styleable.SmartRefreshLayout_srlEnableHeaderTranslationContent, this.f3245);
        this.f3260 = obtainStyledAttributes.getBoolean(R$styleable.SmartRefreshLayout_srlEnableFooterTranslationContent, this.f3260);
        this.f3233 = obtainStyledAttributes.getBoolean(R$styleable.SmartRefreshLayout_srlEnablePreviewInEditMode, this.f3233);
        this.f3272 = obtainStyledAttributes.getBoolean(R$styleable.SmartRefreshLayout_srlEnableAutoLoadmore, this.f3272);
        this.f3240 = (int) Math.max((this.f3270 - 1.0f) * ((float) this.f3228), 0.0f);
        this.f3235 = (int) Math.max((this.f3270 - 1.0f) * ((float) this.f3239), 0.0f);
        if (obtainStyledAttributes.hasValue(R$styleable.SmartRefreshLayout_srlHeaderHeight)) {
            this.f3243 = DimensionStatus.XmlLayoutUnNotify;
        }
        if (obtainStyledAttributes.hasValue(R$styleable.SmartRefreshLayout_srlFooterHeight)) {
            this.f3262 = DimensionStatus.XmlLayoutUnNotify;
        }
        int color = obtainStyledAttributes.getColor(R$styleable.SmartRefreshLayout_srlAccentColor, 0);
        int color2 = obtainStyledAttributes.getColor(R$styleable.SmartRefreshLayout_srlPrimaryColor, 0);
        if (color2 != 0) {
            if (color != 0) {
                this.f3256 = new int[]{color2, color};
            } else {
                this.f3256 = new int[]{color2};
            }
        }
        obtainStyledAttributes.recycle();
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public boolean m1838() {
        RefreshState refreshState = this.f3250;
        if (refreshState == RefreshState.PullDownToRefresh) {
            m1831();
            return true;
        } else if (refreshState == RefreshState.PullToUpLoad) {
            m1839();
            return true;
        } else if (refreshState == RefreshState.ReleaseToRefresh) {
            m1833();
            return true;
        } else if (refreshState != RefreshState.ReleaseToLoad) {
            return false;
        } else {
            m1852();
            return true;
        }
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1401
    /* renamed from: ῲ  reason: contains not printable characters */
    public SmartRefreshLayout m1837(boolean z) {
        this.f3273 = z;
        return this;
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public void m1830(int i) {
        if (this.f3269 != i) {
            ValueAnimator valueAnimator = this.f3258;
            if (valueAnimator != null) {
                valueAnimator.cancel();
            }
            this.f3258 = ValueAnimator.ofInt(this.f3269, i);
            this.f3258.setDuration((long) this.f3236);
            this.f3258.setInterpolator(this.f3246);
            this.f3258.addUpdateListener(this.f3241);
            this.f3258.addListener(this.f3227);
            this.f3258.start();
        }
    }

    public SmartRefreshLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.f3250 = RefreshState.None;
        this.f3236 = 300;
        this.f3248 = 0.5f;
        this.f3273 = true;
        this.f3230 = true;
        this.f3259 = false;
        this.f3232 = false;
        this.f3245 = true;
        this.f3260 = true;
        this.f3233 = true;
        this.f3272 = false;
        this.f3231 = false;
        this.f3265 = new int[2];
        this.f3242 = new int[2];
        DimensionStatus dimensionStatus = DimensionStatus.DefaultUnNotify;
        this.f3243 = dimensionStatus;
        this.f3262 = dimensionStatus;
        this.f3270 = 2.0f;
        this.f3257 = 2.0f;
        this.f3237 = 0;
        this.f3263 = 0;
        this.f3255 = null;
        this.f3227 = new C0561();
        this.f3241 = new C1423(this);
        m1846(context, attributeSet);
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m1847(RefreshState refreshState) {
        RefreshState refreshState2 = this.f3250;
        if (refreshState2 != refreshState) {
            this.f3250 = refreshState;
            AbstractC1400 r1 = this.f3249;
            if (r1 != null) {
                r1.m3615(this, refreshState2, refreshState);
            }
            AbstractC1391 r12 = this.f3268;
            if (r12 != null) {
                r12.m3615(this, refreshState2, refreshState);
            }
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m1844(float f) {
        if (f >= 0.0f) {
            float f2 = this.f3248;
            double max = (double) (((float) Math.max(this.f3266 / 2, getHeight())) * f2);
            double max2 = (double) Math.max(0.0f, f * f2);
            m1845((int) Math.min((1.0d - Math.pow(100.0d, (-max2) / max)) * ((double) (this.f3235 + this.f3239)), max2), false);
            return;
        }
        float f3 = this.f3248;
        double max3 = (double) (((float) Math.max(this.f3266 / 2, getHeight())) * f3);
        double d = (double) (-Math.min(0.0f, f * f3));
        m1845((int) (-Math.min((1.0d - Math.pow(100.0d, (-d) / max3)) * ((double) (this.f3240 + this.f3228)), d)), false);
    }

    public SmartRefreshLayout(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.f3250 = RefreshState.None;
        this.f3236 = 300;
        this.f3248 = 0.5f;
        this.f3273 = true;
        this.f3230 = true;
        this.f3259 = false;
        this.f3232 = false;
        this.f3245 = true;
        this.f3260 = true;
        this.f3233 = true;
        this.f3272 = false;
        this.f3231 = false;
        this.f3265 = new int[2];
        this.f3242 = new int[2];
        DimensionStatus dimensionStatus = DimensionStatus.DefaultUnNotify;
        this.f3243 = dimensionStatus;
        this.f3262 = dimensionStatus;
        this.f3270 = 2.0f;
        this.f3257 = 2.0f;
        this.f3237 = 0;
        this.f3263 = 0;
        this.f3255 = null;
        this.f3227 = new C0561();
        this.f3241 = new C1435(this);
        m1846(context, attributeSet);
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m1845(int i, boolean z) {
        AbstractC1400 r1;
        AbstractC1391 r12;
        RefreshState refreshState;
        int i2 = this.f3269;
        if (i2 != i) {
            this.f3269 = i;
            if (!(z || (refreshState = this.f3250) == RefreshState.Refreshing || refreshState == RefreshState.Loading)) {
                int i3 = this.f3269;
                if (i3 > this.f3239) {
                    m1832();
                } else if ((-i3) > this.f3228) {
                    m1850();
                } else if (i3 < 0) {
                    m1853();
                } else if (i3 > 0) {
                    m1851();
                }
            }
            if (this.f3229 != null) {
                if (i >= 0) {
                    if (this.f3245 || (r12 = this.f3268) == null || r12.getSpinnerStyle() == SpinnerStyle.FixedBehind) {
                        ((C1414) this.f3229).f5346.setTranslationY((float) i);
                        if (this.f3237 != 0) {
                            invalidate();
                        }
                    }
                } else if (this.f3260 || (r1 = this.f3249) == null || r1.getSpinnerStyle() == SpinnerStyle.FixedBehind) {
                    ((C1414) this.f3229).f5346.setTranslationY((float) i);
                    if (this.f3237 != 0) {
                        invalidate();
                    }
                }
            }
            if ((i >= 0 || i2 > 0) && this.f3268 != null) {
                i = Math.max(i, 0);
                if (this.f3273) {
                    if (this.f3268.getSpinnerStyle() == SpinnerStyle.Scale) {
                        requestLayout();
                    } else if (this.f3268.getSpinnerStyle() == SpinnerStyle.Translate) {
                        this.f3268.getView().setTranslationY((float) i);
                    }
                }
                if (z) {
                    AbstractC1391 r3 = this.f3268;
                    int i4 = this.f3239;
                    r3.m3600((((float) i) * 1.0f) / ((float) i4), i, i4, this.f3235);
                } else {
                    AbstractC1391 r32 = this.f3268;
                    int i5 = this.f3239;
                    r32.m3601((((float) i) * 1.0f) / ((float) i5), i, i5, this.f3235);
                }
            }
            if ((i <= 0 || i2 < 0) && this.f3249 != null) {
                int min = Math.min(i, 0);
                if (this.f3230) {
                    if (this.f3249.getSpinnerStyle() == SpinnerStyle.Scale) {
                        requestLayout();
                    } else if (this.f3249.getSpinnerStyle() == SpinnerStyle.Translate) {
                        this.f3249.getView().setTranslationY((float) min);
                    }
                }
                if (z) {
                    AbstractC1400 r9 = this.f3249;
                    int i6 = this.f3228;
                    r9.m3607((((float) min) * 1.0f) / ((float) i6), min, i6, this.f3240);
                    return;
                }
                AbstractC1400 r92 = this.f3249;
                int i7 = this.f3228;
                r92.m3608((((float) min) * 1.0f) / ((float) i7), min, i7, this.f3240);
            }
        }
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1401
    /* renamed from: K  reason: contains not printable characters */
    public SmartRefreshLayout m1843(boolean z) {
        this.f3230 = z;
        return this;
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1401
    /* renamed from: K  reason: contains not printable characters */
    public boolean m1849(int i, float f) {
        if (this.f3250 != RefreshState.None || !this.f3230 || this.f3231) {
            return false;
        }
        postDelayed(new RunnableC1424(this, f), (long) i);
        return true;
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1401
    /* renamed from: K  reason: contains not printable characters */
    public boolean m1848() {
        return this.f3230;
    }
}
