package com.scwang.smartrefresh.header;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.google.android.material.progressindicator.BaseProgressIndicator;
import com.scwang.smartrefresh.header.waveswipe.AnimationImageView;
import com.scwang.smartrefresh.header.waveswipe.WaveView;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1391;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1396;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1401;
import ඓ.㿎.K.ῲ.䀟.C1436;
import ඓ.㿎.K.K.C1456;
import ඓ.㿎.K.K.㳳.C1449;
import ῲ.ᨨ.ᨨ.C1729;

public class WaveSwipeHeader extends ViewGroup implements AbstractC1391 {

    /* renamed from: ʬ  reason: contains not printable characters */
    public C0552 f3121;

    /* renamed from: ῲ  reason: contains not printable characters */
    public WaveView f3122;

    /* renamed from: 㸾  reason: contains not printable characters */
    public float f3123;

    public enum VERTICAL_DRAG_THRESHOLD {
        FIRST(0.1f),
        SECOND(FIRST.val + 0.16f),
        THIRD(FIRST.val + 0.5f);
        
        public final float val;

        /* access modifiers changed from: public */
        VERTICAL_DRAG_THRESHOLD(float f) {
            this.val = f;
        }
    }

    /* renamed from: com.scwang.smartrefresh.header.WaveSwipeHeader$ʬ  reason: contains not printable characters */
    public class C0552 extends AnimationImageView {

        /* renamed from: ʬ  reason: contains not printable characters */
        public final C1449 f3125;

        public C0552(WaveSwipeHeader waveSwipeHeader, Context context) {
            super(context);
            this.f3125 = new C1449(context, waveSwipeHeader);
            this.f3125.f5416.f5433 = 0;
            DisplayMetrics displayMetrics = getContext().getResources().getDisplayMetrics();
            if (((float) displayMetrics.widthPixels) / displayMetrics.density >= 600.0f) {
                this.f3125.m3660(0);
            }
            setImageDrawable(this.f3125);
        }

        /* renamed from: ʬ  reason: contains not printable characters */
        public void m1763() {
            this.f3125.f5416.f5429 = BaseProgressIndicator.MAX_ALPHA;
        }

        /* renamed from: K  reason: contains not printable characters */
        public final int m1764(int i) {
            return View.MeasureSpec.makeMeasureSpec(i, 1073741824);
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m1765(float f) {
            C1729.m4461(this, f);
            setScaleY(f);
        }
    }

    /* renamed from: com.scwang.smartrefresh.header.WaveSwipeHeader$ῲ  reason: contains not printable characters */
    public class animation.Animation$AnimationListenerC0553 implements Animation.AnimationListener {
        public animation.Animation$AnimationListenerC0553() {
        }

        public void onAnimationEnd(Animation animation) {
            WaveSwipeHeader.this.f3121.f3125.stop();
            WaveSwipeHeader.this.f3121.m1763();
            WaveSwipeHeader.this.f3122.m1811();
        }

        public void onAnimationRepeat(Animation animation) {
        }

        public void onAnimationStart(Animation animation) {
        }
    }

    /* renamed from: com.scwang.smartrefresh.header.WaveSwipeHeader$K  reason: contains not printable characters */
    public class C0554 extends Animation {
        public C0554() {
        }

        public void applyTransformation(float f, Transformation transformation) {
            WaveSwipeHeader.this.f3121.m1765(1.0f - f);
        }
    }

    public WaveSwipeHeader(Context context) {
        this(context, null);
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    public SpinnerStyle getSpinnerStyle() {
        return SpinnerStyle.FixedFront;
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    public View getView() {
        return this;
    }

    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        this.f3122.layout(0, 0, getMeasuredWidth(), getMeasuredHeight());
        int measuredWidth = getMeasuredWidth();
        int measuredWidth2 = this.f3121.getMeasuredWidth();
        this.f3121.layout((measuredWidth - measuredWidth2) / 2, -this.f3121.getMeasuredHeight(), (measuredWidth + measuredWidth2) / 2, 0);
        if (isInEditMode()) {
            m1757(0.99f, C1436.m3649(99.0f), C1436.m3649(100.0f), C1436.m3649(100.0f));
        }
    }

    public void onMeasure(int i, int i2) {
        setMeasuredDimension(View.MeasureSpec.getSize(i), View.MeasureSpec.getSize(i2));
        C0552 r0 = this.f3121;
        int i3 = (int) r0.f3125.f5419;
        r0.measure(r0.m1764(i3), r0.m1764(i3));
        this.f3122.measure(View.MeasureSpec.makeMeasureSpec(View.MeasureSpec.getSize(i), 1073741824), View.MeasureSpec.makeMeasureSpec(View.MeasureSpec.getSize(i2), 1073741824));
    }

    public void setColorSchemeColors(int... iArr) {
        C1449 r0 = this.f3121.f3125;
        r0.f5416.m3667(iArr);
        r0.f5416.m3665(0);
    }

    public void setLayoutParams(ViewGroup.LayoutParams layoutParams) {
        super.setLayoutParams(layoutParams);
        layoutParams.height = -3;
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    public void setPrimaryColors(int... iArr) {
        if (iArr.length > 0) {
            this.f3122.setWaveColor(iArr[0]);
            if (iArr.length > 1) {
                C0552 r0 = this.f3121;
                int[] iArr2 = {iArr[1]};
                C1449 r5 = r0.f3125;
                r5.f5416.m3667(iArr2);
                r5.f5416.m3665(0);
            }
        }
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1391
    /* renamed from: ῲ  reason: contains not printable characters */
    public void m1756(float f, int i, int i2, int i3) {
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m1758(Context context, AttributeSet attributeSet) {
        WaveView waveView = new WaveView(context);
        this.f3122 = waveView;
        addView(waveView);
        C0552 r0 = new C0552(this, getContext());
        this.f3121 = r0;
        addView(r0);
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, R$styleable.WaveSwipeHeader);
        int color = obtainStyledAttributes.getColor(R$styleable.WaveSwipeHeader_wshPrimaryColor, 0);
        int color2 = obtainStyledAttributes.getColor(R$styleable.WaveSwipeHeader_wshAccentColor, 0);
        if (color != 0) {
            this.f3122.setWaveColor(color);
        }
        if (color2 != 0) {
            C1449 r5 = this.f3121.f3125;
            r5.f5416.m3667(new int[]{color2});
            r5.f5416.m3665(0);
        }
        if (obtainStyledAttributes.hasValue(R$styleable.WaveSwipeHeader_wshShadowRadius)) {
            this.f3122.m1819(obtainStyledAttributes.getDimensionPixelOffset(R$styleable.WaveSwipeHeader_wshShadowRadius, 0), obtainStyledAttributes.getColor(R$styleable.WaveSwipeHeader_wshShadowColor, -16777216));
        }
        obtainStyledAttributes.recycle();
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    /* renamed from: K  reason: contains not printable characters */
    public void m1759(AbstractC1396 r1, int i, int i2) {
    }

    public WaveSwipeHeader(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public WaveSwipeHeader(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        m1758(context, attributeSet);
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1391
    /* renamed from: K  reason: contains not printable characters */
    public void m1757(float f, int i, int i2, int i3) {
        float max = (((float) Math.max(((double) Math.min(1.0f, f)) - 0.4d, 0.0d)) * 5.0f) / 3.0f;
        float f2 = f > 3.0f ? 2.0f : f > 1.0f ? f - 1.0f : 0.0f;
        float f3 = ((4.0f - f2) * f2) / 8.0f;
        if (f < 1.0f) {
            C0552 r5 = this.f3121;
            float min = Math.min(0.8f, max * 0.8f);
            C1449 r1 = r5.f3125;
            C1449.C1450 r52 = r1.f5416;
            r52.f5432 = 0.0f;
            r52.m3663();
            C1449.C1450 r12 = r1.f5416;
            r12.f5445 = min;
            r12.m3663();
            C0552 r7 = this.f3121;
            float min2 = Math.min(1.0f, max);
            C1449.C1450 r72 = r7.f3125.f5416;
            if (min2 != r72.f5434) {
                r72.f5434 = min2;
                r72.m3663();
            }
        }
        C1449.C1450 r73 = this.f3121.f3125.f5416;
        r73.f5438 = ((f3 * 2.0f) + ((max * 0.4f) - 16.0f)) * 0.5f;
        r73.m3663();
        this.f3121.setTranslationY(this.f3122.getCurrentCircleCenterY());
        float min3 = (((float) i) * 1.0f) / ((float) Math.min(getMeasuredWidth(), getMeasuredHeight()));
        float f4 = ((5.0f - (2.0f * min3)) * min3) / 3.5f;
        float f5 = f4 - VERTICAL_DRAG_THRESHOLD.FIRST.val;
        float f6 = (f4 - VERTICAL_DRAG_THRESHOLD.SECOND.val) / 5.0f;
        this.f3123 = f4;
        if (f4 < VERTICAL_DRAG_THRESHOLD.FIRST.val) {
            this.f3122.m1815(f4);
        } else if (f4 < VERTICAL_DRAG_THRESHOLD.SECOND.val) {
            this.f3122.m1816(f4, f5);
        } else {
            this.f3122.m1817(f4, f5, f6);
        }
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    /* renamed from: K  reason: contains not printable characters */
    public void m1761(AbstractC1401 r1, int i, int i2) {
        this.f3123 = 0.0f;
        this.f3122.m1814();
        this.f3121.m1763();
        this.f3121.f3125.start();
        ValueAnimator ofFloat = ValueAnimator.ofFloat(0.0f, 0.0f);
        ofFloat.setDuration(500L);
        ofFloat.setInterpolator(new AccelerateDecelerateInterpolator());
        ofFloat.addUpdateListener(new C1456(this));
        ofFloat.start();
    }

    @Override // ඓ.㿎.K.ῲ.ݜ.AbstractC1408
    /* renamed from: K  reason: contains not printable characters */
    public void m1762(AbstractC1401 r1, RefreshState refreshState, RefreshState refreshState2) {
        int ordinal = refreshState2.ordinal();
        if (ordinal == 0) {
            return;
        }
        if (ordinal == 1) {
            C1449.C1450 r12 = this.f3121.f3125.f5416;
            if (!r12.f5441) {
                r12.f5441 = true;
                r12.m3663();
            }
            this.f3121.m1765(1.0f);
            this.f3121.m1763();
        } else if (ordinal == 3) {
            C1449 r13 = this.f3121.f3125;
            C1449.C1450 r3 = r13.f5416;
            r3.f5432 = 0.0f;
            r3.m3663();
            C1449.C1450 r14 = r13.f5416;
            r14.f5445 = 0.0f;
            r14.m3663();
            this.f3122.m1813(this.f3123);
            this.f3123 = 0.0f;
        }
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    /* renamed from: K  reason: contains not printable characters */
    public void m1760(AbstractC1401 r3) {
        C0554 k = new C0554();
        k.setDuration(200);
        this.f3121.setAnimationListener(new animation.Animation$AnimationListenerC0553());
        this.f3121.clearAnimation();
        this.f3121.startAnimation(k);
    }
}
