package com.scwang.smartrefresh.header;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.google.android.material.progressindicator.BaseProgressIndicator;
import com.scwang.smartrefresh.header.waterdrop.WaterDropView;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1391;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1396;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1401;
import ඓ.㿎.K.ῲ.㗽.C1430;
import ඓ.㿎.K.K.㳳.C1449;

public class WaterDropHeader extends ViewGroup implements AbstractC1391 {

    /* renamed from: ʬ  reason: contains not printable characters */
    public ImageView f3112;

    /* renamed from: ඓ  reason: contains not printable characters */
    public C1430 f3113;

    /* renamed from: ῲ  reason: contains not printable characters */
    public RefreshState f3114;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public int f3115 = 0;

    /* renamed from: 㴹  reason: contains not printable characters */
    public C1449 f3116;

    /* renamed from: 㸾  reason: contains not printable characters */
    public WaterDropView f3117;

    /* renamed from: com.scwang.smartrefresh.header.WaterDropHeader$ῲ  reason: contains not printable characters */
    public class RunnableC0549 implements Runnable {
        public RunnableC0549() {
        }

        public void run() {
            WaterDropHeader waterDropHeader = WaterDropHeader.this;
            waterDropHeader.f3115 = (waterDropHeader.f3115 + 30) % 360;
            waterDropHeader.invalidate();
            WaterDropHeader waterDropHeader2 = WaterDropHeader.this;
            if (waterDropHeader2.f3114 == RefreshState.Refreshing) {
                waterDropHeader2.postDelayed(this, 100);
            }
        }
    }

    /* renamed from: com.scwang.smartrefresh.header.WaterDropHeader$K  reason: contains not printable characters */
    public class C0550 extends AnimatorListenerAdapter {

        /* renamed from: com.scwang.smartrefresh.header.WaterDropHeader$K$K  reason: contains not printable characters */
        public class C0551 extends AnimatorListenerAdapter {
            public C0551() {
            }

            public void onAnimationEnd(Animator animator) {
                WaterDropHeader.this.f3117.setVisibility(8);
                WaterDropHeader.this.f3117.setAlpha(1.0f);
            }
        }

        public C0550() {
        }

        public void onAnimationEnd(Animator animator) {
            WaterDropHeader.this.f3117.animate().alpha(0.0f).setListener(new C0551());
        }
    }

    public WaterDropHeader(Context context) {
        super(context);
        m1751(context);
    }

    public void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.f3114 == RefreshState.Refreshing) {
            canvas.save();
            canvas.translate((float) ((getWidth() / 2) - (this.f3113.getBounds().width() / 2)), (float) ((getHeight() / 2) - (this.f3113.getBounds().height() / 2)));
            canvas.rotate((float) this.f3115, (float) (this.f3113.getBounds().width() / 2), (float) (this.f3113.getBounds().height() / 2));
            this.f3113.draw(canvas);
            canvas.restore();
        }
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    public SpinnerStyle getSpinnerStyle() {
        return SpinnerStyle.Scale;
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    public View getView() {
        return this;
    }

    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        int measuredWidth = getMeasuredWidth();
        int measuredWidth2 = this.f3117.getMeasuredWidth();
        int i5 = measuredWidth / 2;
        int i6 = measuredWidth2 / 2;
        int i7 = i5 - i6;
        this.f3117.layout(i7, 0, i7 + measuredWidth2, this.f3117.getMeasuredHeight() + 0);
        int measuredWidth3 = this.f3112.getMeasuredWidth();
        int measuredHeight = this.f3112.getMeasuredHeight();
        int i8 = measuredWidth3 / 2;
        int i9 = i5 - i8;
        int i10 = i6 - i8;
        int i11 = (measuredWidth2 - measuredWidth3) / 2;
        if (i10 + measuredHeight > this.f3117.getBottom() - i11) {
            i10 = (this.f3117.getBottom() - i11) - measuredHeight;
        }
        this.f3112.layout(i9, i10, measuredWidth3 + i9, measuredHeight + i10);
    }

    public void onMeasure(int i, int i2) {
        super.onMeasure(i, i2);
        ViewGroup.LayoutParams layoutParams = this.f3112.getLayoutParams();
        this.f3112.measure(View.MeasureSpec.makeMeasureSpec(layoutParams.width, 1073741824), View.MeasureSpec.makeMeasureSpec(layoutParams.height, 1073741824));
        this.f3117.measure(View.MeasureSpec.makeMeasureSpec(View.MeasureSpec.getSize(i), Integer.MIN_VALUE), i2);
        setMeasuredDimension(ViewGroup.resolveSize(Math.max(this.f3112.getMeasuredWidth(), this.f3117.getMeasuredHeight()), i), ViewGroup.resolveSize(Math.max(this.f3112.getMeasuredHeight(), this.f3117.getMeasuredHeight()), i2));
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    public void setPrimaryColors(int... iArr) {
        if (iArr.length > 0) {
            this.f3117.setIndicatorColor(iArr[0]);
        }
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1391
    /* renamed from: ῲ  reason: contains not printable characters */
    public void m1749(float f, int i, int i2, int i3) {
        if (this.f3114 != RefreshState.Refreshing) {
            WaterDropView waterDropView = this.f3117;
            Math.max(i, 0);
            waterDropView.m1803();
            this.f3117.postInvalidate();
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m1751(Context context) {
        float f = Resources.getSystem().getDisplayMetrics().density;
        this.f3117 = new WaterDropView(context);
        addView(this.f3117, -1, -1);
        this.f3117.m1807(0);
        this.f3113 = new C1430();
        this.f3113.setBounds(0, 0, (int) ((20.0f * f) + 0.5f), (int) ((20.0f * f) + 0.5f));
        this.f3112 = new ImageView(context);
        this.f3116 = new C1449(context, this.f3112);
        C1449 r8 = this.f3116;
        C1449.C1450 r1 = r8.f5416;
        r1.f5433 = -1;
        r1.f5429 = BaseProgressIndicator.MAX_ALPHA;
        r1.m3667(new int[]{-1, -16737844, -48060, -10053376, -5609780, -30720});
        r8.f5416.m3665(0);
        this.f3112.setImageDrawable(this.f3116);
        addView(this.f3112, (int) ((30.0f * f) + 0.5f), (int) ((30.0f * f) + 0.5f));
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    /* renamed from: K  reason: contains not printable characters */
    public void m1752(AbstractC1396 r1, int i, int i2) {
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    /* renamed from: K  reason: contains not printable characters */
    public void m1753(AbstractC1401 r1) {
    }

    public WaterDropHeader(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        m1751(context);
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1391
    /* renamed from: K  reason: contains not printable characters */
    public void m1750(float f, int i, int i2, int i3) {
        this.f3117.m1803();
        this.f3117.postInvalidate();
        float f2 = (float) i2;
        float max = (((float) Math.max(((double) Math.min(1.0f, Math.abs((((float) i) * 1.0f) / f2))) - 0.4d, 0.0d)) * 5.0f) / 3.0f;
        double max2 = (double) (Math.max(0.0f, Math.min((float) (Math.abs(i) - i2), f2 * 2.0f) / f2) / 4.0f);
        float pow = ((float) (max2 - Math.pow(max2, 2.0d))) * 2.0f * 2.0f;
        this.f3116.m3661(true);
        this.f3116.m3658(0.0f, Math.min(0.8f, max * 0.8f));
        this.f3116.m3657(Math.min(1.0f, max));
        this.f3116.m3655((pow + ((0.4f * max) - 16.0f)) * 0.5f);
    }

    @Override // ඓ.㿎.K.ῲ.ݜ.AbstractC1408
    /* renamed from: K  reason: contains not printable characters */
    public void m1755(AbstractC1401 r1, RefreshState refreshState, RefreshState refreshState2) {
        this.f3114 = refreshState2;
        int ordinal = refreshState2.ordinal();
        if (ordinal == 0) {
            this.f3117.setVisibility(0);
        } else if (ordinal == 1) {
            this.f3117.setVisibility(0);
        } else if (ordinal == 3) {
        } else {
            if (ordinal == 5) {
                this.f3117.setVisibility(0);
            } else if (ordinal != 7 && ordinal == 9) {
                this.f3117.setVisibility(8);
            }
        }
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    /* renamed from: K  reason: contains not printable characters */
    public void m1754(AbstractC1401 r1, int i, int i2) {
        Animator r12 = this.f3117.m1805();
        r12.addListener(new C0550());
        r12.start();
        postDelayed(new RunnableC0549(), 100);
    }
}
