package com.scwang.smartrefresh.header;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Transformation;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import java.util.ArrayList;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1391;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1396;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1401;
import ඓ.㿎.K.ῲ.䀟.C1436;
import ඓ.㿎.K.K.ᕣ.C1440;
import ඓ.㿎.K.K.ᕣ.C1441;

public class StoreHouseHeader extends View implements AbstractC1391 {

    /* renamed from: ʬ  reason: contains not printable characters */
    public int f3066 = -1;

    /* renamed from: Ԕ  reason: contains not printable characters */
    public Transformation f3067 = new Transformation();

    /* renamed from: Ԛ  reason: contains not printable characters */
    public Runnable f3068;

    /* renamed from: ؿ  reason: contains not printable characters */
    public RunnableC0547 f3069 = new RunnableC0547(null);

    /* renamed from: ݜ  reason: contains not printable characters */
    public Matrix f3070 = new Matrix();

    /* renamed from: ඓ  reason: contains not printable characters */
    public int f3071 = -1;

    /* renamed from: ᓣ  reason: contains not printable characters */
    public int f3072 = -1;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public int f3073 = 0;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public int f3074 = 0;

    /* renamed from: ῲ  reason: contains not printable characters */
    public ArrayList<C1441> f3075 = new ArrayList<>();

    /* renamed from: ⁱ  reason: contains not printable characters */
    public float f3076 = 0.0f;

    /* renamed from: 㑃  reason: contains not printable characters */
    public int f3077 = 1000;

    /* renamed from: 㗗  reason: contains not printable characters */
    public boolean f3078 = false;

    /* renamed from: 㗽  reason: contains not printable characters */
    public int f3079 = 0;

    /* renamed from: 㳳  reason: contains not printable characters */
    public int f3080 = 0;

    /* renamed from: 㴹  reason: contains not printable characters */
    public int f3081 = -1;

    /* renamed from: 㸾  reason: contains not printable characters */
    public float f3082 = 1.0f;

    /* renamed from: 㿎  reason: contains not printable characters */
    public int f3083 = 0;

    /* renamed from: 䀟  reason: contains not printable characters */
    public AbstractC1396 f3084;

    /* renamed from: 䁗  reason: contains not printable characters */
    public int f3085 = 1000;

    /* renamed from: com.scwang.smartrefresh.header.StoreHouseHeader$ῲ  reason: contains not printable characters */
    public class RunnableC0547 implements Runnable {

        /* renamed from: ʬ  reason: contains not printable characters */
        public int f3086 = 0;

        /* renamed from: ඓ  reason: contains not printable characters */
        public int f3087 = 0;

        /* renamed from: ῲ  reason: contains not printable characters */
        public int f3088 = 0;

        /* renamed from: 㴹  reason: contains not printable characters */
        public boolean f3090 = true;

        /* renamed from: 㸾  reason: contains not printable characters */
        public int f3091 = 0;

        public /* synthetic */ RunnableC0547(C0548 k) {
        }

        public void run() {
            int i = this.f3088 % this.f3086;
            for (int i2 = 0; i2 < this.f3091; i2++) {
                int i3 = (this.f3086 * i2) + i;
                if (i3 <= this.f3088) {
                    C1441 k = StoreHouseHeader.this.f3075.get(i3 % StoreHouseHeader.this.f3075.size());
                    k.setFillAfter(false);
                    k.setFillEnabled(true);
                    k.setFillBefore(false);
                    k.setDuration(400);
                    k.m3653(1.0f, 0.4f);
                }
            }
            this.f3088++;
            if (this.f3090) {
                StoreHouseHeader.this.postDelayed(this, (long) this.f3087);
            }
        }
    }

    public StoreHouseHeader(Context context) {
        super(context);
        m1732(context, (AttributeSet) null);
    }

    private int getBottomOffset() {
        return C1436.m3649(10.0f) + getPaddingBottom();
    }

    private int getTopOffset() {
        return C1436.m3649(10.0f) + getPaddingTop();
    }

    private void setProgress(float f) {
        this.f3076 = f;
    }

    public int getLoadingAniDuration() {
        return this.f3077;
    }

    public float getScale() {
        return this.f3082;
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    public SpinnerStyle getSpinnerStyle() {
        return SpinnerStyle.Translate;
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    public View getView() {
        return this;
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.f3084 = null;
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float f = this.f3076;
        int save = canvas.save();
        int size = this.f3075.size();
        if (isInEditMode()) {
            f = 1.0f;
        }
        for (int i = 0; i < size; i++) {
            canvas.save();
            C1441 k = this.f3075.get(i);
            PointF pointF = k.f5399;
            float f2 = ((float) this.f3080) + pointF.x;
            float f3 = ((float) this.f3073) + pointF.y;
            if (this.f3078) {
                k.getTransformation(getDrawingTime(), this.f3067);
                canvas.translate(f2, f3);
            } else {
                float f4 = 0.0f;
                if (f == 0.0f) {
                    k.m3654(this.f3081);
                } else {
                    float f5 = (((float) i) * 0.3f) / ((float) size);
                    float f6 = 0.3f - f5;
                    if (f == 1.0f || f >= 1.0f - f6) {
                        canvas.translate(f2, f3);
                        k.m3652(0.4f);
                    } else {
                        if (f > f5) {
                            f4 = Math.min(1.0f, (f - f5) / 0.7f);
                        }
                        float f7 = 1.0f - f4;
                        float f8 = (k.f5397 * f7) + f2;
                        float f9 = (((float) (-this.f3071)) * f7) + f3;
                        this.f3070.reset();
                        this.f3070.postRotate(360.0f * f4);
                        this.f3070.postScale(f4, f4);
                        this.f3070.postTranslate(f8, f9);
                        k.m3652(f4 * 0.4f);
                        canvas.concat(this.f3070);
                    }
                }
            }
            PointF pointF2 = k.f5400;
            float f10 = pointF2.x;
            float f11 = pointF2.y;
            PointF pointF3 = k.f5403;
            canvas.drawLine(f10, f11, pointF3.x, pointF3.y, k.f5402);
            canvas.restore();
        }
        if (this.f3078) {
            invalidate();
        }
        canvas.restoreToCount(save);
    }

    public void onMeasure(int i, int i2) {
        super.onMeasure(i, View.MeasureSpec.makeMeasureSpec(getTopOffset() + this.f3074 + getBottomOffset(), 1073741824));
        this.f3080 = (getMeasuredWidth() - this.f3083) / 2;
        this.f3073 = getTopOffset();
        this.f3071 = getTopOffset();
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    public void setPrimaryColors(int... iArr) {
        if (iArr.length > 0) {
            this.f3079 = iArr[0];
            AbstractC1396 r1 = this.f3084;
            if (r1 != null) {
                int i = iArr[0];
                SmartRefreshLayout.C0559 r12 = (SmartRefreshLayout.C0559) r1;
                SmartRefreshLayout smartRefreshLayout = SmartRefreshLayout.this;
                if (smartRefreshLayout.f3234 == null && i != 0) {
                    smartRefreshLayout.f3234 = new Paint();
                }
                SmartRefreshLayout.this.f3263 = i;
            }
            if (iArr.length > 1) {
                m1726(iArr[1]);
            }
        }
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1391
    /* renamed from: ῲ  reason: contains not printable characters */
    public void m1725(float f, int i, int i2, int i3) {
        setProgress(f * 0.8f);
        invalidate();
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m1730() {
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m1732(Context context, AttributeSet attributeSet) {
        float f = Resources.getSystem().getDisplayMetrics().density;
        this.f3066 = (int) ((1.0f * f) + 0.5f);
        this.f3071 = (int) ((40.0f * f) + 0.5f);
        this.f3081 = Resources.getSystem().getDisplayMetrics().widthPixels / 2;
        this.f3079 = -13421773;
        m1726(-3355444);
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, R$styleable.StoreHouseHeader);
        this.f3066 = obtainStyledAttributes.getDimensionPixelOffset(R$styleable.StoreHouseHeader_shhLineWidth, this.f3066);
        if (obtainStyledAttributes.hasValue(R$styleable.StoreHouseHeader_shhText)) {
            m1727(obtainStyledAttributes.getString(R$styleable.StoreHouseHeader_shhText));
        } else {
            m1727("StoreHouse");
        }
        obtainStyledAttributes.recycle();
    }

    /* renamed from: K  reason: contains not printable characters */
    public StoreHouseHeader m1726(int i) {
        this.f3072 = i;
        for (int i2 = 0; i2 < this.f3075.size(); i2++) {
            this.f3075.get(i2).f5402.setColor(i);
        }
        return this;
    }

    /* renamed from: K  reason: contains not printable characters */
    public StoreHouseHeader m1727(String str) {
        m1728(str, 25);
        return this;
    }

    /* renamed from: K  reason: contains not printable characters */
    public StoreHouseHeader m1728(String str, int i) {
        m1729(C1440.m3650(str, ((float) i) * 0.01f, 14));
        return this;
    }

    /* renamed from: K  reason: contains not printable characters */
    public StoreHouseHeader m1729(ArrayList<float[]> arrayList) {
        boolean z = this.f3075.size() > 0;
        this.f3075.clear();
        float f = Resources.getSystem().getDisplayMetrics().density;
        int i = 0;
        float f2 = 0.0f;
        float f3 = 0.0f;
        while (i < arrayList.size()) {
            float[] fArr = arrayList.get(i);
            PointF pointF = new PointF(((float) ((int) ((fArr[0] * f) + 0.5f))) * this.f3082, ((float) ((int) ((fArr[1] * f) + 0.5f))) * this.f3082);
            PointF pointF2 = new PointF(((float) ((int) ((fArr[2] * f) + 0.5f))) * this.f3082, ((float) ((int) ((fArr[3] * f) + 0.5f))) * this.f3082);
            float max = Math.max(Math.max(f2, pointF.x), pointF2.x);
            float max2 = Math.max(Math.max(f3, pointF.y), pointF2.y);
            C1441 k = new C1441(i, pointF, pointF2, this.f3072, this.f3066);
            k.m3654(this.f3081);
            this.f3075.add(k);
            i++;
            f2 = max;
            f3 = max2;
        }
        this.f3083 = (int) Math.ceil((double) f2);
        this.f3074 = (int) Math.ceil((double) f3);
        if (z) {
            requestLayout();
        }
        return this;
    }

    public StoreHouseHeader(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        m1732(context, attributeSet);
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    /* renamed from: K  reason: contains not printable characters */
    public void m1735(AbstractC1401 r3, int i, int i2) {
        this.f3078 = true;
        RunnableC0547 r4 = this.f3069;
        r4.f3090 = true;
        r4.f3088 = 0;
        StoreHouseHeader storeHouseHeader = StoreHouseHeader.this;
        r4.f3087 = storeHouseHeader.f3077 / storeHouseHeader.f3075.size();
        StoreHouseHeader storeHouseHeader2 = StoreHouseHeader.this;
        r4.f3086 = storeHouseHeader2.f3085 / r4.f3087;
        r4.f3091 = (storeHouseHeader2.f3075.size() / r4.f3086) + 1;
        r4.run();
        invalidate();
    }

    public StoreHouseHeader(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        m1732(context, attributeSet);
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    /* renamed from: K  reason: contains not printable characters */
    public void m1734(AbstractC1401 r3) {
        this.f3078 = false;
        RunnableC0547 r0 = this.f3069;
        r0.f3090 = false;
        StoreHouseHeader.this.removeCallbacks(r0);
        for (int i = 0; i < this.f3075.size(); i++) {
            this.f3075.get(i).m3654(this.f3081);
        }
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    /* renamed from: K  reason: contains not printable characters */
    public void m1733(AbstractC1396 r3, int i, int i2) {
        int i3 = this.f3079;
        if (i3 != 0) {
            SmartRefreshLayout.C0559 r5 = (SmartRefreshLayout.C0559) r3;
            SmartRefreshLayout smartRefreshLayout = SmartRefreshLayout.this;
            if (smartRefreshLayout.f3234 == null && i3 != 0) {
                smartRefreshLayout.f3234 = new Paint();
            }
            SmartRefreshLayout.this.f3237 = i3;
        }
        this.f3084 = r3;
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1391
    /* renamed from: K  reason: contains not printable characters */
    public void m1731(float f, int i, int i2, int i3) {
        setProgress(f * 0.8f);
        invalidate();
    }

    @Override // ඓ.㿎.K.ῲ.ݜ.AbstractC1408
    /* renamed from: K  reason: contains not printable characters */
    public void m1736(AbstractC1401 r1, RefreshState refreshState, RefreshState refreshState2) {
        Runnable runnable;
        if (refreshState2 == RefreshState.ReleaseToRefresh) {
            m1730();
        } else if (refreshState2 == RefreshState.None && (runnable = this.f3068) != null) {
            runnable.run();
            this.f3068 = null;
        }
    }
}
