package com.scwang.smartrefresh.header;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import com.google.android.material.bottomappbar.BottomAppBarTopEdgeTreatment;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import ඓ.K.K.K.C1293;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1391;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1393;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1396;
import ඓ.㿎.K.ῲ.Ԕ.AbstractC1401;
import ඓ.㿎.K.ῲ.ᓣ.AbstractC1418;
import ඓ.㿎.K.ῲ.䀟.C1436;
import ඓ.㿎.K.K.C1444;

public class CircleRefreshHeader extends View implements AbstractC1391 {

    /* renamed from: ʬ  reason: contains not printable characters */
    public int f2934;

    /* renamed from: Ԕ  reason: contains not printable characters */
    public long f2935;

    /* renamed from: Ԛ  reason: contains not printable characters */
    public boolean f2936;

    /* renamed from: ؿ  reason: contains not printable characters */
    public int f2937;

    /* renamed from: ݜ  reason: contains not printable characters */
    public int f2938;

    /* renamed from: ඓ  reason: contains not printable characters */
    public AbstractC0539 f2939;

    /* renamed from: ᑓ  reason: contains not printable characters */
    public long f2940;

    /* renamed from: ᓆ  reason: contains not printable characters */
    public long f2941;

    /* renamed from: ᓣ  reason: contains not printable characters */
    public int f2942;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public int f2943;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public Paint f2944;

    /* renamed from: ῲ  reason: contains not printable characters */
    public int f2945;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public Paint f2946;

    /* renamed from: ゎ  reason: contains not printable characters */
    public long f2947;

    /* renamed from: ト  reason: contains not printable characters */
    public long f2948;

    /* renamed from: 㑃  reason: contains not printable characters */
    public int f2949;

    /* renamed from: 㗗  reason: contains not printable characters */
    public long f2950;

    /* renamed from: 㗽  reason: contains not printable characters */
    public int f2951;

    /* renamed from: 㮔  reason: contains not printable characters */
    public long f2952;

    /* renamed from: 㳳  reason: contains not printable characters */
    public Path f2953;

    /* renamed from: 㴪  reason: contains not printable characters */
    public long f2954;

    /* renamed from: 㴹  reason: contains not printable characters */
    public AnimatorStatus f2955;

    /* renamed from: 㶋  reason: contains not printable characters */
    public long f2956;

    /* renamed from: 㸾  reason: contains not printable characters */
    public float f2957;

    /* renamed from: 㿎  reason: contains not printable characters */
    public Paint f2958;

    /* renamed from: 䀟  reason: contains not printable characters */
    public boolean f2959;

    /* renamed from: 䁗  reason: contains not printable characters */
    public int f2960;

    /* renamed from: 䃖  reason: contains not printable characters */
    public long f2961;

    public enum AnimatorStatus {
        PULL_DOWN,
        DRAG_DOWN,
        REL_DRAG,
        SPRING_UP,
        POP_BALL,
        OUTER_CIR,
        REFRESHING,
        DONE,
        STOP
    }

    /* renamed from: com.scwang.smartrefresh.header.CircleRefreshHeader$ῲ  reason: contains not printable characters */
    public interface AbstractC0539 {
    }

    /* renamed from: com.scwang.smartrefresh.header.CircleRefreshHeader$K  reason: contains not printable characters */
    public class C0540 extends AbstractC1418 {
        public C0540() {
        }

        @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1392
        /* renamed from: K  reason: contains not printable characters */
        public void m1678(AbstractC1393.AbstractC1394 k, AbstractC1401 r3) {
            CircleRefreshHeader.this.setRefreshing(false);
            CircleRefreshHeader circleRefreshHeader = CircleRefreshHeader.this;
            k.getClass();
            circleRefreshHeader.setOnViewAniDone(new C1444(k));
        }
    }

    public CircleRefreshHeader(Context context) {
        this(context, null, 0);
    }

    private float getDoneRatio() {
        if (System.currentTimeMillis() < this.f2961) {
            return Math.min(((float) (System.currentTimeMillis() - this.f2952)) / 1000.0f, 1.0f);
        }
        this.f2955 = AnimatorStatus.STOP;
        AbstractC0539 r0 = this.f2939;
        if (r0 != null) {
            ((C1444) r0).f5406.m3603(new Object[0]);
        }
        return 1.0f;
    }

    private float getOutRatio() {
        if (System.currentTimeMillis() < this.f2948) {
            return Math.min(((float) (System.currentTimeMillis() - this.f2947)) / 200.0f, 1.0f);
        }
        this.f2955 = AnimatorStatus.REFRESHING;
        this.f2936 = true;
        return 1.0f;
    }

    private float getPopRatio() {
        if (System.currentTimeMillis() < this.f2940) {
            return Math.min(((float) (System.currentTimeMillis() - this.f2954)) / 300.0f, 1.0f);
        }
        this.f2947 = System.currentTimeMillis();
        this.f2948 = this.f2947 + 200;
        this.f2955 = AnimatorStatus.OUTER_CIR;
        this.f2942 = 90;
        this.f2951 = 90;
        this.f2938 = BottomAppBarTopEdgeTreatment.ANGLE_UP;
        this.f2959 = true;
        this.f2936 = true;
        invalidate();
        return 1.0f;
    }

    private int getRelHeight() {
        return (int) ((1.0f - getRelRatio()) * ((float) this.f2937));
    }

    private float getRelRatio() {
        if (System.currentTimeMillis() < this.f2950) {
            return Math.min(((float) (System.currentTimeMillis() - this.f2935)) / 2000.0f, 1.0f);
        }
        m1667();
        return 1.0f;
    }

    private float getSprRatio() {
        if (System.currentTimeMillis() < this.f2941) {
            return Math.min(1.0f, ((float) (System.currentTimeMillis() - this.f2956)) / 200.0f);
        }
        this.f2954 = System.currentTimeMillis();
        this.f2940 = this.f2954 + 300;
        this.f2955 = AnimatorStatus.POP_BALL;
        invalidate();
        return 1.0f;
    }

    private int getSpringDelta() {
        return (int) (((float) this.f2934) * getSprRatio());
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    public SpinnerStyle getSpinnerStyle() {
        return SpinnerStyle.Scale;
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    public View getView() {
        return this;
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        switch (this.f2955.ordinal()) {
            case 0:
                canvas.drawRect(0.0f, 0.0f, (float) this.f2949, (float) this.f2960, this.f2946);
                break;
            case 1:
            case 2:
                canvas.drawRect(0.0f, 0.0f, (float) this.f2949, (float) this.f2945, this.f2946);
                this.f2953.reset();
                this.f2953.moveTo(0.0f, (float) this.f2945);
                Path path = this.f2953;
                float f = this.f2957;
                float f2 = (float) this.f2949;
                int i = this.f2945;
                path.quadTo(f * f2, (float) (((this.f2960 - i) * 2) + i), f2, (float) i);
                canvas.drawPath(this.f2953, this.f2946);
                break;
            case 3:
                int springDelta = getSpringDelta();
                this.f2953.reset();
                this.f2953.moveTo(0.0f, 0.0f);
                this.f2953.lineTo(0.0f, (float) this.f2945);
                Path path2 = this.f2953;
                int i2 = this.f2949;
                int i3 = this.f2945;
                path2.quadTo((float) (i2 / 2), (float) (i3 - springDelta), (float) i2, (float) i3);
                this.f2953.lineTo((float) this.f2949, 0.0f);
                canvas.drawPath(this.f2953, this.f2946);
                int i4 = this.f2945;
                int i5 = i4 - (springDelta / 2);
                if (i5 > i4 - (this.f2934 / 2)) {
                    int sprRatio = (int) ((getSprRatio() * ((float) this.f2943)) + ((float) ((this.f2949 / 2) - (this.f2943 * 2))));
                    this.f2953.reset();
                    float f3 = (float) i5;
                    this.f2953.moveTo((float) sprRatio, f3);
                    this.f2953.quadTo((float) (this.f2949 / 2), f3 - ((((float) this.f2943) * getSprRatio()) * 2.0f), (float) (this.f2949 - sprRatio), f3);
                    canvas.drawPath(this.f2953, this.f2958);
                } else {
                    int i6 = this.f2949 / 2;
                    int i7 = this.f2943;
                    canvas.drawArc(new RectF((float) (i6 - i7), (float) (i5 - i7), (float) (i6 + i7), (float) (i5 + i7)), 180.0f, 180.0f, true, this.f2958);
                }
                invalidate();
                break;
            case 4:
                this.f2953.reset();
                this.f2953.moveTo(0.0f, 0.0f);
                this.f2953.lineTo(0.0f, (float) this.f2945);
                Path path3 = this.f2953;
                int i8 = this.f2949;
                int i9 = this.f2945;
                path3.quadTo((float) (i8 / 2), (float) (i9 - this.f2934), (float) i8, (float) i9);
                this.f2953.lineTo((float) this.f2949, 0.0f);
                canvas.drawPath(this.f2953, this.f2946);
                int i10 = this.f2945 - (this.f2934 / 2);
                int popRatio = (int) (((float) i10) - (((float) (this.f2943 * 2)) * getPopRatio()));
                int i11 = this.f2949 / 2;
                int i12 = this.f2943;
                canvas.drawArc(new RectF((float) (i11 - i12), (float) (popRatio - i12), (float) (i11 + i12), (float) (i12 + popRatio)), 180.0f, 360.0f, true, this.f2958);
                if (getPopRatio() < 1.0f) {
                    m1673(canvas, popRatio, i10 + 1, getPopRatio());
                } else {
                    canvas.drawCircle((float) (this.f2949 / 2), (float) popRatio, (float) this.f2943, this.f2958);
                }
                invalidate();
                break;
            case 5:
                this.f2953.reset();
                this.f2953.moveTo(0.0f, 0.0f);
                this.f2953.lineTo(0.0f, (float) this.f2945);
                this.f2953.quadTo((float) (this.f2949 / 2), ((float) this.f2945) - ((1.0f - getOutRatio()) * ((float) this.f2934)), (float) this.f2949, (float) this.f2945);
                this.f2953.lineTo((float) this.f2949, 0.0f);
                canvas.drawPath(this.f2953, this.f2946);
                int i13 = this.f2945 - (this.f2934 / 2);
                int i14 = this.f2943;
                canvas.drawCircle((float) (this.f2949 / 2), (float) (i13 - (i14 * 2)), (float) i14, this.f2958);
                invalidate();
                break;
            case 6:
                canvas.drawRect(0.0f, 0.0f, (float) this.f2949, (float) this.f2960, this.f2946);
                int i15 = this.f2945 - (this.f2934 / 2);
                int i16 = this.f2943;
                int i17 = i15 - (i16 * 2);
                canvas.drawCircle((float) (this.f2949 / 2), (float) i17, (float) i16, this.f2958);
                int i18 = this.f2943 + 10;
                int i19 = 3;
                this.f2942 += this.f2959 ? 3 : 10;
                int i20 = this.f2951;
                if (this.f2959) {
                    i19 = 10;
                }
                this.f2951 = i20 + i19;
                this.f2942 %= 360;
                this.f2951 %= 360;
                int i21 = this.f2951 - this.f2942;
                if (i21 < 0) {
                    i21 += 360;
                }
                int i22 = this.f2949 / 2;
                canvas.drawArc(new RectF((float) (i22 - i18), (float) (i17 - i18), (float) (i22 + i18), (float) (i17 + i18)), (float) this.f2942, (float) i21, false, this.f2944);
                if (i21 >= this.f2938) {
                    this.f2959 = false;
                } else if (i21 <= 10) {
                    this.f2959 = true;
                }
                if (!this.f2936) {
                    this.f2952 = System.currentTimeMillis();
                    this.f2961 = this.f2952 + 1000;
                    this.f2955 = AnimatorStatus.DONE;
                }
                invalidate();
                break;
            case 7:
                m1672(canvas);
                invalidate();
                break;
            case 8:
                m1672(canvas);
                break;
        }
        if (this.f2955 == AnimatorStatus.REL_DRAG) {
            m1667();
        }
    }

    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        super.onLayout(z, i, i2, i3, i4);
        if (z) {
            this.f2943 = getHeight() / 6;
            this.f2949 = getWidth();
            this.f2960 = getHeight();
            if (this.f2960 < this.f2945) {
                this.f2955 = AnimatorStatus.PULL_DOWN;
            }
            if (this.f2955.ordinal() == 0 && this.f2960 >= this.f2945) {
                this.f2955 = AnimatorStatus.DRAG_DOWN;
            }
        }
    }

    public void onMeasure(int i, int i2) {
        setMeasuredDimension(View.resolveSize(getSuggestedMinimumWidth(), i), View.resolveSize(getSuggestedMinimumHeight(), i2));
    }

    public void setAniBackColor(int i) {
        this.f2946.setColor(i);
    }

    public void setAniForeColor(int i) {
        this.f2958.setColor(i);
        this.f2944.setColor(i);
        setBackgroundColor(i);
    }

    public void setOnViewAniDone(AbstractC0539 r1) {
        this.f2939 = r1;
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    public void setPrimaryColors(int... iArr) {
        if (iArr.length > 0) {
            setAniBackColor(iArr[0]);
            if (iArr.length > 1) {
                setAniForeColor(iArr[1]);
            }
        }
    }

    public void setRadius(int i) {
        this.f2943 = this.f2960 / i;
    }

    public void setRefreshing(boolean z) {
        this.f2936 = z;
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public final void m1667() {
        this.f2956 = System.currentTimeMillis();
        this.f2941 = this.f2956 + 200;
        this.f2955 = AnimatorStatus.SPRING_UP;
        invalidate();
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public void m1668() {
        this.f2935 = System.currentTimeMillis();
        this.f2950 = this.f2935 + 2000;
        this.f2955 = AnimatorStatus.REL_DRAG;
        this.f2937 = this.f2960 - this.f2945;
        requestLayout();
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1391
    /* renamed from: ῲ  reason: contains not printable characters */
    public void m1669(float f, int i, int i2, int i3) {
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m1670() {
        this.f2945 = C1436.m3649(100.0f);
        this.f2934 = C1436.m3649(50.0f);
        this.f2957 = 0.5f;
        this.f2946 = new Paint();
        this.f2946.setAntiAlias(true);
        this.f2946.setStyle(Paint.Style.FILL);
        this.f2946.setColor(-7630673);
        this.f2958 = new Paint();
        this.f2958.setAntiAlias(true);
        this.f2958.setColor(-1);
        this.f2958.setStyle(Paint.Style.FILL);
        this.f2944 = new Paint();
        this.f2944.setAntiAlias(true);
        this.f2944.setColor(-1);
        this.f2944.setStyle(Paint.Style.STROKE);
        this.f2944.setStrokeWidth(5.0f);
        this.f2953 = new Path();
        setMinimumHeight(this.f2945);
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1391
    /* renamed from: K  reason: contains not printable characters */
    public void m1671(float f, int i, int i2, int i3) {
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    /* renamed from: K  reason: contains not printable characters */
    public void m1675(AbstractC1401 r1) {
    }

    @Override // ඓ.㿎.K.ῲ.ݜ.AbstractC1408
    /* renamed from: K  reason: contains not printable characters */
    public void m1677(AbstractC1401 r1, RefreshState refreshState, RefreshState refreshState2) {
    }

    public CircleRefreshHeader(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public CircleRefreshHeader(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.f2955 = AnimatorStatus.PULL_DOWN;
        this.f2942 = 90;
        this.f2951 = 90;
        this.f2938 = BottomAppBarTopEdgeTreatment.ANGLE_UP;
        this.f2959 = true;
        this.f2936 = true;
        m1670();
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m1673(Canvas canvas, int i, int i2, float f) {
        int i3 = this.f2949;
        int i4 = this.f2943;
        int r9 = (int) C1293.m3403(1.0f, f, (float) ((i4 * 3) / 4), (float) (i3 / 2));
        PointF pointF = new PointF((float) ((i3 / 2) + i4), (float) i);
        float f2 = (float) i2;
        PointF pointF2 = new PointF((float) r9, f2);
        PointF pointF3 = new PointF((float) ((this.f2943 / 2) + r9), f2);
        this.f2953.reset();
        this.f2953.moveTo(pointF.x, pointF.y);
        this.f2953.quadTo(pointF2.x, pointF2.y, pointF3.x, pointF3.y);
        this.f2953.lineTo(((float) this.f2949) - pointF3.x, pointF3.y);
        Path path = this.f2953;
        int i5 = this.f2949;
        path.quadTo(((float) i5) - pointF2.x, pointF2.y, ((float) i5) - pointF.x, pointF.y);
        canvas.drawPath(this.f2953, this.f2958);
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m1672(Canvas canvas) {
        int color = this.f2944.getColor();
        if (((double) getDoneRatio()) < 0.3d) {
            canvas.drawRect(0.0f, 0.0f, (float) this.f2949, (float) this.f2960, this.f2946);
            int i = this.f2945 - (this.f2934 / 2);
            int i2 = this.f2943;
            int i3 = i - (i2 * 2);
            canvas.drawCircle((float) (this.f2949 / 2), (float) i3, (float) i2, this.f2958);
            int doneRatio = (int) (((getDoneRatio() * 10.0f) / 0.3f) + ((float) (this.f2943 + 10)));
            this.f2944.setColor(Color.argb((int) ((1.0f - (getDoneRatio() / 0.3f)) * 255.0f), Color.red(color), Color.green(color), Color.blue(color)));
            int i4 = this.f2949;
            canvas.drawArc(new RectF((float) ((i4 / 2) - doneRatio), (float) (i3 - doneRatio), (float) ((i4 / 2) + doneRatio), (float) (i3 + doneRatio)), 0.0f, 360.0f, false, this.f2944);
        }
        this.f2944.setColor(color);
        if (((double) getDoneRatio()) >= 0.3d && ((double) getDoneRatio()) < 0.7d) {
            canvas.drawRect(0.0f, 0.0f, (float) this.f2949, (float) this.f2960, this.f2946);
            float doneRatio2 = (getDoneRatio() - 0.3f) / 0.4f;
            int i5 = this.f2945;
            int i6 = this.f2934;
            int i7 = i5 - (i6 / 2);
            int i8 = this.f2943;
            int i9 = (int) ((((float) ((i8 * 2) + (i6 / 2))) * doneRatio2) + ((float) (i7 - (i8 * 2))));
            canvas.drawCircle((float) (this.f2949 / 2), (float) i9, (float) i8, this.f2958);
            int i10 = this.f2945;
            if (i9 >= i10 - (this.f2943 * 2)) {
                m1673(canvas, i9, i10, 1.0f - doneRatio2);
            }
        }
        if (((double) getDoneRatio()) >= 0.7d && getDoneRatio() <= 1.0f) {
            float doneRatio3 = (getDoneRatio() - 0.7f) / 0.3f;
            canvas.drawRect(0.0f, 0.0f, (float) this.f2949, (float) this.f2960, this.f2946);
            int i11 = this.f2943;
            int i12 = (int) (((float) ((this.f2949 / 2) - i11)) - (((float) (i11 * 2)) * doneRatio3));
            this.f2953.reset();
            this.f2953.moveTo((float) i12, (float) this.f2945);
            Path path = this.f2953;
            int i13 = this.f2949;
            int i14 = this.f2945;
            path.quadTo((float) (i13 / 2), ((float) i14) - ((1.0f - doneRatio3) * ((float) this.f2943)), (float) (i13 - i12), (float) i14);
            canvas.drawPath(this.f2953, this.f2958);
        }
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    /* renamed from: K  reason: contains not printable characters */
    public void m1674(AbstractC1396 r1, int i, int i2) {
        this.f2945 = i;
        this.f2934 = i / 2;
        ((SmartRefreshLayout.C0559) r1).m1854(new C0540());
    }

    @Override // ඓ.㿎.K.ῲ.Ԕ.AbstractC1399
    /* renamed from: K  reason: contains not printable characters */
    public void m1676(AbstractC1401 r1, int i, int i2) {
        setRefreshing(true);
        m1668();
    }
}
