package com.mexico.inloancash.utils;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.TypedValue;
import androidx.appcompat.widget.AppCompatImageView;
import com.mexico.inloancash.R$styleable;

public class RoundImageView extends AppCompatImageView {

    /* renamed from: ʬ  reason: contains not printable characters */
    public int f2878;

    /* renamed from: ῲ  reason: contains not printable characters */
    public Paint f2879;

    /* renamed from: 㸾  reason: contains not printable characters */
    public int f2880;

    public RoundImageView(Context context) {
        super(context);
        this.f2878 = 0;
        this.f2880 = (int) TypedValue.applyDimension(1, 10.0f, getResources().getDisplayMetrics());
        this.f2879 = new Paint(5);
    }

    public void onDraw(Canvas canvas) {
        Drawable drawable = getDrawable();
        Matrix imageMatrix = getImageMatrix();
        if (drawable != null && drawable.getIntrinsicWidth() != 0 && drawable.getIntrinsicHeight() != 0) {
            if (imageMatrix == null && getPaddingTop() == 0 && getPaddingLeft() == 0) {
                drawable.draw(canvas);
                return;
            }
            int saveCount = canvas.getSaveCount();
            canvas.save();
            int i = Build.VERSION.SDK_INT;
            if (getCropToPadding()) {
                int scrollX = getScrollX();
                int scrollY = getScrollY();
                canvas.clipRect(getPaddingLeft() + scrollX, getPaddingTop() + scrollY, ((getRight() + scrollX) - getLeft()) - getPaddingRight(), ((getBottom() + scrollY) - getTop()) - getPaddingBottom());
            }
            canvas.translate((float) getPaddingLeft(), (float) getPaddingTop());
            int i2 = this.f2878;
            if (i2 == 1) {
                Bitmap r0 = m1639(drawable);
                Paint paint = this.f2879;
                Shader.TileMode tileMode = Shader.TileMode.CLAMP;
                paint.setShader(new BitmapShader(r0, tileMode, tileMode));
                canvas.drawCircle((float) (getWidth() / 2), (float) (getHeight() / 2), (float) (getWidth() / 2), this.f2879);
            } else if (i2 == 2) {
                Bitmap r02 = m1639(drawable);
                Paint paint2 = this.f2879;
                Shader.TileMode tileMode2 = Shader.TileMode.CLAMP;
                paint2.setShader(new BitmapShader(r02, tileMode2, tileMode2));
                RectF rectF = new RectF((float) getPaddingLeft(), (float) getPaddingTop(), (float) (getWidth() - getPaddingRight()), (float) (getHeight() - getPaddingBottom()));
                int i3 = this.f2880;
                canvas.drawRoundRect(rectF, (float) i3, (float) i3, this.f2879);
            } else {
                if (imageMatrix != null) {
                    canvas.concat(imageMatrix);
                }
                drawable.draw(canvas);
            }
            canvas.restoreToCount(saveCount);
        }
    }

    public void onMeasure(int i, int i2) {
        if (this.f2878 == 1) {
            super.onMeasure(i, i2);
            int min = Math.min(getMeasuredHeight(), getMeasuredWidth());
            setMeasuredDimension(min, min);
            return;
        }
        super.onMeasure(i, i2);
    }

    /* renamed from: K  reason: contains not printable characters */
    public final Bitmap m1639(Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        Bitmap createBitmap = Bitmap.createBitmap(getWidth(), getHeight(), Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(createBitmap);
        Matrix imageMatrix = getImageMatrix();
        if (imageMatrix != null) {
            canvas.concat(imageMatrix);
        }
        drawable.draw(canvas);
        return createBitmap;
    }

    public RoundImageView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public RoundImageView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.f2878 = 0;
        this.f2880 = (int) TypedValue.applyDimension(1, 10.0f, getResources().getDisplayMetrics());
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, R$styleable.RoundImageView, i, 0);
        this.f2878 = obtainStyledAttributes.hasValue(1) ? obtainStyledAttributes.getInt(1, 0) : 0;
        this.f2880 = obtainStyledAttributes.hasValue(0) ? obtainStyledAttributes.getDimensionPixelSize(0, this.f2880) : this.f2880;
        obtainStyledAttributes.recycle();
        this.f2879 = new Paint(5);
    }
}
