package com.mexico.inloancash.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.widget.ScrollView;
import com.mexico.inloancash.R$styleable;
import java.lang.ref.WeakReference;
import java.util.List;
import ඓ.K.K.K.C1293;

public class WheelView extends ScrollView {

    /* renamed from: ʬ  reason: contains not printable characters */
    public int f2805;

    /* renamed from: Ԕ  reason: contains not printable characters */
    public Paint f2806;

    /* renamed from: ؿ  reason: contains not printable characters */
    public Handler f2807;

    /* renamed from: ඓ  reason: contains not printable characters */
    public float f2808;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public float f2809;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public int f2810;

    /* renamed from: ῲ  reason: contains not printable characters */
    public List<String> f2811;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public int f2812;

    /* renamed from: 㑃  reason: contains not printable characters */
    public float f2813;

    /* renamed from: 㗗  reason: contains not printable characters */
    public Paint f2814;

    /* renamed from: 㳳  reason: contains not printable characters */
    public int f2815;

    /* renamed from: 㴹  reason: contains not printable characters */
    public int f2816;

    /* renamed from: 㸾  reason: contains not printable characters */
    public float f2817;

    /* renamed from: 㿎  reason: contains not printable characters */
    public float f2818;

    /* renamed from: 䁗  reason: contains not printable characters */
    public Paint f2819;

    /* renamed from: com.mexico.inloancash.ui.WheelView$ῲ  reason: contains not printable characters */
    public static class HandlerC0527 extends Handler {

        /* renamed from: K  reason: contains not printable characters */
        public WeakReference<WheelView> f2820;

        public /* synthetic */ HandlerC0527(WheelView wheelView, C0528 k) {
            this.f2820 = new WeakReference<>(wheelView);
        }

        public void handleMessage(Message message) {
            super.handleMessage(message);
            if (message.what == 1) {
                Bundle data = message.getData();
                WheelView wheelView = this.f2820.get();
                if (wheelView != null) {
                    wheelView.f2808 -= data.getFloat("resilience_distance_of_once", 0.0f);
                    wheelView.invalidate();
                }
                int i = data.getInt("left_times", 0);
                if (i > 1) {
                    data.putInt("left_times", i - 1);
                    Message message2 = new Message();
                    message2.what = 1;
                    message2.setData(data);
                    sendMessageDelayed(message2, 50);
                }
            }
        }
    }

    public WheelView(Context context) {
        this(context, null);
    }

    public int getSelectedItemIndex() {
        return this.f2805;
    }

    public void onDraw(Canvas canvas) {
        Paint paint;
        super.onDraw(canvas);
        StringBuilder r0 = C1293.m3416("onDraw: ");
        r0.append(this.f2805);
        Log.d("MyWheelView", r0.toString());
        List<String> list = this.f2811;
        if (!(list == null || list.size() == 0)) {
            float f = this.f2818;
            int i = this.f2815;
            canvas.drawRect(0.0f, f * ((float) i), (float) this.f2816, f * ((float) (i + 1)), this.f2819);
            int min = Math.min(this.f2811.size() - 1, this.f2815 + 1 + this.f2805);
            for (int max = Math.max(0, this.f2805 - (this.f2815 + 1)); max <= min; max++) {
                String str = this.f2811.get(max);
                float f2 = this.f2818;
                int i2 = this.f2815;
                int i3 = this.f2805;
                float f3 = ((f2 / 2.0f) + (((float) (i2 - (i3 - max))) * f2)) - this.f2808;
                if (max == i3) {
                    paint = this.f2814;
                } else {
                    paint = this.f2806;
                }
                paint.setAntiAlias(true);
                float f4 = this.f2809;
                paint.setTextSize(f4 - ((Math.abs(((float) (this.f2812 / 2)) - f3) * (f4 - this.f2813)) / ((float) (this.f2812 / 2))));
                if (str != null) {
                    Paint.FontMetricsInt fontMetricsInt = paint.getFontMetricsInt();
                    canvas.drawText(str, (((float) this.f2816) - paint.measureText(str)) / 2.0f, (((float) ((-fontMetricsInt.bottom) - fontMetricsInt.top)) / 2.0f) + f3, paint);
                }
            }
        }
    }

    public void onMeasure(int i, int i2) {
        super.onMeasure(i, i2);
        this.f2816 = getMeasuredWidth();
        this.f2812 = getMeasuredHeight();
        this.f2818 = ((float) this.f2812) / ((float) this.f2810);
        float f = this.f2818;
        this.f2809 = 0.4f * f;
        this.f2813 = f * 0.16f;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        StringBuilder r0 = C1293.m3416("onTouchEvent: ");
        r0.append(motionEvent.getAction());
        r0.append(" ");
        r0.append(motionEvent.getY());
        Log.d("MyWheelView", r0.toString());
        int action = motionEvent.getAction();
        if (action == 0) {
            this.f2807.removeMessages(1);
            this.f2817 = motionEvent.getY();
            return true;
        } else if (action == 1) {
            Message obtainMessage = this.f2807.obtainMessage();
            obtainMessage.what = 1;
            Bundle bundle = new Bundle();
            bundle.putFloat("resilience_distance_of_once", this.f2808 / 5.0f);
            bundle.putInt("left_times", 5);
            obtainMessage.setData(bundle);
            obtainMessage.sendToTarget();
            return true;
        } else if (action != 2) {
            return false;
        } else {
            this.f2808 -= motionEvent.getY() - this.f2817;
            this.f2817 = motionEvent.getY();
            int round = Math.round(this.f2808 / this.f2818);
            int selectedItemIndex = getSelectedItemIndex();
            int selectedItemIndex2 = getSelectedItemIndex() + round;
            if (selectedItemIndex2 < 0) {
                selectedItemIndex2 = 0;
            }
            if (selectedItemIndex2 >= this.f2811.size()) {
                selectedItemIndex2 = this.f2811.size() - 1;
            }
            this.f2805 = selectedItemIndex2;
            this.f2808 -= this.f2818 * ((float) (this.f2805 - selectedItemIndex));
            invalidate();
            return true;
        }
    }

    public void setSelectedItemIndex(int i) {
        this.f2805 = i;
        this.f2808 = 0.0f;
        invalidate();
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m1627(List<String> list, int i) {
        this.f2811 = list;
        setSelectedItemIndex(i);
    }

    public WheelView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 1);
    }

    public WheelView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.f2805 = 0;
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, R$styleable.MyWheelView);
        Log.d("MyWheelView", "initDataAndPaint: ");
        this.f2810 = obtainStyledAttributes.getInt(0, 5);
        this.f2815 = this.f2810 / 2;
        this.f2819 = new Paint();
        this.f2806 = new Paint();
        this.f2814 = new Paint();
        this.f2819.setColor(obtainStyledAttributes.getColor(2, Color.parseColor("#ffffff")));
        this.f2806.setColor(obtainStyledAttributes.getColor(1, Color.parseColor("#5E5F60")));
        this.f2814.setColor(obtainStyledAttributes.getColor(4, Color.parseColor("#1E2429")));
        this.f2805 = 0;
        this.f2807 = new HandlerC0527(this, null);
    }
}
