package com.mexico.inloancash.ui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatImageView;

public class CircleImageView extends AppCompatImageView {

    /* renamed from: ʬ  reason: contains not printable characters */
    public int f2802;

    /* renamed from: ῲ  reason: contains not printable characters */
    public Paint f2803;

    /* renamed from: 㸾  reason: contains not printable characters */
    public float f2804;

    public CircleImageView(Context context) {
        super(context);
    }

    @SuppressLint({"DrawAllocation"})
    public void onDraw(Canvas canvas) {
        this.f2803 = new Paint();
        Drawable drawable = getDrawable();
        if (drawable != null) {
            Bitmap bitmap = ((BitmapDrawable) drawable).getBitmap();
            Shader.TileMode tileMode = Shader.TileMode.CLAMP;
            BitmapShader bitmapShader = new BitmapShader(bitmap, tileMode, tileMode);
            this.f2804 = (((float) this.f2802) * 2.0f) / ((float) Math.min(bitmap.getHeight(), bitmap.getWidth()));
            Matrix matrix = new Matrix();
            float f = this.f2804;
            matrix.setScale(f, f);
            bitmapShader.setLocalMatrix(matrix);
            this.f2803.setShader(bitmapShader);
            int i = this.f2802;
            canvas.drawCircle((float) i, (float) i, (float) i, this.f2803);
            return;
        }
        super.onDraw(canvas);
    }

    public void onMeasure(int i, int i2) {
        super.onMeasure(i, i2);
        int min = Math.min(getMeasuredWidth(), getMeasuredHeight());
        this.f2802 = min / 2;
        setMeasuredDimension(min, min);
    }

    public CircleImageView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public CircleImageView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
    }
}
