package com.mexico.inloancash.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import butterknife.ButterKnife;
import com.facebook.AccessToken;
import com.google.gson.Gson;
import com.indiaholacash.holacash.R;
import com.mexico.inloancash.MyApplication;
import com.mexico.inloancash.bean.BaseBean;
import com.mexico.inloancash.bean.India_NewBank_ListBean;
import java.util.ArrayList;
import java.util.List;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import ඓ.ඓ.K.㳳.AbstractC0672;
import ඓ.ඓ.K.㴹.DialogC0684;
import ඓ.ඓ.K.㿎.C0701;
import ඓ.K.K.K.C1293;
import ῲ.ᨨ.㳳.C1841;

public class IndiaAddBankActivity extends BaseActivity implements AbstractC0672 {
    public EditText mIndiaBankCard;
    public LinearLayout mIndiaBankLinear;
    public TextView mIndiaBankName;
    public Button mIndiaCommitButton;
    public EditText mIndiaEditTextIFSCCode;
    public ImageView mIndiaLogonBack;
    public EditText mIndiaPhoneNumber;
    public TextView mTitle;
    public EditText mUserName;

    /* renamed from: ඓ  reason: contains not printable characters */
    public DialogC0684 f2297;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public List<String> f2298;

    /* renamed from: 㴹  reason: contains not printable characters */
    public List<String> f2299;

    /* renamed from: com.mexico.inloancash.activity.IndiaAddBankActivity$ῲ  reason: contains not printable characters */
    public class C0348 implements Callback<String> {
        public C0348() {
        }

        @Override // retrofit2.Callback
        public void onFailure(Call<String> call, Throwable th) {
            IndiaAddBankActivity.this.f2296.m2185();
        }

        @Override // retrofit2.Callback
        public void onResponse(Call<String> call, Response<String> response) {
            if (response.isSuccessful()) {
                India_NewBank_ListBean india_NewBank_ListBean = (India_NewBank_ListBean) new Gson().fromJson(response.body(), India_NewBank_ListBean.class);
                if (Integer.parseInt(india_NewBank_ListBean.getCode()) == 200) {
                    List<India_NewBank_ListBean.DataBean> data = india_NewBank_ListBean.getData();
                    if (data.size() > 0) {
                        IndiaAddBankActivity.this.f2299.clear();
                        IndiaAddBankActivity.this.f2298.clear();
                        for (int i = 0; i < data.size(); i++) {
                            India_NewBank_ListBean.DataBean dataBean = data.get(i);
                            IndiaAddBankActivity.this.f2299.add(dataBean.getSerpay());
                            IndiaAddBankActivity.this.f2298.add(dataBean.getCode());
                        }
                    }
                }
            }
            IndiaAddBankActivity.this.f2296.m2185();
        }
    }

    /* renamed from: com.mexico.inloancash.activity.IndiaAddBankActivity$K  reason: contains not printable characters */
    public class C0349 implements Callback<String> {
        public C0349() {
        }

        @Override // retrofit2.Callback
        public void onFailure(Call<String> call, Throwable th) {
            IndiaAddBankActivity.this.f2296.m2185();
        }

        @Override // retrofit2.Callback
        public void onResponse(Call<String> call, Response<String> response) {
            if (response.isSuccessful()) {
                BaseBean baseBean = (BaseBean) new Gson().fromJson(response.body(), BaseBean.class);
                if (baseBean.getCode() == 200) {
                    C1841.m4792((Context) IndiaAddBankActivity.this, "Added successfully");
                    IndiaAddBankActivity.this.setResult(0);
                    IndiaAddBankActivity.this.finish();
                } else if (baseBean.getCode() == 401) {
                    C1841.m4744(AccessToken.TOKEN_KEY, "");
                    C1841.m4766(false);
                    MainActivity.f2549 = false;
                    IndiaAddBankActivity.this.startActivity(new Intent(IndiaAddBankActivity.this, IndiaLoginActivity.class));
                } else if (baseBean.getCode() != 60) {
                    C1841.m4792((Context) IndiaAddBankActivity.this, baseBean.getMsg());
                }
            }
            IndiaAddBankActivity.this.f2296.m2185();
        }
    }

    @Override // androidx.activity.ComponentActivity, androidx.core.app.ComponentActivity, com.mexico.inloancash.activity.BaseActivity, androidx.appcompat.app.AppCompatActivity, androidx.fragment.app.FragmentActivity
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        setContentView(R.layout.india_activity_view_addnewbank);
        ButterKnife.m1066(this);
        this.mTitle.setText("Add bank card");
        this.f2299 = new ArrayList();
        this.f2298 = new ArrayList();
        m1357();
        m1356();
    }

    @Override // androidx.appcompat.app.AppCompatActivity
    public boolean onKeyDown(int i, KeyEvent keyEvent) {
        if (i == 4) {
            finish();
        }
        return super.onKeyDown(i, keyEvent);
    }

    public void onViewClicked(View view) {
        int id = view.getId();
        if (id != R.id.bank_linear) {
            if (id != R.id.commit_button) {
                if (id == R.id.logon_back) {
                    finish();
                }
            } else if (C1293.m3418(this.mIndiaBankCard)) {
                Toast.makeText(this, "Bank card number cannot be empty", 0).show();
            } else if (TextUtils.isEmpty(this.mIndiaBankName.getText().toString().trim())) {
                Toast.makeText(this, "Bank name cannot be empty", 0).show();
            } else if (C1293.m3418(this.mIndiaEditTextIFSCCode)) {
                Toast.makeText(this, "IFSC cannot be empty", 0).show();
            } else {
                m1359();
            }
        } else if (this.f2299.size() > 0) {
            this.f2297 = new DialogC0684(this, this, "Bank", this.f2299, "bank");
            this.f2297.show();
        }
    }

    /* renamed from: ؿ  reason: contains not printable characters */
    public void m1356() {
        this.f2296.m2183();
        C0701.f3707.m2131().m2126().enqueue(new C0348());
    }

    /* renamed from: ᓣ  reason: contains not printable characters */
    public void m1357() {
    }

    @Override // ඓ.ඓ.K.㳳.AbstractC0672
    /* renamed from: K  reason: contains not printable characters */
    public void m1358(String str, String str2) {
        if (str.equals("bank")) {
            this.mIndiaBankName.setText(str2);
        }
    }

    /* renamed from: 㗽  reason: contains not printable characters */
    public void m1359() {
        this.f2296.m2183();
        C0701.f3707.m2131().m2120(C1841.m4788(AccessToken.TOKEN_KEY, ""), MyApplication.f2291, this.mIndiaBankCard.getText().toString().trim(), this.f2298.get(this.f2299.indexOf(this.mIndiaBankName.getText().toString().trim())), this.mIndiaEditTextIFSCCode.getText().toString().trim()).enqueue(new C0349());
    }
}
