package com.google.gson.internal.bind.util;

import com.facebook.internal.security.CertificateUtil;
import com.google.android.material.timepicker.ChipTextInputComboView;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import ඓ.K.K.K.C1293;

public class ISO8601Utils {
    public static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");
    public static final String UTC_ID = "UTC";

    public static boolean checkOffset(String str, int i, char c) {
        return i < str.length() && str.charAt(i) == c;
    }

    public static String format(Date date) {
        return format(date, false, TIMEZONE_UTC);
    }

    public static int indexOfNonDigit(String str, int i) {
        while (i < str.length()) {
            char charAt = str.charAt(i);
            if (charAt < '0' || charAt > '9') {
                return i;
            }
            i++;
        }
        return str.length();
    }

    public static void padInt(StringBuilder sb, int i, int i2) {
        String num = Integer.toString(i);
        for (int length = i2 - num.length(); length > 0; length--) {
            sb.append('0');
        }
        sb.append(num);
    }

    /* JADX WARNING: Removed duplicated region for block: B:49:0x00d6 A[Catch:{ IllegalArgumentException | IndexOutOfBoundsException | NumberFormatException -> 0x01c2 }] */
    /* JADX WARNING: Removed duplicated region for block: B:77:0x01ba A[Catch:{ IllegalArgumentException | IndexOutOfBoundsException | NumberFormatException -> 0x01c2 }] */
    public static Date parse(String str, ParsePosition parsePosition) throws ParseException {
        String str2;
        int i;
        int i2;
        int i3;
        int i4;
        int i5;
        TimeZone timeZone;
        int i6;
        int i7;
        int i8;
        int i9;
        char charAt;
        try {
            int index = parsePosition.getIndex();
            int i10 = index + 4;
            int parseInt = parseInt(str, index, i10);
            if (checkOffset(str, i10, '-')) {
                i10++;
            }
            int i11 = i10 + 2;
            int parseInt2 = parseInt(str, i10, i11);
            if (checkOffset(str, i11, '-')) {
                i11++;
            }
            int i12 = i11 + 2;
            int parseInt3 = parseInt(str, i11, i12);
            boolean checkOffset = checkOffset(str, i12, 'T');
            if (checkOffset || str.length() > i12) {
                if (checkOffset) {
                    int i13 = i12 + 1;
                    int i14 = i13 + 2;
                    i8 = parseInt(str, i13, i14);
                    if (checkOffset(str, i14, ':')) {
                        i14++;
                    }
                    int i15 = i14 + 2;
                    i9 = parseInt(str, i14, i15);
                    if (checkOffset(str, i15, ':')) {
                        i15++;
                    }
                    if (str.length() <= i15 || (charAt = str.charAt(i15)) == 'Z' || charAt == '+' || charAt == '-') {
                        i5 = i15;
                    } else {
                        i5 = i15 + 2;
                        i = parseInt(str, i15, i5);
                        if (i > 59 && i < 63) {
                            i = 59;
                        }
                        if (checkOffset(str, i5, '.')) {
                            int i16 = i5 + 1;
                            int indexOfNonDigit = indexOfNonDigit(str, i16 + 1);
                            int min = Math.min(indexOfNonDigit, i16 + 3);
                            i7 = parseInt(str, i16, min);
                            int i17 = min - i16;
                            if (i17 == 1) {
                                i7 *= 100;
                            } else if (i17 == 2) {
                                i7 *= 10;
                            }
                            i2 = i9;
                            i5 = indexOfNonDigit;
                            i3 = i8;
                            i4 = i7;
                            if (str.length() > i5) {
                                char charAt2 = str.charAt(i5);
                                if (charAt2 == 'Z') {
                                    timeZone = TIMEZONE_UTC;
                                    i6 = i5 + 1;
                                } else {
                                    if (charAt2 != '+') {
                                        if (charAt2 != '-') {
                                            throw new IndexOutOfBoundsException("Invalid time zone indicator '" + charAt2 + "'");
                                        }
                                    }
                                    String substring = str.substring(i5);
                                    if (substring.length() < 5) {
                                        substring = substring + ChipTextInputComboView.TextFormatter.DEFAULT_TEXT;
                                    }
                                    i6 = i5 + substring.length();
                                    if (!"+0000".equals(substring)) {
                                        if (!"+00:00".equals(substring)) {
                                            String str3 = "GMT" + substring;
                                            timeZone = TimeZone.getTimeZone(str3);
                                            String id = timeZone.getID();
                                            if (!id.equals(str3)) {
                                                if (!id.replace(CertificateUtil.DELIMITER, "").equals(str3)) {
                                                    throw new IndexOutOfBoundsException("Mismatching time zone indicator: " + str3 + " given, resolves to " + timeZone.getID());
                                                }
                                            }
                                        }
                                    }
                                    timeZone = TIMEZONE_UTC;
                                }
                                GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
                                gregorianCalendar.setLenient(false);
                                gregorianCalendar.set(1, parseInt);
                                gregorianCalendar.set(2, parseInt2 - 1);
                                gregorianCalendar.set(5, parseInt3);
                                gregorianCalendar.set(11, i3);
                                gregorianCalendar.set(12, i2);
                                gregorianCalendar.set(13, i);
                                gregorianCalendar.set(14, i4);
                                parsePosition.setIndex(i6);
                                return gregorianCalendar.getTime();
                            }
                            throw new IllegalArgumentException("No time zone indicator");
                        }
                        i2 = i9;
                        i3 = i8;
                        i4 = 0;
                        if (str.length() > i5) {
                        }
                    }
                } else {
                    i5 = i12;
                    i8 = 0;
                    i9 = 0;
                }
                i7 = 0;
                i = 0;
                i2 = i9;
                i3 = i8;
                i4 = i7;
                if (str.length() > i5) {
                }
            } else {
                GregorianCalendar gregorianCalendar2 = new GregorianCalendar(parseInt, parseInt2 - 1, parseInt3);
                parsePosition.setIndex(i12);
                return gregorianCalendar2.getTime();
            }
        } catch (IllegalArgumentException | IndexOutOfBoundsException | NumberFormatException e) {
            if (str == null) {
                str2 = null;
            } else {
                str2 = '\"' + str + "'";
            }
            String message = e.getMessage();
            if (message == null || message.isEmpty()) {
                StringBuilder r3 = C1293.m3416("(");
                r3.append(e.getClass().getName());
                r3.append(")");
                message = r3.toString();
            }
            ParseException parseException = new ParseException("Failed to parse date [" + str2 + "]: " + message, parsePosition.getIndex());
            parseException.initCause(e);
            throw parseException;
        }
    }

    public static int parseInt(String str, int i, int i2) throws NumberFormatException {
        int i3;
        int i4;
        if (i < 0 || i2 > str.length() || i > i2) {
            throw new NumberFormatException(str);
        }
        if (i < i2) {
            i4 = i + 1;
            int digit = Character.digit(str.charAt(i), 10);
            if (digit >= 0) {
                i3 = -digit;
            } else {
                StringBuilder r0 = C1293.m3416("Invalid number: ");
                r0.append(str.substring(i, i2));
                throw new NumberFormatException(r0.toString());
            }
        } else {
            i3 = 0;
            i4 = i;
        }
        while (i4 < i2) {
            int i5 = i4 + 1;
            int digit2 = Character.digit(str.charAt(i4), 10);
            if (digit2 >= 0) {
                i3 = (i3 * 10) - digit2;
                i4 = i5;
            } else {
                StringBuilder r02 = C1293.m3416("Invalid number: ");
                r02.append(str.substring(i, i2));
                throw new NumberFormatException(r02.toString());
            }
        }
        return -i3;
    }

    public static String format(Date date, boolean z) {
        return format(date, z, TIMEZONE_UTC);
    }

    public static String format(Date date, boolean z, TimeZone timeZone) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone, Locale.US);
        gregorianCalendar.setTime(date);
        StringBuilder sb = new StringBuilder(19 + (z ? 4 : 0) + (timeZone.getRawOffset() == 0 ? 1 : 6));
        padInt(sb, gregorianCalendar.get(1), 4);
        char c = '-';
        sb.append('-');
        padInt(sb, gregorianCalendar.get(2) + 1, 2);
        sb.append('-');
        padInt(sb, gregorianCalendar.get(5), 2);
        sb.append('T');
        padInt(sb, gregorianCalendar.get(11), 2);
        sb.append(':');
        padInt(sb, gregorianCalendar.get(12), 2);
        sb.append(':');
        padInt(sb, gregorianCalendar.get(13), 2);
        if (z) {
            sb.append('.');
            padInt(sb, gregorianCalendar.get(14), 3);
        }
        int offset = timeZone.getOffset(gregorianCalendar.getTimeInMillis());
        if (offset != 0) {
            int i = offset / 60000;
            int abs = Math.abs(i / 60);
            int abs2 = Math.abs(i % 60);
            if (offset >= 0) {
                c = '+';
            }
            sb.append(c);
            padInt(sb, abs, 2);
            sb.append(':');
            padInt(sb, abs2, 2);
        } else {
            sb.append('Z');
        }
        return sb.toString();
    }
}
