package com.google.android.material.transition.platform;

import com.google.android.material.progressindicator.BaseProgressIndicator;
import ඓ.K.K.K.C1293;

public class FadeModeEvaluators {
    public static final FadeModeEvaluator CROSS = new FadeModeEvaluator() {
        /* class com.google.android.material.transition.platform.FadeModeEvaluators.AnonymousClass3 */

        @Override // com.google.android.material.transition.platform.FadeModeEvaluator
        public FadeModeResult evaluate(float f, float f2, float f3, float f4) {
            return FadeModeResult.startOnTop(TransitionUtils.lerp((int) BaseProgressIndicator.MAX_ALPHA, 0, f2, f3, f), TransitionUtils.lerp(0, (int) BaseProgressIndicator.MAX_ALPHA, f2, f3, f));
        }
    };
    public static final FadeModeEvaluator IN = new FadeModeEvaluator() {
        /* class com.google.android.material.transition.platform.FadeModeEvaluators.AnonymousClass1 */

        @Override // com.google.android.material.transition.platform.FadeModeEvaluator
        public FadeModeResult evaluate(float f, float f2, float f3, float f4) {
            return FadeModeResult.endOnTop(BaseProgressIndicator.MAX_ALPHA, TransitionUtils.lerp(0, (int) BaseProgressIndicator.MAX_ALPHA, f2, f3, f));
        }
    };
    public static final FadeModeEvaluator OUT = new FadeModeEvaluator() {
        /* class com.google.android.material.transition.platform.FadeModeEvaluators.AnonymousClass2 */

        @Override // com.google.android.material.transition.platform.FadeModeEvaluator
        public FadeModeResult evaluate(float f, float f2, float f3, float f4) {
            return FadeModeResult.startOnTop(TransitionUtils.lerp((int) BaseProgressIndicator.MAX_ALPHA, 0, f2, f3, f), BaseProgressIndicator.MAX_ALPHA);
        }
    };
    public static final FadeModeEvaluator THROUGH = new FadeModeEvaluator() {
        /* class com.google.android.material.transition.platform.FadeModeEvaluators.AnonymousClass4 */

        @Override // com.google.android.material.transition.platform.FadeModeEvaluator
        public FadeModeResult evaluate(float f, float f2, float f3, float f4) {
            float r6 = C1293.m3403(f3, f2, f4, f2);
            return FadeModeResult.startOnTop(TransitionUtils.lerp((int) BaseProgressIndicator.MAX_ALPHA, 0, f2, r6, f), TransitionUtils.lerp(0, (int) BaseProgressIndicator.MAX_ALPHA, r6, f3, f));
        }
    };

    public static FadeModeEvaluator get(int i, boolean z) {
        if (i == 0) {
            return z ? IN : OUT;
        }
        if (i == 1) {
            return z ? OUT : IN;
        }
        if (i == 2) {
            return CROSS;
        }
        if (i == 3) {
            return THROUGH;
        }
        throw new IllegalArgumentException(C1293.m3408("Invalid fade mode: ", i));
    }
}
