package com.google.android.material.progressindicator;

import android.content.ContentResolver;
import android.os.Build;
import android.provider.Settings;

public class AnimatorDurationScaleProvider {
    public static float defaultSystemAnimatorDurationScale = 1.0f;

    public static void setDefaultSystemAnimatorDurationScale(float f) {
        defaultSystemAnimatorDurationScale = f;
    }

    public float getSystemAnimatorDurationScale(ContentResolver contentResolver) {
        int i = Build.VERSION.SDK_INT;
        return Settings.Global.getFloat(contentResolver, "animator_duration_scale", 1.0f);
    }
}
