package com.google.android.material.internal;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import java.util.Map;
import ῲ.ᓆ.AbstractC1647;
import ῲ.ᓆ.C1646;

public class TextScale extends AbstractC1647 {
    public static final String PROPNAME_SCALE = "android:textscale:scale";

    private void captureValues(C1646 r3) {
        View view = r3.f5882;
        if (view instanceof TextView) {
            r3.f5883.put(PROPNAME_SCALE, Float.valueOf(((TextView) view).getScaleX()));
        }
    }

    @Override // ῲ.ᓆ.AbstractC1647
    public void captureEndValues(C1646 r1) {
        captureValues(r1);
    }

    @Override // ῲ.ᓆ.AbstractC1647
    public void captureStartValues(C1646 r1) {
        captureValues(r1);
    }

    @Override // ῲ.ᓆ.AbstractC1647
    public Animator createAnimator(ViewGroup viewGroup, C1646 r6, C1646 r7) {
        if (r6 == null || r7 == null || !(r6.f5882 instanceof TextView)) {
            return null;
        }
        View view = r7.f5882;
        if (!(view instanceof TextView)) {
            return null;
        }
        final TextView textView = (TextView) view;
        Map<String, Object> map = r6.f5883;
        Map<String, Object> map2 = r7.f5883;
        float f = 1.0f;
        float floatValue = map.get(PROPNAME_SCALE) != null ? ((Float) map.get(PROPNAME_SCALE)).floatValue() : 1.0f;
        if (map2.get(PROPNAME_SCALE) != null) {
            f = ((Float) map2.get(PROPNAME_SCALE)).floatValue();
        }
        if (floatValue == f) {
            return null;
        }
        ValueAnimator ofFloat = ValueAnimator.ofFloat(floatValue, f);
        ofFloat.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
            /* class com.google.android.material.internal.TextScale.AnonymousClass1 */

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float floatValue = ((Float) valueAnimator.getAnimatedValue()).floatValue();
                textView.setScaleX(floatValue);
                textView.setScaleY(floatValue);
            }
        });
        return ofFloat;
    }
}
