package com.google.android.material.internal;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.CheckedTextView;
import android.widget.FrameLayout;
import androidx.appcompat.R$attr;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.R;
import ῲ.ᨨ.ᨨ.C1729;
import ῲ.ᨨ.ᨨ.C1747;
import ῲ.ᨨ.ᨨ.䃖.C1782;
import ῲ.ᨨ.㳳.C1841;
import ῲ.ῲ.ඓ.㳳.AbstractC1917;
import ῲ.ῲ.ඓ.㳳.C1922;
import K.K.K.ʬ.C2369;

public class NavigationMenuItemView extends ForegroundLinearLayout implements AbstractC1917.AbstractC1918 {
    public static final int[] CHECKED_STATE_SET = {16842912};
    public final C1747 accessibilityDelegate;
    public FrameLayout actionArea;
    public boolean checkable;
    public Drawable emptyDrawable;
    public boolean hasIconTintList;
    public int iconSize;
    public ColorStateList iconTintList;
    public C1922 itemData;
    public boolean needsEmptyIcon;
    public final CheckedTextView textView;

    public NavigationMenuItemView(Context context) {
        this(context, null);
    }

    private void adjustAppearance() {
        if (shouldExpandActionArea()) {
            this.textView.setVisibility(8);
            FrameLayout frameLayout = this.actionArea;
            if (frameLayout != null) {
                LinearLayoutCompat.C0090 k = (LinearLayoutCompat.C0090) frameLayout.getLayoutParams();
                ((ViewGroup.MarginLayoutParams) k).width = -1;
                this.actionArea.setLayoutParams(k);
                return;
            }
            return;
        }
        this.textView.setVisibility(0);
        FrameLayout frameLayout2 = this.actionArea;
        if (frameLayout2 != null) {
            LinearLayoutCompat.C0090 k2 = (LinearLayoutCompat.C0090) frameLayout2.getLayoutParams();
            ((ViewGroup.MarginLayoutParams) k2).width = -2;
            this.actionArea.setLayoutParams(k2);
        }
    }

    private StateListDrawable createDefaultBackground() {
        TypedValue typedValue = new TypedValue();
        if (!getContext().getTheme().resolveAttribute(R$attr.colorControlHighlight, typedValue, true)) {
            return null;
        }
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(CHECKED_STATE_SET, new ColorDrawable(typedValue.data));
        stateListDrawable.addState(ViewGroup.EMPTY_STATE_SET, new ColorDrawable(0));
        return stateListDrawable;
    }

    private void setActionView(View view) {
        if (view != null) {
            if (this.actionArea == null) {
                this.actionArea = (FrameLayout) ((ViewStub) findViewById(R.id.design_menu_item_action_area_stub)).inflate();
            }
            this.actionArea.removeAllViews();
            this.actionArea.addView(view);
        }
    }

    private boolean shouldExpandActionArea() {
        C1922 r0 = this.itemData;
        return r0.f6519 == null && r0.getIcon() == null && this.itemData.getActionView() != null;
    }

    @Override // ῲ.ῲ.ඓ.㳳.AbstractC1917.AbstractC1918
    public C1922 getItemData() {
        return this.itemData;
    }

    @Override // ῲ.ῲ.ඓ.㳳.AbstractC1917.AbstractC1918
    public void initialize(C1922 r1, int i) {
        this.itemData = r1;
        int i2 = r1.f6529;
        if (i2 > 0) {
            setId(i2);
        }
        setVisibility(r1.isVisible() ? 0 : 8);
        if (getBackground() == null) {
            C1729.m4478(this, createDefaultBackground());
        }
        setCheckable(r1.isCheckable());
        setChecked(r1.isChecked());
        setEnabled(r1.isEnabled());
        setTitle(r1.f6519);
        setIcon(r1.getIcon());
        setActionView(r1.getActionView());
        setContentDescription(r1.f6534);
        C2369.m6331((View) this, r1.f6518);
        adjustAppearance();
    }

    public int[] onCreateDrawableState(int i) {
        int[] onCreateDrawableState = super.onCreateDrawableState(i + 1);
        C1922 r0 = this.itemData;
        if (r0 != null && r0.isCheckable() && this.itemData.isChecked()) {
            ViewGroup.mergeDrawableStates(onCreateDrawableState, CHECKED_STATE_SET);
        }
        return onCreateDrawableState;
    }

    @Override // ῲ.ῲ.ඓ.㳳.AbstractC1917.AbstractC1918
    public boolean prefersCondensedTitle() {
        return false;
    }

    public void recycle() {
        FrameLayout frameLayout = this.actionArea;
        if (frameLayout != null) {
            frameLayout.removeAllViews();
        }
        this.textView.setCompoundDrawables(null, null, null, null);
    }

    public void setCheckable(boolean z) {
        refreshDrawableState();
        if (this.checkable != z) {
            this.checkable = z;
            this.accessibilityDelegate.sendAccessibilityEvent(this.textView, RecyclerView.AbstractC0269.FLAG_MOVED);
        }
    }

    public void setChecked(boolean z) {
        refreshDrawableState();
        this.textView.setChecked(z);
    }

    public void setHorizontalPadding(int i) {
        setPadding(i, 0, i, 0);
    }

    public void setIcon(Drawable drawable) {
        if (drawable != null) {
            if (this.hasIconTintList) {
                Drawable.ConstantState constantState = drawable.getConstantState();
                if (constantState != null) {
                    drawable = constantState.newDrawable();
                }
                drawable = C2369.m6273(drawable).mutate();
                ColorStateList colorStateList = this.iconTintList;
                int i = Build.VERSION.SDK_INT;
                drawable.setTintList(colorStateList);
            }
            int i2 = this.iconSize;
            drawable.setBounds(0, 0, i2, i2);
        } else if (this.needsEmptyIcon) {
            if (this.emptyDrawable == null) {
                this.emptyDrawable = C2369.m6280(getResources(), R.drawable.navigation_empty_icon, getContext().getTheme());
                Drawable drawable2 = this.emptyDrawable;
                if (drawable2 != null) {
                    int i3 = this.iconSize;
                    drawable2.setBounds(0, 0, i3, i3);
                }
            }
            drawable = this.emptyDrawable;
        }
        CheckedTextView checkedTextView = this.textView;
        int i4 = Build.VERSION.SDK_INT;
        checkedTextView.setCompoundDrawablesRelative(drawable, null, null, null);
    }

    public void setIconPadding(int i) {
        this.textView.setCompoundDrawablePadding(i);
    }

    public void setIconSize(int i) {
        this.iconSize = i;
    }

    public void setIconTintList(ColorStateList colorStateList) {
        this.iconTintList = colorStateList;
        this.hasIconTintList = this.iconTintList != null;
        C1922 r1 = this.itemData;
        if (r1 != null) {
            setIcon(r1.getIcon());
        }
    }

    public void setMaxLines(int i) {
        this.textView.setMaxLines(i);
    }

    public void setNeedsEmptyIcon(boolean z) {
        this.needsEmptyIcon = z;
    }

    public void setShortcut(boolean z, char c) {
    }

    public void setTextAppearance(int i) {
        C1841.m4810(this.textView, i);
    }

    public void setTextColor(ColorStateList colorStateList) {
        this.textView.setTextColor(colorStateList);
    }

    public void setTitle(CharSequence charSequence) {
        this.textView.setText(charSequence);
    }

    public boolean showsIcon() {
        return true;
    }

    public NavigationMenuItemView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public NavigationMenuItemView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.accessibilityDelegate = new C1747() {
            /* class com.google.android.material.internal.NavigationMenuItemView.AnonymousClass1 */

            @Override // ῲ.ᨨ.ᨨ.C1747
            public void onInitializeAccessibilityNodeInfo(View view, C1782 r2) {
                super.onInitializeAccessibilityNodeInfo(view, r2);
                r2.f6124.setCheckable(NavigationMenuItemView.this.checkable);
            }
        };
        setOrientation(0);
        LayoutInflater.from(context).inflate(R.layout.design_navigation_menu_item, (ViewGroup) this, true);
        setIconSize(context.getResources().getDimensionPixelSize(R.dimen.design_navigation_icon_size));
        this.textView = (CheckedTextView) findViewById(R.id.design_menu_item_text);
        this.textView.setDuplicateParentStateEnabled(true);
        C1729.m4482(this.textView, this.accessibilityDelegate);
    }
}
