package com.google.android.material.color;

import android.content.Context;
import android.graphics.Color;
import android.util.TypedValue;
import android.view.View;
import com.google.android.material.progressindicator.BaseProgressIndicator;
import com.google.android.material.resources.MaterialAttributes;
import ῲ.ᨨ.ʬ.C1718;

public class MaterialColors {
    public static final float ALPHA_DISABLED = 0.38f;
    public static final float ALPHA_DISABLED_LOW = 0.12f;
    public static final float ALPHA_FULL = 1.0f;
    public static final float ALPHA_LOW = 0.32f;
    public static final float ALPHA_MEDIUM = 0.54f;

    public static int compositeARGBWithAlpha(int i, int i2) {
        return C1718.m4410(i, (Color.alpha(i) * i2) / BaseProgressIndicator.MAX_ALPHA);
    }

    public static int getColor(View view, int i) {
        return MaterialAttributes.resolveOrThrow(view, i);
    }

    public static boolean isColorLight(int i) {
        double d;
        double d2;
        double d3;
        double d4;
        if (i != 0) {
            double[] dArr = C1718.f6030.get();
            if (dArr == null) {
                dArr = new double[3];
                C1718.f6030.set(dArr);
            }
            int red = Color.red(i);
            int green = Color.green(i);
            int blue = Color.blue(i);
            if (dArr.length == 3) {
                double d5 = ((double) red) / 255.0d;
                if (d5 < 0.04045d) {
                    d = d5 / 12.92d;
                } else {
                    d = Math.pow((d5 + 0.055d) / 1.055d, 2.4d);
                }
                double d6 = ((double) green) / 255.0d;
                if (d6 < 0.04045d) {
                    d3 = d6 / 12.92d;
                    d2 = 2.4d;
                } else {
                    d2 = 2.4d;
                    d3 = Math.pow((d6 + 0.055d) / 1.055d, 2.4d);
                }
                double d7 = ((double) blue) / 255.0d;
                if (d7 < 0.04045d) {
                    d4 = d7 / 12.92d;
                } else {
                    d4 = Math.pow((d7 + 0.055d) / 1.055d, d2);
                }
                dArr[0] = ((0.1805d * d4) + (0.3576d * d3) + (0.4124d * d)) * 100.0d;
                dArr[1] = ((0.0722d * d4) + (0.7152d * d3) + (0.2126d * d)) * 100.0d;
                double d8 = d4 * 0.9505d;
                dArr[2] = (d8 + (d3 * 0.1192d) + (d * 0.0193d)) * 100.0d;
                if (dArr[1] / 100.0d > 0.5d) {
                    return true;
                }
            } else {
                throw new IllegalArgumentException("outXyz must have a length of 3.");
            }
        }
        return false;
    }

    public static int layer(View view, int i, int i2) {
        return layer(view, i, i2, 1.0f);
    }

    public static int getColor(Context context, int i, String str) {
        return MaterialAttributes.resolveOrThrow(context, i, str);
    }

    public static int layer(View view, int i, int i2, float f) {
        return layer(getColor(view, i), getColor(view, i2), f);
    }

    public static int getColor(View view, int i, int i2) {
        return getColor(view.getContext(), i, i2);
    }

    public static int getColor(Context context, int i, int i2) {
        TypedValue resolve = MaterialAttributes.resolve(context, i);
        return resolve != null ? resolve.data : i2;
    }

    public static int layer(int i, int i2, float f) {
        return layer(i, C1718.m4410(i2, Math.round(((float) Color.alpha(i2)) * f)));
    }

    public static int layer(int i, int i2) {
        return C1718.m4411(i2, i);
    }
}
