package com.google.android.material.animation;

import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Property;
import java.util.WeakHashMap;

public class DrawableAlphaProperty extends Property<Drawable, Integer> {
    public static final Property<Drawable, Integer> DRAWABLE_ALPHA_COMPAT = new DrawableAlphaProperty();
    public final WeakHashMap<Drawable, Integer> alphaCache = new WeakHashMap<>();

    public DrawableAlphaProperty() {
        super(Integer.class, "drawableAlphaCompat");
    }

    public Integer get(Drawable drawable) {
        int i = Build.VERSION.SDK_INT;
        return Integer.valueOf(drawable.getAlpha());
    }

    public void set(Drawable drawable, Integer num) {
        int i = Build.VERSION.SDK_INT;
        drawable.setAlpha(num.intValue());
    }
}
