package com.facebook.places.model;

import java.util.HashSet;
import java.util.Set;

public final class PlaceSearchRequestParams {
    public final Set<String> categories;
    public final int distance;
    public final Set<String> fields;
    public final int limit;
    public final String searchText;

    public static class Builder {
        public final Set<String> categories = new HashSet();
        public int distance;
        public final Set<String> fields = new HashSet();
        public int limit;
        public String searchText;

        public Builder addCategory(String str) {
            this.categories.add(str);
            return this;
        }

        public Builder addField(String str) {
            this.fields.add(str);
            return this;
        }

        public PlaceSearchRequestParams build() {
            return new PlaceSearchRequestParams(this);
        }

        public Builder setDistance(int i) {
            this.distance = i;
            return this;
        }

        public Builder setLimit(int i) {
            this.limit = i;
            return this;
        }

        public Builder setSearchText(String str) {
            this.searchText = str;
            return this;
        }
    }

    public Set<String> getCategories() {
        return this.categories;
    }

    public int getDistance() {
        return this.distance;
    }

    public Set<String> getFields() {
        return this.fields;
    }

    public int getLimit() {
        return this.limit;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public PlaceSearchRequestParams(Builder builder) {
        this.categories = new HashSet();
        this.fields = new HashSet();
        this.distance = builder.distance;
        this.limit = builder.limit;
        this.searchText = builder.searchText;
        this.categories.addAll(builder.categories);
        this.fields.addAll(builder.fields);
    }
}
