package com.facebook.places.model;

import java.util.HashSet;
import java.util.Set;

public final class PlaceInfoRequestParams {
    public final Set<String> fields;
    public final String placeId;

    public static class Builder {
        public final Set<String> fields = new HashSet();
        public String placeId;

        public Builder addField(String str) {
            this.fields.add(str);
            return this;
        }

        public Builder addFields(String[] strArr) {
            for (String str : strArr) {
                this.fields.add(str);
            }
            return this;
        }

        public PlaceInfoRequestParams build() {
            return new PlaceInfoRequestParams(this);
        }

        public Builder setPlaceId(String str) {
            this.placeId = str;
            return this;
        }
    }

    public Set<String> getFields() {
        return this.fields;
    }

    public String getPlaceId() {
        return this.placeId;
    }

    public PlaceInfoRequestParams(Builder builder) {
        this.fields = new HashSet();
        this.placeId = builder.placeId;
        this.fields.addAll(builder.fields);
    }
}
