package com.facebook.messenger;

import android.net.Uri;

public class ShareToMessengerParamsBuilder {
    public Uri mExternalUri;
    public String mMetaData;
    public final String mMimeType;
    public final Uri mUri;

    public ShareToMessengerParamsBuilder(Uri uri, String str) {
        this.mUri = uri;
        this.mMimeType = str;
    }

    public ShareToMessengerParams build() {
        return new ShareToMessengerParams(this);
    }

    public Uri getExternalUri() {
        return this.mExternalUri;
    }

    public String getMetaData() {
        return this.mMetaData;
    }

    public String getMimeType() {
        return this.mMimeType;
    }

    public Uri getUri() {
        return this.mUri;
    }

    public ShareToMessengerParamsBuilder setExternalUri(Uri uri) {
        this.mExternalUri = uri;
        return this;
    }

    public ShareToMessengerParamsBuilder setMetaData(String str) {
        this.mMetaData = str;
        return this;
    }
}
