package com.facebook.login;

import com.facebook.AccessToken;
import java.util.Set;

public class LoginResult {
    public final AccessToken accessToken;
    public final Set<String> recentlyDeniedPermissions;
    public final Set<String> recentlyGrantedPermissions;

    public LoginResult(AccessToken accessToken2, Set<String> set, Set<String> set2) {
        this.accessToken = accessToken2;
        this.recentlyGrantedPermissions = set;
        this.recentlyDeniedPermissions = set2;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public Set<String> getRecentlyDeniedPermissions() {
        return this.recentlyDeniedPermissions;
    }

    public Set<String> getRecentlyGrantedPermissions() {
        return this.recentlyGrantedPermissions;
    }
}
