package com.facebook.internal;

import java.util.EnumSet;
import java.util.Iterator;

public enum SmartLoginOption {
    None(0),
    Enabled(1),
    RequireConfirm(2);
    
    public static final EnumSet<SmartLoginOption> ALL = EnumSet.allOf(SmartLoginOption.class);
    public final long mValue;

    /* access modifiers changed from: public */
    SmartLoginOption(long j) {
        this.mValue = j;
    }

    public static EnumSet<SmartLoginOption> parseOptions(long j) {
        EnumSet<SmartLoginOption> noneOf = EnumSet.noneOf(SmartLoginOption.class);
        Iterator it2 = ALL.iterator();
        while (it2.hasNext()) {
            SmartLoginOption smartLoginOption = (SmartLoginOption) it2.next();
            if ((smartLoginOption.getValue() & j) != 0) {
                noneOf.add(smartLoginOption);
            }
        }
        return noneOf;
    }

    public long getValue() {
        return this.mValue;
    }
}
