package com.facebook.internal;

import com.facebook.FacebookSdk;
import com.facebook.internal.FetchedAppGateKeepersManager;
import com.google.android.material.progressindicator.BaseProgressIndicator;
import ඓ.K.K.K.C1293;

public final class FeatureManager {

    /* renamed from: com.facebook.internal.FeatureManager$2  reason: invalid class name */
    public static /* synthetic */ class AnonymousClass2 {
        public static final /* synthetic */ int[] $SwitchMap$com$facebook$internal$FeatureManager$Feature = new int[Feature.values().length];

        /* JADX WARNING: Can't wrap try/catch for region: R(30:0|1|2|3|4|5|6|7|8|9|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24|25|26|27|28|(3:29|30|32)) */
        /* JADX WARNING: Can't wrap try/catch for region: R(32:0|1|2|3|4|5|6|7|8|9|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24|25|26|27|28|29|30|32) */
        /* JADX WARNING: Failed to process nested try/catch */
        /* JADX WARNING: Missing exception handler attribute for start block: B:11:0x0040 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:13:0x004b */
        /* JADX WARNING: Missing exception handler attribute for start block: B:15:0x0056 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:17:0x0062 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:19:0x006e */
        /* JADX WARNING: Missing exception handler attribute for start block: B:21:0x007a */
        /* JADX WARNING: Missing exception handler attribute for start block: B:23:0x0086 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:25:0x0092 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:27:0x009e */
        /* JADX WARNING: Missing exception handler attribute for start block: B:29:0x00aa */
        /* JADX WARNING: Missing exception handler attribute for start block: B:3:0x0014 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:5:0x001f */
        /* JADX WARNING: Missing exception handler attribute for start block: B:7:0x002a */
        /* JADX WARNING: Missing exception handler attribute for start block: B:9:0x0035 */
        static {
            $SwitchMap$com$facebook$internal$FeatureManager$Feature[Feature.RestrictiveDataFiltering.ordinal()] = 1;
            $SwitchMap$com$facebook$internal$FeatureManager$Feature[Feature.Instrument.ordinal()] = 2;
            $SwitchMap$com$facebook$internal$FeatureManager$Feature[Feature.CrashReport.ordinal()] = 3;
            $SwitchMap$com$facebook$internal$FeatureManager$Feature[Feature.ErrorReport.ordinal()] = 4;
            $SwitchMap$com$facebook$internal$FeatureManager$Feature[Feature.AAM.ordinal()] = 5;
            $SwitchMap$com$facebook$internal$FeatureManager$Feature[Feature.PrivacyProtection.ordinal()] = 6;
            $SwitchMap$com$facebook$internal$FeatureManager$Feature[Feature.SuggestedEvents.ordinal()] = 7;
            $SwitchMap$com$facebook$internal$FeatureManager$Feature[Feature.PIIFiltering.ordinal()] = 8;
            $SwitchMap$com$facebook$internal$FeatureManager$Feature[Feature.EventDeactivation.ordinal()] = 9;
            $SwitchMap$com$facebook$internal$FeatureManager$Feature[Feature.Core.ordinal()] = 10;
            $SwitchMap$com$facebook$internal$FeatureManager$Feature[Feature.AppEvents.ordinal()] = 11;
            $SwitchMap$com$facebook$internal$FeatureManager$Feature[Feature.CodelessEvents.ordinal()] = 12;
            $SwitchMap$com$facebook$internal$FeatureManager$Feature[Feature.Login.ordinal()] = 13;
            $SwitchMap$com$facebook$internal$FeatureManager$Feature[Feature.Share.ordinal()] = 14;
            try {
                $SwitchMap$com$facebook$internal$FeatureManager$Feature[Feature.Places.ordinal()] = 15;
            } catch (NoSuchFieldError unused) {
            }
        }
    }

    public interface Callback {
        void onCompleted(boolean z);
    }

    public enum Feature {
        Unknown(-1),
        Core(0),
        AppEvents(NativeProtocol.MESSAGE_GET_ACCESS_TOKEN_REQUEST),
        CodelessEvents(65792),
        RestrictiveDataFiltering(66048),
        AAM(66304),
        PrivacyProtection(66560),
        SuggestedEvents(66561),
        PIIFiltering(66562),
        EventDeactivation(66816),
        Instrument(131072),
        CrashReport(131328),
        ErrorReport(131584),
        Login(16777216),
        Share(33554432),
        Places(50331648);
        
        public final int code;

        /* access modifiers changed from: public */
        Feature(int i) {
            this.code = i;
        }

        public static Feature fromInt(int i) {
            Feature[] values = values();
            for (Feature feature : values) {
                if (feature.code == i) {
                    return feature;
                }
            }
            return Unknown;
        }

        public Feature getParent() {
            int i = this.code;
            if ((i & BaseProgressIndicator.MAX_ALPHA) > 0) {
                return fromInt(i & -256);
            }
            if ((65280 & i) > 0) {
                return fromInt(i & -65536);
            }
            if ((16711680 & i) > 0) {
                return fromInt(i & -16777216);
            }
            return fromInt(0);
        }

        public String toString() {
            switch (ordinal()) {
                case 1:
                    return "CoreKit";
                case 2:
                    return "AppEvents";
                case 3:
                    return "CodelessEvents";
                case 4:
                    return "RestrictiveDataFiltering";
                case 5:
                    return "AAM";
                case 6:
                    return "PrivacyProtection";
                case 7:
                    return "SuggestedEvents";
                case 8:
                    return "PIIFiltering";
                case 9:
                    return "EventDeactivation";
                case 10:
                    return "Instrument";
                case 11:
                    return "CrashReport";
                case 12:
                    return "ErrorReport";
                case 13:
                    return "LoginKit";
                case 14:
                    return "ShareKit";
                case 15:
                    return "PlacesKit";
                default:
                    return "unknown";
            }
        }
    }

    public static void checkFeature(final Feature feature, final Callback callback) {
        FetchedAppGateKeepersManager.loadAppGateKeepersAsync(new FetchedAppGateKeepersManager.Callback() {
            /* class com.facebook.internal.FeatureManager.AnonymousClass1 */

            @Override // com.facebook.internal.FetchedAppGateKeepersManager.Callback
            public void onCompleted() {
                callback.onCompleted(FeatureManager.isEnabled(feature));
            }
        });
    }

    public static boolean defaultStatus(Feature feature) {
        switch (feature.ordinal()) {
            case 4:
            case 5:
            case 6:
            case 7:
            case 8:
            case 9:
            case 10:
            case 11:
            case 12:
                return false;
            default:
                return true;
        }
    }

    public static boolean getGKStatus(Feature feature) {
        StringBuilder r0 = C1293.m3416("FBSDKFeature");
        r0.append(feature.toString());
        return FetchedAppGateKeepersManager.getGateKeeperForKey(r0.toString(), FacebookSdk.getApplicationId(), defaultStatus(feature));
    }

    public static boolean isEnabled(Feature feature) {
        if (Feature.Unknown == feature) {
            return false;
        }
        if (Feature.Core == feature) {
            return true;
        }
        Feature parent = feature.getParent();
        if (parent == feature) {
            return getGKStatus(feature);
        }
        if (!isEnabled(parent) || !getGKStatus(feature)) {
            return false;
        }
        return true;
    }
}
