package com.facebook.internal;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import com.appsflyer.share.Constants;
import com.facebook.FacebookSdk;
import ῲ.ᨨ.ῲ.C1806;

public class CustomTab {
    public Uri uri;

    public CustomTab(String str, Bundle bundle) {
        bundle = bundle == null ? new Bundle() : bundle;
        String dialogAuthority = ServerProtocol.getDialogAuthority();
        this.uri = Utility.buildUri(dialogAuthority, FacebookSdk.getGraphApiVersion() + Constants.URL_PATH_DELIMITER + ServerProtocol.DIALOG_PATH + str, bundle);
    }

    public void openCustomTab(Activity activity, String str) {
        Intent intent = new Intent("android.intent.action.VIEW");
        Bundle bundle = new Bundle();
        int i = Build.VERSION.SDK_INT;
        bundle.putBinder("android.support.customtabs.extra.SESSION", null);
        intent.putExtras(bundle);
        intent.putExtra("android.support.customtabs.extra.EXTRA_ENABLE_INSTANT_APPS", true);
        intent.setPackage(str);
        intent.addFlags(1073741824);
        intent.setData(this.uri);
        C1806.m4689(activity, intent, (Bundle) null);
    }
}
