package com.facebook.applinks;

import android.net.Uri;
import android.os.Bundle;
import com.facebook.AccessToken;
import com.facebook.FacebookRequestError;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ʬ.AbstractC0589;
import ʬ.AbstractC0605;
import ʬ.C0593;
import ʬ.C0595;

public class FacebookAppLinkResolver implements AbstractC0589 {
    public static final String APP_LINK_ANDROID_TARGET_KEY = "android";
    public static final String APP_LINK_KEY = "app_links";
    public static final String APP_LINK_TARGET_APP_NAME_KEY = "app_name";
    public static final String APP_LINK_TARGET_CLASS_KEY = "class";
    public static final String APP_LINK_TARGET_PACKAGE_KEY = "package";
    public static final String APP_LINK_TARGET_SHOULD_FALLBACK_KEY = "should_fallback";
    public static final String APP_LINK_TARGET_URL_KEY = "url";
    public static final String APP_LINK_WEB_TARGET_KEY = "web";
    public final HashMap<Uri, C0593> cachedAppLinks = new HashMap<>();

    public static C0593.C0594 getAndroidTargetFromJson(JSONObject jSONObject) {
        Uri uri = null;
        String tryGetStringFromJson = tryGetStringFromJson(jSONObject, APP_LINK_TARGET_PACKAGE_KEY, null);
        if (tryGetStringFromJson == null) {
            return null;
        }
        String tryGetStringFromJson2 = tryGetStringFromJson(jSONObject, APP_LINK_TARGET_CLASS_KEY, null);
        String tryGetStringFromJson3 = tryGetStringFromJson(jSONObject, "app_name", null);
        String tryGetStringFromJson4 = tryGetStringFromJson(jSONObject, "url", null);
        if (tryGetStringFromJson4 != null) {
            uri = Uri.parse(tryGetStringFromJson4);
        }
        return new C0593.C0594(tryGetStringFromJson, tryGetStringFromJson2, uri, tryGetStringFromJson3);
    }

    public static Uri getWebFallbackUriFromJson(Uri uri, JSONObject jSONObject) {
        try {
            JSONObject jSONObject2 = jSONObject.getJSONObject("web");
            if (!tryGetBooleanFromJson(jSONObject2, APP_LINK_TARGET_SHOULD_FALLBACK_KEY, true)) {
                return null;
            }
            String tryGetStringFromJson = tryGetStringFromJson(jSONObject2, "url", null);
            Uri parse = tryGetStringFromJson != null ? Uri.parse(tryGetStringFromJson) : null;
            return parse != null ? parse : uri;
        } catch (JSONException unused) {
            return uri;
        }
    }

    public static boolean tryGetBooleanFromJson(JSONObject jSONObject, String str, boolean z) {
        try {
            return jSONObject.getBoolean(str);
        } catch (JSONException unused) {
            return z;
        }
    }

    public static String tryGetStringFromJson(JSONObject jSONObject, String str, String str2) {
        try {
            return jSONObject.getString(str);
        } catch (JSONException unused) {
            return str2;
        }
    }

    public C0595<C0593> getAppLinkFromUrlInBackground(final Uri uri) {
        ArrayList arrayList = new ArrayList();
        arrayList.add(uri);
        return getAppLinkFromUrlsInBackground(arrayList).m2031(new AbstractC0605<Map<Uri, C0593>, C0593>() {
            /* class com.facebook.applinks.FacebookAppLinkResolver.AnonymousClass1 */

            @Override // ʬ.AbstractC0605
            public C0593 then(C0595<Map<Uri, C0593>> r2) throws Exception {
                return r2.m2030().get(uri);
            }
        });
    }

    public C0595<Map<Uri, C0593>> getAppLinkFromUrlsInBackground(List<Uri> list) {
        C0593 r5;
        final HashMap hashMap = new HashMap();
        final HashSet hashSet = new HashSet();
        StringBuilder sb = new StringBuilder();
        for (Uri uri : list) {
            synchronized (this.cachedAppLinks) {
                r5 = this.cachedAppLinks.get(uri);
            }
            if (r5 != null) {
                hashMap.put(uri, r5);
            } else {
                if (!hashSet.isEmpty()) {
                    sb.append(',');
                }
                sb.append(uri.toString());
                hashSet.add(uri);
            }
        }
        if (hashSet.isEmpty()) {
            return C0595.m2024(hashMap);
        }
        final C0595.C0596 r3 = new C0595.C0596(new C0595());
        Bundle bundle = new Bundle();
        bundle.putString("ids", sb.toString());
        bundle.putString("fields", String.format("%s.fields(%s,%s)", "app_links", "android", "web"));
        new GraphRequest(AccessToken.getCurrentAccessToken(), "", bundle, null, new GraphRequest.Callback() {
            /* class com.facebook.applinks.FacebookAppLinkResolver.AnonymousClass2 */

            @Override // com.facebook.GraphRequest.Callback
            public void onCompleted(GraphResponse graphResponse) {
                FacebookRequestError error = graphResponse.getError();
                if (error != null) {
                    r3.m2022((Exception) error.getException());
                    return;
                }
                JSONObject jSONObject = graphResponse.getJSONObject();
                if (jSONObject == null) {
                    r3.m2023(hashMap);
                    return;
                }
                Iterator it2 = hashSet.iterator();
                while (it2.hasNext()) {
                    Uri uri = (Uri) it2.next();
                    if (jSONObject.has(uri.toString())) {
                        try {
                            JSONObject jSONObject2 = jSONObject.getJSONObject(uri.toString()).getJSONObject("app_links");
                            JSONArray jSONArray = jSONObject2.getJSONArray("android");
                            int length = jSONArray.length();
                            ArrayList arrayList = new ArrayList(length);
                            for (int i = 0; i < length; i++) {
                                C0593.C0594 androidTargetFromJson = FacebookAppLinkResolver.getAndroidTargetFromJson(jSONArray.getJSONObject(i));
                                if (androidTargetFromJson != null) {
                                    arrayList.add(androidTargetFromJson);
                                }
                            }
                            C0593 r3 = new C0593(uri, arrayList, FacebookAppLinkResolver.getWebFallbackUriFromJson(uri, jSONObject2));
                            hashMap.put(uri, r3);
                            synchronized (FacebookAppLinkResolver.this.cachedAppLinks) {
                                FacebookAppLinkResolver.this.cachedAppLinks.put(uri, r3);
                            }
                        } catch (JSONException unused) {
                            continue;
                        }
                    }
                }
                r3.m2023(hashMap);
            }
        }).executeAsync();
        return r3.f3541;
    }
}
