package com.facebook.appevents.internal;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;
import com.facebook.FacebookSdk;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

public class InAppPurchaseActivityLifecycleTracker {
    public static final String BILLING_ACTIVITY_NAME = "com.android.billingclient.api.ProxyBillingActivity";
    public static final String SERVICE_INTERFACE_NAME = "com.android.vending.billing.IInAppBillingService$Stub";
    public static final String TAG = "com.facebook.appevents.internal.InAppPurchaseActivityLifecycleTracker";
    public static Application.ActivityLifecycleCallbacks callbacks;
    public static Boolean hasBiillingActivity = null;
    public static Boolean hasBillingService = null;
    public static Object inAppBillingObj;
    public static Intent intent;
    public static final AtomicBoolean isTracking = new AtomicBoolean(false);
    public static ServiceConnection serviceConnection;

    public static void initializeIfNotInitialized() {
        if (hasBillingService == null) {
            try {
                Class.forName("com.android.vending.billing.IInAppBillingService$Stub");
                hasBillingService = true;
                try {
                    Class.forName(BILLING_ACTIVITY_NAME);
                    hasBiillingActivity = true;
                } catch (ClassNotFoundException unused) {
                    hasBiillingActivity = false;
                }
                InAppPurchaseEventManager.clearSkuDetailsCache();
                intent = new Intent("com.android.vending.billing.InAppBillingService.BIND").setPackage("com.android.vending");
                serviceConnection = new ServiceConnection() {
                    /* class com.facebook.appevents.internal.InAppPurchaseActivityLifecycleTracker.AnonymousClass1 */

                    public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                        Object unused = InAppPurchaseActivityLifecycleTracker.inAppBillingObj = InAppPurchaseEventManager.asInterface(FacebookSdk.getApplicationContext(), iBinder);
                    }

                    public void onServiceDisconnected(ComponentName componentName) {
                    }
                };
                callbacks = new Application.ActivityLifecycleCallbacks() {
                    /* class com.facebook.appevents.internal.InAppPurchaseActivityLifecycleTracker.AnonymousClass2 */

                    public void onActivityCreated(Activity activity, Bundle bundle) {
                    }

                    public void onActivityDestroyed(Activity activity) {
                    }

                    public void onActivityPaused(Activity activity) {
                    }

                    public void onActivityResumed(Activity activity) {
                        try {
                            FacebookSdk.getExecutor().execute(new Runnable() {
                                /* class com.facebook.appevents.internal.InAppPurchaseActivityLifecycleTracker.AnonymousClass2.AnonymousClass1 */

                                public void run() {
                                    Context applicationContext = FacebookSdk.getApplicationContext();
                                    InAppPurchaseActivityLifecycleTracker.logPurchase(applicationContext, InAppPurchaseEventManager.getPurchasesInapp(applicationContext, InAppPurchaseActivityLifecycleTracker.inAppBillingObj), false);
                                    InAppPurchaseActivityLifecycleTracker.logPurchase(applicationContext, InAppPurchaseEventManager.getPurchasesSubs(applicationContext, InAppPurchaseActivityLifecycleTracker.inAppBillingObj), true);
                                }
                            });
                        } catch (Exception unused) {
                        }
                    }

                    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
                    }

                    public void onActivityStarted(Activity activity) {
                    }

                    public void onActivityStopped(Activity activity) {
                        try {
                            if (InAppPurchaseActivityLifecycleTracker.hasBiillingActivity.booleanValue() && activity.getLocalClassName().equals(InAppPurchaseActivityLifecycleTracker.BILLING_ACTIVITY_NAME)) {
                                FacebookSdk.getExecutor().execute(new Runnable() {
                                    /* class com.facebook.appevents.internal.InAppPurchaseActivityLifecycleTracker.AnonymousClass2.AnonymousClass2 */

                                    public void run() {
                                        Context applicationContext = FacebookSdk.getApplicationContext();
                                        ArrayList<String> purchasesInapp = InAppPurchaseEventManager.getPurchasesInapp(applicationContext, InAppPurchaseActivityLifecycleTracker.inAppBillingObj);
                                        if (purchasesInapp.isEmpty()) {
                                            purchasesInapp = InAppPurchaseEventManager.getPurchaseHistoryInapp(applicationContext, InAppPurchaseActivityLifecycleTracker.inAppBillingObj);
                                        }
                                        InAppPurchaseActivityLifecycleTracker.logPurchase(applicationContext, purchasesInapp, false);
                                    }
                                });
                            }
                        } catch (Exception unused) {
                        }
                    }
                };
            } catch (ClassNotFoundException unused2) {
                hasBillingService = false;
            }
        }
    }

    public static void logPurchase(Context context, ArrayList<String> arrayList, boolean z) {
        if (!arrayList.isEmpty()) {
            HashMap hashMap = new HashMap();
            ArrayList arrayList2 = new ArrayList();
            Iterator<String> it2 = arrayList.iterator();
            while (it2.hasNext()) {
                String next = it2.next();
                try {
                    String string = new JSONObject(next).getString("productId");
                    hashMap.put(string, next);
                    arrayList2.add(string);
                } catch (JSONException e) {
                    Log.e(TAG, "Error parsing in-app purchase data.", e);
                }
            }
            for (Map.Entry<String, String> entry : InAppPurchaseEventManager.getSkuDetails(context, arrayList2, inAppBillingObj, z).entrySet()) {
                AutomaticAnalyticsLogger.logPurchase((String) hashMap.get(entry.getKey()), entry.getValue(), z);
            }
        }
    }

    public static void startTracking() {
        if (isTracking.compareAndSet(false, true)) {
            Context applicationContext = FacebookSdk.getApplicationContext();
            if (applicationContext instanceof Application) {
                ((Application) applicationContext).registerActivityLifecycleCallbacks(callbacks);
                applicationContext.bindService(intent, serviceConnection, 1);
            }
        }
    }

    public static void update() {
        initializeIfNotInitialized();
        if (hasBillingService.booleanValue() && AutomaticAnalyticsLogger.isImplicitPurchaseLoggingEnabled()) {
            startTracking();
        }
    }
}
