package com.facebook.appevents.codeless.internal;

import android.util.Log;

public class UnityReflection {
    public static final String CAPTURE_VIEW_HIERARCHY_METHOD = "CaptureViewHierarchy";
    public static final String EVENT_MAPPING_METHOD = "OnReceiveMapping";
    public static final String FB_UNITY_GAME_OBJECT = "UnityFacebookSDKPlugin";
    public static final String TAG = "com.facebook.appevents.codeless.internal.UnityReflection";
    public static final String UNITY_PLAYER_CLASS = "com.unity3d.player.UnityPlayer";
    public static final String UNITY_SEND_MESSAGE_METHOD = "UnitySendMessage";
    public static Class<?> unityPlayer;

    public static void captureViewHierarchy() {
        sendMessage(FB_UNITY_GAME_OBJECT, CAPTURE_VIEW_HIERARCHY_METHOD, "");
    }

    public static void sendEventMapping(String str) {
        sendMessage(FB_UNITY_GAME_OBJECT, EVENT_MAPPING_METHOD, str);
    }

    public static void sendMessage(String str, String str2, String str3) {
        try {
            if (unityPlayer == null) {
                unityPlayer = Class.forName(UNITY_PLAYER_CLASS);
            }
            unityPlayer.getMethod(UNITY_SEND_MESSAGE_METHOD, String.class, String.class, String.class).invoke(unityPlayer, str, str2, str3);
        } catch (Exception e) {
            Log.e(TAG, "Failed to send message to Unity", e);
        }
    }
}
