package com.facebook;

import ඓ.K.K.K.C1293;

public class FacebookGraphResponseException extends FacebookException {
    public final GraphResponse graphResponse;

    public FacebookGraphResponseException(GraphResponse graphResponse2, String str) {
        super(str);
        this.graphResponse = graphResponse2;
    }

    public final GraphResponse getGraphResponse() {
        return this.graphResponse;
    }

    @Override // com.facebook.FacebookException
    public final String toString() {
        GraphResponse graphResponse2 = this.graphResponse;
        FacebookRequestError error = graphResponse2 != null ? graphResponse2.getError() : null;
        StringBuilder r1 = C1293.m3416("{FacebookGraphResponseException: ");
        String message = getMessage();
        if (message != null) {
            r1.append(message);
            r1.append(" ");
        }
        if (error != null) {
            r1.append("httpResponseCode: ");
            r1.append(error.getRequestStatusCode());
            r1.append(", facebookErrorCode: ");
            r1.append(error.getErrorCode());
            r1.append(", facebookErrorType: ");
            r1.append(error.getErrorType());
            r1.append(", message: ");
            r1.append(error.getErrorMessage());
            r1.append("}");
        }
        return r1.toString();
    }
}
