package com.bumptech.glide.request;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.util.Log;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import java.util.List;
import java.util.concurrent.Executor;
import ඓ.ῲ.K.C1220;
import ඓ.ῲ.K.ᓣ.C0845;
import ඓ.ῲ.K.ᓣ.C0847;
import ඓ.ῲ.K.ᓣ.ᕣ.AbstractC0836;
import ඓ.ῲ.K.ᕣ.ᕣ.ඓ.C0898;
import ඓ.ῲ.K.ᕣ.ᨨ.AbstractC1027;
import ඓ.ῲ.K.ᕣ.ᨨ.C1013;
import ඓ.ῲ.K.㗗.AbstractC1189;
import ඓ.ῲ.K.㗗.AbstractC1198;
import ඓ.ῲ.K.㗗.AbstractC1199;
import ඓ.ῲ.K.㗗.AbstractC1200;
import ඓ.ῲ.K.㗗.ᨨ.AbstractC1191;
import ඓ.ῲ.K.㗗.ᨨ.C1194;
import ඓ.ῲ.K.㗗.㿎.AbstractC1207;
import ඓ.ῲ.K.㗗.㿎.AbstractC1211;
import ඓ.K.K.K.C1293;

public final class SingleRequest<R> implements AbstractC1189, AbstractC1207, AbstractC1199 {

    /* renamed from: ᝁ  reason: contains not printable characters */
    public static final boolean f2258 = Log.isLoggable("Request", 2);

    /* renamed from: ʬ  reason: contains not printable characters */
    public final Object f2259;

    /* renamed from: Ԕ  reason: contains not printable characters */
    public final AbstractC1211<R> f2260;

    /* renamed from: Ԛ  reason: contains not printable characters */
    public volatile C1013 f2261;

    /* renamed from: ؿ  reason: contains not printable characters */
    public final AbstractC1191<? super R> f2262;

    /* renamed from: ݜ  reason: contains not printable characters */
    public C1013.C1019 f2263;

    /* renamed from: ඓ  reason: contains not printable characters */
    public final RequestCoordinator f2264;

    /* renamed from: ᑓ  reason: contains not printable characters */
    public Drawable f2265;

    /* renamed from: ᓆ  reason: contains not printable characters */
    public Drawable f2266;

    /* renamed from: ᓣ  reason: contains not printable characters */
    public final Executor f2267;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public final int f2268;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public final Class<R> f2269;

    /* renamed from: ῲ  reason: contains not printable characters */
    public final AbstractC0836 f2270;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public final C1220 f2271;

    /* renamed from: K  reason: contains not printable characters */
    public final String f2272;

    /* renamed from: ゎ  reason: contains not printable characters */
    public int f2273;

    /* renamed from: ト  reason: contains not printable characters */
    public int f2274;

    /* renamed from: 㑃  reason: contains not printable characters */
    public final int f2275;

    /* renamed from: 㗗  reason: contains not printable characters */
    public final List<AbstractC1200<R>> f2276;

    /* renamed from: 㗽  reason: contains not printable characters */
    public AbstractC1027<R> f2277;

    /* renamed from: 㮔  reason: contains not printable characters */
    public boolean f2278;

    /* renamed from: 㳳  reason: contains not printable characters */
    public final AbstractC1198<?> f2279;

    /* renamed from: 㴪  reason: contains not printable characters */
    public Drawable f2280;

    /* renamed from: 㴹  reason: contains not printable characters */
    public final Context f2281;

    /* renamed from: 㶋  reason: contains not printable characters */
    public Status f2282;

    /* renamed from: 㸾  reason: contains not printable characters */
    public final AbstractC1200<R> f2283;

    /* renamed from: 㿎  reason: contains not printable characters */
    public final Object f2284;

    /* renamed from: 䀟  reason: contains not printable characters */
    public long f2285;

    /* renamed from: 䁗  reason: contains not printable characters */
    public final Priority f2286;

    /* renamed from: 䃖  reason: contains not printable characters */
    public RuntimeException f2287;

    public enum Status {
        PENDING,
        RUNNING,
        WAITING_FOR_SIZE,
        COMPLETE,
        FAILED,
        CLEARED
    }

    public SingleRequest(Context context, C1220 r5, Object obj, Object obj2, Class<R> cls, AbstractC1198<?> k, int i, int i2, Priority priority, AbstractC1211<R> r13, AbstractC1200<R> r14, List<AbstractC1200<R>> list, RequestCoordinator requestCoordinator, C1013 r17, AbstractC1191<? super R> r18, Executor executor) {
        this.f2272 = f2258 ? String.valueOf(super.hashCode()) : null;
        this.f2270 = new AbstractC0836.C0837();
        this.f2259 = obj;
        this.f2281 = context;
        this.f2271 = r5;
        this.f2284 = obj2;
        this.f2269 = cls;
        this.f2279 = k;
        this.f2268 = i;
        this.f2275 = i2;
        this.f2286 = priority;
        this.f2260 = r13;
        this.f2283 = r14;
        this.f2276 = list;
        this.f2264 = requestCoordinator;
        this.f2261 = r17;
        this.f2262 = r18;
        this.f2267 = executor;
        this.f2282 = Status.PENDING;
        if (this.f2287 == null && r5.f4855) {
            this.f2287 = new RuntimeException("Glide request origin trace");
        }
    }

    /* JADX WARNING: Code restructure failed: missing block: B:25:0x0052, code lost:
        if (r1 == null) goto L_?;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:26:0x0054, code lost:
        r4.f2261.m2825(r1);
     */
    /* JADX WARNING: Code restructure failed: missing block: B:30:?, code lost:
        return;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:31:?, code lost:
        return;
     */
    /* JADX WARNING: Removed duplicated region for block: B:22:0x0044  */
    @Override // ඓ.ῲ.K.㗗.AbstractC1189
    public void clear() {
        AbstractC1027<R> r1;
        boolean z;
        synchronized (this.f2259) {
            m1338();
            this.f2270.m2431();
            if (this.f2282 != Status.CLEARED) {
                m1338();
                this.f2270.m2431();
                this.f2260.m3273((AbstractC1207) this);
                C1013.C1019 r12 = this.f2263;
                if (r12 != null) {
                    r12.m2830();
                    this.f2263 = null;
                }
                if (this.f2277 != null) {
                    r1 = this.f2277;
                    this.f2277 = null;
                } else {
                    r1 = null;
                }
                RequestCoordinator requestCoordinator = this.f2264;
                if (requestCoordinator != null) {
                    if (!requestCoordinator.m1335(this)) {
                        z = false;
                        if (z) {
                            this.f2260.m3267(m1341());
                        }
                        this.f2282 = Status.CLEARED;
                    }
                }
                z = true;
                if (z) {
                }
                this.f2282 = Status.CLEARED;
            }
        }
    }

    @Override // ඓ.ῲ.K.㗗.AbstractC1189
    public boolean isRunning() {
        boolean z;
        synchronized (this.f2259) {
            if (this.f2282 != Status.RUNNING) {
                if (this.f2282 != Status.WAITING_FOR_SIZE) {
                    z = false;
                }
            }
            z = true;
        }
        return z;
    }

    @Override // ඓ.ῲ.K.㗗.AbstractC1189
    public void pause() {
        synchronized (this.f2259) {
            if (isRunning()) {
                clear();
            }
        }
    }

    @Override // ඓ.ῲ.K.㗗.AbstractC1189
    /* renamed from: ʬ  reason: contains not printable characters */
    public boolean m1337() {
        boolean z;
        synchronized (this.f2259) {
            z = this.f2282 == Status.COMPLETE;
        }
        return z;
    }

    /* renamed from: ඓ  reason: contains not printable characters */
    public final void m1338() {
        if (this.f2278) {
            throw new IllegalStateException("You can't start or clear loads in RequestListener or Target callbacks. If you're trying to start a fallback request when a load fails, use RequestBuilder#error(RequestBuilder). Otherwise consider posting your into() or clear() calls to the main thread using a Handler instead.");
        }
    }

    /* renamed from: ᨨ  reason: contains not printable characters */
    public final void m1339() {
        int i;
        RequestCoordinator requestCoordinator = this.f2264;
        if (requestCoordinator == null || requestCoordinator.m1332(this)) {
            Drawable drawable = null;
            if (this.f2284 == null) {
                drawable = m1350();
            }
            if (drawable == null) {
                if (this.f2266 == null) {
                    AbstractC1198<?> k = this.f2279;
                    this.f2266 = k.f4760;
                    if (this.f2266 == null && (i = k.f4752) > 0) {
                        this.f2266 = m1342(i);
                    }
                }
                drawable = this.f2266;
            }
            if (drawable == null) {
                drawable = m1341();
            }
            this.f2260.m3268(drawable);
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:38:0x0088  */
    @Override // ඓ.ῲ.K.㗗.AbstractC1189
    /* renamed from: ῲ  reason: contains not printable characters */
    public void m1340() {
        boolean z;
        synchronized (this.f2259) {
            m1338();
            this.f2270.m2431();
            this.f2285 = C0847.m2463();
            if (this.f2284 == null) {
                if (C0845.m2460(this.f2268, this.f2275)) {
                    this.f2273 = this.f2268;
                    this.f2274 = this.f2275;
                }
                m1344(new GlideException("Received null model"), m1350() == null ? 5 : 3);
            } else if (this.f2282 == Status.RUNNING) {
                throw new IllegalArgumentException("Cannot restart a running request");
            } else if (this.f2282 == Status.COMPLETE) {
                m1346((AbstractC1027<?>) this.f2277, DataSource.MEMORY_CACHE);
            } else {
                this.f2282 = Status.WAITING_FOR_SIZE;
                if (C0845.m2460(this.f2268, this.f2275)) {
                    m1343(this.f2268, this.f2275);
                } else {
                    this.f2260.m3269(this);
                }
                if (this.f2282 == Status.RUNNING || this.f2282 == Status.WAITING_FOR_SIZE) {
                    RequestCoordinator requestCoordinator = this.f2264;
                    if (requestCoordinator != null) {
                        if (!requestCoordinator.m1332(this)) {
                            z = false;
                            if (z) {
                                this.f2260.m3270(m1341());
                            }
                        }
                    }
                    z = true;
                    if (z) {
                    }
                }
                if (f2258) {
                    m1345("finished run method in " + C0847.m2462(this.f2285));
                }
            }
        }
    }

    /* renamed from: ⁱ  reason: contains not printable characters */
    public final Drawable m1341() {
        int i;
        if (this.f2280 == null) {
            AbstractC1198<?> k = this.f2279;
            this.f2280 = k.f4763;
            if (this.f2280 == null && (i = k.f4750) > 0) {
                this.f2280 = m1342(i);
            }
        }
        return this.f2280;
    }

    @Override // ඓ.ῲ.K.㗗.AbstractC1189
    /* renamed from: K  reason: contains not printable characters */
    public boolean m1348() {
        boolean z;
        synchronized (this.f2259) {
            z = this.f2282 == Status.COMPLETE;
        }
        return z;
    }

    /* renamed from: 㴹  reason: contains not printable characters */
    public final Drawable m1350() {
        int i;
        if (this.f2265 == null) {
            AbstractC1198<?> k = this.f2279;
            this.f2265 = k.f4743;
            if (this.f2265 == null && (i = k.f4748) > 0) {
                this.f2265 = m1342(i);
            }
        }
        return this.f2265;
    }

    @Override // ඓ.ῲ.K.㗗.AbstractC1189
    /* renamed from: 㸾  reason: contains not printable characters */
    public boolean m1351() {
        boolean z;
        synchronized (this.f2259) {
            z = this.f2282 == Status.CLEARED;
        }
        return z;
    }

    /* renamed from: 㿎  reason: contains not printable characters */
    public final boolean m1352() {
        RequestCoordinator requestCoordinator = this.f2264;
        return requestCoordinator == null || !requestCoordinator.getRoot().m1334();
    }

    /* renamed from: K  reason: contains not printable characters */
    public final Drawable m1342(int i) {
        Resources.Theme theme = this.f2279.f4761;
        if (theme == null) {
            theme = this.f2281.getTheme();
        }
        C1220 r1 = this.f2271;
        return C0898.m2580(r1, r1, i, theme);
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m1343(int i, int i2) {
        Object obj;
        int i3;
        int i4 = i;
        this.f2270.m2431();
        Object obj2 = this.f2259;
        synchronized (obj2) {
            try {
                if (f2258) {
                    m1345("Got onSizeReady in " + C0847.m2462(this.f2285));
                }
                if (this.f2282 == Status.WAITING_FOR_SIZE) {
                    this.f2282 = Status.RUNNING;
                    float f = this.f2279.f4740;
                    if (i4 != Integer.MIN_VALUE) {
                        i4 = Math.round(((float) i4) * f);
                    }
                    this.f2273 = i4;
                    if (i2 == Integer.MIN_VALUE) {
                        i3 = i2;
                    } else {
                        i3 = Math.round(f * ((float) i2));
                    }
                    this.f2274 = i3;
                    if (f2258) {
                        m1345("finished setup for calling load in " + C0847.m2462(this.f2285));
                    }
                    obj = obj2;
                    try {
                        this.f2263 = this.f2261.m2821(this.f2271, this.f2284, this.f2279.f4765, this.f2273, this.f2274, this.f2279.f4764, this.f2269, this.f2286, this.f2279.f4762, this.f2279.f4744, this.f2279.f4741, this.f2279.f4753, this.f2279.f4757, this.f2279.f4758, this.f2279.f4759, this.f2279.f4754, this.f2279.f4746, this, this.f2267);
                        if (this.f2282 != Status.RUNNING) {
                            this.f2263 = null;
                        }
                        if (f2258) {
                            m1345("finished onSizeReady in " + C0847.m2462(this.f2285));
                        }
                    } catch (Throwable th) {
                        th = th;
                        throw th;
                    }
                }
            } catch (Throwable th2) {
                th = th2;
                obj = obj2;
                throw th;
            }
        }
    }

    /* JADX DEBUG: Multi-variable search result rejected for r6v0, resolved type: com.bumptech.glide.request.SingleRequest<R> */
    /* JADX WARN: Multi-variable type inference failed */
    /* renamed from: K  reason: contains not printable characters */
    public void m1346(AbstractC1027<?> r7, DataSource dataSource) {
        Throwable th;
        Throwable th2;
        this.f2270.m2431();
        AbstractC1027<?> r0 = null;
        try {
            synchronized (this.f2259) {
                try {
                    this.f2263 = null;
                    if (r7 == null) {
                        m1344(new GlideException("Expected to receive a Resource<R> with an object of " + this.f2269 + " inside, but instead got null."), 5);
                        return;
                    }
                    Object obj = r7.get();
                    if (obj != null) {
                        if (this.f2269.isAssignableFrom(obj.getClass())) {
                            RequestCoordinator requestCoordinator = this.f2264;
                            if (!(requestCoordinator == null || requestCoordinator.m1333(this))) {
                                try {
                                    this.f2277 = null;
                                    this.f2282 = Status.COMPLETE;
                                    this.f2261.m2825(r7);
                                    return;
                                } catch (Throwable th3) {
                                    th2 = th3;
                                    try {
                                        throw th2;
                                    } catch (Throwable th4) {
                                        th = th4;
                                        r0 = r7;
                                    }
                                }
                            } else {
                                m1347(r7, obj, dataSource);
                                return;
                            }
                        }
                    }
                    this.f2277 = null;
                    StringBuilder sb = new StringBuilder();
                    sb.append("Expected to receive an object of ");
                    sb.append(this.f2269);
                    sb.append(" but instead got ");
                    sb.append(obj != null ? obj.getClass() : "");
                    sb.append("{");
                    sb.append(obj);
                    sb.append("} inside Resource{");
                    sb.append(r7);
                    sb.append("}.");
                    sb.append(obj != null ? "" : " To indicate failure return a null Resource object, rather than a Resource object containing null data.");
                    m1344(new GlideException(sb.toString()), 5);
                    this.f2261.m2825(r7);
                } catch (Throwable th5) {
                    th2 = th5;
                    r7 = null;
                    throw th2;
                }
            }
        } catch (Throwable th6) {
            th = th6;
            if (r0 != null) {
                this.f2261.m2825(r0);
            }
            throw th;
        }
    }

    /* JADX INFO: finally extract failed */
    /* renamed from: K  reason: contains not printable characters */
    public final void m1347(AbstractC1027<R> r11, R r, DataSource dataSource) {
        boolean z;
        boolean r6 = m1352();
        this.f2282 = Status.COMPLETE;
        this.f2277 = r11;
        if (this.f2271.f4848 <= 3) {
            StringBuilder r112 = C1293.m3416("Finished loading ");
            r112.append(r.getClass().getSimpleName());
            r112.append(" from ");
            r112.append(dataSource);
            r112.append(" for ");
            r112.append(this.f2284);
            r112.append(" with size [");
            r112.append(this.f2273);
            r112.append("x");
            r112.append(this.f2274);
            r112.append("] in ");
            r112.append(C0847.m2462(this.f2285));
            r112.append(" ms");
            Log.d("Glide", r112.toString());
        }
        boolean z2 = true;
        this.f2278 = true;
        try {
            if (this.f2276 != null) {
                z = false;
                for (AbstractC1200<R> r0 : this.f2276) {
                    z |= r0.m3232(r, this.f2284, this.f2260, dataSource, r6);
                }
            } else {
                z = false;
            }
            if (this.f2283 == null || !this.f2283.m3232(r, this.f2284, this.f2260, dataSource, r6)) {
                z2 = false;
            }
            if (!z2 && !z) {
                this.f2260.m3271(r, ((C1194.C1195) this.f2262).m3184(dataSource, r6));
            }
            this.f2278 = false;
            RequestCoordinator requestCoordinator = this.f2264;
            if (requestCoordinator != null) {
                requestCoordinator.m1336(this);
            }
        } catch (Throwable th) {
            this.f2278 = false;
            throw th;
        }
    }

    /* JADX INFO: finally extract failed */
    /* renamed from: K  reason: contains not printable characters */
    public final void m1344(GlideException glideException, int i) {
        boolean z;
        this.f2270.m2431();
        synchronized (this.f2259) {
            glideException.setOrigin(this.f2287);
            int i2 = this.f2271.f4848;
            if (i2 <= i) {
                Log.w("Glide", "Load failed for " + this.f2284 + " with size [" + this.f2273 + "x" + this.f2274 + "]", glideException);
                if (i2 <= 4) {
                    glideException.logRootCauses("Glide");
                }
            }
            this.f2263 = null;
            this.f2282 = Status.FAILED;
            boolean z2 = true;
            this.f2278 = true;
            try {
                if (this.f2276 != null) {
                    z = false;
                    for (AbstractC1200<R> r4 : this.f2276) {
                        z |= r4.m3231(glideException, this.f2284, this.f2260, m1352());
                    }
                } else {
                    z = false;
                }
                if (this.f2283 == null || !this.f2283.m3231(glideException, this.f2284, this.f2260, m1352())) {
                    z2 = false;
                }
                if (!z && !z2) {
                    m1339();
                }
                this.f2278 = false;
                RequestCoordinator requestCoordinator = this.f2264;
                if (requestCoordinator != null) {
                    requestCoordinator.m1331(this);
                }
            } catch (Throwable th) {
                this.f2278 = false;
                throw th;
            }
        }
    }

    @Override // ඓ.ῲ.K.㗗.AbstractC1189
    /* renamed from: K  reason: contains not printable characters */
    public boolean m1349(AbstractC1189 r18) {
        int i;
        int i2;
        Object obj;
        Class<R> cls;
        AbstractC1198<?> k;
        Priority priority;
        int size;
        int i3;
        int i4;
        Object obj2;
        Class<R> cls2;
        AbstractC1198<?> k2;
        Priority priority2;
        int size2;
        if (!(r18 instanceof SingleRequest)) {
            return false;
        }
        synchronized (this.f2259) {
            i = this.f2268;
            i2 = this.f2275;
            obj = this.f2284;
            cls = this.f2269;
            k = this.f2279;
            priority = this.f2286;
            size = this.f2276 != null ? this.f2276.size() : 0;
        }
        SingleRequest singleRequest = (SingleRequest) r18;
        synchronized (singleRequest.f2259) {
            i3 = singleRequest.f2268;
            i4 = singleRequest.f2275;
            obj2 = singleRequest.f2284;
            cls2 = singleRequest.f2269;
            k2 = singleRequest.f2279;
            priority2 = singleRequest.f2286;
            List<AbstractC1200<R>> list = singleRequest.f2276;
            size2 = list != null ? list.size() : 0;
        }
        return i == i3 && i2 == i4 && C0845.m2461(obj, obj2) && cls.equals(cls2) && k.equals(k2) && priority == priority2 && size == size2;
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m1345(String str) {
        StringBuilder r2 = C1293.m3402(str, " this: ");
        r2.append(this.f2272);
        Log.v("Request", r2.toString());
    }
}
