package com.bumptech.glide.load.resource.bitmap;

import android.util.Log;
import com.bumptech.glide.load.ImageHeaderParser;
import com.google.android.material.progressindicator.BaseProgressIndicator;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import ඓ.ῲ.K.ᕣ.ᨨ.ゎ.AbstractC0967;
import ඓ.ῲ.K.ᕣ.ᨨ.ゎ.C0964;
import ῲ.ᨨ.㳳.C1841;

public final class DefaultImageHeaderParser implements ImageHeaderParser {

    /* renamed from: ῲ  reason: contains not printable characters */
    public static final int[] f2238 = {0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};

    /* renamed from: K  reason: contains not printable characters */
    public static final byte[] f2239 = "Exif\u0000\u0000".getBytes(Charset.forName("UTF-8"));

    public interface Reader {

        public static final class EndOfFileException extends IOException {
            public static final long serialVersionUID = 1;

            public EndOfFileException() {
                super("Unexpectedly reached end of a file");
            }
        }

        long skip(long j) throws IOException;

        /* renamed from: ῲ  reason: contains not printable characters */
        short m1305() throws IOException;

        /* renamed from: K  reason: contains not printable characters */
        int m1306() throws IOException;

        /* renamed from: K  reason: contains not printable characters */
        int m1307(byte[] bArr, int i) throws IOException;
    }

    /* renamed from: com.bumptech.glide.load.resource.bitmap.DefaultImageHeaderParser$ʬ  reason: contains not printable characters */
    public static final class C0337 implements Reader {

        /* renamed from: K  reason: contains not printable characters */
        public final InputStream f2240;

        public C0337(InputStream inputStream) {
            this.f2240 = inputStream;
        }

        @Override // com.bumptech.glide.load.resource.bitmap.DefaultImageHeaderParser.Reader
        public long skip(long j) throws IOException {
            if (j < 0) {
                return 0;
            }
            long j2 = j;
            while (j2 > 0) {
                long skip = this.f2240.skip(j2);
                if (skip <= 0) {
                    if (this.f2240.read() == -1) {
                        break;
                    }
                    skip = 1;
                }
                j2 -= skip;
            }
            return j - j2;
        }

        @Override // com.bumptech.glide.load.resource.bitmap.DefaultImageHeaderParser.Reader
        /* renamed from: ῲ  reason: contains not printable characters */
        public short m1308() throws IOException {
            int read = this.f2240.read();
            if (read != -1) {
                return (short) read;
            }
            throw new Reader.EndOfFileException();
        }

        @Override // com.bumptech.glide.load.resource.bitmap.DefaultImageHeaderParser.Reader
        /* renamed from: K  reason: contains not printable characters */
        public int m1309() throws IOException {
            return (m1308() << 8) | m1308();
        }

        @Override // com.bumptech.glide.load.resource.bitmap.DefaultImageHeaderParser.Reader
        /* renamed from: K  reason: contains not printable characters */
        public int m1310(byte[] bArr, int i) throws IOException {
            int i2 = 0;
            int i3 = 0;
            while (i2 < i && (i3 = this.f2240.read(bArr, i2, i - i2)) != -1) {
                i2 += i3;
            }
            if (i2 != 0 || i3 != -1) {
                return i2;
            }
            throw new Reader.EndOfFileException();
        }
    }

    /* renamed from: com.bumptech.glide.load.resource.bitmap.DefaultImageHeaderParser$ῲ  reason: contains not printable characters */
    public static final class C0338 {

        /* renamed from: K  reason: contains not printable characters */
        public final ByteBuffer f2241;

        public C0338(byte[] bArr, int i) {
            this.f2241 = (ByteBuffer) ByteBuffer.wrap(bArr).order(ByteOrder.BIG_ENDIAN).limit(i);
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public int m1311(int i) {
            if (this.f2241.remaining() - i >= 4) {
                return this.f2241.getInt(i);
            }
            return -1;
        }

        /* renamed from: K  reason: contains not printable characters */
        public int m1312() {
            return this.f2241.remaining();
        }

        /* renamed from: K  reason: contains not printable characters */
        public short m1313(int i) {
            if (this.f2241.remaining() - i >= 2) {
                return this.f2241.getShort(i);
            }
            return -1;
        }
    }

    /* renamed from: com.bumptech.glide.load.resource.bitmap.DefaultImageHeaderParser$K  reason: contains not printable characters */
    public static final class C0339 implements Reader {

        /* renamed from: K  reason: contains not printable characters */
        public final ByteBuffer f2242;

        public C0339(ByteBuffer byteBuffer) {
            this.f2242 = byteBuffer;
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        }

        @Override // com.bumptech.glide.load.resource.bitmap.DefaultImageHeaderParser.Reader
        public long skip(long j) {
            int min = (int) Math.min((long) this.f2242.remaining(), j);
            ByteBuffer byteBuffer = this.f2242;
            byteBuffer.position(byteBuffer.position() + min);
            return (long) min;
        }

        @Override // com.bumptech.glide.load.resource.bitmap.DefaultImageHeaderParser.Reader
        /* renamed from: ῲ  reason: contains not printable characters */
        public short m1314() throws Reader.EndOfFileException {
            if (this.f2242.remaining() >= 1) {
                return (short) (this.f2242.get() & 255);
            }
            throw new Reader.EndOfFileException();
        }

        @Override // com.bumptech.glide.load.resource.bitmap.DefaultImageHeaderParser.Reader
        /* renamed from: K  reason: contains not printable characters */
        public int m1315() throws Reader.EndOfFileException {
            return (m1314() << 8) | m1314();
        }

        @Override // com.bumptech.glide.load.resource.bitmap.DefaultImageHeaderParser.Reader
        /* renamed from: K  reason: contains not printable characters */
        public int m1316(byte[] bArr, int i) {
            int min = Math.min(i, this.f2242.remaining());
            if (min == 0) {
                return -1;
            }
            this.f2242.get(bArr, 0, min);
            return min;
        }
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public final int m1299(Reader reader) throws IOException {
        short r0;
        int r1;
        long j;
        long skip;
        do {
            short r02 = reader.m1305();
            if (r02 != 255) {
                if (Log.isLoggable("DfltImageHeaderParser", 3)) {
                    Log.d("DfltImageHeaderParser", "Unknown segmentId=" + ((int) r02));
                }
                return -1;
            }
            r0 = reader.m1305();
            if (r0 == 218) {
                return -1;
            }
            if (r0 == 217) {
                if (Log.isLoggable("DfltImageHeaderParser", 3)) {
                    Log.d("DfltImageHeaderParser", "Found MARKER_EOI in exif segment");
                }
                return -1;
            }
            r1 = reader.m1306() - 2;
            if (r0 == 225) {
                return r1;
            }
            j = (long) r1;
            skip = reader.skip(j);
        } while (skip == j);
        if (Log.isLoggable("DfltImageHeaderParser", 3)) {
            Log.d("DfltImageHeaderParser", "Unable to skip enough data, type: " + ((int) r0) + ", wanted to skip: " + r1 + ", but actually skipped: " + skip);
        }
        return -1;
    }

    @Override // com.bumptech.glide.load.ImageHeaderParser
    /* renamed from: K  reason: contains not printable characters */
    public ImageHeaderParser.ImageType m1303(InputStream inputStream) throws IOException {
        C1841.m4783(inputStream, "Argument must not be null");
        return m1302(new C0337(inputStream));
    }

    @Override // com.bumptech.glide.load.ImageHeaderParser
    /* renamed from: K  reason: contains not printable characters */
    public ImageHeaderParser.ImageType m1304(ByteBuffer byteBuffer) throws IOException {
        C1841.m4783(byteBuffer, "Argument must not be null");
        return m1302(new C0339(byteBuffer));
    }

    @Override // com.bumptech.glide.load.ImageHeaderParser
    /* renamed from: K  reason: contains not printable characters */
    public int m1301(InputStream inputStream, AbstractC0967 r7) throws IOException {
        C1841.m4783(inputStream, "Argument must not be null");
        C0337 r0 = new C0337(inputStream);
        C1841.m4783(r7, "Argument must not be null");
        try {
            int r1 = r0.m1309();
            if ((r1 & 65496) == 65496 || r1 == 19789 || r1 == 18761) {
                int r12 = m1299(r0);
                if (r12 != -1) {
                    C0964 r72 = (C0964) r7;
                    byte[] bArr = (byte[]) r72.m2735(r12, byte[].class);
                    try {
                        return m1300(r0, bArr, r12);
                    } finally {
                        r72.m2743(bArr);
                    }
                } else if (!Log.isLoggable("DfltImageHeaderParser", 3)) {
                    return -1;
                } else {
                    Log.d("DfltImageHeaderParser", "Failed to parse exif segment length, or exif segment not found");
                    return -1;
                }
            } else if (!Log.isLoggable("DfltImageHeaderParser", 3)) {
                return -1;
            } else {
                Log.d("DfltImageHeaderParser", "Parser doesn't handle magic number: " + r1);
                return -1;
            }
        } catch (Reader.EndOfFileException unused) {
            return -1;
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public final ImageHeaderParser.ImageType m1302(Reader reader) throws IOException {
        try {
            int r0 = reader.m1306();
            if (r0 == 65496) {
                return ImageHeaderParser.ImageType.JPEG;
            }
            int r02 = (r0 << 8) | reader.m1305();
            if (r02 == 4671814) {
                return ImageHeaderParser.ImageType.GIF;
            }
            int r03 = (r02 << 8) | reader.m1305();
            if (r03 == -1991225785) {
                reader.skip(21);
                try {
                    return reader.m1305() >= 3 ? ImageHeaderParser.ImageType.PNG_A : ImageHeaderParser.ImageType.PNG;
                } catch (Reader.EndOfFileException unused) {
                    return ImageHeaderParser.ImageType.PNG;
                }
            } else if (r03 != 1380533830) {
                return ImageHeaderParser.ImageType.UNKNOWN;
            } else {
                reader.skip(4);
                if (((reader.m1306() << 16) | reader.m1306()) != 1464156752) {
                    return ImageHeaderParser.ImageType.UNKNOWN;
                }
                int r2 = (reader.m1306() << 16) | reader.m1306();
                if ((r2 & -256) != 1448097792) {
                    return ImageHeaderParser.ImageType.UNKNOWN;
                }
                int i = r2 & BaseProgressIndicator.MAX_ALPHA;
                if (i == 88) {
                    reader.skip(4);
                    return (reader.m1305() & 16) != 0 ? ImageHeaderParser.ImageType.WEBP_A : ImageHeaderParser.ImageType.WEBP;
                } else if (i != 76) {
                    return ImageHeaderParser.ImageType.WEBP;
                } else {
                    reader.skip(4);
                    return (reader.m1305() & 8) != 0 ? ImageHeaderParser.ImageType.WEBP_A : ImageHeaderParser.ImageType.WEBP;
                }
            }
        } catch (Reader.EndOfFileException unused2) {
            return ImageHeaderParser.ImageType.UNKNOWN;
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public final int m1300(Reader reader, byte[] bArr, int i) throws IOException {
        ByteOrder byteOrder;
        int r13 = reader.m1307(bArr, i);
        if (r13 != i) {
            if (Log.isLoggable("DfltImageHeaderParser", 3)) {
                Log.d("DfltImageHeaderParser", "Unable to read exif segment data, length: " + i + ", actually read: " + r13);
            }
            return -1;
        }
        boolean z = bArr != null && i > f2239.length;
        if (z) {
            int i2 = 0;
            while (true) {
                byte[] bArr2 = f2239;
                if (i2 >= bArr2.length) {
                    break;
                } else if (bArr[i2] != bArr2[i2]) {
                    z = false;
                    break;
                } else {
                    i2++;
                }
            }
        }
        if (z) {
            C0338 r4 = new C0338(bArr, i);
            short r15 = r4.m1313(6);
            if (r15 == 18761) {
                byteOrder = ByteOrder.LITTLE_ENDIAN;
            } else if (r15 != 19789) {
                if (Log.isLoggable("DfltImageHeaderParser", 3)) {
                    Log.d("DfltImageHeaderParser", "Unknown endianness = " + ((int) r15));
                }
                byteOrder = ByteOrder.BIG_ENDIAN;
            } else {
                byteOrder = ByteOrder.BIG_ENDIAN;
            }
            r4.f2241.order(byteOrder);
            int r152 = r4.m1311(10) + 6;
            short r14 = r4.m1313(r152);
            for (int i3 = 0; i3 < r14; i3++) {
                int i4 = (i3 * 12) + r152 + 2;
                short r5 = r4.m1313(i4);
                if (r5 == 274) {
                    short r7 = r4.m1313(i4 + 2);
                    if (r7 >= 1 && r7 <= 12) {
                        int r8 = r4.m1311(i4 + 4);
                        if (r8 >= 0) {
                            if (Log.isLoggable("DfltImageHeaderParser", 3)) {
                                Log.d("DfltImageHeaderParser", "Got tagIndex=" + i3 + " tagType=" + ((int) r5) + " formatCode=" + ((int) r7) + " componentCount=" + r8);
                            }
                            int i5 = r8 + f2238[r7];
                            if (i5 <= 4) {
                                int i6 = i4 + 8;
                                if (i6 < 0 || i6 > r4.m1312()) {
                                    if (Log.isLoggable("DfltImageHeaderParser", 3)) {
                                        Log.d("DfltImageHeaderParser", "Illegal tagValueOffset=" + i6 + " tagType=" + ((int) r5));
                                    }
                                } else if (i5 >= 0 && i5 + i6 <= r4.m1312()) {
                                    return r4.m1313(i6);
                                } else {
                                    if (Log.isLoggable("DfltImageHeaderParser", 3)) {
                                        Log.d("DfltImageHeaderParser", "Illegal number of bytes for TI tag data tagType=" + ((int) r5));
                                    }
                                }
                            } else if (Log.isLoggable("DfltImageHeaderParser", 3)) {
                                Log.d("DfltImageHeaderParser", "Got byte count > 4, not orientation, continuing, formatCode=" + ((int) r7));
                            }
                        } else if (Log.isLoggable("DfltImageHeaderParser", 3)) {
                            Log.d("DfltImageHeaderParser", "Negative tiff component count");
                        }
                    } else if (Log.isLoggable("DfltImageHeaderParser", 3)) {
                        Log.d("DfltImageHeaderParser", "Got invalid format code = " + ((int) r7));
                    }
                }
            }
            return -1;
        }
        if (Log.isLoggable("DfltImageHeaderParser", 3)) {
            Log.d("DfltImageHeaderParser", "Missing jpeg exif preamble");
        }
        return -1;
    }
}
