package com.bumptech.glide.load.engine;

import android.os.Build;
import android.util.Log;
import com.bumptech.glide.Priority;
import com.bumptech.glide.Registry;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.EncodeStrategy;
import java.util.ArrayList;
import java.util.List;
import ඓ.ῲ.K.C1220;
import ඓ.ῲ.K.ᓣ.C0847;
import ඓ.ῲ.K.ᓣ.ᕣ.AbstractC0836;
import ඓ.ῲ.K.ᓣ.ᕣ.C0830;
import ඓ.ῲ.K.ᕣ.AbstractC1029;
import ඓ.ῲ.K.ᕣ.AbstractC1030;
import ඓ.ῲ.K.ᕣ.AbstractC1120;
import ඓ.ῲ.K.ᕣ.C1121;
import ඓ.ῲ.K.ᕣ.ᕣ.ʬ.C0873;
import ඓ.ῲ.K.ᕣ.ᨨ.AbstractC0937;
import ඓ.ῲ.K.ᕣ.ᨨ.AbstractC0951;
import ඓ.ῲ.K.ᕣ.ᨨ.AbstractC1021;
import ඓ.ῲ.K.ᕣ.ᨨ.AbstractC1027;
import ඓ.ῲ.K.ᕣ.ᨨ.C0934;
import ඓ.ῲ.K.ᕣ.ᨨ.C0936;
import ඓ.ῲ.K.ᕣ.ᨨ.C0938;
import ඓ.ῲ.K.ᕣ.ᨨ.C0940;
import ඓ.ῲ.K.ᕣ.ᨨ.C0941;
import ඓ.ῲ.K.ᕣ.ᨨ.C0945;
import ඓ.ῲ.K.ᕣ.ᨨ.C0956;
import ඓ.ῲ.K.ᕣ.ᨨ.C1007;
import ඓ.ῲ.K.ᕣ.ᨨ.C1013;
import ඓ.ῲ.K.ᕣ.ᨨ.C1023;
import ඓ.ῲ.K.ᕣ.ᨨ.C1024;
import ඓ.ῲ.K.ᕣ.ᨨ.C1025;
import ඓ.ῲ.K.ᕣ.ᨨ.C1028;
import ඓ.ῲ.K.ᕣ.ᨨ.㮔.ExecutorServiceC1008;
import ඓ.ῲ.K.ᕣ.㳳.AbstractC1033;
import ඓ.ῲ.K.ᕣ.㿎.AbstractC1130;
import ඓ.ῲ.K.ᕣ.㿎.AbstractC1146;
import ඓ.K.K.K.C1293;
import ῲ.ᨨ.㿎.AbstractC1871;

public class DecodeJob<R> implements AbstractC1021.AbstractC1022, Runnable, Comparable<DecodeJob<?>>, C0830.AbstractC0835 {

    /* renamed from: ʬ  reason: contains not printable characters */
    public final List<Throwable> f2194 = new ArrayList();

    /* renamed from: Ԕ  reason: contains not printable characters */
    public int f2195;

    /* renamed from: Ԛ  reason: contains not printable characters */
    public long f2196;

    /* renamed from: ؿ  reason: contains not printable characters */
    public C1121 f2197;

    /* renamed from: ݜ  reason: contains not printable characters */
    public Stage f2198;

    /* renamed from: ඓ  reason: contains not printable characters */
    public final AbstractC0335 f2199;

    /* renamed from: ᆯ  reason: contains not printable characters */
    public volatile boolean f2200;

    /* renamed from: ᑓ  reason: contains not printable characters */
    public AbstractC1029 f2201;

    /* renamed from: ᓆ  reason: contains not printable characters */
    public Object f2202;

    /* renamed from: ᓣ  reason: contains not printable characters */
    public AbstractC0334<R> f2203;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public Priority f2204;

    /* renamed from: ᝁ  reason: contains not printable characters */
    public volatile AbstractC1021 f2205;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public C1220 f2206;

    /* renamed from: ῲ  reason: contains not printable characters */
    public final C0956<R> f2207 = new C0956<>();

    /* renamed from: ⁱ  reason: contains not printable characters */
    public final C0331<?> f2208 = new C0331<>();

    /* renamed from: ⶍ  reason: contains not printable characters */
    public volatile boolean f2209;

    /* renamed from: ゎ  reason: contains not printable characters */
    public AbstractC1029 f2210;

    /* renamed from: ト  reason: contains not printable characters */
    public Object f2211;

    /* renamed from: 㑃  reason: contains not printable characters */
    public C1028 f2212;

    /* renamed from: 㗗  reason: contains not printable characters */
    public AbstractC0951 f2213;

    /* renamed from: 㗽  reason: contains not printable characters */
    public int f2214;

    /* renamed from: 㮔  reason: contains not printable characters */
    public DataSource f2215;

    /* renamed from: 㳳  reason: contains not printable characters */
    public AbstractC1029 f2216;

    /* renamed from: 㴪  reason: contains not printable characters */
    public Thread f2217;

    /* renamed from: 㴹  reason: contains not printable characters */
    public final AbstractC1871<DecodeJob<?>> f2218;

    /* renamed from: 㶋  reason: contains not printable characters */
    public boolean f2219;

    /* renamed from: 㸾  reason: contains not printable characters */
    public final AbstractC0836 f2220 = new AbstractC0836.C0837();

    /* renamed from: 㿎  reason: contains not printable characters */
    public final C0332 f2221 = new C0332();

    /* renamed from: 䀟  reason: contains not printable characters */
    public RunReason f2222;

    /* renamed from: 䁗  reason: contains not printable characters */
    public int f2223;

    /* renamed from: 䃖  reason: contains not printable characters */
    public AbstractC1146<?> f2224;

    public enum RunReason {
        INITIALIZE,
        SWITCH_TO_SOURCE_SERVICE,
        DECODE_DATA
    }

    public enum Stage {
        INITIALIZE,
        RESOURCE_CACHE,
        DATA_CACHE,
        SOURCE,
        ENCODE,
        FINISHED
    }

    /* renamed from: com.bumptech.glide.load.engine.DecodeJob$ῲ  reason: contains not printable characters */
    public final class C0333<Z> implements C1025.AbstractC1026<Z> {

        /* renamed from: K  reason: contains not printable characters */
        public final DataSource f2234;

        public C0333(DataSource dataSource) {
            this.f2234 = dataSource;
        }
    }

    /* renamed from: com.bumptech.glide.load.engine.DecodeJob$K  reason: contains not printable characters */
    public interface AbstractC0334<R> {
    }

    /* renamed from: com.bumptech.glide.load.engine.DecodeJob$㸾  reason: contains not printable characters */
    public interface AbstractC0335 {
    }

    public DecodeJob(AbstractC0335 r2, AbstractC1871<DecodeJob<?>> r3) {
        this.f2199 = r2;
        this.f2218 = r3;
    }

    /* JADX DEBUG: Method arguments types fixed to match base method, original types: [java.lang.Object] */
    @Override // java.lang.Comparable
    public int compareTo(DecodeJob<?> decodeJob) {
        DecodeJob<?> decodeJob2 = decodeJob;
        int r0 = m1270() - decodeJob2.m1270();
        return r0 == 0 ? this.f2214 - decodeJob2.f2214 : r0;
    }

    public void run() {
        AbstractC1146<?> r1 = this.f2224;
        try {
            if (this.f2209) {
                m1284();
                if (r1 != null) {
                    r1.m3065();
                    return;
                }
                return;
            }
            m1272();
            if (r1 != null) {
                r1.m3065();
            }
        } catch (CallbackException e) {
            throw e;
        } catch (Throwable th) {
            if (r1 != null) {
                r1.m3065();
            }
            throw th;
        }
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public final AbstractC1021 m1269() {
        int ordinal = this.f2198.ordinal();
        if (ordinal == 1) {
            return new C0936(this.f2207, this);
        }
        if (ordinal == 2) {
            C0956<R> r1 = this.f2207;
            return new C0934(r1.m2712(), r1, this);
        } else if (ordinal == 3) {
            return new C0941(this.f2207, this);
        } else {
            if (ordinal == 5) {
                return null;
            }
            StringBuilder r12 = C1293.m3416("Unrecognized stage: ");
            r12.append(this.f2198);
            throw new IllegalStateException(r12.toString());
        }
    }

    /* renamed from: ඓ  reason: contains not printable characters */
    public final int m1270() {
        return this.f2204.ordinal();
    }

    /* renamed from: ᕣ  reason: contains not printable characters */
    public boolean m1271() {
        Stage r0 = m1275(Stage.INITIALIZE);
        return r0 == Stage.RESOURCE_CACHE || r0 == Stage.DATA_CACHE;
    }

    /* renamed from: ᨨ  reason: contains not printable characters */
    public final void m1272() {
        int ordinal = this.f2222.ordinal();
        if (ordinal == 0) {
            this.f2198 = m1275(Stage.INITIALIZE);
            this.f2205 = m1269();
            m1286();
        } else if (ordinal == 1) {
            m1286();
        } else if (ordinal == 2) {
            m1279();
        } else {
            StringBuilder r1 = C1293.m3416("Unrecognized run reason: ");
            r1.append(this.f2222);
            throw new IllegalStateException(r1.toString());
        }
    }

    @Override // ඓ.ῲ.K.ᕣ.ᨨ.AbstractC1021.AbstractC1022
    /* renamed from: ῲ  reason: contains not printable characters */
    public void m1273() {
        this.f2222 = RunReason.SWITCH_TO_SOURCE_SERVICE;
        ((C0945) this.f2203).m2675().f4412.execute(this);
    }

    /* renamed from: ⁱ  reason: contains not printable characters */
    public final void m1274() {
        this.f2221.m1289();
        C0331<?> r0 = this.f2208;
        r0.f2229 = null;
        r0.f2228 = null;
        r0.f2227 = null;
        C0956<R> r02 = this.f2207;
        r02.f4302 = null;
        r02.f4317 = null;
        r02.f4303 = null;
        r02.f4310 = null;
        r02.f4307 = null;
        r02.f4308 = null;
        r02.f4313 = null;
        r02.f4315 = null;
        r02.f4304 = null;
        r02.f4311.clear();
        r02.f4312 = false;
        r02.f4309.clear();
        r02.f4319 = false;
        this.f2200 = false;
        this.f2206 = null;
        this.f2216 = null;
        this.f2197 = null;
        this.f2204 = null;
        this.f2212 = null;
        this.f2203 = null;
        this.f2198 = null;
        this.f2205 = null;
        this.f2217 = null;
        this.f2201 = null;
        this.f2211 = null;
        this.f2215 = null;
        this.f2224 = null;
        this.f2196 = 0;
        this.f2209 = false;
        this.f2202 = null;
        this.f2194.clear();
        this.f2218.m4836(this);
    }

    /* renamed from: K  reason: contains not printable characters */
    public final Stage m1275(Stage stage) {
        int ordinal = stage.ordinal();
        if (ordinal != 0) {
            if (ordinal != 1) {
                if (ordinal == 2) {
                    return this.f2219 ? Stage.FINISHED : Stage.SOURCE;
                }
                if (ordinal == 3 || ordinal == 5) {
                    return Stage.FINISHED;
                }
                throw new IllegalArgumentException("Unrecognized stage: " + stage);
            } else if (this.f2213.m2693()) {
                return Stage.DATA_CACHE;
            } else {
                return m1275(Stage.DATA_CACHE);
            }
        } else if (this.f2213.m2692()) {
            return Stage.RESOURCE_CACHE;
        } else {
            return m1275(Stage.RESOURCE_CACHE);
        }
    }

    /* renamed from: 㳳  reason: contains not printable characters */
    public final void m1283() {
        Throwable th;
        this.f2220.m2431();
        if (this.f2200) {
            if (this.f2194.isEmpty()) {
                th = null;
            } else {
                List<Throwable> list = this.f2194;
                th = list.get(list.size() - 1);
            }
            throw new IllegalStateException("Already notified", th);
        }
        this.f2200 = true;
    }

    /* renamed from: 㴹  reason: contains not printable characters */
    public final void m1284() {
        m1283();
        ((C0945) this.f2203).m2682(new GlideException("Failed to load resource", new ArrayList(this.f2194)));
        if (this.f2221.m1290()) {
            m1274();
        }
    }

    @Override // ඓ.ῲ.K.ᓣ.ᕣ.C0830.AbstractC0835
    /* renamed from: 㸾  reason: contains not printable characters */
    public AbstractC0836 m1285() {
        return this.f2220;
    }

    /* renamed from: 㿎  reason: contains not printable characters */
    public final void m1286() {
        this.f2217 = Thread.currentThread();
        this.f2196 = C0847.m2463();
        boolean z = false;
        while (!this.f2209 && this.f2205 != null && !(z = this.f2205.m2833())) {
            this.f2198 = m1275(this.f2198);
            this.f2205 = m1269();
            if (this.f2198 == Stage.SOURCE) {
                m1273();
                return;
            }
        }
        if ((this.f2198 == Stage.FINISHED || this.f2209) && !z) {
            m1284();
        }
    }

    /* renamed from: com.bumptech.glide.load.engine.DecodeJob$ඓ  reason: contains not printable characters */
    public static class C0332 {

        /* renamed from: ʬ  reason: contains not printable characters */
        public boolean f2230;

        /* renamed from: ῲ  reason: contains not printable characters */
        public boolean f2231;

        /* renamed from: K  reason: contains not printable characters */
        public boolean f2232;

        /* renamed from: ʬ  reason: contains not printable characters */
        public synchronized void m1289() {
            this.f2231 = false;
            this.f2232 = false;
            this.f2230 = false;
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public synchronized boolean m1291(boolean z) {
            this.f2232 = true;
            return m1293(z);
        }

        /* renamed from: K  reason: contains not printable characters */
        public synchronized boolean m1292() {
            this.f2231 = true;
            return m1293(false);
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public synchronized boolean m1290() {
            this.f2230 = true;
            return m1293(false);
        }

        /* renamed from: K  reason: contains not printable characters */
        public final boolean m1293(boolean z) {
            return (this.f2230 || z || this.f2231) && this.f2232;
        }
    }

    /* renamed from: com.bumptech.glide.load.engine.DecodeJob$ʬ  reason: contains not printable characters */
    public static class C0331<Z> {

        /* renamed from: ʬ  reason: contains not printable characters */
        public C0938<Z> f2227;

        /* renamed from: ῲ  reason: contains not printable characters */
        public AbstractC1120<Z> f2228;

        /* renamed from: K  reason: contains not printable characters */
        public AbstractC1029 f2229;

        /* renamed from: K  reason: contains not printable characters */
        public void m1287(AbstractC0335 r5, C1121 r6) {
            try {
                ((C1013.C1014) r5).m2827().m2800(this.f2229, new C0940(this.f2228, this.f2227, r6));
            } finally {
                this.f2227.m2659();
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public boolean m1288() {
            return this.f2227 != null;
        }
    }

    @Override // ඓ.ῲ.K.ᕣ.ᨨ.AbstractC1021.AbstractC1022
    /* renamed from: K  reason: contains not printable characters */
    public void m1282(AbstractC1029 r1, Object obj, AbstractC1146<?> r3, DataSource dataSource, AbstractC1029 r5) {
        ExecutorServiceC1008 k;
        this.f2201 = r1;
        this.f2211 = obj;
        this.f2224 = r3;
        this.f2215 = dataSource;
        this.f2210 = r5;
        if (Thread.currentThread() != this.f2217) {
            this.f2222 = RunReason.DECODE_DATA;
            C0945 r12 = (C0945) this.f2203;
            if (r12.f4281) {
                k = r12.f4283;
            } else {
                k = r12.f4270 ? r12.f4276 : r12.f4277;
            }
            k.f4412.execute(this);
            return;
        }
        m1279();
    }

    @Override // ඓ.ῲ.K.ᕣ.ᨨ.AbstractC1021.AbstractC1022
    /* renamed from: K  reason: contains not printable characters */
    public void m1281(AbstractC1029 r3, Exception exc, AbstractC1146<?> r5, DataSource dataSource) {
        r5.m3065();
        GlideException glideException = new GlideException("Fetching data failed", exc);
        glideException.setLoggingDetails(r3, dataSource, r5.m3066());
        this.f2194.add(glideException);
        if (Thread.currentThread() != this.f2217) {
            this.f2222 = RunReason.SWITCH_TO_SOURCE_SERVICE;
            ((C0945) this.f2203).m2675().f4412.execute(this);
            return;
        }
        m1286();
    }

    /* JADX DEBUG: Multi-variable search result rejected for r1v2, resolved type: ඓ.ῲ.K.ᕣ.ᨨ.ݜ */
    /* JADX DEBUG: Multi-variable search result rejected for r1v3, resolved type: ඓ.ῲ.K.ᕣ.ᨨ.ݜ */
    /* JADX DEBUG: Multi-variable search result rejected for r1v4, resolved type: ඓ.ῲ.K.ᕣ.ᨨ.ݜ */
    /* JADX WARN: Multi-variable type inference failed */
    /* renamed from: K  reason: contains not printable characters */
    public final void m1279() {
        AbstractC1027<R> r1;
        C0938 r12;
        AbstractC1027<R> r0;
        if (Log.isLoggable("DecodeJob", 2)) {
            long j = this.f2196;
            StringBuilder r2 = C1293.m3416("data: ");
            r2.append(this.f2211);
            r2.append(", cache key: ");
            r2.append(this.f2201);
            r2.append(", fetcher: ");
            r2.append(this.f2224);
            m1280("Retrieved data", j, r2.toString());
        }
        try {
            r1 = m1278(this.f2224, this.f2211, this.f2215);
        } catch (GlideException e) {
            e.setLoggingDetails(this.f2210, this.f2215);
            this.f2194.add(e);
            r1 = null;
        }
        if (r1 != null) {
            DataSource dataSource = this.f2215;
            if (r1 instanceof AbstractC0937) {
                ((AbstractC0937) r1).initialize();
            }
            if (this.f2208.m1288()) {
                r0 = C0938.m2657(r1);
                r12 = r0;
            } else {
                r12 = 0;
                r0 = r1;
            }
            m1283();
            ((C0945) this.f2203).m2683(r0, dataSource);
            this.f2198 = Stage.ENCODE;
            try {
                if (this.f2208.m1288()) {
                    this.f2208.m1287(this.f2199, this.f2197);
                }
                if (this.f2221.m1292()) {
                    m1274();
                }
            } finally {
                if (r12 != 0) {
                    r12.m2659();
                }
            }
        } else {
            m1286();
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public final <Data> AbstractC1027<R> m1278(AbstractC1146<?> r5, Data data, DataSource dataSource) throws GlideException {
        if (data == null) {
            r5.m3065();
            return null;
        }
        try {
            long r1 = C0847.m2463();
            AbstractC1027<R> r6 = m1277(data, dataSource);
            if (Log.isLoggable("DecodeJob", 2)) {
                m1280("Decoded result " + r6, r1, (String) null);
            }
            return r6;
        } finally {
            r5.m3065();
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public final <Data> AbstractC1027<R> m1277(Data data, DataSource dataSource) throws GlideException {
        C1007<Data, ?, R> r2 = this.f2207.m2714(data.getClass());
        C1121 r0 = this.f2197;
        if (Build.VERSION.SDK_INT >= 26) {
            boolean z = dataSource == DataSource.RESOURCE_DISK_CACHE || this.f2207.f4314;
            Boolean bool = (Boolean) r0.m3002(C0873.f4118);
            if (bool == null || (bool.booleanValue() && !z)) {
                r0 = new C1121();
                r0.m3005(this.f2197);
                r0.m3003(C0873.f4118, Boolean.valueOf(z));
            }
        }
        AbstractC1130<Data> r9 = this.f2206.f4849.f2181.m3058((Object) data);
        try {
            return r2.m2813(r9, r0, this.f2223, this.f2195, new C0333(dataSource));
        } finally {
            r9.m3023();
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m1280(String str, long j, String str2) {
        StringBuilder r2 = C1293.m3402(str, " in ");
        r2.append(C0847.m2462(j));
        r2.append(", load key: ");
        r2.append(this.f2212);
        r2.append(str2 != null ? C1293.m3412(", ", str2) : "");
        r2.append(", thread: ");
        r2.append(Thread.currentThread().getName());
        Log.v("DecodeJob", r2.toString());
    }

    /* renamed from: K  reason: contains not printable characters */
    public <Z> AbstractC1027<Z> m1276(DataSource dataSource, AbstractC1027<Z> r14) {
        AbstractC1030<Z> r7;
        AbstractC1027<Z> r0;
        EncodeStrategy encodeStrategy;
        AbstractC1029 r13;
        Class<?> cls = r14.get().getClass();
        AbstractC1120<Z> r1 = null;
        if (dataSource != DataSource.RESOURCE_DISK_CACHE) {
            AbstractC1030<Z> r02 = this.f2207.m2711(cls);
            r7 = r02;
            r0 = r02.m2846(this.f2206, r14, this.f2223, this.f2195);
        } else {
            r0 = r14;
            r7 = null;
        }
        if (!r14.equals(r0)) {
            r14.m2841();
        }
        boolean z = false;
        if (this.f2207.f4302.f4849.f2188.m2413(r0.m2842()) != null) {
            r1 = this.f2207.f4302.f4849.f2188.m2413(r0.m2842());
            if (r1 != null) {
                encodeStrategy = r1.m3001(this.f2197);
            } else {
                throw new Registry.NoResultEncoderAvailableException(r0.m2842());
            }
        } else {
            encodeStrategy = EncodeStrategy.NONE;
        }
        C0956<R> r4 = this.f2207;
        AbstractC1029 r5 = this.f2201;
        List<AbstractC1033.C1034<?>> r42 = r4.m2708();
        int size = r42.size();
        int i = 0;
        while (true) {
            if (i >= size) {
                break;
            } else if (r42.get(i).f4476.equals(r5)) {
                z = true;
                break;
            } else {
                i++;
            }
        }
        if (!this.f2213.m2695(!z, dataSource, encodeStrategy)) {
            return r0;
        }
        if (r1 != null) {
            int ordinal = encodeStrategy.ordinal();
            if (ordinal == 0) {
                r13 = new C1024(this.f2201, this.f2216);
            } else if (ordinal == 1) {
                r13 = new C1023(this.f2207.f4302.f4851, this.f2201, this.f2216, this.f2223, this.f2195, r7, cls, this.f2197);
            } else {
                throw new IllegalArgumentException("Unknown strategy: " + encodeStrategy);
            }
            C0938<Z> r03 = C0938.m2657(r0);
            C0331<?> r12 = this.f2208;
            r12.f2229 = r13;
            r12.f2228 = r1;
            r12.f2227 = r03;
            return r03;
        }
        throw new Registry.NoResultEncoderAvailableException(r0.get().getClass());
    }
}
