package com.appsflyer.internal;

import android.content.Context;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.android.installreferrer.api.ReferrerDetails;
import com.appsflyer.AFLogger;
import java.util.HashMap;

public final class i implements InstallReferrerStateListener {

    /* renamed from: ˊ  reason: contains not printable characters */
    public InstallReferrerClient f2083;

    /* renamed from: ˎ  reason: contains not printable characters */
    public m f2084;

    @Override // com.android.installreferrer.api.InstallReferrerStateListener
    public final void onInstallReferrerServiceDisconnected() {
        AFLogger.afDebugLog("Install Referrer service disconnected");
    }

    @Override // com.android.installreferrer.api.InstallReferrerStateListener
    public final void onInstallReferrerSetupFinished(int i) {
        HashMap hashMap = new HashMap();
        hashMap.put("code", String.valueOf(i));
        ReferrerDetails referrerDetails = null;
        if (i == 0) {
            try {
                AFLogger.afDebugLog("InstallReferrer connected");
                if (this.f2083.isReady()) {
                    referrerDetails = this.f2083.getInstallReferrer();
                    this.f2083.endConnection();
                } else {
                    AFLogger.afWarnLog("ReferrerClient: InstallReferrer is not ready");
                    hashMap.put("err", "ReferrerClient: InstallReferrer is not ready");
                }
            } catch (Throwable th) {
                StringBuilder sb = new StringBuilder("Failed to get install referrer: ");
                sb.append(th.getMessage());
                AFLogger.afWarnLog(sb.toString());
                hashMap.put("err", th.getMessage());
            }
        } else if (i == 1) {
            AFLogger.afWarnLog("InstallReferrer not supported");
        } else if (i != 2) {
            AFLogger.afWarnLog("responseCode not found.");
        } else {
            AFLogger.afWarnLog("InstallReferrer not supported");
        }
        if (referrerDetails != null) {
            try {
                if (referrerDetails.getInstallReferrer() != null) {
                    hashMap.put("val", referrerDetails.getInstallReferrer());
                }
                hashMap.put("clk", Long.toString(referrerDetails.getReferrerClickTimestampSeconds()));
                hashMap.put("install", Long.toString(referrerDetails.getInstallBeginTimestampSeconds()));
            } catch (Exception e) {
                e.printStackTrace();
                hashMap.put("val", "-1");
                hashMap.put("clk", "-1");
                hashMap.put("install", "-1");
            }
        }
        m mVar = this.f2084;
        if (mVar != null) {
            mVar.onHandleReferrer(hashMap);
        }
    }

    /* renamed from: ˏ  reason: contains not printable characters */
    public final void m1231(Context context, m mVar) {
        this.f2084 = mVar;
        try {
            this.f2083 = InstallReferrerClient.newBuilder(context).build();
            this.f2083.startConnection(this);
        } catch (Throwable th) {
            AFLogger.afErrorLog("referrerClient -> startConnection", th);
        }
    }
}
