package com.appsflyer;

import android.util.Log;
import com.appsflyer.internal.ae;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class AFLogger {

    /* renamed from: ˊ  reason: contains not printable characters */
    public static long f1867 = System.currentTimeMillis();

    public enum LogLevel {
        NONE(0),
        ERROR(1),
        WARNING(2),
        INFO(3),
        DEBUG(4),
        VERBOSE(5);
        

        /* renamed from: ˊ  reason: contains not printable characters */
        public int f1869;

        /* access modifiers changed from: public */
        LogLevel(int i) {
            this.f1869 = i;
        }

        public final int getLevel() {
            return this.f1869;
        }
    }

    public static void afDebugLog(String str) {
        if (LogLevel.DEBUG.getLevel() <= AppsFlyerProperties.getInstance().getInt("logLevel", LogLevel.NONE.getLevel())) {
            Log.d(AppsFlyerLibCore.LOG_TAG, m1082(str, false));
        }
        if (ae.f1979 == null) {
            ae.f1979 = new ae();
        }
        ae.f1979.m1180(null, "D", m1082(str, true));
    }

    public static void afErrorLog(String str, Throwable th) {
        m1084(str, th, false);
    }

    public static void afInfoLog(String str, boolean z) {
        if (LogLevel.INFO.getLevel() <= AppsFlyerProperties.getInstance().getInt("logLevel", LogLevel.NONE.getLevel())) {
            Log.i(AppsFlyerLibCore.LOG_TAG, m1082(str, false));
        }
        if (z) {
            if (ae.f1979 == null) {
                ae.f1979 = new ae();
            }
            ae.f1979.m1180(null, "I", m1082(str, true));
        }
    }

    public static void afRDLog(String str) {
        if (LogLevel.VERBOSE.getLevel() <= AppsFlyerProperties.getInstance().getInt("logLevel", LogLevel.NONE.getLevel())) {
            Log.v(AppsFlyerLibCore.LOG_TAG, m1082(str, false));
        }
        if (ae.f1979 == null) {
            ae.f1979 = new ae();
        }
        ae.f1979.m1180(null, "V", m1082(str, true));
    }

    public static void afWarnLog(String str) {
        m1081(str);
    }

    public static void resetDeltaTime() {
        f1867 = System.currentTimeMillis();
    }

    /* renamed from: ˋ  reason: contains not printable characters */
    public static void m1081(String str) {
        if (LogLevel.WARNING.getLevel() <= AppsFlyerProperties.getInstance().getInt("logLevel", LogLevel.NONE.getLevel())) {
            Log.w(AppsFlyerLibCore.LOG_TAG, m1082(str, false));
        }
        if (ae.f1979 == null) {
            ae.f1979 = new ae();
        }
        ae.f1979.m1180(null, "W", m1082(str, true));
    }

    /* renamed from: ˏ  reason: contains not printable characters */
    public static String m1082(String str, boolean z) {
        if (!z && LogLevel.VERBOSE.getLevel() > AppsFlyerProperties.getInstance().getInt("logLevel", LogLevel.NONE.getLevel())) {
            return str;
        }
        StringBuilder sb = new StringBuilder("(");
        sb.append(m1085(System.currentTimeMillis() - f1867));
        sb.append(") [");
        sb.append(Thread.currentThread().getName());
        sb.append("] ");
        sb.append(str);
        return sb.toString();
    }

    /* renamed from: ॱ  reason: contains not printable characters */
    public static String m1085(long j) {
        long hours = TimeUnit.MILLISECONDS.toHours(j);
        long millis = j - TimeUnit.HOURS.toMillis(hours);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis);
        long millis2 = millis - TimeUnit.MINUTES.toMillis(minutes);
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis2);
        long millis3 = TimeUnit.MILLISECONDS.toMillis(millis2 - TimeUnit.SECONDS.toMillis(seconds));
        return String.format(Locale.getDefault(), "%02d:%02d:%02d:%03d", Long.valueOf(hours), Long.valueOf(minutes), Long.valueOf(seconds), Long.valueOf(millis3));
    }

    public static void afErrorLog(String str, Throwable th, boolean z) {
        m1084(str, th, z);
    }

    /* renamed from: ˏ  reason: contains not printable characters */
    public static void m1084(String str, Throwable th, boolean z) {
        String[] strArr;
        if ((LogLevel.ERROR.getLevel() <= AppsFlyerProperties.getInstance().getInt("logLevel", LogLevel.NONE.getLevel())) && z) {
            Log.e(AppsFlyerLibCore.LOG_TAG, m1082(str, false), th);
        }
        if (ae.f1979 == null) {
            ae.f1979 = new ae();
        }
        ae aeVar = ae.f1979;
        Throwable cause = th.getCause();
        String simpleName = th.getClass().getSimpleName();
        String message = cause == null ? th.getMessage() : cause.getMessage();
        StackTraceElement[] stackTrace = cause == null ? th.getStackTrace() : cause.getStackTrace();
        if (stackTrace == null) {
            strArr = new String[]{message};
        } else {
            String[] strArr2 = new String[(stackTrace.length + 1)];
            strArr2[0] = message;
            for (int i = 1; i < stackTrace.length; i++) {
                strArr2[i] = stackTrace[i].toString();
            }
            strArr = strArr2;
        }
        aeVar.m1180("exception", simpleName, strArr);
    }

    public static void afInfoLog(String str) {
        afInfoLog(str, true);
    }

    /* renamed from: ˏ  reason: contains not printable characters */
    public static void m1083(String str) {
        if (!AppsFlyerProperties.getInstance().isLogsDisabledCompletely()) {
            Log.d(AppsFlyerLibCore.LOG_TAG, m1082(str, false));
        }
        if (ae.f1979 == null) {
            ae.f1979 = new ae();
        }
        ae.f1979.m1180(null, "F", str);
    }
}
