package com.adjust.sdk;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import java.util.concurrent.atomic.AtomicBoolean;

public class InstallReferrerHuawei {
    public static final int COLUMN_INDEX_CLICK_TIME = 1;
    public static final int COLUMN_INDEX_INSTALL_TIME = 2;
    public static final int COLUMN_INDEX_REFERRER = 0;
    public static final int COLUMN_INDEX_TRACK_ID = 4;
    public static final String REFERRER_PROVIDER_AUTHORITY = "com.huawei.appmarket.commondata";
    public static final String REFERRER_PROVIDER_URI = "content://com.huawei.appmarket.commondata/item/5";
    public Context context;
    public ILogger logger = AdjustFactory.getLogger();
    public final InstallReferrerReadListener referrerCallback;
    public final AtomicBoolean shouldTryToRead;

    public InstallReferrerHuawei(Context context2, InstallReferrerReadListener installReferrerReadListener) {
        this.context = context2;
        this.referrerCallback = installReferrerReadListener;
        this.shouldTryToRead = new AtomicBoolean(true);
    }

    private boolean isValidReferrerHuaweiAds(String str) {
        return str != null && !str.isEmpty();
    }

    private boolean isValidReferrerHuaweiAppGallery(String str) {
        return str != null && !str.isEmpty();
    }

    /* JADX WARNING: Code restructure failed: missing block: B:20:0x00bf, code lost:
        if (r3 != null) goto L_0x00d6;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:25:0x00d4, code lost:
        if (0 == 0) goto L_0x00d9;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:26:0x00d6, code lost:
        r3.close();
     */
    /* JADX WARNING: Code restructure failed: missing block: B:27:0x00d9, code lost:
        r19.shouldTryToRead.set(false);
     */
    /* JADX WARNING: Code restructure failed: missing block: B:28:0x00de, code lost:
        return;
     */
    public void readReferrer() {
        if (!this.shouldTryToRead.get()) {
            this.logger.debug("Should not try to read Install referrer Huawei", new Object[0]);
        } else if (Util.resolveContentProvider(this.context, REFERRER_PROVIDER_AUTHORITY)) {
            Cursor cursor = null;
            Uri parse = Uri.parse(REFERRER_PROVIDER_URI);
            try {
                cursor = this.context.getContentResolver().query(parse, null, null, new String[]{this.context.getPackageName()}, null);
                if (cursor == null || !cursor.moveToFirst()) {
                    this.logger.debug("InstallReferrerHuawei fail to read referrer for package [%s] and content uri [%s]", this.context.getPackageName(), parse.toString());
                } else {
                    String string = cursor.getString(0);
                    String string2 = cursor.getString(4);
                    this.logger.debug("InstallReferrerHuawei reads index_referrer[%s] index_track_id[%s]", string, string2);
                    String string3 = cursor.getString(1);
                    String string4 = cursor.getString(2);
                    this.logger.debug("InstallReferrerHuawei reads clickTime[%s] installTime[%s]", string3, string4);
                    long parseLong = Long.parseLong(string3);
                    long parseLong2 = Long.parseLong(string4);
                    if (isValidReferrerHuaweiAds(string)) {
                        this.referrerCallback.onInstallReferrerRead(new ReferrerDetails(string, parseLong, parseLong2), Constants.REFERRER_API_HUAWEI_ADS);
                    }
                    if (isValidReferrerHuaweiAppGallery(string2)) {
                        this.referrerCallback.onInstallReferrerRead(new ReferrerDetails(string2, parseLong, parseLong2), Constants.REFERRER_API_HUAWEI_APP_GALLERY);
                    }
                }
            } catch (Exception e) {
                this.logger.debug("InstallReferrerHuawei error [%s]", e.getMessage());
            } catch (Throwable th) {
                if (0 != 0) {
                    cursor.close();
                }
                throw th;
            }
        }
    }
}
