package com.adjust.sdk;

import android.net.Uri;
import com.appsflyer.share.Constants;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class AdjustLinkResolution {
    public static volatile ExecutorService executor = null;
    public static final String[] expectedUrlHostSuffixArray = {"adjust.com", "adj.st", "go.link"};
    public static final int maxRecursions = 10;

    public interface AdjustLinkResolutionCallback {
        void resolvedLinkCallback(Uri uri);
    }

    public class a implements Runnable {
        public final /* synthetic */ URL a;
        public final /* synthetic */ AdjustLinkResolutionCallback b;

        public a(URL url, AdjustLinkResolutionCallback adjustLinkResolutionCallback) {
            this.a = url;
            this.b = adjustLinkResolutionCallback;
        }

        public final void run() {
            AdjustLinkResolution.requestAndResolve(this.a, 0, this.b);
        }
    }

    public static URL convertToHttps(URL url) {
        String externalForm;
        if (url == null || (externalForm = url.toExternalForm()) == null || !externalForm.startsWith("http:")) {
            return url;
        }
        try {
            return new URL("https:" + externalForm.substring(5));
        } catch (MalformedURLException unused) {
            return url;
        }
    }

    public static Uri convertToUri(URL url) {
        if (url == null) {
            return null;
        }
        return Uri.parse(url.toString());
    }

    public static boolean isTerminalUrl(String str) {
        return urlMatchesSuffix(str, expectedUrlHostSuffixArray);
    }

    /* JADX WARNING: Code restructure failed: missing block: B:13:0x0027, code lost:
        if (r1 != null) goto L_0x0020;
     */
    public static void requestAndResolve(URL url, int i, AdjustLinkResolutionCallback adjustLinkResolutionCallback) {
        HttpURLConnection httpURLConnection;
        URL convertToHttps = convertToHttps(url);
        URL url2 = null;
        try {
            httpURLConnection = (HttpURLConnection) convertToHttps.openConnection();
            try {
                httpURLConnection.setInstanceFollowRedirects(false);
                httpURLConnection.connect();
                String headerField = httpURLConnection.getHeaderField(Constants.HTTP_REDIRECT_URL_HEADER_FIELD);
                if (headerField != null) {
                    url2 = new URL(headerField);
                }
            } catch (Throwable unused) {
            }
        } catch (Throwable unused2) {
            httpURLConnection = null;
        }
        httpURLConnection.disconnect();
        resolveLink(url2, convertToHttps, i + 1, adjustLinkResolutionCallback);
    }

    public static void resolveLink(String str, String[] strArr, AdjustLinkResolutionCallback adjustLinkResolutionCallback) {
        URL url;
        if (adjustLinkResolutionCallback != null) {
            if (str == null) {
                adjustLinkResolutionCallback.resolvedLinkCallback(null);
                return;
            }
            try {
                url = new URL(str);
            } catch (MalformedURLException unused) {
                url = null;
            }
            if (url == null) {
                adjustLinkResolutionCallback.resolvedLinkCallback(null);
            } else if (!urlMatchesSuffix(url.getHost(), strArr)) {
                adjustLinkResolutionCallback.resolvedLinkCallback(convertToUri(url));
            } else {
                if (executor == null) {
                    synchronized (expectedUrlHostSuffixArray) {
                        if (executor == null) {
                            executor = Executors.newSingleThreadExecutor();
                        }
                    }
                }
                executor.execute(new a(url, adjustLinkResolutionCallback));
            }
        }
    }

    public static void resolveLink(URL url, URL url2, int i, AdjustLinkResolutionCallback adjustLinkResolutionCallback) {
        Uri convertToUri;
        if (url == null) {
            convertToUri = convertToUri(url2);
        } else if (!isTerminalUrl(url.getHost()) && i <= 10) {
            requestAndResolve(url, i, adjustLinkResolutionCallback);
            return;
        } else {
            convertToUri = convertToUri(url);
        }
        adjustLinkResolutionCallback.resolvedLinkCallback(convertToUri);
    }

    public static boolean urlMatchesSuffix(String str, String[] strArr) {
        if (str == null || strArr == null) {
            return false;
        }
        for (String str2 : strArr) {
            if (str.endsWith(str2)) {
                return true;
            }
        }
        return false;
    }
}
