package androidx.viewpager2.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.R$styleable;
import com.google.android.material.badge.BadgeDrawable;
import ῲ.ᨨ.ᨨ.C1729;
import ῲ.ᨨ.ᨨ.䃖.AbstractC1787;
import ῲ.ᨨ.ᨨ.䃖.C1782;
import ῲ.ト.ῲ.C2200;
import ῲ.ト.ῲ.C2201;
import ῲ.ト.ῲ.C2203;
import ῲ.ト.ῲ.C2205;
import ῲ.ト.ῲ.C2207;
import ῲ.ト.K.AbstractC2208;
import ῲ.䀟.K.C2331;

public final class ViewPager2 extends ViewGroup {

    /* renamed from: ʬ  reason: contains not printable characters */
    public final Rect f1797 = new Rect();

    /* renamed from: Ԕ  reason: contains not printable characters */
    public C2200 f1798;

    /* renamed from: Ԛ  reason: contains not printable characters */
    public AbstractC0319 f1799;

    /* renamed from: ؿ  reason: contains not printable characters */
    public C2201 f1800;

    /* renamed from: ݜ  reason: contains not printable characters */
    public boolean f1801 = true;

    /* renamed from: ඓ  reason: contains not printable characters */
    public int f1802;

    /* renamed from: ᓣ  reason: contains not printable characters */
    public RecyclerView.AbstractC0250 f1803 = null;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public RecyclerView f1804;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public int f1805 = -1;

    /* renamed from: ῲ  reason: contains not printable characters */
    public final Rect f1806 = new Rect();

    /* renamed from: ⁱ  reason: contains not printable characters */
    public RecyclerView.AbstractC0244 f1807 = new C0315();

    /* renamed from: 㑃  reason: contains not printable characters */
    public C2331 f1808;

    /* renamed from: 㗗  reason: contains not printable characters */
    public C2207 f1809;

    /* renamed from: 㗽  reason: contains not printable characters */
    public boolean f1810 = false;

    /* renamed from: 㳳  reason: contains not printable characters */
    public Parcelable f1811;

    /* renamed from: 㴹  reason: contains not printable characters */
    public boolean f1812 = false;

    /* renamed from: 㸾  reason: contains not printable characters */
    public C2200 f1813 = new C2200(3);

    /* renamed from: 㿎  reason: contains not printable characters */
    public LinearLayoutManager f1814;

    /* renamed from: 䀟  reason: contains not printable characters */
    public int f1815 = -1;

    /* renamed from: 䁗  reason: contains not printable characters */
    public C2205 f1816;

    /* renamed from: androidx.viewpager2.widget.ViewPager2$ʬ  reason: contains not printable characters */
    public class C0309 extends AbstractC0314 {
        public C0309() {
        }

        @Override // androidx.viewpager2.widget.ViewPager2.AbstractC0314
        public void onPageSelected(int i) {
            ViewPager2.this.clearFocus();
            if (ViewPager2.this.hasFocus()) {
                ViewPager2.this.f1804.requestFocus(2);
            }
        }
    }

    /* renamed from: androidx.viewpager2.widget.ViewPager2$ඓ  reason: contains not printable characters */
    public static abstract class AbstractC0310 extends RecyclerView.AbstractC0244 {
        public /* synthetic */ AbstractC0310(C0315 k) {
        }

        @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0244
        public final void onItemRangeChanged(int i, int i2) {
            onChanged();
        }

        @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0244
        public final void onItemRangeInserted(int i, int i2) {
            onChanged();
        }

        @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0244
        public final void onItemRangeMoved(int i, int i2, int i3) {
            onChanged();
        }

        @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0244
        public final void onItemRangeRemoved(int i, int i2) {
            onChanged();
        }

        @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0244
        public final void onItemRangeChanged(int i, int i2, Object obj) {
            onChanged();
        }
    }

    /* renamed from: androidx.viewpager2.widget.ViewPager2$ᕣ  reason: contains not printable characters */
    public class C0311 extends RecyclerView {
        public C0311(Context context) {
            super(context);
        }

        @Override // androidx.recyclerview.widget.RecyclerView
        public CharSequence getAccessibilityClassName() {
            if (ViewPager2.this.f1799.m1035()) {
                return ViewPager2.this.f1799.m1032();
            }
            return super.getAccessibilityClassName();
        }

        public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
            super.onInitializeAccessibilityEvent(accessibilityEvent);
            accessibilityEvent.setFromIndex(ViewPager2.this.f1802);
            accessibilityEvent.setToIndex(ViewPager2.this.f1802);
            ViewPager2.this.f1799.m1039(accessibilityEvent);
        }

        @Override // androidx.recyclerview.widget.RecyclerView
        public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
            return ViewPager2.this.m1018() && super.onInterceptTouchEvent(motionEvent);
        }

        @Override // androidx.recyclerview.widget.RecyclerView
        @SuppressLint({"ClickableViewAccessibility"})
        public boolean onTouchEvent(MotionEvent motionEvent) {
            return ViewPager2.this.m1018() && super.onTouchEvent(motionEvent);
        }
    }

    /* renamed from: androidx.viewpager2.widget.ViewPager2$ᨨ  reason: contains not printable characters */
    public interface AbstractC0312 {
    }

    /* renamed from: androidx.viewpager2.widget.ViewPager2$ῲ  reason: contains not printable characters */
    public class C0313 extends AbstractC0314 {
        public C0313() {
        }

        @Override // androidx.viewpager2.widget.ViewPager2.AbstractC0314
        public void onPageScrollStateChanged(int i) {
            if (i == 0) {
                ViewPager2.this.m1027();
            }
        }

        @Override // androidx.viewpager2.widget.ViewPager2.AbstractC0314
        public void onPageSelected(int i) {
            ViewPager2 viewPager2 = ViewPager2.this;
            if (viewPager2.f1802 != i) {
                viewPager2.f1802 = i;
                viewPager2.f1799.m1038();
            }
        }
    }

    /* renamed from: androidx.viewpager2.widget.ViewPager2$ⁱ  reason: contains not printable characters */
    public static abstract class AbstractC0314 {
        public void onPageScrollStateChanged(int i) {
        }

        public void onPageScrolled(int i, float f, int i2) {
        }

        public void onPageSelected(int i) {
        }
    }

    /* renamed from: androidx.viewpager2.widget.ViewPager2$K  reason: contains not printable characters */
    public class C0315 extends AbstractC0310 {
        public C0315() {
            super(null);
        }

        @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0244
        public void onChanged() {
            ViewPager2 viewPager2 = ViewPager2.this;
            viewPager2.f1812 = true;
            viewPager2.f1816.f7671 = true;
        }
    }

    /* renamed from: androidx.viewpager2.widget.ViewPager2$㑃  reason: contains not printable characters */
    public static class RunnableC0316 implements Runnable {

        /* renamed from: ʬ  reason: contains not printable characters */
        public final RecyclerView f1824;

        /* renamed from: ῲ  reason: contains not printable characters */
        public final int f1825;

        public RunnableC0316(int i, RecyclerView recyclerView) {
            this.f1825 = i;
            this.f1824 = recyclerView;
        }

        public void run() {
            this.f1824.smoothScrollToPosition(this.f1825);
        }
    }

    /* renamed from: androidx.viewpager2.widget.ViewPager2$㳳  reason: contains not printable characters */
    public class C0317 extends C2331 {
        public C0317() {
        }

        @Override // ῲ.䀟.K.C2331, ῲ.䀟.K.AbstractC2301
        /* renamed from: K  reason: contains not printable characters */
        public View m1030(RecyclerView.AbstractC0254 r2) {
            if (ViewPager2.this.m1026()) {
                return null;
            }
            return super.m6113(r2);
        }
    }

    /* renamed from: androidx.viewpager2.widget.ViewPager2$㴹  reason: contains not printable characters */
    public class C0318 extends LinearLayoutManager {
        public C0318(Context context) {
            super(context);
        }

        @Override // androidx.recyclerview.widget.LinearLayoutManager
        public void calculateExtraLayoutSpace(RecyclerView.C0248 r3, int[] iArr) {
            int offscreenPageLimit = ViewPager2.this.getOffscreenPageLimit();
            if (offscreenPageLimit == -1) {
                super.calculateExtraLayoutSpace(r3, iArr);
                return;
            }
            int pageSize = ViewPager2.this.getPageSize() * offscreenPageLimit;
            iArr[0] = pageSize;
            iArr[1] = pageSize;
        }

        @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
        public void onInitializeAccessibilityNodeInfo(RecyclerView.C0264 r1, RecyclerView.C0248 r2, C1782 r3) {
            super.onInitializeAccessibilityNodeInfo(r1, r2, r3);
            ViewPager2.this.f1799.m1042(r3);
        }

        @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
        public boolean performAccessibilityAction(RecyclerView.C0264 r2, RecyclerView.C0248 r3, int i, Bundle bundle) {
            if (ViewPager2.this.f1799.m1045(i)) {
                return ViewPager2.this.f1799.m1036(i);
            }
            return super.performAccessibilityAction(r2, r3, i, bundle);
        }

        @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
        public boolean requestChildRectangleOnScreen(RecyclerView recyclerView, View view, Rect rect, boolean z, boolean z2) {
            return false;
        }
    }

    /* renamed from: androidx.viewpager2.widget.ViewPager2$㸾  reason: contains not printable characters */
    public abstract class AbstractC0319 {
        public /* synthetic */ AbstractC0319(ViewPager2 viewPager2, C0315 k) {
        }

        /* renamed from: ʬ  reason: contains not printable characters */
        public abstract String m1031();

        /* renamed from: ඓ  reason: contains not printable characters */
        public CharSequence m1032() {
            throw new IllegalStateException("Not implemented.");
        }

        /* renamed from: ᨨ  reason: contains not printable characters */
        public abstract void m1033();

        /* renamed from: ῲ  reason: contains not printable characters */
        public abstract void m1034(RecyclerView.AbstractC0246<?> v);

        /* renamed from: ῲ  reason: contains not printable characters */
        public boolean m1035() {
            return false;
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public boolean m1036(int i) {
            throw new IllegalStateException("Not implemented.");
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public abstract boolean m1037(int i, Bundle bundle);

        /* renamed from: ⁱ  reason: contains not printable characters */
        public abstract void m1038();

        /* renamed from: K  reason: contains not printable characters */
        public abstract void m1039(AccessibilityEvent accessibilityEvent);

        /* renamed from: K  reason: contains not printable characters */
        public abstract void m1040(AccessibilityNodeInfo accessibilityNodeInfo);

        /* renamed from: K  reason: contains not printable characters */
        public abstract void m1041(RecyclerView.AbstractC0246<?> v);

        /* renamed from: K  reason: contains not printable characters */
        public void m1042(C1782 r1) {
        }

        /* renamed from: K  reason: contains not printable characters */
        public abstract void m1043(C2200 v, RecyclerView recyclerView);

        /* renamed from: K  reason: contains not printable characters */
        public abstract boolean m1044();

        /* renamed from: K  reason: contains not printable characters */
        public boolean m1045(int i) {
            return false;
        }

        /* renamed from: K  reason: contains not printable characters */
        public abstract boolean m1046(int i, Bundle bundle);

        /* renamed from: 㴹  reason: contains not printable characters */
        public abstract void m1047();

        /* renamed from: 㸾  reason: contains not printable characters */
        public abstract void m1048();

        /* renamed from: 㿎  reason: contains not printable characters */
        public abstract void m1049();
    }

    /* renamed from: androidx.viewpager2.widget.ViewPager2$㿎  reason: contains not printable characters */
    public class C0320 extends AbstractC0319 {

        /* renamed from: ʬ  reason: contains not printable characters */
        public RecyclerView.AbstractC0244 f1828;

        /* renamed from: ῲ  reason: contains not printable characters */
        public final AbstractC1787 f1829 = new C0322();

        /* renamed from: K  reason: contains not printable characters */
        public final AbstractC1787 f1830 = new C0323();

        /* renamed from: androidx.viewpager2.widget.ViewPager2$㿎$ʬ  reason: contains not printable characters */
        public class C0321 extends AbstractC0310 {
            public C0321() {
                super(null);
            }

            @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0244
            public void onChanged() {
                C0320.this.m1062();
            }
        }

        /* renamed from: androidx.viewpager2.widget.ViewPager2$㿎$ῲ  reason: contains not printable characters */
        public class C0322 implements AbstractC1787 {
            public C0322() {
            }

            @Override // ῲ.ᨨ.ᨨ.䃖.AbstractC1787
            public boolean perform(View view, AbstractC1787.AbstractC1792 k) {
                C0320.this.m1051(((ViewPager2) view).getCurrentItem() - 1);
                return true;
            }
        }

        /* renamed from: androidx.viewpager2.widget.ViewPager2$㿎$K  reason: contains not printable characters */
        public class C0323 implements AbstractC1787 {
            public C0323() {
            }

            @Override // ῲ.ᨨ.ᨨ.䃖.AbstractC1787
            public boolean perform(View view, AbstractC1787.AbstractC1792 k) {
                C0320.this.m1051(((ViewPager2) view).getCurrentItem() + 1);
                return true;
            }
        }

        public C0320() {
            super(ViewPager2.this, null);
        }

        @Override // androidx.viewpager2.widget.ViewPager2.AbstractC0319
        /* renamed from: ʬ  reason: contains not printable characters */
        public String m1050() {
            return "androidx.viewpager.widget.ViewPager";
        }

        /* renamed from: ʬ  reason: contains not printable characters */
        public void m1051(int i) {
            if (ViewPager2.this.m1018()) {
                ViewPager2.this.m1020(i, true);
            }
        }

        @Override // androidx.viewpager2.widget.ViewPager2.AbstractC0319
        /* renamed from: ᨨ  reason: contains not printable characters */
        public void m1052() {
            m1062();
            int i = Build.VERSION.SDK_INT;
        }

        @Override // androidx.viewpager2.widget.ViewPager2.AbstractC0319
        /* renamed from: ῲ  reason: contains not printable characters */
        public void m1053(RecyclerView.AbstractC0246<?> r2) {
            if (r2 != null) {
                r2.unregisterAdapterDataObserver(this.f1828);
            }
        }

        @Override // androidx.viewpager2.widget.ViewPager2.AbstractC0319
        /* renamed from: ⁱ  reason: contains not printable characters */
        public void m1055() {
            m1062();
        }

        @Override // androidx.viewpager2.widget.ViewPager2.AbstractC0319
        /* renamed from: K  reason: contains not printable characters */
        public void m1059(C2200 r2, RecyclerView recyclerView) {
            C1729.m4457(recyclerView, 2);
            this.f1828 = new C0321();
            if (C1729.m4454(ViewPager2.this) == 0) {
                ViewPager2 viewPager2 = ViewPager2.this;
                int i = Build.VERSION.SDK_INT;
                viewPager2.setImportantForAccessibility(1);
            }
        }

        @Override // androidx.viewpager2.widget.ViewPager2.AbstractC0319
        /* renamed from: K  reason: contains not printable characters */
        public boolean m1060() {
            return true;
        }

        @Override // androidx.viewpager2.widget.ViewPager2.AbstractC0319
        /* renamed from: K  reason: contains not printable characters */
        public boolean m1061(int i, Bundle bundle) {
            return i == 8192 || i == 4096;
        }

        /* renamed from: 㳳  reason: contains not printable characters */
        public void m1062() {
            int itemCount;
            ViewPager2 viewPager2 = ViewPager2.this;
            int i = 16908360;
            C1729.m4466(viewPager2, 16908360);
            C1729.m4466(viewPager2, 16908361);
            C1729.m4466(viewPager2, 16908358);
            C1729.m4466(viewPager2, 16908359);
            if (ViewPager2.this.getAdapter() != null && (itemCount = ViewPager2.this.getAdapter().getItemCount()) != 0 && ViewPager2.this.m1018()) {
                if (ViewPager2.this.getOrientation() == 0) {
                    boolean r3 = ViewPager2.this.m1022();
                    int i2 = r3 ? 16908360 : 16908361;
                    if (r3) {
                        i = 16908361;
                    }
                    if (ViewPager2.this.f1802 < itemCount - 1) {
                        C1729.m4486(viewPager2, new C1782.C1785(i2, null), null, this.f1830);
                    }
                    if (ViewPager2.this.f1802 > 0) {
                        C1729.m4486(viewPager2, new C1782.C1785(i, null), null, this.f1829);
                        return;
                    }
                    return;
                }
                if (ViewPager2.this.f1802 < itemCount - 1) {
                    C1729.m4486(viewPager2, new C1782.C1785(16908359, null), null, this.f1830);
                }
                if (ViewPager2.this.f1802 > 0) {
                    C1729.m4486(viewPager2, new C1782.C1785(16908358, null), null, this.f1829);
                }
            }
        }

        @Override // androidx.viewpager2.widget.ViewPager2.AbstractC0319
        /* renamed from: 㴹  reason: contains not printable characters */
        public void m1063() {
            m1062();
        }

        @Override // androidx.viewpager2.widget.ViewPager2.AbstractC0319
        /* renamed from: 㸾  reason: contains not printable characters */
        public void m1064() {
            m1062();
        }

        @Override // androidx.viewpager2.widget.ViewPager2.AbstractC0319
        /* renamed from: 㿎  reason: contains not printable characters */
        public void m1065() {
            m1062();
        }

        @Override // androidx.viewpager2.widget.ViewPager2.AbstractC0319
        /* renamed from: ῲ  reason: contains not printable characters */
        public boolean m1054(int i, Bundle bundle) {
            int i2;
            if (m1061(i, bundle)) {
                if (i == 8192) {
                    i2 = ViewPager2.this.getCurrentItem() - 1;
                } else {
                    i2 = ViewPager2.this.getCurrentItem() + 1;
                }
                m1051(i2);
                return true;
            }
            throw new IllegalStateException();
        }

        @Override // androidx.viewpager2.widget.ViewPager2.AbstractC0319
        /* renamed from: K  reason: contains not printable characters */
        public void m1058(RecyclerView.AbstractC0246<?> r2) {
            m1062();
            if (r2 != null) {
                r2.registerAdapterDataObserver(this.f1828);
            }
        }

        @Override // androidx.viewpager2.widget.ViewPager2.AbstractC0319
        /* renamed from: K  reason: contains not printable characters */
        public void m1056(AccessibilityEvent accessibilityEvent) {
            accessibilityEvent.setSource(ViewPager2.this);
            accessibilityEvent.setClassName("androidx.viewpager.widget.ViewPager");
        }

        /* JADX WARNING: Removed duplicated region for block: B:16:0x0058  */
        /* JADX WARNING: Removed duplicated region for block: B:19:0x0064  */
        @Override // androidx.viewpager2.widget.ViewPager2.AbstractC0319
        /* renamed from: K  reason: contains not printable characters */
        public void m1057(AccessibilityNodeInfo accessibilityNodeInfo) {
            int i;
            int i2;
            RecyclerView.AbstractC0246 adapter;
            int itemCount;
            if (ViewPager2.this.getAdapter() == null) {
                i2 = 0;
            } else if (ViewPager2.this.getOrientation() == 1) {
                i2 = ViewPager2.this.getAdapter().getItemCount();
            } else {
                i = ViewPager2.this.getAdapter().getItemCount();
                i2 = 0;
                new C1782(accessibilityNodeInfo).m4663(C1782.C1784.m4673(i2, i, false, 0));
                int i3 = Build.VERSION.SDK_INT;
                adapter = ViewPager2.this.getAdapter();
                if (adapter != null && (itemCount = adapter.getItemCount()) != 0 && ViewPager2.this.m1018()) {
                    if (ViewPager2.this.f1802 > 0) {
                        accessibilityNodeInfo.addAction(8192);
                    }
                    if (ViewPager2.this.f1802 < itemCount - 1) {
                        accessibilityNodeInfo.addAction(RecyclerView.AbstractC0269.FLAG_APPEARED_IN_PRE_LAYOUT);
                    }
                    accessibilityNodeInfo.setScrollable(true);
                }
                return;
            }
            i = 0;
            new C1782(accessibilityNodeInfo).m4663(C1782.C1784.m4673(i2, i, false, 0));
            int i32 = Build.VERSION.SDK_INT;
            adapter = ViewPager2.this.getAdapter();
            if (adapter != null) {
                if (ViewPager2.this.f1802 > 0) {
                }
                if (ViewPager2.this.f1802 < itemCount - 1) {
                }
                accessibilityNodeInfo.setScrollable(true);
            }
        }
    }

    public ViewPager2(Context context) {
        super(context);
        m1024(context, (AttributeSet) null);
    }

    public boolean canScrollHorizontally(int i) {
        return this.f1804.canScrollHorizontally(i);
    }

    public boolean canScrollVertically(int i) {
        return this.f1804.canScrollVertically(i);
    }

    @Override // android.view.View, android.view.ViewGroup
    public void dispatchRestoreInstanceState(SparseArray<Parcelable> sparseArray) {
        Parcelable parcelable = sparseArray.get(getId());
        if (parcelable instanceof SavedState) {
            int i = ((SavedState) parcelable).f1818;
            sparseArray.put(this.f1804.getId(), sparseArray.get(i));
            sparseArray.remove(i);
        }
        super.dispatchRestoreInstanceState(sparseArray);
        m1019();
    }

    public CharSequence getAccessibilityClassName() {
        if (this.f1799.m1044()) {
            return this.f1799.m1031();
        }
        return super.getAccessibilityClassName();
    }

    public RecyclerView.AbstractC0246 getAdapter() {
        return this.f1804.getAdapter();
    }

    public int getCurrentItem() {
        return this.f1802;
    }

    public int getItemDecorationCount() {
        return this.f1804.getItemDecorationCount();
    }

    public int getOffscreenPageLimit() {
        return this.f1815;
    }

    public int getOrientation() {
        return this.f1814.getOrientation();
    }

    public int getPageSize() {
        int i;
        int i2;
        RecyclerView recyclerView = this.f1804;
        if (getOrientation() == 0) {
            i = recyclerView.getWidth() - recyclerView.getPaddingLeft();
            i2 = recyclerView.getPaddingRight();
        } else {
            i = recyclerView.getHeight() - recyclerView.getPaddingTop();
            i2 = recyclerView.getPaddingBottom();
        }
        return i - i2;
    }

    public int getScrollState() {
        return this.f1816.f7673;
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        this.f1799.m1040(accessibilityNodeInfo);
    }

    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        int measuredWidth = this.f1804.getMeasuredWidth();
        int measuredHeight = this.f1804.getMeasuredHeight();
        this.f1806.left = getPaddingLeft();
        this.f1806.right = (i3 - i) - getPaddingRight();
        this.f1806.top = getPaddingTop();
        this.f1806.bottom = (i4 - i2) - getPaddingBottom();
        Gravity.apply(BadgeDrawable.TOP_START, measuredWidth, measuredHeight, this.f1806, this.f1797);
        RecyclerView recyclerView = this.f1804;
        Rect rect = this.f1797;
        recyclerView.layout(rect.left, rect.top, rect.right, rect.bottom);
        if (this.f1812) {
            m1027();
        }
    }

    public void onMeasure(int i, int i2) {
        measureChild(this.f1804, i, i2);
        int measuredWidth = this.f1804.getMeasuredWidth();
        int measuredHeight = this.f1804.getMeasuredHeight();
        int measuredState = this.f1804.getMeasuredState();
        int paddingRight = getPaddingRight() + getPaddingLeft() + measuredWidth;
        int paddingTop = getPaddingTop();
        setMeasuredDimension(ViewGroup.resolveSizeAndState(Math.max(paddingRight, getSuggestedMinimumWidth()), i, measuredState), ViewGroup.resolveSizeAndState(Math.max(getPaddingBottom() + paddingTop + measuredHeight, getSuggestedMinimumHeight()), i2, measuredState << 16));
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof SavedState)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        SavedState savedState = (SavedState) parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.f1805 = savedState.f1817;
        this.f1811 = savedState.f1819;
    }

    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.f1818 = this.f1804.getId();
        int i = this.f1805;
        if (i == -1) {
            i = this.f1802;
        }
        savedState.f1817 = i;
        Parcelable parcelable = this.f1811;
        if (parcelable != null) {
            savedState.f1819 = parcelable;
        } else {
            RecyclerView.AbstractC0246 adapter = this.f1804.getAdapter();
            if (adapter instanceof AbstractC2208) {
                savedState.f1819 = ((AbstractC2208) adapter).m5836();
            }
        }
        return savedState;
    }

    public void onViewAdded(View view) {
        throw new IllegalStateException(ViewPager2.class.getSimpleName() + " does not support direct child views");
    }

    public boolean performAccessibilityAction(int i, Bundle bundle) {
        if (this.f1799.m1046(i, bundle)) {
            return this.f1799.m1037(i, bundle);
        }
        return super.performAccessibilityAction(i, bundle);
    }

    public void setAdapter(RecyclerView.AbstractC0246 r3) {
        RecyclerView.AbstractC0246<?> adapter = this.f1804.getAdapter();
        this.f1799.m1034(adapter);
        if (adapter != null) {
            adapter.unregisterAdapterDataObserver(this.f1807);
        }
        this.f1804.setAdapter(r3);
        this.f1802 = 0;
        m1019();
        this.f1799.m1041(r3);
        if (r3 != null) {
            r3.registerAdapterDataObserver(this.f1807);
        }
    }

    public void setCurrentItem(int i) {
        m1023(i, true);
    }

    public void setLayoutDirection(int i) {
        super.setLayoutDirection(i);
        this.f1799.m1047();
    }

    public void setOffscreenPageLimit(int i) {
        if (i >= 1 || i == -1) {
            this.f1815 = i;
            this.f1804.requestLayout();
            return;
        }
        throw new IllegalArgumentException("Offscreen page limit must be OFFSCREEN_PAGE_LIMIT_DEFAULT or a number > 0");
    }

    public void setOrientation(int i) {
        this.f1814.setOrientation(i);
        this.f1799.m1049();
    }

    public void setPageTransformer(AbstractC0312 r4) {
        if (r4 != null) {
            if (!this.f1810) {
                this.f1803 = this.f1804.getItemAnimator();
                this.f1810 = true;
            }
            this.f1804.setItemAnimator(null);
        } else if (this.f1810) {
            this.f1804.setItemAnimator(this.f1803);
            this.f1803 = null;
            this.f1810 = false;
        }
        this.f1800.m5826();
        if (r4 != null) {
            this.f1800.m5827(r4);
            m1028();
        }
    }

    public void setUserInputEnabled(boolean z) {
        this.f1801 = z;
        this.f1799.m1033();
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public boolean m1018() {
        return this.f1801;
    }

    /* renamed from: ඓ  reason: contains not printable characters */
    public final void m1019() {
        RecyclerView.AbstractC0246 adapter;
        if (this.f1805 != -1 && (adapter = getAdapter()) != null) {
            Parcelable parcelable = this.f1811;
            if (parcelable != null) {
                if (adapter instanceof AbstractC2208) {
                    ((AbstractC2208) adapter).m5837(parcelable);
                }
                this.f1811 = null;
            }
            this.f1802 = Math.max(0, Math.min(this.f1805, adapter.getItemCount() - 1));
            this.f1805 = -1;
            this.f1804.scrollToPosition(this.f1802);
            this.f1799.m1048();
        }
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public boolean m1022() {
        return this.f1814.getLayoutDirection() == 1;
    }

    /* JADX INFO: finally extract failed */
    /* renamed from: K  reason: contains not printable characters */
    public final void m1024(Context context, AttributeSet attributeSet) {
        this.f1799 = new C0320();
        this.f1804 = new C0311(context);
        this.f1804.setId(C1729.m4458());
        this.f1804.setDescendantFocusability(131072);
        this.f1814 = new C0318(context);
        this.f1804.setLayoutManager(this.f1814);
        this.f1804.setScrollingTouchSlop(1);
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, R$styleable.ViewPager2);
        if (Build.VERSION.SDK_INT >= 29) {
            saveAttributeDataForStyleable(context, R$styleable.ViewPager2, attributeSet, obtainStyledAttributes, 0, 0);
        }
        try {
            setOrientation(obtainStyledAttributes.getInt(R$styleable.ViewPager2_android_orientation, 0));
            obtainStyledAttributes.recycle();
            this.f1804.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            this.f1804.addOnChildAttachStateChangeListener(new C2203(this));
            this.f1816 = new C2205(this);
            this.f1809 = new C2207(this, this.f1816, this.f1804);
            this.f1808 = new C0317();
            this.f1808.m6011(this.f1804);
            this.f1804.addOnScrollListener(this.f1816);
            this.f1798 = new C2200(3);
            this.f1816.f7670 = this.f1798;
            C0313 r9 = new C0313();
            C0309 r0 = new C0309();
            this.f1798.f7660.add(r9);
            this.f1798.f7660.add(r0);
            this.f1799.m1043(this.f1798, this.f1804);
            C2200 r92 = this.f1798;
            r92.f7660.add(this.f1813);
            this.f1800 = new C2201(this.f1814);
            C2200 r93 = this.f1798;
            r93.f7660.add(this.f1800);
            RecyclerView recyclerView = this.f1804;
            attachViewToParent(recyclerView, 0, recyclerView.getLayoutParams());
        } catch (Throwable th) {
            obtainStyledAttributes.recycle();
            throw th;
        }
    }

    /* renamed from: 㴹  reason: contains not printable characters */
    public void m1027() {
        C2331 r0 = this.f1808;
        if (r0 != null) {
            View r02 = r0.m6113(this.f1814);
            if (r02 != null) {
                int position = this.f1814.getPosition(r02);
                if (position != this.f1802 && getScrollState() == 0) {
                    this.f1798.onPageSelected(position);
                }
                this.f1812 = false;
                return;
            }
            return;
        }
        throw new IllegalStateException("Design assumption violated.");
    }

    /* renamed from: 㸾  reason: contains not printable characters */
    public void m1028() {
        this.f1800.m5826();
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public void m1020(int i, boolean z) {
        RecyclerView.AbstractC0246 adapter = getAdapter();
        boolean z2 = false;
        if (adapter == null) {
            if (this.f1805 != -1) {
                this.f1805 = Math.max(i, 0);
            }
        } else if (adapter.getItemCount() > 0) {
            int min = Math.min(Math.max(i, 0), adapter.getItemCount() - 1);
            if (min == this.f1802) {
                if (this.f1816.f7673 == 0) {
                    return;
                }
            }
            if (min != this.f1802 || !z) {
                double d = (double) this.f1802;
                this.f1802 = min;
                this.f1799.m1038();
                if (!(this.f1816.f7673 == 0)) {
                    C2205 r0 = this.f1816;
                    r0.m5831();
                    C2205.C2206 k = r0.f7669;
                    d = ((double) k.f7679) + ((double) k.f7678);
                }
                C2205 r02 = this.f1816;
                r02.f7665 = z ? 2 : 3;
                r02.f7676 = false;
                if (r02.f7667 != min) {
                    z2 = true;
                }
                r02.f7667 = min;
                r02.m5832(2);
                if (z2) {
                    r02.m5834(min);
                }
                if (!z) {
                    this.f1804.scrollToPosition(min);
                    return;
                }
                double d2 = (double) min;
                if (Math.abs(d2 - d) > 3.0d) {
                    this.f1804.scrollToPosition(d2 > d ? min - 3 : min + 3);
                    RecyclerView recyclerView = this.f1804;
                    recyclerView.post(new RunnableC0316(min, recyclerView));
                    return;
                }
                this.f1804.smoothScrollToPosition(min);
            }
        }
    }

    public static class SavedState extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new C0308();

        /* renamed from: ʬ  reason: contains not printable characters */
        public int f1817;

        /* renamed from: ῲ  reason: contains not printable characters */
        public int f1818;

        /* renamed from: 㸾  reason: contains not printable characters */
        public Parcelable f1819;

        /* renamed from: androidx.viewpager2.widget.ViewPager2$SavedState$K  reason: contains not printable characters */
        public static class C0308 implements Parcelable.ClassLoaderCreator<SavedState> {
            @Override // android.os.Parcelable.ClassLoaderCreator
            public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return Build.VERSION.SDK_INT >= 24 ? new SavedState(parcel, classLoader) : new SavedState(parcel);
            }

            @Override // android.os.Parcelable.Creator
            public Object[] newArray(int i) {
                return new SavedState[i];
            }

            /* Return type fixed from 'java.lang.Object' to match base method */
            @Override // android.os.Parcelable.ClassLoaderCreator
            /* renamed from: createFromParcel  reason: collision with other method in class */
            public SavedState m1029createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return Build.VERSION.SDK_INT >= 24 ? new SavedState(parcel, classLoader) : new SavedState(parcel);
            }

            @Override // android.os.Parcelable.Creator
            public Object createFromParcel(Parcel parcel) {
                return createFromParcel(parcel, (ClassLoader) null);
            }
        }

        public SavedState(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            this.f1818 = parcel.readInt();
            this.f1817 = parcel.readInt();
            this.f1819 = parcel.readParcelable(classLoader);
        }

        public void writeToParcel(Parcel parcel, int i) {
            super.writeToParcel(parcel, i);
            parcel.writeInt(this.f1818);
            parcel.writeInt(this.f1817);
            parcel.writeParcelable(this.f1819, i);
        }

        public SavedState(Parcel parcel) {
            super(parcel);
            this.f1818 = parcel.readInt();
            this.f1817 = parcel.readInt();
            this.f1819 = parcel.readParcelable(null);
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }
    }

    public ViewPager2(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        m1024(context, attributeSet);
    }

    public ViewPager2(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        m1024(context, attributeSet);
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public void m1021(AbstractC0314 r2) {
        this.f1813.f7660.remove(r2);
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m1023(int i, boolean z) {
        if (!m1026()) {
            m1020(i, z);
            return;
        }
        throw new IllegalStateException("Cannot change current item when ViewPager2 is fake dragging");
    }

    /* renamed from: K  reason: contains not printable characters */
    public boolean m1026() {
        return this.f1809.f7680.f7676;
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m1025(AbstractC0314 r2) {
        this.f1813.f7660.add(r2);
    }
}
