package androidx.viewpager.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SoundEffectConstants;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.animation.Interpolator;
import android.widget.EdgeEffect;
import android.widget.Scroller;
import androidx.customview.view.AbsSavedState;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.progressindicator.BaseProgressIndicator;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import ඓ.K.K.K.C1293;
import ῲ.ᨨ.ᨨ.AbstractC1777;
import ῲ.ᨨ.ᨨ.C1729;
import ῲ.ᨨ.ᨨ.C1747;
import ῲ.ᨨ.ᨨ.C1754;
import ῲ.ᨨ.ᨨ.䃖.C1782;
import ῲ.ᨨ.ῲ.C1806;
import ῲ.ゎ.K.AbstractC2199;

public class ViewPager extends ViewGroup {

    /* renamed from: ݰ  reason: contains not printable characters */
    public static final C0303 f1720 = new C0303();

    /* renamed from: ᔝ  reason: contains not printable characters */
    public static final int[] f1721 = {16842931};

    /* renamed from: ₱  reason: contains not printable characters */
    public static final Interpolator f1722 = new animation.InterpolatorC0300();

    /* renamed from: 㗼  reason: contains not printable characters */
    public static final Comparator<C0305> f1723 = new C0302();

    /* renamed from: ʬ  reason: contains not printable characters */
    public final ArrayList<C0305> f1724 = new ArrayList<>();

    /* renamed from: Ϸ  reason: contains not printable characters */
    public List<AbstractC0299> f1725;

    /* renamed from: В  reason: contains not printable characters */
    public VelocityTracker f1726;

    /* renamed from: ѷ  reason: contains not printable characters */
    public EdgeEffect f1727;

    /* renamed from: ӯ  reason: contains not printable characters */
    public final Runnable f1728 = new RunnableC0296();

    /* renamed from: Ԕ  reason: contains not printable characters */
    public int f1729;

    /* renamed from: Ԛ  reason: contains not printable characters */
    public boolean f1730;

    /* renamed from: ؿ  reason: contains not printable characters */
    public int f1731;

    /* renamed from: ݜ  reason: contains not printable characters */
    public float f1732 = Float.MAX_VALUE;

    /* renamed from: ࠋ  reason: contains not printable characters */
    public boolean f1733;

    /* renamed from: ಯ  reason: contains not printable characters */
    public int f1734;

    /* renamed from: ඓ  reason: contains not printable characters */
    public final Rect f1735 = new Rect();

    /* renamed from: ผ  reason: contains not printable characters */
    public int f1736;

    /* renamed from: ᆯ  reason: contains not printable characters */
    public float f1737;

    /* renamed from: ሽ  reason: contains not printable characters */
    public float f1738;

    /* renamed from: ጒ  reason: contains not printable characters */
    public int f1739;

    /* renamed from: Ꮝ  reason: contains not printable characters */
    public int f1740;

    /* renamed from: ᑓ  reason: contains not printable characters */
    public boolean f1741;

    /* renamed from: ᑾ  reason: contains not printable characters */
    public int f1742 = -1;

    /* renamed from: ᓆ  reason: contains not printable characters */
    public boolean f1743;

    /* renamed from: ᓣ  reason: contains not printable characters */
    public int f1744;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public Scroller f1745;

    /* renamed from: ᝁ  reason: contains not printable characters */
    public float f1746;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public Parcelable f1747 = null;

    /* renamed from: ᴊ  reason: contains not printable characters */
    public ArrayList<View> f1748;

    /* renamed from: ᶲ  reason: contains not printable characters */
    public boolean f1749 = true;

    /* renamed from: ῲ  reason: contains not printable characters */
    public int f1750;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public int f1751;

    /* renamed from: ⶍ  reason: contains not printable characters */
    public float f1752;

    /* renamed from: ゎ  reason: contains not printable characters */
    public boolean f1753;

    /* renamed from: ト  reason: contains not printable characters */
    public int f1754;

    /* renamed from: ピ  reason: contains not printable characters */
    public AbstractC0304 f1755;

    /* renamed from: 㑃  reason: contains not printable characters */
    public boolean f1756;

    /* renamed from: 㒁  reason: contains not printable characters */
    public boolean f1757;

    /* renamed from: 㓚  reason: contains not printable characters */
    public AbstractC0304 f1758;

    /* renamed from: 㗗  reason: contains not printable characters */
    public Drawable f1759;

    /* renamed from: 㗽  reason: contains not printable characters */
    public float f1760 = -3.4028235E38f;

    /* renamed from: 㮔  reason: contains not printable characters */
    public int f1761;

    /* renamed from: 㮝  reason: contains not printable characters */
    public int f1762;

    /* renamed from: 㱶  reason: contains not printable characters */
    public List<AbstractC0304> f1763;

    /* renamed from: 㳳  reason: contains not printable characters */
    public ClassLoader f1764 = null;

    /* renamed from: 㴪  reason: contains not printable characters */
    public int f1765 = 1;

    /* renamed from: 㴹  reason: contains not printable characters */
    public AbstractC2199 f1766;

    /* renamed from: 㵟  reason: contains not printable characters */
    public int f1767 = 0;

    /* renamed from: 㶋  reason: contains not printable characters */
    public boolean f1768;

    /* renamed from: 㷛  reason: contains not printable characters */
    public EdgeEffect f1769;

    /* renamed from: 㸾  reason: contains not printable characters */
    public final C0305 f1770 = new C0305();

    /* renamed from: 㹎  reason: contains not printable characters */
    public int f1771;

    /* renamed from: 㿎  reason: contains not printable characters */
    public int f1772 = -1;

    /* renamed from: 䀟  reason: contains not printable characters */
    public int f1773;

    /* renamed from: 䁗  reason: contains not printable characters */
    public C0298 f1774;

    /* renamed from: 䃖  reason: contains not printable characters */
    public int f1775;

    public static class SavedState extends AbsSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new C0295();

        /* renamed from: ʬ  reason: contains not printable characters */
        public Parcelable f1776;

        /* renamed from: ῲ  reason: contains not printable characters */
        public int f1777;

        /* renamed from: 㸾  reason: contains not printable characters */
        public ClassLoader f1778;

        /* renamed from: androidx.viewpager.widget.ViewPager$SavedState$K  reason: contains not printable characters */
        public static class C0295 implements Parcelable.ClassLoaderCreator<SavedState> {
            /* Return type fixed from 'java.lang.Object' to match base method */
            @Override // android.os.Parcelable.ClassLoaderCreator
            public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new SavedState(parcel, classLoader);
            }

            @Override // android.os.Parcelable.Creator
            public Object[] newArray(int i) {
                return new SavedState[i];
            }

            @Override // android.os.Parcelable.Creator
            public Object createFromParcel(Parcel parcel) {
                return new SavedState(parcel, null);
            }
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public String toString() {
            StringBuilder r0 = C1293.m3416("FragmentPager.SavedState{");
            r0.append(Integer.toHexString(System.identityHashCode(this)));
            r0.append(" position=");
            r0.append(this.f1777);
            r0.append("}");
            return r0.toString();
        }

        @Override // androidx.customview.view.AbsSavedState
        public void writeToParcel(Parcel parcel, int i) {
            super.writeToParcel(parcel, i);
            parcel.writeInt(this.f1777);
            parcel.writeParcelable(this.f1776, i);
        }

        public SavedState(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            classLoader = classLoader == null ? SavedState.class.getClassLoader() : classLoader;
            this.f1777 = parcel.readInt();
            this.f1776 = parcel.readParcelable(classLoader);
            this.f1778 = classLoader;
        }
    }

    /* renamed from: androidx.viewpager.widget.ViewPager$ʬ  reason: contains not printable characters */
    public class RunnableC0296 implements Runnable {
        public RunnableC0296() {
        }

        public void run() {
            ViewPager.this.setScrollState(0);
            ViewPager.this.m1011();
        }
    }

    @Target({ElementType.TYPE})
    @Inherited
    @Retention(RetentionPolicy.RUNTIME)
    /* renamed from: androidx.viewpager.widget.ViewPager$ඓ  reason: contains not printable characters */
    public @interface AbstractC0297 {
    }

    /* renamed from: androidx.viewpager.widget.ViewPager$ᕣ  reason: contains not printable characters */
    public class C0298 extends DataSetObserver {
        public C0298() {
        }

        public void onChanged() {
            ViewPager.this.m998();
        }

        public void onInvalidated() {
            ViewPager.this.m998();
        }
    }

    /* renamed from: androidx.viewpager.widget.ViewPager$ᨨ  reason: contains not printable characters */
    public interface AbstractC0299 {
        void onAdapterChanged(ViewPager viewPager, AbstractC2199 k, AbstractC2199 k2);
    }

    /* renamed from: androidx.viewpager.widget.ViewPager$ῲ  reason: contains not printable characters */
    public static class animation.InterpolatorC0300 implements Interpolator {
        public float getInterpolation(float f) {
            float f2 = f - 1.0f;
            return (f2 * f2 * f2 * f2 * f2) + 1.0f;
        }
    }

    /* renamed from: androidx.viewpager.widget.ViewPager$K  reason: contains not printable characters */
    public static class C0302 implements Comparator<C0305> {
        /* JADX DEBUG: Method arguments types fixed to match base method, original types: [java.lang.Object, java.lang.Object] */
        @Override // java.util.Comparator
        public int compare(C0305 r1, C0305 r2) {
            return r1.f1789 - r2.f1789;
        }
    }

    /* renamed from: androidx.viewpager.widget.ViewPager$㑃  reason: contains not printable characters */
    public static class C0303 implements Comparator<View> {
        /* JADX DEBUG: Method arguments types fixed to match base method, original types: [java.lang.Object, java.lang.Object] */
        @Override // java.util.Comparator
        public int compare(View view, View view2) {
            C0301 r3 = (C0301) view.getLayoutParams();
            C0301 r4 = (C0301) view2.getLayoutParams();
            boolean z = r3.f1784;
            if (z != r4.f1784) {
                return z ? 1 : -1;
            }
            return r3.f1782 - r4.f1782;
        }
    }

    /* renamed from: androidx.viewpager.widget.ViewPager$㳳  reason: contains not printable characters */
    public interface AbstractC0304 {
        void onPageScrollStateChanged(int i);

        void onPageScrolled(int i, float f, int i2);

        void onPageSelected(int i);
    }

    /* renamed from: androidx.viewpager.widget.ViewPager$㴹  reason: contains not printable characters */
    public static class C0305 {

        /* renamed from: ʬ  reason: contains not printable characters */
        public boolean f1787;

        /* renamed from: ඓ  reason: contains not printable characters */
        public float f1788;

        /* renamed from: ῲ  reason: contains not printable characters */
        public int f1789;

        /* renamed from: K  reason: contains not printable characters */
        public Object f1790;

        /* renamed from: 㸾  reason: contains not printable characters */
        public float f1791;
    }

    /* renamed from: androidx.viewpager.widget.ViewPager$㸾  reason: contains not printable characters */
    public class C0306 implements AbstractC1777 {

        /* renamed from: K  reason: contains not printable characters */
        public final Rect f1793 = new Rect();

        public C0306() {
        }

        @Override // ῲ.ᨨ.ᨨ.AbstractC1777
        public C1754 onApplyWindowInsets(View view, C1754 r7) {
            C1754 r6 = C1729.m4460(view, r7);
            if (r6.m4562()) {
                return r6;
            }
            Rect rect = this.f1793;
            rect.left = r6.m4556();
            rect.top = r6.m4557();
            rect.right = r6.m4563();
            rect.bottom = r6.m4558();
            int childCount = ViewPager.this.getChildCount();
            for (int i = 0; i < childCount; i++) {
                C1754 r2 = C1729.m4468(ViewPager.this.getChildAt(i), r6);
                rect.left = Math.min(r2.m4556(), rect.left);
                rect.top = Math.min(r2.m4557(), rect.top);
                rect.right = Math.min(r2.m4563(), rect.right);
                rect.bottom = Math.min(r2.m4558(), rect.bottom);
            }
            return r6.m4561(rect.left, rect.top, rect.right, rect.bottom);
        }
    }

    /* renamed from: androidx.viewpager.widget.ViewPager$㿎  reason: contains not printable characters */
    public class C0307 extends C1747 {
        public C0307() {
        }

        @Override // ῲ.ᨨ.ᨨ.C1747
        public void onInitializeAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
            AbstractC2199 k;
            super.onInitializeAccessibilityEvent(view, accessibilityEvent);
            accessibilityEvent.setClassName(ViewPager.class.getName());
            AbstractC2199 k2 = ViewPager.this.f1766;
            boolean z = true;
            if (k2 == null || k2.m5813() <= 1) {
                z = false;
            }
            accessibilityEvent.setScrollable(z);
            if (accessibilityEvent.getEventType() == 4096 && (k = ViewPager.this.f1766) != null) {
                accessibilityEvent.setItemCount(k.m5813());
                accessibilityEvent.setFromIndex(ViewPager.this.f1751);
                accessibilityEvent.setToIndex(ViewPager.this.f1751);
            }
        }

        @Override // ῲ.ᨨ.ᨨ.C1747
        public void onInitializeAccessibilityNodeInfo(View view, C1782 r4) {
            super.onInitializeAccessibilityNodeInfo(view, r4);
            r4.f6124.setClassName(ViewPager.class.getName());
            AbstractC2199 k = ViewPager.this.f1766;
            r4.f6124.setScrollable(k != null && k.m5813() > 1);
            if (ViewPager.this.canScrollHorizontally(1)) {
                r4.f6124.addAction(RecyclerView.AbstractC0269.FLAG_APPEARED_IN_PRE_LAYOUT);
            }
            if (ViewPager.this.canScrollHorizontally(-1)) {
                r4.f6124.addAction(8192);
            }
        }

        @Override // ῲ.ᨨ.ᨨ.C1747
        public boolean performAccessibilityAction(View view, int i, Bundle bundle) {
            if (super.performAccessibilityAction(view, i, bundle)) {
                return true;
            }
            if (i != 4096) {
                if (i != 8192 || !ViewPager.this.canScrollHorizontally(-1)) {
                    return false;
                }
                ViewPager viewPager = ViewPager.this;
                viewPager.setCurrentItem(viewPager.f1751 - 1);
                return true;
            } else if (!ViewPager.this.canScrollHorizontally(1)) {
                return false;
            } else {
                ViewPager viewPager2 = ViewPager.this;
                viewPager2.setCurrentItem(viewPager2.f1751 + 1);
                return true;
            }
        }
    }

    public ViewPager(Context context) {
        super(context);
        m984();
    }

    private int getClientWidth() {
        return (getMeasuredWidth() - getPaddingLeft()) - getPaddingRight();
    }

    private void setScrollingCacheEnabled(boolean z) {
        if (this.f1768 != z) {
            this.f1768 = z;
        }
    }

    @Override // android.view.View, android.view.ViewGroup
    public void addFocusables(ArrayList<View> arrayList, int i, int i2) {
        C0305 r4;
        int size = arrayList.size();
        int descendantFocusability = getDescendantFocusability();
        if (descendantFocusability != 393216) {
            for (int i3 = 0; i3 < getChildCount(); i3++) {
                View childAt = getChildAt(i3);
                if (childAt.getVisibility() == 0 && (r4 = m988(childAt)) != null && r4.f1789 == this.f1751) {
                    childAt.addFocusables(arrayList, i, i2);
                }
            }
        }
        if ((descendantFocusability == 262144 && size != arrayList.size()) || !isFocusable()) {
            return;
        }
        if ((i2 & 1) != 1 || !isInTouchMode() || isFocusableInTouchMode()) {
            arrayList.add(this);
        }
    }

    public void addOnAdapterChangeListener(AbstractC0299 r2) {
        if (this.f1725 == null) {
            this.f1725 = new ArrayList();
        }
        this.f1725.add(r2);
    }

    public void addOnPageChangeListener(AbstractC0304 r2) {
        if (this.f1763 == null) {
            this.f1763 = new ArrayList();
        }
        this.f1763.add(r2);
    }

    @Override // android.view.View, android.view.ViewGroup
    public void addTouchables(ArrayList<View> arrayList) {
        C0305 r2;
        for (int i = 0; i < getChildCount(); i++) {
            View childAt = getChildAt(i);
            if (childAt.getVisibility() == 0 && (r2 = m988(childAt)) != null && r2.f1789 == this.f1751) {
                childAt.addTouchables(arrayList);
            }
        }
    }

    @Override // android.view.ViewGroup
    public void addView(View view, int i, ViewGroup.LayoutParams layoutParams) {
        if (!checkLayoutParams(layoutParams)) {
            layoutParams = generateLayoutParams(layoutParams);
        }
        C0301 r0 = (C0301) layoutParams;
        r0.f1784 |= view.getClass().getAnnotation(AbstractC0297.class) != null;
        if (!this.f1730) {
            super.addView(view, i, layoutParams);
        } else if (!r0.f1784) {
            r0.f1786 = true;
            addViewInLayout(view, i, layoutParams);
        } else {
            throw new IllegalStateException("Cannot add pager decor view during layout");
        }
    }

    public boolean canScrollHorizontally(int i) {
        if (this.f1766 == null) {
            return false;
        }
        int clientWidth = getClientWidth();
        int scrollX = getScrollX();
        if (i < 0) {
            if (scrollX > ((int) (((float) clientWidth) * this.f1760))) {
                return true;
            }
            return false;
        } else if (i <= 0 || scrollX >= ((int) (((float) clientWidth) * this.f1732))) {
            return false;
        } else {
            return true;
        }
    }

    public boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return (layoutParams instanceof C0301) && super.checkLayoutParams(layoutParams);
    }

    public void computeScroll() {
        this.f1756 = true;
        if (this.f1745.isFinished() || !this.f1745.computeScrollOffset()) {
            m1007(true);
            return;
        }
        int scrollX = getScrollX();
        int scrollY = getScrollY();
        int currX = this.f1745.getCurrX();
        int currY = this.f1745.getCurrY();
        if (!(scrollX == currX && scrollY == currY)) {
            scrollTo(currX, currY);
            if (!m1013(currX)) {
                this.f1745.abortAnimation();
                scrollTo(0, currY);
            }
        }
        C1729.m4449(this);
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return super.dispatchKeyEvent(keyEvent) || m1009(keyEvent);
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        C0305 r4;
        if (accessibilityEvent.getEventType() == 4096) {
            return super.dispatchPopulateAccessibilityEvent(accessibilityEvent);
        }
        int childCount = getChildCount();
        for (int i = 0; i < childCount; i++) {
            View childAt = getChildAt(i);
            if (childAt.getVisibility() == 0 && (r4 = m988(childAt)) != null && r4.f1789 == this.f1751 && childAt.dispatchPopulateAccessibilityEvent(accessibilityEvent)) {
                return true;
            }
        }
        return false;
    }

    public void draw(Canvas canvas) {
        AbstractC2199 k;
        super.draw(canvas);
        int overScrollMode = getOverScrollMode();
        boolean z = false;
        if (overScrollMode == 0 || (overScrollMode == 1 && (k = this.f1766) != null && k.m5813() > 1)) {
            if (!this.f1769.isFinished()) {
                int save = canvas.save();
                int height = (getHeight() - getPaddingTop()) - getPaddingBottom();
                int width = getWidth();
                canvas.rotate(270.0f);
                canvas.translate((float) (getPaddingTop() + (-height)), this.f1760 * ((float) width));
                this.f1769.setSize(height, width);
                z = false | this.f1769.draw(canvas);
                canvas.restoreToCount(save);
            }
            if (!this.f1727.isFinished()) {
                int save2 = canvas.save();
                int width2 = getWidth();
                int height2 = (getHeight() - getPaddingTop()) - getPaddingBottom();
                canvas.rotate(90.0f);
                canvas.translate((float) (-getPaddingTop()), (-(this.f1732 + 1.0f)) * ((float) width2));
                this.f1727.setSize(height2, width2);
                z |= this.f1727.draw(canvas);
                canvas.restoreToCount(save2);
            }
        } else {
            this.f1769.finish();
            this.f1727.finish();
        }
        if (z) {
            C1729.m4449(this);
        }
    }

    public void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable drawable = this.f1759;
        if (drawable != null && drawable.isStateful()) {
            drawable.setState(getDrawableState());
        }
    }

    public ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new C0301();
    }

    @Override // android.view.ViewGroup
    public ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return generateDefaultLayoutParams();
    }

    public AbstractC2199 getAdapter() {
        return this.f1766;
    }

    public int getChildDrawingOrder(int i, int i2) {
        if (this.f1740 == 2) {
            i2 = (i - 1) - i2;
        }
        return ((C0301) this.f1748.get(i2).getLayoutParams()).f1785;
    }

    public int getCurrentItem() {
        return this.f1751;
    }

    public int getOffscreenPageLimit() {
        return this.f1765;
    }

    public int getPageMargin() {
        return this.f1729;
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.f1749 = true;
    }

    public void onDetachedFromWindow() {
        removeCallbacks(this.f1728);
        Scroller scroller = this.f1745;
        if (scroller != null && !scroller.isFinished()) {
            this.f1745.abortAnimation();
        }
        super.onDetachedFromWindow();
    }

    public void onDraw(Canvas canvas) {
        float f;
        float f2;
        super.onDraw(canvas);
        if (this.f1729 > 0 && this.f1759 != null && this.f1724.size() > 0 && this.f1766 != null) {
            int scrollX = getScrollX();
            int width = getWidth();
            float f3 = (float) width;
            float f4 = ((float) this.f1729) / f3;
            int i = 0;
            C0305 r5 = this.f1724.get(0);
            float f5 = r5.f1788;
            int size = this.f1724.size();
            int i2 = r5.f1789;
            int i3 = this.f1724.get(size - 1).f1789;
            while (i2 < i3) {
                while (i2 > r5.f1789 && i < size) {
                    i++;
                    r5 = this.f1724.get(i);
                }
                if (i2 == r5.f1789) {
                    float f6 = r5.f1788;
                    float f7 = r5.f1791;
                    f = (f6 + f7) * f3;
                    f5 = f6 + f7 + f4;
                } else {
                    float r11 = this.f1766.m5806(i2);
                    f = (f5 + r11) * f3;
                    f5 = r11 + f4 + f5;
                }
                if (((float) this.f1729) + f > ((float) scrollX)) {
                    f2 = f4;
                    this.f1759.setBounds(Math.round(f), this.f1731, Math.round(((float) this.f1729) + f), this.f1744);
                    this.f1759.draw(canvas);
                } else {
                    f2 = f4;
                }
                if (f <= ((float) (scrollX + width))) {
                    i2++;
                    f4 = f2;
                } else {
                    return;
                }
            }
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        int action = motionEvent.getAction() & BaseProgressIndicator.MAX_ALPHA;
        if (action == 3 || action == 1) {
            m992();
            return false;
        }
        if (action != 0) {
            if (this.f1741) {
                return true;
            }
            if (this.f1753) {
                return false;
            }
        }
        if (action == 0) {
            float x = motionEvent.getX();
            this.f1752 = x;
            this.f1746 = x;
            float y = motionEvent.getY();
            this.f1738 = y;
            this.f1737 = y;
            this.f1742 = motionEvent.getPointerId(0);
            this.f1753 = false;
            this.f1756 = true;
            this.f1745.computeScrollOffset();
            if (this.f1767 != 2 || Math.abs(this.f1745.getFinalX() - this.f1745.getCurrX()) <= this.f1771) {
                m1007(false);
                this.f1741 = false;
            } else {
                this.f1745.abortAnimation();
                this.f1743 = false;
                m1011();
                this.f1741 = true;
                m990(true);
                setScrollState(1);
            }
        } else if (action == 2) {
            int i = this.f1742;
            if (i != -1) {
                int findPointerIndex = motionEvent.findPointerIndex(i);
                float x2 = motionEvent.getX(findPointerIndex);
                float f = x2 - this.f1746;
                float abs = Math.abs(f);
                float y2 = motionEvent.getY(findPointerIndex);
                float abs2 = Math.abs(y2 - this.f1738);
                int i2 = (f > 0.0f ? 1 : (f == 0.0f ? 0 : -1));
                if (i2 != 0) {
                    float f2 = this.f1746;
                    if (!((f2 < ((float) this.f1761) && i2 > 0) || (f2 > ((float) (getWidth() - this.f1761)) && f < 0.0f)) && m1010(this, false, (int) f, (int) x2, (int) y2)) {
                        this.f1746 = x2;
                        this.f1737 = y2;
                        this.f1753 = true;
                        return false;
                    }
                }
                if (abs > ((float) this.f1775) && abs * 0.5f > abs2) {
                    this.f1741 = true;
                    m990(true);
                    setScrollState(1);
                    float f3 = this.f1752;
                    float f4 = (float) this.f1775;
                    this.f1746 = i2 > 0 ? f3 + f4 : f3 - f4;
                    this.f1737 = y2;
                    setScrollingCacheEnabled(true);
                } else if (abs2 > ((float) this.f1775)) {
                    this.f1753 = true;
                }
                if (this.f1741 && m991(x2)) {
                    C1729.m4449(this);
                }
            }
        } else if (action == 6) {
            m1006(motionEvent);
        }
        if (this.f1726 == null) {
            this.f1726 = VelocityTracker.obtain();
        }
        this.f1726.addMovement(motionEvent);
        return this.f1741;
    }

    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        boolean z2;
        C0305 r9;
        int i5;
        int i6;
        int childCount = getChildCount();
        int i7 = i3 - i;
        int i8 = i4 - i2;
        int paddingLeft = getPaddingLeft();
        int paddingTop = getPaddingTop();
        int paddingRight = getPaddingRight();
        int paddingBottom = getPaddingBottom();
        int scrollX = getScrollX();
        int i9 = paddingBottom;
        int i10 = 0;
        int i11 = paddingTop;
        int i12 = paddingLeft;
        for (int i13 = 0; i13 < childCount; i13++) {
            View childAt = getChildAt(i13);
            if (childAt.getVisibility() != 8) {
                C0301 r12 = (C0301) childAt.getLayoutParams();
                if (r12.f1784) {
                    int i14 = r12.f1783;
                    int i15 = i14 & 7;
                    int i16 = i14 & 112;
                    if (i15 == 1) {
                        i5 = Math.max((i7 - childAt.getMeasuredWidth()) / 2, i12);
                    } else if (i15 == 3) {
                        i5 = i12;
                        i12 = childAt.getMeasuredWidth() + i12;
                    } else if (i15 != 5) {
                        i5 = i12;
                    } else {
                        i5 = (i7 - paddingRight) - childAt.getMeasuredWidth();
                        paddingRight += childAt.getMeasuredWidth();
                    }
                    if (i16 == 16) {
                        i6 = Math.max((i8 - childAt.getMeasuredHeight()) / 2, i11);
                    } else if (i16 == 48) {
                        i6 = i11;
                        i11 = childAt.getMeasuredHeight() + i11;
                    } else if (i16 != 80) {
                        i6 = i11;
                    } else {
                        i6 = (i8 - i9) - childAt.getMeasuredHeight();
                        i9 += childAt.getMeasuredHeight();
                    }
                    int i17 = i5 + scrollX;
                    childAt.layout(i17, i6, childAt.getMeasuredWidth() + i17, childAt.getMeasuredHeight() + i6);
                    i10++;
                }
            }
        }
        int i18 = (i7 - i12) - paddingRight;
        for (int i19 = 0; i19 < childCount; i19++) {
            View childAt2 = getChildAt(i19);
            if (childAt2.getVisibility() != 8) {
                C0301 r8 = (C0301) childAt2.getLayoutParams();
                if (!r8.f1784 && (r9 = m988(childAt2)) != null) {
                    float f = (float) i18;
                    int i20 = ((int) (r9.f1788 * f)) + i12;
                    if (r8.f1786) {
                        r8.f1786 = false;
                        childAt2.measure(View.MeasureSpec.makeMeasureSpec((int) (f * r8.f1781), 1073741824), View.MeasureSpec.makeMeasureSpec((i8 - i11) - i9, 1073741824));
                    }
                    childAt2.layout(i20, i11, childAt2.getMeasuredWidth() + i20, childAt2.getMeasuredHeight() + i11);
                }
            }
        }
        this.f1731 = i11;
        this.f1744 = i8 - i9;
        this.f1736 = i10;
        if (this.f1749) {
            z2 = false;
            m1003(this.f1751, false, 0, false);
        } else {
            z2 = false;
        }
        this.f1749 = z2;
    }

    /* JADX WARNING: Removed duplicated region for block: B:28:0x0084  */
    /* JADX WARNING: Removed duplicated region for block: B:31:0x008b  */
    /* JADX WARNING: Removed duplicated region for block: B:34:0x0090  */
    /* JADX WARNING: Removed duplicated region for block: B:36:0x0095  */
    /* JADX WARNING: Removed duplicated region for block: B:39:0x00a4  */
    /* JADX WARNING: Removed duplicated region for block: B:40:0x00aa  */
    public void onMeasure(int i, int i2) {
        C0301 r2;
        C0301 r3;
        int i3;
        int i4;
        int i5;
        setMeasuredDimension(ViewGroup.getDefaultSize(0, i), ViewGroup.getDefaultSize(0, i2));
        int measuredWidth = getMeasuredWidth();
        this.f1761 = Math.min(measuredWidth / 10, this.f1754);
        int paddingLeft = (measuredWidth - getPaddingLeft()) - getPaddingRight();
        int measuredHeight = (getMeasuredHeight() - getPaddingTop()) - getPaddingBottom();
        int childCount = getChildCount();
        int i6 = measuredHeight;
        int i7 = paddingLeft;
        int i8 = 0;
        while (true) {
            boolean z = true;
            int i9 = 1073741824;
            if (i8 >= childCount) {
                break;
            }
            View childAt = getChildAt(i8);
            if (!(childAt.getVisibility() == 8 || (r3 = (C0301) childAt.getLayoutParams()) == null || !r3.f1784)) {
                int i10 = r3.f1783;
                int i11 = i10 & 7;
                int i12 = i10 & 112;
                boolean z2 = i12 == 48 || i12 == 80;
                if (!(i11 == 3 || i11 == 5)) {
                    z = false;
                }
                int i13 = Integer.MIN_VALUE;
                if (z2) {
                    i13 = 1073741824;
                } else if (z) {
                    i3 = 1073741824;
                    i4 = ((ViewGroup.LayoutParams) r3).width;
                    if (i4 == -2) {
                        if (i4 == -1) {
                            i4 = i7;
                        }
                        i13 = 1073741824;
                    } else {
                        i4 = i7;
                    }
                    i5 = ((ViewGroup.LayoutParams) r3).height;
                    if (i5 != -2) {
                        i5 = i6;
                        i9 = i3;
                    } else if (i5 == -1) {
                        i5 = i6;
                    }
                    childAt.measure(View.MeasureSpec.makeMeasureSpec(i4, i13), View.MeasureSpec.makeMeasureSpec(i5, i9));
                    if (!z2) {
                        i6 -= childAt.getMeasuredHeight();
                    } else if (z) {
                        i7 -= childAt.getMeasuredWidth();
                    }
                }
                i3 = Integer.MIN_VALUE;
                i4 = ((ViewGroup.LayoutParams) r3).width;
                if (i4 == -2) {
                }
                i5 = ((ViewGroup.LayoutParams) r3).height;
                if (i5 != -2) {
                }
                childAt.measure(View.MeasureSpec.makeMeasureSpec(i4, i13), View.MeasureSpec.makeMeasureSpec(i5, i9));
                if (!z2) {
                }
            }
            i8++;
        }
        View.MeasureSpec.makeMeasureSpec(i7, 1073741824);
        this.f1773 = View.MeasureSpec.makeMeasureSpec(i6, 1073741824);
        this.f1730 = true;
        m1011();
        this.f1730 = false;
        int childCount2 = getChildCount();
        for (int i14 = 0; i14 < childCount2; i14++) {
            View childAt2 = getChildAt(i14);
            if (childAt2.getVisibility() != 8 && ((r2 = (C0301) childAt2.getLayoutParams()) == null || !r2.f1784)) {
                childAt2.measure(View.MeasureSpec.makeMeasureSpec((int) (((float) i7) * r2.f1781), 1073741824), this.f1773);
            }
        }
    }

    public boolean onRequestFocusInDescendants(int i, Rect rect) {
        int i2;
        int i3;
        C0305 r6;
        int childCount = getChildCount();
        int i4 = -1;
        if ((i & 2) != 0) {
            i4 = childCount;
            i3 = 0;
            i2 = 1;
        } else {
            i3 = childCount - 1;
            i2 = -1;
        }
        while (i3 != i4) {
            View childAt = getChildAt(i3);
            if (childAt.getVisibility() == 0 && (r6 = m988(childAt)) != null && r6.f1789 == this.f1751 && childAt.requestFocus(i, rect)) {
                return true;
            }
            i3 += i2;
        }
        return false;
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof SavedState)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        SavedState savedState = (SavedState) parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        AbstractC2199 k = this.f1766;
        if (k != null) {
            k.m5819(savedState.f1776, savedState.f1778);
            m1004(savedState.f1777, false, true);
            return;
        }
        this.f1772 = savedState.f1777;
        this.f1747 = savedState.f1776;
        this.f1764 = savedState.f1778;
    }

    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.f1777 = this.f1751;
        AbstractC2199 k = this.f1766;
        if (k != null) {
            savedState.f1776 = k.m5804();
        }
        return savedState;
    }

    public void onSizeChanged(int i, int i2, int i3, int i4) {
        super.onSizeChanged(i, i2, i3, i4);
        if (i != i3) {
            int i5 = this.f1729;
            m1001(i, i3, i5, i5);
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        AbstractC2199 k;
        if (this.f1757) {
            return true;
        }
        boolean z = false;
        if ((motionEvent.getAction() == 0 && motionEvent.getEdgeFlags() != 0) || (k = this.f1766) == null || k.m5813() == 0) {
            return false;
        }
        if (this.f1726 == null) {
            this.f1726 = VelocityTracker.obtain();
        }
        this.f1726.addMovement(motionEvent);
        int action = motionEvent.getAction() & BaseProgressIndicator.MAX_ALPHA;
        if (action == 0) {
            this.f1745.abortAnimation();
            this.f1743 = false;
            m1011();
            float x = motionEvent.getX();
            this.f1752 = x;
            this.f1746 = x;
            float y = motionEvent.getY();
            this.f1738 = y;
            this.f1737 = y;
            this.f1742 = motionEvent.getPointerId(0);
        } else if (action != 1) {
            if (action == 2) {
                if (!this.f1741) {
                    int findPointerIndex = motionEvent.findPointerIndex(this.f1742);
                    if (findPointerIndex == -1) {
                        z = m992();
                    } else {
                        float x2 = motionEvent.getX(findPointerIndex);
                        float abs = Math.abs(x2 - this.f1746);
                        float y2 = motionEvent.getY(findPointerIndex);
                        float abs2 = Math.abs(y2 - this.f1737);
                        if (abs > ((float) this.f1775) && abs > abs2) {
                            this.f1741 = true;
                            m990(true);
                            float f = this.f1752;
                            this.f1746 = x2 - f > 0.0f ? f + ((float) this.f1775) : f - ((float) this.f1775);
                            this.f1737 = y2;
                            setScrollState(1);
                            setScrollingCacheEnabled(true);
                            ViewParent parent = getParent();
                            if (parent != null) {
                                parent.requestDisallowInterceptTouchEvent(true);
                            }
                        }
                    }
                }
                if (this.f1741) {
                    z = false | m991(motionEvent.getX(motionEvent.findPointerIndex(this.f1742)));
                }
            } else if (action != 3) {
                if (action == 5) {
                    int actionIndex = motionEvent.getActionIndex();
                    this.f1746 = motionEvent.getX(actionIndex);
                    this.f1742 = motionEvent.getPointerId(actionIndex);
                } else if (action == 6) {
                    m1006(motionEvent);
                    this.f1746 = motionEvent.getX(motionEvent.findPointerIndex(this.f1742));
                }
            } else if (this.f1741) {
                m1003(this.f1751, true, 0, false);
                z = m992();
            }
        } else if (this.f1741) {
            VelocityTracker velocityTracker = this.f1726;
            velocityTracker.computeCurrentVelocity(1000, (float) this.f1734);
            int xVelocity = (int) velocityTracker.getXVelocity(this.f1742);
            this.f1743 = true;
            int clientWidth = getClientWidth();
            int scrollX = getScrollX();
            C0305 r6 = m987();
            float f2 = (float) clientWidth;
            float f3 = ((float) this.f1729) / f2;
            int i = r6.f1789;
            float f4 = ((((float) scrollX) / f2) - r6.f1788) / (r6.f1791 + f3);
            if (Math.abs((int) (motionEvent.getX(motionEvent.findPointerIndex(this.f1742)) - this.f1752)) <= this.f1739 || Math.abs(xVelocity) <= this.f1762) {
                i += (int) (f4 + (i >= this.f1751 ? 0.4f : 0.6f));
            } else if (xVelocity <= 0) {
                i++;
            }
            if (this.f1724.size() > 0) {
                ArrayList<C0305> arrayList = this.f1724;
                i = Math.max(this.f1724.get(0).f1789, Math.min(i, arrayList.get(arrayList.size() - 1).f1789));
            }
            m1005(i, true, true, xVelocity);
            z = m992();
        }
        if (z) {
            C1729.m4449(this);
        }
        return true;
    }

    public void removeOnAdapterChangeListener(AbstractC0299 r2) {
        List<AbstractC0299> list = this.f1725;
        if (list != null) {
            list.remove(r2);
        }
    }

    public void removeOnPageChangeListener(AbstractC0304 r2) {
        List<AbstractC0304> list = this.f1763;
        if (list != null) {
            list.remove(r2);
        }
    }

    public void removeView(View view) {
        if (this.f1730) {
            removeViewInLayout(view);
        } else {
            super.removeView(view);
        }
    }

    public void setAdapter(AbstractC2199 k) {
        AbstractC2199 k2 = this.f1766;
        if (k2 != null) {
            k2.m5808((DataSetObserver) null);
            this.f1766.m5811((ViewGroup) this);
            for (int i = 0; i < this.f1724.size(); i++) {
                C0305 r4 = this.f1724.get(i);
                this.f1766.m5823((ViewGroup) this, r4.f1789, r4.f1790);
            }
            this.f1766.m5822((ViewGroup) this);
            this.f1724.clear();
            int i2 = 0;
            while (i2 < getChildCount()) {
                if (!((C0301) getChildAt(i2).getLayoutParams()).f1784) {
                    removeViewAt(i2);
                    i2--;
                }
                i2++;
            }
            this.f1751 = 0;
            scrollTo(0, 0);
        }
        AbstractC2199 k3 = this.f1766;
        this.f1766 = k;
        this.f1750 = 0;
        if (this.f1766 != null) {
            if (this.f1774 == null) {
                this.f1774 = new C0298();
            }
            this.f1766.m5808(this.f1774);
            this.f1743 = false;
            boolean z = this.f1749;
            this.f1749 = true;
            this.f1750 = this.f1766.m5813();
            if (this.f1772 >= 0) {
                this.f1766.m5819(this.f1747, this.f1764);
                m1004(this.f1772, false, true);
                this.f1772 = -1;
                this.f1747 = null;
                this.f1764 = null;
            } else if (!z) {
                m1011();
            } else {
                requestLayout();
            }
        }
        List<AbstractC0299> list = this.f1725;
        if (!(list == null || list.isEmpty())) {
            int size = this.f1725.size();
            for (int i3 = 0; i3 < size; i3++) {
                this.f1725.get(i3).onAdapterChanged(this, k3, k);
            }
        }
    }

    public void setCurrentItem(int i) {
        this.f1743 = false;
        m1004(i, !this.f1749, false);
    }

    public void setOffscreenPageLimit(int i) {
        if (i < 1) {
            Log.w("ViewPager", "Requested offscreen page limit " + i + " too small; defaulting to " + 1);
            i = 1;
        }
        if (i != this.f1765) {
            this.f1765 = i;
            m1011();
        }
    }

    @Deprecated
    public void setOnPageChangeListener(AbstractC0304 r1) {
        this.f1755 = r1;
    }

    public void setPageMargin(int i) {
        int i2 = this.f1729;
        this.f1729 = i;
        int width = getWidth();
        m1001(width, width, i, i2);
        requestLayout();
    }

    public void setPageMarginDrawable(Drawable drawable) {
        this.f1759 = drawable;
        if (drawable != null) {
            refreshDrawableState();
        }
        setWillNotDraw(drawable == null);
        invalidate();
    }

    public void setScrollState(int i) {
        if (this.f1767 != i) {
            this.f1767 = i;
            AbstractC0304 r0 = this.f1755;
            if (r0 != null) {
                r0.onPageScrollStateChanged(i);
            }
            List<AbstractC0304> list = this.f1763;
            if (list != null) {
                int size = list.size();
                for (int i2 = 0; i2 < size; i2++) {
                    AbstractC0304 r2 = this.f1763.get(i2);
                    if (r2 != null) {
                        r2.onPageScrollStateChanged(i);
                    }
                }
            }
            AbstractC0304 r02 = this.f1758;
            if (r02 != null) {
                r02.onPageScrollStateChanged(i);
            }
        }
    }

    public boolean verifyDrawable(Drawable drawable) {
        return super.verifyDrawable(drawable) || drawable == this.f1759;
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public void m984() {
        setWillNotDraw(false);
        setDescendantFocusability(262144);
        setFocusable(true);
        Context context = getContext();
        this.f1745 = new Scroller(context, f1722);
        ViewConfiguration viewConfiguration = ViewConfiguration.get(context);
        float f = context.getResources().getDisplayMetrics().density;
        this.f1775 = viewConfiguration.getScaledPagingTouchSlop();
        this.f1762 = (int) (400.0f * f);
        this.f1734 = viewConfiguration.getScaledMaximumFlingVelocity();
        this.f1769 = new EdgeEffect(context);
        this.f1727 = new EdgeEffect(context);
        this.f1739 = (int) (25.0f * f);
        this.f1771 = (int) (2.0f * f);
        this.f1754 = (int) (f * 16.0f);
        C1729.m4482(this, new C0307());
        if (C1729.m4454(this) == 0) {
            int i = Build.VERSION.SDK_INT;
            setImportantForAccessibility(1);
        }
        C1729.m4484(this, new C0306());
    }

    /* JADX WARNING: Code restructure failed: missing block: B:22:0x005c, code lost:
        if (r5 == r6) goto L_0x0063;
     */
    /* renamed from: ඓ  reason: contains not printable characters */
    public void m985(int i) {
        C0305 r0;
        String str;
        C0305 r4;
        C0305 r1;
        float f;
        int i2;
        int i3;
        C0305 r8;
        C0305 r82;
        float f2;
        int i4 = this.f1751;
        if (i4 != i) {
            r0 = m983(i4);
            this.f1751 = i;
        } else {
            r0 = null;
        }
        if (this.f1766 == null) {
            m1014();
        } else if (this.f1743) {
            m1014();
        } else if (getWindowToken() != null) {
            this.f1766.m5811((ViewGroup) this);
            int i5 = this.f1765;
            int max = Math.max(0, this.f1751 - i5);
            int r2 = this.f1766.m5813();
            int min = Math.min(r2 - 1, this.f1751 + i5);
            if (r2 == this.f1750) {
                int i6 = 0;
                while (true) {
                    if (i6 >= this.f1724.size()) {
                        break;
                    }
                    r4 = this.f1724.get(i6);
                    int i7 = r4.f1789;
                    int i8 = this.f1751;
                    if (i7 < i8) {
                        i6++;
                    }
                }
                r4 = null;
                if (r4 == null && r2 > 0) {
                    r4 = m996(this.f1751, i6);
                }
                if (r4 != null) {
                    int i9 = i6 - 1;
                    C0305 r7 = i9 >= 0 ? this.f1724.get(i9) : null;
                    int clientWidth = getClientWidth();
                    if (clientWidth <= 0) {
                        f = 0.0f;
                    } else {
                        f = (2.0f - r4.f1791) + (((float) getPaddingLeft()) / ((float) clientWidth));
                    }
                    float f3 = 0.0f;
                    for (int i10 = this.f1751 - 1; i10 >= 0; i10--) {
                        if (f3 < f || i10 >= max) {
                            if (r7 == null || i10 != r7.f1789) {
                                f3 += m996(i10, i9 + 1).f1791;
                                i6++;
                                if (i9 >= 0) {
                                    r7 = this.f1724.get(i9);
                                }
                            } else {
                                f3 += r7.f1791;
                                i9--;
                                if (i9 >= 0) {
                                    r7 = this.f1724.get(i9);
                                }
                            }
                        } else if (r7 == null) {
                            break;
                        } else {
                            if (i10 == r7.f1789 && !r7.f1787) {
                                this.f1724.remove(i9);
                                this.f1766.m5823((ViewGroup) this, i10, r7.f1790);
                                i9--;
                                i6--;
                                if (i9 >= 0) {
                                    r7 = this.f1724.get(i9);
                                }
                            }
                        }
                        r7 = null;
                    }
                    float f4 = r4.f1791;
                    int i11 = i6 + 1;
                    if (f4 < 2.0f) {
                        C0305 r72 = i11 < this.f1724.size() ? this.f1724.get(i11) : null;
                        if (clientWidth <= 0) {
                            f2 = 0.0f;
                        } else {
                            f2 = (((float) getPaddingRight()) / ((float) clientWidth)) + 2.0f;
                        }
                        int i12 = i11;
                        for (int i13 = this.f1751 + 1; i13 < r2; i13++) {
                            if (f4 < f2 || i13 <= min) {
                                if (r72 == null || i13 != r72.f1789) {
                                    C0305 r73 = m996(i13, i12);
                                    i12++;
                                    f4 += r73.f1791;
                                    if (i12 < this.f1724.size()) {
                                        r72 = this.f1724.get(i12);
                                    }
                                } else {
                                    f4 += r72.f1791;
                                    i12++;
                                    if (i12 < this.f1724.size()) {
                                        r72 = this.f1724.get(i12);
                                    }
                                }
                            } else if (r72 == null) {
                                break;
                            } else {
                                if (i13 == r72.f1789 && !r72.f1787) {
                                    this.f1724.remove(i12);
                                    this.f1766.m5823((ViewGroup) this, i13, r72.f1790);
                                    if (i12 < this.f1724.size()) {
                                        r72 = this.f1724.get(i12);
                                    }
                                }
                            }
                            r72 = null;
                        }
                    }
                    int r15 = this.f1766.m5813();
                    int clientWidth2 = getClientWidth();
                    float f5 = clientWidth2 > 0 ? ((float) this.f1729) / ((float) clientWidth2) : 0.0f;
                    if (r0 != null) {
                        int i14 = r0.f1789;
                        int i15 = r4.f1789;
                        if (i14 < i15) {
                            float f6 = r0.f1788 + r0.f1791 + f5;
                            int i16 = 0;
                            while (true) {
                                i14++;
                                if (i14 > r4.f1789 || i16 >= this.f1724.size()) {
                                    break;
                                }
                                C0305 r83 = this.f1724.get(i16);
                                while (true) {
                                    r82 = r83;
                                    if (i14 > r82.f1789 && i16 < this.f1724.size() - 1) {
                                        i16++;
                                        r83 = this.f1724.get(i16);
                                    }
                                }
                                while (i14 < r82.f1789) {
                                    f6 += this.f1766.m5806(i14) + f5;
                                    i14++;
                                }
                                r82.f1788 = f6;
                                f6 += r82.f1791 + f5;
                            }
                        } else if (i14 > i15) {
                            int size = this.f1724.size() - 1;
                            float f7 = r0.f1788;
                            while (true) {
                                i14--;
                                if (i14 < r4.f1789 || size < 0) {
                                    break;
                                }
                                C0305 r84 = this.f1724.get(size);
                                while (true) {
                                    r8 = r84;
                                    if (i14 < r8.f1789 && size > 0) {
                                        size--;
                                        r84 = this.f1724.get(size);
                                    }
                                }
                                while (i14 > r8.f1789) {
                                    f7 -= this.f1766.m5806(i14) + f5;
                                    i14--;
                                }
                                f7 -= r8.f1791 + f5;
                                r8.f1788 = f7;
                            }
                        }
                    }
                    int size2 = this.f1724.size();
                    float f8 = r4.f1788;
                    int i17 = r4.f1789;
                    int i18 = i17 - 1;
                    this.f1760 = i17 == 0 ? f8 : -3.4028235E38f;
                    int i19 = r15 - 1;
                    this.f1732 = r4.f1789 == i19 ? (r4.f1788 + r4.f1791) - 1.0f : Float.MAX_VALUE;
                    int i20 = i6 - 1;
                    while (i20 >= 0) {
                        C0305 r74 = this.f1724.get(i20);
                        while (true) {
                            i3 = r74.f1789;
                            if (i18 <= i3) {
                                break;
                            }
                            f8 -= this.f1766.m5806(i18) + f5;
                            i18--;
                        }
                        f8 -= r74.f1791 + f5;
                        r74.f1788 = f8;
                        if (i3 == 0) {
                            this.f1760 = f8;
                        }
                        i20--;
                        i18--;
                    }
                    float f9 = r4.f1788 + r4.f1791 + f5;
                    int i21 = r4.f1789;
                    while (true) {
                        i21++;
                        if (i11 >= size2) {
                            break;
                        }
                        C0305 r75 = this.f1724.get(i11);
                        while (true) {
                            i2 = r75.f1789;
                            if (i21 >= i2) {
                                break;
                            }
                            f9 += this.f1766.m5806(i21) + f5;
                            i21++;
                        }
                        if (i2 == i19) {
                            this.f1732 = (r75.f1791 + f9) - 1.0f;
                        }
                        r75.f1788 = f9;
                        f9 += r75.f1791 + f5;
                        i11++;
                    }
                    this.f1766.m5812((ViewGroup) this, this.f1751, r4.f1790);
                }
                this.f1766.m5822((ViewGroup) this);
                int childCount = getChildCount();
                for (int i22 = 0; i22 < childCount; i22++) {
                    View childAt = getChildAt(i22);
                    C0301 r22 = (C0301) childAt.getLayoutParams();
                    r22.f1785 = i22;
                    if (!r22.f1784 && r22.f1781 == 0.0f && (r1 = m988(childAt)) != null) {
                        r22.f1781 = r1.f1791;
                        r22.f1782 = r1.f1789;
                    }
                }
                m1014();
                if (hasFocus()) {
                    View findFocus = findFocus();
                    C0305 r152 = findFocus != null ? m997(findFocus) : null;
                    if (r152 == null || r152.f1789 != this.f1751) {
                        for (int i23 = 0; i23 < getChildCount(); i23++) {
                            View childAt2 = getChildAt(i23);
                            C0305 r12 = m988(childAt2);
                            if (r12 != null && r12.f1789 == this.f1751 && childAt2.requestFocus(2)) {
                                return;
                            }
                        }
                        return;
                    }
                    return;
                }
                return;
            }
            try {
                str = getResources().getResourceName(getId());
            } catch (Resources.NotFoundException unused) {
                str = Integer.toHexString(getId());
            }
            StringBuilder r13 = C1293.m3416("The application's PagerAdapter changed the adapter's contents without calling PagerAdapter#notifyDataSetChanged! Expected adapter item count: ");
            r13.append(this.f1750);
            r13.append(", found: ");
            r13.append(r2);
            r13.append(" Pager id: ");
            r13.append(str);
            r13.append(" Pager class: ");
            r13.append(getClass());
            r13.append(" Problematic adapter: ");
            r13.append(this.f1766.getClass());
            throw new IllegalStateException(r13.toString());
        }
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public C0305 m988(View view) {
        for (int i = 0; i < this.f1724.size(); i++) {
            C0305 r1 = this.f1724.get(i);
            if (this.f1766.m5824(view, r1.f1790)) {
                return r1;
            }
        }
        return null;
    }

    /* renamed from: ⁱ  reason: contains not printable characters */
    public final boolean m992() {
        this.f1742 = -1;
        this.f1741 = false;
        this.f1753 = false;
        VelocityTracker velocityTracker = this.f1726;
        if (velocityTracker != null) {
            velocityTracker.recycle();
            this.f1726 = null;
        }
        this.f1769.onRelease();
        this.f1727.onRelease();
        if (this.f1769.isFinished() || this.f1727.isFinished()) {
            return true;
        }
        return false;
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m1002(int i, boolean z) {
        this.f1743 = false;
        m1004(i, z, false);
    }

    /* renamed from: 㴹  reason: contains not printable characters */
    public void m1011() {
        m985(this.f1751);
    }

    /* renamed from: 㸾  reason: contains not printable characters */
    public final boolean m1013(int i) {
        if (this.f1724.size() != 0) {
            C0305 r0 = m987();
            int clientWidth = getClientWidth();
            int i2 = this.f1729;
            int i3 = clientWidth + i2;
            float f = (float) clientWidth;
            int i4 = r0.f1789;
            float f2 = ((((float) i) / f) - r0.f1788) / (r0.f1791 + (((float) i2) / f));
            this.f1733 = false;
            m999(i4, f2, (int) (((float) i3) * f2));
            if (this.f1733) {
                return true;
            }
            throw new IllegalStateException("onPageScrolled did not call superclass implementation");
        } else if (this.f1749) {
            return false;
        } else {
            this.f1733 = false;
            m999(0, 0.0f, 0);
            if (this.f1733) {
                return false;
            }
            throw new IllegalStateException("onPageScrolled did not call superclass implementation");
        }
    }

    /* renamed from: 㿎  reason: contains not printable characters */
    public final void m1014() {
        if (this.f1740 != 0) {
            ArrayList<View> arrayList = this.f1748;
            if (arrayList == null) {
                this.f1748 = new ArrayList<>();
            } else {
                arrayList.clear();
            }
            int childCount = getChildCount();
            for (int i = 0; i < childCount; i++) {
                this.f1748.add(getChildAt(i));
            }
            Collections.sort(this.f1748, f1720);
        }
    }

    /* renamed from: androidx.viewpager.widget.ViewPager$ⁱ  reason: contains not printable characters */
    public static class C0301 extends ViewGroup.LayoutParams {

        /* renamed from: ʬ  reason: contains not printable characters */
        public float f1781 = 0.0f;

        /* renamed from: ඓ  reason: contains not printable characters */
        public int f1782;

        /* renamed from: ῲ  reason: contains not printable characters */
        public int f1783;

        /* renamed from: K  reason: contains not printable characters */
        public boolean f1784;

        /* renamed from: 㴹  reason: contains not printable characters */
        public int f1785;

        /* renamed from: 㸾  reason: contains not printable characters */
        public boolean f1786;

        public C0301() {
            super(-1, -1);
        }

        public C0301(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, ViewPager.f1721);
            this.f1783 = obtainStyledAttributes.getInteger(0, 48);
            obtainStyledAttributes.recycle();
        }
    }

    @Override // android.view.ViewGroup
    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new C0301(getContext(), attributeSet);
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m1004(int i, boolean z, boolean z2) {
        m1005(i, z, z2, 0);
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public final void m989(int i) {
        AbstractC0304 r0 = this.f1755;
        if (r0 != null) {
            r0.onPageSelected(i);
        }
        List<AbstractC0304> list = this.f1763;
        if (list != null) {
            int size = list.size();
            for (int i2 = 0; i2 < size; i2++) {
                AbstractC0304 r2 = this.f1763.get(i2);
                if (r2 != null) {
                    r2.onPageSelected(i);
                }
            }
        }
        AbstractC0304 r02 = this.f1758;
        if (r02 != null) {
            r02.onPageSelected(i);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m1005(int i, boolean z, boolean z2, int i2) {
        AbstractC2199 k = this.f1766;
        if (k == null || k.m5813() <= 0) {
            setScrollingCacheEnabled(false);
        } else if (z2 || this.f1751 != i || this.f1724.size() == 0) {
            boolean z3 = true;
            if (i < 0) {
                i = 0;
            } else if (i >= this.f1766.m5813()) {
                i = this.f1766.m5813() - 1;
            }
            int i3 = this.f1765;
            int i4 = this.f1751;
            if (i > i4 + i3 || i < i4 - i3) {
                for (int i5 = 0; i5 < this.f1724.size(); i5++) {
                    this.f1724.get(i5).f1787 = true;
                }
            }
            if (this.f1751 == i) {
                z3 = false;
            }
            if (this.f1749) {
                this.f1751 = i;
                if (z3) {
                    m989(i);
                }
                requestLayout();
                return;
            }
            m985(i);
            m1003(i, z, i2, z3);
        } else {
            setScrollingCacheEnabled(false);
        }
    }

    public void setPageMarginDrawable(int i) {
        setPageMarginDrawable(C1806.m4683(getContext(), i));
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public final void m990(boolean z) {
        ViewParent parent = getParent();
        if (parent != null) {
            parent.requestDisallowInterceptTouchEvent(z);
        }
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public final boolean m991(float f) {
        boolean z;
        boolean z2;
        float f2 = this.f1746 - f;
        this.f1746 = f;
        float scrollX = ((float) getScrollX()) + f2;
        float clientWidth = (float) getClientWidth();
        float f3 = this.f1760 * clientWidth;
        float f4 = this.f1732 * clientWidth;
        boolean z3 = false;
        C0305 r3 = this.f1724.get(0);
        ArrayList<C0305> arrayList = this.f1724;
        C0305 r5 = arrayList.get(arrayList.size() - 1);
        if (r3.f1789 != 0) {
            f3 = r3.f1788 * clientWidth;
            z = false;
        } else {
            z = true;
        }
        if (r5.f1789 != this.f1766.m5813() - 1) {
            f4 = r5.f1788 * clientWidth;
            z2 = false;
        } else {
            z2 = true;
        }
        if (scrollX < f3) {
            if (z) {
                this.f1769.onPull(Math.abs(f3 - scrollX) / clientWidth);
                z3 = true;
            }
            scrollX = f3;
        } else if (scrollX > f4) {
            if (z2) {
                this.f1727.onPull(Math.abs(scrollX - f4) / clientWidth);
                z3 = true;
            }
            scrollX = f4;
        }
        int i = (int) scrollX;
        this.f1746 = (scrollX - ((float) i)) + this.f1746;
        scrollTo(i, getScrollY());
        m1013(i);
        return z3;
    }

    public ViewPager(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        m984();
    }

    /* renamed from: 㸾  reason: contains not printable characters */
    public boolean m1012() {
        int i = this.f1751;
        if (i <= 0) {
            return false;
        }
        m1002(i - 1, true);
        return true;
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public C0305 m983(int i) {
        for (int i2 = 0; i2 < this.f1724.size(); i2++) {
            C0305 r1 = this.f1724.get(i2);
            if (r1.f1789 == i) {
                return r1;
            }
        }
        return null;
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m1003(int i, boolean z, int i2, boolean z2) {
        int i3;
        C0305 r0 = m983(i);
        if (r0 != null) {
            i3 = (int) (Math.max(this.f1760, Math.min(r0.f1788, this.f1732)) * ((float) getClientWidth()));
        } else {
            i3 = 0;
        }
        if (z) {
            m1000(i3, 0, i2);
            if (z2) {
                m989(i);
                return;
            }
            return;
        }
        if (z2) {
            m989(i);
        }
        m1007(false);
        scrollTo(i3, 0);
        m1013(i3);
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public final C0305 m987() {
        int i;
        int clientWidth = getClientWidth();
        float scrollX = clientWidth > 0 ? ((float) getScrollX()) / ((float) clientWidth) : 0.0f;
        float f = clientWidth > 0 ? ((float) this.f1729) / ((float) clientWidth) : 0.0f;
        C0305 r3 = null;
        int i2 = 0;
        boolean z = true;
        int i3 = -1;
        float f2 = 0.0f;
        float f3 = 0.0f;
        while (i2 < this.f1724.size()) {
            C0305 r10 = this.f1724.get(i2);
            if (!z && r10.f1789 != (i = i3 + 1)) {
                r10 = this.f1770;
                r10.f1788 = f2 + f3 + f;
                r10.f1789 = i;
                r10.f1791 = this.f1766.m5806(r10.f1789);
                i2--;
            }
            f2 = r10.f1788;
            float f4 = r10.f1791 + f2 + f;
            if (!z && scrollX < f2) {
                return r3;
            }
            if (scrollX < f4 || i2 == this.f1724.size() - 1) {
                return r10;
            }
            i3 = r10.f1789;
            f3 = r10.f1791;
            i2++;
            r3 = r10;
            z = false;
        }
        return r3;
    }

    /* renamed from: K  reason: contains not printable characters */
    public AbstractC0304 m995(AbstractC0304 r2) {
        AbstractC0304 r0 = this.f1758;
        this.f1758 = r2;
        return r0;
    }

    /* renamed from: K  reason: contains not printable characters */
    public float m993(float f) {
        return (float) Math.sin((double) ((f - 0.5f) * 0.47123894f));
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m1000(int i, int i2, int i3) {
        int i4;
        int i5;
        if (getChildCount() == 0) {
            setScrollingCacheEnabled(false);
            return;
        }
        Scroller scroller = this.f1745;
        if (scroller != null && !scroller.isFinished()) {
            i4 = this.f1756 ? this.f1745.getCurrX() : this.f1745.getStartX();
            this.f1745.abortAnimation();
            setScrollingCacheEnabled(false);
        } else {
            i4 = getScrollX();
        }
        int scrollY = getScrollY();
        int i6 = i - i4;
        int i7 = i2 - scrollY;
        if (i6 == 0 && i7 == 0) {
            m1007(false);
            m1011();
            setScrollState(0);
            return;
        }
        setScrollingCacheEnabled(true);
        setScrollState(2);
        int clientWidth = getClientWidth();
        int i8 = clientWidth / 2;
        float f = (float) clientWidth;
        float f2 = (float) i8;
        float r0 = (m993(Math.min(1.0f, (((float) Math.abs(i6)) * 1.0f) / f)) * f2) + f2;
        int abs = Math.abs(i3);
        if (abs > 0) {
            i5 = Math.round(Math.abs(r0 / ((float) abs)) * 1000.0f) * 4;
        } else {
            i5 = (int) (((((float) Math.abs(i6)) / ((this.f1766.m5806(this.f1751) * f) + ((float) this.f1729))) + 1.0f) * 100.0f);
        }
        int min = Math.min(i5, 600);
        this.f1756 = false;
        this.f1745.startScroll(i4, scrollY, i6, i7, min);
        C1729.m4449(this);
    }

    /* renamed from: K  reason: contains not printable characters */
    public C0305 m996(int i, int i2) {
        C0305 r0 = new C0305();
        r0.f1789 = i;
        r0.f1790 = this.f1766.m5817((ViewGroup) this, i);
        r0.f1791 = this.f1766.m5806(i);
        if (i2 < 0 || i2 >= this.f1724.size()) {
            this.f1724.add(r0);
        } else {
            this.f1724.add(i2, r0);
        }
        return r0;
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m998() {
        int r0 = this.f1766.m5813();
        this.f1750 = r0;
        boolean z = this.f1724.size() < (this.f1765 * 2) + 1 && this.f1724.size() < r0;
        int i = this.f1751;
        int i2 = 0;
        boolean z2 = false;
        while (i2 < this.f1724.size()) {
            C0305 r7 = this.f1724.get(i2);
            int r8 = this.f1766.m5814(r7.f1790);
            if (r8 != -1) {
                if (r8 == -2) {
                    this.f1724.remove(i2);
                    i2--;
                    if (!z2) {
                        this.f1766.m5811((ViewGroup) this);
                        z2 = true;
                    }
                    this.f1766.m5823((ViewGroup) this, r7.f1789, r7.f1790);
                    int i3 = this.f1751;
                    if (i3 == r7.f1789) {
                        i = Math.max(0, Math.min(i3, r0 - 1));
                    }
                } else {
                    int i4 = r7.f1789;
                    if (i4 != r8) {
                        if (i4 == this.f1751) {
                            i = r8;
                        }
                        r7.f1789 = r8;
                    }
                }
                z = true;
            }
            i2++;
        }
        if (z2) {
            this.f1766.m5822((ViewGroup) this);
        }
        Collections.sort(this.f1724, f1723);
        if (z) {
            int childCount = getChildCount();
            for (int i5 = 0; i5 < childCount; i5++) {
                C0301 r2 = (C0301) getChildAt(i5).getLayoutParams();
                if (!r2.f1784) {
                    r2.f1781 = 0.0f;
                }
            }
            m1004(i, false, true);
            requestLayout();
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public C0305 m997(View view) {
        while (true) {
            ViewParent parent = view.getParent();
            if (parent == this) {
                return m988(view);
            }
            if (parent == null || !(parent instanceof View)) {
                return null;
            }
            view = (View) parent;
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m1001(int i, int i2, int i3, int i4) {
        if (i2 <= 0 || this.f1724.isEmpty()) {
            C0305 r3 = m983(this.f1751);
            int min = (int) ((r3 != null ? Math.min(r3.f1788, this.f1732) : 0.0f) * ((float) ((i - getPaddingLeft()) - getPaddingRight())));
            if (min != getScrollX()) {
                m1007(false);
                scrollTo(min, getScrollY());
            }
        } else if (!this.f1745.isFinished()) {
            this.f1745.setFinalX(getCurrentItem() * getClientWidth());
        } else {
            scrollTo((int) ((((float) getScrollX()) / ((float) (((i2 - getPaddingLeft()) - getPaddingRight()) + i4))) * ((float) (((i - getPaddingLeft()) - getPaddingRight()) + i3))), getScrollY());
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:19:0x0066  */
    /* renamed from: K  reason: contains not printable characters */
    public void m999(int i, float f, int i2) {
        int i3;
        int left;
        int i4;
        if (this.f1736 > 0) {
            int scrollX = getScrollX();
            int paddingLeft = getPaddingLeft();
            int paddingRight = getPaddingRight();
            int width = getWidth();
            int childCount = getChildCount();
            int i5 = paddingRight;
            int i6 = paddingLeft;
            for (int i7 = 0; i7 < childCount; i7++) {
                View childAt = getChildAt(i7);
                C0301 r9 = (C0301) childAt.getLayoutParams();
                if (r9.f1784) {
                    int i8 = r9.f1783 & 7;
                    if (i8 != 1) {
                        if (i8 == 3) {
                            i3 = childAt.getWidth() + i6;
                        } else if (i8 != 5) {
                            i3 = i6;
                        } else {
                            i4 = (width - i5) - childAt.getMeasuredWidth();
                            i5 += childAt.getMeasuredWidth();
                        }
                        left = (i6 + scrollX) - childAt.getLeft();
                        if (left != 0) {
                            childAt.offsetLeftAndRight(left);
                        }
                        i6 = i3;
                    } else {
                        i4 = Math.max((width - childAt.getMeasuredWidth()) / 2, i6);
                    }
                    i3 = i6;
                    i6 = i4;
                    left = (i6 + scrollX) - childAt.getLeft();
                    if (left != 0) {
                    }
                    i6 = i3;
                }
            }
        }
        AbstractC0304 r0 = this.f1755;
        if (r0 != null) {
            r0.onPageScrolled(i, f, i2);
        }
        List<AbstractC0304> list = this.f1763;
        if (list != null) {
            int size = list.size();
            for (int i9 = 0; i9 < size; i9++) {
                AbstractC0304 r3 = this.f1763.get(i9);
                if (r3 != null) {
                    r3.onPageScrolled(i, f, i2);
                }
            }
        }
        AbstractC0304 r02 = this.f1758;
        if (r02 != null) {
            r02.onPageScrolled(i, f, i2);
        }
        this.f1733 = true;
    }

    /* renamed from: ඓ  reason: contains not printable characters */
    public boolean m986() {
        AbstractC2199 k = this.f1766;
        if (k == null || this.f1751 >= k.m5813() - 1) {
            return false;
        }
        m1002(this.f1751 + 1, true);
        return true;
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m1007(boolean z) {
        boolean z2 = this.f1767 == 2;
        if (z2) {
            setScrollingCacheEnabled(false);
            if (!this.f1745.isFinished()) {
                this.f1745.abortAnimation();
                int scrollX = getScrollX();
                int scrollY = getScrollY();
                int currX = this.f1745.getCurrX();
                int currY = this.f1745.getCurrY();
                if (!(scrollX == currX && scrollY == currY)) {
                    scrollTo(currX, currY);
                    if (currX != scrollX) {
                        m1013(currX);
                    }
                }
            }
        }
        this.f1743 = false;
        boolean z3 = z2;
        for (int i = 0; i < this.f1724.size(); i++) {
            C0305 r4 = this.f1724.get(i);
            if (r4.f1787) {
                r4.f1787 = false;
                z3 = true;
            }
        }
        if (!z3) {
            return;
        }
        if (z) {
            C1729.m4479(this, this.f1728);
        } else {
            this.f1728.run();
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m1006(MotionEvent motionEvent) {
        int actionIndex = motionEvent.getActionIndex();
        if (motionEvent.getPointerId(actionIndex) == this.f1742) {
            int i = actionIndex == 0 ? 1 : 0;
            this.f1746 = motionEvent.getX(i);
            this.f1742 = motionEvent.getPointerId(i);
            VelocityTracker velocityTracker = this.f1726;
            if (velocityTracker != null) {
                velocityTracker.clear();
            }
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public boolean m1010(View view, boolean z, int i, int i2, int i3) {
        int i4;
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup) view;
            int scrollX = view.getScrollX();
            int scrollY = view.getScrollY();
            for (int childCount = viewGroup.getChildCount() - 1; childCount >= 0; childCount--) {
                View childAt = viewGroup.getChildAt(childCount);
                int i5 = i2 + scrollX;
                if (i5 >= childAt.getLeft() && i5 < childAt.getRight() && (i4 = i3 + scrollY) >= childAt.getTop() && i4 < childAt.getBottom() && m1010(childAt, true, i, i5 - childAt.getLeft(), i4 - childAt.getTop())) {
                    return true;
                }
            }
        }
        if (!z || !view.canScrollHorizontally(-i)) {
            return false;
        }
        return true;
    }

    /* renamed from: K  reason: contains not printable characters */
    public boolean m1009(KeyEvent keyEvent) {
        if (keyEvent.getAction() == 0) {
            int keyCode = keyEvent.getKeyCode();
            if (keyCode != 21) {
                if (keyCode != 22) {
                    if (keyCode == 61) {
                        if (keyEvent.hasNoModifiers()) {
                            return m1008(2);
                        }
                        if (keyEvent.hasModifiers(1)) {
                            return m1008(1);
                        }
                    }
                } else if (keyEvent.hasModifiers(2)) {
                    return m986();
                } else {
                    return m1008(66);
                }
            } else if (keyEvent.hasModifiers(2)) {
                return m1012();
            } else {
                return m1008(17);
            }
        }
        return false;
    }

    /* JADX WARNING: Removed duplicated region for block: B:41:0x00ca  */
    /* renamed from: K  reason: contains not printable characters */
    public boolean m1008(int i) {
        View findNextFocus;
        boolean requestFocus;
        boolean z;
        View findFocus = findFocus();
        boolean z2 = false;
        if (findFocus != this) {
            if (findFocus != null) {
                ViewParent parent = findFocus.getParent();
                while (true) {
                    if (!(parent instanceof ViewGroup)) {
                        z = false;
                        break;
                    } else if (parent == this) {
                        z = true;
                        break;
                    } else {
                        parent = parent.getParent();
                    }
                }
                if (!z) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(findFocus.getClass().getSimpleName());
                    for (ViewParent parent2 = findFocus.getParent(); parent2 instanceof ViewGroup; parent2 = parent2.getParent()) {
                        sb.append(" => ");
                        sb.append(parent2.getClass().getSimpleName());
                    }
                    StringBuilder r0 = C1293.m3416("arrowScroll tried to find focus based on non-child current focused view ");
                    r0.append(sb.toString());
                    Log.e("ViewPager", r0.toString());
                }
            }
            findNextFocus = FocusFinder.getInstance().findNextFocus(this, findFocus, i);
            if (findNextFocus == null && findNextFocus != findFocus) {
                if (i == 17) {
                    int i2 = m994(this.f1735, findNextFocus).left;
                    int i3 = m994(this.f1735, findFocus).left;
                    if (findFocus == null || i2 < i3) {
                        requestFocus = findNextFocus.requestFocus();
                    } else {
                        requestFocus = m1012();
                    }
                } else if (i == 66) {
                    int i4 = m994(this.f1735, findNextFocus).left;
                    int i5 = m994(this.f1735, findFocus).left;
                    if (findFocus == null || i4 > i5) {
                        requestFocus = findNextFocus.requestFocus();
                    } else {
                        requestFocus = m986();
                    }
                }
                z2 = requestFocus;
            } else if (i != 17 || i == 1) {
                z2 = m1012();
            } else if (i == 66 || i == 2) {
                z2 = m986();
            }
            if (z2) {
                playSoundEffect(SoundEffectConstants.getContantForFocusDirection(i));
            }
            return z2;
        }
        findFocus = null;
        findNextFocus = FocusFinder.getInstance().findNextFocus(this, findFocus, i);
        if (findNextFocus == null) {
        }
        if (i != 17) {
        }
        z2 = m1012();
        if (z2) {
        }
        return z2;
    }

    /* renamed from: K  reason: contains not printable characters */
    public final Rect m994(Rect rect, View view) {
        if (rect == null) {
            rect = new Rect();
        }
        if (view == null) {
            rect.set(0, 0, 0, 0);
            return rect;
        }
        rect.left = view.getLeft();
        rect.right = view.getRight();
        rect.top = view.getTop();
        rect.bottom = view.getBottom();
        ViewParent parent = view.getParent();
        while ((parent instanceof ViewGroup) && parent != this) {
            ViewGroup viewGroup = (ViewGroup) parent;
            rect.left = viewGroup.getLeft() + rect.left;
            rect.right = viewGroup.getRight() + rect.right;
            rect.top = viewGroup.getTop() + rect.top;
            rect.bottom = viewGroup.getBottom() + rect.bottom;
            parent = viewGroup.getParent();
        }
        return rect;
    }
}
