package androidx.viewpager.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.text.method.SingleLineTransformationMethod;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.TextView;
import androidx.viewpager.widget.ViewPager;
import com.google.android.material.progressindicator.BaseProgressIndicator;
import java.lang.ref.WeakReference;
import java.util.Locale;
import ῲ.ᨨ.㳳.C1841;
import ῲ.ゎ.K.AbstractC2199;

@ViewPager.AbstractC0297
public class PagerTitleStrip extends ViewGroup {

    /* renamed from: ؿ  reason: contains not printable characters */
    public static final int[] f1701 = {16842804, 16842901, 16842904, 16842927};

    /* renamed from: ᓣ  reason: contains not printable characters */
    public static final int[] f1702 = {16843660};

    /* renamed from: ʬ  reason: contains not printable characters */
    public TextView f1703;

    /* renamed from: Ԕ  reason: contains not printable characters */
    public int f1704;

    /* renamed from: ඓ  reason: contains not printable characters */
    public TextView f1705;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public boolean f1706;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public int f1707;

    /* renamed from: ῲ  reason: contains not printable characters */
    public ViewPager f1708;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public float f1709;

    /* renamed from: 㑃  reason: contains not printable characters */
    public final C0294 f1710;

    /* renamed from: 㗗  reason: contains not printable characters */
    public int f1711;

    /* renamed from: 㳳  reason: contains not printable characters */
    public boolean f1712;

    /* renamed from: 㴹  reason: contains not printable characters */
    public int f1713;

    /* renamed from: 㸾  reason: contains not printable characters */
    public TextView f1714;

    /* renamed from: 㿎  reason: contains not printable characters */
    public int f1715;

    /* renamed from: 䁗  reason: contains not printable characters */
    public WeakReference<AbstractC2199> f1716;

    /* renamed from: androidx.viewpager.widget.PagerTitleStrip$ῲ  reason: contains not printable characters */
    public static class C0293 extends SingleLineTransformationMethod {

        /* renamed from: ῲ  reason: contains not printable characters */
        public Locale f1717;

        public C0293(Context context) {
            this.f1717 = context.getResources().getConfiguration().locale;
        }

        public CharSequence getTransformation(CharSequence charSequence, View view) {
            CharSequence transformation = super.getTransformation(charSequence, view);
            if (transformation != null) {
                return transformation.toString().toUpperCase(this.f1717);
            }
            return null;
        }
    }

    /* renamed from: androidx.viewpager.widget.PagerTitleStrip$K  reason: contains not printable characters */
    public class C0294 extends DataSetObserver implements ViewPager.AbstractC0304, ViewPager.AbstractC0299 {

        /* renamed from: ῲ  reason: contains not printable characters */
        public int f1719;

        public C0294() {
        }

        @Override // androidx.viewpager.widget.ViewPager.AbstractC0299
        public void onAdapterChanged(ViewPager viewPager, AbstractC2199 k, AbstractC2199 k2) {
            PagerTitleStrip.this.m982(k, k2);
        }

        public void onChanged() {
            PagerTitleStrip pagerTitleStrip = PagerTitleStrip.this;
            pagerTitleStrip.m981(pagerTitleStrip.f1708.getCurrentItem(), PagerTitleStrip.this.f1708.getAdapter());
            float f = PagerTitleStrip.this.f1709;
            if (f < 0.0f) {
                f = 0.0f;
            }
            PagerTitleStrip pagerTitleStrip2 = PagerTitleStrip.this;
            pagerTitleStrip2.m980(pagerTitleStrip2.f1708.getCurrentItem(), f, true);
        }

        @Override // androidx.viewpager.widget.ViewPager.AbstractC0304
        public void onPageScrollStateChanged(int i) {
            this.f1719 = i;
        }

        @Override // androidx.viewpager.widget.ViewPager.AbstractC0304
        public void onPageScrolled(int i, float f, int i2) {
            if (f > 0.5f) {
                i++;
            }
            PagerTitleStrip.this.m980(i, f, false);
        }

        @Override // androidx.viewpager.widget.ViewPager.AbstractC0304
        public void onPageSelected(int i) {
            if (this.f1719 == 0) {
                PagerTitleStrip pagerTitleStrip = PagerTitleStrip.this;
                pagerTitleStrip.m981(pagerTitleStrip.f1708.getCurrentItem(), PagerTitleStrip.this.f1708.getAdapter());
                float f = PagerTitleStrip.this.f1709;
                if (f < 0.0f) {
                    f = 0.0f;
                }
                PagerTitleStrip pagerTitleStrip2 = PagerTitleStrip.this;
                pagerTitleStrip2.m980(pagerTitleStrip2.f1708.getCurrentItem(), f, true);
            }
        }
    }

    public PagerTitleStrip(Context context) {
        this(context, null);
    }

    public static void setSingleLineAllCaps(TextView textView) {
        textView.setTransformationMethod(new C0293(textView.getContext()));
    }

    public int getMinHeight() {
        Drawable background = getBackground();
        if (background != null) {
            return background.getIntrinsicHeight();
        }
        return 0;
    }

    public int getTextSpacing() {
        return this.f1715;
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        ViewParent parent = getParent();
        if (parent instanceof ViewPager) {
            ViewPager viewPager = (ViewPager) parent;
            AbstractC2199 adapter = viewPager.getAdapter();
            viewPager.m995(this.f1710);
            viewPager.addOnAdapterChangeListener(this.f1710);
            this.f1708 = viewPager;
            WeakReference<AbstractC2199> weakReference = this.f1716;
            m982(weakReference != null ? weakReference.get() : null, adapter);
            return;
        }
        throw new IllegalStateException("PagerTitleStrip must be a direct child of a ViewPager.");
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        ViewPager viewPager = this.f1708;
        if (viewPager != null) {
            m982(viewPager.getAdapter(), (AbstractC2199) null);
            this.f1708.m995((ViewPager.AbstractC0304) null);
            this.f1708.removeOnAdapterChangeListener(this.f1710);
            this.f1708 = null;
        }
    }

    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        if (this.f1708 != null) {
            float f = this.f1709;
            if (f < 0.0f) {
                f = 0.0f;
            }
            m980(this.f1713, f, true);
        }
    }

    public void onMeasure(int i, int i2) {
        int i3;
        if (View.MeasureSpec.getMode(i) == 1073741824) {
            int paddingBottom = getPaddingBottom() + getPaddingTop();
            int childMeasureSpec = ViewGroup.getChildMeasureSpec(i2, paddingBottom, -2);
            int size = View.MeasureSpec.getSize(i);
            int childMeasureSpec2 = ViewGroup.getChildMeasureSpec(i, (int) (((float) size) * 0.2f), -2);
            this.f1703.measure(childMeasureSpec2, childMeasureSpec);
            this.f1714.measure(childMeasureSpec2, childMeasureSpec);
            this.f1705.measure(childMeasureSpec2, childMeasureSpec);
            if (View.MeasureSpec.getMode(i2) == 1073741824) {
                i3 = View.MeasureSpec.getSize(i2);
            } else {
                i3 = Math.max(getMinHeight(), this.f1714.getMeasuredHeight() + paddingBottom);
            }
            setMeasuredDimension(size, View.resolveSizeAndState(i3, i2, this.f1714.getMeasuredState() << 16));
            return;
        }
        throw new IllegalStateException("Must measure with an exact width");
    }

    public void requestLayout() {
        if (!this.f1712) {
            super.requestLayout();
        }
    }

    public void setGravity(int i) {
        this.f1707 = i;
        requestLayout();
    }

    public void setNonPrimaryAlpha(float f) {
        this.f1704 = ((int) (f * 255.0f)) & BaseProgressIndicator.MAX_ALPHA;
        int i = (this.f1704 << 24) | (this.f1711 & 16777215);
        this.f1703.setTextColor(i);
        this.f1705.setTextColor(i);
    }

    public void setTextColor(int i) {
        this.f1711 = i;
        this.f1714.setTextColor(i);
        int i2 = (this.f1704 << 24) | (this.f1711 & 16777215);
        this.f1703.setTextColor(i2);
        this.f1705.setTextColor(i2);
    }

    public void setTextSpacing(int i) {
        this.f1715 = i;
        requestLayout();
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m979(int i, float f) {
        this.f1703.setTextSize(i, f);
        this.f1714.setTextSize(i, f);
        this.f1705.setTextSize(i, f);
    }

    public PagerTitleStrip(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.f1713 = -1;
        this.f1709 = -1.0f;
        this.f1710 = new C0294();
        TextView textView = new TextView(context);
        this.f1703 = textView;
        addView(textView);
        TextView textView2 = new TextView(context);
        this.f1714 = textView2;
        addView(textView2);
        TextView textView3 = new TextView(context);
        this.f1705 = textView3;
        addView(textView3);
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, f1701);
        boolean z = false;
        int resourceId = obtainStyledAttributes.getResourceId(0, 0);
        if (resourceId != 0) {
            C1841.m4810(this.f1703, resourceId);
            C1841.m4810(this.f1714, resourceId);
            C1841.m4810(this.f1705, resourceId);
        }
        int dimensionPixelSize = obtainStyledAttributes.getDimensionPixelSize(1, 0);
        if (dimensionPixelSize != 0) {
            m979(0, (float) dimensionPixelSize);
        }
        if (obtainStyledAttributes.hasValue(2)) {
            int color = obtainStyledAttributes.getColor(2, 0);
            this.f1703.setTextColor(color);
            this.f1714.setTextColor(color);
            this.f1705.setTextColor(color);
        }
        this.f1707 = obtainStyledAttributes.getInteger(3, 80);
        obtainStyledAttributes.recycle();
        this.f1711 = this.f1714.getTextColors().getDefaultColor();
        setNonPrimaryAlpha(0.6f);
        this.f1703.setEllipsize(TextUtils.TruncateAt.END);
        this.f1714.setEllipsize(TextUtils.TruncateAt.END);
        this.f1705.setEllipsize(TextUtils.TruncateAt.END);
        if (resourceId != 0) {
            TypedArray obtainStyledAttributes2 = context.obtainStyledAttributes(resourceId, f1702);
            z = obtainStyledAttributes2.getBoolean(0, false);
            obtainStyledAttributes2.recycle();
        }
        if (z) {
            setSingleLineAllCaps(this.f1703);
            setSingleLineAllCaps(this.f1714);
            setSingleLineAllCaps(this.f1705);
        } else {
            this.f1703.setSingleLine();
            this.f1714.setSingleLine();
            this.f1705.setSingleLine();
        }
        this.f1715 = (int) (context.getResources().getDisplayMetrics().density * 16.0f);
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m981(int i, AbstractC2199 k) {
        int r1 = k != null ? k.m5813() : 0;
        this.f1712 = true;
        CharSequence charSequence = null;
        this.f1703.setText((i < 1 || k == null) ? null : k.m5815(i - 1));
        this.f1714.setText((k == null || i >= r1) ? null : k.m5815(i));
        int i2 = i + 1;
        if (i2 < r1 && k != null) {
            charSequence = k.m5815(i2);
        }
        this.f1705.setText(charSequence);
        int makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(Math.max(0, (int) (((float) ((getWidth() - getPaddingLeft()) - getPaddingRight())) * 0.8f)), Integer.MIN_VALUE);
        int makeMeasureSpec2 = View.MeasureSpec.makeMeasureSpec(Math.max(0, (getHeight() - getPaddingTop()) - getPaddingBottom()), Integer.MIN_VALUE);
        this.f1703.measure(makeMeasureSpec, makeMeasureSpec2);
        this.f1714.measure(makeMeasureSpec, makeMeasureSpec2);
        this.f1705.measure(makeMeasureSpec, makeMeasureSpec2);
        this.f1713 = i;
        if (!this.f1706) {
            m980(i, this.f1709, false);
        }
        this.f1712 = false;
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m982(AbstractC2199 k, AbstractC2199 k2) {
        if (k != null) {
            k.m5805(this.f1710);
            this.f1716 = null;
        }
        if (k2 != null) {
            k2.m5818((DataSetObserver) this.f1710);
            this.f1716 = new WeakReference<>(k2);
        }
        ViewPager viewPager = this.f1708;
        if (viewPager != null) {
            this.f1713 = -1;
            this.f1709 = -1.0f;
            m981(viewPager.getCurrentItem(), k2);
            requestLayout();
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m980(int i, float f, boolean z) {
        int i2;
        int i3;
        int i4;
        int i5;
        if (i != this.f1713) {
            m981(i, this.f1708.getAdapter());
        } else if (!z && f == this.f1709) {
            return;
        }
        this.f1706 = true;
        int measuredWidth = this.f1703.getMeasuredWidth();
        int measuredWidth2 = this.f1714.getMeasuredWidth();
        int measuredWidth3 = this.f1705.getMeasuredWidth();
        int i6 = measuredWidth2 / 2;
        int width = getWidth();
        int height = getHeight();
        int paddingLeft = getPaddingLeft();
        int paddingRight = getPaddingRight();
        int paddingTop = getPaddingTop();
        int paddingBottom = getPaddingBottom();
        int i7 = paddingRight + i6;
        int i8 = (width - (paddingLeft + i6)) - i7;
        float f2 = 0.5f + f;
        if (f2 > 1.0f) {
            f2 -= 1.0f;
        }
        int i9 = ((width - i7) - ((int) (((float) i8) * f2))) - i6;
        int i10 = measuredWidth2 + i9;
        int baseline = this.f1703.getBaseline();
        int baseline2 = this.f1714.getBaseline();
        int baseline3 = this.f1705.getBaseline();
        int max = Math.max(Math.max(baseline, baseline2), baseline3);
        int i11 = max - baseline;
        int i12 = max - baseline2;
        int i13 = max - baseline3;
        int max2 = Math.max(Math.max(this.f1703.getMeasuredHeight() + i11, this.f1714.getMeasuredHeight() + i12), this.f1705.getMeasuredHeight() + i13);
        int i14 = this.f1707 & 112;
        if (i14 == 16) {
            i5 = (((height - paddingTop) - paddingBottom) - max2) / 2;
        } else if (i14 != 80) {
            i4 = i11 + paddingTop;
            i2 = i12 + paddingTop;
            i3 = paddingTop + i13;
            TextView textView = this.f1714;
            textView.layout(i9, i2, i10, textView.getMeasuredHeight() + i2);
            int min = Math.min(paddingLeft, (i9 - this.f1715) - measuredWidth);
            TextView textView2 = this.f1703;
            textView2.layout(min, i4, measuredWidth + min, textView2.getMeasuredHeight() + i4);
            int max3 = Math.max((width - paddingRight) - measuredWidth3, i10 + this.f1715);
            TextView textView3 = this.f1705;
            textView3.layout(max3, i3, max3 + measuredWidth3, textView3.getMeasuredHeight() + i3);
            this.f1709 = f;
            this.f1706 = false;
        } else {
            i5 = (height - paddingBottom) - max2;
        }
        i4 = i11 + i5;
        i2 = i12 + i5;
        i3 = i5 + i13;
        TextView textView4 = this.f1714;
        textView4.layout(i9, i2, i10, textView4.getMeasuredHeight() + i2);
        int min2 = Math.min(paddingLeft, (i9 - this.f1715) - measuredWidth);
        TextView textView22 = this.f1703;
        textView22.layout(min2, i4, measuredWidth + min2, textView22.getMeasuredHeight() + i4);
        int max32 = Math.max((width - paddingRight) - measuredWidth3, i10 + this.f1715);
        TextView textView32 = this.f1705;
        textView32.layout(max32, i3, max32 + measuredWidth3, textView32.getMeasuredHeight() + i3);
        this.f1709 = f;
        this.f1706 = false;
    }
}
