package androidx.swiperefreshlayout.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Transformation;
import android.widget.ListView;
import com.google.android.material.progressindicator.BaseProgressIndicator;
import ῲ.ᨨ.ᨨ.AbstractC1741;
import ῲ.ᨨ.ᨨ.AbstractC1746;
import ῲ.ᨨ.ᨨ.C1729;
import ῲ.ᨨ.ᨨ.C1751;
import ῲ.ᨨ.ᨨ.C1775;
import ῲ.ᨨ.ῲ.C1806;
import ῲ.㶋.K.C2290;
import ῲ.㶋.K.C2292;
import ῲ.㶋.K.C2293;
import ῲ.㶋.K.C2294;

public class SwipeRefreshLayout extends ViewGroup implements AbstractC1741, AbstractC1746 {

    /* renamed from: ѷ  reason: contains not printable characters */
    public static final int[] f1633 = {16842766};

    /* renamed from: 㷛  reason: contains not printable characters */
    public static final String f1634 = SwipeRefreshLayout.class.getSimpleName();

    /* renamed from: ʬ  reason: contains not printable characters */
    public AbstractC0289 f1635;

    /* renamed from: В  reason: contains not printable characters */
    public boolean f1636;

    /* renamed from: Ԕ  reason: contains not printable characters */
    public int f1637;

    /* renamed from: Ԛ  reason: contains not printable characters */
    public final DecelerateInterpolator f1638;

    /* renamed from: ؿ  reason: contains not printable characters */
    public float f1639;

    /* renamed from: ݜ  reason: contains not printable characters */
    public boolean f1640;

    /* renamed from: ಯ  reason: contains not printable characters */
    public boolean f1641;

    /* renamed from: ඓ  reason: contains not printable characters */
    public int f1642;

    /* renamed from: ᆯ  reason: contains not printable characters */
    public Animation f1643;

    /* renamed from: ሽ  reason: contains not printable characters */
    public Animation f1644;

    /* renamed from: ጒ  reason: contains not printable characters */
    public Animation.AnimationListener f1645;

    /* renamed from: ᑓ  reason: contains not printable characters */
    public float f1646;

    /* renamed from: ᑾ  reason: contains not printable characters */
    public Animation f1647;

    /* renamed from: ᓆ  reason: contains not printable characters */
    public int f1648;

    /* renamed from: ᓣ  reason: contains not printable characters */
    public boolean f1649;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public final int[] f1650;

    /* renamed from: ᝁ  reason: contains not printable characters */
    public Animation f1651;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public final C1775 f1652;

    /* renamed from: ῲ  reason: contains not printable characters */
    public View f1653;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public float f1654;

    /* renamed from: ⶍ  reason: contains not printable characters */
    public Animation f1655;

    /* renamed from: ゎ  reason: contains not printable characters */
    public int f1656;

    /* renamed from: ト  reason: contains not printable characters */
    public int f1657;

    /* renamed from: 㑃  reason: contains not printable characters */
    public boolean f1658;

    /* renamed from: 㒁  reason: contains not printable characters */
    public final Animation f1659;

    /* renamed from: 㗗  reason: contains not printable characters */
    public float f1660;

    /* renamed from: 㗽  reason: contains not printable characters */
    public int f1661;

    /* renamed from: 㮔  reason: contains not printable characters */
    public int f1662;

    /* renamed from: 㮝  reason: contains not printable characters */
    public int f1663;

    /* renamed from: 㳳  reason: contains not printable characters */
    public final int[] f1664;

    /* renamed from: 㴪  reason: contains not printable characters */
    public int f1665;

    /* renamed from: 㴹  reason: contains not printable characters */
    public float f1666;

    /* renamed from: 㶋  reason: contains not printable characters */
    public C2292 f1667;

    /* renamed from: 㸾  reason: contains not printable characters */
    public boolean f1668;

    /* renamed from: 㹎  reason: contains not printable characters */
    public final Animation f1669;

    /* renamed from: 㿎  reason: contains not printable characters */
    public final C1751 f1670;

    /* renamed from: 䀟  reason: contains not printable characters */
    public boolean f1671;

    /* renamed from: 䁗  reason: contains not printable characters */
    public int f1672;

    /* renamed from: 䃖  reason: contains not printable characters */
    public C2294 f1673;

    /* renamed from: androidx.swiperefreshlayout.widget.SwipeRefreshLayout$ʬ  reason: contains not printable characters */
    public class C0282 extends Animation {

        /* renamed from: ʬ  reason: contains not printable characters */
        public final /* synthetic */ int f1674;

        /* renamed from: ῲ  reason: contains not printable characters */
        public final /* synthetic */ int f1675;

        public C0282(int i, int i2) {
            this.f1675 = i;
            this.f1674 = i2;
        }

        public void applyTransformation(float f, Transformation transformation) {
            C2294 r5 = SwipeRefreshLayout.this.f1673;
            int i = this.f1675;
            r5.setAlpha((int) ((((float) (this.f1674 - i)) * f) + ((float) i)));
        }
    }

    /* renamed from: androidx.swiperefreshlayout.widget.SwipeRefreshLayout$ඓ  reason: contains not printable characters */
    public class C0283 extends Animation {
        public C0283() {
        }

        public void applyTransformation(float f, Transformation transformation) {
            int i;
            SwipeRefreshLayout swipeRefreshLayout = SwipeRefreshLayout.this;
            if (!swipeRefreshLayout.f1641) {
                i = swipeRefreshLayout.f1657 - Math.abs(swipeRefreshLayout.f1656);
            } else {
                i = swipeRefreshLayout.f1657;
            }
            SwipeRefreshLayout swipeRefreshLayout2 = SwipeRefreshLayout.this;
            int i2 = swipeRefreshLayout2.f1665;
            SwipeRefreshLayout.this.setTargetOffsetTopAndBottom((i2 + ((int) (((float) (i - i2)) * f))) - swipeRefreshLayout2.f1667.getTop());
            C2294 r4 = SwipeRefreshLayout.this.f1673;
            float f2 = 1.0f - f;
            C2294.C2295 k = r4.f7923;
            if (f2 != k.f7930) {
                k.f7930 = f2;
            }
            r4.invalidateSelf();
        }
    }

    /* renamed from: androidx.swiperefreshlayout.widget.SwipeRefreshLayout$ῲ  reason: contains not printable characters */
    public class C0284 extends Animation {
        public C0284() {
        }

        public void applyTransformation(float f, Transformation transformation) {
            SwipeRefreshLayout.this.setAnimationProgress(1.0f - f);
        }
    }

    /* renamed from: androidx.swiperefreshlayout.widget.SwipeRefreshLayout$ⁱ  reason: contains not printable characters */
    public interface AbstractC0285 {
    }

    /* renamed from: androidx.swiperefreshlayout.widget.SwipeRefreshLayout$K  reason: contains not printable characters */
    public class animation.Animation$AnimationListenerC0286 implements Animation.AnimationListener {
        public animation.Animation$AnimationListenerC0286() {
        }

        public void onAnimationEnd(Animation animation) {
            AbstractC0289 r2;
            SwipeRefreshLayout swipeRefreshLayout = SwipeRefreshLayout.this;
            if (swipeRefreshLayout.f1668) {
                swipeRefreshLayout.f1673.setAlpha(BaseProgressIndicator.MAX_ALPHA);
                SwipeRefreshLayout.this.f1673.start();
                SwipeRefreshLayout swipeRefreshLayout2 = SwipeRefreshLayout.this;
                if (swipeRefreshLayout2.f1636 && (r2 = swipeRefreshLayout2.f1635) != null) {
                    r2.m977();
                }
                SwipeRefreshLayout swipeRefreshLayout3 = SwipeRefreshLayout.this;
                swipeRefreshLayout3.f1637 = swipeRefreshLayout3.f1667.getTop();
                return;
            }
            swipeRefreshLayout.m964();
        }

        public void onAnimationRepeat(Animation animation) {
        }

        public void onAnimationStart(Animation animation) {
        }
    }

    /* renamed from: androidx.swiperefreshlayout.widget.SwipeRefreshLayout$㴹  reason: contains not printable characters */
    public class C0287 extends Animation {
        public C0287() {
        }

        public void applyTransformation(float f, Transformation transformation) {
            SwipeRefreshLayout.this.m965(f);
        }
    }

    /* renamed from: androidx.swiperefreshlayout.widget.SwipeRefreshLayout$㸾  reason: contains not printable characters */
    public class animation.Animation$AnimationListenerC0288 implements Animation.AnimationListener {
        public animation.Animation$AnimationListenerC0288() {
        }

        public void onAnimationEnd(Animation animation) {
            SwipeRefreshLayout swipeRefreshLayout = SwipeRefreshLayout.this;
            if (!swipeRefreshLayout.f1640) {
                swipeRefreshLayout.m971((Animation.AnimationListener) null);
            }
        }

        public void onAnimationRepeat(Animation animation) {
        }

        public void onAnimationStart(Animation animation) {
        }
    }

    /* renamed from: androidx.swiperefreshlayout.widget.SwipeRefreshLayout$㿎  reason: contains not printable characters */
    public interface AbstractC0289 {
        /* renamed from: K  reason: contains not printable characters */
        void m977();
    }

    public SwipeRefreshLayout(Context context) {
        this(context, null);
    }

    private void setColorViewAlpha(int i) {
        this.f1667.getBackground().setAlpha(i);
        C2294 r0 = this.f1673;
        r0.f7923.f7946 = i;
        r0.invalidateSelf();
    }

    public boolean dispatchNestedFling(float f, float f2, boolean z) {
        return this.f1652.m4631(f, f2, z);
    }

    public boolean dispatchNestedPreFling(float f, float f2) {
        return this.f1652.m4630(f, f2);
    }

    public boolean dispatchNestedPreScroll(int i, int i2, int[] iArr, int[] iArr2) {
        return this.f1652.m4634(i, i2, iArr, iArr2);
    }

    public boolean dispatchNestedScroll(int i, int i2, int i3, int i4, int[] iArr) {
        return this.f1652.m4633(i, i2, i3, i4, iArr);
    }

    public int getChildDrawingOrder(int i, int i2) {
        int i3 = this.f1648;
        if (i3 < 0) {
            return i2;
        }
        if (i2 == i - 1) {
            return i3;
        }
        return i2 >= i3 ? i2 + 1 : i2;
    }

    public int getNestedScrollAxes() {
        return this.f1670.m4547();
    }

    public int getProgressCircleDiameter() {
        return this.f1663;
    }

    public int getProgressViewEndOffset() {
        return this.f1657;
    }

    public int getProgressViewStartOffset() {
        return this.f1656;
    }

    public boolean hasNestedScrollingParent() {
        return this.f1652.m4629();
    }

    public boolean isNestedScrollingEnabled() {
        return this.f1652.f6118;
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        m964();
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        m966();
        int actionMasked = motionEvent.getActionMasked();
        if (this.f1671 && actionMasked == 0) {
            this.f1671 = false;
        }
        if (!isEnabled() || this.f1671 || m974() || this.f1668 || this.f1658) {
            return false;
        }
        if (actionMasked != 0) {
            if (actionMasked != 1) {
                if (actionMasked == 2) {
                    int i = this.f1661;
                    if (i == -1) {
                        Log.e(f1634, "Got ACTION_MOVE event but don't have an active pointer id.");
                        return false;
                    }
                    int findPointerIndex = motionEvent.findPointerIndex(i);
                    if (findPointerIndex < 0) {
                        return false;
                    }
                    m976(motionEvent.getY(findPointerIndex));
                } else if (actionMasked != 3) {
                    if (actionMasked == 6) {
                        m970(motionEvent);
                    }
                }
            }
            this.f1649 = false;
            this.f1661 = -1;
        } else {
            setTargetOffsetTopAndBottom(this.f1656 - this.f1667.getTop());
            this.f1661 = motionEvent.getPointerId(0);
            this.f1649 = false;
            int findPointerIndex2 = motionEvent.findPointerIndex(this.f1661);
            if (findPointerIndex2 < 0) {
                return false;
            }
            this.f1639 = motionEvent.getY(findPointerIndex2);
        }
        return this.f1649;
    }

    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        int measuredWidth = getMeasuredWidth();
        int measuredHeight = getMeasuredHeight();
        if (getChildCount() != 0) {
            if (this.f1653 == null) {
                m966();
            }
            View view = this.f1653;
            if (view != null) {
                int paddingLeft = getPaddingLeft();
                int paddingTop = getPaddingTop();
                view.layout(paddingLeft, paddingTop, ((measuredWidth - getPaddingLeft()) - getPaddingRight()) + paddingLeft, ((measuredHeight - getPaddingTop()) - getPaddingBottom()) + paddingTop);
                int measuredWidth2 = this.f1667.getMeasuredWidth();
                int measuredHeight2 = this.f1667.getMeasuredHeight();
                int i5 = measuredWidth / 2;
                int i6 = measuredWidth2 / 2;
                int i7 = this.f1637;
                this.f1667.layout(i5 - i6, i7, i5 + i6, measuredHeight2 + i7);
            }
        }
    }

    public void onMeasure(int i, int i2) {
        super.onMeasure(i, i2);
        if (this.f1653 == null) {
            m966();
        }
        View view = this.f1653;
        if (view != null) {
            view.measure(View.MeasureSpec.makeMeasureSpec((getMeasuredWidth() - getPaddingLeft()) - getPaddingRight(), 1073741824), View.MeasureSpec.makeMeasureSpec((getMeasuredHeight() - getPaddingTop()) - getPaddingBottom(), 1073741824));
            this.f1667.measure(View.MeasureSpec.makeMeasureSpec(this.f1663, 1073741824), View.MeasureSpec.makeMeasureSpec(this.f1663, 1073741824));
            this.f1648 = -1;
            for (int i3 = 0; i3 < getChildCount(); i3++) {
                if (getChildAt(i3) == this.f1667) {
                    this.f1648 = i3;
                    return;
                }
            }
        }
    }

    public boolean onNestedFling(View view, float f, float f2, boolean z) {
        return dispatchNestedFling(f, f2, z);
    }

    public boolean onNestedPreFling(View view, float f, float f2) {
        return dispatchNestedPreFling(f, f2);
    }

    public void onNestedPreScroll(View view, int i, int i2, int[] iArr) {
        if (i2 > 0) {
            float f = this.f1654;
            if (f > 0.0f) {
                float f2 = (float) i2;
                if (f2 > f) {
                    iArr[1] = i2 - ((int) f);
                    this.f1654 = 0.0f;
                } else {
                    this.f1654 = f - f2;
                    iArr[1] = i2;
                }
                m967(this.f1654);
            }
        }
        if (this.f1641 && i2 > 0 && this.f1654 == 0.0f && Math.abs(i2 - iArr[1]) > 0) {
            this.f1667.setVisibility(8);
        }
        int[] iArr2 = this.f1664;
        if (dispatchNestedPreScroll(i - iArr[0], i2 - iArr[1], iArr2, null)) {
            iArr[0] = iArr[0] + iArr2[0];
            iArr[1] = iArr[1] + iArr2[1];
        }
    }

    public void onNestedScroll(View view, int i, int i2, int i3, int i4) {
        dispatchNestedScroll(i, i2, i3, i4, this.f1650);
        int i5 = i4 + this.f1650[1];
        if (i5 < 0 && !m974()) {
            this.f1654 += (float) Math.abs(i5);
            m967(this.f1654);
        }
    }

    public void onNestedScrollAccepted(View view, View view2, int i) {
        this.f1670.f6066 = i;
        startNestedScroll(i & 2);
        this.f1654 = 0.0f;
        this.f1658 = true;
    }

    public boolean onStartNestedScroll(View view, View view2, int i) {
        return isEnabled() && !this.f1671 && !this.f1668 && (i & 2) != 0;
    }

    public void onStopNestedScroll(View view) {
        this.f1670.m4548(0);
        this.f1658 = false;
        float f = this.f1654;
        if (f > 0.0f) {
            m969(f);
            this.f1654 = 0.0f;
        }
        stopNestedScroll();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int actionMasked = motionEvent.getActionMasked();
        if (this.f1671 && actionMasked == 0) {
            this.f1671 = false;
        }
        if (!isEnabled() || this.f1671 || m974() || this.f1668 || this.f1658) {
            return false;
        }
        if (actionMasked == 0) {
            this.f1661 = motionEvent.getPointerId(0);
            this.f1649 = false;
        } else if (actionMasked == 1) {
            int findPointerIndex = motionEvent.findPointerIndex(this.f1661);
            if (findPointerIndex < 0) {
                Log.e(f1634, "Got ACTION_UP event but don't have an active pointer id.");
                return false;
            }
            if (this.f1649) {
                this.f1649 = false;
                m969((motionEvent.getY(findPointerIndex) - this.f1660) * 0.5f);
            }
            this.f1661 = -1;
            return false;
        } else if (actionMasked == 2) {
            int findPointerIndex2 = motionEvent.findPointerIndex(this.f1661);
            if (findPointerIndex2 < 0) {
                Log.e(f1634, "Got ACTION_MOVE event but have an invalid active pointer id.");
                return false;
            }
            float y = motionEvent.getY(findPointerIndex2);
            m976(y);
            if (this.f1649) {
                float f = (y - this.f1660) * 0.5f;
                if (f <= 0.0f) {
                    return false;
                }
                m967(f);
            }
        } else if (actionMasked == 3) {
            return false;
        } else {
            if (actionMasked == 5) {
                int actionIndex = motionEvent.getActionIndex();
                if (actionIndex < 0) {
                    Log.e(f1634, "Got ACTION_POINTER_DOWN event but have an invalid action index.");
                    return false;
                }
                this.f1661 = motionEvent.getPointerId(actionIndex);
            } else if (actionMasked == 6) {
                m970(motionEvent);
            }
        }
        return true;
    }

    public void requestDisallowInterceptTouchEvent(boolean z) {
        int i = Build.VERSION.SDK_INT;
        View view = this.f1653;
        if (view == null || C1729.m4455(view)) {
            super.requestDisallowInterceptTouchEvent(z);
        }
    }

    public void setAnimationProgress(float f) {
        this.f1667.setScaleX(f);
        this.f1667.setScaleY(f);
    }

    @Deprecated
    public void setColorScheme(int... iArr) {
        setColorSchemeResources(iArr);
    }

    public void setColorSchemeColors(int... iArr) {
        m966();
        C2294 r0 = this.f1673;
        r0.f7923.m5989(iArr);
        r0.f7923.m5987(0);
        r0.invalidateSelf();
    }

    public void setColorSchemeResources(int... iArr) {
        Context context = getContext();
        int[] iArr2 = new int[iArr.length];
        for (int i = 0; i < iArr.length; i++) {
            iArr2[i] = C1806.m4686(context, iArr[i]);
        }
        setColorSchemeColors(iArr2);
    }

    public void setDistanceToTriggerSync(int i) {
        this.f1666 = (float) i;
    }

    public void setEnabled(boolean z) {
        super.setEnabled(z);
        if (!z) {
            m964();
        }
    }

    public void setNestedScrollingEnabled(boolean z) {
        C1775 r0 = this.f1652;
        if (r0.f6118) {
            C1729.m4441(r0.f6114);
        }
        r0.f6118 = z;
    }

    public void setOnChildScrollUpCallback(AbstractC0285 r1) {
    }

    public void setOnRefreshListener(AbstractC0289 r1) {
        this.f1635 = r1;
    }

    @Deprecated
    public void setProgressBackgroundColor(int i) {
        setProgressBackgroundColorSchemeResource(i);
    }

    public void setProgressBackgroundColorSchemeColor(int i) {
        this.f1667.setBackgroundColor(i);
    }

    public void setProgressBackgroundColorSchemeResource(int i) {
        setProgressBackgroundColorSchemeColor(C1806.m4686(getContext(), i));
    }

    public void setRefreshing(boolean z) {
        int i;
        if (!z || this.f1668 == z) {
            m973(z, false);
            return;
        }
        this.f1668 = z;
        if (!this.f1641) {
            i = this.f1657 + this.f1656;
        } else {
            i = this.f1657;
        }
        setTargetOffsetTopAndBottom(i - this.f1637);
        this.f1636 = false;
        Animation.AnimationListener animationListener = this.f1645;
        this.f1667.setVisibility(0);
        this.f1673.setAlpha(BaseProgressIndicator.MAX_ALPHA);
        this.f1651 = new C2290(this);
        this.f1651.setDuration((long) this.f1672);
        if (animationListener != null) {
            this.f1667.f7916 = animationListener;
        }
        this.f1667.clearAnimation();
        this.f1667.startAnimation(this.f1651);
    }

    public void setSize(int i) {
        if (i == 0 || i == 1) {
            DisplayMetrics displayMetrics = getResources().getDisplayMetrics();
            if (i == 0) {
                this.f1663 = (int) (displayMetrics.density * 56.0f);
            } else {
                this.f1663 = (int) (displayMetrics.density * 40.0f);
            }
            this.f1667.setImageDrawable(null);
            this.f1673.m5986(i);
            this.f1667.setImageDrawable(this.f1673);
        }
    }

    public void setSlingshotDistance(int i) {
        this.f1662 = i;
    }

    public void setTargetOffsetTopAndBottom(int i) {
        this.f1667.bringToFront();
        C1729.m4503(this.f1667, i);
        this.f1637 = this.f1667.getTop();
    }

    public boolean startNestedScroll(int i) {
        return this.f1652.m4632(i, 0);
    }

    public void stopNestedScroll() {
        this.f1652.m4624(0);
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public void m964() {
        this.f1667.clearAnimation();
        this.f1673.stop();
        this.f1667.setVisibility(8);
        setColorViewAlpha(BaseProgressIndicator.MAX_ALPHA);
        if (this.f1640) {
            setAnimationProgress(0.0f);
        } else {
            setTargetOffsetTopAndBottom(this.f1656 - this.f1637);
        }
        this.f1637 = this.f1667.getTop();
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public final void m966() {
        if (this.f1653 == null) {
            for (int i = 0; i < getChildCount(); i++) {
                View childAt = getChildAt(i);
                if (!childAt.equals(this.f1667)) {
                    this.f1653 = childAt;
                    return;
                }
            }
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m972(boolean z, int i, int i2) {
        this.f1640 = z;
        this.f1656 = i;
        this.f1657 = i2;
        this.f1641 = true;
        m964();
        this.f1668 = false;
    }

    /* renamed from: 㸾  reason: contains not printable characters */
    public final void m976(float f) {
        float f2 = this.f1639;
        int i = this.f1642;
        if (f - f2 > ((float) i) && !this.f1649) {
            this.f1660 = f2 + ((float) i);
            this.f1649 = true;
            this.f1673.setAlpha(76);
        }
    }

    public SwipeRefreshLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.f1668 = false;
        this.f1666 = -1.0f;
        this.f1664 = new int[2];
        this.f1650 = new int[2];
        this.f1661 = -1;
        this.f1648 = -1;
        this.f1645 = new animation.Animation$AnimationListenerC0286();
        this.f1669 = new C0283();
        this.f1659 = new C0287();
        this.f1642 = ViewConfiguration.get(context).getScaledTouchSlop();
        this.f1672 = getResources().getInteger(17694721);
        setWillNotDraw(false);
        this.f1638 = new DecelerateInterpolator(2.0f);
        DisplayMetrics displayMetrics = getResources().getDisplayMetrics();
        this.f1663 = (int) (displayMetrics.density * 40.0f);
        this.f1667 = new C2292(getContext(), -328966);
        this.f1673 = new C2294(getContext());
        this.f1673.m5986(1);
        this.f1667.setImageDrawable(this.f1673);
        this.f1667.setVisibility(8);
        addView(this.f1667);
        setChildrenDrawingOrderEnabled(true);
        this.f1657 = (int) (displayMetrics.density * 64.0f);
        this.f1666 = (float) this.f1657;
        this.f1670 = new C1751();
        this.f1652 = new C1775(this);
        setNestedScrollingEnabled(true);
        int i = -this.f1663;
        this.f1637 = i;
        this.f1656 = i;
        m965(1.0f);
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, f1633);
        setEnabled(obtainStyledAttributes.getBoolean(0, true));
        obtainStyledAttributes.recycle();
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public final void m967(float f) {
        C2294 r0 = this.f1673;
        C2294.C2295 k = r0.f7923;
        if (!k.f7928) {
            k.f7928 = true;
        }
        r0.invalidateSelf();
        float min = Math.min(1.0f, Math.abs(f / this.f1666));
        float max = (((float) Math.max(((double) min) - 0.4d, 0.0d)) * 5.0f) / 3.0f;
        float abs = Math.abs(f) - this.f1666;
        int i = this.f1662;
        if (i <= 0) {
            i = this.f1641 ? this.f1657 - this.f1656 : this.f1657;
        }
        float f2 = (float) i;
        double max2 = (double) (Math.max(0.0f, Math.min(abs, f2 * 2.0f) / f2) / 4.0f);
        float pow = ((float) (max2 - Math.pow(max2, 2.0d))) * 2.0f;
        int i2 = this.f1656 + ((int) ((f2 * min) + (f2 * pow * 2.0f)));
        if (this.f1667.getVisibility() != 0) {
            this.f1667.setVisibility(0);
        }
        if (!this.f1640) {
            this.f1667.setScaleX(1.0f);
            this.f1667.setScaleY(1.0f);
        }
        if (this.f1640) {
            setAnimationProgress(Math.min(1.0f, f / this.f1666));
        }
        if (f < this.f1666) {
            if (this.f1673.f7923.f7946 > 76 && !m975(this.f1655)) {
                this.f1655 = m968(this.f1673.f7923.f7946, 76);
            }
        } else if (this.f1673.f7923.f7946 < 255 && !m975(this.f1644)) {
            this.f1644 = m968(this.f1673.f7923.f7946, BaseProgressIndicator.MAX_ALPHA);
        }
        C2294 r4 = this.f1673;
        float min2 = Math.min(0.8f, max * 0.8f);
        C2294.C2295 k2 = r4.f7923;
        k2.f7932 = 0.0f;
        k2.f7943 = min2;
        r4.invalidateSelf();
        C2294 r12 = this.f1673;
        float min3 = Math.min(1.0f, max);
        C2294.C2295 k3 = r12.f7923;
        if (min3 != k3.f7930) {
            k3.f7930 = min3;
        }
        r12.invalidateSelf();
        C2294 r122 = this.f1673;
        r122.f7923.f7937 = ((pow * 2.0f) + ((max * 0.4f) - 16.0f)) * 0.5f;
        r122.invalidateSelf();
        setTargetOffsetTopAndBottom(i2 - this.f1637);
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m973(boolean z, boolean z2) {
        if (this.f1668 != z) {
            this.f1636 = z2;
            m966();
            this.f1668 = z;
            if (this.f1668) {
                int i = this.f1637;
                Animation.AnimationListener animationListener = this.f1645;
                this.f1665 = i;
                this.f1669.reset();
                this.f1669.setDuration(200);
                this.f1669.setInterpolator(this.f1638);
                if (animationListener != null) {
                    this.f1667.f7916 = animationListener;
                }
                this.f1667.clearAnimation();
                this.f1667.startAnimation(this.f1669);
                return;
            }
            m971(this.f1645);
        }
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public void m965(float f) {
        int i = this.f1665;
        setTargetOffsetTopAndBottom((i + ((int) (((float) (this.f1656 - i)) * f))) - this.f1667.getTop());
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m971(Animation.AnimationListener animationListener) {
        this.f1643 = new C0284();
        this.f1643.setDuration(150);
        C2292 k = this.f1667;
        k.f7916 = animationListener;
        k.clearAnimation();
        this.f1667.startAnimation(this.f1643);
    }

    /* renamed from: K  reason: contains not printable characters */
    public final Animation m968(int i, int i2) {
        C0282 r0 = new C0282(i, i2);
        r0.setDuration(300);
        C2292 k = this.f1667;
        k.f7916 = null;
        k.clearAnimation();
        this.f1667.startAnimation(r0);
        return r0;
    }

    /* renamed from: K  reason: contains not printable characters */
    public boolean m974() {
        View view = this.f1653;
        if (!(view instanceof ListView)) {
            return view.canScrollVertically(-1);
        }
        int i = Build.VERSION.SDK_INT;
        return ((ListView) view).canScrollList(-1);
    }

    /* renamed from: K  reason: contains not printable characters */
    public final boolean m975(Animation animation) {
        return animation != null && animation.hasStarted() && !animation.hasEnded();
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m969(float f) {
        if (f > this.f1666) {
            m973(true, true);
            return;
        }
        this.f1668 = false;
        C2294 r0 = this.f1673;
        C2294.C2295 k = r0.f7923;
        k.f7932 = 0.0f;
        k.f7943 = 0.0f;
        r0.invalidateSelf();
        animation.Animation$AnimationListenerC0288 r02 = null;
        if (!this.f1640) {
            r02 = new animation.Animation$AnimationListenerC0288();
        }
        int i = this.f1637;
        if (this.f1640) {
            this.f1665 = i;
            this.f1646 = this.f1667.getScaleX();
            this.f1647 = new C2293(this);
            this.f1647.setDuration(150);
            if (r02 != null) {
                this.f1667.f7916 = r02;
            }
            this.f1667.clearAnimation();
            this.f1667.startAnimation(this.f1647);
        } else {
            this.f1665 = i;
            this.f1659.reset();
            this.f1659.setDuration(200);
            this.f1659.setInterpolator(this.f1638);
            if (r02 != null) {
                this.f1667.f7916 = r02;
            }
            this.f1667.clearAnimation();
            this.f1667.startAnimation(this.f1659);
        }
        C2294 r03 = this.f1673;
        C2294.C2295 k2 = r03.f7923;
        if (k2.f7928) {
            k2.f7928 = false;
        }
        r03.invalidateSelf();
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m970(MotionEvent motionEvent) {
        int actionIndex = motionEvent.getActionIndex();
        if (motionEvent.getPointerId(actionIndex) == this.f1661) {
            this.f1661 = motionEvent.getPointerId(actionIndex == 0 ? 1 : 0);
        }
    }
}
