package androidx.recyclerview.widget;

import android.animation.LayoutTransition;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.Observable;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.os.Trace;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.Display;
import android.view.FocusFinder;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewPropertyAnimator;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.Interpolator;
import android.widget.EdgeEffect;
import android.widget.OverScroller;
import androidx.customview.view.AbsSavedState;
import androidx.recyclerview.R$attr;
import androidx.recyclerview.R$dimen;
import androidx.recyclerview.R$styleable;
import com.facebook.appevents.codeless.CodelessMatcher;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import ඓ.K.K.K.C1293;
import ῲ.ᨨ.ඓ.C1724;
import ῲ.ᨨ.ᨨ.AbstractC1735;
import ῲ.ᨨ.ᨨ.AbstractC1737;
import ῲ.ᨨ.ᨨ.AbstractC1771;
import ῲ.ᨨ.ᨨ.C1729;
import ῲ.ᨨ.ᨨ.C1739;
import ῲ.ᨨ.ᨨ.C1747;
import ῲ.ᨨ.ᨨ.C1775;
import ῲ.ᨨ.ᨨ.䃖.C1782;
import ῲ.ト.ῲ.C2203;
import ῲ.䀟.K.AbstractC2301;
import ῲ.䀟.K.AbstractC2303;
import ῲ.䀟.K.AbstractC2343;
import ῲ.䀟.K.C2304;
import ῲ.䀟.K.C2307;
import ῲ.䀟.K.C2310;
import ῲ.䀟.K.C2316;
import ῲ.䀟.K.C2319;
import ῲ.䀟.K.C2326;
import ῲ.䀟.K.C2331;
import ῲ.䀟.K.C2333;
import ῲ.䀟.K.C2334;
import ῲ.䀟.K.C2338;
import ῲ.䀟.K.RunnableC2299;
import ῲ.䀟.K.RunnableC2306;
import ῲ.䀟.K.RunnableC2312;
import ῲ.䀟.K.RunnableC2337;

public class RecyclerView extends ViewGroup implements AbstractC1735, AbstractC1737, AbstractC1771 {
    public static final boolean ALLOW_SIZE_IN_UNSPECIFIED_SPEC;
    public static final boolean ALLOW_THREAD_GAP_WORK = true;
    public static final boolean DEBUG = false;
    public static final int DEFAULT_ORIENTATION = 1;
    public static final boolean DISPATCH_TEMP_DETACH = false;
    public static final boolean FORCE_ABS_FOCUS_SEARCH_DIRECTION = false;
    public static final boolean FORCE_INVALIDATE_DISPLAY_LIST = false;
    public static final long FOREVER_NS = Long.MAX_VALUE;
    public static final int HORIZONTAL = 0;
    public static final boolean IGNORE_DETACHED_FOCUSED_CHILD = false;
    public static final int INVALID_POINTER = -1;
    public static final int INVALID_TYPE = -1;
    public static final Class<?>[] LAYOUT_MANAGER_CONSTRUCTOR_SIGNATURE;
    public static final int MAX_SCROLL_DURATION = 2000;
    public static final int[] NESTED_SCROLLING_ATTRS = {16843830};
    public static final long NO_ID = -1;
    public static final int NO_POSITION = -1;
    public static final boolean POST_UPDATES_ON_ANIMATION = true;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_SETTLING = 2;
    public static final String TAG = "RecyclerView";
    public static final int TOUCH_SLOP_DEFAULT = 0;
    public static final int TOUCH_SLOP_PAGING = 1;
    public static final String TRACE_BIND_VIEW_TAG = "RV OnBindView";
    public static final String TRACE_CREATE_VIEW_TAG = "RV CreateView";
    public static final String TRACE_HANDLE_ADAPTER_UPDATES_TAG = "RV PartialInvalidate";
    public static final String TRACE_NESTED_PREFETCH_TAG = "RV Nested Prefetch";
    public static final String TRACE_ON_DATA_SET_CHANGE_LAYOUT_TAG = "RV FullInvalidate";
    public static final String TRACE_ON_LAYOUT_TAG = "RV OnLayout";
    public static final String TRACE_PREFETCH_TAG = "RV Prefetch";
    public static final String TRACE_SCROLL_TAG = "RV Scroll";
    public static final int UNDEFINED_DURATION = Integer.MIN_VALUE;
    public static final boolean VERBOSE_TRACING = false;
    public static final int VERTICAL = 1;
    public static final Interpolator sQuinticInterpolator = new animation.InterpolatorC0231();
    public C2304 mAccessibilityDelegate;
    public final AccessibilityManager mAccessibilityManager;
    public AbstractC0246 mAdapter;
    public C2326 mAdapterHelper;
    public boolean mAdapterUpdateDuringMeasure;
    public EdgeEffect mBottomGlow;
    public AbstractC0261 mChildDrawingOrderCallback;
    public C2316 mChildHelper;
    public boolean mClipToPadding;
    public boolean mDataSetHasChangedAfterLayout;
    public boolean mDispatchItemsChangedEvent;
    public int mDispatchScrollCounter;
    public int mEatenAccessibilityChangeFlags;
    public C0243 mEdgeEffectFactory;
    public boolean mEnableFastScroller;
    public boolean mFirstLayoutComplete;
    public RunnableC2312 mGapWorker;
    public boolean mHasFixedSize;
    public boolean mIgnoreMotionEventTillDown;
    public int mInitialTouchX;
    public int mInitialTouchY;
    public int mInterceptRequestLayoutDepth;
    public AbstractC0236 mInterceptingOnItemTouchListener;
    public boolean mIsAttached;
    public AbstractC0250 mItemAnimator;
    public AbstractC0250.AbstractC0252 mItemAnimatorListener;
    public Runnable mItemAnimatorRunner;
    public final ArrayList<AbstractC0232> mItemDecorations;
    public boolean mItemsAddedOrRemoved;
    public boolean mItemsChanged;
    public int mLastTouchX;
    public int mLastTouchY;
    public AbstractC0254 mLayout;
    public int mLayoutOrScrollCounter;
    public boolean mLayoutSuppressed;
    public boolean mLayoutWasDefered;
    public EdgeEffect mLeftGlow;
    public final int mMaxFlingVelocity;
    public final int mMinFlingVelocity;
    public final int[] mMinMaxLayoutPositions;
    public final int[] mNestedOffsets;
    public final C0262 mObserver;
    public List<AbstractC0242> mOnChildAttachStateListeners;
    public AbstractC0259 mOnFlingListener;
    public final ArrayList<AbstractC0236> mOnItemTouchListeners;
    public final List<AbstractC0269> mPendingAccessibilityImportanceChange;
    public SavedState mPendingSavedState;
    public boolean mPostedAnimatorRunner;
    public RunnableC2312.C2314 mPrefetchRegistry;
    public boolean mPreserveFocusAfterLayout;
    public final C0264 mRecycler;
    public AbstractC0241 mRecyclerListener;
    public final int[] mReusableIntPair;
    public EdgeEffect mRightGlow;
    public float mScaledHorizontalScrollFactor;
    public float mScaledVerticalScrollFactor;
    public AbstractC0267 mScrollListener;
    public List<AbstractC0267> mScrollListeners;
    public final int[] mScrollOffset;
    public int mScrollPointerId;
    public int mScrollState;
    public C1775 mScrollingChildHelper;
    public final C0248 mState;
    public final Rect mTempRect;
    public final Rect mTempRect2;
    public final RectF mTempRectF;
    public EdgeEffect mTopGlow;
    public int mTouchSlop;
    public final Runnable mUpdateChildViewsRunnable;
    public VelocityTracker mVelocityTracker;
    public final RunnableC0260 mViewFlinger;
    public final C2307.AbstractC2308 mViewInfoProcessCallback;
    public final C2307 mViewInfoStore;

    /* renamed from: androidx.recyclerview.widget.RecyclerView$ʬ  reason: contains not printable characters */
    public static class animation.InterpolatorC0231 implements Interpolator {
        public float getInterpolation(float f) {
            float f2 = f - 1.0f;
            return (f2 * f2 * f2 * f2 * f2) + 1.0f;
        }
    }

    /* renamed from: androidx.recyclerview.widget.RecyclerView$Ԕ  reason: contains not printable characters */
    public static abstract class AbstractC0232 {
        @Deprecated
        public void getItemOffsets(Rect rect, int i, RecyclerView recyclerView) {
            rect.set(0, 0, 0, 0);
        }

        @Deprecated
        public void onDraw(Canvas canvas, RecyclerView recyclerView) {
        }

        public void onDraw(Canvas canvas, RecyclerView recyclerView, C0248 r3) {
            onDraw(canvas, recyclerView);
        }

        @Deprecated
        public void onDrawOver(Canvas canvas, RecyclerView recyclerView) {
        }

        public void onDrawOver(Canvas canvas, RecyclerView recyclerView, C0248 r3) {
            onDrawOver(canvas, recyclerView);
        }

        public void getItemOffsets(Rect rect, View view, RecyclerView recyclerView, C0248 r4) {
            getItemOffsets(rect, ((C0235) view.getLayoutParams()).m811(), recyclerView);
        }
    }

    /* renamed from: androidx.recyclerview.widget.RecyclerView$ݜ  reason: contains not printable characters */
    public interface AbstractC0236 {
    }

    /* renamed from: androidx.recyclerview.widget.RecyclerView$ඓ  reason: contains not printable characters */
    public class C0237 implements C2316.AbstractC2317 {
        public C0237() {
        }

        /* renamed from: ʬ  reason: contains not printable characters */
        public void m812(View view) {
            AbstractC0269 childViewHolderInt = RecyclerView.getChildViewHolderInt(view);
            if (childViewHolderInt != null) {
                childViewHolderInt.onLeftHiddenState(RecyclerView.this);
            }
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public void m813(int i) {
            View childAt = RecyclerView.this.getChildAt(i);
            if (childAt != null) {
                RecyclerView.this.dispatchChildDetached(childAt);
                childAt.clearAnimation();
            }
            RecyclerView.this.removeViewAt(i);
        }

        /* renamed from: K  reason: contains not printable characters */
        public int m815() {
            return RecyclerView.this.getChildCount();
        }

        /* renamed from: K  reason: contains not printable characters */
        public View m816(int i) {
            return RecyclerView.this.getChildAt(i);
        }

        /* renamed from: K  reason: contains not printable characters */
        public AbstractC0269 m817(View view) {
            return RecyclerView.getChildViewHolderInt(view);
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m818(View view, int i, ViewGroup.LayoutParams layoutParams) {
            AbstractC0269 childViewHolderInt = RecyclerView.getChildViewHolderInt(view);
            if (childViewHolderInt != null) {
                if (childViewHolderInt.isTmpDetached() || childViewHolderInt.shouldIgnore()) {
                    childViewHolderInt.clearTmpDetachFlag();
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Called attach on a child which is not detached: ");
                    sb.append(childViewHolderInt);
                    throw new IllegalArgumentException(C1293.m3407(RecyclerView.this, sb));
                }
            }
            RecyclerView.this.attachViewToParent(view, i, layoutParams);
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public void m814(View view) {
            AbstractC0269 childViewHolderInt = RecyclerView.getChildViewHolderInt(view);
            if (childViewHolderInt != null) {
                childViewHolderInt.onEnteredHiddenState(RecyclerView.this);
            }
        }
    }

    /* renamed from: androidx.recyclerview.widget.RecyclerView$ᓆ  reason: contains not printable characters */
    public interface AbstractC0241 {
        /* renamed from: K  reason: contains not printable characters */
        void m821(AbstractC0269 v);
    }

    /* renamed from: androidx.recyclerview.widget.RecyclerView$ᓣ  reason: contains not printable characters */
    public interface AbstractC0242 {
    }

    /* renamed from: androidx.recyclerview.widget.RecyclerView$ᕣ  reason: contains not printable characters */
    public static class C0243 {
        /* renamed from: K  reason: contains not printable characters */
        public EdgeEffect m822(RecyclerView recyclerView) {
            return new EdgeEffect(recyclerView.getContext());
        }
    }

    /* renamed from: androidx.recyclerview.widget.RecyclerView$ᨨ  reason: contains not printable characters */
    public static abstract class AbstractC0244 {
        public void onChanged() {
        }

        public void onItemRangeChanged(int i, int i2) {
        }

        public void onItemRangeChanged(int i, int i2, Object obj) {
            onItemRangeChanged(i, i2);
        }

        public void onItemRangeInserted(int i, int i2) {
        }

        public void onItemRangeMoved(int i, int i2, int i3) {
        }

        public void onItemRangeRemoved(int i, int i2) {
        }
    }

    /* renamed from: androidx.recyclerview.widget.RecyclerView$ῲ  reason: contains not printable characters */
    public class RunnableC0245 implements Runnable {
        public RunnableC0245() {
        }

        public void run() {
            AbstractC0250 r0 = RecyclerView.this.mItemAnimator;
            if (r0 != null) {
                C2319 r02 = (C2319) r0;
                boolean z = !r02.f8014.isEmpty();
                boolean z2 = !r02.f8013.isEmpty();
                boolean z3 = !r02.f8008.isEmpty();
                boolean z4 = !r02.f8009.isEmpty();
                if (z || z2 || z4 || z3) {
                    Iterator<AbstractC0269> it2 = r02.f8014.iterator();
                    while (it2.hasNext()) {
                        AbstractC0269 next = it2.next();
                        View view = next.itemView;
                        ViewPropertyAnimator animate = view.animate();
                        r02.f8007.add(next);
                        animate.setDuration(r02.f1517).alpha(0.0f).setListener(new C2333(r02, next, animate, view)).start();
                    }
                    r02.f8014.clear();
                    if (z2) {
                        ArrayList<C2319.C2324> arrayList = new ArrayList<>();
                        arrayList.addAll(r02.f8013);
                        r02.f8015.add(arrayList);
                        r02.f8013.clear();
                        RunnableC2299 r7 = new RunnableC2299(r02, arrayList);
                        if (z) {
                            C1729.m4480(arrayList.get(0).f8039.itemView, r7, r02.f1517);
                        } else {
                            r7.run();
                        }
                    }
                    if (z3) {
                        ArrayList<C2319.C2321> arrayList2 = new ArrayList<>();
                        arrayList2.addAll(r02.f8008);
                        r02.f8005.add(arrayList2);
                        r02.f8008.clear();
                        RunnableC2337 r72 = new RunnableC2337(r02, arrayList2);
                        if (z) {
                            C1729.m4480(arrayList2.get(0).f8023.itemView, r72, r02.f1517);
                        } else {
                            r72.run();
                        }
                    }
                    if (z4) {
                        ArrayList<AbstractC0269> arrayList3 = new ArrayList<>();
                        arrayList3.addAll(r02.f8009);
                        r02.f8010.add(arrayList3);
                        r02.f8009.clear();
                        RunnableC2306 r6 = new RunnableC2306(r02, arrayList3);
                        if (z || z2 || z3) {
                            long j = 0;
                            long j2 = z ? r02.f1517 : 0;
                            long r2 = z2 ? r02.m826() : 0;
                            if (z3) {
                                j = r02.f1516;
                            }
                            C1729.m4480(arrayList3.get(0).itemView, r6, Math.max(r2, j) + j2);
                        } else {
                            r6.run();
                        }
                    }
                }
            }
            RecyclerView.this.mPostedAnimatorRunner = false;
        }
    }

    /* renamed from: androidx.recyclerview.widget.RecyclerView$K  reason: contains not printable characters */
    public class RunnableC0247 implements Runnable {
        public RunnableC0247() {
        }

        public void run() {
            RecyclerView recyclerView = RecyclerView.this;
            if (recyclerView.mFirstLayoutComplete && !recyclerView.isLayoutRequested()) {
                RecyclerView recyclerView2 = RecyclerView.this;
                if (!recyclerView2.mIsAttached) {
                    recyclerView2.requestLayout();
                } else if (recyclerView2.mLayoutSuppressed) {
                    recyclerView2.mLayoutWasDefered = true;
                } else {
                    recyclerView2.consumePendingUpdateOperations();
                }
            }
        }
    }

    /* renamed from: androidx.recyclerview.widget.RecyclerView$ト  reason: contains not printable characters */
    public static abstract class AbstractC0249 {
    }

    /* renamed from: androidx.recyclerview.widget.RecyclerView$㑃  reason: contains not printable characters */
    public static abstract class AbstractC0250 {

        /* renamed from: ʬ  reason: contains not printable characters */
        public long f1512 = 120;

        /* renamed from: ඓ  reason: contains not printable characters */
        public long f1513 = 250;

        /* renamed from: ῲ  reason: contains not printable characters */
        public ArrayList<AbstractC0253> f1514 = new ArrayList<>();

        /* renamed from: K  reason: contains not printable characters */
        public AbstractC0252 f1515 = null;

        /* renamed from: 㴹  reason: contains not printable characters */
        public long f1516 = 250;

        /* renamed from: 㸾  reason: contains not printable characters */
        public long f1517 = 120;

        /* renamed from: androidx.recyclerview.widget.RecyclerView$㑃$ʬ  reason: contains not printable characters */
        public static class C0251 {

            /* renamed from: ῲ  reason: contains not printable characters */
            public int f1518;

            /* renamed from: K  reason: contains not printable characters */
            public int f1519;

            /* renamed from: K  reason: contains not printable characters */
            public C0251 m838(AbstractC0269 r2) {
                View view = r2.itemView;
                this.f1519 = view.getLeft();
                this.f1518 = view.getTop();
                view.getRight();
                view.getBottom();
                return this;
            }
        }

        /* renamed from: androidx.recyclerview.widget.RecyclerView$㑃$ῲ  reason: contains not printable characters */
        public interface AbstractC0252 {
        }

        /* renamed from: androidx.recyclerview.widget.RecyclerView$㑃$K  reason: contains not printable characters */
        public interface AbstractC0253 {
            /* renamed from: K  reason: contains not printable characters */
            void m839();
        }

        /* renamed from: ʬ  reason: contains not printable characters */
        public long m826() {
            return this.f1513;
        }

        /* renamed from: ʬ  reason: contains not printable characters */
        public abstract boolean m827(AbstractC0269 v, C0251 v2, C0251 v3);

        /* renamed from: ඓ  reason: contains not printable characters */
        public C0251 m828() {
            return new C0251();
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public abstract void m829();

        /* renamed from: ῲ  reason: contains not printable characters */
        public abstract void m830(AbstractC0269 v);

        /* renamed from: ῲ  reason: contains not printable characters */
        public abstract boolean m831(AbstractC0269 v, C0251 v2, C0251 v3);

        /* renamed from: K  reason: contains not printable characters */
        public final void m833(AbstractC0269 r2) {
            AbstractC0252 r0 = this.f1515;
            if (r0 != null) {
                ((C0268) r0).m879(r2);
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public abstract boolean m834(AbstractC0269 v, C0251 v2, C0251 v3);

        /* renamed from: K  reason: contains not printable characters */
        public abstract boolean m835(AbstractC0269 v, AbstractC0269 v2, C0251 v3, C0251 v4);

        /* renamed from: 㸾  reason: contains not printable characters */
        public abstract boolean m837();

        /* renamed from: ʬ  reason: contains not printable characters */
        public static int m825(AbstractC0269 r3) {
            int i = r3.mFlags & 14;
            if (r3.isInvalid()) {
                return 4;
            }
            if ((i & 4) != 0) {
                return i;
            }
            int oldPosition = r3.getOldPosition();
            int adapterPosition = r3.getAdapterPosition();
            return (oldPosition == -1 || adapterPosition == -1 || oldPosition == adapterPosition) ? i : i | AbstractC0269.FLAG_MOVED;
        }

        /* renamed from: K  reason: contains not printable characters */
        public boolean m836(AbstractC0269 r1, List<Object> list) {
            return !((AbstractC2343) this).f8108 || r1.isInvalid();
        }

        /* renamed from: K  reason: contains not printable characters */
        public final void m832() {
            int size = this.f1514.size();
            for (int i = 0; i < size; i++) {
                this.f1514.get(i).m839();
            }
            this.f1514.clear();
        }
    }

    /* renamed from: androidx.recyclerview.widget.RecyclerView$㗗  reason: contains not printable characters */
    public static abstract class AbstractC0254 {
        public boolean mAutoMeasure = false;
        public C2316 mChildHelper;
        public int mHeight;
        public int mHeightMode;
        public C2334 mHorizontalBoundCheck = new C2334(this.mHorizontalBoundCheckCallback);
        public final C2334.AbstractC2335 mHorizontalBoundCheckCallback = new C0257();
        public boolean mIsAttachedToWindow = false;
        public boolean mItemPrefetchEnabled = true;
        public boolean mMeasurementCacheEnabled = true;
        public int mPrefetchMaxCountObserved;
        public boolean mPrefetchMaxObservedInInitialPrefetch;
        public RecyclerView mRecyclerView;
        public boolean mRequestedSimpleAnimations = false;
        public AbstractC0238 mSmoothScroller;
        public C2334 mVerticalBoundCheck = new C2334(this.mVerticalBoundCheckCallback);
        public final C2334.AbstractC2335 mVerticalBoundCheckCallback = new C0256();
        public int mWidth;
        public int mWidthMode;

        /* renamed from: androidx.recyclerview.widget.RecyclerView$㗗$ʬ  reason: contains not printable characters */
        public interface AbstractC0255 {
        }

        /* renamed from: androidx.recyclerview.widget.RecyclerView$㗗$ῲ  reason: contains not printable characters */
        public class C0256 implements C2334.AbstractC2335 {
            public C0256() {
            }

            @Override // ῲ.䀟.K.C2334.AbstractC2335
            /* renamed from: ῲ  reason: contains not printable characters */
            public int m840() {
                return AbstractC0254.this.getPaddingTop();
            }

            @Override // ῲ.䀟.K.C2334.AbstractC2335
            /* renamed from: K  reason: contains not printable characters */
            public View m844(int i) {
                return AbstractC0254.this.getChildAt(i);
            }

            @Override // ῲ.䀟.K.C2334.AbstractC2335
            /* renamed from: ῲ  reason: contains not printable characters */
            public int m841(View view) {
                return AbstractC0254.this.getDecoratedTop(view) - ((ViewGroup.MarginLayoutParams) ((C0235) view.getLayoutParams())).topMargin;
            }

            @Override // ῲ.䀟.K.C2334.AbstractC2335
            /* renamed from: K  reason: contains not printable characters */
            public int m842() {
                return AbstractC0254.this.getHeight() - AbstractC0254.this.getPaddingBottom();
            }

            @Override // ῲ.䀟.K.C2334.AbstractC2335
            /* renamed from: K  reason: contains not printable characters */
            public int m843(View view) {
                return AbstractC0254.this.getDecoratedBottom(view) + ((ViewGroup.MarginLayoutParams) ((C0235) view.getLayoutParams())).bottomMargin;
            }
        }

        /* renamed from: androidx.recyclerview.widget.RecyclerView$㗗$K  reason: contains not printable characters */
        public class C0257 implements C2334.AbstractC2335 {
            public C0257() {
            }

            @Override // ῲ.䀟.K.C2334.AbstractC2335
            /* renamed from: ῲ  reason: contains not printable characters */
            public int m845() {
                return AbstractC0254.this.getPaddingLeft();
            }

            @Override // ῲ.䀟.K.C2334.AbstractC2335
            /* renamed from: K  reason: contains not printable characters */
            public View m849(int i) {
                return AbstractC0254.this.getChildAt(i);
            }

            @Override // ῲ.䀟.K.C2334.AbstractC2335
            /* renamed from: ῲ  reason: contains not printable characters */
            public int m846(View view) {
                return AbstractC0254.this.getDecoratedLeft(view) - ((ViewGroup.MarginLayoutParams) ((C0235) view.getLayoutParams())).leftMargin;
            }

            @Override // ῲ.䀟.K.C2334.AbstractC2335
            /* renamed from: K  reason: contains not printable characters */
            public int m847() {
                return AbstractC0254.this.getWidth() - AbstractC0254.this.getPaddingRight();
            }

            @Override // ῲ.䀟.K.C2334.AbstractC2335
            /* renamed from: K  reason: contains not printable characters */
            public int m848(View view) {
                return AbstractC0254.this.getDecoratedRight(view) + ((ViewGroup.MarginLayoutParams) ((C0235) view.getLayoutParams())).rightMargin;
            }
        }

        /* renamed from: androidx.recyclerview.widget.RecyclerView$㗗$㸾  reason: contains not printable characters */
        public static class C0258 {

            /* renamed from: ʬ  reason: contains not printable characters */
            public boolean f1522;

            /* renamed from: ῲ  reason: contains not printable characters */
            public int f1523;

            /* renamed from: K  reason: contains not printable characters */
            public int f1524;

            /* renamed from: 㸾  reason: contains not printable characters */
            public boolean f1525;
        }

        private void addViewInt(View view, int i, boolean z) {
            AbstractC0269 childViewHolderInt = RecyclerView.getChildViewHolderInt(view);
            if (z || childViewHolderInt.isRemoved()) {
                this.mRecyclerView.mViewInfoStore.m6035(childViewHolderInt);
            } else {
                this.mRecyclerView.mViewInfoStore.m6030(childViewHolderInt);
            }
            C0235 r7 = (C0235) view.getLayoutParams();
            if (childViewHolderInt.wasReturnedFromScrap() || childViewHolderInt.isScrap()) {
                if (childViewHolderInt.isScrap()) {
                    childViewHolderInt.unScrap();
                } else {
                    childViewHolderInt.clearReturnedFromScrapFlag();
                }
                this.mChildHelper.m6055(view, i, view.getLayoutParams(), false);
            } else if (view.getParent() == this.mRecyclerView) {
                int r1 = this.mChildHelper.m6053(view);
                if (i == -1) {
                    i = this.mChildHelper.m6052();
                }
                if (r1 == -1) {
                    StringBuilder r72 = C1293.m3416("Added View has RecyclerView as parent but view is not a real child. Unfiltered index:");
                    r72.append(this.mRecyclerView.indexOfChild(view));
                    throw new IllegalStateException(C1293.m3407(this.mRecyclerView, r72));
                } else if (r1 != i) {
                    this.mRecyclerView.mLayout.moveView(r1, i);
                }
            } else {
                this.mChildHelper.m6056(view, i, false);
                r7.f1481 = true;
                AbstractC0238 r6 = this.mSmoothScroller;
                if (r6 != null && r6.isRunning()) {
                    this.mSmoothScroller.onChildAttachedToWindow(view);
                }
            }
            if (r7.f1484) {
                childViewHolderInt.itemView.invalidate();
                r7.f1484 = false;
            }
        }

        public static int chooseSize(int i, int i2, int i3) {
            int mode = View.MeasureSpec.getMode(i);
            int size = View.MeasureSpec.getSize(i);
            if (mode != Integer.MIN_VALUE) {
                return mode != 1073741824 ? Math.max(i2, i3) : size;
            }
            return Math.min(size, Math.max(i2, i3));
        }

        private void detachViewInternal(int i, View view) {
            this.mChildHelper.m6054(i);
        }

        /* JADX WARNING: Code restructure failed: missing block: B:2:0x000a, code lost:
            if (r3 >= 0) goto L_0x0011;
         */
        @Deprecated
        public static int getChildMeasureSpec(int i, int i2, int i3, boolean z) {
            int i4 = i - i2;
            int i5 = 0;
            int max = Math.max(0, i4);
            if (!z) {
                if (i3 < 0) {
                    if (i3 != -1) {
                        if (i3 == -2) {
                            i5 = Integer.MIN_VALUE;
                            return View.MeasureSpec.makeMeasureSpec(max, i5);
                        }
                    }
                    i5 = 1073741824;
                    return View.MeasureSpec.makeMeasureSpec(max, i5);
                }
                max = i3;
                i5 = 1073741824;
                return View.MeasureSpec.makeMeasureSpec(max, i5);
            }
            max = 0;
            return View.MeasureSpec.makeMeasureSpec(max, i5);
        }

        private int[] getChildRectangleOnScreenScrollAmount(View view, Rect rect) {
            int[] iArr = new int[2];
            int paddingLeft = getPaddingLeft();
            int paddingTop = getPaddingTop();
            int width = getWidth() - getPaddingRight();
            int height = getHeight() - getPaddingBottom();
            int left = (view.getLeft() + rect.left) - view.getScrollX();
            int top2 = (view.getTop() + rect.top) - view.getScrollY();
            int width2 = rect.width() + left;
            int height2 = rect.height() + top2;
            int i = left - paddingLeft;
            int min = Math.min(0, i);
            int i2 = top2 - paddingTop;
            int min2 = Math.min(0, i2);
            int i3 = width2 - width;
            int max = Math.max(0, i3);
            int max2 = Math.max(0, height2 - height);
            if (getLayoutDirection() != 1) {
                if (min == 0) {
                    min = Math.min(i, max);
                }
                max = min;
            } else if (max == 0) {
                max = Math.max(min, i3);
            }
            if (min2 == 0) {
                min2 = Math.min(i2, max2);
            }
            iArr[0] = max;
            iArr[1] = min2;
            return iArr;
        }

        public static C0258 getProperties(Context context, AttributeSet attributeSet, int i, int i2) {
            C0258 r0 = new C0258();
            TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, R$styleable.RecyclerView, i, i2);
            r0.f1524 = obtainStyledAttributes.getInt(R$styleable.RecyclerView_android_orientation, 1);
            r0.f1523 = obtainStyledAttributes.getInt(R$styleable.RecyclerView_spanCount, 1);
            r0.f1522 = obtainStyledAttributes.getBoolean(R$styleable.RecyclerView_reverseLayout, false);
            r0.f1525 = obtainStyledAttributes.getBoolean(R$styleable.RecyclerView_stackFromEnd, false);
            obtainStyledAttributes.recycle();
            return r0;
        }

        private boolean isFocusedChildVisibleAfterScrolling(RecyclerView recyclerView, int i, int i2) {
            View focusedChild = recyclerView.getFocusedChild();
            if (focusedChild == null) {
                return false;
            }
            int paddingLeft = getPaddingLeft();
            int paddingTop = getPaddingTop();
            int width = getWidth() - getPaddingRight();
            int height = getHeight() - getPaddingBottom();
            Rect rect = this.mRecyclerView.mTempRect;
            getDecoratedBoundsWithMargins(focusedChild, rect);
            if (rect.left - i >= width || rect.right - i <= paddingLeft || rect.top - i2 >= height || rect.bottom - i2 <= paddingTop) {
                return false;
            }
            return true;
        }

        public static boolean isMeasurementUpToDate(int i, int i2, int i3) {
            int mode = View.MeasureSpec.getMode(i2);
            int size = View.MeasureSpec.getSize(i2);
            if (i3 > 0 && i != i3) {
                return false;
            }
            if (mode == Integer.MIN_VALUE) {
                return size >= i;
            }
            if (mode != 0) {
                return mode == 1073741824 && size == i;
            }
            return true;
        }

        private void scrapOrRecycleView(C0264 r3, int i, View view) {
            AbstractC0269 childViewHolderInt = RecyclerView.getChildViewHolderInt(view);
            if (!childViewHolderInt.shouldIgnore()) {
                if (!childViewHolderInt.isInvalid() || childViewHolderInt.isRemoved() || this.mRecyclerView.mAdapter.hasStableIds()) {
                    detachViewAt(i);
                    r3.m858(view);
                    this.mRecyclerView.mViewInfoStore.m6030(childViewHolderInt);
                    return;
                }
                removeViewAt(i);
                r3.m869(childViewHolderInt);
            }
        }

        public void addDisappearingView(View view) {
            addDisappearingView(view, -1);
        }

        public void addView(View view) {
            addView(view, -1);
        }

        public void assertInLayoutOrScroll(String str) {
            RecyclerView recyclerView = this.mRecyclerView;
            if (recyclerView != null) {
                recyclerView.assertInLayoutOrScroll(str);
            }
        }

        public void assertNotInLayoutOrScroll(String str) {
            RecyclerView recyclerView = this.mRecyclerView;
            if (recyclerView != null) {
                recyclerView.assertNotInLayoutOrScroll(str);
            }
        }

        public void attachView(View view, int i, C0235 r5) {
            AbstractC0269 childViewHolderInt = RecyclerView.getChildViewHolderInt(view);
            if (childViewHolderInt.isRemoved()) {
                this.mRecyclerView.mViewInfoStore.m6035(childViewHolderInt);
            } else {
                this.mRecyclerView.mViewInfoStore.m6030(childViewHolderInt);
            }
            this.mChildHelper.m6055(view, i, r5, childViewHolderInt.isRemoved());
        }

        public void calculateItemDecorationsForChild(View view, Rect rect) {
            RecyclerView recyclerView = this.mRecyclerView;
            if (recyclerView == null) {
                rect.set(0, 0, 0, 0);
            } else {
                rect.set(recyclerView.getItemDecorInsetsForChild(view));
            }
        }

        public boolean canScrollHorizontally() {
            return false;
        }

        public boolean canScrollVertically() {
            return false;
        }

        public boolean checkLayoutParams(C0235 r1) {
            return r1 != null;
        }

        public void collectAdjacentPrefetchPositions(int i, int i2, C0248 r3, AbstractC0255 r4) {
        }

        public void collectInitialPrefetchPositions(int i, AbstractC0255 r2) {
        }

        public int computeHorizontalScrollExtent(C0248 r1) {
            return 0;
        }

        public int computeHorizontalScrollOffset(C0248 r1) {
            return 0;
        }

        public int computeHorizontalScrollRange(C0248 r1) {
            return 0;
        }

        public int computeVerticalScrollExtent(C0248 r1) {
            return 0;
        }

        public int computeVerticalScrollOffset(C0248 r1) {
            return 0;
        }

        public int computeVerticalScrollRange(C0248 r1) {
            return 0;
        }

        public void detachAndScrapAttachedViews(C0264 r3) {
            for (int childCount = getChildCount() - 1; childCount >= 0; childCount--) {
                scrapOrRecycleView(r3, childCount, getChildAt(childCount));
            }
        }

        public void detachAndScrapView(View view, C0264 r3) {
            scrapOrRecycleView(r3, this.mChildHelper.m6053(view), view);
        }

        public void detachAndScrapViewAt(int i, C0264 r3) {
            scrapOrRecycleView(r3, i, getChildAt(i));
        }

        public void detachView(View view) {
            int r0 = this.mChildHelper.m6053(view);
            if (r0 >= 0) {
                detachViewInternal(r0, view);
            }
        }

        public void detachViewAt(int i) {
            detachViewInternal(i, getChildAt(i));
        }

        public void dispatchAttachedToWindow(RecyclerView recyclerView) {
            this.mIsAttachedToWindow = true;
            onAttachedToWindow(recyclerView);
        }

        public void dispatchDetachedFromWindow(RecyclerView recyclerView, C0264 r3) {
            this.mIsAttachedToWindow = false;
            onDetachedFromWindow(recyclerView, r3);
        }

        public void endAnimation(View view) {
            AbstractC0250 r0 = this.mRecyclerView.mItemAnimator;
            if (r0 != null) {
                r0.m830(RecyclerView.getChildViewHolderInt(view));
            }
        }

        public View findContainingItemView(View view) {
            View findContainingItemView;
            RecyclerView recyclerView = this.mRecyclerView;
            if (recyclerView == null || (findContainingItemView = recyclerView.findContainingItemView(view)) == null || this.mChildHelper.f7999.contains(findContainingItemView)) {
                return null;
            }
            return findContainingItemView;
        }

        public View findViewByPosition(int i) {
            int childCount = getChildCount();
            for (int i2 = 0; i2 < childCount; i2++) {
                View childAt = getChildAt(i2);
                AbstractC0269 childViewHolderInt = RecyclerView.getChildViewHolderInt(childAt);
                if (childViewHolderInt != null && childViewHolderInt.getLayoutPosition() == i && !childViewHolderInt.shouldIgnore() && (this.mRecyclerView.mState.f1510 || !childViewHolderInt.isRemoved())) {
                    return childAt;
                }
            }
            return null;
        }

        public abstract C0235 generateDefaultLayoutParams();

        public C0235 generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
            if (layoutParams instanceof C0235) {
                return new C0235((C0235) layoutParams);
            }
            if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
                return new C0235((ViewGroup.MarginLayoutParams) layoutParams);
            }
            return new C0235(layoutParams);
        }

        public int getBaseline() {
            return -1;
        }

        public int getBottomDecorationHeight(View view) {
            return ((C0235) view.getLayoutParams()).f1482.bottom;
        }

        public View getChildAt(int i) {
            C2316 r0 = this.mChildHelper;
            if (r0 == null) {
                return null;
            }
            return ((C0237) r0.f8001).m816(r0.m6046(i));
        }

        public int getChildCount() {
            C2316 r0 = this.mChildHelper;
            if (r0 != null) {
                return r0.m6052();
            }
            return 0;
        }

        public boolean getClipToPadding() {
            RecyclerView recyclerView = this.mRecyclerView;
            return recyclerView != null && recyclerView.mClipToPadding;
        }

        public int getColumnCountForAccessibility(C0264 r1, C0248 r2) {
            RecyclerView recyclerView = this.mRecyclerView;
            if (recyclerView == null || recyclerView.mAdapter == null || !canScrollHorizontally()) {
                return 1;
            }
            return this.mRecyclerView.mAdapter.getItemCount();
        }

        public int getDecoratedBottom(View view) {
            return getBottomDecorationHeight(view) + view.getBottom();
        }

        public void getDecoratedBoundsWithMargins(View view, Rect rect) {
            RecyclerView.getDecoratedBoundsWithMarginsInt(view, rect);
        }

        public int getDecoratedLeft(View view) {
            return view.getLeft() - getLeftDecorationWidth(view);
        }

        public int getDecoratedMeasuredHeight(View view) {
            Rect rect = ((C0235) view.getLayoutParams()).f1482;
            return view.getMeasuredHeight() + rect.top + rect.bottom;
        }

        public int getDecoratedMeasuredWidth(View view) {
            Rect rect = ((C0235) view.getLayoutParams()).f1482;
            return view.getMeasuredWidth() + rect.left + rect.right;
        }

        public int getDecoratedRight(View view) {
            return getRightDecorationWidth(view) + view.getRight();
        }

        public int getDecoratedTop(View view) {
            return view.getTop() - getTopDecorationHeight(view);
        }

        public View getFocusedChild() {
            View focusedChild;
            RecyclerView recyclerView = this.mRecyclerView;
            if (recyclerView == null || (focusedChild = recyclerView.getFocusedChild()) == null || this.mChildHelper.f7999.contains(focusedChild)) {
                return null;
            }
            return focusedChild;
        }

        public int getHeight() {
            return this.mHeight;
        }

        public int getHeightMode() {
            return this.mHeightMode;
        }

        public int getItemCount() {
            RecyclerView recyclerView = this.mRecyclerView;
            AbstractC0246 adapter = recyclerView != null ? recyclerView.getAdapter() : null;
            if (adapter != null) {
                return adapter.getItemCount();
            }
            return 0;
        }

        public int getItemViewType(View view) {
            return RecyclerView.getChildViewHolderInt(view).getItemViewType();
        }

        public int getLayoutDirection() {
            return C1729.m4511(this.mRecyclerView);
        }

        public int getLeftDecorationWidth(View view) {
            return ((C0235) view.getLayoutParams()).f1482.left;
        }

        public int getMinimumHeight() {
            return C1729.m4442(this.mRecyclerView);
        }

        public int getMinimumWidth() {
            return C1729.m4496(this.mRecyclerView);
        }

        public int getPaddingBottom() {
            RecyclerView recyclerView = this.mRecyclerView;
            if (recyclerView != null) {
                return recyclerView.getPaddingBottom();
            }
            return 0;
        }

        public int getPaddingEnd() {
            RecyclerView recyclerView = this.mRecyclerView;
            if (recyclerView != null) {
                return C1729.m4453(recyclerView);
            }
            return 0;
        }

        public int getPaddingLeft() {
            RecyclerView recyclerView = this.mRecyclerView;
            if (recyclerView != null) {
                return recyclerView.getPaddingLeft();
            }
            return 0;
        }

        public int getPaddingRight() {
            RecyclerView recyclerView = this.mRecyclerView;
            if (recyclerView != null) {
                return recyclerView.getPaddingRight();
            }
            return 0;
        }

        public int getPaddingStart() {
            RecyclerView recyclerView = this.mRecyclerView;
            if (recyclerView != null) {
                return C1729.m4497(recyclerView);
            }
            return 0;
        }

        public int getPaddingTop() {
            RecyclerView recyclerView = this.mRecyclerView;
            if (recyclerView != null) {
                return recyclerView.getPaddingTop();
            }
            return 0;
        }

        public int getPosition(View view) {
            return ((C0235) view.getLayoutParams()).m811();
        }

        public int getRightDecorationWidth(View view) {
            return ((C0235) view.getLayoutParams()).f1482.right;
        }

        public int getRowCountForAccessibility(C0264 r1, C0248 r2) {
            RecyclerView recyclerView = this.mRecyclerView;
            if (recyclerView == null || recyclerView.mAdapter == null || !canScrollVertically()) {
                return 1;
            }
            return this.mRecyclerView.mAdapter.getItemCount();
        }

        public int getSelectionModeForAccessibility(C0264 r1, C0248 r2) {
            return 0;
        }

        public int getTopDecorationHeight(View view) {
            return ((C0235) view.getLayoutParams()).f1482.top;
        }

        public void getTransformedBoundingBox(View view, boolean z, Rect rect) {
            Matrix matrix;
            if (z) {
                Rect rect2 = ((C0235) view.getLayoutParams()).f1482;
                rect.set(-rect2.left, -rect2.top, view.getWidth() + rect2.right, view.getHeight() + rect2.bottom);
            } else {
                rect.set(0, 0, view.getWidth(), view.getHeight());
            }
            if (!(this.mRecyclerView == null || (matrix = view.getMatrix()) == null || matrix.isIdentity())) {
                RectF rectF = this.mRecyclerView.mTempRectF;
                rectF.set(rect);
                matrix.mapRect(rectF);
                rect.set((int) Math.floor((double) rectF.left), (int) Math.floor((double) rectF.top), (int) Math.ceil((double) rectF.right), (int) Math.ceil((double) rectF.bottom));
            }
            rect.offset(view.getLeft(), view.getTop());
        }

        public int getWidth() {
            return this.mWidth;
        }

        public int getWidthMode() {
            return this.mWidthMode;
        }

        public boolean hasFlexibleChildInBothOrientations() {
            int childCount = getChildCount();
            for (int i = 0; i < childCount; i++) {
                ViewGroup.LayoutParams layoutParams = getChildAt(i).getLayoutParams();
                if (layoutParams.width < 0 && layoutParams.height < 0) {
                    return true;
                }
            }
            return false;
        }

        public boolean hasFocus() {
            RecyclerView recyclerView = this.mRecyclerView;
            return recyclerView != null && recyclerView.hasFocus();
        }

        public void ignoreView(View view) {
            ViewParent parent = view.getParent();
            RecyclerView recyclerView = this.mRecyclerView;
            if (parent != recyclerView || recyclerView.indexOfChild(view) == -1) {
                throw new IllegalArgumentException(C1293.m3407(this.mRecyclerView, C1293.m3416("View should be fully attached to be ignored")));
            }
            AbstractC0269 childViewHolderInt = RecyclerView.getChildViewHolderInt(view);
            childViewHolderInt.addFlags(128);
            this.mRecyclerView.mViewInfoStore.m6037(childViewHolderInt);
        }

        public boolean isAttachedToWindow() {
            return this.mIsAttachedToWindow;
        }

        public boolean isAutoMeasureEnabled() {
            return this.mAutoMeasure;
        }

        public boolean isFocused() {
            RecyclerView recyclerView = this.mRecyclerView;
            return recyclerView != null && recyclerView.isFocused();
        }

        public final boolean isItemPrefetchEnabled() {
            return this.mItemPrefetchEnabled;
        }

        public boolean isLayoutHierarchical(C0264 r1, C0248 r2) {
            return false;
        }

        public boolean isMeasurementCacheEnabled() {
            return this.mMeasurementCacheEnabled;
        }

        public boolean isSmoothScrolling() {
            AbstractC0238 r0 = this.mSmoothScroller;
            return r0 != null && r0.isRunning();
        }

        public boolean isViewPartiallyVisible(View view, boolean z, boolean z2) {
            boolean z3 = this.mHorizontalBoundCheck.m6117(view, 24579) && this.mVerticalBoundCheck.m6117(view, 24579);
            return z ? z3 : !z3;
        }

        public void layoutDecorated(View view, int i, int i2, int i3, int i4) {
            Rect rect = ((C0235) view.getLayoutParams()).f1482;
            view.layout(i + rect.left, i2 + rect.top, i3 - rect.right, i4 - rect.bottom);
        }

        public void layoutDecoratedWithMargins(View view, int i, int i2, int i3, int i4) {
            C0235 r0 = (C0235) view.getLayoutParams();
            Rect rect = r0.f1482;
            view.layout(i + rect.left + ((ViewGroup.MarginLayoutParams) r0).leftMargin, i2 + rect.top + ((ViewGroup.MarginLayoutParams) r0).topMargin, (i3 - rect.right) - ((ViewGroup.MarginLayoutParams) r0).rightMargin, (i4 - rect.bottom) - ((ViewGroup.MarginLayoutParams) r0).bottomMargin);
        }

        public void measureChild(View view, int i, int i2) {
            C0235 r0 = (C0235) view.getLayoutParams();
            Rect itemDecorInsetsForChild = this.mRecyclerView.getItemDecorInsetsForChild(view);
            int i3 = itemDecorInsetsForChild.left + itemDecorInsetsForChild.right + i;
            int i4 = itemDecorInsetsForChild.top + itemDecorInsetsForChild.bottom + i2;
            int childMeasureSpec = getChildMeasureSpec(getWidth(), getWidthMode(), getPaddingRight() + getPaddingLeft() + i3, ((ViewGroup.MarginLayoutParams) r0).width, canScrollHorizontally());
            int childMeasureSpec2 = getChildMeasureSpec(getHeight(), getHeightMode(), getPaddingBottom() + getPaddingTop() + i4, ((ViewGroup.MarginLayoutParams) r0).height, canScrollVertically());
            if (shouldMeasureChild(view, childMeasureSpec, childMeasureSpec2, r0)) {
                view.measure(childMeasureSpec, childMeasureSpec2);
            }
        }

        public void measureChildWithMargins(View view, int i, int i2) {
            C0235 r0 = (C0235) view.getLayoutParams();
            Rect itemDecorInsetsForChild = this.mRecyclerView.getItemDecorInsetsForChild(view);
            int i3 = itemDecorInsetsForChild.left + itemDecorInsetsForChild.right + i;
            int i4 = itemDecorInsetsForChild.top + itemDecorInsetsForChild.bottom + i2;
            int childMeasureSpec = getChildMeasureSpec(getWidth(), getWidthMode(), getPaddingRight() + getPaddingLeft() + ((ViewGroup.MarginLayoutParams) r0).leftMargin + ((ViewGroup.MarginLayoutParams) r0).rightMargin + i3, ((ViewGroup.MarginLayoutParams) r0).width, canScrollHorizontally());
            int childMeasureSpec2 = getChildMeasureSpec(getHeight(), getHeightMode(), getPaddingBottom() + getPaddingTop() + ((ViewGroup.MarginLayoutParams) r0).topMargin + ((ViewGroup.MarginLayoutParams) r0).bottomMargin + i4, ((ViewGroup.MarginLayoutParams) r0).height, canScrollVertically());
            if (shouldMeasureChild(view, childMeasureSpec, childMeasureSpec2, r0)) {
                view.measure(childMeasureSpec, childMeasureSpec2);
            }
        }

        public void moveView(int i, int i2) {
            View childAt = getChildAt(i);
            if (childAt != null) {
                detachViewAt(i);
                attachView(childAt, i2);
                return;
            }
            throw new IllegalArgumentException("Cannot move a child from non-existing index:" + i + this.mRecyclerView.toString());
        }

        public void offsetChildrenHorizontal(int i) {
            RecyclerView recyclerView = this.mRecyclerView;
            if (recyclerView != null) {
                recyclerView.offsetChildrenHorizontal(i);
            }
        }

        public void offsetChildrenVertical(int i) {
            RecyclerView recyclerView = this.mRecyclerView;
            if (recyclerView != null) {
                recyclerView.offsetChildrenVertical(i);
            }
        }

        public void onAdapterChanged(AbstractC0246 r1, AbstractC0246 r2) {
        }

        public boolean onAddFocusables(RecyclerView recyclerView, ArrayList<View> arrayList, int i, int i2) {
            return false;
        }

        public void onAttachedToWindow(RecyclerView recyclerView) {
        }

        @Deprecated
        public void onDetachedFromWindow(RecyclerView recyclerView) {
        }

        public void onDetachedFromWindow(RecyclerView recyclerView, C0264 r2) {
            onDetachedFromWindow(recyclerView);
        }

        public View onFocusSearchFailed(View view, int i, C0264 r3, C0248 r4) {
            return null;
        }

        public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
            RecyclerView recyclerView = this.mRecyclerView;
            onInitializeAccessibilityEvent(recyclerView.mRecycler, recyclerView.mState, accessibilityEvent);
        }

        public void onInitializeAccessibilityNodeInfo(C1782 r3) {
            RecyclerView recyclerView = this.mRecyclerView;
            onInitializeAccessibilityNodeInfo(recyclerView.mRecycler, recyclerView.mState, r3);
        }

        public void onInitializeAccessibilityNodeInfoForItem(View view, C1782 r4) {
            AbstractC0269 childViewHolderInt = RecyclerView.getChildViewHolderInt(view);
            if (childViewHolderInt != null && !childViewHolderInt.isRemoved() && !this.mChildHelper.m6051(childViewHolderInt.itemView)) {
                RecyclerView recyclerView = this.mRecyclerView;
                onInitializeAccessibilityNodeInfoForItem(recyclerView.mRecycler, recyclerView.mState, view, r4);
            }
        }

        public View onInterceptFocusSearch(View view, int i) {
            return null;
        }

        public void onItemsAdded(RecyclerView recyclerView, int i, int i2) {
        }

        public void onItemsChanged(RecyclerView recyclerView) {
        }

        public void onItemsMoved(RecyclerView recyclerView, int i, int i2, int i3) {
        }

        public void onItemsRemoved(RecyclerView recyclerView, int i, int i2) {
        }

        public void onItemsUpdated(RecyclerView recyclerView, int i, int i2) {
        }

        public void onItemsUpdated(RecyclerView recyclerView, int i, int i2, Object obj) {
            onItemsUpdated(recyclerView, i, i2);
        }

        public void onLayoutChildren(C0264 r1, C0248 r2) {
            Log.e(RecyclerView.TAG, "You must override onLayoutChildren(Recycler recycler, State state) ");
        }

        public void onLayoutCompleted(C0248 r1) {
        }

        public void onMeasure(C0264 r1, C0248 r2, int i, int i2) {
            this.mRecyclerView.defaultOnMeasure(i, i2);
        }

        @Deprecated
        public boolean onRequestChildFocus(RecyclerView recyclerView, View view, View view2) {
            return isSmoothScrolling() || recyclerView.isComputingLayout();
        }

        public void onRestoreInstanceState(Parcelable parcelable) {
        }

        public Parcelable onSaveInstanceState() {
            return null;
        }

        public void onScrollStateChanged(int i) {
        }

        public void onSmoothScrollerStopped(AbstractC0238 r2) {
            if (this.mSmoothScroller == r2) {
                this.mSmoothScroller = null;
            }
        }

        public boolean performAccessibilityAction(int i, Bundle bundle) {
            RecyclerView recyclerView = this.mRecyclerView;
            return performAccessibilityAction(recyclerView.mRecycler, recyclerView.mState, i, bundle);
        }

        public boolean performAccessibilityActionForItem(View view, int i, Bundle bundle) {
            RecyclerView recyclerView = this.mRecyclerView;
            return performAccessibilityActionForItem(recyclerView.mRecycler, recyclerView.mState, view, i, bundle);
        }

        public boolean performAccessibilityActionForItem(C0264 r1, C0248 r2, View view, int i, Bundle bundle) {
            return false;
        }

        public void postOnAnimation(Runnable runnable) {
            RecyclerView recyclerView = this.mRecyclerView;
            if (recyclerView != null) {
                C1729.m4479(recyclerView, runnable);
            }
        }

        public void removeAllViews() {
            for (int childCount = getChildCount() - 1; childCount >= 0; childCount--) {
                this.mChildHelper.m6048(childCount);
            }
        }

        public void removeAndRecycleAllViews(C0264 r3) {
            for (int childCount = getChildCount() - 1; childCount >= 0; childCount--) {
                if (!RecyclerView.getChildViewHolderInt(getChildAt(childCount)).shouldIgnore()) {
                    removeAndRecycleViewAt(childCount, r3);
                }
            }
        }

        public void removeAndRecycleScrapInt(C0264 r7) {
            int size = r7.f1539.size();
            for (int i = size - 1; i >= 0; i--) {
                View view = r7.f1539.get(i).itemView;
                AbstractC0269 childViewHolderInt = RecyclerView.getChildViewHolderInt(view);
                if (!childViewHolderInt.shouldIgnore()) {
                    childViewHolderInt.setIsRecyclable(false);
                    if (childViewHolderInt.isTmpDetached()) {
                        this.mRecyclerView.removeDetachedView(view, false);
                    }
                    AbstractC0250 r5 = this.mRecyclerView.mItemAnimator;
                    if (r5 != null) {
                        r5.m830(childViewHolderInt);
                    }
                    childViewHolderInt.setIsRecyclable(true);
                    AbstractC0269 childViewHolderInt2 = RecyclerView.getChildViewHolderInt(view);
                    childViewHolderInt2.mScrapContainer = null;
                    childViewHolderInt2.mInChangeScrap = false;
                    childViewHolderInt2.clearReturnedFromScrapFlag();
                    r7.m869(childViewHolderInt2);
                }
            }
            r7.f1539.clear();
            ArrayList<AbstractC0269> arrayList = r7.f1537;
            if (arrayList != null) {
                arrayList.clear();
            }
            if (size > 0) {
                this.mRecyclerView.invalidate();
            }
        }

        public void removeAndRecycleView(View view, C0264 r2) {
            removeView(view);
            r2.m861(view);
        }

        public void removeAndRecycleViewAt(int i, C0264 r3) {
            View childAt = getChildAt(i);
            removeViewAt(i);
            r3.m861(childAt);
        }

        public boolean removeCallbacks(Runnable runnable) {
            RecyclerView recyclerView = this.mRecyclerView;
            if (recyclerView != null) {
                return recyclerView.removeCallbacks(runnable);
            }
            return false;
        }

        public void removeDetachedView(View view) {
            this.mRecyclerView.removeDetachedView(view, false);
        }

        public void removeView(View view) {
            C2316 r0 = this.mChildHelper;
            int indexOfChild = RecyclerView.this.indexOfChild(view);
            if (indexOfChild >= 0) {
                if (r0.f8000.m6065(indexOfChild)) {
                    r0.m6047(view);
                }
                ((C0237) r0.f8001).m813(indexOfChild);
            }
        }

        public void removeViewAt(int i) {
            if (getChildAt(i) != null) {
                this.mChildHelper.m6048(i);
            }
        }

        public boolean requestChildRectangleOnScreen(RecyclerView recyclerView, View view, Rect rect, boolean z) {
            return requestChildRectangleOnScreen(recyclerView, view, rect, z, false);
        }

        public void requestLayout() {
            RecyclerView recyclerView = this.mRecyclerView;
            if (recyclerView != null) {
                recyclerView.requestLayout();
            }
        }

        public void requestSimpleAnimationsInNextLayout() {
            this.mRequestedSimpleAnimations = true;
        }

        public int scrollHorizontallyBy(int i, C0264 r2, C0248 r3) {
            return 0;
        }

        public void scrollToPosition(int i) {
        }

        public int scrollVerticallyBy(int i, C0264 r2, C0248 r3) {
            return 0;
        }

        @Deprecated
        public void setAutoMeasureEnabled(boolean z) {
            this.mAutoMeasure = z;
        }

        public void setExactMeasureSpecsFrom(RecyclerView recyclerView) {
            setMeasureSpecs(View.MeasureSpec.makeMeasureSpec(recyclerView.getWidth(), 1073741824), View.MeasureSpec.makeMeasureSpec(recyclerView.getHeight(), 1073741824));
        }

        public final void setItemPrefetchEnabled(boolean z) {
            if (z != this.mItemPrefetchEnabled) {
                this.mItemPrefetchEnabled = z;
                this.mPrefetchMaxCountObserved = 0;
                RecyclerView recyclerView = this.mRecyclerView;
                if (recyclerView != null) {
                    recyclerView.mRecycler.m871();
                }
            }
        }

        public void setMeasureSpecs(int i, int i2) {
            this.mWidth = View.MeasureSpec.getSize(i);
            this.mWidthMode = View.MeasureSpec.getMode(i);
            if (this.mWidthMode == 0 && !RecyclerView.ALLOW_SIZE_IN_UNSPECIFIED_SPEC) {
                this.mWidth = 0;
            }
            this.mHeight = View.MeasureSpec.getSize(i2);
            this.mHeightMode = View.MeasureSpec.getMode(i2);
            if (this.mHeightMode == 0 && !RecyclerView.ALLOW_SIZE_IN_UNSPECIFIED_SPEC) {
                this.mHeight = 0;
            }
        }

        public void setMeasuredDimension(Rect rect, int i, int i2) {
            setMeasuredDimension(chooseSize(i, getPaddingRight() + getPaddingLeft() + rect.width(), getMinimumWidth()), chooseSize(i2, getPaddingBottom() + getPaddingTop() + rect.height(), getMinimumHeight()));
        }

        public void setMeasuredDimensionFromChildren(int i, int i2) {
            int childCount = getChildCount();
            if (childCount == 0) {
                this.mRecyclerView.defaultOnMeasure(i, i2);
                return;
            }
            int i3 = Integer.MAX_VALUE;
            int i4 = Integer.MAX_VALUE;
            int i5 = Integer.MIN_VALUE;
            int i6 = Integer.MIN_VALUE;
            for (int i7 = 0; i7 < childCount; i7++) {
                View childAt = getChildAt(i7);
                Rect rect = this.mRecyclerView.mTempRect;
                getDecoratedBoundsWithMargins(childAt, rect);
                int i8 = rect.left;
                if (i8 < i3) {
                    i3 = i8;
                }
                int i9 = rect.right;
                if (i9 > i5) {
                    i5 = i9;
                }
                int i10 = rect.top;
                if (i10 < i4) {
                    i4 = i10;
                }
                int i11 = rect.bottom;
                if (i11 > i6) {
                    i6 = i11;
                }
            }
            this.mRecyclerView.mTempRect.set(i3, i4, i5, i6);
            setMeasuredDimension(this.mRecyclerView.mTempRect, i, i2);
        }

        public void setMeasurementCacheEnabled(boolean z) {
            this.mMeasurementCacheEnabled = z;
        }

        public void setRecyclerView(RecyclerView recyclerView) {
            if (recyclerView == null) {
                this.mRecyclerView = null;
                this.mChildHelper = null;
                this.mWidth = 0;
                this.mHeight = 0;
            } else {
                this.mRecyclerView = recyclerView;
                this.mChildHelper = recyclerView.mChildHelper;
                this.mWidth = recyclerView.getWidth();
                this.mHeight = recyclerView.getHeight();
            }
            this.mWidthMode = 1073741824;
            this.mHeightMode = 1073741824;
        }

        public boolean shouldMeasureChild(View view, int i, int i2, C0235 r6) {
            return view.isLayoutRequested() || !this.mMeasurementCacheEnabled || !isMeasurementUpToDate(view.getWidth(), i, ((ViewGroup.MarginLayoutParams) r6).width) || !isMeasurementUpToDate(view.getHeight(), i2, ((ViewGroup.MarginLayoutParams) r6).height);
        }

        public boolean shouldMeasureTwice() {
            return false;
        }

        public boolean shouldReMeasureChild(View view, int i, int i2, C0235 r6) {
            return !this.mMeasurementCacheEnabled || !isMeasurementUpToDate(view.getMeasuredWidth(), i, ((ViewGroup.MarginLayoutParams) r6).width) || !isMeasurementUpToDate(view.getMeasuredHeight(), i2, ((ViewGroup.MarginLayoutParams) r6).height);
        }

        public void smoothScrollToPosition(RecyclerView recyclerView, C0248 r2, int i) {
            Log.e(RecyclerView.TAG, "You must override smoothScrollToPosition to support smooth scrolling");
        }

        public void startSmoothScroll(AbstractC0238 r2) {
            AbstractC0238 r0 = this.mSmoothScroller;
            if (!(r0 == null || r2 == r0 || !r0.isRunning())) {
                this.mSmoothScroller.stop();
            }
            this.mSmoothScroller = r2;
            this.mSmoothScroller.start(this.mRecyclerView, this);
        }

        public void stopIgnoringView(View view) {
            AbstractC0269 childViewHolderInt = RecyclerView.getChildViewHolderInt(view);
            childViewHolderInt.stopIgnoring();
            childViewHolderInt.resetInternal();
            childViewHolderInt.addFlags(4);
        }

        public void stopSmoothScroller() {
            AbstractC0238 r0 = this.mSmoothScroller;
            if (r0 != null) {
                r0.stop();
            }
        }

        public boolean supportsPredictiveItemAnimations() {
            return false;
        }

        public void addDisappearingView(View view, int i) {
            addViewInt(view, i, true);
        }

        public void addView(View view, int i) {
            addViewInt(view, i, false);
        }

        public void onInitializeAccessibilityEvent(C0264 r2, C0248 r3, AccessibilityEvent accessibilityEvent) {
            RecyclerView recyclerView = this.mRecyclerView;
            if (recyclerView != null && accessibilityEvent != null) {
                boolean z = true;
                if (!recyclerView.canScrollVertically(1) && !this.mRecyclerView.canScrollVertically(-1) && !this.mRecyclerView.canScrollHorizontally(-1) && !this.mRecyclerView.canScrollHorizontally(1)) {
                    z = false;
                }
                accessibilityEvent.setScrollable(z);
                AbstractC0246 r22 = this.mRecyclerView.mAdapter;
                if (r22 != null) {
                    accessibilityEvent.setItemCount(r22.getItemCount());
                }
            }
        }

        public void onInitializeAccessibilityNodeInfo(C0264 r4, C0248 r5, C1782 r6) {
            if (this.mRecyclerView.canScrollVertically(-1) || this.mRecyclerView.canScrollHorizontally(-1)) {
                r6.f6124.addAction(8192);
                r6.f6124.setScrollable(true);
            }
            if (this.mRecyclerView.canScrollVertically(1) || this.mRecyclerView.canScrollHorizontally(1)) {
                r6.f6124.addAction(AbstractC0269.FLAG_APPEARED_IN_PRE_LAYOUT);
                r6.f6124.setScrollable(true);
            }
            r6.m4663(C1782.C1784.m4673(getRowCountForAccessibility(r4, r5), getColumnCountForAccessibility(r4, r5), isLayoutHierarchical(r4, r5), getSelectionModeForAccessibility(r4, r5)));
        }

        public boolean onRequestChildFocus(RecyclerView recyclerView, C0248 r2, View view, View view2) {
            return onRequestChildFocus(recyclerView, view, view2);
        }

        /* JADX WARNING: Removed duplicated region for block: B:25:0x0075 A[ADDED_TO_REGION] */
        public boolean performAccessibilityAction(C0264 r8, C0248 r9, int i, Bundle bundle) {
            int i2;
            int i3;
            int i4;
            int i5;
            RecyclerView recyclerView = this.mRecyclerView;
            if (recyclerView == null) {
                return false;
            }
            if (i == 4096) {
                i4 = recyclerView.canScrollVertically(1) ? (getHeight() - getPaddingTop()) - getPaddingBottom() : 0;
                if (this.mRecyclerView.canScrollHorizontally(1)) {
                    i5 = (getWidth() - getPaddingLeft()) - getPaddingRight();
                }
                i2 = i4;
                i3 = 0;
                if (i2 != 0) {
                }
                this.mRecyclerView.smoothScrollBy(i3, i2, null, Integer.MIN_VALUE, true);
                return true;
            } else if (i != 8192) {
                i3 = 0;
                i2 = 0;
                if (i2 != 0 && i3 == 0) {
                    return false;
                }
                this.mRecyclerView.smoothScrollBy(i3, i2, null, Integer.MIN_VALUE, true);
                return true;
            } else {
                i4 = recyclerView.canScrollVertically(-1) ? -((getHeight() - getPaddingTop()) - getPaddingBottom()) : 0;
                if (this.mRecyclerView.canScrollHorizontally(-1)) {
                    i5 = -((getWidth() - getPaddingLeft()) - getPaddingRight());
                }
                i2 = i4;
                i3 = 0;
                if (i2 != 0) {
                }
                this.mRecyclerView.smoothScrollBy(i3, i2, null, Integer.MIN_VALUE, true);
                return true;
            }
            i2 = i4;
            i3 = i5;
            if (i2 != 0) {
            }
            this.mRecyclerView.smoothScrollBy(i3, i2, null, Integer.MIN_VALUE, true);
            return true;
        }

        public boolean requestChildRectangleOnScreen(RecyclerView recyclerView, View view, Rect rect, boolean z, boolean z2) {
            int[] childRectangleOnScreenScrollAmount = getChildRectangleOnScreenScrollAmount(view, rect);
            int i = childRectangleOnScreenScrollAmount[0];
            int i2 = childRectangleOnScreenScrollAmount[1];
            if ((z2 && !isFocusedChildVisibleAfterScrolling(recyclerView, i, i2)) || (i == 0 && i2 == 0)) {
                return false;
            }
            if (z) {
                recyclerView.scrollBy(i, i2);
            } else {
                recyclerView.smoothScrollBy(i, i2);
            }
            return true;
        }

        public static int getChildMeasureSpec(int i, int i2, int i3, int i4, boolean z) {
            int i5;
            int i6 = i - i3;
            int i7 = 0;
            int max = Math.max(0, i6);
            if (z) {
                if (i4 < 0) {
                    if (i4 == -1) {
                        if (i2 == Integer.MIN_VALUE || (i2 != 0 && i2 == 1073741824)) {
                            i5 = max;
                        } else {
                            i2 = 0;
                            i5 = 0;
                        }
                        i7 = i2;
                        max = i5;
                        return View.MeasureSpec.makeMeasureSpec(max, i7);
                    }
                    max = 0;
                    return View.MeasureSpec.makeMeasureSpec(max, i7);
                }
            } else if (i4 < 0) {
                if (i4 == -1) {
                    i7 = i2;
                } else {
                    if (i4 == -2) {
                        if (i2 == Integer.MIN_VALUE || i2 == 1073741824) {
                            i7 = Integer.MIN_VALUE;
                        }
                    }
                    max = 0;
                }
                return View.MeasureSpec.makeMeasureSpec(max, i7);
            }
            max = i4;
            i7 = 1073741824;
            return View.MeasureSpec.makeMeasureSpec(max, i7);
        }

        public void onInitializeAccessibilityNodeInfoForItem(C0264 r7, C0248 r8, View view, C1782 r10) {
            r10.m4654(C1782.C1783.m4672(canScrollVertically() ? getPosition(view) : 0, 1, canScrollHorizontally() ? getPosition(view) : 0, 1, false, false));
        }

        public void attachView(View view, int i) {
            attachView(view, i, (C0235) view.getLayoutParams());
        }

        public C0235 generateLayoutParams(Context context, AttributeSet attributeSet) {
            return new C0235(context, attributeSet);
        }

        public void setMeasuredDimension(int i, int i2) {
            this.mRecyclerView.setMeasuredDimension(i, i2);
        }

        public void attachView(View view) {
            attachView(view, -1);
        }
    }

    /* renamed from: androidx.recyclerview.widget.RecyclerView$㗽  reason: contains not printable characters */
    public static abstract class AbstractC0259 {
    }

    /* renamed from: androidx.recyclerview.widget.RecyclerView$㳳  reason: contains not printable characters */
    public interface AbstractC0261 {
    }

    /* renamed from: androidx.recyclerview.widget.RecyclerView$㴪  reason: contains not printable characters */
    public class C0262 extends AbstractC0244 {
        public C0262() {
        }

        @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0244
        public void onChanged() {
            RecyclerView.this.assertNotInLayoutOrScroll(null);
            RecyclerView recyclerView = RecyclerView.this;
            recyclerView.mState.f1503 = true;
            recyclerView.processDataSetCompletelyChanged(true);
            if (!RecyclerView.this.mAdapterHelper.m6080()) {
                RecyclerView.this.requestLayout();
            }
        }

        @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0244
        public void onItemRangeChanged(int i, int i2, Object obj) {
            RecyclerView.this.assertNotInLayoutOrScroll(null);
            if (RecyclerView.this.mAdapterHelper.m6093(i, i2, obj)) {
                m853();
            }
        }

        @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0244
        public void onItemRangeInserted(int i, int i2) {
            RecyclerView.this.assertNotInLayoutOrScroll(null);
            if (RecyclerView.this.mAdapterHelper.m6084(i, i2)) {
                m853();
            }
        }

        @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0244
        public void onItemRangeMoved(int i, int i2, int i3) {
            RecyclerView.this.assertNotInLayoutOrScroll(null);
            if (RecyclerView.this.mAdapterHelper.m6092(i, i2, i3)) {
                m853();
            }
        }

        @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0244
        public void onItemRangeRemoved(int i, int i2) {
            RecyclerView.this.assertNotInLayoutOrScroll(null);
            if (RecyclerView.this.mAdapterHelper.m6081(i, i2)) {
                m853();
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m853() {
            if (RecyclerView.POST_UPDATES_ON_ANIMATION) {
                RecyclerView recyclerView = RecyclerView.this;
                if (recyclerView.mHasFixedSize && recyclerView.mIsAttached) {
                    C1729.m4479(recyclerView, recyclerView.mUpdateChildViewsRunnable);
                    return;
                }
            }
            RecyclerView recyclerView2 = RecyclerView.this;
            recyclerView2.mAdapterUpdateDuringMeasure = true;
            recyclerView2.requestLayout();
        }
    }

    /* renamed from: androidx.recyclerview.widget.RecyclerView$㸾  reason: contains not printable characters */
    public class C0265 implements C2307.AbstractC2308 {
        public C0265() {
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m872(AbstractC0269 r3, AbstractC0250.C0251 r4, AbstractC0250.C0251 r5) {
            r3.setIsRecyclable(false);
            RecyclerView recyclerView = RecyclerView.this;
            if (recyclerView.mDataSetHasChangedAfterLayout) {
                if (recyclerView.mItemAnimator.m835(r3, r3, r4, r5)) {
                    RecyclerView.this.postAnimationRunner();
                }
            } else if (recyclerView.mItemAnimator.m827(r3, r4, r5)) {
                RecyclerView.this.postAnimationRunner();
            }
        }
    }

    /* renamed from: androidx.recyclerview.widget.RecyclerView$㿎  reason: contains not printable characters */
    public static class C0266 extends Observable<AbstractC0244> {
        /* renamed from: ʬ  reason: contains not printable characters */
        public void m873(int i, int i2) {
            for (int size = ((Observable) this).mObservers.size() - 1; size >= 0; size--) {
                ((AbstractC0244) ((Observable) this).mObservers.get(size)).onItemRangeRemoved(i, i2);
            }
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public void m874() {
            for (int size = ((Observable) this).mObservers.size() - 1; size >= 0; size--) {
                ((AbstractC0244) ((Observable) this).mObservers.get(size)).onChanged();
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public boolean m878() {
            return !((Observable) this).mObservers.isEmpty();
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m877(int i, int i2, Object obj) {
            for (int size = ((Observable) this).mObservers.size() - 1; size >= 0; size--) {
                ((AbstractC0244) ((Observable) this).mObservers.get(size)).onItemRangeChanged(i, i2, obj);
            }
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public void m875(int i, int i2) {
            for (int size = ((Observable) this).mObservers.size() - 1; size >= 0; size--) {
                ((AbstractC0244) ((Observable) this).mObservers.get(size)).onItemRangeInserted(i, i2);
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m876(int i, int i2) {
            for (int size = ((Observable) this).mObservers.size() - 1; size >= 0; size--) {
                ((AbstractC0244) ((Observable) this).mObservers.get(size)).onItemRangeMoved(i, i2, 1);
            }
        }
    }

    /* renamed from: androidx.recyclerview.widget.RecyclerView$䀟  reason: contains not printable characters */
    public static abstract class AbstractC0267 {
        public void onScrollStateChanged(RecyclerView recyclerView, int i) {
        }

        public void onScrolled(RecyclerView recyclerView, int i, int i2) {
        }
    }

    /* renamed from: androidx.recyclerview.widget.RecyclerView$䁗  reason: contains not printable characters */
    public class C0268 implements AbstractC0250.AbstractC0252 {
        public C0268() {
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m879(AbstractC0269 r3) {
            r3.setIsRecyclable(true);
            if (r3.mShadowedHolder != null && r3.mShadowingHolder == null) {
                r3.mShadowedHolder = null;
            }
            r3.mShadowingHolder = null;
            if (!r3.shouldBeKeptAsChild() && !RecyclerView.this.removeAnimatingView(r3.itemView) && r3.isTmpDetached()) {
                RecyclerView.this.removeDetachedView(r3.itemView, false);
            }
        }
    }

    /* renamed from: androidx.recyclerview.widget.RecyclerView$䃖  reason: contains not printable characters */
    public static abstract class AbstractC0269 {
        public static final int FLAG_ADAPTER_FULLUPDATE = 1024;
        public static final int FLAG_ADAPTER_POSITION_UNKNOWN = 512;
        public static final int FLAG_APPEARED_IN_PRE_LAYOUT = 4096;
        public static final int FLAG_BOUNCED_FROM_HIDDEN_LIST = 8192;
        public static final int FLAG_BOUND = 1;
        public static final int FLAG_IGNORE = 128;
        public static final int FLAG_INVALID = 4;
        public static final int FLAG_MOVED = 2048;
        public static final int FLAG_NOT_RECYCLABLE = 16;
        public static final int FLAG_REMOVED = 8;
        public static final int FLAG_RETURNED_FROM_SCRAP = 32;
        public static final int FLAG_TMP_DETACHED = 256;
        public static final int FLAG_UPDATE = 2;
        public static final List<Object> FULLUPDATE_PAYLOADS = Collections.emptyList();
        public static final int PENDING_ACCESSIBILITY_STATE_NOT_SET = -1;
        public final View itemView;
        public int mFlags;
        public boolean mInChangeScrap = false;
        public int mIsRecyclableCount = 0;
        public long mItemId = -1;
        public int mItemViewType = -1;
        public WeakReference<RecyclerView> mNestedRecyclerView;
        public int mOldPosition = -1;
        public RecyclerView mOwnerRecyclerView;
        public List<Object> mPayloads = null;
        public int mPendingAccessibilityState = -1;
        public int mPosition = -1;
        public int mPreLayoutPosition = -1;
        public C0264 mScrapContainer = null;
        public AbstractC0269 mShadowedHolder = null;
        public AbstractC0269 mShadowingHolder = null;
        public List<Object> mUnmodifiedPayloads = null;
        public int mWasImportantForAccessibilityBeforeHidden = 0;

        public AbstractC0269(View view) {
            if (view != null) {
                this.itemView = view;
                return;
            }
            throw new IllegalArgumentException("itemView may not be null");
        }

        private void createPayloadsIfNeeded() {
            if (this.mPayloads == null) {
                this.mPayloads = new ArrayList();
                this.mUnmodifiedPayloads = Collections.unmodifiableList(this.mPayloads);
            }
        }

        public void addChangePayload(Object obj) {
            if (obj == null) {
                addFlags(FLAG_ADAPTER_FULLUPDATE);
            } else if ((1024 & this.mFlags) == 0) {
                createPayloadsIfNeeded();
                this.mPayloads.add(obj);
            }
        }

        public void addFlags(int i) {
            this.mFlags = i | this.mFlags;
        }

        public void clearOldPosition() {
            this.mOldPosition = -1;
            this.mPreLayoutPosition = -1;
        }

        public void clearPayload() {
            List<Object> list = this.mPayloads;
            if (list != null) {
                list.clear();
            }
            this.mFlags &= -1025;
        }

        public void clearReturnedFromScrapFlag() {
            this.mFlags &= -33;
        }

        public void clearTmpDetachFlag() {
            this.mFlags &= -257;
        }

        public boolean doesTransientStatePreventRecycling() {
            return (this.mFlags & 16) == 0 && C1729.m4494(this.itemView);
        }

        public void flagRemovedAndOffsetPosition(int i, int i2, boolean z) {
            addFlags(8);
            offsetPosition(i2, z);
            this.mPosition = i;
        }

        public final int getAdapterPosition() {
            RecyclerView recyclerView = this.mOwnerRecyclerView;
            if (recyclerView == null) {
                return -1;
            }
            return recyclerView.getAdapterPositionFor(this);
        }

        public final long getItemId() {
            return this.mItemId;
        }

        public final int getItemViewType() {
            return this.mItemViewType;
        }

        public final int getLayoutPosition() {
            int i = this.mPreLayoutPosition;
            return i == -1 ? this.mPosition : i;
        }

        public final int getOldPosition() {
            return this.mOldPosition;
        }

        @Deprecated
        public final int getPosition() {
            int i = this.mPreLayoutPosition;
            return i == -1 ? this.mPosition : i;
        }

        public List<Object> getUnmodifiedPayloads() {
            if ((this.mFlags & FLAG_ADAPTER_FULLUPDATE) != 0) {
                return FULLUPDATE_PAYLOADS;
            }
            List<Object> list = this.mPayloads;
            if (list == null || list.size() == 0) {
                return FULLUPDATE_PAYLOADS;
            }
            return this.mUnmodifiedPayloads;
        }

        public boolean hasAnyOfTheFlags(int i) {
            return (i & this.mFlags) != 0;
        }

        public boolean isAdapterPositionUnknown() {
            return (this.mFlags & 512) != 0 || isInvalid();
        }

        public boolean isAttachedToTransitionOverlay() {
            return (this.itemView.getParent() == null || this.itemView.getParent() == this.mOwnerRecyclerView) ? false : true;
        }

        public boolean isBound() {
            return (this.mFlags & 1) != 0;
        }

        public boolean isInvalid() {
            return (this.mFlags & 4) != 0;
        }

        public final boolean isRecyclable() {
            return (this.mFlags & 16) == 0 && !C1729.m4494(this.itemView);
        }

        public boolean isRemoved() {
            return (this.mFlags & 8) != 0;
        }

        public boolean isScrap() {
            return this.mScrapContainer != null;
        }

        public boolean isTmpDetached() {
            return (this.mFlags & 256) != 0;
        }

        public boolean isUpdated() {
            return (this.mFlags & 2) != 0;
        }

        public boolean needsUpdate() {
            return (this.mFlags & 2) != 0;
        }

        public void offsetPosition(int i, boolean z) {
            if (this.mOldPosition == -1) {
                this.mOldPosition = this.mPosition;
            }
            if (this.mPreLayoutPosition == -1) {
                this.mPreLayoutPosition = this.mPosition;
            }
            if (z) {
                this.mPreLayoutPosition += i;
            }
            this.mPosition += i;
            if (this.itemView.getLayoutParams() != null) {
                ((C0235) this.itemView.getLayoutParams()).f1481 = true;
            }
        }

        public void onEnteredHiddenState(RecyclerView recyclerView) {
            int i = this.mPendingAccessibilityState;
            if (i != -1) {
                this.mWasImportantForAccessibilityBeforeHidden = i;
            } else {
                this.mWasImportantForAccessibilityBeforeHidden = C1729.m4454(this.itemView);
            }
            recyclerView.setChildImportantForAccessibilityInternal(this, 4);
        }

        public void onLeftHiddenState(RecyclerView recyclerView) {
            recyclerView.setChildImportantForAccessibilityInternal(this, this.mWasImportantForAccessibilityBeforeHidden);
            this.mWasImportantForAccessibilityBeforeHidden = 0;
        }

        public void resetInternal() {
            this.mFlags = 0;
            this.mPosition = -1;
            this.mOldPosition = -1;
            this.mItemId = -1;
            this.mPreLayoutPosition = -1;
            this.mIsRecyclableCount = 0;
            this.mShadowedHolder = null;
            this.mShadowingHolder = null;
            clearPayload();
            this.mWasImportantForAccessibilityBeforeHidden = 0;
            this.mPendingAccessibilityState = -1;
            RecyclerView.clearNestedRecyclerViewIfNotNested(this);
        }

        public void saveOldPosition() {
            if (this.mOldPosition == -1) {
                this.mOldPosition = this.mPosition;
            }
        }

        public void setFlags(int i, int i2) {
            this.mFlags = (i & i2) | (this.mFlags & (~i2));
        }

        public final void setIsRecyclable(boolean z) {
            int i = this.mIsRecyclableCount;
            this.mIsRecyclableCount = z ? i - 1 : i + 1;
            int i2 = this.mIsRecyclableCount;
            if (i2 < 0) {
                this.mIsRecyclableCount = 0;
                Log.e("View", "isRecyclable decremented below 0: unmatched pair of setIsRecyable() calls for " + this);
            } else if (!z && i2 == 1) {
                this.mFlags |= 16;
            } else if (z && this.mIsRecyclableCount == 0) {
                this.mFlags &= -17;
            }
        }

        public void setScrapContainer(C0264 r1, boolean z) {
            this.mScrapContainer = r1;
            this.mInChangeScrap = z;
        }

        public boolean shouldBeKeptAsChild() {
            return (this.mFlags & 16) != 0;
        }

        public boolean shouldIgnore() {
            return (this.mFlags & 128) != 0;
        }

        public void stopIgnoring() {
            this.mFlags &= -129;
        }

        public String toString() {
            StringBuilder r0 = C1293.m3402(getClass().isAnonymousClass() ? "ViewHolder" : getClass().getSimpleName(), "{");
            r0.append(Integer.toHexString(hashCode()));
            r0.append(" position=");
            r0.append(this.mPosition);
            r0.append(" id=");
            r0.append(this.mItemId);
            r0.append(", oldPos=");
            r0.append(this.mOldPosition);
            r0.append(", pLpos:");
            r0.append(this.mPreLayoutPosition);
            StringBuilder sb = new StringBuilder(r0.toString());
            if (isScrap()) {
                sb.append(" scrap ");
                sb.append(this.mInChangeScrap ? "[changeScrap]" : "[attachedScrap]");
            }
            if (isInvalid()) {
                sb.append(" invalid");
            }
            if (!isBound()) {
                sb.append(" unbound");
            }
            if (needsUpdate()) {
                sb.append(" update");
            }
            if (isRemoved()) {
                sb.append(" removed");
            }
            if (shouldIgnore()) {
                sb.append(" ignored");
            }
            if (isTmpDetached()) {
                sb.append(" tmpDetached");
            }
            if (!isRecyclable()) {
                StringBuilder r02 = C1293.m3416(" not recyclable(");
                r02.append(this.mIsRecyclableCount);
                r02.append(")");
                sb.append(r02.toString());
            }
            if (isAdapterPositionUnknown()) {
                sb.append(" undefined adapter position");
            }
            if (this.itemView.getParent() == null) {
                sb.append(" no parent");
            }
            sb.append("}");
            return sb.toString();
        }

        public void unScrap() {
            this.mScrapContainer.m862(this);
        }

        public boolean wasReturnedFromScrap() {
            return (this.mFlags & 32) != 0;
        }
    }

    static {
        int i = Build.VERSION.SDK_INT;
        ALLOW_SIZE_IN_UNSPECIFIED_SPEC = i >= 23;
        int i2 = Build.VERSION.SDK_INT;
        Class<?> cls = Integer.TYPE;
        LAYOUT_MANAGER_CONSTRUCTOR_SIGNATURE = new Class[]{Context.class, AttributeSet.class, cls, cls};
    }

    public RecyclerView(Context context) {
        this(context, null);
    }

    private void addAnimatingView(AbstractC0269 r6) {
        View view = r6.itemView;
        boolean z = view.getParent() == this;
        this.mRecycler.m862(getChildViewHolder(view));
        if (r6.isTmpDetached()) {
            this.mChildHelper.m6055(view, -1, view.getLayoutParams(), true);
        } else if (!z) {
            this.mChildHelper.m6056(view, -1, true);
        } else {
            C2316 r62 = this.mChildHelper;
            int indexOfChild = RecyclerView.this.indexOfChild(view);
            if (indexOfChild >= 0) {
                r62.f8000.m6059(indexOfChild);
                r62.f7999.add(view);
                ((C0237) r62.f8001).m814(view);
                return;
            }
            throw new IllegalArgumentException("view is not a child, cannot hide " + view);
        }
    }

    private void animateChange(AbstractC0269 r2, AbstractC0269 r3, AbstractC0250.C0251 r4, AbstractC0250.C0251 r5, boolean z, boolean z2) {
        r2.setIsRecyclable(false);
        if (z) {
            addAnimatingView(r2);
        }
        if (r2 != r3) {
            if (z2) {
                addAnimatingView(r3);
            }
            r2.mShadowedHolder = r3;
            addAnimatingView(r2);
            this.mRecycler.m862(r2);
            r3.setIsRecyclable(false);
            r3.mShadowingHolder = r2;
        }
        if (this.mItemAnimator.m835(r2, r3, r4, r5)) {
            postAnimationRunner();
        }
    }

    private void cancelScroll() {
        resetScroll();
        setScrollState(0);
    }

    public static void clearNestedRecyclerViewIfNotNested(AbstractC0269 r3) {
        WeakReference<RecyclerView> weakReference = r3.mNestedRecyclerView;
        if (weakReference != null) {
            RecyclerView recyclerView = weakReference.get();
            while (recyclerView != null) {
                if (recyclerView != r3.itemView) {
                    ViewParent parent = recyclerView.getParent();
                    recyclerView = parent instanceof View ? (View) parent : null;
                } else {
                    return;
                }
            }
            r3.mNestedRecyclerView = null;
        }
    }

    private void createLayoutManager(Context context, String str, AttributeSet attributeSet, int i, int i2) {
        ClassLoader classLoader;
        Constructor<? extends U> constructor;
        if (str != null) {
            String trim = str.trim();
            if (!trim.isEmpty()) {
                String fullClassName = getFullClassName(context, trim);
                try {
                    if (isInEditMode()) {
                        classLoader = getClass().getClassLoader();
                    } else {
                        classLoader = context.getClassLoader();
                    }
                    Class<? extends U> asSubclass = Class.forName(fullClassName, false, classLoader).asSubclass(AbstractC0254.class);
                    Object[] objArr = null;
                    try {
                        constructor = asSubclass.getConstructor(LAYOUT_MANAGER_CONSTRUCTOR_SIGNATURE);
                        objArr = new Object[]{context, attributeSet, Integer.valueOf(i), Integer.valueOf(i2)};
                    } catch (NoSuchMethodException e) {
                        try {
                            constructor = asSubclass.getConstructor(new Class[0]);
                        } catch (NoSuchMethodException e2) {
                            e2.initCause(e);
                            throw new IllegalStateException(attributeSet.getPositionDescription() + ": Error creating LayoutManager " + fullClassName, e2);
                        }
                    }
                    constructor.setAccessible(true);
                    setLayoutManager((AbstractC0254) constructor.newInstance(objArr));
                } catch (ClassNotFoundException e3) {
                    throw new IllegalStateException(attributeSet.getPositionDescription() + ": Unable to find LayoutManager " + fullClassName, e3);
                } catch (InvocationTargetException e4) {
                    throw new IllegalStateException(attributeSet.getPositionDescription() + ": Could not instantiate the LayoutManager: " + fullClassName, e4);
                } catch (InstantiationException e5) {
                    throw new IllegalStateException(attributeSet.getPositionDescription() + ": Could not instantiate the LayoutManager: " + fullClassName, e5);
                } catch (IllegalAccessException e6) {
                    throw new IllegalStateException(attributeSet.getPositionDescription() + ": Cannot access non-public constructor " + fullClassName, e6);
                } catch (ClassCastException e7) {
                    throw new IllegalStateException(attributeSet.getPositionDescription() + ": Class is not a LayoutManager " + fullClassName, e7);
                }
            }
        }
    }

    private boolean didChildRangeChange(int i, int i2) {
        findMinMaxChildLayoutPositions(this.mMinMaxLayoutPositions);
        int[] iArr = this.mMinMaxLayoutPositions;
        return (iArr[0] == i && iArr[1] == i2) ? false : true;
    }

    private void dispatchContentChangedIfNecessary() {
        int i = this.mEatenAccessibilityChangeFlags;
        this.mEatenAccessibilityChangeFlags = 0;
        if (i != 0 && isAccessibilityEnabled()) {
            AccessibilityEvent obtain = AccessibilityEvent.obtain();
            obtain.setEventType(AbstractC0269.FLAG_MOVED);
            int i2 = Build.VERSION.SDK_INT;
            obtain.setContentChangeTypes(i);
            sendAccessibilityEventUnchecked(obtain);
        }
    }

    private void dispatchLayoutStep1() {
        this.mState.m824(1);
        fillRemainingScrollValues(this.mState);
        this.mState.f1507 = false;
        startInterceptRequestLayout();
        C2307 r0 = this.mViewInfoStore;
        r0.f7969.clear();
        r0.f7968.m5919();
        onEnterLayoutOrScroll();
        processAdapterUpdatesAndSetAnimationFlags();
        saveFocusInfo();
        C0248 r02 = this.mState;
        r02.f1501 = r02.f1500 && this.mItemsChanged;
        this.mItemsChanged = false;
        this.mItemsAddedOrRemoved = false;
        C0248 r03 = this.mState;
        r03.f1510 = r03.f1505;
        r03.f1508 = this.mAdapter.getItemCount();
        findMinMaxChildLayoutPositions(this.mMinMaxLayoutPositions);
        if (this.mState.f1500) {
            int r04 = this.mChildHelper.m6052();
            for (int i = 0; i < r04; i++) {
                AbstractC0269 childViewHolderInt = getChildViewHolderInt(this.mChildHelper.m6050(i));
                if (!childViewHolderInt.shouldIgnore() && (!childViewHolderInt.isInvalid() || this.mAdapter.hasStableIds())) {
                    AbstractC0250 r5 = this.mItemAnimator;
                    AbstractC0250.m825(childViewHolderInt);
                    childViewHolderInt.getUnmodifiedPayloads();
                    AbstractC0250.C0251 r52 = r5.m828();
                    View view = childViewHolderInt.itemView;
                    r52.f1519 = view.getLeft();
                    r52.f1518 = view.getTop();
                    view.getRight();
                    view.getBottom();
                    this.mViewInfoStore.m6031(childViewHolderInt, r52);
                    if (this.mState.f1501 && childViewHolderInt.isUpdated() && !childViewHolderInt.isRemoved() && !childViewHolderInt.shouldIgnore() && !childViewHolderInt.isInvalid()) {
                        this.mViewInfoStore.f7968.m5914(getChangedHolderKey(childViewHolderInt), childViewHolderInt);
                    }
                }
            }
        }
        if (this.mState.f1505) {
            saveOldPositions();
            C0248 r05 = this.mState;
            boolean z = r05.f1503;
            r05.f1503 = false;
            this.mLayout.onLayoutChildren(this.mRecycler, r05);
            this.mState.f1503 = z;
            for (int i2 = 0; i2 < this.mChildHelper.m6052(); i2++) {
                AbstractC0269 childViewHolderInt2 = getChildViewHolderInt(this.mChildHelper.m6050(i2));
                if (!childViewHolderInt2.shouldIgnore()) {
                    C2307.C2309 orDefault = this.mViewInfoStore.f7969.getOrDefault(childViewHolderInt2, null);
                    if (!((orDefault == null || (orDefault.f7973 & 4) == 0) ? false : true)) {
                        AbstractC0250.m825(childViewHolderInt2);
                        boolean hasAnyOfTheFlags = childViewHolderInt2.hasAnyOfTheFlags(8192);
                        AbstractC0250 r7 = this.mItemAnimator;
                        childViewHolderInt2.getUnmodifiedPayloads();
                        AbstractC0250.C0251 r72 = r7.m828();
                        View view2 = childViewHolderInt2.itemView;
                        r72.f1519 = view2.getLeft();
                        r72.f1518 = view2.getTop();
                        view2.getRight();
                        view2.getBottom();
                        if (hasAnyOfTheFlags) {
                            recordAnimationInfoIfBouncedHiddenView(childViewHolderInt2, r72);
                        } else {
                            C2307 r53 = this.mViewInfoStore;
                            C2307.C2309 orDefault2 = r53.f7969.getOrDefault(childViewHolderInt2, null);
                            if (orDefault2 == null) {
                                orDefault2 = C2307.C2309.m6038();
                                r53.f7969.put(childViewHolderInt2, orDefault2);
                            }
                            orDefault2.f7973 |= 2;
                            orDefault2.f7972 = r72;
                        }
                    }
                }
            }
            clearOldPositions();
        } else {
            clearOldPositions();
        }
        onExitLayoutOrScroll();
        stopInterceptRequestLayout(false);
        this.mState.f1498 = 2;
    }

    private void dispatchLayoutStep2() {
        startInterceptRequestLayout();
        onEnterLayoutOrScroll();
        this.mState.m824(6);
        this.mAdapterHelper.m6082();
        this.mState.f1508 = this.mAdapter.getItemCount();
        C0248 r0 = this.mState;
        r0.f1509 = 0;
        r0.f1510 = false;
        this.mLayout.onLayoutChildren(this.mRecycler, r0);
        C0248 r02 = this.mState;
        r02.f1503 = false;
        this.mPendingSavedState = null;
        r02.f1500 = r02.f1500 && this.mItemAnimator != null;
        this.mState.f1498 = 4;
        onExitLayoutOrScroll();
        stopInterceptRequestLayout(false);
    }

    private void dispatchLayoutStep3() {
        this.mState.m824(4);
        startInterceptRequestLayout();
        onEnterLayoutOrScroll();
        C0248 r0 = this.mState;
        r0.f1498 = 1;
        if (r0.f1500) {
            for (int r02 = this.mChildHelper.m6052() - 1; r02 >= 0; r02--) {
                AbstractC0269 childViewHolderInt = getChildViewHolderInt(this.mChildHelper.m6050(r02));
                if (!childViewHolderInt.shouldIgnore()) {
                    long changedHolderKey = getChangedHolderKey(childViewHolderInt);
                    AbstractC0250.C0251 r6 = this.mItemAnimator.m828();
                    View view = childViewHolderInt.itemView;
                    r6.f1519 = view.getLeft();
                    r6.f1518 = view.getTop();
                    view.getRight();
                    view.getBottom();
                    AbstractC0269 r3 = this.mViewInfoStore.f7968.m5915(changedHolderKey, null);
                    if (r3 == null || r3.shouldIgnore()) {
                        this.mViewInfoStore.m6036(childViewHolderInt, r6);
                    } else {
                        boolean r10 = this.mViewInfoStore.m6032(r3);
                        boolean r11 = this.mViewInfoStore.m6032(childViewHolderInt);
                        if (!r10 || r3 != childViewHolderInt) {
                            AbstractC0250.C0251 r8 = this.mViewInfoStore.m6033(r3, 4);
                            this.mViewInfoStore.m6036(childViewHolderInt, r6);
                            AbstractC0250.C0251 r9 = this.mViewInfoStore.m6033(childViewHolderInt, 8);
                            if (r8 == null) {
                                handleMissingPreInfoForChangeError(changedHolderKey, childViewHolderInt, r3);
                            } else {
                                animateChange(r3, childViewHolderInt, r8, r9, r10, r11);
                            }
                        } else {
                            this.mViewInfoStore.m6036(childViewHolderInt, r6);
                        }
                    }
                }
            }
            C2307 r03 = this.mViewInfoStore;
            C2307.AbstractC2308 r1 = this.mViewInfoProcessCallback;
            int i = r03.f7969.f7909;
            while (true) {
                i--;
                if (i < 0) {
                    break;
                }
                AbstractC0269 r5 = r03.f7969.m5972(i);
                C2307.C2309 r62 = r03.f7969.m5982(i);
                int i2 = r62.f7973;
                if ((i2 & 3) == 3) {
                    RecyclerView recyclerView = RecyclerView.this;
                    recyclerView.mLayout.removeAndRecycleView(r5.itemView, recyclerView.mRecycler);
                } else if ((i2 & 1) != 0) {
                    AbstractC0250.C0251 r7 = r62.f7972;
                    if (r7 == null) {
                        RecyclerView recyclerView2 = RecyclerView.this;
                        recyclerView2.mLayout.removeAndRecycleView(r5.itemView, recyclerView2.mRecycler);
                    } else {
                        AbstractC0250.C0251 r82 = r62.f7971;
                        C0265 r92 = (C0265) r1;
                        RecyclerView.this.mRecycler.m862(r5);
                        RecyclerView.this.animateDisappearance(r5, r7, r82);
                    }
                } else if ((i2 & 14) == 14) {
                    RecyclerView.this.animateAppearance(r5, r62.f7972, r62.f7971);
                } else if ((i2 & 12) == 12) {
                    ((C0265) r1).m872(r5, r62.f7972, r62.f7971);
                } else if ((i2 & 4) != 0) {
                    AbstractC0250.C0251 r72 = r62.f7972;
                    C0265 r83 = (C0265) r1;
                    RecyclerView.this.mRecycler.m862(r5);
                    RecyclerView.this.animateDisappearance(r5, r72, null);
                } else if ((i2 & 8) != 0) {
                    RecyclerView.this.animateAppearance(r5, r62.f7972, r62.f7971);
                }
                C2307.C2309.m6039(r62);
            }
        }
        this.mLayout.removeAndRecycleScrapInt(this.mRecycler);
        C0248 r04 = this.mState;
        r04.f1495 = r04.f1508;
        this.mDataSetHasChangedAfterLayout = false;
        this.mDispatchItemsChangedEvent = false;
        r04.f1500 = false;
        r04.f1505 = false;
        this.mLayout.mRequestedSimpleAnimations = false;
        ArrayList<AbstractC0269> arrayList = this.mRecycler.f1537;
        if (arrayList != null) {
            arrayList.clear();
        }
        AbstractC0254 r05 = this.mLayout;
        if (r05.mPrefetchMaxObservedInInitialPrefetch) {
            r05.mPrefetchMaxCountObserved = 0;
            r05.mPrefetchMaxObservedInInitialPrefetch = false;
            this.mRecycler.m871();
        }
        this.mLayout.onLayoutCompleted(this.mState);
        onExitLayoutOrScroll();
        stopInterceptRequestLayout(false);
        C2307 r06 = this.mViewInfoStore;
        r06.f7969.clear();
        r06.f7968.m5919();
        int[] iArr = this.mMinMaxLayoutPositions;
        if (didChildRangeChange(iArr[0], iArr[1])) {
            dispatchOnScrolled(0, 0);
        }
        recoverFocusFromState();
        resetFocusInfo();
    }

    private boolean dispatchToOnItemTouchListeners(MotionEvent motionEvent) {
        AbstractC0236 r0 = this.mInterceptingOnItemTouchListener;
        if (r0 != null) {
            C2338 r02 = (C2338) r0;
            if (r02.f8097 != 0) {
                if (motionEvent.getAction() == 0) {
                    boolean r1 = r02.m6127(motionEvent.getX(), motionEvent.getY());
                    boolean r2 = r02.m6132(motionEvent.getX(), motionEvent.getY());
                    if (r1 || r2) {
                        if (r2) {
                            r02.f8081 = 1;
                            r02.f8077 = (float) ((int) motionEvent.getX());
                        } else if (r1) {
                            r02.f8081 = 2;
                            r02.f8101 = (float) ((int) motionEvent.getY());
                        }
                        r02.m6130(2);
                    }
                } else if (motionEvent.getAction() == 1 && r02.f8097 == 2) {
                    r02.f8101 = 0.0f;
                    r02.f8077 = 0.0f;
                    r02.m6130(1);
                    r02.f8081 = 0;
                } else if (motionEvent.getAction() == 2 && r02.f8097 == 2) {
                    r02.m6125();
                    if (r02.f8081 == 1) {
                        float x = motionEvent.getX();
                        int[] iArr = r02.f8080;
                        int i = r02.f8085;
                        iArr[0] = i;
                        iArr[1] = r02.f8082 - i;
                        float max = Math.max((float) iArr[0], Math.min((float) iArr[1], x));
                        if (Math.abs(((float) r02.f8091) - max) >= 2.0f) {
                            int r22 = r02.m6128(r02.f8077, max, iArr, r02.f8078.computeHorizontalScrollRange(), r02.f8078.computeHorizontalScrollOffset(), r02.f8082);
                            if (r22 != 0) {
                                r02.f8078.scrollBy(r22, 0);
                            }
                            r02.f8077 = max;
                        }
                    }
                    if (r02.f8081 == 2) {
                        float y = motionEvent.getY();
                        int[] iArr2 = r02.f8095;
                        int i2 = r02.f8085;
                        iArr2[0] = i2;
                        iArr2[1] = r02.f8092 - i2;
                        float max2 = Math.max((float) iArr2[0], Math.min((float) iArr2[1], y));
                        if (Math.abs(((float) r02.f8090) - max2) >= 2.0f) {
                            int r23 = r02.m6128(r02.f8101, max2, iArr2, r02.f8078.computeVerticalScrollRange(), r02.f8078.computeVerticalScrollOffset(), r02.f8092);
                            if (r23 != 0) {
                                r02.f8078.scrollBy(0, r23);
                            }
                            r02.f8101 = max2;
                        }
                    }
                }
            }
            int action = motionEvent.getAction();
            if (action == 3 || action == 1) {
                this.mInterceptingOnItemTouchListener = null;
            }
            return true;
        } else if (motionEvent.getAction() == 0) {
            return false;
        } else {
            return findInterceptingOnItemTouchListener(motionEvent);
        }
    }

    /* JADX WARNING: Code restructure failed: missing block: B:13:0x005e, code lost:
        if (r6 == 2) goto L_0x0060;
     */
    private boolean findInterceptingOnItemTouchListener(MotionEvent motionEvent) {
        boolean z;
        int action = motionEvent.getAction();
        int size = this.mOnItemTouchListeners.size();
        for (int i = 0; i < size; i++) {
            AbstractC0236 r4 = this.mOnItemTouchListeners.get(i);
            C2338 r5 = (C2338) r4;
            int i2 = r5.f8097;
            if (i2 == 1) {
                boolean r6 = r5.m6127(motionEvent.getX(), motionEvent.getY());
                boolean r9 = r5.m6132(motionEvent.getX(), motionEvent.getY());
                if (motionEvent.getAction() == 0 && (r6 || r9)) {
                    if (r9) {
                        r5.f8081 = 1;
                        r5.f8077 = (float) ((int) motionEvent.getX());
                    } else if (r6) {
                        r5.f8081 = 2;
                        r5.f8101 = (float) ((int) motionEvent.getY());
                    }
                    r5.m6130(2);
                }
                z = false;
                if (!z && action != 3) {
                    this.mInterceptingOnItemTouchListener = r4;
                    return true;
                }
            }
            z = true;
            if (!z) {
            }
        }
        return false;
    }

    private void findMinMaxChildLayoutPositions(int[] iArr) {
        int r0 = this.mChildHelper.m6052();
        if (r0 == 0) {
            iArr[0] = -1;
            iArr[1] = -1;
            return;
        }
        int i = Integer.MAX_VALUE;
        int i2 = Integer.MIN_VALUE;
        for (int i3 = 0; i3 < r0; i3++) {
            AbstractC0269 childViewHolderInt = getChildViewHolderInt(this.mChildHelper.m6050(i3));
            if (!childViewHolderInt.shouldIgnore()) {
                int layoutPosition = childViewHolderInt.getLayoutPosition();
                if (layoutPosition < i) {
                    i = layoutPosition;
                }
                if (layoutPosition > i2) {
                    i2 = layoutPosition;
                }
            }
        }
        iArr[0] = i;
        iArr[1] = i2;
    }

    public static RecyclerView findNestedRecyclerView(View view) {
        if (!(view instanceof ViewGroup)) {
            return null;
        }
        if (view instanceof RecyclerView) {
            return (RecyclerView) view;
        }
        ViewGroup viewGroup = (ViewGroup) view;
        int childCount = viewGroup.getChildCount();
        for (int i = 0; i < childCount; i++) {
            RecyclerView findNestedRecyclerView = findNestedRecyclerView(viewGroup.getChildAt(i));
            if (findNestedRecyclerView != null) {
                return findNestedRecyclerView;
            }
        }
        return null;
    }

    private View findNextViewToFocus() {
        AbstractC0269 findViewHolderForAdapterPosition;
        int i = this.mState.f1511;
        if (i == -1) {
            i = 0;
        }
        int r1 = this.mState.m823();
        for (int i2 = i; i2 < r1; i2++) {
            AbstractC0269 findViewHolderForAdapterPosition2 = findViewHolderForAdapterPosition(i2);
            if (findViewHolderForAdapterPosition2 == null) {
                break;
            } else if (findViewHolderForAdapterPosition2.itemView.hasFocusable()) {
                return findViewHolderForAdapterPosition2.itemView;
            }
        }
        int min = Math.min(r1, i);
        while (true) {
            min--;
            if (min < 0 || (findViewHolderForAdapterPosition = findViewHolderForAdapterPosition(min)) == null) {
                return null;
            }
            if (findViewHolderForAdapterPosition.itemView.hasFocusable()) {
                return findViewHolderForAdapterPosition.itemView;
            }
        }
    }

    public static AbstractC0269 getChildViewHolderInt(View view) {
        if (view == null) {
            return null;
        }
        return ((C0235) view.getLayoutParams()).f1483;
    }

    public static void getDecoratedBoundsWithMarginsInt(View view, Rect rect) {
        C0235 r0 = (C0235) view.getLayoutParams();
        Rect rect2 = r0.f1482;
        rect.set((view.getLeft() - rect2.left) - ((ViewGroup.MarginLayoutParams) r0).leftMargin, (view.getTop() - rect2.top) - ((ViewGroup.MarginLayoutParams) r0).topMargin, view.getRight() + rect2.right + ((ViewGroup.MarginLayoutParams) r0).rightMargin, view.getBottom() + rect2.bottom + ((ViewGroup.MarginLayoutParams) r0).bottomMargin);
    }

    private int getDeepestFocusedViewWithId(View view) {
        int id = view.getId();
        while (!view.isFocused() && (view instanceof ViewGroup) && view.hasFocus()) {
            view = ((ViewGroup) view).getFocusedChild();
            if (view.getId() != -1) {
                id = view.getId();
            }
        }
        return id;
    }

    private String getFullClassName(Context context, String str) {
        if (str.charAt(0) == '.') {
            return context.getPackageName() + str;
        } else if (str.contains(CodelessMatcher.CURRENT_CLASS_NAME)) {
            return str;
        } else {
            return RecyclerView.class.getPackage().getName() + '.' + str;
        }
    }

    private C1775 getScrollingChildHelper() {
        if (this.mScrollingChildHelper == null) {
            this.mScrollingChildHelper = new C1775(this);
        }
        return this.mScrollingChildHelper;
    }

    private void handleMissingPreInfoForChangeError(long j, AbstractC0269 r9, AbstractC0269 r10) {
        int r0 = this.mChildHelper.m6052();
        for (int i = 0; i < r0; i++) {
            AbstractC0269 childViewHolderInt = getChildViewHolderInt(this.mChildHelper.m6050(i));
            if (childViewHolderInt != r9 && getChangedHolderKey(childViewHolderInt) == j) {
                AbstractC0246 r7 = this.mAdapter;
                if (r7 == null || !r7.hasStableIds()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Two different ViewHolders have the same change ID. This might happen due to inconsistent Adapter update events or if the LayoutManager lays out the same View multiple times.\n ViewHolder 1:");
                    sb.append(childViewHolderInt);
                    sb.append(" \n View Holder 2:");
                    sb.append(r9);
                    throw new IllegalStateException(C1293.m3407(this, sb));
                }
                StringBuilder sb2 = new StringBuilder();
                sb2.append("Two different ViewHolders have the same stable ID. Stable IDs in your adapter MUST BE unique and SHOULD NOT change.\n ViewHolder 1:");
                sb2.append(childViewHolderInt);
                sb2.append(" \n View Holder 2:");
                sb2.append(r9);
                throw new IllegalStateException(C1293.m3407(this, sb2));
            }
        }
        Log.e(TAG, "Problem while matching changed view holders with the newones. The pre-layout information for the change holder " + r10 + " cannot be found but it is necessary for " + r9 + exceptionLabel());
    }

    private boolean hasUpdatedView() {
        int r0 = this.mChildHelper.m6052();
        for (int i = 0; i < r0; i++) {
            AbstractC0269 childViewHolderInt = getChildViewHolderInt(this.mChildHelper.m6050(i));
            if (!(childViewHolderInt == null || childViewHolderInt.shouldIgnore() || !childViewHolderInt.isUpdated())) {
                return true;
            }
        }
        return false;
    }

    @SuppressLint({"InlinedApi"})
    private void initAutofill() {
        if (C1729.m4495(this) == 0 && Build.VERSION.SDK_INT >= 26) {
            setImportantForAutofill(8);
        }
    }

    private void initChildrenHelper() {
        this.mChildHelper = new C2316(new C0237());
    }

    private boolean isPreferredNextFocus(View view, View view2, int i) {
        int i2;
        if (view2 == null || view2 == this || findContainingItemView(view2) == null) {
            return false;
        }
        if (view == null || findContainingItemView(view) == null) {
            return true;
        }
        this.mTempRect.set(0, 0, view.getWidth(), view.getHeight());
        this.mTempRect2.set(0, 0, view2.getWidth(), view2.getHeight());
        offsetDescendantRectToMyCoords(view, this.mTempRect);
        offsetDescendantRectToMyCoords(view2, this.mTempRect2);
        char c = 65535;
        int i3 = this.mLayout.getLayoutDirection() == 1 ? -1 : 1;
        Rect rect = this.mTempRect;
        int i4 = rect.left;
        int i5 = this.mTempRect2.left;
        if ((i4 < i5 || rect.right <= i5) && this.mTempRect.right < this.mTempRect2.right) {
            i2 = 1;
        } else {
            Rect rect2 = this.mTempRect;
            int i6 = rect2.right;
            int i7 = this.mTempRect2.right;
            i2 = ((i6 > i7 || rect2.left >= i7) && this.mTempRect.left > this.mTempRect2.left) ? -1 : 0;
        }
        Rect rect3 = this.mTempRect;
        int i8 = rect3.top;
        int i9 = this.mTempRect2.top;
        if ((i8 < i9 || rect3.bottom <= i9) && this.mTempRect.bottom < this.mTempRect2.bottom) {
            c = 1;
        } else {
            Rect rect4 = this.mTempRect;
            int i10 = rect4.bottom;
            int i11 = this.mTempRect2.bottom;
            if ((i10 <= i11 && rect4.top < i11) || this.mTempRect.top <= this.mTempRect2.top) {
                c = 0;
            }
        }
        if (i != 1) {
            if (i != 2) {
                if (i != 17) {
                    if (i != 33) {
                        if (i != 66) {
                            if (i != 130) {
                                StringBuilder sb = new StringBuilder();
                                sb.append("Invalid direction: ");
                                sb.append(i);
                                throw new IllegalArgumentException(C1293.m3407(this, sb));
                            } else if (c > 0) {
                                return true;
                            } else {
                                return false;
                            }
                        } else if (i2 > 0) {
                            return true;
                        } else {
                            return false;
                        }
                    } else if (c < 0) {
                        return true;
                    } else {
                        return false;
                    }
                } else if (i2 < 0) {
                    return true;
                } else {
                    return false;
                }
            } else if (c > 0 || (c == 0 && i2 * i3 >= 0)) {
                return true;
            } else {
                return false;
            }
        } else if (c < 0 || (c == 0 && i2 * i3 <= 0)) {
            return true;
        } else {
            return false;
        }
    }

    private void onPointerUp(MotionEvent motionEvent) {
        int actionIndex = motionEvent.getActionIndex();
        if (motionEvent.getPointerId(actionIndex) == this.mScrollPointerId) {
            int i = actionIndex == 0 ? 1 : 0;
            this.mScrollPointerId = motionEvent.getPointerId(i);
            int x = (int) (motionEvent.getX(i) + 0.5f);
            this.mLastTouchX = x;
            this.mInitialTouchX = x;
            int y = (int) (motionEvent.getY(i) + 0.5f);
            this.mLastTouchY = y;
            this.mInitialTouchY = y;
        }
    }

    private boolean predictiveItemAnimationsEnabled() {
        return this.mItemAnimator != null && this.mLayout.supportsPredictiveItemAnimations();
    }

    private void processAdapterUpdatesAndSetAnimationFlags() {
        boolean z = false;
        if (this.mDataSetHasChangedAfterLayout) {
            C2326 k = this.mAdapterHelper;
            k.m6088(k.f8047);
            k.m6088(k.f8045);
            k.f8052 = 0;
            if (this.mDispatchItemsChangedEvent) {
                this.mLayout.onItemsChanged(this);
            }
        }
        if (predictiveItemAnimationsEnabled()) {
            this.mAdapterHelper.m6095();
        } else {
            this.mAdapterHelper.m6082();
        }
        boolean z2 = this.mItemsAddedOrRemoved || this.mItemsChanged;
        this.mState.f1500 = this.mFirstLayoutComplete && this.mItemAnimator != null && (this.mDataSetHasChangedAfterLayout || z2 || this.mLayout.mRequestedSimpleAnimations) && (!this.mDataSetHasChangedAfterLayout || this.mAdapter.hasStableIds());
        C0248 r3 = this.mState;
        if (r3.f1500 && z2 && !this.mDataSetHasChangedAfterLayout && predictiveItemAnimationsEnabled()) {
            z = true;
        }
        r3.f1505 = z;
    }

    /* JADX WARNING: Removed duplicated region for block: B:10:0x0044  */
    /* JADX WARNING: Removed duplicated region for block: B:11:0x005c  */
    private void pullGlows(float f, float f2, float f3, float f4) {
        boolean z;
        boolean z2 = true;
        if (f2 < 0.0f) {
            ensureLeftGlow();
            int i = Build.VERSION.SDK_INT;
            this.mLeftGlow.onPull((-f2) / ((float) getWidth()), 1.0f - (f3 / ((float) getHeight())));
        } else if (f2 > 0.0f) {
            ensureRightGlow();
            float height = f3 / ((float) getHeight());
            int i2 = Build.VERSION.SDK_INT;
            this.mRightGlow.onPull(f2 / ((float) getWidth()), height);
        } else {
            z = false;
            if (f4 >= 0.0f) {
                ensureTopGlow();
                EdgeEffect edgeEffect = this.mTopGlow;
                float height2 = (-f4) / ((float) getHeight());
                float width = f / ((float) getWidth());
                int i3 = Build.VERSION.SDK_INT;
                edgeEffect.onPull(height2, width);
            } else if (f4 > 0.0f) {
                ensureBottomGlow();
                float width2 = 1.0f - (f / ((float) getWidth()));
                int i4 = Build.VERSION.SDK_INT;
                this.mBottomGlow.onPull(f4 / ((float) getHeight()), width2);
            } else {
                z2 = z;
            }
            if (!z2 || f2 != 0.0f || f4 != 0.0f) {
                C1729.m4449(this);
            }
            return;
        }
        z = true;
        if (f4 >= 0.0f) {
        }
        if (!z2) {
        }
        C1729.m4449(this);
    }

    private void recoverFocusFromState() {
        View view;
        if (this.mPreserveFocusAfterLayout && this.mAdapter != null && hasFocus() && getDescendantFocusability() != 393216) {
            if (getDescendantFocusability() != 131072 || !isFocused()) {
                if (!isFocused()) {
                    View focusedChild = getFocusedChild();
                    if (!IGNORE_DETACHED_FOCUSED_CHILD || (focusedChild.getParent() != null && focusedChild.hasFocus())) {
                        if (!this.mChildHelper.m6051(focusedChild)) {
                            return;
                        }
                    } else if (this.mChildHelper.m6052() == 0) {
                        requestFocus();
                        return;
                    }
                }
                View view2 = null;
                AbstractC0269 findViewHolderForItemId = (this.mState.f1496 == -1 || !this.mAdapter.hasStableIds()) ? null : findViewHolderForItemId(this.mState.f1496);
                if (findViewHolderForItemId != null && !this.mChildHelper.m6051(findViewHolderForItemId.itemView) && findViewHolderForItemId.itemView.hasFocusable()) {
                    view2 = findViewHolderForItemId.itemView;
                } else if (this.mChildHelper.m6052() > 0) {
                    view2 = findNextViewToFocus();
                }
                if (view2 != null) {
                    int i = this.mState.f1506;
                    if (((long) i) == -1 || (view = view2.findViewById(i)) == null || !view.isFocusable()) {
                        view = view2;
                    }
                    view.requestFocus();
                }
            }
        }
    }

    private void releaseGlows() {
        boolean z;
        EdgeEffect edgeEffect = this.mLeftGlow;
        if (edgeEffect != null) {
            edgeEffect.onRelease();
            z = this.mLeftGlow.isFinished();
        } else {
            z = false;
        }
        EdgeEffect edgeEffect2 = this.mTopGlow;
        if (edgeEffect2 != null) {
            edgeEffect2.onRelease();
            z |= this.mTopGlow.isFinished();
        }
        EdgeEffect edgeEffect3 = this.mRightGlow;
        if (edgeEffect3 != null) {
            edgeEffect3.onRelease();
            z |= this.mRightGlow.isFinished();
        }
        EdgeEffect edgeEffect4 = this.mBottomGlow;
        if (edgeEffect4 != null) {
            edgeEffect4.onRelease();
            z |= this.mBottomGlow.isFinished();
        }
        if (z) {
            C1729.m4449(this);
        }
    }

    private void requestChildOnScreen(View view, View view2) {
        View view3 = view2 != null ? view2 : view;
        this.mTempRect.set(0, 0, view3.getWidth(), view3.getHeight());
        ViewGroup.LayoutParams layoutParams = view3.getLayoutParams();
        if (layoutParams instanceof C0235) {
            C0235 r0 = (C0235) layoutParams;
            if (!r0.f1481) {
                Rect rect = r0.f1482;
                Rect rect2 = this.mTempRect;
                rect2.left -= rect.left;
                rect2.right += rect.right;
                rect2.top -= rect.top;
                rect2.bottom += rect.bottom;
            }
        }
        if (view2 != null) {
            offsetDescendantRectToMyCoords(view2, this.mTempRect);
            offsetRectIntoDescendantCoords(view, this.mTempRect);
        }
        this.mLayout.requestChildRectangleOnScreen(this, view, this.mTempRect, !this.mFirstLayoutComplete, view2 == null);
    }

    private void resetFocusInfo() {
        C0248 r0 = this.mState;
        r0.f1496 = -1;
        r0.f1511 = -1;
        r0.f1506 = -1;
    }

    private void resetScroll() {
        VelocityTracker velocityTracker = this.mVelocityTracker;
        if (velocityTracker != null) {
            velocityTracker.clear();
        }
        stopNestedScroll(0);
        releaseGlows();
    }

    private void saveFocusInfo() {
        int i;
        AbstractC0269 r1 = null;
        View focusedChild = (!this.mPreserveFocusAfterLayout || !hasFocus() || this.mAdapter == null) ? null : getFocusedChild();
        if (focusedChild != null) {
            r1 = findContainingViewHolder(focusedChild);
        }
        if (r1 == null) {
            resetFocusInfo();
            return;
        }
        this.mState.f1496 = this.mAdapter.hasStableIds() ? r1.getItemId() : -1;
        C0248 r0 = this.mState;
        if (this.mDataSetHasChangedAfterLayout) {
            i = -1;
        } else if (r1.isRemoved()) {
            i = r1.mOldPosition;
        } else {
            i = r1.getAdapterPosition();
        }
        r0.f1511 = i;
        this.mState.f1506 = getDeepestFocusedViewWithId(r1.itemView);
    }

    private void setAdapterInternal(AbstractC0246 r3, boolean z, boolean z2) {
        AbstractC0246 r0 = this.mAdapter;
        if (r0 != null) {
            r0.unregisterAdapterDataObserver(this.mObserver);
            this.mAdapter.onDetachedFromRecyclerView(this);
        }
        if (!z || z2) {
            removeAndRecycleViews();
        }
        C2326 k = this.mAdapterHelper;
        k.m6088(k.f8047);
        k.m6088(k.f8045);
        k.f8052 = 0;
        AbstractC0246 r5 = this.mAdapter;
        this.mAdapter = r3;
        if (r3 != null) {
            r3.registerAdapterDataObserver(this.mObserver);
            r3.onAttachedToRecyclerView(this);
        }
        AbstractC0254 r32 = this.mLayout;
        if (r32 != null) {
            r32.onAdapterChanged(r5, this.mAdapter);
        }
        C0264 r33 = this.mRecycler;
        AbstractC0246 r02 = this.mAdapter;
        r33.m865();
        r33.m859().m807(r5, r02, z);
        this.mState.f1503 = true;
    }

    private void stopScrollersInternal() {
        this.mViewFlinger.m850();
        AbstractC0254 r0 = this.mLayout;
        if (r0 != null) {
            r0.stopSmoothScroller();
        }
    }

    public void absorbGlows(int i, int i2) {
        if (i < 0) {
            ensureLeftGlow();
            if (this.mLeftGlow.isFinished()) {
                this.mLeftGlow.onAbsorb(-i);
            }
        } else if (i > 0) {
            ensureRightGlow();
            if (this.mRightGlow.isFinished()) {
                this.mRightGlow.onAbsorb(i);
            }
        }
        if (i2 < 0) {
            ensureTopGlow();
            if (this.mTopGlow.isFinished()) {
                this.mTopGlow.onAbsorb(-i2);
            }
        } else if (i2 > 0) {
            ensureBottomGlow();
            if (this.mBottomGlow.isFinished()) {
                this.mBottomGlow.onAbsorb(i2);
            }
        }
        if (i != 0 || i2 != 0) {
            C1729.m4449(this);
        }
    }

    @Override // android.view.View, android.view.ViewGroup
    public void addFocusables(ArrayList<View> arrayList, int i, int i2) {
        AbstractC0254 r0 = this.mLayout;
        if (r0 == null || !r0.onAddFocusables(this, arrayList, i, i2)) {
            super.addFocusables(arrayList, i, i2);
        }
    }

    public void addItemDecoration(AbstractC0232 r3, int i) {
        AbstractC0254 r0 = this.mLayout;
        if (r0 != null) {
            r0.assertNotInLayoutOrScroll("Cannot add item decoration during a scroll  or layout");
        }
        if (this.mItemDecorations.isEmpty()) {
            setWillNotDraw(false);
        }
        if (i < 0) {
            this.mItemDecorations.add(r3);
        } else {
            this.mItemDecorations.add(i, r3);
        }
        markItemDecorInsetsDirty();
        requestLayout();
    }

    public void addOnChildAttachStateChangeListener(AbstractC0242 r2) {
        if (this.mOnChildAttachStateListeners == null) {
            this.mOnChildAttachStateListeners = new ArrayList();
        }
        this.mOnChildAttachStateListeners.add(r2);
    }

    public void addOnItemTouchListener(AbstractC0236 r2) {
        this.mOnItemTouchListeners.add(r2);
    }

    public void addOnScrollListener(AbstractC0267 r2) {
        if (this.mScrollListeners == null) {
            this.mScrollListeners = new ArrayList();
        }
        this.mScrollListeners.add(r2);
    }

    public void animateAppearance(AbstractC0269 r2, AbstractC0250.C0251 r3, AbstractC0250.C0251 r4) {
        r2.setIsRecyclable(false);
        if (this.mItemAnimator.m834(r2, r3, r4)) {
            postAnimationRunner();
        }
    }

    public void animateDisappearance(AbstractC0269 r2, AbstractC0250.C0251 r3, AbstractC0250.C0251 r4) {
        addAnimatingView(r2);
        r2.setIsRecyclable(false);
        if (this.mItemAnimator.m831(r2, r3, r4)) {
            postAnimationRunner();
        }
    }

    public void assertInLayoutOrScroll(String str) {
        if (isComputingLayout()) {
            return;
        }
        if (str == null) {
            throw new IllegalStateException(C1293.m3407(this, C1293.m3416("Cannot call this method unless RecyclerView is computing a layout or scrolling")));
        }
        throw new IllegalStateException(C1293.m3407(this, C1293.m3416(str)));
    }

    public void assertNotInLayoutOrScroll(String str) {
        if (isComputingLayout()) {
            if (str == null) {
                throw new IllegalStateException(C1293.m3407(this, C1293.m3416("Cannot call this method while RecyclerView is computing a layout or scrolling")));
            }
            throw new IllegalStateException(str);
        } else if (this.mDispatchScrollCounter > 0) {
            Log.w(TAG, "Cannot call this method in a scroll callback. Scroll callbacks mightbe run during a measure & layout pass where you cannot change theRecyclerView data. Any method call that might change the structureof the RecyclerView or the adapter contents should be postponed tothe next frame.", new IllegalStateException(C1293.m3407(this, C1293.m3416(""))));
        }
    }

    public boolean canReuseUpdatedViewHolder(AbstractC0269 r3) {
        AbstractC0250 r0 = this.mItemAnimator;
        return r0 == null || r0.m836(r3, r3.getUnmodifiedPayloads());
    }

    public boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return (layoutParams instanceof C0235) && this.mLayout.checkLayoutParams((C0235) layoutParams);
    }

    public void clearOldPositions() {
        int r0 = this.mChildHelper.m6049();
        for (int i = 0; i < r0; i++) {
            AbstractC0269 childViewHolderInt = getChildViewHolderInt(this.mChildHelper.m6057(i));
            if (!childViewHolderInt.shouldIgnore()) {
                childViewHolderInt.clearOldPosition();
            }
        }
        C0264 r02 = this.mRecycler;
        int size = r02.f1535.size();
        for (int i2 = 0; i2 < size; i2++) {
            r02.f1535.get(i2).clearOldPosition();
        }
        int size2 = r02.f1539.size();
        for (int i3 = 0; i3 < size2; i3++) {
            r02.f1539.get(i3).clearOldPosition();
        }
        ArrayList<AbstractC0269> arrayList = r02.f1537;
        if (arrayList != null) {
            int size3 = arrayList.size();
            for (int i4 = 0; i4 < size3; i4++) {
                r02.f1537.get(i4).clearOldPosition();
            }
        }
    }

    public void clearOnChildAttachStateChangeListeners() {
        List<AbstractC0242> list = this.mOnChildAttachStateListeners;
        if (list != null) {
            list.clear();
        }
    }

    public void clearOnScrollListeners() {
        List<AbstractC0267> list = this.mScrollListeners;
        if (list != null) {
            list.clear();
        }
    }

    public int computeHorizontalScrollExtent() {
        AbstractC0254 r0 = this.mLayout;
        if (r0 != null && r0.canScrollHorizontally()) {
            return this.mLayout.computeHorizontalScrollExtent(this.mState);
        }
        return 0;
    }

    public int computeHorizontalScrollOffset() {
        AbstractC0254 r0 = this.mLayout;
        if (r0 != null && r0.canScrollHorizontally()) {
            return this.mLayout.computeHorizontalScrollOffset(this.mState);
        }
        return 0;
    }

    public int computeHorizontalScrollRange() {
        AbstractC0254 r0 = this.mLayout;
        if (r0 != null && r0.canScrollHorizontally()) {
            return this.mLayout.computeHorizontalScrollRange(this.mState);
        }
        return 0;
    }

    public int computeVerticalScrollExtent() {
        AbstractC0254 r0 = this.mLayout;
        if (r0 != null && r0.canScrollVertically()) {
            return this.mLayout.computeVerticalScrollExtent(this.mState);
        }
        return 0;
    }

    public int computeVerticalScrollOffset() {
        AbstractC0254 r0 = this.mLayout;
        if (r0 != null && r0.canScrollVertically()) {
            return this.mLayout.computeVerticalScrollOffset(this.mState);
        }
        return 0;
    }

    public int computeVerticalScrollRange() {
        AbstractC0254 r0 = this.mLayout;
        if (r0 != null && r0.canScrollVertically()) {
            return this.mLayout.computeVerticalScrollRange(this.mState);
        }
        return 0;
    }

    public void considerReleasingGlowsOnScroll(int i, int i2) {
        boolean z;
        EdgeEffect edgeEffect = this.mLeftGlow;
        if (edgeEffect == null || edgeEffect.isFinished() || i <= 0) {
            z = false;
        } else {
            this.mLeftGlow.onRelease();
            z = this.mLeftGlow.isFinished();
        }
        EdgeEffect edgeEffect2 = this.mRightGlow;
        if (edgeEffect2 != null && !edgeEffect2.isFinished() && i < 0) {
            this.mRightGlow.onRelease();
            z |= this.mRightGlow.isFinished();
        }
        EdgeEffect edgeEffect3 = this.mTopGlow;
        if (edgeEffect3 != null && !edgeEffect3.isFinished() && i2 > 0) {
            this.mTopGlow.onRelease();
            z |= this.mTopGlow.isFinished();
        }
        EdgeEffect edgeEffect4 = this.mBottomGlow;
        if (edgeEffect4 != null && !edgeEffect4.isFinished() && i2 < 0) {
            this.mBottomGlow.onRelease();
            z |= this.mBottomGlow.isFinished();
        }
        if (z) {
            C1729.m4449(this);
        }
    }

    public void consumePendingUpdateOperations() {
        if (!this.mFirstLayoutComplete || this.mDataSetHasChangedAfterLayout) {
            C1724.m4432(TRACE_ON_DATA_SET_CHANGE_LAYOUT_TAG);
            dispatchLayout();
            int i = Build.VERSION.SDK_INT;
            Trace.endSection();
        } else if (this.mAdapterHelper.m6080()) {
            boolean z = false;
            if ((this.mAdapterHelper.f8052 & 4) != 0) {
                if ((this.mAdapterHelper.f8052 & 11) != 0) {
                    z = true;
                }
                if (!z) {
                    C1724.m4432(TRACE_HANDLE_ADAPTER_UPDATES_TAG);
                    startInterceptRequestLayout();
                    onEnterLayoutOrScroll();
                    this.mAdapterHelper.m6095();
                    if (!this.mLayoutWasDefered) {
                        if (hasUpdatedView()) {
                            dispatchLayout();
                        } else {
                            this.mAdapterHelper.m6087();
                        }
                    }
                    stopInterceptRequestLayout(true);
                    onExitLayoutOrScroll();
                    int i2 = Build.VERSION.SDK_INT;
                    Trace.endSection();
                    return;
                }
            }
            if (this.mAdapterHelper.m6080()) {
                C1724.m4432(TRACE_ON_DATA_SET_CHANGE_LAYOUT_TAG);
                dispatchLayout();
                int i3 = Build.VERSION.SDK_INT;
                Trace.endSection();
            }
        }
    }

    public void defaultOnMeasure(int i, int i2) {
        setMeasuredDimension(AbstractC0254.chooseSize(i, getPaddingRight() + getPaddingLeft(), C1729.m4496(this)), AbstractC0254.chooseSize(i2, getPaddingBottom() + getPaddingTop(), C1729.m4442(this)));
    }

    public void dispatchChildAttached(View view) {
        AbstractC0269 childViewHolderInt = getChildViewHolderInt(view);
        onChildAttachedToWindow(view);
        AbstractC0246 r1 = this.mAdapter;
        if (!(r1 == null || childViewHolderInt == null)) {
            r1.onViewAttachedToWindow(childViewHolderInt);
        }
        List<AbstractC0242> list = this.mOnChildAttachStateListeners;
        if (list != null) {
            for (int size = list.size() - 1; size >= 0; size--) {
                ((C2203) this.mOnChildAttachStateListeners.get(size)).m5830(view);
            }
        }
    }

    public void dispatchChildDetached(View view) {
        AbstractC0269 childViewHolderInt = getChildViewHolderInt(view);
        onChildDetachedFromWindow(view);
        AbstractC0246 r1 = this.mAdapter;
        if (!(r1 == null || childViewHolderInt == null)) {
            r1.onViewDetachedFromWindow(childViewHolderInt);
        }
        List<AbstractC0242> list = this.mOnChildAttachStateListeners;
        if (list != null) {
            for (int size = list.size() - 1; size >= 0; size--) {
                ((C2203) this.mOnChildAttachStateListeners.get(size)).m5829(view);
            }
        }
    }

    public void dispatchLayout() {
        if (this.mAdapter == null) {
            Log.e(TAG, "No adapter attached; skipping layout");
        } else if (this.mLayout == null) {
            Log.e(TAG, "No layout manager attached; skipping layout");
        } else {
            C0248 r0 = this.mState;
            boolean z = false;
            r0.f1507 = false;
            if (r0.f1498 == 1) {
                dispatchLayoutStep1();
                this.mLayout.setExactMeasureSpecsFrom(this);
                dispatchLayoutStep2();
            } else {
                C2326 k = this.mAdapterHelper;
                if (!k.f8045.isEmpty() && !k.f8047.isEmpty()) {
                    z = true;
                }
                if (!z && this.mLayout.getWidth() == getWidth() && this.mLayout.getHeight() == getHeight()) {
                    this.mLayout.setExactMeasureSpecsFrom(this);
                } else {
                    this.mLayout.setExactMeasureSpecsFrom(this);
                    dispatchLayoutStep2();
                }
            }
            dispatchLayoutStep3();
        }
    }

    public boolean dispatchNestedFling(float f, float f2, boolean z) {
        return getScrollingChildHelper().m4631(f, f2, z);
    }

    public boolean dispatchNestedPreFling(float f, float f2) {
        return getScrollingChildHelper().m4630(f, f2);
    }

    public boolean dispatchNestedPreScroll(int i, int i2, int[] iArr, int[] iArr2) {
        return getScrollingChildHelper().m4634(i, i2, iArr, iArr2);
    }

    public boolean dispatchNestedScroll(int i, int i2, int i3, int i4, int[] iArr) {
        return getScrollingChildHelper().m4633(i, i2, i3, i4, iArr);
    }

    public void dispatchOnScrollStateChanged(int i) {
        AbstractC0254 r0 = this.mLayout;
        if (r0 != null) {
            r0.onScrollStateChanged(i);
        }
        onScrollStateChanged(i);
        AbstractC0267 r02 = this.mScrollListener;
        if (r02 != null) {
            r02.onScrollStateChanged(this, i);
        }
        List<AbstractC0267> list = this.mScrollListeners;
        if (list != null) {
            for (int size = list.size() - 1; size >= 0; size--) {
                this.mScrollListeners.get(size).onScrollStateChanged(this, i);
            }
        }
    }

    public void dispatchOnScrolled(int i, int i2) {
        this.mDispatchScrollCounter++;
        int scrollX = getScrollX();
        int scrollY = getScrollY();
        onScrollChanged(scrollX, scrollY, scrollX - i, scrollY - i2);
        onScrolled(i, i2);
        AbstractC0267 r0 = this.mScrollListener;
        if (r0 != null) {
            r0.onScrolled(this, i, i2);
        }
        List<AbstractC0267> list = this.mScrollListeners;
        if (list != null) {
            for (int size = list.size() - 1; size >= 0; size--) {
                this.mScrollListeners.get(size).onScrolled(this, i, i2);
            }
        }
        this.mDispatchScrollCounter--;
    }

    public void dispatchPendingImportantForAccessibilityChanges() {
        int i;
        for (int size = this.mPendingAccessibilityImportanceChange.size() - 1; size >= 0; size--) {
            AbstractC0269 r1 = this.mPendingAccessibilityImportanceChange.get(size);
            if (r1.itemView.getParent() == this && !r1.shouldIgnore() && (i = r1.mPendingAccessibilityState) != -1) {
                C1729.m4457(r1.itemView, i);
                r1.mPendingAccessibilityState = -1;
            }
        }
        this.mPendingAccessibilityImportanceChange.clear();
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        onPopulateAccessibilityEvent(accessibilityEvent);
        return true;
    }

    @Override // android.view.View, android.view.ViewGroup
    public void dispatchRestoreInstanceState(SparseArray<Parcelable> sparseArray) {
        dispatchThawSelfOnly(sparseArray);
    }

    @Override // android.view.View, android.view.ViewGroup
    public void dispatchSaveInstanceState(SparseArray<Parcelable> sparseArray) {
        dispatchFreezeSelfOnly(sparseArray);
    }

    public void draw(Canvas canvas) {
        boolean z;
        boolean z2;
        super.draw(canvas);
        int size = this.mItemDecorations.size();
        boolean z3 = false;
        for (int i = 0; i < size; i++) {
            this.mItemDecorations.get(i).onDrawOver(canvas, this, this.mState);
        }
        EdgeEffect edgeEffect = this.mLeftGlow;
        if (edgeEffect == null || edgeEffect.isFinished()) {
            z = false;
        } else {
            int save = canvas.save();
            int paddingBottom = this.mClipToPadding ? getPaddingBottom() : 0;
            canvas.rotate(270.0f);
            canvas.translate((float) ((-getHeight()) + paddingBottom), 0.0f);
            EdgeEffect edgeEffect2 = this.mLeftGlow;
            z = edgeEffect2 != null && edgeEffect2.draw(canvas);
            canvas.restoreToCount(save);
        }
        EdgeEffect edgeEffect3 = this.mTopGlow;
        if (edgeEffect3 != null && !edgeEffect3.isFinished()) {
            int save2 = canvas.save();
            if (this.mClipToPadding) {
                canvas.translate((float) getPaddingLeft(), (float) getPaddingTop());
            }
            EdgeEffect edgeEffect4 = this.mTopGlow;
            z |= edgeEffect4 != null && edgeEffect4.draw(canvas);
            canvas.restoreToCount(save2);
        }
        EdgeEffect edgeEffect5 = this.mRightGlow;
        if (edgeEffect5 != null && !edgeEffect5.isFinished()) {
            int save3 = canvas.save();
            int width = getWidth();
            int paddingTop = this.mClipToPadding ? getPaddingTop() : 0;
            canvas.rotate(90.0f);
            canvas.translate((float) (-paddingTop), (float) (-width));
            EdgeEffect edgeEffect6 = this.mRightGlow;
            z |= edgeEffect6 != null && edgeEffect6.draw(canvas);
            canvas.restoreToCount(save3);
        }
        EdgeEffect edgeEffect7 = this.mBottomGlow;
        if (edgeEffect7 == null || edgeEffect7.isFinished()) {
            z2 = z;
        } else {
            int save4 = canvas.save();
            canvas.rotate(180.0f);
            if (this.mClipToPadding) {
                canvas.translate((float) (getPaddingRight() + (-getWidth())), (float) (getPaddingBottom() + (-getHeight())));
            } else {
                canvas.translate((float) (-getWidth()), (float) (-getHeight()));
            }
            EdgeEffect edgeEffect8 = this.mBottomGlow;
            if (edgeEffect8 != null && edgeEffect8.draw(canvas)) {
                z3 = true;
            }
            z2 = z3 | z;
            canvas.restoreToCount(save4);
        }
        if (!z2 && this.mItemAnimator != null && this.mItemDecorations.size() > 0 && this.mItemAnimator.m837()) {
            z2 = true;
        }
        if (z2) {
            C1729.m4449(this);
        }
    }

    public boolean drawChild(Canvas canvas, View view, long j) {
        return super.drawChild(canvas, view, j);
    }

    public void ensureBottomGlow() {
        if (this.mBottomGlow == null) {
            this.mBottomGlow = this.mEdgeEffectFactory.m822(this);
            if (this.mClipToPadding) {
                this.mBottomGlow.setSize((getMeasuredWidth() - getPaddingLeft()) - getPaddingRight(), (getMeasuredHeight() - getPaddingTop()) - getPaddingBottom());
            } else {
                this.mBottomGlow.setSize(getMeasuredWidth(), getMeasuredHeight());
            }
        }
    }

    public void ensureLeftGlow() {
        if (this.mLeftGlow == null) {
            this.mLeftGlow = this.mEdgeEffectFactory.m822(this);
            if (this.mClipToPadding) {
                this.mLeftGlow.setSize((getMeasuredHeight() - getPaddingTop()) - getPaddingBottom(), (getMeasuredWidth() - getPaddingLeft()) - getPaddingRight());
            } else {
                this.mLeftGlow.setSize(getMeasuredHeight(), getMeasuredWidth());
            }
        }
    }

    public void ensureRightGlow() {
        if (this.mRightGlow == null) {
            this.mRightGlow = this.mEdgeEffectFactory.m822(this);
            if (this.mClipToPadding) {
                this.mRightGlow.setSize((getMeasuredHeight() - getPaddingTop()) - getPaddingBottom(), (getMeasuredWidth() - getPaddingLeft()) - getPaddingRight());
            } else {
                this.mRightGlow.setSize(getMeasuredHeight(), getMeasuredWidth());
            }
        }
    }

    public void ensureTopGlow() {
        if (this.mTopGlow == null) {
            this.mTopGlow = this.mEdgeEffectFactory.m822(this);
            if (this.mClipToPadding) {
                this.mTopGlow.setSize((getMeasuredWidth() - getPaddingLeft()) - getPaddingRight(), (getMeasuredHeight() - getPaddingTop()) - getPaddingBottom());
            } else {
                this.mTopGlow.setSize(getMeasuredWidth(), getMeasuredHeight());
            }
        }
    }

    public String exceptionLabel() {
        StringBuilder r0 = C1293.m3416(" ");
        r0.append(super.toString());
        r0.append(", adapter:");
        r0.append(this.mAdapter);
        r0.append(", layout:");
        r0.append(this.mLayout);
        r0.append(", context:");
        r0.append(getContext());
        return r0.toString();
    }

    public final void fillRemainingScrollValues(C0248 r4) {
        if (getScrollState() == 2) {
            OverScroller overScroller = this.mViewFlinger.f1531;
            r4.f1497 = overScroller.getFinalX() - overScroller.getCurrX();
            r4.f1499 = overScroller.getFinalY() - overScroller.getCurrY();
            return;
        }
        r4.f1497 = 0;
        r4.f1499 = 0;
    }

    public View findChildViewUnder(float f, float f2) {
        for (int r0 = this.mChildHelper.m6052() - 1; r0 >= 0; r0--) {
            View r1 = this.mChildHelper.m6050(r0);
            float translationX = r1.getTranslationX();
            float translationY = r1.getTranslationY();
            if (f >= ((float) r1.getLeft()) + translationX && f <= ((float) r1.getRight()) + translationX && f2 >= ((float) r1.getTop()) + translationY && f2 <= ((float) r1.getBottom()) + translationY) {
                return r1;
            }
        }
        return null;
    }

    public View findContainingItemView(View view) {
        ViewParent parent = view.getParent();
        while (parent != null && parent != this && (parent instanceof View)) {
            view = (View) parent;
            parent = view.getParent();
        }
        if (parent == this) {
            return view;
        }
        return null;
    }

    public AbstractC0269 findContainingViewHolder(View view) {
        View findContainingItemView = findContainingItemView(view);
        if (findContainingItemView == null) {
            return null;
        }
        return getChildViewHolder(findContainingItemView);
    }

    public AbstractC0269 findViewHolderForAdapterPosition(int i) {
        AbstractC0269 r1 = null;
        if (this.mDataSetHasChangedAfterLayout) {
            return null;
        }
        int r0 = this.mChildHelper.m6049();
        for (int i2 = 0; i2 < r0; i2++) {
            AbstractC0269 childViewHolderInt = getChildViewHolderInt(this.mChildHelper.m6057(i2));
            if (childViewHolderInt != null && !childViewHolderInt.isRemoved() && getAdapterPositionFor(childViewHolderInt) == i) {
                if (!this.mChildHelper.m6051(childViewHolderInt.itemView)) {
                    return childViewHolderInt;
                }
                r1 = childViewHolderInt;
            }
        }
        return r1;
    }

    public AbstractC0269 findViewHolderForItemId(long j) {
        AbstractC0246 r0 = this.mAdapter;
        AbstractC0269 r1 = null;
        if (r0 != null && r0.hasStableIds()) {
            int r02 = this.mChildHelper.m6049();
            for (int i = 0; i < r02; i++) {
                AbstractC0269 childViewHolderInt = getChildViewHolderInt(this.mChildHelper.m6057(i));
                if (childViewHolderInt != null && !childViewHolderInt.isRemoved() && childViewHolderInt.getItemId() == j) {
                    if (!this.mChildHelper.m6051(childViewHolderInt.itemView)) {
                        return childViewHolderInt;
                    }
                    r1 = childViewHolderInt;
                }
            }
        }
        return r1;
    }

    public AbstractC0269 findViewHolderForLayoutPosition(int i) {
        return findViewHolderForPosition(i, false);
    }

    @Deprecated
    public AbstractC0269 findViewHolderForPosition(int i) {
        return findViewHolderForPosition(i, false);
    }

    /* JADX WARNING: Removed duplicated region for block: B:107:0x0166  */
    /* JADX WARNING: Removed duplicated region for block: B:108:0x0168  */
    /* JADX WARNING: Removed duplicated region for block: B:110:0x0171  */
    public boolean fling(int i, int i2) {
        boolean z;
        boolean z2;
        C2310 r12;
        int i3;
        int i4;
        AbstractC2303 r15;
        PointF computeScrollVectorForPosition;
        int position;
        boolean z3;
        AbstractC0254 r1 = this.mLayout;
        int i5 = 0;
        if (r1 == null) {
            Log.e(TAG, "Cannot fling without a LayoutManager set. Call setLayoutManager with a non-null argument.");
            return false;
        } else if (this.mLayoutSuppressed) {
            return false;
        } else {
            boolean canScrollHorizontally = r1.canScrollHorizontally();
            boolean canScrollVertically = this.mLayout.canScrollVertically();
            int i6 = (!canScrollHorizontally || Math.abs(i) < this.mMinFlingVelocity) ? 0 : i;
            int i7 = (!canScrollVertically || Math.abs(i2) < this.mMinFlingVelocity) ? 0 : i2;
            if (i6 == 0 && i7 == 0) {
                return false;
            }
            float f = (float) i6;
            float f2 = (float) i7;
            if (dispatchNestedPreFling(f, f2)) {
                return false;
            }
            boolean z4 = canScrollHorizontally || canScrollVertically;
            dispatchNestedFling(f, f2, z4);
            AbstractC0259 r6 = this.mOnFlingListener;
            if (r6 != null) {
                AbstractC2301 r62 = (AbstractC2301) r6;
                AbstractC0254 layoutManager = r62.f7958.getLayoutManager();
                if (layoutManager == null || r62.f7958.getAdapter() == null) {
                    z = canScrollHorizontally;
                    z2 = canScrollVertically;
                } else {
                    int minFlingVelocity = r62.f7958.getMinFlingVelocity();
                    if (Math.abs(i7) > minFlingVelocity || Math.abs(i6) > minFlingVelocity) {
                        boolean z5 = layoutManager instanceof AbstractC0238.AbstractC0239;
                        if (z5) {
                            C2331 r63 = (C2331) r62;
                            if (!z5) {
                                r12 = null;
                            } else {
                                r12 = new C2310(r63, r63.f7958.getContext());
                            }
                            if (r12 != null) {
                                int itemCount = layoutManager.getItemCount();
                                if (itemCount != 0) {
                                    if (layoutManager.canScrollVertically()) {
                                        r15 = r63.m6110(layoutManager);
                                    } else {
                                        r15 = layoutManager.canScrollHorizontally() ? r63.m6111(layoutManager) : null;
                                    }
                                    if (r15 != null) {
                                        int childCount = layoutManager.getChildCount();
                                        z2 = canScrollVertically;
                                        View view = null;
                                        View view2 = null;
                                        int i8 = Integer.MAX_VALUE;
                                        int i9 = Integer.MIN_VALUE;
                                        while (i5 < childCount) {
                                            View childAt = layoutManager.getChildAt(i5);
                                            if (childAt == null) {
                                                z3 = canScrollHorizontally;
                                            } else {
                                                z3 = canScrollHorizontally;
                                                int r13 = r63.m6112(childAt, r15);
                                                if (r13 <= 0 && r13 > i9) {
                                                    i9 = r13;
                                                    view2 = childAt;
                                                }
                                                if (r13 >= 0 && r13 < i8) {
                                                    i8 = r13;
                                                    view = childAt;
                                                }
                                            }
                                            i5++;
                                            childCount = childCount;
                                            canScrollHorizontally = z3;
                                        }
                                        z = canScrollHorizontally;
                                        boolean z6 = !layoutManager.canScrollHorizontally() ? i7 > 0 : i6 > 0;
                                        if (z6 && view != null) {
                                            position = layoutManager.getPosition(view);
                                        } else if (z6 || view2 == null) {
                                            if (z6) {
                                                view = view2;
                                            }
                                            if (view != null) {
                                                int position2 = ((z5 && (computeScrollVectorForPosition = ((AbstractC0238.AbstractC0239) layoutManager).computeScrollVectorForPosition(layoutManager.getItemCount() - 1)) != null && ((computeScrollVectorForPosition.x > 0.0f ? 1 : (computeScrollVectorForPosition.x == 0.0f ? 0 : -1)) < 0 || (computeScrollVectorForPosition.y > 0.0f ? 1 : (computeScrollVectorForPosition.y == 0.0f ? 0 : -1)) < 0)) == z6 ? -1 : 1) + layoutManager.getPosition(view);
                                                if (position2 >= 0 && position2 < itemCount) {
                                                    i3 = position2;
                                                    i4 = -1;
                                                    if (i3 != i4) {
                                                        i5 = 0;
                                                    } else {
                                                        r12.setTargetPosition(i3);
                                                        layoutManager.startSmoothScroll(r12);
                                                        i5 = 1;
                                                    }
                                                    if (i5 != 0) {
                                                        i5 = 1;
                                                    }
                                                }
                                            }
                                            i4 = -1;
                                            i3 = -1;
                                            if (i3 != i4) {
                                            }
                                            if (i5 != 0) {
                                            }
                                        } else {
                                            position = layoutManager.getPosition(view2);
                                        }
                                        i3 = position;
                                        i4 = -1;
                                        if (i3 != i4) {
                                        }
                                        if (i5 != 0) {
                                        }
                                    }
                                }
                                z = canScrollHorizontally;
                                z2 = canScrollVertically;
                                i4 = -1;
                                i3 = -1;
                                if (i3 != i4) {
                                }
                                if (i5 != 0) {
                                }
                            }
                        }
                        z = canScrollHorizontally;
                        z2 = canScrollVertically;
                        if (i5 != 0) {
                        }
                    } else {
                        z = canScrollHorizontally;
                        z2 = canScrollVertically;
                    }
                    i5 = 0;
                }
                if (i5 != 0) {
                    return true;
                }
            } else {
                z = canScrollHorizontally;
                z2 = canScrollVertically;
            }
            if (!z4) {
                return false;
            }
            int i10 = z ? 1 : 0;
            if (z2) {
                i10 |= 2;
            }
            startNestedScroll(i10, 1);
            int i11 = this.mMaxFlingVelocity;
            int max = Math.max(-i11, Math.min(i6, i11));
            int i12 = this.mMaxFlingVelocity;
            int max2 = Math.max(-i12, Math.min(i7, i12));
            RunnableC0260 r14 = this.mViewFlinger;
            RecyclerView.this.setScrollState(2);
            r14.f1526 = 0;
            r14.f1528 = 0;
            Interpolator interpolator = r14.f1527;
            Interpolator interpolator2 = sQuinticInterpolator;
            if (interpolator != interpolator2) {
                r14.f1527 = interpolator2;
                r14.f1531 = new OverScroller(RecyclerView.this.getContext(), sQuinticInterpolator);
            }
            r14.f1531.fling(0, 0, max, max2, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
            r14.m851();
            return true;
        }
    }

    public View focusSearch(View view, int i) {
        View view2;
        boolean z;
        View onInterceptFocusSearch = this.mLayout.onInterceptFocusSearch(view, i);
        if (onInterceptFocusSearch != null) {
            return onInterceptFocusSearch;
        }
        boolean z2 = this.mAdapter != null && this.mLayout != null && !isComputingLayout() && !this.mLayoutSuppressed;
        FocusFinder instance = FocusFinder.getInstance();
        if (!z2 || !(i == 2 || i == 1)) {
            View findNextFocus = instance.findNextFocus(this, view, i);
            if (findNextFocus != null || !z2) {
                view2 = findNextFocus;
            } else {
                consumePendingUpdateOperations();
                if (findContainingItemView(view) == null) {
                    return null;
                }
                startInterceptRequestLayout();
                view2 = this.mLayout.onFocusSearchFailed(view, i, this.mRecycler, this.mState);
                stopInterceptRequestLayout(false);
            }
        } else {
            if (this.mLayout.canScrollVertically()) {
                int i2 = i == 2 ? 130 : 33;
                z = instance.findNextFocus(this, view, i2) == null;
                if (FORCE_ABS_FOCUS_SEARCH_DIRECTION) {
                    i = i2;
                }
            } else {
                z = false;
            }
            if (!z && this.mLayout.canScrollHorizontally()) {
                int i3 = (this.mLayout.getLayoutDirection() == 1) ^ (i == 2) ? 66 : 17;
                z = instance.findNextFocus(this, view, i3) == null;
                if (FORCE_ABS_FOCUS_SEARCH_DIRECTION) {
                    i = i3;
                }
            }
            if (z) {
                consumePendingUpdateOperations();
                if (findContainingItemView(view) == null) {
                    return null;
                }
                startInterceptRequestLayout();
                this.mLayout.onFocusSearchFailed(view, i, this.mRecycler, this.mState);
                stopInterceptRequestLayout(false);
            }
            view2 = instance.findNextFocus(this, view, i);
        }
        if (view2 == null || view2.hasFocusable()) {
            return isPreferredNextFocus(view, view2, i) ? view2 : super.focusSearch(view, i);
        }
        if (getFocusedChild() == null) {
            return super.focusSearch(view, i);
        }
        requestChildOnScreen(view2, null);
        return view;
    }

    public ViewGroup.LayoutParams generateDefaultLayoutParams() {
        AbstractC0254 r0 = this.mLayout;
        if (r0 != null) {
            return r0.generateDefaultLayoutParams();
        }
        throw new IllegalStateException(C1293.m3407(this, C1293.m3416("RecyclerView has no LayoutManager")));
    }

    @Override // android.view.ViewGroup
    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        AbstractC0254 r0 = this.mLayout;
        if (r0 != null) {
            return r0.generateLayoutParams(getContext(), attributeSet);
        }
        throw new IllegalStateException(C1293.m3407(this, C1293.m3416("RecyclerView has no LayoutManager")));
    }

    public CharSequence getAccessibilityClassName() {
        return "androidx.recyclerview.widget.RecyclerView";
    }

    public AbstractC0246 getAdapter() {
        return this.mAdapter;
    }

    public int getAdapterPositionFor(AbstractC0269 r8) {
        if (r8.hasAnyOfTheFlags(524) || !r8.isBound()) {
            return -1;
        }
        C2326 k = this.mAdapterHelper;
        int i = r8.mPosition;
        int size = k.f8047.size();
        for (int i2 = 0; i2 < size; i2++) {
            C2326.C2327 r4 = k.f8047.get(i2);
            int i3 = r4.f8055;
            if (i3 != 1) {
                if (i3 == 2) {
                    int i4 = r4.f8054;
                    if (i4 <= i) {
                        int i5 = r4.f8056;
                        if (i4 + i5 > i) {
                            return -1;
                        }
                        i -= i5;
                    } else {
                        continue;
                    }
                } else if (i3 == 8) {
                    int i6 = r4.f8054;
                    if (i6 == i) {
                        i = r4.f8056;
                    } else {
                        if (i6 < i) {
                            i--;
                        }
                        if (r4.f8056 <= i) {
                            i++;
                        }
                    }
                }
            } else if (r4.f8054 <= i) {
                i += r4.f8056;
            }
        }
        return i;
    }

    public int getBaseline() {
        AbstractC0254 r0 = this.mLayout;
        if (r0 != null) {
            return r0.getBaseline();
        }
        return super.getBaseline();
    }

    public long getChangedHolderKey(AbstractC0269 r3) {
        return this.mAdapter.hasStableIds() ? r3.getItemId() : (long) r3.mPosition;
    }

    public int getChildAdapterPosition(View view) {
        AbstractC0269 childViewHolderInt = getChildViewHolderInt(view);
        if (childViewHolderInt != null) {
            return childViewHolderInt.getAdapterPosition();
        }
        return -1;
    }

    public int getChildDrawingOrder(int i, int i2) {
        return super.getChildDrawingOrder(i, i2);
    }

    public long getChildItemId(View view) {
        AbstractC0269 childViewHolderInt;
        AbstractC0246 r0 = this.mAdapter;
        if (r0 == null || !r0.hasStableIds() || (childViewHolderInt = getChildViewHolderInt(view)) == null) {
            return -1;
        }
        return childViewHolderInt.getItemId();
    }

    public int getChildLayoutPosition(View view) {
        AbstractC0269 childViewHolderInt = getChildViewHolderInt(view);
        if (childViewHolderInt != null) {
            return childViewHolderInt.getLayoutPosition();
        }
        return -1;
    }

    @Deprecated
    public int getChildPosition(View view) {
        return getChildAdapterPosition(view);
    }

    public AbstractC0269 getChildViewHolder(View view) {
        ViewParent parent = view.getParent();
        if (parent == null || parent == this) {
            return getChildViewHolderInt(view);
        }
        throw new IllegalArgumentException("View " + view + " is not a direct child of " + this);
    }

    public boolean getClipToPadding() {
        return this.mClipToPadding;
    }

    public C2304 getCompatAccessibilityDelegate() {
        return this.mAccessibilityDelegate;
    }

    public void getDecoratedBoundsWithMargins(View view, Rect rect) {
        getDecoratedBoundsWithMarginsInt(view, rect);
    }

    public C0243 getEdgeEffectFactory() {
        return this.mEdgeEffectFactory;
    }

    public AbstractC0250 getItemAnimator() {
        return this.mItemAnimator;
    }

    public Rect getItemDecorInsetsForChild(View view) {
        C0235 r0 = (C0235) view.getLayoutParams();
        if (!r0.f1481) {
            return r0.f1482;
        }
        if (this.mState.f1510 && (r0.m810() || r0.f1483.isInvalid())) {
            return r0.f1482;
        }
        Rect rect = r0.f1482;
        rect.set(0, 0, 0, 0);
        int size = this.mItemDecorations.size();
        for (int i = 0; i < size; i++) {
            this.mTempRect.set(0, 0, 0, 0);
            this.mItemDecorations.get(i).getItemOffsets(this.mTempRect, view, this, this.mState);
            int i2 = rect.left;
            Rect rect2 = this.mTempRect;
            rect.left = i2 + rect2.left;
            rect.top += rect2.top;
            rect.right += rect2.right;
            rect.bottom += rect2.bottom;
        }
        r0.f1481 = false;
        return rect;
    }

    public AbstractC0232 getItemDecorationAt(int i) {
        int itemDecorationCount = getItemDecorationCount();
        if (i >= 0 && i < itemDecorationCount) {
            return this.mItemDecorations.get(i);
        }
        throw new IndexOutOfBoundsException(i + " is an invalid index for size " + itemDecorationCount);
    }

    public int getItemDecorationCount() {
        return this.mItemDecorations.size();
    }

    public AbstractC0254 getLayoutManager() {
        return this.mLayout;
    }

    public int getMaxFlingVelocity() {
        return this.mMaxFlingVelocity;
    }

    public int getMinFlingVelocity() {
        return this.mMinFlingVelocity;
    }

    public long getNanoTime() {
        if (ALLOW_THREAD_GAP_WORK) {
            return System.nanoTime();
        }
        return 0;
    }

    public AbstractC0259 getOnFlingListener() {
        return this.mOnFlingListener;
    }

    public boolean getPreserveFocusAfterLayout() {
        return this.mPreserveFocusAfterLayout;
    }

    public C0233 getRecycledViewPool() {
        return this.mRecycler.m859();
    }

    public int getScrollState() {
        return this.mScrollState;
    }

    public boolean hasFixedSize() {
        return this.mHasFixedSize;
    }

    public boolean hasNestedScrollingParent() {
        return getScrollingChildHelper().m4629();
    }

    public boolean hasPendingAdapterUpdates() {
        return !this.mFirstLayoutComplete || this.mDataSetHasChangedAfterLayout || this.mAdapterHelper.m6080();
    }

    public void initAdapterManager() {
        this.mAdapterHelper = new C2326(new C0263());
    }

    public void initFastScroller(StateListDrawable stateListDrawable, Drawable drawable, StateListDrawable stateListDrawable2, Drawable drawable2) {
        if (stateListDrawable == null || drawable == null || stateListDrawable2 == null || drawable2 == null) {
            throw new IllegalArgumentException(C1293.m3407(this, C1293.m3416("Trying to set fast scroller without both required drawables.")));
        }
        Resources resources = getContext().getResources();
        new C2338(this, stateListDrawable, drawable, stateListDrawable2, drawable2, resources.getDimensionPixelSize(R$dimen.fastscroll_default_thickness), resources.getDimensionPixelSize(R$dimen.fastscroll_minimum_range), resources.getDimensionPixelOffset(R$dimen.fastscroll_margin));
    }

    public void invalidateGlows() {
        this.mBottomGlow = null;
        this.mTopGlow = null;
        this.mRightGlow = null;
        this.mLeftGlow = null;
    }

    public void invalidateItemDecorations() {
        if (this.mItemDecorations.size() != 0) {
            AbstractC0254 r0 = this.mLayout;
            if (r0 != null) {
                r0.assertNotInLayoutOrScroll("Cannot invalidate item decorations during a scroll or layout");
            }
            markItemDecorInsetsDirty();
            requestLayout();
        }
    }

    public boolean isAccessibilityEnabled() {
        AccessibilityManager accessibilityManager = this.mAccessibilityManager;
        return accessibilityManager != null && accessibilityManager.isEnabled();
    }

    public boolean isAnimating() {
        AbstractC0250 r0 = this.mItemAnimator;
        return r0 != null && r0.m837();
    }

    public boolean isAttachedToWindow() {
        return this.mIsAttached;
    }

    public boolean isComputingLayout() {
        return this.mLayoutOrScrollCounter > 0;
    }

    @Deprecated
    public boolean isLayoutFrozen() {
        return isLayoutSuppressed();
    }

    public final boolean isLayoutSuppressed() {
        return this.mLayoutSuppressed;
    }

    public boolean isNestedScrollingEnabled() {
        return getScrollingChildHelper().f6118;
    }

    public void jumpToPositionForSmoothScroller(int i) {
        if (this.mLayout != null) {
            setScrollState(2);
            this.mLayout.scrollToPosition(i);
            awakenScrollBars();
        }
    }

    public void markItemDecorInsetsDirty() {
        int r0 = this.mChildHelper.m6049();
        for (int i = 0; i < r0; i++) {
            ((C0235) this.mChildHelper.m6057(i).getLayoutParams()).f1481 = true;
        }
        C0264 r02 = this.mRecycler;
        int size = r02.f1535.size();
        for (int i2 = 0; i2 < size; i2++) {
            C0235 r4 = (C0235) r02.f1535.get(i2).itemView.getLayoutParams();
            if (r4 != null) {
                r4.f1481 = true;
            }
        }
    }

    public void markKnownViewsInvalid() {
        int r0 = this.mChildHelper.m6049();
        for (int i = 0; i < r0; i++) {
            AbstractC0269 childViewHolderInt = getChildViewHolderInt(this.mChildHelper.m6057(i));
            if (childViewHolderInt != null && !childViewHolderInt.shouldIgnore()) {
                childViewHolderInt.addFlags(6);
            }
        }
        markItemDecorInsetsDirty();
        C0264 r02 = this.mRecycler;
        int size = r02.f1535.size();
        for (int i2 = 0; i2 < size; i2++) {
            AbstractC0269 r4 = r02.f1535.get(i2);
            if (r4 != null) {
                r4.addFlags(6);
                r4.addChangePayload(null);
            }
        }
        AbstractC0246 r1 = RecyclerView.this.mAdapter;
        if (r1 == null || !r1.hasStableIds()) {
            r02.m857();
        }
    }

    public void offsetChildrenHorizontal(int i) {
        int r0 = this.mChildHelper.m6052();
        for (int i2 = 0; i2 < r0; i2++) {
            this.mChildHelper.m6050(i2).offsetLeftAndRight(i);
        }
    }

    public void offsetChildrenVertical(int i) {
        int r0 = this.mChildHelper.m6052();
        for (int i2 = 0; i2 < r0; i2++) {
            this.mChildHelper.m6050(i2).offsetTopAndBottom(i);
        }
    }

    public void offsetPositionRecordsForInsert(int i, int i2) {
        int r0 = this.mChildHelper.m6049();
        for (int i3 = 0; i3 < r0; i3++) {
            AbstractC0269 childViewHolderInt = getChildViewHolderInt(this.mChildHelper.m6057(i3));
            if (childViewHolderInt != null && !childViewHolderInt.shouldIgnore() && childViewHolderInt.mPosition >= i) {
                childViewHolderInt.offsetPosition(i2, false);
                this.mState.f1503 = true;
            }
        }
        C0264 r02 = this.mRecycler;
        int size = r02.f1535.size();
        for (int i4 = 0; i4 < size; i4++) {
            AbstractC0269 r4 = r02.f1535.get(i4);
            if (r4 != null && r4.mPosition >= i) {
                r4.offsetPosition(i2, true);
            }
        }
        requestLayout();
    }

    public void offsetPositionRecordsForMove(int i, int i2) {
        int i3;
        int i4;
        int i5;
        int i6;
        int i7;
        int i8;
        int i9;
        int i10;
        int r0 = this.mChildHelper.m6049();
        if (i < i2) {
            i5 = i;
            i4 = i2;
            i3 = -1;
        } else {
            i4 = i;
            i5 = i2;
            i3 = 1;
        }
        for (int i11 = 0; i11 < r0; i11++) {
            AbstractC0269 childViewHolderInt = getChildViewHolderInt(this.mChildHelper.m6057(i11));
            if (childViewHolderInt != null && (i10 = childViewHolderInt.mPosition) >= i5 && i10 <= i4) {
                if (i10 == i) {
                    childViewHolderInt.offsetPosition(i2 - i, false);
                } else {
                    childViewHolderInt.offsetPosition(i3, false);
                }
                this.mState.f1503 = true;
            }
        }
        C0264 r02 = this.mRecycler;
        if (i < i2) {
            i8 = i;
            i7 = i2;
            i6 = -1;
        } else {
            i7 = i;
            i8 = i2;
            i6 = 1;
        }
        int size = r02.f1535.size();
        for (int i12 = 0; i12 < size; i12++) {
            AbstractC0269 r7 = r02.f1535.get(i12);
            if (r7 != null && (i9 = r7.mPosition) >= i8 && i9 <= i7) {
                if (i9 == i) {
                    r7.offsetPosition(i2 - i, false);
                } else {
                    r7.offsetPosition(i6, false);
                }
            }
        }
        requestLayout();
    }

    public void offsetPositionRecordsForRemove(int i, int i2, boolean z) {
        int i3 = i + i2;
        int r1 = this.mChildHelper.m6049();
        for (int i4 = 0; i4 < r1; i4++) {
            AbstractC0269 childViewHolderInt = getChildViewHolderInt(this.mChildHelper.m6057(i4));
            if (childViewHolderInt != null && !childViewHolderInt.shouldIgnore()) {
                int i5 = childViewHolderInt.mPosition;
                if (i5 >= i3) {
                    childViewHolderInt.offsetPosition(-i2, z);
                    this.mState.f1503 = true;
                } else if (i5 >= i) {
                    childViewHolderInt.flagRemovedAndOffsetPosition(i - 1, -i2, z);
                    this.mState.f1503 = true;
                }
            }
        }
        C0264 r12 = this.mRecycler;
        int size = r12.f1535.size();
        while (true) {
            size--;
            if (size >= 0) {
                AbstractC0269 r3 = r12.f1535.get(size);
                if (r3 != null) {
                    int i6 = r3.mPosition;
                    if (i6 >= i3) {
                        r3.offsetPosition(-i2, z);
                    } else if (i6 >= i) {
                        r3.addFlags(8);
                        r12.m860(size);
                    }
                }
            } else {
                requestLayout();
                return;
            }
        }
    }

    /* JADX WARNING: Code restructure failed: missing block: B:16:0x004f, code lost:
        if (r0 >= 30.0f) goto L_0x0054;
     */
    public void onAttachedToWindow() {
        float f;
        super.onAttachedToWindow();
        this.mLayoutOrScrollCounter = 0;
        boolean z = true;
        this.mIsAttached = true;
        if (!this.mFirstLayoutComplete || isLayoutRequested()) {
            z = false;
        }
        this.mFirstLayoutComplete = z;
        AbstractC0254 r1 = this.mLayout;
        if (r1 != null) {
            r1.dispatchAttachedToWindow(this);
        }
        this.mPostedAnimatorRunner = false;
        if (ALLOW_THREAD_GAP_WORK) {
            this.mGapWorker = RunnableC2312.f7985.get();
            if (this.mGapWorker == null) {
                this.mGapWorker = new RunnableC2312();
                Display r0 = C1729.m4508(this);
                if (!isInEditMode() && r0 != null) {
                    f = r0.getRefreshRate();
                }
                f = 60.0f;
                RunnableC2312 r12 = this.mGapWorker;
                r12.f7989 = (long) (1.0E9f / f);
                RunnableC2312.f7985.set(r12);
            }
            this.mGapWorker.f7988.add(this);
        }
    }

    public void onChildAttachedToWindow(View view) {
    }

    public void onChildDetachedFromWindow(View view) {
    }

    public void onDetachedFromWindow() {
        RunnableC2312 r0;
        super.onDetachedFromWindow();
        AbstractC0250 r02 = this.mItemAnimator;
        if (r02 != null) {
            r02.m829();
        }
        stopScroll();
        this.mIsAttached = false;
        AbstractC0254 r03 = this.mLayout;
        if (r03 != null) {
            r03.dispatchDetachedFromWindow(this, this.mRecycler);
        }
        this.mPendingAccessibilityImportanceChange.clear();
        removeCallbacks(this.mItemAnimatorRunner);
        this.mViewInfoStore.m6034();
        if (ALLOW_THREAD_GAP_WORK && (r0 = this.mGapWorker) != null) {
            r0.f7988.remove(this);
            this.mGapWorker = null;
        }
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int size = this.mItemDecorations.size();
        for (int i = 0; i < size; i++) {
            this.mItemDecorations.get(i).onDraw(canvas, this, this.mState);
        }
    }

    public void onEnterLayoutOrScroll() {
        this.mLayoutOrScrollCounter++;
    }

    public void onExitLayoutOrScroll() {
        onExitLayoutOrScroll(true);
    }

    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        float f;
        float f2;
        if (this.mLayout != null && !this.mLayoutSuppressed && motionEvent.getAction() == 8) {
            if ((motionEvent.getSource() & 2) != 0) {
                f2 = this.mLayout.canScrollVertically() ? -motionEvent.getAxisValue(9) : 0.0f;
                if (this.mLayout.canScrollHorizontally()) {
                    f = motionEvent.getAxisValue(10);
                    if (!(f2 == 0.0f && f == 0.0f)) {
                        scrollByInternal((int) (f * this.mScaledHorizontalScrollFactor), (int) (f2 * this.mScaledVerticalScrollFactor), motionEvent);
                    }
                }
            } else {
                if ((motionEvent.getSource() & 4194304) != 0) {
                    float axisValue = motionEvent.getAxisValue(26);
                    if (this.mLayout.canScrollVertically()) {
                        f2 = -axisValue;
                    } else if (this.mLayout.canScrollHorizontally()) {
                        f = axisValue;
                        f2 = 0.0f;
                        scrollByInternal((int) (f * this.mScaledHorizontalScrollFactor), (int) (f2 * this.mScaledVerticalScrollFactor), motionEvent);
                    }
                }
                f2 = 0.0f;
            }
            f = 0.0f;
            scrollByInternal((int) (f * this.mScaledHorizontalScrollFactor), (int) (f2 * this.mScaledVerticalScrollFactor), motionEvent);
        }
        return false;
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        boolean z;
        if (this.mLayoutSuppressed) {
            return false;
        }
        this.mInterceptingOnItemTouchListener = null;
        if (findInterceptingOnItemTouchListener(motionEvent)) {
            cancelScroll();
            return true;
        }
        AbstractC0254 r0 = this.mLayout;
        if (r0 == null) {
            return false;
        }
        boolean canScrollHorizontally = r0.canScrollHorizontally();
        boolean canScrollVertically = this.mLayout.canScrollVertically();
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(motionEvent);
        int actionMasked = motionEvent.getActionMasked();
        int actionIndex = motionEvent.getActionIndex();
        if (actionMasked == 0) {
            if (this.mIgnoreMotionEventTillDown) {
                this.mIgnoreMotionEventTillDown = false;
            }
            this.mScrollPointerId = motionEvent.getPointerId(0);
            int x = (int) (motionEvent.getX() + 0.5f);
            this.mLastTouchX = x;
            this.mInitialTouchX = x;
            int y = (int) (motionEvent.getY() + 0.5f);
            this.mLastTouchY = y;
            this.mInitialTouchY = y;
            if (this.mScrollState == 2) {
                getParent().requestDisallowInterceptTouchEvent(true);
                setScrollState(1);
                stopNestedScroll(1);
            }
            int[] iArr = this.mNestedOffsets;
            iArr[1] = 0;
            iArr[0] = 0;
            int i = canScrollHorizontally ? 1 : 0;
            if (canScrollVertically) {
                i |= 2;
            }
            startNestedScroll(i, 0);
        } else if (actionMasked == 1) {
            this.mVelocityTracker.clear();
            stopNestedScroll(0);
        } else if (actionMasked == 2) {
            int findPointerIndex = motionEvent.findPointerIndex(this.mScrollPointerId);
            if (findPointerIndex < 0) {
                StringBuilder r9 = C1293.m3416("Error processing scroll; pointer index for id ");
                r9.append(this.mScrollPointerId);
                r9.append(" not found. Did any MotionEvents get skipped?");
                Log.e(TAG, r9.toString());
                return false;
            }
            int x2 = (int) (motionEvent.getX(findPointerIndex) + 0.5f);
            int y2 = (int) (motionEvent.getY(findPointerIndex) + 0.5f);
            if (this.mScrollState != 1) {
                int i2 = x2 - this.mInitialTouchX;
                int i3 = y2 - this.mInitialTouchY;
                if (!canScrollHorizontally || Math.abs(i2) <= this.mTouchSlop) {
                    z = false;
                } else {
                    this.mLastTouchX = x2;
                    z = true;
                }
                if (canScrollVertically && Math.abs(i3) > this.mTouchSlop) {
                    this.mLastTouchY = y2;
                    z = true;
                }
                if (z) {
                    setScrollState(1);
                }
            }
        } else if (actionMasked == 3) {
            cancelScroll();
        } else if (actionMasked == 5) {
            this.mScrollPointerId = motionEvent.getPointerId(actionIndex);
            int x3 = (int) (motionEvent.getX(actionIndex) + 0.5f);
            this.mLastTouchX = x3;
            this.mInitialTouchX = x3;
            int y3 = (int) (motionEvent.getY(actionIndex) + 0.5f);
            this.mLastTouchY = y3;
            this.mInitialTouchY = y3;
        } else if (actionMasked == 6) {
            onPointerUp(motionEvent);
        }
        if (this.mScrollState == 1) {
            return true;
        }
        return false;
    }

    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        C1724.m4432(TRACE_ON_LAYOUT_TAG);
        dispatchLayout();
        int i5 = Build.VERSION.SDK_INT;
        Trace.endSection();
        this.mFirstLayoutComplete = true;
    }

    public void onMeasure(int i, int i2) {
        AbstractC0254 r0 = this.mLayout;
        if (r0 == null) {
            defaultOnMeasure(i, i2);
            return;
        }
        boolean z = false;
        if (r0.isAutoMeasureEnabled()) {
            int mode = View.MeasureSpec.getMode(i);
            int mode2 = View.MeasureSpec.getMode(i2);
            this.mLayout.onMeasure(this.mRecycler, this.mState, i, i2);
            if (mode == 1073741824 && mode2 == 1073741824) {
                z = true;
            }
            if (!z && this.mAdapter != null) {
                if (this.mState.f1498 == 1) {
                    dispatchLayoutStep1();
                }
                this.mLayout.setMeasureSpecs(i, i2);
                this.mState.f1507 = true;
                dispatchLayoutStep2();
                this.mLayout.setMeasuredDimensionFromChildren(i, i2);
                if (this.mLayout.shouldMeasureTwice()) {
                    this.mLayout.setMeasureSpecs(View.MeasureSpec.makeMeasureSpec(getMeasuredWidth(), 1073741824), View.MeasureSpec.makeMeasureSpec(getMeasuredHeight(), 1073741824));
                    this.mState.f1507 = true;
                    dispatchLayoutStep2();
                    this.mLayout.setMeasuredDimensionFromChildren(i, i2);
                }
            }
        } else if (this.mHasFixedSize) {
            this.mLayout.onMeasure(this.mRecycler, this.mState, i, i2);
        } else {
            if (this.mAdapterUpdateDuringMeasure) {
                startInterceptRequestLayout();
                onEnterLayoutOrScroll();
                processAdapterUpdatesAndSetAnimationFlags();
                onExitLayoutOrScroll();
                C0248 r02 = this.mState;
                if (r02.f1505) {
                    r02.f1510 = true;
                } else {
                    this.mAdapterHelper.m6082();
                    this.mState.f1510 = false;
                }
                this.mAdapterUpdateDuringMeasure = false;
                stopInterceptRequestLayout(false);
            } else if (this.mState.f1505) {
                setMeasuredDimension(getMeasuredWidth(), getMeasuredHeight());
                return;
            }
            AbstractC0246 r03 = this.mAdapter;
            if (r03 != null) {
                this.mState.f1508 = r03.getItemCount();
            } else {
                this.mState.f1508 = 0;
            }
            startInterceptRequestLayout();
            this.mLayout.onMeasure(this.mRecycler, this.mState, i, i2);
            stopInterceptRequestLayout(false);
            this.mState.f1510 = false;
        }
    }

    public boolean onRequestFocusInDescendants(int i, Rect rect) {
        if (isComputingLayout()) {
            return false;
        }
        return super.onRequestFocusInDescendants(i, rect);
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        Parcelable parcelable2;
        if (!(parcelable instanceof SavedState)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        this.mPendingSavedState = (SavedState) parcelable;
        super.onRestoreInstanceState(this.mPendingSavedState.getSuperState());
        AbstractC0254 r2 = this.mLayout;
        if (r2 != null && (parcelable2 = this.mPendingSavedState.f1474) != null) {
            r2.onRestoreInstanceState(parcelable2);
        }
    }

    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        SavedState savedState2 = this.mPendingSavedState;
        if (savedState2 != null) {
            savedState.m802(savedState2);
        } else {
            AbstractC0254 r1 = this.mLayout;
            if (r1 != null) {
                savedState.f1474 = r1.onSaveInstanceState();
            } else {
                savedState.f1474 = null;
            }
        }
        return savedState;
    }

    public void onScrollStateChanged(int i) {
    }

    public void onScrolled(int i, int i2) {
    }

    public void onSizeChanged(int i, int i2, int i3, int i4) {
        super.onSizeChanged(i, i2, i3, i4);
        if (i != i3 || i2 != i4) {
            invalidateGlows();
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:45:0x00de  */
    /* JADX WARNING: Removed duplicated region for block: B:51:0x00f4  */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        boolean z;
        boolean z2 = false;
        if (this.mLayoutSuppressed || this.mIgnoreMotionEventTillDown) {
            return false;
        }
        if (dispatchToOnItemTouchListeners(motionEvent)) {
            cancelScroll();
            return true;
        }
        AbstractC0254 r0 = this.mLayout;
        if (r0 == null) {
            return false;
        }
        boolean canScrollHorizontally = r0.canScrollHorizontally();
        boolean canScrollVertically = this.mLayout.canScrollVertically();
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        int actionMasked = motionEvent.getActionMasked();
        int actionIndex = motionEvent.getActionIndex();
        if (actionMasked == 0) {
            int[] iArr = this.mNestedOffsets;
            iArr[1] = 0;
            iArr[0] = 0;
        }
        MotionEvent obtain = MotionEvent.obtain(motionEvent);
        int[] iArr2 = this.mNestedOffsets;
        obtain.offsetLocation((float) iArr2[0], (float) iArr2[1]);
        if (actionMasked == 0) {
            this.mScrollPointerId = motionEvent.getPointerId(0);
            int x = (int) (motionEvent.getX() + 0.5f);
            this.mLastTouchX = x;
            this.mInitialTouchX = x;
            int y = (int) (motionEvent.getY() + 0.5f);
            this.mLastTouchY = y;
            this.mInitialTouchY = y;
            int i = canScrollHorizontally ? 1 : 0;
            if (canScrollVertically) {
                i |= 2;
            }
            startNestedScroll(i, 0);
        } else if (actionMasked == 1) {
            this.mVelocityTracker.addMovement(obtain);
            this.mVelocityTracker.computeCurrentVelocity(1000, (float) this.mMaxFlingVelocity);
            float f = canScrollHorizontally ? -this.mVelocityTracker.getXVelocity(this.mScrollPointerId) : 0.0f;
            float f2 = canScrollVertically ? -this.mVelocityTracker.getYVelocity(this.mScrollPointerId) : 0.0f;
            if ((f == 0.0f && f2 == 0.0f) || !fling((int) f, (int) f2)) {
                setScrollState(0);
            }
            resetScroll();
            z2 = true;
        } else if (actionMasked == 2) {
            int findPointerIndex = motionEvent.findPointerIndex(this.mScrollPointerId);
            if (findPointerIndex < 0) {
                StringBuilder r02 = C1293.m3416("Error processing scroll; pointer index for id ");
                r02.append(this.mScrollPointerId);
                r02.append(" not found. Did any MotionEvents get skipped?");
                Log.e(TAG, r02.toString());
                return false;
            }
            int x2 = (int) (motionEvent.getX(findPointerIndex) + 0.5f);
            int y2 = (int) (motionEvent.getY(findPointerIndex) + 0.5f);
            int i2 = this.mLastTouchX - x2;
            int i3 = this.mLastTouchY - y2;
            if (this.mScrollState != 1) {
                if (canScrollHorizontally) {
                    if (i2 > 0) {
                        i2 = Math.max(0, i2 - this.mTouchSlop);
                    } else {
                        i2 = Math.min(0, i2 + this.mTouchSlop);
                    }
                    if (i2 != 0) {
                        z = true;
                        if (canScrollVertically) {
                            if (i3 > 0) {
                                i3 = Math.max(0, i3 - this.mTouchSlop);
                            } else {
                                i3 = Math.min(0, i3 + this.mTouchSlop);
                            }
                            if (i3 != 0) {
                                z = true;
                            }
                        }
                        if (z) {
                            setScrollState(1);
                        }
                    }
                }
                z = false;
                if (canScrollVertically) {
                }
                if (z) {
                }
            }
            int i4 = i2;
            int i5 = i3;
            if (this.mScrollState == 1) {
                int[] iArr3 = this.mReusableIntPair;
                iArr3[0] = 0;
                iArr3[1] = 0;
                if (dispatchNestedPreScroll(canScrollHorizontally ? i4 : 0, canScrollVertically ? i5 : 0, this.mReusableIntPair, this.mScrollOffset, 0)) {
                    int[] iArr4 = this.mReusableIntPair;
                    i4 -= iArr4[0];
                    i5 -= iArr4[1];
                    int[] iArr5 = this.mNestedOffsets;
                    int i6 = iArr5[0];
                    int[] iArr6 = this.mScrollOffset;
                    iArr5[0] = i6 + iArr6[0];
                    iArr5[1] = iArr5[1] + iArr6[1];
                    getParent().requestDisallowInterceptTouchEvent(true);
                }
                int[] iArr7 = this.mScrollOffset;
                this.mLastTouchX = x2 - iArr7[0];
                this.mLastTouchY = y2 - iArr7[1];
                if (scrollByInternal(canScrollHorizontally ? i4 : 0, canScrollVertically ? i5 : 0, motionEvent)) {
                    getParent().requestDisallowInterceptTouchEvent(true);
                }
                if (!(this.mGapWorker == null || (i4 == 0 && i5 == 0))) {
                    this.mGapWorker.m6042(this, i4, i5);
                }
            }
        } else if (actionMasked == 3) {
            cancelScroll();
        } else if (actionMasked == 5) {
            this.mScrollPointerId = motionEvent.getPointerId(actionIndex);
            int x3 = (int) (motionEvent.getX(actionIndex) + 0.5f);
            this.mLastTouchX = x3;
            this.mInitialTouchX = x3;
            int y3 = (int) (motionEvent.getY(actionIndex) + 0.5f);
            this.mLastTouchY = y3;
            this.mInitialTouchY = y3;
        } else if (actionMasked == 6) {
            onPointerUp(motionEvent);
        }
        if (!z2) {
            this.mVelocityTracker.addMovement(obtain);
        }
        obtain.recycle();
        return true;
    }

    public void postAnimationRunner() {
        if (!this.mPostedAnimatorRunner && this.mIsAttached) {
            C1729.m4479(this, this.mItemAnimatorRunner);
            this.mPostedAnimatorRunner = true;
        }
    }

    public void processDataSetCompletelyChanged(boolean z) {
        this.mDispatchItemsChangedEvent = z | this.mDispatchItemsChangedEvent;
        this.mDataSetHasChangedAfterLayout = true;
        markKnownViewsInvalid();
    }

    public void recordAnimationInfoIfBouncedHiddenView(AbstractC0269 r4, AbstractC0250.C0251 r5) {
        r4.setFlags(0, 8192);
        if (this.mState.f1501 && r4.isUpdated() && !r4.isRemoved() && !r4.shouldIgnore()) {
            this.mViewInfoStore.f7968.m5914(getChangedHolderKey(r4), r4);
        }
        this.mViewInfoStore.m6031(r4, r5);
    }

    public void removeAndRecycleViews() {
        AbstractC0250 r0 = this.mItemAnimator;
        if (r0 != null) {
            r0.m829();
        }
        AbstractC0254 r02 = this.mLayout;
        if (r02 != null) {
            r02.removeAndRecycleAllViews(this.mRecycler);
            this.mLayout.removeAndRecycleScrapInt(this.mRecycler);
        }
        this.mRecycler.m865();
    }

    public boolean removeAnimatingView(View view) {
        startInterceptRequestLayout();
        C2316 r0 = this.mChildHelper;
        int indexOfChild = RecyclerView.this.indexOfChild(view);
        boolean z = true;
        if (indexOfChild == -1) {
            r0.m6047(view);
        } else if (r0.f8000.m6058(indexOfChild)) {
            r0.f8000.m6065(indexOfChild);
            r0.m6047(view);
            ((C0237) r0.f8001).m813(indexOfChild);
        } else {
            z = false;
        }
        if (z) {
            AbstractC0269 childViewHolderInt = getChildViewHolderInt(view);
            this.mRecycler.m862(childViewHolderInt);
            this.mRecycler.m869(childViewHolderInt);
        }
        stopInterceptRequestLayout(!z);
        return z;
    }

    public void removeDetachedView(View view, boolean z) {
        AbstractC0269 childViewHolderInt = getChildViewHolderInt(view);
        if (childViewHolderInt != null) {
            if (childViewHolderInt.isTmpDetached()) {
                childViewHolderInt.clearTmpDetachFlag();
            } else if (!childViewHolderInt.shouldIgnore()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Called removeDetachedView with a view which is not flagged as tmp detached.");
                sb.append(childViewHolderInt);
                throw new IllegalArgumentException(C1293.m3407(this, sb));
            }
        }
        view.clearAnimation();
        dispatchChildDetached(view);
        super.removeDetachedView(view, z);
    }

    public void removeItemDecoration(AbstractC0232 r3) {
        AbstractC0254 r0 = this.mLayout;
        if (r0 != null) {
            r0.assertNotInLayoutOrScroll("Cannot remove item decoration during a scroll  or layout");
        }
        this.mItemDecorations.remove(r3);
        if (this.mItemDecorations.isEmpty()) {
            setWillNotDraw(getOverScrollMode() == 2);
        }
        markItemDecorInsetsDirty();
        requestLayout();
    }

    public void removeItemDecorationAt(int i) {
        int itemDecorationCount = getItemDecorationCount();
        if (i < 0 || i >= itemDecorationCount) {
            throw new IndexOutOfBoundsException(i + " is an invalid index for size " + itemDecorationCount);
        }
        removeItemDecoration(getItemDecorationAt(i));
    }

    public void removeOnChildAttachStateChangeListener(AbstractC0242 r2) {
        List<AbstractC0242> list = this.mOnChildAttachStateListeners;
        if (list != null) {
            list.remove(r2);
        }
    }

    public void removeOnItemTouchListener(AbstractC0236 r2) {
        this.mOnItemTouchListeners.remove(r2);
        if (this.mInterceptingOnItemTouchListener == r2) {
            this.mInterceptingOnItemTouchListener = null;
        }
    }

    public void removeOnScrollListener(AbstractC0267 r2) {
        List<AbstractC0267> list = this.mScrollListeners;
        if (list != null) {
            list.remove(r2);
        }
    }

    public void repositionShadowingViews() {
        AbstractC0269 r3;
        int r0 = this.mChildHelper.m6052();
        for (int i = 0; i < r0; i++) {
            View r2 = this.mChildHelper.m6050(i);
            AbstractC0269 childViewHolder = getChildViewHolder(r2);
            if (!(childViewHolder == null || (r3 = childViewHolder.mShadowingHolder) == null)) {
                View view = r3.itemView;
                int left = r2.getLeft();
                int top2 = r2.getTop();
                if (left != view.getLeft() || top2 != view.getTop()) {
                    view.layout(left, top2, view.getWidth() + left, view.getHeight() + top2);
                }
            }
        }
    }

    public void requestChildFocus(View view, View view2) {
        if (!this.mLayout.onRequestChildFocus(this, this.mState, view, view2) && view2 != null) {
            requestChildOnScreen(view, view2);
        }
        super.requestChildFocus(view, view2);
    }

    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean z) {
        return this.mLayout.requestChildRectangleOnScreen(this, view, rect, z);
    }

    public void requestDisallowInterceptTouchEvent(boolean z) {
        int size = this.mOnItemTouchListeners.size();
        for (int i = 0; i < size; i++) {
            ((C2338) this.mOnItemTouchListeners.get(i)).m6131(z);
        }
        super.requestDisallowInterceptTouchEvent(z);
    }

    public void requestLayout() {
        if (this.mInterceptRequestLayoutDepth != 0 || this.mLayoutSuppressed) {
            this.mLayoutWasDefered = true;
        } else {
            super.requestLayout();
        }
    }

    public void saveOldPositions() {
        int r0 = this.mChildHelper.m6049();
        for (int i = 0; i < r0; i++) {
            AbstractC0269 childViewHolderInt = getChildViewHolderInt(this.mChildHelper.m6057(i));
            if (!childViewHolderInt.shouldIgnore()) {
                childViewHolderInt.saveOldPosition();
            }
        }
    }

    public void scrollBy(int i, int i2) {
        AbstractC0254 r0 = this.mLayout;
        if (r0 == null) {
            Log.e(TAG, "Cannot scroll without a LayoutManager set. Call setLayoutManager with a non-null argument.");
        } else if (!this.mLayoutSuppressed) {
            boolean canScrollHorizontally = r0.canScrollHorizontally();
            boolean canScrollVertically = this.mLayout.canScrollVertically();
            if (canScrollHorizontally || canScrollVertically) {
                if (!canScrollHorizontally) {
                    i = 0;
                }
                if (!canScrollVertically) {
                    i2 = 0;
                }
                scrollByInternal(i, i2, null);
            }
        }
    }

    public boolean scrollByInternal(int i, int i2, MotionEvent motionEvent) {
        int i3;
        int i4;
        int i5;
        int i6;
        consumePendingUpdateOperations();
        if (this.mAdapter != null) {
            int[] iArr = this.mReusableIntPair;
            iArr[0] = 0;
            iArr[1] = 0;
            scrollStep(i, i2, iArr);
            int[] iArr2 = this.mReusableIntPair;
            int i7 = iArr2[0];
            int i8 = iArr2[1];
            i5 = i8;
            i6 = i7;
            i4 = i - i7;
            i3 = i2 - i8;
        } else {
            i6 = 0;
            i5 = 0;
            i4 = 0;
            i3 = 0;
        }
        if (!this.mItemDecorations.isEmpty()) {
            invalidate();
        }
        int[] iArr3 = this.mReusableIntPair;
        iArr3[0] = 0;
        iArr3[1] = 0;
        dispatchNestedScroll(i6, i5, i4, i3, this.mScrollOffset, 0, iArr3);
        int[] iArr4 = this.mReusableIntPair;
        int i9 = i4 - iArr4[0];
        int i10 = i3 - iArr4[1];
        boolean z = (iArr4[0] == 0 && iArr4[1] == 0) ? false : true;
        int i11 = this.mLastTouchX;
        int[] iArr5 = this.mScrollOffset;
        this.mLastTouchX = i11 - iArr5[0];
        this.mLastTouchY -= iArr5[1];
        int[] iArr6 = this.mNestedOffsets;
        iArr6[0] = iArr6[0] + iArr5[0];
        iArr6[1] = iArr6[1] + iArr5[1];
        if (getOverScrollMode() != 2) {
            if (motionEvent != null) {
                if (!((motionEvent.getSource() & 8194) == 8194)) {
                    pullGlows(motionEvent.getX(), (float) i9, motionEvent.getY(), (float) i10);
                }
            }
            considerReleasingGlowsOnScroll(i, i2);
        }
        if (!(i6 == 0 && i5 == 0)) {
            dispatchOnScrolled(i6, i5);
        }
        if (!awakenScrollBars()) {
            invalidate();
        }
        if (!z && i6 == 0 && i5 == 0) {
            return false;
        }
        return true;
    }

    public void scrollStep(int i, int i2, int[] iArr) {
        startInterceptRequestLayout();
        onEnterLayoutOrScroll();
        C1724.m4432(TRACE_SCROLL_TAG);
        fillRemainingScrollValues(this.mState);
        int scrollHorizontallyBy = i != 0 ? this.mLayout.scrollHorizontallyBy(i, this.mRecycler, this.mState) : 0;
        int scrollVerticallyBy = i2 != 0 ? this.mLayout.scrollVerticallyBy(i2, this.mRecycler, this.mState) : 0;
        int i3 = Build.VERSION.SDK_INT;
        Trace.endSection();
        repositionShadowingViews();
        onExitLayoutOrScroll();
        stopInterceptRequestLayout(false);
        if (iArr != null) {
            iArr[0] = scrollHorizontallyBy;
            iArr[1] = scrollVerticallyBy;
        }
    }

    public void scrollTo(int i, int i2) {
        Log.w(TAG, "RecyclerView does not support scrolling to an absolute position. Use scrollToPosition instead");
    }

    public void scrollToPosition(int i) {
        if (!this.mLayoutSuppressed) {
            stopScroll();
            AbstractC0254 r0 = this.mLayout;
            if (r0 == null) {
                Log.e(TAG, "Cannot scroll to position a LayoutManager set. Call setLayoutManager with a non-null argument.");
                return;
            }
            r0.scrollToPosition(i);
            awakenScrollBars();
        }
    }

    public void sendAccessibilityEventUnchecked(AccessibilityEvent accessibilityEvent) {
        if (!shouldDeferAccessibilityEvent(accessibilityEvent)) {
            super.sendAccessibilityEventUnchecked(accessibilityEvent);
        }
    }

    public void setAccessibilityDelegateCompat(C2304 r1) {
        this.mAccessibilityDelegate = r1;
        C1729.m4482(this, this.mAccessibilityDelegate);
    }

    public void setAdapter(AbstractC0246 r3) {
        setLayoutFrozen(false);
        setAdapterInternal(r3, false, true);
        processDataSetCompletelyChanged(false);
        requestLayout();
    }

    public void setChildDrawingOrderCallback(AbstractC0261 r1) {
        if (r1 != null) {
            setChildrenDrawingOrderEnabled(false);
        }
    }

    public boolean setChildImportantForAccessibilityInternal(AbstractC0269 r2, int i) {
        if (isComputingLayout()) {
            r2.mPendingAccessibilityState = i;
            this.mPendingAccessibilityImportanceChange.add(r2);
            return false;
        }
        C1729.m4457(r2.itemView, i);
        return true;
    }

    public void setClipToPadding(boolean z) {
        if (z != this.mClipToPadding) {
            invalidateGlows();
        }
        this.mClipToPadding = z;
        super.setClipToPadding(z);
        if (this.mFirstLayoutComplete) {
            requestLayout();
        }
    }

    public void setEdgeEffectFactory(C0243 r1) {
        if (r1 != null) {
            this.mEdgeEffectFactory = r1;
            invalidateGlows();
            return;
        }
        throw new NullPointerException();
    }

    public void setHasFixedSize(boolean z) {
        this.mHasFixedSize = z;
    }

    public void setItemAnimator(AbstractC0250 r3) {
        AbstractC0250 r0 = this.mItemAnimator;
        if (r0 != null) {
            r0.m829();
            this.mItemAnimator.f1515 = null;
        }
        this.mItemAnimator = r3;
        AbstractC0250 r32 = this.mItemAnimator;
        if (r32 != null) {
            r32.f1515 = this.mItemAnimatorListener;
        }
    }

    public void setItemViewCacheSize(int i) {
        C0264 r0 = this.mRecycler;
        r0.f1536 = i;
        r0.m871();
    }

    @Deprecated
    public void setLayoutFrozen(boolean z) {
        suppressLayout(z);
    }

    public void setLayoutManager(AbstractC0254 r6) {
        if (r6 != this.mLayout) {
            stopScroll();
            if (this.mLayout != null) {
                AbstractC0250 r0 = this.mItemAnimator;
                if (r0 != null) {
                    r0.m829();
                }
                this.mLayout.removeAndRecycleAllViews(this.mRecycler);
                this.mLayout.removeAndRecycleScrapInt(this.mRecycler);
                this.mRecycler.m865();
                if (this.mIsAttached) {
                    this.mLayout.dispatchDetachedFromWindow(this, this.mRecycler);
                }
                this.mLayout.setRecyclerView(null);
                this.mLayout = null;
            } else {
                this.mRecycler.m865();
            }
            C2316 r02 = this.mChildHelper;
            r02.f8000.m6061();
            int size = r02.f7999.size();
            while (true) {
                size--;
                if (size < 0) {
                    break;
                }
                ((C0237) r02.f8001).m812(r02.f7999.get(size));
                r02.f7999.remove(size);
            }
            C0237 r03 = (C0237) r02.f8001;
            int r1 = r03.m815();
            for (int i = 0; i < r1; i++) {
                View r3 = r03.m816(i);
                RecyclerView.this.dispatchChildDetached(r3);
                r3.clearAnimation();
            }
            RecyclerView.this.removeAllViews();
            this.mLayout = r6;
            if (r6 != null) {
                if (r6.mRecyclerView == null) {
                    this.mLayout.setRecyclerView(this);
                    if (this.mIsAttached) {
                        this.mLayout.dispatchAttachedToWindow(this);
                    }
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append("LayoutManager ");
                    sb.append(r6);
                    sb.append(" is already attached to a RecyclerView:");
                    throw new IllegalArgumentException(C1293.m3407(r6.mRecyclerView, sb));
                }
            }
            this.mRecycler.m871();
            requestLayout();
        }
    }

    @Deprecated
    public void setLayoutTransition(LayoutTransition layoutTransition) {
        int i = Build.VERSION.SDK_INT;
        if (layoutTransition == null) {
            super.setLayoutTransition(null);
            return;
        }
        throw new IllegalArgumentException("Providing a LayoutTransition into RecyclerView is not supported. Please use setItemAnimator() instead for animating changes to the items in this RecyclerView");
    }

    public void setNestedScrollingEnabled(boolean z) {
        C1775 scrollingChildHelper = getScrollingChildHelper();
        if (scrollingChildHelper.f6118) {
            C1729.m4441(scrollingChildHelper.f6114);
        }
        scrollingChildHelper.f6118 = z;
    }

    public void setOnFlingListener(AbstractC0259 r1) {
        this.mOnFlingListener = r1;
    }

    @Deprecated
    public void setOnScrollListener(AbstractC0267 r1) {
        this.mScrollListener = r1;
    }

    public void setPreserveFocusAfterLayout(boolean z) {
        this.mPreserveFocusAfterLayout = z;
    }

    public void setRecycledViewPool(C0233 r3) {
        C0264 r0 = this.mRecycler;
        C0233 r1 = r0.f1538;
        if (r1 != null) {
            r1.m803();
        }
        r0.f1538 = r3;
        if (r0.f1538 != null && RecyclerView.this.getAdapter() != null) {
            r0.f1538.m806();
        }
    }

    public void setRecyclerListener(AbstractC0241 r1) {
    }

    public void setScrollState(int i) {
        if (i != this.mScrollState) {
            this.mScrollState = i;
            if (i != 2) {
                stopScrollersInternal();
            }
            dispatchOnScrollStateChanged(i);
        }
    }

    public void setScrollingTouchSlop(int i) {
        ViewConfiguration viewConfiguration = ViewConfiguration.get(getContext());
        if (i != 0) {
            if (i != 1) {
                Log.w(TAG, "setScrollingTouchSlop(): bad argument constant " + i + "; using default value");
            } else {
                this.mTouchSlop = viewConfiguration.getScaledPagingTouchSlop();
                return;
            }
        }
        this.mTouchSlop = viewConfiguration.getScaledTouchSlop();
    }

    public void setViewCacheExtension(AbstractC0249 r2) {
        this.mRecycler.m868(r2);
    }

    public boolean shouldDeferAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        int i;
        if (!isComputingLayout()) {
            return false;
        }
        if (accessibilityEvent != null) {
            int i2 = Build.VERSION.SDK_INT;
            i = accessibilityEvent.getContentChangeTypes();
        } else {
            i = 0;
        }
        if (i == 0) {
            i = 0;
        }
        this.mEatenAccessibilityChangeFlags = i | this.mEatenAccessibilityChangeFlags;
        return true;
    }

    public void smoothScrollBy(int i, int i2) {
        smoothScrollBy(i, i2, null);
    }

    public void smoothScrollToPosition(int i) {
        if (!this.mLayoutSuppressed) {
            AbstractC0254 r0 = this.mLayout;
            if (r0 == null) {
                Log.e(TAG, "Cannot smooth scroll without a LayoutManager set. Call setLayoutManager with a non-null argument.");
            } else {
                r0.smoothScrollToPosition(this, this.mState, i);
            }
        }
    }

    public void startInterceptRequestLayout() {
        this.mInterceptRequestLayoutDepth++;
        if (this.mInterceptRequestLayoutDepth == 1 && !this.mLayoutSuppressed) {
            this.mLayoutWasDefered = false;
        }
    }

    public boolean startNestedScroll(int i) {
        return getScrollingChildHelper().m4632(i, 0);
    }

    public void stopInterceptRequestLayout(boolean z) {
        if (this.mInterceptRequestLayoutDepth < 1) {
            this.mInterceptRequestLayoutDepth = 1;
        }
        if (!z && !this.mLayoutSuppressed) {
            this.mLayoutWasDefered = false;
        }
        if (this.mInterceptRequestLayoutDepth == 1) {
            if (z && this.mLayoutWasDefered && !this.mLayoutSuppressed && this.mLayout != null && this.mAdapter != null) {
                dispatchLayout();
            }
            if (!this.mLayoutSuppressed) {
                this.mLayoutWasDefered = false;
            }
        }
        this.mInterceptRequestLayoutDepth--;
    }

    public void stopNestedScroll() {
        getScrollingChildHelper().m4624(0);
    }

    public void stopScroll() {
        setScrollState(0);
        stopScrollersInternal();
    }

    public final void suppressLayout(boolean z) {
        if (z != this.mLayoutSuppressed) {
            assertNotInLayoutOrScroll("Do not suppressLayout in layout or scroll");
            if (!z) {
                this.mLayoutSuppressed = false;
                if (!(!this.mLayoutWasDefered || this.mLayout == null || this.mAdapter == null)) {
                    requestLayout();
                }
                this.mLayoutWasDefered = false;
                return;
            }
            long uptimeMillis = SystemClock.uptimeMillis();
            onTouchEvent(MotionEvent.obtain(uptimeMillis, uptimeMillis, 3, 0.0f, 0.0f, 0));
            this.mLayoutSuppressed = true;
            this.mIgnoreMotionEventTillDown = true;
            stopScroll();
        }
    }

    public void swapAdapter(AbstractC0246 r2, boolean z) {
        setLayoutFrozen(false);
        setAdapterInternal(r2, true, z);
        processDataSetCompletelyChanged(true);
        requestLayout();
    }

    public void viewRangeUpdate(int i, int i2, Object obj) {
        int i3;
        int i4;
        int r0 = this.mChildHelper.m6049();
        int i5 = i2 + i;
        for (int i6 = 0; i6 < r0; i6++) {
            View r3 = this.mChildHelper.m6057(i6);
            AbstractC0269 childViewHolderInt = getChildViewHolderInt(r3);
            if (childViewHolderInt != null && !childViewHolderInt.shouldIgnore() && (i4 = childViewHolderInt.mPosition) >= i && i4 < i5) {
                childViewHolderInt.addFlags(2);
                childViewHolderInt.addChangePayload(obj);
                ((C0235) r3.getLayoutParams()).f1481 = true;
            }
        }
        C0264 r9 = this.mRecycler;
        int size = r9.f1535.size();
        while (true) {
            size--;
            if (size >= 0) {
                AbstractC0269 r1 = r9.f1535.get(size);
                if (r1 != null && (i3 = r1.mPosition) >= i && i3 < i5) {
                    r1.addFlags(2);
                    r9.m860(size);
                }
            } else {
                return;
            }
        }
    }

    /* renamed from: androidx.recyclerview.widget.RecyclerView$ⁱ  reason: contains not printable characters */
    public static abstract class AbstractC0246<VH extends AbstractC0269> {
        public boolean mHasStableIds = false;
        public final C0266 mObservable = new C0266();

        public final void bindViewHolder(VH vh, int i) {
            vh.mPosition = i;
            if (hasStableIds()) {
                vh.mItemId = getItemId(i);
            }
            vh.setFlags(1, 519);
            C1724.m4432(RecyclerView.TRACE_BIND_VIEW_TAG);
            onBindViewHolder(vh, i, vh.getUnmodifiedPayloads());
            vh.clearPayload();
            ViewGroup.LayoutParams layoutParams = vh.itemView.getLayoutParams();
            if (layoutParams instanceof C0235) {
                ((C0235) layoutParams).f1481 = true;
            }
            int i2 = Build.VERSION.SDK_INT;
            Trace.endSection();
        }

        public final VH createViewHolder(ViewGroup viewGroup, int i) {
            try {
                C1724.m4432(RecyclerView.TRACE_CREATE_VIEW_TAG);
                VH onCreateViewHolder = onCreateViewHolder(viewGroup, i);
                if (onCreateViewHolder.itemView.getParent() == null) {
                    onCreateViewHolder.mItemViewType = i;
                    int i2 = Build.VERSION.SDK_INT;
                    Trace.endSection();
                    return onCreateViewHolder;
                }
                throw new IllegalStateException("ViewHolder views must not be attached when created. Ensure that you are not passing 'true' to the attachToRoot parameter of LayoutInflater.inflate(..., boolean attachToRoot)");
            } catch (Throwable th) {
                C1724.m4431();
                throw th;
            }
        }

        public abstract int getItemCount();

        public long getItemId(int i) {
            return -1;
        }

        public int getItemViewType(int i) {
            return 0;
        }

        public final boolean hasObservers() {
            return this.mObservable.m878();
        }

        public final boolean hasStableIds() {
            return this.mHasStableIds;
        }

        public final void notifyDataSetChanged() {
            this.mObservable.m874();
        }

        public final void notifyItemChanged(int i) {
            this.mObservable.m877(i, 1, null);
        }

        public final void notifyItemInserted(int i) {
            this.mObservable.m875(i, 1);
        }

        public final void notifyItemMoved(int i, int i2) {
            this.mObservable.m876(i, i2);
        }

        public final void notifyItemRangeChanged(int i, int i2) {
            this.mObservable.m877(i, i2, null);
        }

        public final void notifyItemRangeInserted(int i, int i2) {
            this.mObservable.m875(i, i2);
        }

        public final void notifyItemRangeRemoved(int i, int i2) {
            this.mObservable.m873(i, i2);
        }

        public final void notifyItemRemoved(int i) {
            this.mObservable.m873(i, 1);
        }

        public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        }

        public abstract void onBindViewHolder(VH vh, int i);

        public void onBindViewHolder(VH vh, int i, List<Object> list) {
            onBindViewHolder(vh, i);
        }

        public abstract VH onCreateViewHolder(ViewGroup viewGroup, int i);

        public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        }

        public boolean onFailedToRecycleView(VH vh) {
            return false;
        }

        public void onViewAttachedToWindow(VH vh) {
        }

        public void onViewDetachedFromWindow(VH vh) {
        }

        public void onViewRecycled(VH vh) {
        }

        public void registerAdapterDataObserver(AbstractC0244 r2) {
            this.mObservable.registerObserver(r2);
        }

        public void setHasStableIds(boolean z) {
            if (!hasObservers()) {
                this.mHasStableIds = z;
                return;
            }
            throw new IllegalStateException("Cannot change whether this adapter has stable IDs while the adapter has registered observers.");
        }

        public void unregisterAdapterDataObserver(AbstractC0244 r2) {
            this.mObservable.unregisterObserver(r2);
        }

        public final void notifyItemChanged(int i, Object obj) {
            this.mObservable.m877(i, 1, obj);
        }

        public final void notifyItemRangeChanged(int i, int i2, Object obj) {
            this.mObservable.m877(i, i2, obj);
        }
    }

    /* renamed from: androidx.recyclerview.widget.RecyclerView$㴹  reason: contains not printable characters */
    public class C0263 implements C2326.AbstractC2328 {
        public C0263() {
        }

        /* renamed from: K  reason: contains not printable characters */
        public AbstractC0269 m854(int i) {
            AbstractC0269 findViewHolderForPosition = RecyclerView.this.findViewHolderForPosition(i, true);
            if (findViewHolderForPosition != null && !RecyclerView.this.mChildHelper.m6051(findViewHolderForPosition.itemView)) {
                return findViewHolderForPosition;
            }
            return null;
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m855(int i, int i2, Object obj) {
            RecyclerView.this.viewRangeUpdate(i, i2, obj);
            RecyclerView.this.mItemsChanged = true;
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m856(C2326.C2327 r5) {
            int i = r5.f8055;
            if (i == 1) {
                RecyclerView recyclerView = RecyclerView.this;
                recyclerView.mLayout.onItemsAdded(recyclerView, r5.f8054, r5.f8056);
            } else if (i == 2) {
                RecyclerView recyclerView2 = RecyclerView.this;
                recyclerView2.mLayout.onItemsRemoved(recyclerView2, r5.f8054, r5.f8056);
            } else if (i == 4) {
                RecyclerView recyclerView3 = RecyclerView.this;
                recyclerView3.mLayout.onItemsUpdated(recyclerView3, r5.f8054, r5.f8056, r5.f8053);
            } else if (i == 8) {
                RecyclerView recyclerView4 = RecyclerView.this;
                recyclerView4.mLayout.onItemsMoved(recyclerView4, r5.f8054, r5.f8056, 1);
            }
        }
    }

    /* renamed from: androidx.recyclerview.widget.RecyclerView$㶋  reason: contains not printable characters */
    public final class C0264 {

        /* renamed from: ʬ  reason: contains not printable characters */
        public final ArrayList<AbstractC0269> f1535 = new ArrayList<>();

        /* renamed from: ඓ  reason: contains not printable characters */
        public int f1536 = 2;

        /* renamed from: ῲ  reason: contains not printable characters */
        public ArrayList<AbstractC0269> f1537 = null;

        /* renamed from: ⁱ  reason: contains not printable characters */
        public C0233 f1538;

        /* renamed from: K  reason: contains not printable characters */
        public final ArrayList<AbstractC0269> f1539 = new ArrayList<>();

        /* renamed from: 㴹  reason: contains not printable characters */
        public int f1540 = 2;

        /* renamed from: 㸾  reason: contains not printable characters */
        public final List<AbstractC0269> f1541 = Collections.unmodifiableList(this.f1539);

        public C0264() {
        }

        /* renamed from: ʬ  reason: contains not printable characters */
        public void m857() {
            for (int size = this.f1535.size() - 1; size >= 0; size--) {
                m860(size);
            }
            this.f1535.clear();
            if (RecyclerView.ALLOW_THREAD_GAP_WORK) {
                RunnableC2312.C2314 r0 = RecyclerView.this.mPrefetchRegistry;
                int[] iArr = r0.f7995;
                if (iArr != null) {
                    Arrays.fill(iArr, -1);
                }
                r0.f7998 = 0;
            }
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public void m861(View view) {
            AbstractC0269 childViewHolderInt = RecyclerView.getChildViewHolderInt(view);
            if (childViewHolderInt.isTmpDetached()) {
                RecyclerView.this.removeDetachedView(view, false);
            }
            if (childViewHolderInt.isScrap()) {
                childViewHolderInt.unScrap();
            } else if (childViewHolderInt.wasReturnedFromScrap()) {
                childViewHolderInt.clearReturnedFromScrapFlag();
            }
            m869(childViewHolderInt);
            if (RecyclerView.this.mItemAnimator != null && !childViewHolderInt.isRecyclable()) {
                RecyclerView.this.mItemAnimator.m830(childViewHolderInt);
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m865() {
            this.f1539.clear();
            m857();
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m868(AbstractC0249 r1) {
        }

        /* renamed from: 㸾  reason: contains not printable characters */
        public void m871() {
            AbstractC0254 r0 = RecyclerView.this.mLayout;
            this.f1540 = this.f1536 + (r0 != null ? r0.mPrefetchMaxCountObserved : 0);
            for (int size = this.f1535.size() - 1; size >= 0 && this.f1535.size() > this.f1540; size--) {
                m860(size);
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public int m863(int i) {
            if (i < 0 || i >= RecyclerView.this.mState.m823()) {
                StringBuilder sb = new StringBuilder();
                sb.append("invalid position ");
                sb.append(i);
                sb.append(". State item count is ");
                sb.append(RecyclerView.this.mState.m823());
                throw new IndexOutOfBoundsException(C1293.m3407(RecyclerView.this, sb));
            }
            RecyclerView recyclerView = RecyclerView.this;
            if (!recyclerView.mState.f1510) {
                return i;
            }
            return recyclerView.mAdapterHelper.m6085(i, 0);
        }

        /* renamed from: ʬ  reason: contains not printable characters */
        public void m858(View view) {
            AbstractC0269 childViewHolderInt = RecyclerView.getChildViewHolderInt(view);
            if (!childViewHolderInt.hasAnyOfTheFlags(12) && childViewHolderInt.isUpdated() && !RecyclerView.this.canReuseUpdatedViewHolder(childViewHolderInt)) {
                if (this.f1537 == null) {
                    this.f1537 = new ArrayList<>();
                }
                childViewHolderInt.setScrapContainer(this, true);
                this.f1537.add(childViewHolderInt);
            } else if (!childViewHolderInt.isInvalid() || childViewHolderInt.isRemoved() || RecyclerView.this.mAdapter.hasStableIds()) {
                childViewHolderInt.setScrapContainer(this, false);
                this.f1539.add(childViewHolderInt);
            } else {
                throw new IllegalArgumentException(C1293.m3407(RecyclerView.this, C1293.m3416("Called scrap view with an invalid view. Invalid views cannot be reused from scrap, they should rebound from recycler pool.")));
            }
        }

        /* JADX WARNING: Code restructure failed: missing block: B:228:0x0482, code lost:
            if ((r4 == 0 || r4 + r7 < r22) == false) goto L_0x0484;
         */
        /* JADX WARNING: Code restructure failed: missing block: B:51:0x00c8, code lost:
            r8.addFlags(32);
         */
        /* JADX WARNING: Code restructure failed: missing block: B:52:0x00cb, code lost:
            r6 = r8;
         */
        /* JADX WARNING: Removed duplicated region for block: B:250:0x04ed  */
        /* JADX WARNING: Removed duplicated region for block: B:251:0x04fb  */
        /* JADX WARNING: Removed duplicated region for block: B:34:0x008e  */
        /* JADX WARNING: Removed duplicated region for block: B:35:0x0090  */
        /* renamed from: K  reason: contains not printable characters */
        public AbstractC0269 m864(int i, boolean z, long j) {
            AbstractC0269 r6;
            boolean z2;
            boolean z3;
            boolean z4;
            ViewGroup.LayoutParams layoutParams;
            C0235 r4;
            boolean z5;
            RecyclerView findNestedRecyclerView;
            AbstractC0269 r3;
            AbstractC0269 r8;
            View view;
            boolean z6;
            int size;
            int r5;
            if (i < 0 || i >= RecyclerView.this.mState.m823()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Invalid item position ");
                sb.append(i);
                sb.append("(");
                sb.append(i);
                sb.append("). Item count:");
                sb.append(RecyclerView.this.mState.m823());
                throw new IndexOutOfBoundsException(C1293.m3407(RecyclerView.this, sb));
            }
            int i2 = 32;
            if (RecyclerView.this.mState.f1510) {
                ArrayList<AbstractC0269> arrayList = this.f1537;
                if (arrayList != null && (size = arrayList.size()) != 0) {
                    int i3 = 0;
                    while (true) {
                        if (i3 < size) {
                            r6 = this.f1537.get(i3);
                            if (!r6.wasReturnedFromScrap() && r6.getLayoutPosition() == i) {
                                r6.addFlags(32);
                                break;
                            }
                            i3++;
                        } else if (RecyclerView.this.mAdapter.hasStableIds() && (r5 = RecyclerView.this.mAdapterHelper.m6085(i, 0)) > 0 && r5 < RecyclerView.this.mAdapter.getItemCount()) {
                            long itemId = RecyclerView.this.mAdapter.getItemId(r5);
                            int i4 = 0;
                            while (true) {
                                if (i4 >= size) {
                                    break;
                                }
                                AbstractC0269 r82 = this.f1537.get(i4);
                                if (!r82.wasReturnedFromScrap() && r82.getItemId() == itemId) {
                                    r82.addFlags(32);
                                    r6 = r82;
                                    break;
                                }
                                i4++;
                            }
                        }
                    }
                    z2 = r6 == null;
                }
                r6 = null;
                if (r6 == null) {
                }
            } else {
                z2 = false;
                r6 = null;
            }
            if (r6 == null) {
                int size2 = this.f1539.size();
                int i5 = 0;
                while (true) {
                    if (i5 < size2) {
                        r8 = this.f1539.get(i5);
                        if (r8.wasReturnedFromScrap() || r8.getLayoutPosition() != i || r8.isInvalid() || (!RecyclerView.this.mState.f1510 && r8.isRemoved())) {
                            i5++;
                        }
                    } else {
                        if (!z) {
                            C2316 r62 = RecyclerView.this.mChildHelper;
                            int size3 = r62.f7999.size();
                            int i6 = 0;
                            while (true) {
                                if (i6 >= size3) {
                                    view = null;
                                    break;
                                }
                                view = r62.f7999.get(i6);
                                AbstractC0269 r10 = ((C0237) r62.f8001).m817(view);
                                if (!(r10.getLayoutPosition() != i || r10.isInvalid() || r10.isRemoved())) {
                                    break;
                                }
                                i6++;
                            }
                            if (view != null) {
                                r6 = RecyclerView.getChildViewHolderInt(view);
                                C2316 r7 = RecyclerView.this.mChildHelper;
                                int indexOfChild = RecyclerView.this.indexOfChild(view);
                                if (indexOfChild < 0) {
                                    throw new IllegalArgumentException("view is not a child, cannot hide " + view);
                                } else if (r7.f8000.m6058(indexOfChild)) {
                                    r7.f8000.m6063(indexOfChild);
                                    r7.m6047(view);
                                    int r72 = RecyclerView.this.mChildHelper.m6053(view);
                                    if (r72 != -1) {
                                        RecyclerView.this.mChildHelper.m6054(r72);
                                        m858(view);
                                        r6.addFlags(8224);
                                    } else {
                                        StringBuilder sb2 = new StringBuilder();
                                        sb2.append("layout index should not be -1 after unhiding a view:");
                                        sb2.append(r6);
                                        throw new IllegalStateException(C1293.m3407(RecyclerView.this, sb2));
                                    }
                                } else {
                                    throw new RuntimeException("trying to unhide a view that was not hidden" + view);
                                }
                            }
                        }
                        int size4 = this.f1535.size();
                        for (int i7 = 0; i7 < size4; i7++) {
                            r8 = this.f1535.get(i7);
                            if (!r8.isInvalid() && r8.getLayoutPosition() == i && !r8.isAttachedToTransitionOverlay()) {
                                if (!z) {
                                    this.f1535.remove(i7);
                                }
                            }
                        }
                        r6 = null;
                    }
                }
                if (r6 != null) {
                    if (r6.isRemoved()) {
                        z6 = RecyclerView.this.mState.f1510;
                    } else {
                        int i8 = r6.mPosition;
                        if (i8 < 0 || i8 >= RecyclerView.this.mAdapter.getItemCount()) {
                            StringBuilder sb3 = new StringBuilder();
                            sb3.append("Inconsistency detected. Invalid view holder adapter position");
                            sb3.append(r6);
                            throw new IndexOutOfBoundsException(C1293.m3407(RecyclerView.this, sb3));
                        }
                        RecyclerView recyclerView = RecyclerView.this;
                        z6 = (recyclerView.mState.f1510 || recyclerView.mAdapter.getItemViewType(r6.mPosition) == r6.getItemViewType()) && (!RecyclerView.this.mAdapter.hasStableIds() || r6.getItemId() == RecyclerView.this.mAdapter.getItemId(r6.mPosition));
                    }
                    if (!z6) {
                        if (!z) {
                            r6.addFlags(4);
                            if (r6.isScrap()) {
                                RecyclerView.this.removeDetachedView(r6.itemView, false);
                                r6.unScrap();
                            } else if (r6.wasReturnedFromScrap()) {
                                r6.clearReturnedFromScrapFlag();
                            }
                            m869(r6);
                        }
                        r6 = null;
                    } else {
                        z2 = true;
                    }
                }
            }
            if (r6 == null) {
                int r11 = RecyclerView.this.mAdapterHelper.m6085(i, 0);
                if (r11 < 0 || r11 >= RecyclerView.this.mAdapter.getItemCount()) {
                    StringBuilder sb4 = new StringBuilder();
                    sb4.append("Inconsistency detected. Invalid item position ");
                    sb4.append(i);
                    sb4.append("(offset:");
                    sb4.append(r11);
                    sb4.append(").state:");
                    sb4.append(RecyclerView.this.mState.m823());
                    throw new IndexOutOfBoundsException(C1293.m3407(RecyclerView.this, sb4));
                }
                int itemViewType = RecyclerView.this.mAdapter.getItemViewType(r11);
                if (RecyclerView.this.mAdapter.hasStableIds()) {
                    long itemId2 = RecyclerView.this.mAdapter.getItemId(r11);
                    int size5 = this.f1539.size() - 1;
                    while (true) {
                        if (size5 >= 0) {
                            AbstractC0269 r15 = this.f1539.get(size5);
                            if (r15.getItemId() == itemId2 && !r15.wasReturnedFromScrap()) {
                                if (itemViewType == r15.getItemViewType()) {
                                    r15.addFlags(i2);
                                    if (r15.isRemoved() && !RecyclerView.this.mState.f1510) {
                                        r15.setFlags(2, 14);
                                    }
                                    r6 = r15;
                                } else if (!z) {
                                    this.f1539.remove(size5);
                                    RecyclerView.this.removeDetachedView(r15.itemView, false);
                                    m866(r15.itemView);
                                }
                            }
                            size5--;
                            i2 = 32;
                        } else {
                            int size6 = this.f1535.size() - 1;
                            while (true) {
                                if (size6 < 0) {
                                    break;
                                }
                                r6 = this.f1535.get(size6);
                                if (r6.getItemId() == itemId2 && !r6.isAttachedToTransitionOverlay()) {
                                    if (itemViewType == r6.getItemViewType()) {
                                        if (!z) {
                                            this.f1535.remove(size6);
                                        }
                                    } else if (!z) {
                                        m860(size6);
                                        break;
                                    }
                                }
                                size6--;
                            }
                            r6 = null;
                        }
                    }
                    if (r6 != null) {
                        r6.mPosition = r11;
                        z2 = true;
                    }
                }
                if (r6 == null) {
                    C0233.C0234 k = m859().f1476.get(itemViewType);
                    if (k != null && !k.f1479.isEmpty()) {
                        ArrayList<AbstractC0269> arrayList2 = k.f1479;
                        int size7 = arrayList2.size() - 1;
                        while (true) {
                            if (size7 < 0) {
                                break;
                            } else if (!arrayList2.get(size7).isAttachedToTransitionOverlay()) {
                                r3 = arrayList2.remove(size7);
                                break;
                            } else {
                                size7--;
                            }
                        }
                    }
                    r3 = null;
                    if (r3 != null) {
                        r3.resetInternal();
                        if (RecyclerView.FORCE_INVALIDATE_DISPLAY_LIST) {
                            View view2 = r3.itemView;
                            if (view2 instanceof ViewGroup) {
                                m867((ViewGroup) view2, false);
                            }
                        }
                    }
                    r6 = r3;
                }
                if (r6 == null) {
                    long nanoTime = RecyclerView.this.getNanoTime();
                    if (j != RecyclerView.FOREVER_NS) {
                        long j2 = this.f1538.m805(itemViewType).f1477;
                        if (!(j2 == 0 || j2 + nanoTime < j)) {
                            return null;
                        }
                    }
                    RecyclerView recyclerView2 = RecyclerView.this;
                    AbstractC0269 createViewHolder = recyclerView2.mAdapter.createViewHolder(recyclerView2, itemViewType);
                    if (RecyclerView.ALLOW_THREAD_GAP_WORK && (findNestedRecyclerView = RecyclerView.findNestedRecyclerView(createViewHolder.itemView)) != null) {
                        createViewHolder.mNestedRecyclerView = new WeakReference<>(findNestedRecyclerView);
                    }
                    long nanoTime2 = RecyclerView.this.getNanoTime();
                    C0233 r9 = this.f1538;
                    long j3 = nanoTime2 - nanoTime;
                    C0233.C0234 r52 = r9.m805(itemViewType);
                    r52.f1477 = r9.m804(r52.f1477, j3);
                    r6 = createViewHolder;
                }
            }
            if (z2 && !RecyclerView.this.mState.f1510 && r6.hasAnyOfTheFlags(8192)) {
                r6.setFlags(0, 8192);
                if (RecyclerView.this.mState.f1500) {
                    AbstractC0250.m825(r6);
                    RecyclerView recyclerView3 = RecyclerView.this;
                    AbstractC0250 r53 = recyclerView3.mItemAnimator;
                    C0248 r32 = recyclerView3.mState;
                    r6.getUnmodifiedPayloads();
                    AbstractC0250.C0251 r33 = r53.m828();
                    r33.m838(r6);
                    RecyclerView.this.recordAnimationInfoIfBouncedHiddenView(r6, r33);
                }
            }
            if (RecyclerView.this.mState.f1510 && r6.isBound()) {
                r6.mPreLayoutPosition = i;
            } else if (!r6.isBound() || r6.needsUpdate() || r6.isInvalid()) {
                int r34 = RecyclerView.this.mAdapterHelper.m6085(i, 0);
                r6.mOwnerRecyclerView = RecyclerView.this;
                int itemViewType2 = r6.getItemViewType();
                long nanoTime3 = RecyclerView.this.getNanoTime();
                if (j != RecyclerView.FOREVER_NS) {
                    long j4 = this.f1538.m805(itemViewType2).f1480;
                }
                RecyclerView.this.mAdapter.bindViewHolder(r6, r34);
                long nanoTime4 = RecyclerView.this.getNanoTime();
                C0233 r54 = this.f1538;
                long j5 = nanoTime4 - nanoTime3;
                C0233.C0234 r73 = r54.m805(r6.getItemViewType());
                r73.f1480 = r54.m804(r73.f1480, j5);
                if (RecyclerView.this.isAccessibilityEnabled()) {
                    View view3 = r6.itemView;
                    if (C1729.m4454(view3) == 0) {
                        int i9 = Build.VERSION.SDK_INT;
                        z5 = true;
                        view3.setImportantForAccessibility(1);
                    } else {
                        z5 = true;
                    }
                    C2304 r55 = RecyclerView.this.mAccessibilityDelegate;
                    if (r55 != null) {
                        C1747 itemDelegate = r55.getItemDelegate();
                        if (itemDelegate instanceof C2304.C2305) {
                            ((C2304.C2305) itemDelegate).m6029(view3);
                        }
                        C1729.m4482(view3, itemDelegate);
                    }
                    z3 = z5;
                } else {
                    z3 = true;
                }
                if (RecyclerView.this.mState.f1510) {
                    r6.mPreLayoutPosition = i;
                }
                z4 = true;
                layoutParams = r6.itemView.getLayoutParams();
                if (layoutParams != null) {
                    r4 = (C0235) RecyclerView.this.generateDefaultLayoutParams();
                    r6.itemView.setLayoutParams(r4);
                } else if (!RecyclerView.this.checkLayoutParams(layoutParams)) {
                    r4 = (C0235) RecyclerView.this.generateLayoutParams(layoutParams);
                    r6.itemView.setLayoutParams(r4);
                } else {
                    r4 = (C0235) layoutParams;
                }
                r4.f1483 = r6;
                if (!z2 || !z4) {
                    z3 = false;
                }
                r4.f1484 = z3;
                return r6;
            }
            z4 = false;
            z3 = true;
            layoutParams = r6.itemView.getLayoutParams();
            if (layoutParams != null) {
            }
            r4.f1483 = r6;
            z3 = false;
            r4.f1484 = z3;
            return r6;
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public void m860(int i) {
            m870(this.f1535.get(i), true);
            this.f1535.remove(i);
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public void m862(AbstractC0269 r2) {
            if (r2.mInChangeScrap) {
                this.f1537.remove(r2);
            } else {
                this.f1539.remove(r2);
            }
            r2.mScrapContainer = null;
            r2.mInChangeScrap = false;
            r2.clearReturnedFromScrapFlag();
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public C0233 m859() {
            if (this.f1538 == null) {
                this.f1538 = new C0233();
            }
            return this.f1538;
        }

        /* renamed from: K  reason: contains not printable characters */
        public final void m867(ViewGroup viewGroup, boolean z) {
            for (int childCount = viewGroup.getChildCount() - 1; childCount >= 0; childCount--) {
                View childAt = viewGroup.getChildAt(childCount);
                if (childAt instanceof ViewGroup) {
                    m867((ViewGroup) childAt, true);
                }
            }
            if (z) {
                if (viewGroup.getVisibility() == 4) {
                    viewGroup.setVisibility(0);
                    viewGroup.setVisibility(4);
                    return;
                }
                int visibility = viewGroup.getVisibility();
                viewGroup.setVisibility(4);
                viewGroup.setVisibility(visibility);
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m869(AbstractC0269 r7) {
            boolean z;
            boolean z2 = false;
            if (r7.isScrap() || r7.itemView.getParent() != null) {
                StringBuilder r2 = C1293.m3416("Scrapped or attached views may not be recycled. isScrap:");
                r2.append(r7.isScrap());
                r2.append(" isAttached:");
                if (r7.itemView.getParent() != null) {
                    z2 = true;
                }
                r2.append(z2);
                throw new IllegalArgumentException(C1293.m3407(RecyclerView.this, r2));
            } else if (r7.isTmpDetached()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Tmp detached view should be removed from RecyclerView before it can be recycled: ");
                sb.append(r7);
                throw new IllegalArgumentException(C1293.m3407(RecyclerView.this, sb));
            } else if (!r7.shouldIgnore()) {
                boolean doesTransientStatePreventRecycling = r7.doesTransientStatePreventRecycling();
                AbstractC0246 r3 = RecyclerView.this.mAdapter;
                if ((r3 != null && doesTransientStatePreventRecycling && r3.onFailedToRecycleView(r7)) || r7.isRecyclable()) {
                    if (this.f1540 <= 0 || r7.hasAnyOfTheFlags(526)) {
                        z = false;
                    } else {
                        int size = this.f1535.size();
                        if (size >= this.f1540 && size > 0) {
                            m860(0);
                            size--;
                        }
                        if (RecyclerView.ALLOW_THREAD_GAP_WORK && size > 0 && !RecyclerView.this.mPrefetchRegistry.m6045(r7.mPosition)) {
                            do {
                                size--;
                                if (size < 0) {
                                    break;
                                }
                            } while (RecyclerView.this.mPrefetchRegistry.m6045(this.f1535.get(size).mPosition));
                            size++;
                        }
                        this.f1535.add(size, r7);
                        z = true;
                    }
                    if (!z) {
                        m870(r7, true);
                        z2 = true;
                    }
                } else {
                    z = false;
                }
                RecyclerView.this.mViewInfoStore.m6037(r7);
                if (!z && !z2 && doesTransientStatePreventRecycling) {
                    r7.mOwnerRecyclerView = null;
                }
            } else {
                throw new IllegalArgumentException(C1293.m3407(RecyclerView.this, C1293.m3416("Trying to recycle an ignored view holder. You should first call stopIgnoringView(view) before calling recycle.")));
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m870(AbstractC0269 r5, boolean z) {
            RecyclerView.clearNestedRecyclerViewIfNotNested(r5);
            View view = r5.itemView;
            C2304 r1 = RecyclerView.this.mAccessibilityDelegate;
            if (r1 != null) {
                C1747 itemDelegate = r1.getItemDelegate();
                C1729.m4482(view, itemDelegate instanceof C2304.C2305 ? ((C2304.C2305) itemDelegate).f7964.remove(view) : null);
            }
            if (z) {
                AbstractC0241 r6 = RecyclerView.this.mRecyclerListener;
                if (r6 != null) {
                    r6.m821(r5);
                }
                AbstractC0246 r62 = RecyclerView.this.mAdapter;
                if (r62 != null) {
                    r62.onViewRecycled(r5);
                }
                RecyclerView recyclerView = RecyclerView.this;
                if (recyclerView.mState != null) {
                    recyclerView.mViewInfoStore.m6037(r5);
                }
            }
            r5.mOwnerRecyclerView = null;
            m859().m808(r5);
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m866(View view) {
            AbstractC0269 childViewHolderInt = RecyclerView.getChildViewHolderInt(view);
            childViewHolderInt.mScrapContainer = null;
            childViewHolderInt.mInChangeScrap = false;
            childViewHolderInt.clearReturnedFromScrapFlag();
            m869(childViewHolderInt);
        }
    }

    public RecyclerView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R$attr.recyclerViewStyle);
    }

    public boolean dispatchNestedPreScroll(int i, int i2, int[] iArr, int[] iArr2, int i3) {
        return getScrollingChildHelper().m4635(i, i2, iArr, iArr2, i3);
    }

    public boolean dispatchNestedScroll(int i, int i2, int i3, int i4, int[] iArr, int i5) {
        return getScrollingChildHelper().m4626(i, i2, i3, i4, iArr, i5, null);
    }

    public AbstractC0269 findViewHolderForPosition(int i, boolean z) {
        int r0 = this.mChildHelper.m6049();
        AbstractC0269 r1 = null;
        for (int i2 = 0; i2 < r0; i2++) {
            AbstractC0269 childViewHolderInt = getChildViewHolderInt(this.mChildHelper.m6057(i2));
            if (childViewHolderInt != null && !childViewHolderInt.isRemoved()) {
                if (z) {
                    if (childViewHolderInt.mPosition != i) {
                        continue;
                    }
                } else if (childViewHolderInt.getLayoutPosition() != i) {
                    continue;
                }
                if (!this.mChildHelper.m6051(childViewHolderInt.itemView)) {
                    return childViewHolderInt;
                }
                r1 = childViewHolderInt;
            }
        }
        return r1;
    }

    public boolean hasNestedScrollingParent(int i) {
        return getScrollingChildHelper().m4627(i) != null;
    }

    public void onExitLayoutOrScroll(boolean z) {
        this.mLayoutOrScrollCounter--;
        if (this.mLayoutOrScrollCounter < 1) {
            this.mLayoutOrScrollCounter = 0;
            if (z) {
                dispatchContentChangedIfNecessary();
                dispatchPendingImportantForAccessibilityChanges();
            }
        }
    }

    public void smoothScrollBy(int i, int i2, Interpolator interpolator) {
        smoothScrollBy(i, i2, interpolator, Integer.MIN_VALUE);
    }

    public RecyclerView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        float f;
        this.mObserver = new C0262();
        this.mRecycler = new C0264();
        this.mViewInfoStore = new C2307();
        this.mUpdateChildViewsRunnable = new RunnableC0247();
        this.mTempRect = new Rect();
        this.mTempRect2 = new Rect();
        this.mTempRectF = new RectF();
        this.mItemDecorations = new ArrayList<>();
        this.mOnItemTouchListeners = new ArrayList<>();
        this.mInterceptRequestLayoutDepth = 0;
        this.mDataSetHasChangedAfterLayout = false;
        this.mDispatchItemsChangedEvent = false;
        this.mLayoutOrScrollCounter = 0;
        this.mDispatchScrollCounter = 0;
        this.mEdgeEffectFactory = new C0243();
        this.mItemAnimator = new C2319();
        this.mScrollState = 0;
        this.mScrollPointerId = -1;
        this.mScaledHorizontalScrollFactor = Float.MIN_VALUE;
        this.mScaledVerticalScrollFactor = Float.MIN_VALUE;
        this.mPreserveFocusAfterLayout = true;
        this.mViewFlinger = new RunnableC0260();
        this.mPrefetchRegistry = ALLOW_THREAD_GAP_WORK ? new RunnableC2312.C2314() : null;
        this.mState = new C0248();
        this.mItemsAddedOrRemoved = false;
        this.mItemsChanged = false;
        this.mItemAnimatorListener = new C0268();
        this.mPostedAnimatorRunner = false;
        this.mMinMaxLayoutPositions = new int[2];
        this.mScrollOffset = new int[2];
        this.mNestedOffsets = new int[2];
        this.mReusableIntPair = new int[2];
        this.mPendingAccessibilityImportanceChange = new ArrayList();
        this.mItemAnimatorRunner = new RunnableC0245();
        this.mViewInfoProcessCallback = new C0265();
        setScrollContainer(true);
        setFocusableInTouchMode(true);
        ViewConfiguration viewConfiguration = ViewConfiguration.get(context);
        this.mTouchSlop = viewConfiguration.getScaledTouchSlop();
        this.mScaledHorizontalScrollFactor = C1739.m4537(viewConfiguration, context);
        if (Build.VERSION.SDK_INT >= 26) {
            f = viewConfiguration.getScaledVerticalScrollFactor();
        } else {
            f = C1739.m4538(viewConfiguration, context);
        }
        this.mScaledVerticalScrollFactor = f;
        this.mMinFlingVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
        this.mMaxFlingVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        setWillNotDraw(getOverScrollMode() == 2);
        this.mItemAnimator.f1515 = this.mItemAnimatorListener;
        initAdapterManager();
        initChildrenHelper();
        initAutofill();
        if (C1729.m4454(this) == 0) {
            int i2 = Build.VERSION.SDK_INT;
            setImportantForAccessibility(1);
        }
        this.mAccessibilityManager = (AccessibilityManager) getContext().getSystemService("accessibility");
        setAccessibilityDelegateCompat(new C2304(this));
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, R$styleable.RecyclerView, i, 0);
        if (Build.VERSION.SDK_INT >= 29) {
            saveAttributeDataForStyleable(context, R$styleable.RecyclerView, attributeSet, obtainStyledAttributes, i, 0);
        }
        String string = obtainStyledAttributes.getString(R$styleable.RecyclerView_layoutManager);
        if (obtainStyledAttributes.getInt(R$styleable.RecyclerView_android_descendantFocusability, -1) == -1) {
            setDescendantFocusability(262144);
        }
        this.mClipToPadding = obtainStyledAttributes.getBoolean(R$styleable.RecyclerView_android_clipToPadding, true);
        this.mEnableFastScroller = obtainStyledAttributes.getBoolean(R$styleable.RecyclerView_fastScrollEnabled, false);
        if (this.mEnableFastScroller) {
            initFastScroller((StateListDrawable) obtainStyledAttributes.getDrawable(R$styleable.RecyclerView_fastScrollVerticalThumbDrawable), obtainStyledAttributes.getDrawable(R$styleable.RecyclerView_fastScrollVerticalTrackDrawable), (StateListDrawable) obtainStyledAttributes.getDrawable(R$styleable.RecyclerView_fastScrollHorizontalThumbDrawable), obtainStyledAttributes.getDrawable(R$styleable.RecyclerView_fastScrollHorizontalTrackDrawable));
        }
        obtainStyledAttributes.recycle();
        createLayoutManager(context, string, attributeSet, i, 0);
        int i3 = Build.VERSION.SDK_INT;
        TypedArray obtainStyledAttributes2 = context.obtainStyledAttributes(attributeSet, NESTED_SCROLLING_ATTRS, i, 0);
        if (Build.VERSION.SDK_INT >= 29) {
            saveAttributeDataForStyleable(context, NESTED_SCROLLING_ATTRS, attributeSet, obtainStyledAttributes2, i, 0);
        }
        boolean z = obtainStyledAttributes2.getBoolean(0, true);
        obtainStyledAttributes2.recycle();
        setNestedScrollingEnabled(z);
    }

    public void smoothScrollBy(int i, int i2, Interpolator interpolator, int i3) {
        smoothScrollBy(i, i2, interpolator, i3, false);
    }

    public boolean startNestedScroll(int i, int i2) {
        return getScrollingChildHelper().m4632(i, i2);
    }

    public void stopNestedScroll(int i) {
        getScrollingChildHelper().m4624(i);
    }

    public static class SavedState extends AbsSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new C0230();

        /* renamed from: ῲ  reason: contains not printable characters */
        public Parcelable f1474;

        /* renamed from: androidx.recyclerview.widget.RecyclerView$SavedState$K  reason: contains not printable characters */
        public static class C0230 implements Parcelable.ClassLoaderCreator<SavedState> {
            /* Return type fixed from 'java.lang.Object' to match base method */
            @Override // android.os.Parcelable.ClassLoaderCreator
            public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new SavedState(parcel, classLoader);
            }

            @Override // android.os.Parcelable.Creator
            public Object[] newArray(int i) {
                return new SavedState[i];
            }

            @Override // android.os.Parcelable.Creator
            public Object createFromParcel(Parcel parcel) {
                return new SavedState(parcel, null);
            }
        }

        public SavedState(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            this.f1474 = parcel.readParcelable(classLoader == null ? AbstractC0254.class.getClassLoader() : classLoader);
        }

        @Override // androidx.customview.view.AbsSavedState
        public void writeToParcel(Parcel parcel, int i) {
            super.writeToParcel(parcel, i);
            parcel.writeParcelable(this.f1474, 0);
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m802(SavedState savedState) {
            this.f1474 = savedState.f1474;
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }
    }

    /* renamed from: androidx.recyclerview.widget.RecyclerView$ؿ  reason: contains not printable characters */
    public static class C0235 extends ViewGroup.MarginLayoutParams {

        /* renamed from: ʬ  reason: contains not printable characters */
        public boolean f1481 = true;

        /* renamed from: ῲ  reason: contains not printable characters */
        public final Rect f1482 = new Rect();

        /* renamed from: K  reason: contains not printable characters */
        public AbstractC0269 f1483;

        /* renamed from: 㸾  reason: contains not printable characters */
        public boolean f1484 = false;

        public C0235(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        /* renamed from: ʬ  reason: contains not printable characters */
        public boolean m809() {
            return this.f1483.isRemoved();
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public boolean m810() {
            return this.f1483.isUpdated();
        }

        /* renamed from: K  reason: contains not printable characters */
        public int m811() {
            return this.f1483.getLayoutPosition();
        }

        public C0235(int i, int i2) {
            super(i, i2);
        }

        public C0235(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }

        public C0235(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public C0235(C0235 r1) {
            super((ViewGroup.LayoutParams) r1);
        }
    }

    /* renamed from: androidx.recyclerview.widget.RecyclerView$ゎ  reason: contains not printable characters */
    public static class C0248 {

        /* renamed from: ʬ  reason: contains not printable characters */
        public int f1495 = 0;

        /* renamed from: Ԕ  reason: contains not printable characters */
        public long f1496;

        /* renamed from: ؿ  reason: contains not printable characters */
        public int f1497;

        /* renamed from: ඓ  reason: contains not printable characters */
        public int f1498 = 1;

        /* renamed from: ᓣ  reason: contains not printable characters */
        public int f1499;

        /* renamed from: ᕣ  reason: contains not printable characters */
        public boolean f1500 = false;

        /* renamed from: ᨨ  reason: contains not printable characters */
        public boolean f1501 = false;

        /* renamed from: ῲ  reason: contains not printable characters */
        public SparseArray<Object> f1502;

        /* renamed from: ⁱ  reason: contains not printable characters */
        public boolean f1503 = false;

        /* renamed from: K  reason: contains not printable characters */
        public int f1504 = -1;

        /* renamed from: 㑃  reason: contains not printable characters */
        public boolean f1505 = false;

        /* renamed from: 㗗  reason: contains not printable characters */
        public int f1506;

        /* renamed from: 㳳  reason: contains not printable characters */
        public boolean f1507 = false;

        /* renamed from: 㴹  reason: contains not printable characters */
        public int f1508 = 0;

        /* renamed from: 㸾  reason: contains not printable characters */
        public int f1509 = 0;

        /* renamed from: 㿎  reason: contains not printable characters */
        public boolean f1510 = false;

        /* renamed from: 䁗  reason: contains not printable characters */
        public int f1511;

        public String toString() {
            StringBuilder r0 = C1293.m3416("State{mTargetPosition=");
            r0.append(this.f1504);
            r0.append(", mData=");
            r0.append(this.f1502);
            r0.append(", mItemCount=");
            r0.append(this.f1508);
            r0.append(", mIsMeasuring=");
            r0.append(this.f1507);
            r0.append(", mPreviousLayoutItemCount=");
            r0.append(this.f1495);
            r0.append(", mDeletedInvisibleItemCountSincePreviousLayout=");
            r0.append(this.f1509);
            r0.append(", mStructureChanged=");
            r0.append(this.f1503);
            r0.append(", mInPreLayout=");
            r0.append(this.f1510);
            r0.append(", mRunSimpleAnimations=");
            r0.append(this.f1500);
            r0.append(", mRunPredictiveAnimations=");
            r0.append(this.f1505);
            r0.append('}');
            return r0.toString();
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m824(int i) {
            if ((this.f1498 & i) == 0) {
                StringBuilder r1 = C1293.m3416("Layout state should be one of ");
                r1.append(Integer.toBinaryString(i));
                r1.append(" but it is ");
                r1.append(Integer.toBinaryString(this.f1498));
                throw new IllegalStateException(r1.toString());
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public int m823() {
            return this.f1510 ? this.f1495 - this.f1509 : this.f1508;
        }
    }

    /* renamed from: androidx.recyclerview.widget.RecyclerView$㮔  reason: contains not printable characters */
    public class RunnableC0260 implements Runnable {

        /* renamed from: ʬ  reason: contains not printable characters */
        public int f1526;

        /* renamed from: ඓ  reason: contains not printable characters */
        public Interpolator f1527 = RecyclerView.sQuinticInterpolator;

        /* renamed from: ῲ  reason: contains not printable characters */
        public int f1528;

        /* renamed from: ⁱ  reason: contains not printable characters */
        public boolean f1529 = false;

        /* renamed from: 㴹  reason: contains not printable characters */
        public boolean f1530 = false;

        /* renamed from: 㸾  reason: contains not printable characters */
        public OverScroller f1531;

        public RunnableC0260() {
            this.f1531 = new OverScroller(RecyclerView.this.getContext(), RecyclerView.sQuinticInterpolator);
        }

        public void run() {
            int i;
            int i2;
            RecyclerView recyclerView = RecyclerView.this;
            if (recyclerView.mLayout == null) {
                m850();
                return;
            }
            this.f1529 = false;
            this.f1530 = true;
            recyclerView.consumePendingUpdateOperations();
            OverScroller overScroller = this.f1531;
            if (overScroller.computeScrollOffset()) {
                int currX = overScroller.getCurrX();
                int currY = overScroller.getCurrY();
                int i3 = currX - this.f1528;
                int i4 = currY - this.f1526;
                this.f1528 = currX;
                this.f1526 = currY;
                RecyclerView recyclerView2 = RecyclerView.this;
                int[] iArr = recyclerView2.mReusableIntPair;
                iArr[0] = 0;
                iArr[1] = 0;
                if (recyclerView2.dispatchNestedPreScroll(i3, i4, iArr, null, 1)) {
                    int[] iArr2 = RecyclerView.this.mReusableIntPair;
                    i3 -= iArr2[0];
                    i4 -= iArr2[1];
                }
                if (RecyclerView.this.getOverScrollMode() != 2) {
                    RecyclerView.this.considerReleasingGlowsOnScroll(i3, i4);
                }
                RecyclerView recyclerView3 = RecyclerView.this;
                if (recyclerView3.mAdapter != null) {
                    int[] iArr3 = recyclerView3.mReusableIntPair;
                    iArr3[0] = 0;
                    iArr3[1] = 0;
                    recyclerView3.scrollStep(i3, i4, iArr3);
                    RecyclerView recyclerView4 = RecyclerView.this;
                    int[] iArr4 = recyclerView4.mReusableIntPair;
                    i = iArr4[0];
                    i2 = iArr4[1];
                    i3 -= i;
                    i4 -= i2;
                    AbstractC0238 r4 = recyclerView4.mLayout.mSmoothScroller;
                    if (r4 != null && !r4.isPendingInitialRun() && r4.isRunning()) {
                        int r9 = RecyclerView.this.mState.m823();
                        if (r9 == 0) {
                            r4.stop();
                        } else if (r4.getTargetPosition() >= r9) {
                            r4.setTargetPosition(r9 - 1);
                            r4.onAnimation(i, i2);
                        } else {
                            r4.onAnimation(i, i2);
                        }
                    }
                } else {
                    i2 = 0;
                    i = 0;
                }
                if (!RecyclerView.this.mItemDecorations.isEmpty()) {
                    RecyclerView.this.invalidate();
                }
                RecyclerView recyclerView5 = RecyclerView.this;
                int[] iArr5 = recyclerView5.mReusableIntPair;
                iArr5[0] = 0;
                iArr5[1] = 0;
                recyclerView5.dispatchNestedScroll(i, i2, i3, i4, null, 1, iArr5);
                int[] iArr6 = RecyclerView.this.mReusableIntPair;
                int i5 = i3 - iArr6[0];
                int i6 = i4 - iArr6[1];
                if (!(i == 0 && i2 == 0)) {
                    RecyclerView.this.dispatchOnScrolled(i, i2);
                }
                if (!RecyclerView.this.awakenScrollBars()) {
                    RecyclerView.this.invalidate();
                }
                boolean z = overScroller.isFinished() || (((overScroller.getCurrX() == overScroller.getFinalX()) || i5 != 0) && ((overScroller.getCurrY() == overScroller.getFinalY()) || i6 != 0));
                AbstractC0238 r92 = RecyclerView.this.mLayout.mSmoothScroller;
                if ((r92 != null && r92.isPendingInitialRun()) || !z) {
                    m851();
                    RecyclerView recyclerView6 = RecyclerView.this;
                    RunnableC2312 r42 = recyclerView6.mGapWorker;
                    if (r42 != null) {
                        r42.m6042(recyclerView6, i, i2);
                    }
                } else {
                    if (RecyclerView.this.getOverScrollMode() != 2) {
                        int currVelocity = (int) overScroller.getCurrVelocity();
                        int i7 = i5 < 0 ? -currVelocity : i5 > 0 ? currVelocity : 0;
                        if (i6 < 0) {
                            currVelocity = -currVelocity;
                        } else if (i6 <= 0) {
                            currVelocity = 0;
                        }
                        RecyclerView.this.absorbGlows(i7, currVelocity);
                    }
                    if (RecyclerView.ALLOW_THREAD_GAP_WORK) {
                        RunnableC2312.C2314 r1 = RecyclerView.this.mPrefetchRegistry;
                        int[] iArr7 = r1.f7995;
                        if (iArr7 != null) {
                            Arrays.fill(iArr7, -1);
                        }
                        r1.f7998 = 0;
                    }
                }
            }
            AbstractC0238 r12 = RecyclerView.this.mLayout.mSmoothScroller;
            if (r12 != null && r12.isPendingInitialRun()) {
                r12.onAnimation(0, 0);
            }
            this.f1530 = false;
            if (this.f1529) {
                RecyclerView.this.removeCallbacks(this);
                C1729.m4479(RecyclerView.this, this);
                return;
            }
            RecyclerView.this.setScrollState(0);
            RecyclerView.this.stopNestedScroll(1);
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public void m850() {
            RecyclerView.this.removeCallbacks(this);
            this.f1531.abortAnimation();
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m851() {
            if (this.f1530) {
                this.f1529 = true;
                return;
            }
            RecyclerView.this.removeCallbacks(this);
            C1729.m4479(RecyclerView.this, this);
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m852(int i, int i2, int i3, Interpolator interpolator) {
            int i4;
            if (i3 == Integer.MIN_VALUE) {
                int abs = Math.abs(i);
                int abs2 = Math.abs(i2);
                boolean z = abs > abs2;
                int sqrt = (int) Math.sqrt((double) 0);
                int sqrt2 = (int) Math.sqrt((double) ((i2 * i2) + (i * i)));
                RecyclerView recyclerView = RecyclerView.this;
                int width = z ? recyclerView.getWidth() : recyclerView.getHeight();
                int i5 = width / 2;
                float f = (float) width;
                float f2 = (float) i5;
                float sin = (((float) Math.sin((double) ((Math.min(1.0f, (((float) sqrt2) * 1.0f) / f) - 0.5f) * 0.47123894f))) * f2) + f2;
                if (sqrt > 0) {
                    i4 = Math.round(Math.abs(sin / ((float) sqrt)) * 1000.0f) * 4;
                } else {
                    if (!z) {
                        abs = abs2;
                    }
                    i4 = (int) (((((float) abs) / f) + 1.0f) * 300.0f);
                }
                i3 = Math.min(i4, (int) RecyclerView.MAX_SCROLL_DURATION);
            }
            if (interpolator == null) {
                interpolator = RecyclerView.sQuinticInterpolator;
            }
            if (this.f1527 != interpolator) {
                this.f1527 = interpolator;
                this.f1531 = new OverScroller(RecyclerView.this.getContext(), interpolator);
            }
            this.f1526 = 0;
            this.f1528 = 0;
            RecyclerView.this.setScrollState(2);
            this.f1531.startScroll(0, 0, i, i2, i3);
            if (Build.VERSION.SDK_INT < 23) {
                this.f1531.computeScrollOffset();
            }
            m851();
        }
    }

    public final void dispatchNestedScroll(int i, int i2, int i3, int i4, int[] iArr, int i5, int[] iArr2) {
        getScrollingChildHelper().m4626(i, i2, i3, i4, iArr, i5, iArr2);
    }

    @Override // android.view.ViewGroup
    public ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        AbstractC0254 r0 = this.mLayout;
        if (r0 != null) {
            return r0.generateLayoutParams(layoutParams);
        }
        throw new IllegalStateException(C1293.m3407(this, C1293.m3416("RecyclerView has no LayoutManager")));
    }

    public void smoothScrollBy(int i, int i2, Interpolator interpolator, int i3, boolean z) {
        AbstractC0254 r0 = this.mLayout;
        if (r0 == null) {
            Log.e(TAG, "Cannot smooth scroll without a LayoutManager set. Call setLayoutManager with a non-null argument.");
        } else if (!this.mLayoutSuppressed) {
            int i4 = 0;
            if (!r0.canScrollHorizontally()) {
                i = 0;
            }
            if (!this.mLayout.canScrollVertically()) {
                i2 = 0;
            }
            if (i != 0 || i2 != 0) {
                if (i3 == Integer.MIN_VALUE || i3 > 0) {
                    if (z) {
                        if (i != 0) {
                            i4 = 1;
                        }
                        if (i2 != 0) {
                            i4 |= 2;
                        }
                        startNestedScroll(i4, 1);
                    }
                    this.mViewFlinger.m852(i, i2, i3, interpolator);
                    return;
                }
                scrollBy(i, i2);
            }
        }
    }

    /* renamed from: androidx.recyclerview.widget.RecyclerView$Ԛ  reason: contains not printable characters */
    public static class C0233 {

        /* renamed from: ῲ  reason: contains not printable characters */
        public int f1475 = 0;

        /* renamed from: K  reason: contains not printable characters */
        public SparseArray<C0234> f1476 = new SparseArray<>();

        /* renamed from: androidx.recyclerview.widget.RecyclerView$Ԛ$K  reason: contains not printable characters */
        public static class C0234 {

            /* renamed from: ʬ  reason: contains not printable characters */
            public long f1477 = 0;

            /* renamed from: ῲ  reason: contains not printable characters */
            public int f1478 = 5;

            /* renamed from: K  reason: contains not printable characters */
            public final ArrayList<AbstractC0269> f1479 = new ArrayList<>();

            /* renamed from: 㸾  reason: contains not printable characters */
            public long f1480 = 0;
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public void m803() {
            this.f1475--;
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m808(AbstractC0269 r4) {
            int itemViewType = r4.getItemViewType();
            ArrayList<AbstractC0269> arrayList = m805(itemViewType).f1479;
            if (this.f1476.get(itemViewType).f1478 > arrayList.size()) {
                r4.resetInternal();
                arrayList.add(r4);
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public long m804(long j, long j2) {
            if (j == 0) {
                return j2;
            }
            return (j2 / 4) + ((j / 4) * 3);
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m806() {
            this.f1475++;
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m807(AbstractC0246 r1, AbstractC0246 r2, boolean z) {
            if (r1 != null) {
                this.f1475--;
            }
            if (!z && this.f1475 == 0) {
                for (int i = 0; i < this.f1476.size(); i++) {
                    this.f1476.valueAt(i).f1479.clear();
                }
            }
            if (r2 != null) {
                this.f1475++;
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public final C0234 m805(int i) {
            C0234 k = this.f1476.get(i);
            if (k != null) {
                return k;
            }
            C0234 k2 = new C0234();
            this.f1476.put(i, k2);
            return k2;
        }
    }

    public void addItemDecoration(AbstractC0232 r2) {
        addItemDecoration(r2, -1);
    }

    /* renamed from: androidx.recyclerview.widget.RecyclerView$ᑓ  reason: contains not printable characters */
    public static abstract class AbstractC0238 {
        public AbstractC0254 mLayoutManager;
        public boolean mPendingInitialRun;
        public RecyclerView mRecyclerView;
        public final C0240 mRecyclingAction = new C0240(0, 0);
        public boolean mRunning;
        public boolean mStarted;
        public int mTargetPosition = -1;
        public View mTargetView;

        /* renamed from: androidx.recyclerview.widget.RecyclerView$ᑓ$ῲ  reason: contains not printable characters */
        public interface AbstractC0239 {
            PointF computeScrollVectorForPosition(int i);
        }

        public PointF computeScrollVectorForPosition(int i) {
            AbstractC0254 layoutManager = getLayoutManager();
            if (layoutManager instanceof AbstractC0239) {
                return ((AbstractC0239) layoutManager).computeScrollVectorForPosition(i);
            }
            StringBuilder r3 = C1293.m3416("You should override computeScrollVectorForPosition when the LayoutManager does not implement ");
            r3.append(AbstractC0239.class.getCanonicalName());
            Log.w(RecyclerView.TAG, r3.toString());
            return null;
        }

        public View findViewByPosition(int i) {
            return this.mRecyclerView.mLayout.findViewByPosition(i);
        }

        public int getChildCount() {
            return this.mRecyclerView.mLayout.getChildCount();
        }

        public int getChildPosition(View view) {
            return this.mRecyclerView.getChildLayoutPosition(view);
        }

        public AbstractC0254 getLayoutManager() {
            return this.mLayoutManager;
        }

        public int getTargetPosition() {
            return this.mTargetPosition;
        }

        @Deprecated
        public void instantScrollToPosition(int i) {
            this.mRecyclerView.scrollToPosition(i);
        }

        public boolean isPendingInitialRun() {
            return this.mPendingInitialRun;
        }

        public boolean isRunning() {
            return this.mRunning;
        }

        public void normalize(PointF pointF) {
            float f = pointF.x;
            float f2 = pointF.y;
            float sqrt = (float) Math.sqrt((double) ((f2 * f2) + (f * f)));
            pointF.x /= sqrt;
            pointF.y /= sqrt;
        }

        public void onAnimation(int i, int i2) {
            PointF computeScrollVectorForPosition;
            RecyclerView recyclerView = this.mRecyclerView;
            if (this.mTargetPosition == -1 || recyclerView == null) {
                stop();
            }
            if (!(!this.mPendingInitialRun || this.mTargetView != null || this.mLayoutManager == null || (computeScrollVectorForPosition = computeScrollVectorForPosition(this.mTargetPosition)) == null || (computeScrollVectorForPosition.x == 0.0f && computeScrollVectorForPosition.y == 0.0f))) {
                recyclerView.scrollStep((int) Math.signum(computeScrollVectorForPosition.x), (int) Math.signum(computeScrollVectorForPosition.y), null);
            }
            boolean z = false;
            this.mPendingInitialRun = false;
            View view = this.mTargetView;
            if (view != null) {
                if (getChildPosition(view) == this.mTargetPosition) {
                    onTargetFound(this.mTargetView, recyclerView.mState, this.mRecyclingAction);
                    this.mRecyclingAction.m820(recyclerView);
                    stop();
                } else {
                    Log.e(RecyclerView.TAG, "Passed over target position while smooth scrolling.");
                    this.mTargetView = null;
                }
            }
            if (this.mRunning) {
                onSeekTargetStep(i, i2, recyclerView.mState, this.mRecyclingAction);
                if (this.mRecyclingAction.f1492 >= 0) {
                    z = true;
                }
                this.mRecyclingAction.m820(recyclerView);
                if (z && this.mRunning) {
                    this.mPendingInitialRun = true;
                    recyclerView.mViewFlinger.m851();
                }
            }
        }

        public void onChildAttachedToWindow(View view) {
            if (getChildPosition(view) == getTargetPosition()) {
                this.mTargetView = view;
            }
        }

        public abstract void onSeekTargetStep(int i, int i2, C0248 v, C0240 k);

        public abstract void onStart();

        public abstract void onStop();

        public abstract void onTargetFound(View view, C0248 v, C0240 k);

        public void setTargetPosition(int i) {
            this.mTargetPosition = i;
        }

        public void start(RecyclerView recyclerView, AbstractC0254 r4) {
            recyclerView.mViewFlinger.m850();
            if (this.mStarted) {
                StringBuilder r0 = C1293.m3416("An instance of ");
                r0.append(getClass().getSimpleName());
                r0.append(" was started more than once. Each instance of");
                r0.append(getClass().getSimpleName());
                r0.append(" is intended to only be used once. You should create a new instance for each use.");
                Log.w(RecyclerView.TAG, r0.toString());
            }
            this.mRecyclerView = recyclerView;
            this.mLayoutManager = r4;
            int i = this.mTargetPosition;
            if (i != -1) {
                this.mRecyclerView.mState.f1504 = i;
                this.mRunning = true;
                this.mPendingInitialRun = true;
                this.mTargetView = findViewByPosition(getTargetPosition());
                onStart();
                this.mRecyclerView.mViewFlinger.m851();
                this.mStarted = true;
                return;
            }
            throw new IllegalArgumentException("Invalid target position");
        }

        public final void stop() {
            if (this.mRunning) {
                this.mRunning = false;
                onStop();
                this.mRecyclerView.mState.f1504 = -1;
                this.mTargetView = null;
                this.mTargetPosition = -1;
                this.mPendingInitialRun = false;
                this.mLayoutManager.onSmoothScrollerStopped(this);
                this.mLayoutManager = null;
                this.mRecyclerView = null;
            }
        }

        /* renamed from: androidx.recyclerview.widget.RecyclerView$ᑓ$K  reason: contains not printable characters */
        public static class C0240 {

            /* renamed from: ʬ  reason: contains not printable characters */
            public int f1486;

            /* renamed from: ඓ  reason: contains not printable characters */
            public Interpolator f1487;

            /* renamed from: ῲ  reason: contains not printable characters */
            public int f1488;

            /* renamed from: ⁱ  reason: contains not printable characters */
            public int f1489 = 0;

            /* renamed from: K  reason: contains not printable characters */
            public int f1490;

            /* renamed from: 㴹  reason: contains not printable characters */
            public boolean f1491 = false;

            /* renamed from: 㸾  reason: contains not printable characters */
            public int f1492 = -1;

            public C0240(int i, int i2) {
                this.f1490 = i;
                this.f1488 = i2;
                this.f1486 = Integer.MIN_VALUE;
                this.f1487 = null;
            }

            /* renamed from: K  reason: contains not printable characters */
            public void m820(RecyclerView recyclerView) {
                int i = this.f1492;
                if (i >= 0) {
                    this.f1492 = -1;
                    recyclerView.jumpToPositionForSmoothScroller(i);
                    this.f1491 = false;
                } else if (!this.f1491) {
                    this.f1489 = 0;
                } else if (this.f1487 == null || this.f1486 >= 1) {
                    int i2 = this.f1486;
                    if (i2 >= 1) {
                        recyclerView.mViewFlinger.m852(this.f1490, this.f1488, i2, this.f1487);
                        this.f1489++;
                        if (this.f1489 > 10) {
                            Log.e(RecyclerView.TAG, "Smooth Scroll action is being updated too frequently. Make sure you are not changing it unless necessary");
                        }
                        this.f1491 = false;
                        return;
                    }
                    throw new IllegalStateException("Scroll duration must be a positive number");
                } else {
                    throw new IllegalStateException("If you provide an interpolator, you must set a positive duration");
                }
            }

            /* renamed from: K  reason: contains not printable characters */
            public void m819(int i, int i2, int i3, Interpolator interpolator) {
                this.f1490 = i;
                this.f1488 = i2;
                this.f1486 = i3;
                this.f1487 = interpolator;
                this.f1491 = true;
            }
        }
    }
}
