package androidx.media;

import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.service.media.MediaBrowserService;
import android.support.v4.media.MediaBrowserCompat;
import android.support.v4.media.session.IMediaSession;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.os.ResultReceiver;
import android.text.TextUtils;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import ඓ.K.K.K.C1293;
import ῲ.ݜ.AbstractC1598;
import ῲ.ݜ.AbstractC1602;
import ῲ.ݜ.C1590;
import ῲ.ݜ.C1592;
import ῲ.ݜ.C1593;
import ῲ.ݜ.C1594;
import ῲ.ݜ.C1596;
import ῲ.ݜ.C1605;
import ῲ.ݜ.C1606;
import ῲ.ݜ.RunnableC1588;
import ῲ.ݜ.RunnableC1591;
import ῲ.ݜ.RunnableC1595;
import ῲ.ݜ.RunnableC1597;
import ῲ.ݜ.RunnableC1603;
import ῲ.ݜ.RunnableC1604;
import ῲ.ᨨ.㳳.C1841;
import ῲ.ᨨ.㿎.C1865;
import ῲ.㴹.C2284;
import K.K.K.ʬ.C2369;

public abstract class MediaBrowserServiceCompat extends Service {

    /* renamed from: ⁱ  reason: contains not printable characters */
    public static final boolean f1378 = Log.isLoggable("MBServiceCompat", 3);

    /* renamed from: ʬ  reason: contains not printable characters */
    public final C2284<IBinder, C0213> f1379 = new C2284<>();

    /* renamed from: ඓ  reason: contains not printable characters */
    public final HandlerC0201 f1380 = new HandlerC0201();

    /* renamed from: ῲ  reason: contains not printable characters */
    public AbstractC0207 f1381;

    /* renamed from: 㴹  reason: contains not printable characters */
    public MediaSessionCompat.Token f1382;

    /* renamed from: 㸾  reason: contains not printable characters */
    public C0213 f1383;

    /* renamed from: androidx.media.MediaBrowserServiceCompat$ʬ  reason: contains not printable characters */
    public class C0199 extends C0209<List<MediaBrowserCompat.MediaItem>> {

        /* renamed from: 㴹  reason: contains not printable characters */
        public final /* synthetic */ ResultReceiver f1384;

        /* JADX INFO: super call moved to the top of the method (can break code semantics) */
        public C0199(MediaBrowserServiceCompat mediaBrowserServiceCompat, Object obj, ResultReceiver resultReceiver) {
            super(obj);
            this.f1384 = resultReceiver;
        }

        /* JADX DEBUG: Method arguments types fixed to match base method, original types: [java.lang.Object] */
        @Override // androidx.media.MediaBrowserServiceCompat.C0209
        /* renamed from: K  reason: contains not printable characters */
        public void m738(List<MediaBrowserCompat.MediaItem> list) {
            List<MediaBrowserCompat.MediaItem> list2 = list;
            if ((this.f1396 & 4) != 0 || list2 == null) {
                this.f1384.send(-1, null);
                return;
            }
            Bundle bundle = new Bundle();
            bundle.putParcelableArray("search_results", (Parcelable[]) list2.toArray(new MediaBrowserCompat.MediaItem[0]));
            this.f1384.send(0, bundle);
        }
    }

    /* renamed from: androidx.media.MediaBrowserServiceCompat$Ԕ  reason: contains not printable characters */
    public interface AbstractC0200 {
    }

    /* renamed from: androidx.media.MediaBrowserServiceCompat$ؿ  reason: contains not printable characters */
    public final class HandlerC0201 extends Handler {

        /* renamed from: K  reason: contains not printable characters */
        public final C0218 f1386 = new C0218();

        public HandlerC0201() {
        }

        public void handleMessage(Message message) {
            Bundle data = message.getData();
            switch (message.what) {
                case 1:
                    Bundle bundle = data.getBundle("data_root_hints");
                    MediaSessionCompat.ensureClassLoader(bundle);
                    C0218 r3 = this.f1386;
                    String string = data.getString("data_package_name");
                    int i = data.getInt(MediaSessionCompat.DATA_CALLING_PID);
                    int i2 = data.getInt(MediaSessionCompat.DATA_CALLING_UID);
                    C0210 r7 = new C0210(message.replyTo);
                    if (MediaBrowserServiceCompat.this.m736(string, i2)) {
                        MediaBrowserServiceCompat.this.f1380.m739(new RunnableC1597(r3, r7, string, i, i2, bundle));
                        return;
                    }
                    throw new IllegalArgumentException("Package/uid mismatch: uid=" + i2 + " package=" + string);
                case 2:
                    C0218 r2 = this.f1386;
                    MediaBrowserServiceCompat.this.f1380.m739(new RunnableC1595(r2, new C0210(message.replyTo)));
                    return;
                case 3:
                    Bundle bundle2 = data.getBundle("data_options");
                    MediaSessionCompat.ensureClassLoader(bundle2);
                    C0218 r12 = this.f1386;
                    String string2 = data.getString("data_media_item_id");
                    IBinder r15 = C2369.m6308(data, "data_callback_token");
                    MediaBrowserServiceCompat.this.f1380.m739(new RunnableC1588(r12, new C0210(message.replyTo), string2, r15, bundle2));
                    return;
                case 4:
                    C0218 r32 = this.f1386;
                    String string3 = data.getString("data_media_item_id");
                    IBinder r22 = C2369.m6308(data, "data_callback_token");
                    MediaBrowserServiceCompat.this.f1380.m739(new RunnableC1604(r32, new C0210(message.replyTo), string3, r22));
                    return;
                case 5:
                    this.f1386.m766(data.getString("data_media_item_id"), (ResultReceiver) data.getParcelable("data_result_receiver"), new C0210(message.replyTo));
                    return;
                case 6:
                    Bundle bundle3 = data.getBundle("data_root_hints");
                    MediaSessionCompat.ensureClassLoader(bundle3);
                    C0218 r33 = this.f1386;
                    MediaBrowserServiceCompat.this.f1380.m739(new RunnableC1591(r33, new C0210(message.replyTo), data.getString("data_package_name"), data.getInt(MediaSessionCompat.DATA_CALLING_PID), data.getInt(MediaSessionCompat.DATA_CALLING_UID), bundle3));
                    return;
                case 7:
                    C0218 r23 = this.f1386;
                    MediaBrowserServiceCompat.this.f1380.m739(new RunnableC1603(r23, new C0210(message.replyTo)));
                    return;
                case 8:
                    Bundle bundle4 = data.getBundle("data_search_extras");
                    MediaSessionCompat.ensureClassLoader(bundle4);
                    this.f1386.m765(data.getString("data_search_query"), bundle4, (ResultReceiver) data.getParcelable("data_result_receiver"), new C0210(message.replyTo));
                    return;
                case 9:
                    Bundle bundle5 = data.getBundle("data_custom_action_extras");
                    MediaSessionCompat.ensureClassLoader(bundle5);
                    this.f1386.m764(data.getString("data_custom_action"), bundle5, (ResultReceiver) data.getParcelable("data_result_receiver"), new C0210(message.replyTo));
                    return;
                default:
                    Log.w("MBServiceCompat", "Unhandled message: " + message + "\n  Service version: " + 2 + "\n  Client version: " + message.arg1);
                    return;
            }
        }

        public boolean sendMessageAtTime(Message message, long j) {
            Bundle data = message.getData();
            data.setClassLoader(MediaBrowserCompat.class.getClassLoader());
            data.putInt(MediaSessionCompat.DATA_CALLING_UID, Binder.getCallingUid());
            data.putInt(MediaSessionCompat.DATA_CALLING_PID, Binder.getCallingPid());
            return super.sendMessageAtTime(message, j);
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m739(Runnable runnable) {
            if (Thread.currentThread() == getLooper().getThread()) {
                runnable.run();
            } else {
                post(runnable);
            }
        }
    }

    /* renamed from: androidx.media.MediaBrowserServiceCompat$ඓ  reason: contains not printable characters */
    public static final class C0202 {
    }

    /* renamed from: androidx.media.MediaBrowserServiceCompat$ᕣ  reason: contains not printable characters */
    public class C0203 extends C0211 {
        public C0203(MediaBrowserServiceCompat mediaBrowserServiceCompat) {
            super();
        }
    }

    /* renamed from: androidx.media.MediaBrowserServiceCompat$ᨨ  reason: contains not printable characters */
    public class C0204 extends C0216 implements AbstractC1598 {

        /* renamed from: androidx.media.MediaBrowserServiceCompat$ᨨ$K  reason: contains not printable characters */
        public class C0205 extends C0209<MediaBrowserCompat.MediaItem> {

            /* renamed from: 㴹  reason: contains not printable characters */
            public final /* synthetic */ C1594 f1388;

            /* JADX INFO: super call moved to the top of the method (can break code semantics) */
            public C0205(C0204 r1, Object obj, C1594 r3) {
                super(obj);
                this.f1388 = r3;
            }

            /* JADX DEBUG: Method arguments types fixed to match base method, original types: [java.lang.Object] */
            @Override // androidx.media.MediaBrowserServiceCompat.C0209
            /* renamed from: K  reason: contains not printable characters */
            public void m742(MediaBrowserCompat.MediaItem mediaItem) {
                MediaBrowserCompat.MediaItem mediaItem2 = mediaItem;
                if (mediaItem2 == null) {
                    this.f1388.m4148(null);
                    return;
                }
                Parcel obtain = Parcel.obtain();
                mediaItem2.writeToParcel(obtain, 0);
                this.f1388.m4148(obtain);
            }
        }

        public C0204() {
            super();
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public void m740(String str, C1594<Parcel> r3) {
            MediaBrowserServiceCompat.this.m724(new C0205(this, str, r3));
        }

        @Override // androidx.media.MediaBrowserServiceCompat.AbstractC0207, androidx.media.MediaBrowserServiceCompat.C0216
        /* renamed from: K  reason: contains not printable characters */
        public void m741() {
            this.f1411 = new C1593(MediaBrowserServiceCompat.this, this);
            ((MediaBrowserService) this.f1411).onCreate();
        }
    }

    /* renamed from: androidx.media.MediaBrowserServiceCompat$ῲ  reason: contains not printable characters */
    public class C0206 extends C0209<MediaBrowserCompat.MediaItem> {

        /* renamed from: 㴹  reason: contains not printable characters */
        public final /* synthetic */ ResultReceiver f1389;

        /* JADX INFO: super call moved to the top of the method (can break code semantics) */
        public C0206(MediaBrowserServiceCompat mediaBrowserServiceCompat, Object obj, ResultReceiver resultReceiver) {
            super(obj);
            this.f1389 = resultReceiver;
        }

        /* JADX DEBUG: Method arguments types fixed to match base method, original types: [java.lang.Object] */
        @Override // androidx.media.MediaBrowserServiceCompat.C0209
        /* renamed from: K  reason: contains not printable characters */
        public void m743(MediaBrowserCompat.MediaItem mediaItem) {
            MediaBrowserCompat.MediaItem mediaItem2 = mediaItem;
            if ((this.f1396 & 2) != 0) {
                this.f1389.send(-1, null);
                return;
            }
            Bundle bundle = new Bundle();
            bundle.putParcelable("media_item", mediaItem2);
            this.f1389.send(0, bundle);
        }
    }

    /* renamed from: androidx.media.MediaBrowserServiceCompat$ⁱ  reason: contains not printable characters */
    public interface AbstractC0207 {
        /* renamed from: K  reason: contains not printable characters */
        IBinder m744(Intent intent);

        /* renamed from: K  reason: contains not printable characters */
        void m745();
    }

    /* renamed from: androidx.media.MediaBrowserServiceCompat$K  reason: contains not printable characters */
    public class C0208 extends C0209<List<MediaBrowserCompat.MediaItem>> {

        /* renamed from: ᨨ  reason: contains not printable characters */
        public final /* synthetic */ Bundle f1390;

        /* renamed from: ⁱ  reason: contains not printable characters */
        public final /* synthetic */ String f1391;

        /* renamed from: 㴹  reason: contains not printable characters */
        public final /* synthetic */ C0213 f1393;

        /* renamed from: 㿎  reason: contains not printable characters */
        public final /* synthetic */ Bundle f1394;

        /* JADX INFO: super call moved to the top of the method (can break code semantics) */
        public C0208(Object obj, C0213 r3, String str, Bundle bundle, Bundle bundle2) {
            super(obj);
            this.f1393 = r3;
            this.f1391 = str;
            this.f1394 = bundle;
            this.f1390 = bundle2;
        }

        /* JADX DEBUG: Method arguments types fixed to match base method, original types: [java.lang.Object] */
        @Override // androidx.media.MediaBrowserServiceCompat.C0209
        /* renamed from: K  reason: contains not printable characters */
        public void m746(List<MediaBrowserCompat.MediaItem> list) {
            List<MediaBrowserCompat.MediaItem> list2 = list;
            if (MediaBrowserServiceCompat.this.f1379.get(((C0210) this.f1393.f1405).m751()) == this.f1393) {
                if ((this.f1396 & 1) != 0) {
                    list2 = MediaBrowserServiceCompat.this.m727(list2, this.f1394);
                }
                try {
                    ((C0210) this.f1393.f1405).m753(this.f1391, list2, this.f1394, this.f1390);
                } catch (RemoteException unused) {
                    StringBuilder r6 = C1293.m3416("Calling onLoadChildren() failed for id=");
                    r6.append(this.f1391);
                    r6.append(" package=");
                    r6.append(this.f1393.f1406);
                    Log.w("MBServiceCompat", r6.toString());
                }
            } else if (MediaBrowserServiceCompat.f1378) {
                StringBuilder r62 = C1293.m3416("Not sending onLoadChildren result for connection that has been disconnected. pkg=");
                r62.append(this.f1393.f1406);
                r62.append(" id=");
                r62.append(this.f1391);
                Log.d("MBServiceCompat", r62.toString());
            }
        }
    }

    /* renamed from: androidx.media.MediaBrowserServiceCompat$㑃  reason: contains not printable characters */
    public static class C0209<T> {

        /* renamed from: ʬ  reason: contains not printable characters */
        public boolean f1395;

        /* renamed from: ඓ  reason: contains not printable characters */
        public int f1396;

        /* renamed from: ῲ  reason: contains not printable characters */
        public boolean f1397;

        /* renamed from: K  reason: contains not printable characters */
        public final Object f1398;

        /* renamed from: 㸾  reason: contains not printable characters */
        public boolean f1399;

        public C0209(Object obj) {
            this.f1398 = obj;
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public void m747(T t) {
            if (this.f1395 || this.f1399) {
                StringBuilder r0 = C1293.m3416("sendResult() called when either sendResult() or sendError() had already been called for: ");
                r0.append(this.f1398);
                throw new IllegalStateException(r0.toString());
            }
            this.f1395 = true;
            m749((Object) t);
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m749(T t) {
            throw null;
        }

        /* renamed from: K  reason: contains not printable characters */
        public boolean m750() {
            return this.f1397 || this.f1395 || this.f1399;
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m748(Bundle bundle) {
            StringBuilder r0 = C1293.m3416("It is not supported to send an error for ");
            r0.append(this.f1398);
            throw new UnsupportedOperationException(r0.toString());
        }
    }

    /* renamed from: androidx.media.MediaBrowserServiceCompat$㗗  reason: contains not printable characters */
    public static class C0210 implements AbstractC0200 {

        /* renamed from: K  reason: contains not printable characters */
        public final Messenger f1400;

        public C0210(Messenger messenger) {
            this.f1400 = messenger;
        }

        /* renamed from: K  reason: contains not printable characters */
        public IBinder m751() {
            return this.f1400.getBinder();
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m753(String str, List<MediaBrowserCompat.MediaItem> list, Bundle bundle, Bundle bundle2) throws RemoteException {
            Bundle bundle3 = new Bundle();
            bundle3.putString("data_media_item_id", str);
            bundle3.putBundle("data_options", bundle);
            bundle3.putBundle("data_notify_children_changed_options", bundle2);
            if (list != null) {
                bundle3.putParcelableArrayList("data_media_item_list", list instanceof ArrayList ? (ArrayList) list : new ArrayList<>(list));
            }
            m752(3, bundle3);
        }

        /* renamed from: K  reason: contains not printable characters */
        public final void m752(int i, Bundle bundle) throws RemoteException {
            Message obtain = Message.obtain();
            obtain.what = i;
            obtain.arg1 = 2;
            obtain.setData(bundle);
            this.f1400.send(obtain);
        }
    }

    /* renamed from: androidx.media.MediaBrowserServiceCompat$㴹  reason: contains not printable characters */
    public class C0213 implements IBinder.DeathRecipient {

        /* renamed from: ʬ  reason: contains not printable characters */
        public final HashMap<String, List<C1865<IBinder, Bundle>>> f1403 = new HashMap<>();

        /* renamed from: ῲ  reason: contains not printable characters */
        public final AbstractC0200 f1405;

        /* renamed from: K  reason: contains not printable characters */
        public final String f1406;

        /* renamed from: 㸾  reason: contains not printable characters */
        public C0202 f1407;

        /* renamed from: androidx.media.MediaBrowserServiceCompat$㴹$K  reason: contains not printable characters */
        public class RunnableC0214 implements Runnable {
            public RunnableC0214() {
            }

            public void run() {
                C0213 r0 = C0213.this;
                MediaBrowserServiceCompat.this.f1379.remove(((C0210) r0.f1405).m751());
            }
        }

        public C0213(String str, int i, int i2, Bundle bundle, AbstractC0200 r6) {
            this.f1406 = str;
            if (Build.VERSION.SDK_INT >= 28) {
                new C1590(str, i, i2);
            } else {
                new C1592(str, i, i2);
            }
            this.f1405 = r6;
        }

        public void binderDied() {
            MediaBrowserServiceCompat.this.f1380.post(new RunnableC0214());
        }
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] strArr) {
    }

    public IBinder onBind(Intent intent) {
        return this.f1381.m744(intent);
    }

    public void onCreate() {
        super.onCreate();
        int i = Build.VERSION.SDK_INT;
        if (i >= 28) {
            this.f1381 = new C0203(this);
        } else if (i >= 26) {
            this.f1381 = new C0211();
        } else if (i >= 23) {
            this.f1381 = new C0204();
        } else {
            this.f1381 = new C0216();
        }
        this.f1381.m745();
    }

    /* JADX WARN: Incorrect args count in method signature: (Ljava/lang/String;Landroid/os/Bundle;Landroidx/media/MediaBrowserServiceCompat$㑃<Ljava/util/List<Landroid/support/v4/media/MediaBrowserCompat$MediaItem;>;>;)V */
    /* renamed from: ʬ  reason: contains not printable characters */
    public void m722(C0209 r2) {
        r2.f1396 = 4;
        r2.m747(null);
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public void m723() {
    }

    /* JADX WARN: Incorrect args count in method signature: (Ljava/lang/String;Landroidx/media/MediaBrowserServiceCompat$㑃<Ljava/util/List<Landroid/support/v4/media/MediaBrowserCompat$MediaItem;>;>;Landroid/os/Bundle;)V */
    /* renamed from: ῲ  reason: contains not printable characters */
    public void m726(String str, C0209 r3) {
        r3.f1396 = 1;
        m732(str, r3);
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m728() {
    }

    /* JADX WARN: Incorrect args count in method signature: (Ljava/lang/String;Landroid/os/Bundle;Landroidx/media/MediaBrowserServiceCompat$㑃<Landroid/os/Bundle;>;)V */
    /* renamed from: K  reason: contains not printable characters */
    public void m729(C0209 r3) {
        if (r3.f1395 || r3.f1399) {
            StringBuilder r1 = C1293.m3416("sendError() called when either sendResult() or sendError() had already been called for: ");
            r1.append(r3.f1398);
            throw new IllegalStateException(r1.toString());
        }
        r3.f1399 = true;
        r3.m748((Bundle) null);
    }

    /* renamed from: K  reason: contains not printable characters */
    public abstract void m730(String str, int i, Bundle bundle);

    /* renamed from: K  reason: contains not printable characters */
    public abstract void m732(String str, C0209<List<MediaBrowserCompat.MediaItem>> v);

    /* renamed from: androidx.media.MediaBrowserServiceCompat$㸾  reason: contains not printable characters */
    public class C0215 extends C0209<Bundle> {

        /* renamed from: 㴹  reason: contains not printable characters */
        public final /* synthetic */ ResultReceiver f1409;

        /* JADX INFO: super call moved to the top of the method (can break code semantics) */
        public C0215(MediaBrowserServiceCompat mediaBrowserServiceCompat, Object obj, ResultReceiver resultReceiver) {
            super(obj);
            this.f1409 = resultReceiver;
        }

        /* JADX DEBUG: Method arguments types fixed to match base method, original types: [java.lang.Object] */
        @Override // androidx.media.MediaBrowserServiceCompat.C0209
        /* renamed from: K  reason: contains not printable characters */
        public void m758(Bundle bundle) {
            this.f1409.send(0, bundle);
        }

        @Override // androidx.media.MediaBrowserServiceCompat.C0209
        /* renamed from: K  reason: contains not printable characters */
        public void m757(Bundle bundle) {
            this.f1409.send(-1, bundle);
        }
    }

    /* renamed from: androidx.media.MediaBrowserServiceCompat$䁗  reason: contains not printable characters */
    public class C0218 {

        /* renamed from: androidx.media.MediaBrowserServiceCompat$䁗$ʬ  reason: contains not printable characters */
        public class RunnableC0219 implements Runnable {

            /* renamed from: ʬ  reason: contains not printable characters */
            public final /* synthetic */ String f1416;

            /* renamed from: ඓ  reason: contains not printable characters */
            public final /* synthetic */ ResultReceiver f1417;

            /* renamed from: ῲ  reason: contains not printable characters */
            public final /* synthetic */ AbstractC0200 f1418;

            /* renamed from: 㸾  reason: contains not printable characters */
            public final /* synthetic */ Bundle f1420;

            public RunnableC0219(AbstractC0200 r2, String str, Bundle bundle, ResultReceiver resultReceiver) {
                this.f1418 = r2;
                this.f1416 = str;
                this.f1420 = bundle;
                this.f1417 = resultReceiver;
            }

            public void run() {
                C0213 r0 = MediaBrowserServiceCompat.this.f1379.get(((C0210) this.f1418).m751());
                if (r0 == null) {
                    StringBuilder r02 = C1293.m3416("sendCustomAction for callback that isn't registered action=");
                    r02.append(this.f1416);
                    r02.append(", extras=");
                    r02.append(this.f1420);
                    Log.w("MBServiceCompat", r02.toString());
                    return;
                }
                MediaBrowserServiceCompat.this.m731(this.f1416, this.f1420, r0, this.f1417);
            }
        }

        /* renamed from: androidx.media.MediaBrowserServiceCompat$䁗$ῲ  reason: contains not printable characters */
        public class RunnableC0220 implements Runnable {

            /* renamed from: ʬ  reason: contains not printable characters */
            public final /* synthetic */ String f1421;

            /* renamed from: ඓ  reason: contains not printable characters */
            public final /* synthetic */ ResultReceiver f1422;

            /* renamed from: ῲ  reason: contains not printable characters */
            public final /* synthetic */ AbstractC0200 f1423;

            /* renamed from: 㸾  reason: contains not printable characters */
            public final /* synthetic */ Bundle f1425;

            public RunnableC0220(AbstractC0200 r2, String str, Bundle bundle, ResultReceiver resultReceiver) {
                this.f1423 = r2;
                this.f1421 = str;
                this.f1425 = bundle;
                this.f1422 = resultReceiver;
            }

            public void run() {
                C0213 r0 = MediaBrowserServiceCompat.this.f1379.get(((C0210) this.f1423).m751());
                if (r0 == null) {
                    StringBuilder r02 = C1293.m3416("search for callback that isn't registered query=");
                    r02.append(this.f1421);
                    Log.w("MBServiceCompat", r02.toString());
                    return;
                }
                MediaBrowserServiceCompat.this.m725(this.f1421, this.f1425, r0, this.f1422);
            }
        }

        /* renamed from: androidx.media.MediaBrowserServiceCompat$䁗$K  reason: contains not printable characters */
        public class RunnableC0221 implements Runnable {

            /* renamed from: ʬ  reason: contains not printable characters */
            public final /* synthetic */ String f1426;

            /* renamed from: ῲ  reason: contains not printable characters */
            public final /* synthetic */ AbstractC0200 f1428;

            /* renamed from: 㸾  reason: contains not printable characters */
            public final /* synthetic */ ResultReceiver f1429;

            public RunnableC0221(AbstractC0200 r2, String str, ResultReceiver resultReceiver) {
                this.f1428 = r2;
                this.f1426 = str;
                this.f1429 = resultReceiver;
            }

            public void run() {
                C0213 r0 = MediaBrowserServiceCompat.this.f1379.get(((C0210) this.f1428).m751());
                if (r0 == null) {
                    StringBuilder r02 = C1293.m3416("getMediaItem for callback that isn't registered id=");
                    r02.append(this.f1426);
                    Log.w("MBServiceCompat", r02.toString());
                    return;
                }
                MediaBrowserServiceCompat.this.m735(this.f1426, r0, this.f1429);
            }
        }

        public C0218() {
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public void m764(String str, Bundle bundle, ResultReceiver resultReceiver, AbstractC0200 r12) {
            if (!TextUtils.isEmpty(str) && resultReceiver != null) {
                MediaBrowserServiceCompat.this.f1380.m739(new RunnableC0219(r12, str, bundle, resultReceiver));
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m766(String str, ResultReceiver resultReceiver, AbstractC0200 r5) {
            if (!TextUtils.isEmpty(str) && resultReceiver != null) {
                MediaBrowserServiceCompat.this.f1380.m739(new RunnableC0221(r5, str, resultReceiver));
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m765(String str, Bundle bundle, ResultReceiver resultReceiver, AbstractC0200 r12) {
            if (!TextUtils.isEmpty(str) && resultReceiver != null) {
                MediaBrowserServiceCompat.this.f1380.m739(new RunnableC0220(r12, str, bundle, resultReceiver));
            }
        }
    }

    /* renamed from: androidx.media.MediaBrowserServiceCompat$㳳  reason: contains not printable characters */
    public class C0211 extends C0204 implements C1606.AbstractC1607 {

        /* renamed from: androidx.media.MediaBrowserServiceCompat$㳳$K  reason: contains not printable characters */
        public class C0212 extends C0209<List<MediaBrowserCompat.MediaItem>> {

            /* renamed from: 㴹  reason: contains not printable characters */
            public final /* synthetic */ C1606.C1608 f1402;

            /* JADX INFO: super call moved to the top of the method (can break code semantics) */
            public C0212(C0211 r1, Object obj, C1606.C1608 r3) {
                super(obj);
                this.f1402 = r3;
            }

            /* JADX DEBUG: Method arguments types fixed to match base method, original types: [java.lang.Object] */
            @Override // androidx.media.MediaBrowserServiceCompat.C0209
            /* renamed from: K  reason: contains not printable characters */
            public void m756(List<MediaBrowserCompat.MediaItem> list) {
                ArrayList arrayList;
                List<MediaBrowserCompat.MediaItem> list2 = list;
                if (list2 != null) {
                    arrayList = new ArrayList();
                    for (MediaBrowserCompat.MediaItem mediaItem : list2) {
                        Parcel obtain = Parcel.obtain();
                        mediaItem.writeToParcel(obtain, 0);
                        arrayList.add(obtain);
                    }
                } else {
                    arrayList = null;
                }
                this.f1402.m4150(arrayList, this.f1396);
            }
        }

        public C0211() {
            super();
        }

        @Override // androidx.media.MediaBrowserServiceCompat.AbstractC0207, androidx.media.MediaBrowserServiceCompat.C0204, androidx.media.MediaBrowserServiceCompat.C0216
        /* renamed from: K  reason: contains not printable characters */
        public void m754() {
            this.f1411 = C1606.m4149(MediaBrowserServiceCompat.this, this);
            ((MediaBrowserService) this.f1411).onCreate();
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m755(String str, C1606.C1608 r2, Bundle bundle) {
            MediaBrowserServiceCompat.this.m726(str, new C0212(this, str, r2));
        }
    }

    /* JADX WARN: Incorrect args count in method signature: (Ljava/lang/String;Landroidx/media/MediaBrowserServiceCompat$㑃<Landroid/support/v4/media/MediaBrowserCompat$MediaItem;>;)V */
    /* renamed from: ῲ  reason: contains not printable characters */
    public void m724(C0209 r2) {
        r2.f1396 = 2;
        r2.m747(null);
    }

    /* renamed from: androidx.media.MediaBrowserServiceCompat$㿎  reason: contains not printable characters */
    public class C0216 implements AbstractC0207, AbstractC1602 {

        /* renamed from: ʬ  reason: contains not printable characters */
        public Messenger f1410;

        /* renamed from: ῲ  reason: contains not printable characters */
        public Object f1411;

        /* renamed from: K  reason: contains not printable characters */
        public final List<Bundle> f1412 = new ArrayList();

        /* renamed from: androidx.media.MediaBrowserServiceCompat$㿎$K  reason: contains not printable characters */
        public class C0217 extends C0209<List<MediaBrowserCompat.MediaItem>> {

            /* renamed from: 㴹  reason: contains not printable characters */
            public final /* synthetic */ C1594 f1414;

            /* JADX INFO: super call moved to the top of the method (can break code semantics) */
            public C0217(C0216 r1, Object obj, C1594 r3) {
                super(obj);
                this.f1414 = r3;
            }

            /* JADX DEBUG: Method arguments types fixed to match base method, original types: [java.lang.Object] */
            @Override // androidx.media.MediaBrowserServiceCompat.C0209
            /* renamed from: K  reason: contains not printable characters */
            public void m763(List<MediaBrowserCompat.MediaItem> list) {
                ArrayList arrayList;
                List<MediaBrowserCompat.MediaItem> list2 = list;
                if (list2 != null) {
                    arrayList = new ArrayList();
                    for (MediaBrowserCompat.MediaItem mediaItem : list2) {
                        Parcel obtain = Parcel.obtain();
                        mediaItem.writeToParcel(obtain, 0);
                        arrayList.add(obtain);
                    }
                } else {
                    arrayList = null;
                }
                this.f1414.m4148(arrayList);
            }
        }

        public C0216() {
        }

        @Override // androidx.media.MediaBrowserServiceCompat.AbstractC0207
        /* renamed from: K  reason: contains not printable characters */
        public void m761() {
            this.f1411 = new C1605(MediaBrowserServiceCompat.this, this);
            ((MediaBrowserService) this.f1411).onCreate();
        }

        @Override // androidx.media.MediaBrowserServiceCompat.AbstractC0207
        /* renamed from: K  reason: contains not printable characters */
        public IBinder m759(Intent intent) {
            return ((MediaBrowserService) this.f1411).onBind(intent);
        }

        /* renamed from: K  reason: contains not printable characters */
        public C1596 m760(String str, int i, Bundle bundle) {
            IBinder iBinder;
            if (!(bundle == null || bundle.getInt("extra_client_version", 0) == 0)) {
                bundle.remove("extra_client_version");
                this.f1410 = new Messenger(MediaBrowserServiceCompat.this.f1380);
                Bundle bundle2 = new Bundle();
                bundle2.putInt("extra_service_version", 2);
                IBinder binder = this.f1410.getBinder();
                int i2 = Build.VERSION.SDK_INT;
                bundle2.putBinder("extra_messenger", binder);
                MediaSessionCompat.Token token = MediaBrowserServiceCompat.this.f1382;
                if (token != null) {
                    IMediaSession extraBinder = token.getExtraBinder();
                    if (extraBinder == null) {
                        iBinder = null;
                    } else {
                        iBinder = extraBinder.asBinder();
                    }
                    int i3 = Build.VERSION.SDK_INT;
                    bundle2.putBinder("extra_session_binder", iBinder);
                } else {
                    this.f1412.add(bundle2);
                }
            }
            MediaBrowserServiceCompat mediaBrowserServiceCompat = MediaBrowserServiceCompat.this;
            mediaBrowserServiceCompat.f1383 = new C0213(str, -1, i, bundle, null);
            MediaBrowserServiceCompat.this.m730(str, i, bundle);
            MediaBrowserServiceCompat.this.f1383 = null;
            return null;
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m762(String str, C1594<List<Parcel>> r3) {
            MediaBrowserServiceCompat.this.m732(str, new C0217(this, str, r3));
        }
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public void m725(String str, Bundle bundle, C0213 r3, ResultReceiver resultReceiver) {
        C0199 r2 = new C0199(this, str, resultReceiver);
        m722(r2);
        if (!r2.m750()) {
            throw new IllegalStateException(C1293.m3412("onSearch must call detach() or sendResult() before returning for query=", str));
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public boolean m736(String str, int i) {
        if (str == null) {
            return false;
        }
        for (String str2 : getPackageManager().getPackagesForUid(i)) {
            if (str2.equals(str)) {
                return true;
            }
        }
        return false;
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m734(String str, C0213 r6, IBinder iBinder, Bundle bundle) {
        List<C1865<IBinder, Bundle>> list = r6.f1403.get(str);
        if (list == null) {
            list = new ArrayList<>();
        }
        for (C1865<IBinder, Bundle> r2 : list) {
            if (iBinder == r2.f6311 && C1841.m4802(bundle, (Bundle) r2.f6310)) {
                return;
            }
        }
        list.add(new C1865<>(iBinder, bundle));
        r6.f1403.put(str, list);
        m733(str, r6, bundle, (Bundle) null);
        m728();
    }

    /* renamed from: K  reason: contains not printable characters */
    public boolean m737(String str, C0213 r7, IBinder iBinder) {
        boolean z = true;
        boolean z2 = false;
        if (iBinder == null) {
            try {
                if (r7.f1403.remove(str) == null) {
                    z = false;
                }
                return z;
            } finally {
                m723();
            }
        } else {
            List<C1865<IBinder, Bundle>> list = r7.f1403.get(str);
            if (list != null) {
                Iterator<C1865<IBinder, Bundle>> it2 = list.iterator();
                while (it2.hasNext()) {
                    if (iBinder == it2.next().f6311) {
                        it2.remove();
                        z2 = true;
                    }
                }
                if (list.size() == 0) {
                    r7.f1403.remove(str);
                }
            }
            m723();
            return z2;
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m733(String str, C0213 r10, Bundle bundle, Bundle bundle2) {
        C0208 k = new C0208(str, r10, str, bundle, bundle2);
        if (bundle == null) {
            m732(str, k);
        } else {
            m726(str, k);
        }
        if (!k.m750()) {
            StringBuilder r12 = C1293.m3416("onLoadChildren must call detach() or sendResult() before returning for package=");
            r12.append(r10.f1406);
            r12.append(" id=");
            r12.append(str);
            throw new IllegalStateException(r12.toString());
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public List<MediaBrowserCompat.MediaItem> m727(List<MediaBrowserCompat.MediaItem> list, Bundle bundle) {
        if (list == null) {
            return null;
        }
        int i = bundle.getInt(MediaBrowserCompat.EXTRA_PAGE, -1);
        int i2 = bundle.getInt(MediaBrowserCompat.EXTRA_PAGE_SIZE, -1);
        if (i == -1 && i2 == -1) {
            return list;
        }
        int i3 = i2 * i;
        int i4 = i3 + i2;
        if (i < 0 || i2 < 1 || i3 >= list.size()) {
            return Collections.emptyList();
        }
        if (i4 > list.size()) {
            i4 = list.size();
        }
        return list.subList(i3, i4);
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m735(String str, C0213 r2, ResultReceiver resultReceiver) {
        C0206 r22 = new C0206(this, str, resultReceiver);
        m724(r22);
        if (!r22.m750()) {
            throw new IllegalStateException(C1293.m3412("onLoadItem must call detach() or sendResult() before returning for id=", str));
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m731(String str, Bundle bundle, C0213 r4, ResultReceiver resultReceiver) {
        C0215 r42 = new C0215(this, str, resultReceiver);
        m729(r42);
        if (!r42.m750()) {
            throw new IllegalStateException("onCustomAction must call detach() or sendResult() or sendError() before returning for action=" + str + " extras=" + bundle);
        }
    }
}
