package androidx.fragment.app;

import android.animation.Animator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LiveData;
import com.facebook.internal.security.CertificateUtil;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import ඓ.K.K.K.C1293;
import ῲ.Ԕ.K.AbstractC1513;
import ῲ.Ԕ.K.AbstractC1531;
import ῲ.Ԕ.K.AbstractC1542;
import ῲ.Ԕ.K.C1522;
import ῲ.Ԕ.K.C1541;
import ῲ.Ԕ.K.LayoutInflater$Factory2C1545;
import ῲ.Ԛ.AbstractC1560;
import ῲ.Ԛ.C1561;
import ῲ.Ԛ.C1562;
import ῲ.ؿ.AbstractC1569;
import ῲ.ؿ.AbstractC1574;
import ῲ.ؿ.AbstractC1586;
import ῲ.ؿ.C1568;
import ῲ.ؿ.C1578;
import ῲ.ؿ.C1584;
import ῲ.ᓣ.K.AbstractC1695;
import ῲ.ᓣ.K.C1690;
import ῲ.ᨨ.K.AbstractC1820;
import ῲ.ᨨ.K.C1826;
import K.K.K.ʬ.C2369;

public class Fragment implements ComponentCallbacks, View.OnCreateContextMenuListener, AbstractC1574, AbstractC1586, AbstractC1560 {
    public static final int ACTIVITY_CREATED = 2;
    public static final int CREATED = 1;
    public static final int INITIALIZING = 0;
    public static final int RESUMED = 4;
    public static final int STARTED = 3;
    public static final Object USE_DEFAULT_TRANSITION = new Object();
    public boolean mAdded;
    public C0185 mAnimationInfo;
    public Bundle mArguments;
    public int mBackStackNesting;
    public boolean mCalled;
    public LayoutInflater$Factory2C1545 mChildFragmentManager;
    public ViewGroup mContainer;
    public int mContainerId;
    public int mContentLayoutId;
    public boolean mDeferStart;
    public boolean mDetached;
    public int mFragmentId;
    public LayoutInflater$Factory2C1545 mFragmentManager;
    public boolean mFromLayout;
    public boolean mHasMenu;
    public boolean mHidden;
    public boolean mHiddenChanged;
    public AbstractC1542 mHost;
    public boolean mInLayout;
    public View mInnerView;
    public boolean mIsCreated;
    public boolean mIsNewlyAdded;
    public Boolean mIsPrimaryNavigationFragment;
    public LayoutInflater mLayoutInflater;
    public C1584 mLifecycleRegistry;
    public Lifecycle.State mMaxState;
    public boolean mMenuVisible;
    public Fragment mParentFragment;
    public boolean mPerformedCreateView;
    public float mPostponedAlpha;
    public Runnable mPostponedDurationRunnable;
    public boolean mRemoving;
    public boolean mRestored;
    public boolean mRetainInstance;
    public boolean mRetainInstanceChangedWhileDetached;
    public Bundle mSavedFragmentState;
    public C1561 mSavedStateRegistryController;
    public Boolean mSavedUserVisibleHint;
    public SparseArray<Parcelable> mSavedViewState;
    public int mState;
    public String mTag;
    public Fragment mTarget;
    public int mTargetRequestCode;
    public String mTargetWho;
    public boolean mUserVisibleHint;
    public View mView;
    public C1541 mViewLifecycleOwner;
    public C1578<AbstractC1574> mViewLifecycleOwnerLiveData;
    public String mWho;

    public static class InstantiationException extends RuntimeException {
        public InstantiationException(String str, Exception exc) {
            super(str, exc);
        }
    }

    @SuppressLint({"BanParcelableUsage"})
    public static class SavedState implements Parcelable {
        public static final Parcelable.Creator<SavedState> CREATOR = new C0180();

        /* renamed from: ῲ  reason: contains not printable characters */
        public final Bundle f1274;

        /* renamed from: androidx.fragment.app.Fragment$SavedState$K  reason: contains not printable characters */
        public static class C0180 implements Parcelable.ClassLoaderCreator<SavedState> {
            @Override // android.os.Parcelable.Creator
            public Object createFromParcel(Parcel parcel) {
                return new SavedState(parcel, null);
            }

            @Override // android.os.Parcelable.Creator
            public Object[] newArray(int i) {
                return new SavedState[i];
            }

            /* Return type fixed from 'java.lang.Object' to match base method */
            @Override // android.os.Parcelable.ClassLoaderCreator
            public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new SavedState(parcel, classLoader);
            }
        }

        public SavedState(Parcel parcel, ClassLoader classLoader) {
            Bundle bundle;
            this.f1274 = parcel.readBundle();
            if (classLoader != null && (bundle = this.f1274) != null) {
                bundle.setClassLoader(classLoader);
            }
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int i) {
            parcel.writeBundle(this.f1274);
        }
    }

    /* renamed from: androidx.fragment.app.Fragment$ඓ  reason: contains not printable characters */
    public interface AbstractC0182 {
    }

    /* renamed from: androidx.fragment.app.Fragment$ῲ  reason: contains not printable characters */
    public class RunnableC0183 implements Runnable {
        public RunnableC0183() {
        }

        public void run() {
            Fragment.this.callStartTransitionListener();
        }
    }

    /* renamed from: androidx.fragment.app.Fragment$K  reason: contains not printable characters */
    public class RunnableC0184 implements Runnable {
        public RunnableC0184() {
        }

        public void run() {
            Fragment.this.startPostponedEnterTransition();
        }
    }

    /* renamed from: androidx.fragment.app.Fragment$㸾  reason: contains not printable characters */
    public static class C0185 {

        /* renamed from: ʬ  reason: contains not printable characters */
        public int f1278;

        /* renamed from: Ԕ  reason: contains not printable characters */
        public Boolean f1279;

        /* renamed from: ؿ  reason: contains not printable characters */
        public AbstractC1820 f1280;

        /* renamed from: ݜ  reason: contains not printable characters */
        public boolean f1281;

        /* renamed from: ඓ  reason: contains not printable characters */
        public int f1282;

        /* renamed from: ᓣ  reason: contains not printable characters */
        public boolean f1283;

        /* renamed from: ᕣ  reason: contains not printable characters */
        public Object f1284;

        /* renamed from: ᨨ  reason: contains not printable characters */
        public Object f1285;

        /* renamed from: ῲ  reason: contains not printable characters */
        public Animator f1286;

        /* renamed from: ⁱ  reason: contains not printable characters */
        public Object f1287 = null;

        /* renamed from: K  reason: contains not printable characters */
        public View f1288;

        /* renamed from: 㑃  reason: contains not printable characters */
        public Object f1289;

        /* renamed from: 㗗  reason: contains not printable characters */
        public AbstractC1820 f1290;

        /* renamed from: 㗽  reason: contains not printable characters */
        public AbstractC0182 f1291;

        /* renamed from: 㳳  reason: contains not printable characters */
        public Object f1292;

        /* renamed from: 㴹  reason: contains not printable characters */
        public int f1293;

        /* renamed from: 㸾  reason: contains not printable characters */
        public int f1294;

        /* renamed from: 㿎  reason: contains not printable characters */
        public Object f1295;

        /* renamed from: 䁗  reason: contains not printable characters */
        public Boolean f1296;

        public C0185() {
            Object obj = Fragment.USE_DEFAULT_TRANSITION;
            this.f1295 = obj;
            this.f1285 = null;
            this.f1292 = obj;
            this.f1284 = null;
            this.f1289 = obj;
        }
    }

    public Fragment() {
        this.mState = 0;
        this.mWho = UUID.randomUUID().toString();
        this.mTargetWho = null;
        this.mIsPrimaryNavigationFragment = null;
        this.mChildFragmentManager = new LayoutInflater$Factory2C1545();
        this.mMenuVisible = true;
        this.mUserVisibleHint = true;
        this.mPostponedDurationRunnable = new RunnableC0184();
        this.mMaxState = Lifecycle.State.RESUMED;
        this.mViewLifecycleOwnerLiveData = new C1578<>();
        initLifecycle();
    }

    private C0185 ensureAnimationInfo() {
        if (this.mAnimationInfo == null) {
            this.mAnimationInfo = new C0185();
        }
        return this.mAnimationInfo;
    }

    private void initLifecycle() {
        this.mLifecycleRegistry = new C1584(this);
        this.mSavedStateRegistryController = new C1561(this);
        int i = Build.VERSION.SDK_INT;
        this.mLifecycleRegistry.m4146(new AbstractC1569() {
            /* class androidx.fragment.app.Fragment.AnonymousClass2 */

            @Override // ῲ.ؿ.AbstractC1569
            /* renamed from: K  reason: contains not printable characters */
            public void m679(AbstractC1574 r1, Lifecycle.Event event) {
                View view;
                if (event == Lifecycle.Event.ON_STOP && (view = Fragment.this.mView) != null) {
                    view.cancelPendingInputEvents();
                }
            }
        });
    }

    @Deprecated
    public static Fragment instantiate(Context context, String str) {
        return instantiate(context, str, null);
    }

    public void callStartTransitionListener() {
        C0185 r0 = this.mAnimationInfo;
        Object obj = null;
        if (r0 != null) {
            r0.f1283 = false;
            Object obj2 = r0.f1291;
            r0.f1291 = null;
            obj = obj2;
        }
        if (obj != null) {
            LayoutInflater$Factory2C1545.C1548 r1 = (LayoutInflater$Factory2C1545.C1548) obj;
            r1.f5684--;
            if (r1.f5684 == 0) {
                r1.f5685.f5610.m4052();
            }
        }
    }

    public void dump(String str, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] strArr) {
        printWriter.print(str);
        printWriter.print("mFragmentId=#");
        printWriter.print(Integer.toHexString(this.mFragmentId));
        printWriter.print(" mContainerId=#");
        printWriter.print(Integer.toHexString(this.mContainerId));
        printWriter.print(" mTag=");
        printWriter.println(this.mTag);
        printWriter.print(str);
        printWriter.print("mState=");
        printWriter.print(this.mState);
        printWriter.print(" mWho=");
        printWriter.print(this.mWho);
        printWriter.print(" mBackStackNesting=");
        printWriter.println(this.mBackStackNesting);
        printWriter.print(str);
        printWriter.print("mAdded=");
        printWriter.print(this.mAdded);
        printWriter.print(" mRemoving=");
        printWriter.print(this.mRemoving);
        printWriter.print(" mFromLayout=");
        printWriter.print(this.mFromLayout);
        printWriter.print(" mInLayout=");
        printWriter.println(this.mInLayout);
        printWriter.print(str);
        printWriter.print("mHidden=");
        printWriter.print(this.mHidden);
        printWriter.print(" mDetached=");
        printWriter.print(this.mDetached);
        printWriter.print(" mMenuVisible=");
        printWriter.print(this.mMenuVisible);
        printWriter.print(" mHasMenu=");
        printWriter.println(this.mHasMenu);
        printWriter.print(str);
        printWriter.print("mRetainInstance=");
        printWriter.print(this.mRetainInstance);
        printWriter.print(" mUserVisibleHint=");
        printWriter.println(this.mUserVisibleHint);
        if (this.mFragmentManager != null) {
            printWriter.print(str);
            printWriter.print("mFragmentManager=");
            printWriter.println(this.mFragmentManager);
        }
        if (this.mHost != null) {
            printWriter.print(str);
            printWriter.print("mHost=");
            printWriter.println(this.mHost);
        }
        if (this.mParentFragment != null) {
            printWriter.print(str);
            printWriter.print("mParentFragment=");
            printWriter.println(this.mParentFragment);
        }
        if (this.mArguments != null) {
            printWriter.print(str);
            printWriter.print("mArguments=");
            printWriter.println(this.mArguments);
        }
        if (this.mSavedFragmentState != null) {
            printWriter.print(str);
            printWriter.print("mSavedFragmentState=");
            printWriter.println(this.mSavedFragmentState);
        }
        if (this.mSavedViewState != null) {
            printWriter.print(str);
            printWriter.print("mSavedViewState=");
            printWriter.println(this.mSavedViewState);
        }
        Fragment targetFragment = getTargetFragment();
        if (targetFragment != null) {
            printWriter.print(str);
            printWriter.print("mTarget=");
            printWriter.print(targetFragment);
            printWriter.print(" mTargetRequestCode=");
            printWriter.println(this.mTargetRequestCode);
        }
        if (getNextAnim() != 0) {
            printWriter.print(str);
            printWriter.print("mNextAnim=");
            printWriter.println(getNextAnim());
        }
        if (this.mContainer != null) {
            printWriter.print(str);
            printWriter.print("mContainer=");
            printWriter.println(this.mContainer);
        }
        if (this.mView != null) {
            printWriter.print(str);
            printWriter.print("mView=");
            printWriter.println(this.mView);
        }
        if (this.mInnerView != null) {
            printWriter.print(str);
            printWriter.print("mInnerView=");
            printWriter.println(this.mView);
        }
        if (getAnimatingAway() != null) {
            printWriter.print(str);
            printWriter.print("mAnimatingAway=");
            printWriter.println(getAnimatingAway());
            printWriter.print(str);
            printWriter.print("mStateAfterAnimating=");
            printWriter.println(getStateAfterAnimating());
        }
        if (getContext() != null) {
            ((C1690) AbstractC1695.m4339(this)).f5956.m4326(str, fileDescriptor, printWriter, strArr);
        }
        printWriter.print(str);
        printWriter.println("Child " + this.mChildFragmentManager + CertificateUtil.DELIMITER);
        this.mChildFragmentManager.m4040(C1293.m3412(str, "  "), fileDescriptor, printWriter, strArr);
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public Fragment findFragmentByWho(String str) {
        if (str.equals(this.mWho)) {
            return this;
        }
        return this.mChildFragmentManager.m4006(str);
    }

    public final FragmentActivity getActivity() {
        AbstractC1542 r0 = this.mHost;
        if (r0 == null) {
            return null;
        }
        return (FragmentActivity) r0.f5640;
    }

    public boolean getAllowEnterTransitionOverlap() {
        Boolean bool;
        C0185 r0 = this.mAnimationInfo;
        if (r0 == null || (bool = r0.f1279) == null) {
            return true;
        }
        return bool.booleanValue();
    }

    public boolean getAllowReturnTransitionOverlap() {
        Boolean bool;
        C0185 r0 = this.mAnimationInfo;
        if (r0 == null || (bool = r0.f1296) == null) {
            return true;
        }
        return bool.booleanValue();
    }

    public View getAnimatingAway() {
        C0185 r0 = this.mAnimationInfo;
        if (r0 == null) {
            return null;
        }
        return r0.f1288;
    }

    public Animator getAnimator() {
        C0185 r0 = this.mAnimationInfo;
        if (r0 == null) {
            return null;
        }
        return r0.f1286;
    }

    public final Bundle getArguments() {
        return this.mArguments;
    }

    public final AbstractC1531 getChildFragmentManager() {
        if (this.mHost != null) {
            return this.mChildFragmentManager;
        }
        throw new IllegalStateException(C1293.m3411("Fragment ", this, " has not been attached yet."));
    }

    public Context getContext() {
        AbstractC1542 r0 = this.mHost;
        if (r0 == null) {
            return null;
        }
        return r0.f5638;
    }

    public Object getEnterTransition() {
        C0185 r0 = this.mAnimationInfo;
        if (r0 == null) {
            return null;
        }
        return r0.f1287;
    }

    public AbstractC1820 getEnterTransitionCallback() {
        C0185 r0 = this.mAnimationInfo;
        if (r0 == null) {
            return null;
        }
        return r0.f1290;
    }

    public Object getExitTransition() {
        C0185 r0 = this.mAnimationInfo;
        if (r0 == null) {
            return null;
        }
        return r0.f1285;
    }

    public AbstractC1820 getExitTransitionCallback() {
        C0185 r0 = this.mAnimationInfo;
        if (r0 == null) {
            return null;
        }
        return r0.f1280;
    }

    public final AbstractC1531 getFragmentManager() {
        return this.mFragmentManager;
    }

    public final Object getHost() {
        AbstractC1542 r0 = this.mHost;
        if (r0 == null) {
            return null;
        }
        return FragmentActivity.this;
    }

    public final int getId() {
        return this.mFragmentId;
    }

    public final LayoutInflater getLayoutInflater() {
        LayoutInflater layoutInflater = this.mLayoutInflater;
        return layoutInflater == null ? performGetLayoutInflater(null) : layoutInflater;
    }

    @Override // ῲ.ؿ.AbstractC1574
    public Lifecycle getLifecycle() {
        return this.mLifecycleRegistry;
    }

    @Deprecated
    public AbstractC1695 getLoaderManager() {
        return AbstractC1695.m4339(this);
    }

    public int getNextAnim() {
        C0185 r0 = this.mAnimationInfo;
        if (r0 == null) {
            return 0;
        }
        return r0.f1294;
    }

    public int getNextTransition() {
        C0185 r0 = this.mAnimationInfo;
        if (r0 == null) {
            return 0;
        }
        return r0.f1282;
    }

    public int getNextTransitionStyle() {
        C0185 r0 = this.mAnimationInfo;
        if (r0 == null) {
            return 0;
        }
        return r0.f1293;
    }

    public final Fragment getParentFragment() {
        return this.mParentFragment;
    }

    public Object getReenterTransition() {
        C0185 r0 = this.mAnimationInfo;
        if (r0 == null) {
            return null;
        }
        Object obj = r0.f1292;
        return obj == USE_DEFAULT_TRANSITION ? getExitTransition() : obj;
    }

    public final Resources getResources() {
        return requireContext().getResources();
    }

    public final boolean getRetainInstance() {
        return this.mRetainInstance;
    }

    public Object getReturnTransition() {
        C0185 r0 = this.mAnimationInfo;
        if (r0 == null) {
            return null;
        }
        Object obj = r0.f1295;
        return obj == USE_DEFAULT_TRANSITION ? getEnterTransition() : obj;
    }

    @Override // ῲ.Ԛ.AbstractC1560
    public final C1562 getSavedStateRegistry() {
        return this.mSavedStateRegistryController.f5732;
    }

    public Object getSharedElementEnterTransition() {
        C0185 r0 = this.mAnimationInfo;
        if (r0 == null) {
            return null;
        }
        return r0.f1284;
    }

    public Object getSharedElementReturnTransition() {
        C0185 r0 = this.mAnimationInfo;
        if (r0 == null) {
            return null;
        }
        Object obj = r0.f1289;
        return obj == USE_DEFAULT_TRANSITION ? getSharedElementEnterTransition() : obj;
    }

    public int getStateAfterAnimating() {
        C0185 r0 = this.mAnimationInfo;
        if (r0 == null) {
            return 0;
        }
        return r0.f1278;
    }

    public final String getString(int i) {
        return getResources().getString(i);
    }

    public final String getTag() {
        return this.mTag;
    }

    public final Fragment getTargetFragment() {
        String str;
        Fragment fragment = this.mTarget;
        if (fragment != null) {
            return fragment;
        }
        LayoutInflater$Factory2C1545 r0 = this.mFragmentManager;
        if (r0 == null || (str = this.mTargetWho) == null) {
            return null;
        }
        return r0.f5675.get(str);
    }

    public final int getTargetRequestCode() {
        return this.mTargetRequestCode;
    }

    public final CharSequence getText(int i) {
        return getResources().getText(i);
    }

    @Deprecated
    public boolean getUserVisibleHint() {
        return this.mUserVisibleHint;
    }

    public View getView() {
        return this.mView;
    }

    public AbstractC1574 getViewLifecycleOwner() {
        C1541 r0 = this.mViewLifecycleOwner;
        if (r0 != null) {
            return r0;
        }
        throw new IllegalStateException("Can't access the Fragment View's LifecycleOwner when getView() is null i.e., before onCreateView() or after onDestroyView()");
    }

    public LiveData<AbstractC1574> getViewLifecycleOwnerLiveData() {
        return this.mViewLifecycleOwnerLiveData;
    }

    @Override // ῲ.ؿ.AbstractC1586
    public C1568 getViewModelStore() {
        LayoutInflater$Factory2C1545 r0 = this.mFragmentManager;
        if (r0 != null) {
            return r0.m4075(this);
        }
        throw new IllegalStateException("Can't access ViewModels from detached fragment");
    }

    public final boolean hasOptionsMenu() {
        return this.mHasMenu;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public void initState() {
        initLifecycle();
        this.mWho = UUID.randomUUID().toString();
        this.mAdded = false;
        this.mRemoving = false;
        this.mFromLayout = false;
        this.mInLayout = false;
        this.mRestored = false;
        this.mBackStackNesting = 0;
        this.mFragmentManager = null;
        this.mChildFragmentManager = new LayoutInflater$Factory2C1545();
        this.mHost = null;
        this.mFragmentId = 0;
        this.mContainerId = 0;
        this.mTag = null;
        this.mHidden = false;
        this.mDetached = false;
    }

    public final boolean isAdded() {
        return this.mHost != null && this.mAdded;
    }

    public final boolean isDetached() {
        return this.mDetached;
    }

    public final boolean isHidden() {
        return this.mHidden;
    }

    public boolean isHideReplaced() {
        C0185 r0 = this.mAnimationInfo;
        if (r0 == null) {
            return false;
        }
        return r0.f1281;
    }

    public final boolean isInBackStack() {
        return this.mBackStackNesting > 0;
    }

    public final boolean isInLayout() {
        return this.mInLayout;
    }

    public final boolean isMenuVisible() {
        return this.mMenuVisible;
    }

    public boolean isPostponed() {
        C0185 r0 = this.mAnimationInfo;
        if (r0 == null) {
            return false;
        }
        return r0.f1283;
    }

    public final boolean isRemoving() {
        return this.mRemoving;
    }

    public final boolean isResumed() {
        return this.mState >= 4;
    }

    public final boolean isStateSaved() {
        LayoutInflater$Factory2C1545 r0 = this.mFragmentManager;
        if (r0 == null) {
            return false;
        }
        return r0.m4061();
    }

    public final boolean isVisible() {
        View view;
        return isAdded() && !isHidden() && (view = this.mView) != null && view.getWindowToken() != null && this.mView.getVisibility() == 0;
    }

    public void noteStateNotSaved() {
        this.mChildFragmentManager.m4082();
    }

    public void onActivityCreated(Bundle bundle) {
        this.mCalled = true;
    }

    public void onActivityResult(int i, int i2, Intent intent) {
    }

    public void onAttach(Context context) {
        Activity activity;
        this.mCalled = true;
        AbstractC1542 r2 = this.mHost;
        if (r2 == null) {
            activity = null;
        } else {
            activity = r2.f5640;
        }
        if (activity != null) {
            this.mCalled = false;
            onAttach(activity);
        }
    }

    public void onAttachFragment(Fragment fragment) {
    }

    public void onConfigurationChanged(Configuration configuration) {
        this.mCalled = true;
    }

    public boolean onContextItemSelected(MenuItem menuItem) {
        return false;
    }

    public void onCreate(Bundle bundle) {
        this.mCalled = true;
        restoreChildFragmentState(bundle);
        if (!this.mChildFragmentManager.m4074(1)) {
            this.mChildFragmentManager.m3999();
        }
    }

    public Animation onCreateAnimation(int i, boolean z, int i2) {
        return null;
    }

    public Animator onCreateAnimator(int i, boolean z, int i2) {
        return null;
    }

    public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
        requireActivity().onCreateContextMenu(contextMenu, view, contextMenuInfo);
    }

    public void onCreateOptionsMenu(Menu menu, MenuInflater menuInflater) {
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        int i = this.mContentLayoutId;
        if (i != 0) {
            return layoutInflater.inflate(i, viewGroup, false);
        }
        return null;
    }

    public void onDestroy() {
        this.mCalled = true;
    }

    public void onDestroyOptionsMenu() {
    }

    public void onDestroyView() {
        this.mCalled = true;
    }

    public void onDetach() {
        this.mCalled = true;
    }

    public LayoutInflater onGetLayoutInflater(Bundle bundle) {
        return getLayoutInflater(bundle);
    }

    public void onHiddenChanged(boolean z) {
    }

    public void onInflate(Context context, AttributeSet attributeSet, Bundle bundle) {
        Activity activity;
        this.mCalled = true;
        AbstractC1542 r2 = this.mHost;
        if (r2 == null) {
            activity = null;
        } else {
            activity = r2.f5640;
        }
        if (activity != null) {
            this.mCalled = false;
            onInflate(activity, attributeSet, bundle);
        }
    }

    public void onLowMemory() {
        this.mCalled = true;
    }

    public void onMultiWindowModeChanged(boolean z) {
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        return false;
    }

    public void onOptionsMenuClosed(Menu menu) {
    }

    public void onPause() {
        this.mCalled = true;
    }

    public void onPictureInPictureModeChanged(boolean z) {
    }

    public void onPrepareOptionsMenu(Menu menu) {
    }

    public void onPrimaryNavigationFragmentChanged(boolean z) {
    }

    public void onRequestPermissionsResult(int i, String[] strArr, int[] iArr) {
    }

    public void onResume() {
        this.mCalled = true;
    }

    public void onSaveInstanceState(Bundle bundle) {
    }

    public void onStart() {
        this.mCalled = true;
    }

    public void onStop() {
        this.mCalled = true;
    }

    public void onViewCreated(View view, Bundle bundle) {
    }

    public void onViewStateRestored(Bundle bundle) {
        this.mCalled = true;
    }

    public void performActivityCreated(Bundle bundle) {
        this.mChildFragmentManager.m4082();
        this.mState = 2;
        this.mCalled = false;
        onActivityCreated(bundle);
        if (this.mCalled) {
            this.mChildFragmentManager.m4062();
            return;
        }
        throw new SuperNotCalledException(C1293.m3411("Fragment ", this, " did not call through to super.onActivityCreated()"));
    }

    public void performAttach() {
        this.mChildFragmentManager.m4045(this.mHost, new C0181(), this);
        this.mCalled = false;
        onAttach(this.mHost.f5638);
        if (!this.mCalled) {
            throw new SuperNotCalledException(C1293.m3411("Fragment ", this, " did not call through to super.onAttach()"));
        }
    }

    public void performConfigurationChanged(Configuration configuration) {
        onConfigurationChanged(configuration);
        this.mChildFragmentManager.m4028(configuration);
    }

    public boolean performContextItemSelected(MenuItem menuItem) {
        if (this.mHidden) {
            return false;
        }
        if (!onContextItemSelected(menuItem) && !this.mChildFragmentManager.m4050(menuItem)) {
            return false;
        }
        return true;
    }

    public void performCreate(Bundle bundle) {
        this.mChildFragmentManager.m4082();
        this.mState = 1;
        this.mCalled = false;
        this.mSavedStateRegistryController.m4105(bundle);
        onCreate(bundle);
        this.mIsCreated = true;
        if (this.mCalled) {
            this.mLifecycleRegistry.m4144(Lifecycle.Event.ON_CREATE);
            return;
        }
        throw new SuperNotCalledException(C1293.m3411("Fragment ", this, " did not call through to super.onCreate()"));
    }

    public boolean performCreateOptionsMenu(Menu menu, MenuInflater menuInflater) {
        boolean z = false;
        if (this.mHidden) {
            return false;
        }
        if (this.mHasMenu && this.mMenuVisible) {
            z = true;
            onCreateOptionsMenu(menu, menuInflater);
        }
        return z | this.mChildFragmentManager.m4049(menu, menuInflater);
    }

    public void performCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        this.mChildFragmentManager.m4082();
        boolean z = true;
        this.mPerformedCreateView = true;
        this.mViewLifecycleOwner = new C1541();
        this.mView = onCreateView(layoutInflater, viewGroup, bundle);
        if (this.mView != null) {
            C1541 r3 = this.mViewLifecycleOwner;
            if (r3.f5637 == null) {
                r3.f5637 = new C1584(r3);
            }
            this.mViewLifecycleOwnerLiveData.m4127(this.mViewLifecycleOwner);
            return;
        }
        if (this.mViewLifecycleOwner.f5637 == null) {
            z = false;
        }
        if (!z) {
            this.mViewLifecycleOwner = null;
            return;
        }
        throw new IllegalStateException("Called getViewLifecycleOwner() but onCreateView() returned null");
    }

    public void performDestroy() {
        this.mChildFragmentManager.m4055();
        this.mLifecycleRegistry.m4144(Lifecycle.Event.ON_DESTROY);
        this.mState = 0;
        this.mCalled = false;
        this.mIsCreated = false;
        onDestroy();
        if (!this.mCalled) {
            throw new SuperNotCalledException(C1293.m3411("Fragment ", this, " did not call through to super.onDestroy()"));
        }
    }

    public void performDestroyView() {
        this.mChildFragmentManager.m4080();
        if (this.mView != null) {
            C1541 r0 = this.mViewLifecycleOwner;
            r0.f5637.m4144(Lifecycle.Event.ON_DESTROY);
        }
        this.mState = 1;
        this.mCalled = false;
        onDestroyView();
        if (this.mCalled) {
            ((C1690) AbstractC1695.m4339(this)).f5956.m4321();
            this.mPerformedCreateView = false;
            return;
        }
        throw new SuperNotCalledException(C1293.m3411("Fragment ", this, " did not call through to super.onDestroyView()"));
    }

    public void performDetach() {
        this.mCalled = false;
        onDetach();
        this.mLayoutInflater = null;
        if (!this.mCalled) {
            throw new SuperNotCalledException(C1293.m3411("Fragment ", this, " did not call through to super.onDetach()"));
        } else if (!this.mChildFragmentManager.m4054()) {
            this.mChildFragmentManager.m4055();
            this.mChildFragmentManager = new LayoutInflater$Factory2C1545();
        }
    }

    public LayoutInflater performGetLayoutInflater(Bundle bundle) {
        this.mLayoutInflater = onGetLayoutInflater(bundle);
        return this.mLayoutInflater;
    }

    public void performLowMemory() {
        onLowMemory();
        this.mChildFragmentManager.m3981();
    }

    public void performMultiWindowModeChanged(boolean z) {
        onMultiWindowModeChanged(z);
        this.mChildFragmentManager.m4048(z);
    }

    public boolean performOptionsItemSelected(MenuItem menuItem) {
        if (this.mHidden) {
            return false;
        }
        if ((!this.mHasMenu || !this.mMenuVisible || !onOptionsItemSelected(menuItem)) && !this.mChildFragmentManager.m4015(menuItem)) {
            return false;
        }
        return true;
    }

    public void performOptionsMenuClosed(Menu menu) {
        if (!this.mHidden) {
            if (this.mHasMenu && this.mMenuVisible) {
                onOptionsMenuClosed(menu);
            }
            this.mChildFragmentManager.m4031(menu);
        }
    }

    public void performPause() {
        this.mChildFragmentManager.m4057();
        if (this.mView != null) {
            C1541 r0 = this.mViewLifecycleOwner;
            r0.f5637.m4144(Lifecycle.Event.ON_PAUSE);
        }
        this.mLifecycleRegistry.m4144(Lifecycle.Event.ON_PAUSE);
        this.mState = 3;
        this.mCalled = false;
        onPause();
        if (!this.mCalled) {
            throw new SuperNotCalledException(C1293.m3411("Fragment ", this, " did not call through to super.onPause()"));
        }
    }

    public void performPictureInPictureModeChanged(boolean z) {
        onPictureInPictureModeChanged(z);
        this.mChildFragmentManager.m4012(z);
    }

    public boolean performPrepareOptionsMenu(Menu menu) {
        boolean z = false;
        if (this.mHidden) {
            return false;
        }
        if (this.mHasMenu && this.mMenuVisible) {
            z = true;
            onPrepareOptionsMenu(menu);
        }
        return z | this.mChildFragmentManager.m4014(menu);
    }

    public void performPrimaryNavigationFragmentChanged() {
        boolean r0 = this.mFragmentManager.m4000(this);
        Boolean bool = this.mIsPrimaryNavigationFragment;
        if (bool == null || bool.booleanValue() != r0) {
            this.mIsPrimaryNavigationFragment = Boolean.valueOf(r0);
            onPrimaryNavigationFragmentChanged(r0);
            this.mChildFragmentManager.m3985();
        }
    }

    public void performResume() {
        this.mChildFragmentManager.m4082();
        this.mChildFragmentManager.m3984();
        this.mState = 4;
        this.mCalled = false;
        onResume();
        if (this.mCalled) {
            this.mLifecycleRegistry.m4144(Lifecycle.Event.ON_RESUME);
            if (this.mView != null) {
                C1541 r0 = this.mViewLifecycleOwner;
                r0.f5637.m4144(Lifecycle.Event.ON_RESUME);
            }
            this.mChildFragmentManager.m3997();
            this.mChildFragmentManager.m3984();
            return;
        }
        throw new SuperNotCalledException(C1293.m3411("Fragment ", this, " did not call through to super.onResume()"));
    }

    public void performSaveInstanceState(Bundle bundle) {
        onSaveInstanceState(bundle);
        this.mSavedStateRegistryController.f5732.m4106(bundle);
        Parcelable r0 = this.mChildFragmentManager.m3992();
        if (r0 != null) {
            bundle.putParcelable(FragmentActivity.FRAGMENTS_TAG, r0);
        }
    }

    public void performStart() {
        this.mChildFragmentManager.m4082();
        this.mChildFragmentManager.m3984();
        this.mState = 3;
        this.mCalled = false;
        onStart();
        if (this.mCalled) {
            this.mLifecycleRegistry.m4144(Lifecycle.Event.ON_START);
            if (this.mView != null) {
                C1541 r0 = this.mViewLifecycleOwner;
                r0.f5637.m4144(Lifecycle.Event.ON_START);
            }
            this.mChildFragmentManager.m4059();
            return;
        }
        throw new SuperNotCalledException(C1293.m3411("Fragment ", this, " did not call through to super.onStart()"));
    }

    public void performStop() {
        this.mChildFragmentManager.m3988();
        if (this.mView != null) {
            C1541 r0 = this.mViewLifecycleOwner;
            r0.f5637.m4144(Lifecycle.Event.ON_STOP);
        }
        this.mLifecycleRegistry.m4144(Lifecycle.Event.ON_STOP);
        this.mState = 2;
        this.mCalled = false;
        onStop();
        if (!this.mCalled) {
            throw new SuperNotCalledException(C1293.m3411("Fragment ", this, " did not call through to super.onStop()"));
        }
    }

    public void postponeEnterTransition() {
        ensureAnimationInfo().f1283 = true;
    }

    public void registerForContextMenu(View view) {
        view.setOnCreateContextMenuListener(this);
    }

    public final void requestPermissions(String[] strArr, int i) {
        AbstractC1542 r0 = this.mHost;
        if (r0 != null) {
            FragmentActivity.this.requestPermissionsFromFragment(this, strArr, i);
            return;
        }
        throw new IllegalStateException(C1293.m3411("Fragment ", this, " not attached to Activity"));
    }

    public final FragmentActivity requireActivity() {
        FragmentActivity activity = getActivity();
        if (activity != null) {
            return activity;
        }
        throw new IllegalStateException(C1293.m3411("Fragment ", this, " not attached to an activity."));
    }

    public final Bundle requireArguments() {
        Bundle arguments = getArguments();
        if (arguments != null) {
            return arguments;
        }
        throw new IllegalStateException(C1293.m3411("Fragment ", this, " does not have any arguments."));
    }

    public final Context requireContext() {
        Context context = getContext();
        if (context != null) {
            return context;
        }
        throw new IllegalStateException(C1293.m3411("Fragment ", this, " not attached to a context."));
    }

    public final AbstractC1531 requireFragmentManager() {
        AbstractC1531 fragmentManager = getFragmentManager();
        if (fragmentManager != null) {
            return fragmentManager;
        }
        throw new IllegalStateException(C1293.m3411("Fragment ", this, " not associated with a fragment manager."));
    }

    public final Object requireHost() {
        Object host = getHost();
        if (host != null) {
            return host;
        }
        throw new IllegalStateException(C1293.m3411("Fragment ", this, " not attached to a host."));
    }

    public final Fragment requireParentFragment() {
        Fragment parentFragment = getParentFragment();
        if (parentFragment != null) {
            return parentFragment;
        }
        if (getContext() == null) {
            throw new IllegalStateException(C1293.m3411("Fragment ", this, " is not attached to any Fragment or host"));
        }
        throw new IllegalStateException("Fragment " + this + " is not a child Fragment, it is directly attached to " + getContext());
    }

    public final View requireView() {
        View view = getView();
        if (view != null) {
            return view;
        }
        throw new IllegalStateException(C1293.m3411("Fragment ", this, " did not return a View from onCreateView() or this was called before onCreateView()."));
    }

    public void restoreChildFragmentState(Bundle bundle) {
        Parcelable parcelable;
        if (bundle != null && (parcelable = bundle.getParcelable(FragmentActivity.FRAGMENTS_TAG)) != null) {
            this.mChildFragmentManager.m4030(parcelable);
            this.mChildFragmentManager.m3999();
        }
    }

    public final void restoreViewState(Bundle bundle) {
        SparseArray<Parcelable> sparseArray = this.mSavedViewState;
        if (sparseArray != null) {
            this.mInnerView.restoreHierarchyState(sparseArray);
            this.mSavedViewState = null;
        }
        this.mCalled = false;
        onViewStateRestored(bundle);
        if (!this.mCalled) {
            throw new SuperNotCalledException(C1293.m3411("Fragment ", this, " did not call through to super.onViewStateRestored()"));
        } else if (this.mView != null) {
            C1541 r3 = this.mViewLifecycleOwner;
            r3.f5637.m4144(Lifecycle.Event.ON_CREATE);
        }
    }

    public void setAllowEnterTransitionOverlap(boolean z) {
        ensureAnimationInfo().f1279 = Boolean.valueOf(z);
    }

    public void setAllowReturnTransitionOverlap(boolean z) {
        ensureAnimationInfo().f1296 = Boolean.valueOf(z);
    }

    public void setAnimatingAway(View view) {
        ensureAnimationInfo().f1288 = view;
    }

    public void setAnimator(Animator animator) {
        ensureAnimationInfo().f1286 = animator;
    }

    public void setArguments(Bundle bundle) {
        if (this.mFragmentManager == null || !isStateSaved()) {
            this.mArguments = bundle;
            return;
        }
        throw new IllegalStateException("Fragment already added and state has been saved");
    }

    public void setEnterSharedElementCallback(AbstractC1820 r2) {
        ensureAnimationInfo().f1290 = r2;
    }

    public void setEnterTransition(Object obj) {
        ensureAnimationInfo().f1287 = obj;
    }

    public void setExitSharedElementCallback(AbstractC1820 r2) {
        ensureAnimationInfo().f1280 = r2;
    }

    public void setExitTransition(Object obj) {
        ensureAnimationInfo().f1285 = obj;
    }

    public void setHasOptionsMenu(boolean z) {
        if (this.mHasMenu != z) {
            this.mHasMenu = z;
            if (isAdded() && !isHidden()) {
                FragmentActivity.this.supportInvalidateOptionsMenu();
            }
        }
    }

    public void setHideReplaced(boolean z) {
        ensureAnimationInfo().f1281 = z;
    }

    public void setInitialSavedState(SavedState savedState) {
        Bundle bundle;
        if (this.mFragmentManager == null) {
            if (savedState == null || (bundle = savedState.f1274) == null) {
                bundle = null;
            }
            this.mSavedFragmentState = bundle;
            return;
        }
        throw new IllegalStateException("Fragment already added");
    }

    public void setMenuVisibility(boolean z) {
        if (this.mMenuVisible != z) {
            this.mMenuVisible = z;
            if (this.mHasMenu && isAdded() && !isHidden()) {
                FragmentActivity.this.supportInvalidateOptionsMenu();
            }
        }
    }

    public void setNextAnim(int i) {
        if (this.mAnimationInfo != null || i != 0) {
            ensureAnimationInfo().f1294 = i;
        }
    }

    public void setNextTransition(int i, int i2) {
        if (this.mAnimationInfo != null || i != 0 || i2 != 0) {
            ensureAnimationInfo();
            C0185 r0 = this.mAnimationInfo;
            r0.f1282 = i;
            r0.f1293 = i2;
        }
    }

    public void setOnStartEnterTransitionListener(AbstractC0182 r3) {
        ensureAnimationInfo();
        AbstractC0182 r0 = this.mAnimationInfo.f1291;
        if (r3 != r0) {
            if (r3 == null || r0 == null) {
                C0185 r02 = this.mAnimationInfo;
                if (r02.f1283) {
                    r02.f1291 = r3;
                }
                if (r3 != null) {
                    ((LayoutInflater$Factory2C1545.C1548) r3).f5684++;
                    return;
                }
                return;
            }
            throw new IllegalStateException("Trying to set a replacement startPostponedEnterTransition on " + this);
        }
    }

    public void setReenterTransition(Object obj) {
        ensureAnimationInfo().f1292 = obj;
    }

    public void setRetainInstance(boolean z) {
        this.mRetainInstance = z;
        LayoutInflater$Factory2C1545 r0 = this.mFragmentManager;
        if (r0 == null) {
            this.mRetainInstanceChangedWhileDetached = true;
        } else if (z) {
            r0.m4032(this);
        } else {
            r0.m4060(this);
        }
    }

    public void setReturnTransition(Object obj) {
        ensureAnimationInfo().f1295 = obj;
    }

    public void setSharedElementEnterTransition(Object obj) {
        ensureAnimationInfo().f1284 = obj;
    }

    public void setSharedElementReturnTransition(Object obj) {
        ensureAnimationInfo().f1289 = obj;
    }

    public void setStateAfterAnimating(int i) {
        ensureAnimationInfo().f1278 = i;
    }

    public void setTargetFragment(Fragment fragment, int i) {
        AbstractC1531 fragmentManager = getFragmentManager();
        AbstractC1531 fragmentManager2 = fragment != null ? fragment.getFragmentManager() : null;
        if (fragmentManager == null || fragmentManager2 == null || fragmentManager == fragmentManager2) {
            for (Fragment fragment2 = fragment; fragment2 != null; fragment2 = fragment2.getTargetFragment()) {
                if (fragment2 == this) {
                    throw new IllegalArgumentException("Setting " + fragment + " as the target of " + this + " would create a target cycle");
                }
            }
            if (fragment == null) {
                this.mTargetWho = null;
                this.mTarget = null;
            } else if (this.mFragmentManager == null || fragment.mFragmentManager == null) {
                this.mTargetWho = null;
                this.mTarget = fragment;
            } else {
                this.mTargetWho = fragment.mWho;
                this.mTarget = null;
            }
            this.mTargetRequestCode = i;
            return;
        }
        throw new IllegalArgumentException(C1293.m3411("Fragment ", fragment, " must share the same FragmentManager to be set as a target fragment"));
    }

    @Deprecated
    public void setUserVisibleHint(boolean z) {
        if (!this.mUserVisibleHint && z && this.mState < 3 && this.mFragmentManager != null && isAdded() && this.mIsCreated) {
            this.mFragmentManager.m3986(this);
        }
        this.mUserVisibleHint = z;
        this.mDeferStart = this.mState < 3 && !z;
        if (this.mSavedFragmentState != null) {
            this.mSavedUserVisibleHint = Boolean.valueOf(z);
        }
    }

    public boolean shouldShowRequestPermissionRationale(String str) {
        AbstractC1542 r0 = this.mHost;
        if (r0 != null) {
            return C1826.m4723((Activity) FragmentActivity.this, str);
        }
        return false;
    }

    public void startActivity(@SuppressLint({"UnknownNullness"}) Intent intent) {
        startActivity(intent, null);
    }

    public void startActivityForResult(@SuppressLint({"UnknownNullness"}) Intent intent, int i) {
        startActivityForResult(intent, i, null);
    }

    public void startIntentSenderForResult(@SuppressLint({"UnknownNullness"}) IntentSender intentSender, int i, Intent intent, int i2, int i3, int i4, Bundle bundle) throws IntentSender.SendIntentException {
        AbstractC1542 r0 = this.mHost;
        if (r0 != null) {
            FragmentActivity.this.startIntentSenderFromFragment(this, intentSender, i, intent, i2, i3, i4, bundle);
            return;
        }
        throw new IllegalStateException(C1293.m3411("Fragment ", this, " not attached to Activity"));
    }

    public void startPostponedEnterTransition() {
        LayoutInflater$Factory2C1545 r0 = this.mFragmentManager;
        if (r0 == null || r0.f5668 == null) {
            ensureAnimationInfo().f1283 = false;
        } else if (Looper.myLooper() != this.mFragmentManager.f5668.f5642.getLooper()) {
            this.mFragmentManager.f5668.f5642.postAtFrontOfQueue(new RunnableC0183());
        } else {
            callStartTransitionListener();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        C2369.m6334((Object) this, sb);
        sb.append(" (");
        sb.append(this.mWho);
        sb.append(")");
        if (this.mFragmentId != 0) {
            sb.append(" id=0x");
            sb.append(Integer.toHexString(this.mFragmentId));
        }
        if (this.mTag != null) {
            sb.append(" ");
            sb.append(this.mTag);
        }
        sb.append('}');
        return sb.toString();
    }

    public void unregisterForContextMenu(View view) {
        view.setOnCreateContextMenuListener(null);
    }

    @Deprecated
    public static Fragment instantiate(Context context, String str, Bundle bundle) {
        try {
            Fragment fragment = (Fragment) C1522.m3877(context.getClassLoader(), str).getConstructor(new Class[0]).newInstance(new Object[0]);
            if (bundle != null) {
                bundle.setClassLoader(fragment.getClass().getClassLoader());
                fragment.setArguments(bundle);
            }
            return fragment;
        } catch (InstantiationException e) {
            throw new InstantiationException(C1293.m3413("Unable to instantiate fragment ", str, ": make sure class name exists, is public, and has an empty constructor that is public"), e);
        } catch (IllegalAccessException e2) {
            throw new InstantiationException(C1293.m3413("Unable to instantiate fragment ", str, ": make sure class name exists, is public, and has an empty constructor that is public"), e2);
        } catch (NoSuchMethodException e3) {
            throw new InstantiationException(C1293.m3413("Unable to instantiate fragment ", str, ": could not find Fragment constructor"), e3);
        } catch (InvocationTargetException e4) {
            throw new InstantiationException(C1293.m3413("Unable to instantiate fragment ", str, ": calling Fragment constructor caused an exception"), e4);
        }
    }

    public final String getString(int i, Object... objArr) {
        return getResources().getString(i, objArr);
    }

    public final void postponeEnterTransition(long j, TimeUnit timeUnit) {
        Handler handler;
        ensureAnimationInfo().f1283 = true;
        LayoutInflater$Factory2C1545 r0 = this.mFragmentManager;
        if (r0 != null) {
            handler = r0.f5668.f5642;
        } else {
            handler = new Handler(Looper.getMainLooper());
        }
        handler.removeCallbacks(this.mPostponedDurationRunnable);
        handler.postDelayed(this.mPostponedDurationRunnable, timeUnit.toMillis(j));
    }

    public void startActivity(@SuppressLint({"UnknownNullness"}) Intent intent, Bundle bundle) {
        AbstractC1542 r0 = this.mHost;
        if (r0 != null) {
            FragmentActivity.this.startActivityFromFragment(this, intent, -1, bundle);
            return;
        }
        throw new IllegalStateException(C1293.m3411("Fragment ", this, " not attached to Activity"));
    }

    public void startActivityForResult(@SuppressLint({"UnknownNullness"}) Intent intent, int i, Bundle bundle) {
        AbstractC1542 r0 = this.mHost;
        if (r0 != null) {
            FragmentActivity.this.startActivityFromFragment(this, intent, i, bundle);
            return;
        }
        throw new IllegalStateException(C1293.m3411("Fragment ", this, " not attached to Activity"));
    }

    /* renamed from: androidx.fragment.app.Fragment$ʬ  reason: contains not printable characters */
    public class C0181 extends AbstractC1513 {
        public C0181() {
        }

        @Override // ῲ.Ԕ.K.AbstractC1513
        /* renamed from: K  reason: contains not printable characters */
        public View m680(int i) {
            View view = Fragment.this.mView;
            if (view != null) {
                return view.findViewById(i);
            }
            throw new IllegalStateException("Fragment " + this + " does not have a view");
        }

        @Override // ῲ.Ԕ.K.AbstractC1513
        /* renamed from: K  reason: contains not printable characters */
        public boolean m681() {
            return Fragment.this.mView != null;
        }
    }

    @Deprecated
    public LayoutInflater getLayoutInflater(Bundle bundle) {
        AbstractC1542 r2 = this.mHost;
        if (r2 != null) {
            FragmentActivity.C0186 k = (FragmentActivity.C0186) r2;
            LayoutInflater cloneInContext = FragmentActivity.this.getLayoutInflater().cloneInContext(FragmentActivity.this);
            cloneInContext.setFactory2(this.mChildFragmentManager.m4064());
            int i = Build.VERSION.SDK_INT;
            return cloneInContext;
        }
        throw new IllegalStateException("onGetLayoutInflater() cannot be executed until the Fragment is attached to the FragmentManager.");
    }

    @Deprecated
    public void onAttach(Activity activity) {
        this.mCalled = true;
    }

    @Deprecated
    public void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        this.mCalled = true;
    }

    public Fragment(int i) {
        this();
        this.mContentLayoutId = i;
    }
}
