package androidx.core.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.animation.AnimationUtils;
import android.widget.EdgeEffect;
import android.widget.FrameLayout;
import android.widget.OverScroller;
import android.widget.ScrollView;
import com.google.android.material.progressindicator.BaseProgressIndicator;
import java.util.ArrayList;
import ඓ.K.K.K.C1293;
import ῲ.ᨨ.ᨨ.AbstractC1735;
import ῲ.ᨨ.ᨨ.AbstractC1767;
import ῲ.ᨨ.ᨨ.AbstractC1771;
import ῲ.ᨨ.ᨨ.C1729;
import ῲ.ᨨ.ᨨ.C1747;
import ῲ.ᨨ.ᨨ.C1751;
import ῲ.ᨨ.ᨨ.C1775;
import ῲ.ᨨ.ᨨ.䃖.C1782;

public class NestedScrollView extends FrameLayout implements AbstractC1767, AbstractC1771, AbstractC1735 {

    /* renamed from: 㮔  reason: contains not printable characters */
    public static final C0169 f1173 = new C0169();

    /* renamed from: 䃖  reason: contains not printable characters */
    public static final int[] f1174 = {16843130};

    /* renamed from: ʬ  reason: contains not printable characters */
    public final Rect f1175;

    /* renamed from: Ԕ  reason: contains not printable characters */
    public boolean f1176;

    /* renamed from: Ԛ  reason: contains not printable characters */
    public int f1177;

    /* renamed from: ؿ  reason: contains not printable characters */
    public int f1178;

    /* renamed from: ݜ  reason: contains not printable characters */
    public final int[] f1179;

    /* renamed from: ඓ  reason: contains not printable characters */
    public EdgeEffect f1180;

    /* renamed from: ᑓ  reason: contains not printable characters */
    public final C1775 f1181;

    /* renamed from: ᓆ  reason: contains not printable characters */
    public SavedState f1182;

    /* renamed from: ᓣ  reason: contains not printable characters */
    public int f1183;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public boolean f1184;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public boolean f1185;

    /* renamed from: ῲ  reason: contains not printable characters */
    public long f1186;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public int f1187;

    /* renamed from: ゎ  reason: contains not printable characters */
    public float f1188;

    /* renamed from: ト  reason: contains not printable characters */
    public AbstractC0168 f1189;

    /* renamed from: 㑃  reason: contains not printable characters */
    public VelocityTracker f1190;

    /* renamed from: 㗗  reason: contains not printable characters */
    public int f1191;

    /* renamed from: 㗽  reason: contains not printable characters */
    public int f1192;

    /* renamed from: 㳳  reason: contains not printable characters */
    public View f1193;

    /* renamed from: 㴪  reason: contains not printable characters */
    public final C1751 f1194;

    /* renamed from: 㴹  reason: contains not printable characters */
    public EdgeEffect f1195;

    /* renamed from: 㶋  reason: contains not printable characters */
    public int f1196;

    /* renamed from: 㸾  reason: contains not printable characters */
    public OverScroller f1197;

    /* renamed from: 㿎  reason: contains not printable characters */
    public boolean f1198;

    /* renamed from: 䀟  reason: contains not printable characters */
    public final int[] f1199;

    /* renamed from: 䁗  reason: contains not printable characters */
    public boolean f1200;

    public static class SavedState extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new C0167();

        /* renamed from: ῲ  reason: contains not printable characters */
        public int f1201;

        /* renamed from: androidx.core.widget.NestedScrollView$SavedState$K  reason: contains not printable characters */
        public class C0167 implements Parcelable.Creator<SavedState> {
            /* Return type fixed from 'java.lang.Object' to match base method */
            @Override // android.os.Parcelable.Creator
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            /* Return type fixed from 'java.lang.Object[]' to match base method */
            @Override // android.os.Parcelable.Creator
            public SavedState[] newArray(int i) {
                return new SavedState[i];
            }
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public String toString() {
            StringBuilder r0 = C1293.m3416("HorizontalScrollView.SavedState{");
            r0.append(Integer.toHexString(System.identityHashCode(this)));
            r0.append(" scrollPosition=");
            r0.append(this.f1201);
            r0.append("}");
            return r0.toString();
        }

        public void writeToParcel(Parcel parcel, int i) {
            super.writeToParcel(parcel, i);
            parcel.writeInt(this.f1201);
        }

        public SavedState(Parcel parcel) {
            super(parcel);
            this.f1201 = parcel.readInt();
        }
    }

    /* renamed from: androidx.core.widget.NestedScrollView$ῲ  reason: contains not printable characters */
    public interface AbstractC0168 {
        /* renamed from: K  reason: contains not printable characters */
        void m637(NestedScrollView nestedScrollView, int i, int i2, int i3, int i4);
    }

    /* renamed from: androidx.core.widget.NestedScrollView$K  reason: contains not printable characters */
    public static class C0169 extends C1747 {
        @Override // ῲ.ᨨ.ᨨ.C1747
        public void onInitializeAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
            super.onInitializeAccessibilityEvent(view, accessibilityEvent);
            NestedScrollView nestedScrollView = (NestedScrollView) view;
            accessibilityEvent.setClassName(ScrollView.class.getName());
            accessibilityEvent.setScrollable(nestedScrollView.getScrollRange() > 0);
            accessibilityEvent.setScrollX(nestedScrollView.getScrollX());
            accessibilityEvent.setScrollY(nestedScrollView.getScrollY());
            int scrollX = nestedScrollView.getScrollX();
            int i = Build.VERSION.SDK_INT;
            accessibilityEvent.setMaxScrollX(scrollX);
            int scrollRange = nestedScrollView.getScrollRange();
            int i2 = Build.VERSION.SDK_INT;
            accessibilityEvent.setMaxScrollY(scrollRange);
        }

        @Override // ῲ.ᨨ.ᨨ.C1747
        public void onInitializeAccessibilityNodeInfo(View view, C1782 r5) {
            int scrollRange;
            super.onInitializeAccessibilityNodeInfo(view, r5);
            NestedScrollView nestedScrollView = (NestedScrollView) view;
            r5.f6124.setClassName(ScrollView.class.getName());
            if (nestedScrollView.isEnabled() && (scrollRange = nestedScrollView.getScrollRange()) > 0) {
                r5.f6124.setScrollable(true);
                if (nestedScrollView.getScrollY() > 0) {
                    r5.m4664(C1782.C1785.f6130);
                    r5.m4664(C1782.C1785.f6137);
                }
                if (nestedScrollView.getScrollY() < scrollRange) {
                    r5.m4664(C1782.C1785.f6136);
                    r5.m4664(C1782.C1785.f6127);
                }
            }
        }

        @Override // ῲ.ᨨ.ᨨ.C1747
        public boolean performAccessibilityAction(View view, int i, Bundle bundle) {
            if (super.performAccessibilityAction(view, i, bundle)) {
                return true;
            }
            NestedScrollView nestedScrollView = (NestedScrollView) view;
            if (!nestedScrollView.isEnabled()) {
                return false;
            }
            if (i != 4096) {
                if (i == 8192 || i == 16908344) {
                    int max = Math.max(nestedScrollView.getScrollY() - ((nestedScrollView.getHeight() - nestedScrollView.getPaddingBottom()) - nestedScrollView.getPaddingTop()), 0);
                    if (max == nestedScrollView.getScrollY()) {
                        return false;
                    }
                    nestedScrollView.m624(0, max, true);
                    return true;
                } else if (i != 16908346) {
                    return false;
                }
            }
            int min = Math.min(nestedScrollView.getScrollY() + ((nestedScrollView.getHeight() - nestedScrollView.getPaddingBottom()) - nestedScrollView.getPaddingTop()), nestedScrollView.getScrollRange());
            if (min == nestedScrollView.getScrollY()) {
                return false;
            }
            nestedScrollView.m624(0, min, true);
            return true;
        }
    }

    public NestedScrollView(Context context) {
        this(context, null);
    }

    private float getVerticalScrollFactorCompat() {
        if (this.f1188 == 0.0f) {
            TypedValue typedValue = new TypedValue();
            Context context = getContext();
            if (context.getTheme().resolveAttribute(16842829, typedValue, true)) {
                this.f1188 = typedValue.getDimension(context.getResources().getDisplayMetrics());
            } else {
                throw new IllegalStateException("Expected theme to define listPreferredItemHeight.");
            }
        }
        return this.f1188;
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public static int m609(int i, int i2, int i3) {
        if (i2 >= i3 || i < 0) {
            return 0;
        }
        return i2 + i > i3 ? i3 - i2 : i;
    }

    public void addView(View view) {
        if (getChildCount() <= 0) {
            super.addView(view);
            return;
        }
        throw new IllegalStateException("ScrollView can host only one direct child");
    }

    public int computeHorizontalScrollExtent() {
        return super.computeHorizontalScrollExtent();
    }

    public int computeHorizontalScrollOffset() {
        return super.computeHorizontalScrollOffset();
    }

    public int computeHorizontalScrollRange() {
        return super.computeHorizontalScrollRange();
    }

    public void computeScroll() {
        if (!this.f1197.isFinished()) {
            this.f1197.computeScrollOffset();
            int currY = this.f1197.getCurrY();
            int i = currY - this.f1196;
            this.f1196 = currY;
            int[] iArr = this.f1199;
            boolean z = false;
            iArr[1] = 0;
            m632(0, i, iArr, null, 1);
            int i2 = i - this.f1199[1];
            int scrollRange = getScrollRange();
            if (i2 != 0) {
                int scrollY = getScrollY();
                m631(0, i2, getScrollX(), scrollY, 0, scrollRange, 0, 0);
                int scrollY2 = getScrollY() - scrollY;
                int i3 = i2 - scrollY2;
                int[] iArr2 = this.f1199;
                iArr2[1] = 0;
                m622(0, scrollY2, 0, i3, this.f1179, 1, iArr2);
                i2 = i3 - this.f1199[1];
            }
            if (i2 != 0) {
                int overScrollMode = getOverScrollMode();
                if (overScrollMode == 0 || (overScrollMode == 1 && scrollRange > 0)) {
                    z = true;
                }
                if (z) {
                    m614();
                    if (i2 < 0) {
                        if (this.f1180.isFinished()) {
                            this.f1180.onAbsorb((int) this.f1197.getCurrVelocity());
                        }
                    } else if (this.f1195.isFinished()) {
                        this.f1195.onAbsorb((int) this.f1197.getCurrVelocity());
                    }
                }
                m620();
            }
            if (!this.f1197.isFinished()) {
                C1729.m4449(this);
            } else {
                m618(1);
            }
        }
    }

    public int computeVerticalScrollExtent() {
        return super.computeVerticalScrollExtent();
    }

    public int computeVerticalScrollOffset() {
        return Math.max(0, super.computeVerticalScrollOffset());
    }

    public int computeVerticalScrollRange() {
        int childCount = getChildCount();
        int height = (getHeight() - getPaddingBottom()) - getPaddingTop();
        if (childCount == 0) {
            return height;
        }
        View childAt = getChildAt(0);
        int bottom = childAt.getBottom() + ((FrameLayout.LayoutParams) childAt.getLayoutParams()).bottomMargin;
        int scrollY = getScrollY();
        int max = Math.max(0, bottom - height);
        if (scrollY < 0) {
            return bottom - scrollY;
        }
        return scrollY > max ? bottom + (scrollY - max) : bottom;
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return super.dispatchKeyEvent(keyEvent) || m633(keyEvent);
    }

    public boolean dispatchNestedFling(float f, float f2, boolean z) {
        return this.f1181.m4631(f, f2, z);
    }

    public boolean dispatchNestedPreFling(float f, float f2) {
        return this.f1181.m4630(f, f2);
    }

    public boolean dispatchNestedPreScroll(int i, int i2, int[] iArr, int[] iArr2) {
        return m632(i, i2, iArr, iArr2, 0);
    }

    public boolean dispatchNestedScroll(int i, int i2, int i3, int i4, int[] iArr) {
        return this.f1181.m4633(i, i2, i3, i4, iArr);
    }

    public void draw(Canvas canvas) {
        int i;
        super.draw(canvas);
        if (this.f1180 != null) {
            int scrollY = getScrollY();
            int i2 = 0;
            if (!this.f1180.isFinished()) {
                int save = canvas.save();
                int width = getWidth();
                int height = getHeight();
                int min = Math.min(0, scrollY);
                int i3 = Build.VERSION.SDK_INT;
                if (getClipToPadding()) {
                    width -= getPaddingRight() + getPaddingLeft();
                    i = getPaddingLeft() + 0;
                } else {
                    i = 0;
                }
                int i4 = Build.VERSION.SDK_INT;
                if (getClipToPadding()) {
                    height -= getPaddingBottom() + getPaddingTop();
                    min += getPaddingTop();
                }
                canvas.translate((float) i, (float) min);
                this.f1180.setSize(width, height);
                if (this.f1180.draw(canvas)) {
                    C1729.m4449(this);
                }
                canvas.restoreToCount(save);
            }
            if (!this.f1195.isFinished()) {
                int save2 = canvas.save();
                int width2 = getWidth();
                int height2 = getHeight();
                int max = Math.max(getScrollRange(), scrollY) + height2;
                int i5 = Build.VERSION.SDK_INT;
                if (getClipToPadding()) {
                    width2 -= getPaddingRight() + getPaddingLeft();
                    i2 = 0 + getPaddingLeft();
                }
                int i6 = Build.VERSION.SDK_INT;
                if (getClipToPadding()) {
                    height2 -= getPaddingBottom() + getPaddingTop();
                    max -= getPaddingBottom();
                }
                canvas.translate((float) (i2 - width2), (float) max);
                canvas.rotate(180.0f, (float) width2, 0.0f);
                this.f1195.setSize(width2, height2);
                if (this.f1195.draw(canvas)) {
                    C1729.m4449(this);
                }
                canvas.restoreToCount(save2);
            }
        }
    }

    public float getBottomFadingEdgeStrength() {
        if (getChildCount() == 0) {
            return 0.0f;
        }
        View childAt = getChildAt(0);
        int verticalFadingEdgeLength = getVerticalFadingEdgeLength();
        int bottom = ((childAt.getBottom() + ((FrameLayout.LayoutParams) childAt.getLayoutParams()).bottomMargin) - getScrollY()) - (getHeight() - getPaddingBottom());
        if (bottom < verticalFadingEdgeLength) {
            return ((float) bottom) / ((float) verticalFadingEdgeLength);
        }
        return 1.0f;
    }

    public int getMaxScrollAmount() {
        return (int) (((float) getHeight()) * 0.5f);
    }

    public int getNestedScrollAxes() {
        return this.f1194.m4547();
    }

    public int getScrollRange() {
        if (getChildCount() <= 0) {
            return 0;
        }
        View childAt = getChildAt(0);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) childAt.getLayoutParams();
        return Math.max(0, ((childAt.getHeight() + layoutParams.topMargin) + layoutParams.bottomMargin) - ((getHeight() - getPaddingTop()) - getPaddingBottom()));
    }

    public float getTopFadingEdgeStrength() {
        if (getChildCount() == 0) {
            return 0.0f;
        }
        int verticalFadingEdgeLength = getVerticalFadingEdgeLength();
        int scrollY = getScrollY();
        if (scrollY < verticalFadingEdgeLength) {
            return ((float) scrollY) / ((float) verticalFadingEdgeLength);
        }
        return 1.0f;
    }

    public boolean hasNestedScrollingParent() {
        return m613(0);
    }

    public boolean isNestedScrollingEnabled() {
        return this.f1181.f6118;
    }

    public void measureChild(View view, int i, int i2) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        view.measure(FrameLayout.getChildMeasureSpec(i, getPaddingRight() + getPaddingLeft(), layoutParams.width), View.MeasureSpec.makeMeasureSpec(0, 0));
    }

    public void measureChildWithMargins(View view, int i, int i2, int i3, int i4) {
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams) view.getLayoutParams();
        view.measure(FrameLayout.getChildMeasureSpec(i, getPaddingRight() + getPaddingLeft() + marginLayoutParams.leftMargin + marginLayoutParams.rightMargin + i2, marginLayoutParams.width), View.MeasureSpec.makeMeasureSpec(marginLayoutParams.topMargin + marginLayoutParams.bottomMargin, 0));
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.f1185 = false;
    }

    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        if ((motionEvent.getSource() & 2) != 0 && motionEvent.getAction() == 8 && !this.f1184) {
            float axisValue = motionEvent.getAxisValue(9);
            if (axisValue != 0.0f) {
                int scrollRange = getScrollRange();
                int scrollY = getScrollY();
                int verticalScrollFactorCompat = scrollY - ((int) (axisValue * getVerticalScrollFactorCompat()));
                if (verticalScrollFactorCompat < 0) {
                    verticalScrollFactorCompat = 0;
                } else if (verticalScrollFactorCompat > scrollRange) {
                    verticalScrollFactorCompat = scrollRange;
                }
                if (verticalScrollFactorCompat != scrollY) {
                    super.scrollTo(getScrollX(), verticalScrollFactorCompat);
                    return true;
                }
            }
        }
        return false;
    }

    /* JADX WARNING: Removed duplicated region for block: B:47:0x00e1  */
    /* JADX WARNING: Removed duplicated region for block: B:48:0x00e7  */
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        boolean z;
        int action = motionEvent.getAction();
        if (action == 2 && this.f1184) {
            return true;
        }
        int i = action & BaseProgressIndicator.MAX_ALPHA;
        if (i != 0) {
            if (i != 1) {
                if (i == 2) {
                    int i2 = this.f1192;
                    if (i2 != -1) {
                        int findPointerIndex = motionEvent.findPointerIndex(i2);
                        if (findPointerIndex == -1) {
                            Log.e("NestedScrollView", "Invalid pointerId=" + i2 + " in onInterceptTouchEvent");
                        } else {
                            int y = (int) motionEvent.getY(findPointerIndex);
                            if (Math.abs(y - this.f1187) > this.f1191 && (2 & getNestedScrollAxes()) == 0) {
                                this.f1184 = true;
                                this.f1187 = y;
                                if (this.f1190 == null) {
                                    this.f1190 = VelocityTracker.obtain();
                                }
                                this.f1190.addMovement(motionEvent);
                                this.f1177 = 0;
                                ViewParent parent = getParent();
                                if (parent != null) {
                                    parent.requestDisallowInterceptTouchEvent(true);
                                }
                            }
                        }
                    }
                } else if (i != 3) {
                    if (i == 6) {
                        m626(motionEvent);
                    }
                }
            }
            this.f1184 = false;
            this.f1192 = -1;
            m611();
            if (this.f1197.springBack(getScrollX(), getScrollY(), 0, 0, 0, getScrollRange())) {
                C1729.m4449(this);
            }
            m618(0);
        } else {
            int y2 = (int) motionEvent.getY();
            int x = (int) motionEvent.getX();
            if (getChildCount() > 0) {
                int scrollY = getScrollY();
                View childAt = getChildAt(0);
                if (y2 >= childAt.getTop() - scrollY && y2 < childAt.getBottom() - scrollY && x >= childAt.getLeft() && x < childAt.getRight()) {
                    z = true;
                    if (z) {
                        this.f1184 = false;
                        m611();
                    } else {
                        this.f1187 = y2;
                        this.f1192 = motionEvent.getPointerId(0);
                        VelocityTracker velocityTracker = this.f1190;
                        if (velocityTracker == null) {
                            this.f1190 = VelocityTracker.obtain();
                        } else {
                            velocityTracker.clear();
                        }
                        this.f1190.addMovement(motionEvent);
                        this.f1197.computeScrollOffset();
                        this.f1184 = !this.f1197.isFinished();
                        m617(2, 0);
                    }
                }
            }
            z = false;
            if (z) {
            }
        }
        return this.f1184;
    }

    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        super.onLayout(z, i, i2, i3, i4);
        int i5 = 0;
        this.f1198 = false;
        View view = this.f1193;
        if (view != null && m610(view, this)) {
            m627(this.f1193);
        }
        this.f1193 = null;
        if (!this.f1185) {
            if (this.f1182 != null) {
                scrollTo(getScrollX(), this.f1182.f1201);
                this.f1182 = null;
            }
            if (getChildCount() > 0) {
                View childAt = getChildAt(0);
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) childAt.getLayoutParams();
                i5 = childAt.getMeasuredHeight() + layoutParams.topMargin + layoutParams.bottomMargin;
            }
            int paddingTop = ((i4 - i2) - getPaddingTop()) - getPaddingBottom();
            int scrollY = getScrollY();
            int r2 = m609(scrollY, paddingTop, i5);
            if (r2 != scrollY) {
                scrollTo(getScrollX(), r2);
            }
        }
        scrollTo(getScrollX(), getScrollY());
        this.f1185 = true;
    }

    public void onMeasure(int i, int i2) {
        super.onMeasure(i, i2);
        if (this.f1200 && View.MeasureSpec.getMode(i2) != 0 && getChildCount() > 0) {
            View childAt = getChildAt(0);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) childAt.getLayoutParams();
            int measuredHeight = childAt.getMeasuredHeight();
            int measuredHeight2 = (((getMeasuredHeight() - getPaddingTop()) - getPaddingBottom()) - layoutParams.topMargin) - layoutParams.bottomMargin;
            if (measuredHeight < measuredHeight2) {
                childAt.measure(FrameLayout.getChildMeasureSpec(i, getPaddingRight() + getPaddingLeft() + layoutParams.leftMargin + layoutParams.rightMargin, layoutParams.width), View.MeasureSpec.makeMeasureSpec(measuredHeight2, 1073741824));
            }
        }
    }

    public boolean onNestedFling(View view, float f, float f2, boolean z) {
        if (z) {
            return false;
        }
        dispatchNestedFling(0.0f, f2, true);
        m612((int) f2);
        return true;
    }

    public boolean onNestedPreFling(View view, float f, float f2) {
        return dispatchNestedPreFling(f, f2);
    }

    @Override // ῲ.ᨨ.ᨨ.AbstractC1742
    public void onNestedPreScroll(View view, int i, int i2, int[] iArr, int i3) {
        m632(i, i2, iArr, null, i3);
    }

    @Override // ῲ.ᨨ.ᨨ.AbstractC1767
    public void onNestedScroll(View view, int i, int i2, int i3, int i4, int i5, int[] iArr) {
        m625(i4, i5, iArr);
    }

    @Override // ῲ.ᨨ.ᨨ.AbstractC1742
    public void onNestedScrollAccepted(View view, View view2, int i, int i2) {
        C1751 r1 = this.f1194;
        if (i2 == 1) {
            r1.f6065 = i;
        } else {
            r1.f6066 = i;
        }
        m617(2, i2);
    }

    public void onOverScrolled(int i, int i2, boolean z, boolean z2) {
        super.scrollTo(i, i2);
    }

    public boolean onRequestFocusInDescendants(int i, Rect rect) {
        View view;
        if (i == 2) {
            i = 130;
        } else if (i == 1) {
            i = 33;
        }
        if (rect == null) {
            view = FocusFinder.getInstance().findNextFocus(this, null, i);
        } else {
            view = FocusFinder.getInstance().findNextFocusFromRect(this, rect, i);
        }
        if (view != null && !(true ^ m634(view, 0, getHeight()))) {
            return view.requestFocus(i, rect);
        }
        return false;
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof SavedState)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        SavedState savedState = (SavedState) parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.f1182 = savedState;
        requestLayout();
    }

    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.f1201 = getScrollY();
        return savedState;
    }

    public void onScrollChanged(int i, int i2, int i3, int i4) {
        super.onScrollChanged(i, i2, i3, i4);
        AbstractC0168 r0 = this.f1189;
        if (r0 != null) {
            r0.m637(this, i, i2, i3, i4);
        }
    }

    public void onSizeChanged(int i, int i2, int i3, int i4) {
        super.onSizeChanged(i, i2, i3, i4);
        View findFocus = findFocus();
        if (findFocus != null && this != findFocus && m634(findFocus, 0, i4)) {
            findFocus.getDrawingRect(this.f1175);
            offsetDescendantRectToMyCoords(findFocus, this.f1175);
            m615(m619(this.f1175));
        }
    }

    public boolean onStartNestedScroll(View view, View view2, int i) {
        return onStartNestedScroll(view, view2, i, 0);
    }

    @Override // ῲ.ᨨ.ᨨ.AbstractC1742
    public boolean onStartNestedScroll(View view, View view2, int i, int i2) {
        return (i & 2) != 0;
    }

    @Override // ῲ.ᨨ.ᨨ.AbstractC1742
    public void onStopNestedScroll(View view, int i) {
        C1751 r3 = this.f1194;
        if (i == 1) {
            r3.f6065 = 0;
        } else {
            r3.f6066 = 0;
        }
        m618(i);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        ViewParent parent;
        if (this.f1190 == null) {
            this.f1190 = VelocityTracker.obtain();
        }
        int actionMasked = motionEvent.getActionMasked();
        if (actionMasked == 0) {
            this.f1177 = 0;
        }
        MotionEvent obtain = MotionEvent.obtain(motionEvent);
        obtain.offsetLocation(0.0f, (float) this.f1177);
        if (actionMasked != 0) {
            if (actionMasked == 1) {
                VelocityTracker velocityTracker = this.f1190;
                velocityTracker.computeCurrentVelocity(1000, (float) this.f1183);
                int yVelocity = (int) velocityTracker.getYVelocity(this.f1192);
                if (Math.abs(yVelocity) >= this.f1178) {
                    int i = -yVelocity;
                    float f = (float) i;
                    if (!dispatchNestedPreFling(0.0f, f)) {
                        dispatchNestedFling(0.0f, f, true);
                        m612(i);
                    }
                } else if (this.f1197.springBack(getScrollX(), getScrollY(), 0, 0, 0, getScrollRange())) {
                    C1729.m4449(this);
                }
                this.f1192 = -1;
                this.f1184 = false;
                m611();
                m618(0);
                EdgeEffect edgeEffect = this.f1180;
                if (edgeEffect != null) {
                    edgeEffect.onRelease();
                    this.f1195.onRelease();
                }
            } else if (actionMasked == 2) {
                int findPointerIndex = motionEvent.findPointerIndex(this.f1192);
                if (findPointerIndex == -1) {
                    StringBuilder r0 = C1293.m3416("Invalid pointerId=");
                    r0.append(this.f1192);
                    r0.append(" in onTouchEvent");
                    Log.e("NestedScrollView", r0.toString());
                } else {
                    int y = (int) motionEvent.getY(findPointerIndex);
                    int i2 = this.f1187 - y;
                    if (!this.f1184 && Math.abs(i2) > this.f1191) {
                        ViewParent parent2 = getParent();
                        if (parent2 != null) {
                            parent2.requestDisallowInterceptTouchEvent(true);
                        }
                        this.f1184 = true;
                        i2 = i2 > 0 ? i2 - this.f1191 : i2 + this.f1191;
                    }
                    int i3 = i2;
                    if (this.f1184) {
                        if (m632(0, i3, this.f1199, this.f1179, 0)) {
                            i3 -= this.f1199[1];
                            this.f1177 += this.f1179[1];
                        }
                        this.f1187 = y - this.f1179[1];
                        int scrollY = getScrollY();
                        int scrollRange = getScrollRange();
                        int overScrollMode = getOverScrollMode();
                        boolean z = overScrollMode == 0 || (overScrollMode == 1 && scrollRange > 0);
                        if (m631(0, i3, 0, getScrollY(), 0, scrollRange, 0, 0) && !m613(0)) {
                            this.f1190.clear();
                        }
                        int scrollY2 = getScrollY() - scrollY;
                        int i4 = i3 - scrollY2;
                        int[] iArr = this.f1199;
                        iArr[1] = 0;
                        m622(0, scrollY2, 0, i4, this.f1179, 0, iArr);
                        int i5 = this.f1187;
                        int[] iArr2 = this.f1179;
                        this.f1187 = i5 - iArr2[1];
                        this.f1177 += iArr2[1];
                        if (z) {
                            int i6 = i3 - this.f1199[1];
                            m614();
                            int i7 = scrollY + i6;
                            if (i7 < 0) {
                                EdgeEffect edgeEffect2 = this.f1180;
                                float height = ((float) i6) / ((float) getHeight());
                                float x = motionEvent.getX(findPointerIndex) / ((float) getWidth());
                                int i8 = Build.VERSION.SDK_INT;
                                edgeEffect2.onPull(height, x);
                                if (!this.f1195.isFinished()) {
                                    this.f1195.onRelease();
                                }
                            } else if (i7 > scrollRange) {
                                EdgeEffect edgeEffect3 = this.f1195;
                                float height2 = ((float) i6) / ((float) getHeight());
                                float x2 = 1.0f - (motionEvent.getX(findPointerIndex) / ((float) getWidth()));
                                int i9 = Build.VERSION.SDK_INT;
                                edgeEffect3.onPull(height2, x2);
                                if (!this.f1180.isFinished()) {
                                    this.f1180.onRelease();
                                }
                            }
                            EdgeEffect edgeEffect4 = this.f1180;
                            if (edgeEffect4 != null && (!edgeEffect4.isFinished() || !this.f1195.isFinished())) {
                                C1729.m4449(this);
                            }
                        }
                    }
                }
            } else if (actionMasked == 3) {
                if (this.f1184 && getChildCount() > 0 && this.f1197.springBack(getScrollX(), getScrollY(), 0, 0, 0, getScrollRange())) {
                    C1729.m4449(this);
                }
                this.f1192 = -1;
                this.f1184 = false;
                m611();
                m618(0);
                EdgeEffect edgeEffect5 = this.f1180;
                if (edgeEffect5 != null) {
                    edgeEffect5.onRelease();
                    this.f1195.onRelease();
                }
            } else if (actionMasked == 5) {
                int actionIndex = motionEvent.getActionIndex();
                this.f1187 = (int) motionEvent.getY(actionIndex);
                this.f1192 = motionEvent.getPointerId(actionIndex);
            } else if (actionMasked == 6) {
                m626(motionEvent);
                this.f1187 = (int) motionEvent.getY(motionEvent.findPointerIndex(this.f1192));
            }
        } else if (getChildCount() == 0) {
            return false;
        } else {
            boolean z2 = !this.f1197.isFinished();
            this.f1184 = z2;
            if (z2 && (parent = getParent()) != null) {
                parent.requestDisallowInterceptTouchEvent(true);
            }
            if (!this.f1197.isFinished()) {
                m620();
            }
            this.f1187 = (int) motionEvent.getY();
            this.f1192 = motionEvent.getPointerId(0);
            m617(2, 0);
        }
        VelocityTracker velocityTracker2 = this.f1190;
        if (velocityTracker2 != null) {
            velocityTracker2.addMovement(obtain);
        }
        obtain.recycle();
        return true;
    }

    public void requestChildFocus(View view, View view2) {
        if (!this.f1198) {
            m627(view2);
        } else {
            this.f1193 = view2;
        }
        super.requestChildFocus(view, view2);
    }

    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean z) {
        rect.offset(view.getLeft() - view.getScrollX(), view.getTop() - view.getScrollY());
        int r3 = m619(rect);
        boolean z2 = r3 != 0;
        if (z2) {
            if (z) {
                scrollBy(0, r3);
            } else {
                m621(0, r3);
            }
        }
        return z2;
    }

    public void requestDisallowInterceptTouchEvent(boolean z) {
        if (z) {
            m611();
        }
        super.requestDisallowInterceptTouchEvent(z);
    }

    public void requestLayout() {
        this.f1198 = true;
        super.requestLayout();
    }

    public void scrollTo(int i, int i2) {
        if (getChildCount() > 0) {
            View childAt = getChildAt(0);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) childAt.getLayoutParams();
            int r7 = m609(i, (getWidth() - getPaddingLeft()) - getPaddingRight(), childAt.getWidth() + layoutParams.leftMargin + layoutParams.rightMargin);
            int r8 = m609(i2, (getHeight() - getPaddingTop()) - getPaddingBottom(), childAt.getHeight() + layoutParams.topMargin + layoutParams.bottomMargin);
            if (r7 != getScrollX() || r8 != getScrollY()) {
                super.scrollTo(r7, r8);
            }
        }
    }

    public void setFillViewport(boolean z) {
        if (z != this.f1200) {
            this.f1200 = z;
            requestLayout();
        }
    }

    public void setNestedScrollingEnabled(boolean z) {
        C1775 r0 = this.f1181;
        if (r0.f6118) {
            C1729.m4441(r0.f6114);
        }
        r0.f6118 = z;
    }

    public void setOnScrollChangeListener(AbstractC0168 r1) {
        this.f1189 = r1;
    }

    public void setSmoothScrollingEnabled(boolean z) {
        this.f1176 = z;
    }

    public boolean shouldDelayChildPressedState() {
        return true;
    }

    public boolean startNestedScroll(int i) {
        return m617(i, 0);
    }

    public void stopNestedScroll() {
        m618(0);
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public final void m611() {
        VelocityTracker velocityTracker = this.f1190;
        if (velocityTracker != null) {
            velocityTracker.recycle();
            this.f1190 = null;
        }
    }

    /* renamed from: ඓ  reason: contains not printable characters */
    public boolean m613(int i) {
        return this.f1181.m4627(i) != null;
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public boolean m617(int i, int i2) {
        return this.f1181.m4632(i, i2);
    }

    /* renamed from: ⁱ  reason: contains not printable characters */
    public void m618(int i) {
        this.f1181.m4624(i);
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m622(int i, int i2, int i3, int i4, int[] iArr, int i5, int[] iArr2) {
        this.f1181.m4626(i, i2, i3, i4, iArr, i5, iArr2);
    }

    /* renamed from: 㴹  reason: contains not printable characters */
    public boolean m635(int i) {
        boolean z = i == 130;
        int height = getHeight();
        if (z) {
            this.f1175.top = getScrollY() + height;
            int childCount = getChildCount();
            if (childCount > 0) {
                View childAt = getChildAt(childCount - 1);
                int paddingBottom = getPaddingBottom() + childAt.getBottom() + ((FrameLayout.LayoutParams) childAt.getLayoutParams()).bottomMargin;
                Rect rect = this.f1175;
                if (rect.top + height > paddingBottom) {
                    rect.top = paddingBottom - height;
                }
            }
        } else {
            this.f1175.top = getScrollY() - height;
            Rect rect2 = this.f1175;
            if (rect2.top < 0) {
                rect2.top = 0;
            }
        }
        Rect rect3 = this.f1175;
        int i2 = rect3.top;
        rect3.bottom = height + i2;
        return m630(i, i2, rect3.bottom);
    }

    /* renamed from: 㸾  reason: contains not printable characters */
    public boolean m636(int i) {
        int childCount;
        boolean z = i == 130;
        int height = getHeight();
        Rect rect = this.f1175;
        rect.top = 0;
        rect.bottom = height;
        if (z && (childCount = getChildCount()) > 0) {
            View childAt = getChildAt(childCount - 1);
            this.f1175.bottom = getPaddingBottom() + childAt.getBottom() + ((FrameLayout.LayoutParams) childAt.getLayoutParams()).bottomMargin;
            Rect rect2 = this.f1175;
            rect2.top = rect2.bottom - height;
        }
        Rect rect3 = this.f1175;
        return m630(i, rect3.top, rect3.bottom);
    }

    public NestedScrollView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public void onNestedPreScroll(View view, int i, int i2, int[] iArr) {
        onNestedPreScroll(view, i, i2, iArr, 0);
    }

    @Override // ῲ.ᨨ.ᨨ.AbstractC1742
    public void onNestedScroll(View view, int i, int i2, int i3, int i4, int i5) {
        m625(i4, i5, (int[]) null);
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public final void m615(int i) {
        if (i == 0) {
            return;
        }
        if (this.f1176) {
            m621(0, i);
        } else {
            scrollBy(0, i);
        }
    }

    public NestedScrollView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.f1175 = new Rect();
        this.f1198 = true;
        this.f1185 = false;
        this.f1193 = null;
        this.f1184 = false;
        this.f1176 = true;
        this.f1192 = -1;
        this.f1179 = new int[2];
        this.f1199 = new int[2];
        this.f1197 = new OverScroller(getContext());
        setFocusable(true);
        setDescendantFocusability(262144);
        setWillNotDraw(false);
        ViewConfiguration viewConfiguration = ViewConfiguration.get(getContext());
        this.f1191 = viewConfiguration.getScaledTouchSlop();
        this.f1178 = viewConfiguration.getScaledMinimumFlingVelocity();
        this.f1183 = viewConfiguration.getScaledMaximumFlingVelocity();
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, f1174, i, 0);
        setFillViewport(obtainStyledAttributes.getBoolean(0, false));
        obtainStyledAttributes.recycle();
        this.f1194 = new C1751();
        this.f1181 = new C1775(this);
        setNestedScrollingEnabled(true);
        C1729.m4482(this, f1173);
    }

    public void onNestedScroll(View view, int i, int i2, int i3, int i4) {
        m625(i4, 0, (int[]) null);
    }

    /* renamed from: K  reason: contains not printable characters */
    public boolean m632(int i, int i2, int[] iArr, int[] iArr2, int i3) {
        return this.f1181.m4635(i, i2, iArr, iArr2, i3);
    }

    @Override // android.view.ViewGroup
    public void addView(View view, int i) {
        if (getChildCount() <= 0) {
            super.addView(view, i);
            return;
        }
        throw new IllegalStateException("ScrollView can host only one direct child");
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public void m612(int i) {
        if (getChildCount() > 0) {
            this.f1197.fling(getScrollX(), getScrollY(), 0, i, 0, 0, Integer.MIN_VALUE, Integer.MAX_VALUE, 0, 0);
            m628(true);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m625(int i, int i2, int[] iArr) {
        int scrollY = getScrollY();
        scrollBy(0, i);
        int scrollY2 = getScrollY() - scrollY;
        if (iArr != null) {
            iArr[1] = iArr[1] + scrollY2;
        }
        this.f1181.m4628(0, scrollY2, 0, i - scrollY2, null, i2, iArr);
    }

    public void onNestedScrollAccepted(View view, View view2, int i) {
        onNestedScrollAccepted(view, view2, i, 0);
    }

    public void onStopNestedScroll(View view) {
        onStopNestedScroll(view, 0);
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public void m616(int i, int i2, int i3, boolean z) {
        m623(i - getScrollX(), i2 - getScrollY(), i3, z);
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public final void m614() {
        if (getOverScrollMode() == 2) {
            this.f1180 = null;
            this.f1195 = null;
        } else if (this.f1180 == null) {
            Context context = getContext();
            this.f1180 = new EdgeEffect(context);
            this.f1195 = new EdgeEffect(context);
        }
    }

    @Override // android.view.ViewGroup
    public void addView(View view, ViewGroup.LayoutParams layoutParams) {
        if (getChildCount() <= 0) {
            super.addView(view, layoutParams);
            return;
        }
        throw new IllegalStateException("ScrollView can host only one direct child");
    }

    /* JADX WARNING: Removed duplicated region for block: B:22:0x0062  */
    /* JADX WARNING: Removed duplicated region for block: B:8:0x0038  */
    /* renamed from: K  reason: contains not printable characters */
    public boolean m633(KeyEvent keyEvent) {
        boolean z;
        this.f1175.setEmpty();
        if (getChildCount() > 0) {
            View childAt = getChildAt(0);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) childAt.getLayoutParams();
            if (childAt.getHeight() + layoutParams.topMargin + layoutParams.bottomMargin > (getHeight() - getPaddingTop()) - getPaddingBottom()) {
                z = true;
                int i = 130;
                if (z) {
                    if (!isFocused() || keyEvent.getKeyCode() == 4) {
                        return false;
                    }
                    View findFocus = findFocus();
                    if (findFocus == this) {
                        findFocus = null;
                    }
                    View findNextFocus = FocusFinder.getInstance().findNextFocus(this, findFocus, 130);
                    if (findNextFocus == null || findNextFocus == this || !findNextFocus.requestFocus(130)) {
                        return false;
                    }
                    return true;
                } else if (keyEvent.getAction() != 0) {
                    return false;
                } else {
                    int keyCode = keyEvent.getKeyCode();
                    if (keyCode != 19) {
                        if (keyCode != 20) {
                            if (keyCode != 62) {
                                return false;
                            }
                            if (keyEvent.isShiftPressed()) {
                                i = 33;
                            }
                            m635(i);
                            return false;
                        } else if (!keyEvent.isAltPressed()) {
                            return m629(130);
                        } else {
                            return m636(130);
                        }
                    } else if (!keyEvent.isAltPressed()) {
                        return m629(33);
                    } else {
                        return m636(33);
                    }
                }
            }
        }
        z = false;
        int i2 = 130;
        if (z) {
        }
    }

    @Override // android.view.ViewGroup
    public void addView(View view, int i, ViewGroup.LayoutParams layoutParams) {
        if (getChildCount() <= 0) {
            super.addView(view, i, layoutParams);
            return;
        }
        throw new IllegalStateException("ScrollView can host only one direct child");
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m626(MotionEvent motionEvent) {
        int actionIndex = motionEvent.getActionIndex();
        if (motionEvent.getPointerId(actionIndex) == this.f1192) {
            int i = actionIndex == 0 ? 1 : 0;
            this.f1187 = (int) motionEvent.getY(i);
            this.f1192 = motionEvent.getPointerId(i);
            VelocityTracker velocityTracker = this.f1190;
            if (velocityTracker != null) {
                velocityTracker.clear();
            }
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:33:0x0057  */
    /* JADX WARNING: Removed duplicated region for block: B:35:0x005a  */
    /* JADX WARNING: Removed duplicated region for block: B:43:0x0083 A[ADDED_TO_REGION] */
    /* renamed from: K  reason: contains not printable characters */
    public boolean m631(int i, int i2, int i3, int i4, int i5, int i6, int i7, int i8) {
        boolean z;
        boolean z2;
        int overScrollMode = getOverScrollMode();
        boolean z3 = computeHorizontalScrollRange() > computeHorizontalScrollExtent();
        boolean z4 = computeVerticalScrollRange() > computeVerticalScrollExtent();
        boolean z5 = overScrollMode == 0 || (overScrollMode == 1 && z3);
        boolean z6 = overScrollMode == 0 || (overScrollMode == 1 && z4);
        int i9 = i3 + i;
        int i10 = !z5 ? 0 : i7;
        int i11 = i4 + i2;
        int i12 = !z6 ? 0 : i8;
        int i13 = -i10;
        int i14 = i10 + i5;
        int i15 = -i12;
        int i16 = i12 + i6;
        if (i9 > i14) {
            i13 = i14;
        } else if (i9 >= i13) {
            i13 = i9;
            z = false;
            if (i11 <= i16) {
                i15 = i16;
            } else if (i11 >= i15) {
                i15 = i11;
                z2 = false;
                if (z2 && !m613(1)) {
                    this.f1197.springBack(i13, i15, 0, 0, 0, getScrollRange());
                }
                onOverScrolled(i13, i15, z, z2);
                if (!z || z2) {
                    return true;
                }
                return false;
            }
            z2 = true;
            this.f1197.springBack(i13, i15, 0, 0, 0, getScrollRange());
            onOverScrolled(i13, i15, z, z2);
            if (!z) {
            }
            return true;
        }
        z = true;
        if (i11 <= i16) {
        }
        z2 = true;
        this.f1197.springBack(i13, i15, 0, 0, 0, getScrollRange());
        onOverScrolled(i13, i15, z, z2);
        if (!z) {
        }
        return true;
    }

    /* renamed from: K  reason: contains not printable characters */
    public final boolean m630(int i, int i2, int i3) {
        boolean z;
        int height = getHeight();
        int scrollY = getScrollY();
        int i4 = height + scrollY;
        boolean z2 = i == 33;
        ArrayList focusables = getFocusables(2);
        int size = focusables.size();
        View view = null;
        boolean z3 = false;
        for (int i5 = 0; i5 < size; i5++) {
            View view2 = (View) focusables.get(i5);
            int top2 = view2.getTop();
            int bottom = view2.getBottom();
            if (i2 < bottom && top2 < i3) {
                boolean z4 = i2 < top2 && bottom < i3;
                if (view == null) {
                    view = view2;
                    z3 = z4;
                } else {
                    boolean z5 = (z2 && top2 < view.getTop()) || (!z2 && bottom > view.getBottom());
                    if (z3) {
                        if (z4) {
                            if (!z5) {
                            }
                        }
                    } else if (z4) {
                        view = view2;
                        z3 = true;
                    } else if (!z5) {
                    }
                    view = view2;
                }
            }
        }
        if (view == null) {
            view = this;
        }
        if (i2 < scrollY || i3 > i4) {
            m615(z2 ? i2 - scrollY : i3 - i4);
            z = true;
        } else {
            z = false;
        }
        if (view != findFocus()) {
            view.requestFocus(i);
        }
        return z;
    }

    /* renamed from: K  reason: contains not printable characters */
    public boolean m629(int i) {
        View findFocus = findFocus();
        if (findFocus == this) {
            findFocus = null;
        }
        View findNextFocus = FocusFinder.getInstance().findNextFocus(this, findFocus, i);
        int maxScrollAmount = getMaxScrollAmount();
        if (findNextFocus == null || !m634(findNextFocus, maxScrollAmount, getHeight())) {
            if (i == 33 && getScrollY() < maxScrollAmount) {
                maxScrollAmount = getScrollY();
            } else if (i == 130 && getChildCount() > 0) {
                View childAt = getChildAt(0);
                maxScrollAmount = Math.min((childAt.getBottom() + ((FrameLayout.LayoutParams) childAt.getLayoutParams()).bottomMargin) - ((getHeight() + getScrollY()) - getPaddingBottom()), maxScrollAmount);
            }
            if (maxScrollAmount == 0) {
                return false;
            }
            if (i != 130) {
                maxScrollAmount = -maxScrollAmount;
            }
            m615(maxScrollAmount);
        } else {
            findNextFocus.getDrawingRect(this.f1175);
            offsetDescendantRectToMyCoords(findNextFocus, this.f1175);
            m615(m619(this.f1175));
            findNextFocus.requestFocus(i);
        }
        if (findFocus != null && findFocus.isFocused() && (!m634(findFocus, 0, getHeight()))) {
            int descendantFocusability = getDescendantFocusability();
            setDescendantFocusability(131072);
            requestFocus();
            setDescendantFocusability(descendantFocusability);
        }
        return true;
    }

    /* renamed from: K  reason: contains not printable characters */
    public final boolean m634(View view, int i, int i2) {
        view.getDrawingRect(this.f1175);
        offsetDescendantRectToMyCoords(view, this.f1175);
        return this.f1175.bottom + i >= getScrollY() && this.f1175.top - i <= getScrollY() + i2;
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m621(int i, int i2) {
        m623(i, i2, 250, false);
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m623(int i, int i2, int i3, boolean z) {
        if (getChildCount() != 0) {
            if (AnimationUtils.currentAnimationTimeMillis() - this.f1186 > 250) {
                View childAt = getChildAt(0);
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) childAt.getLayoutParams();
                int scrollY = getScrollY();
                OverScroller overScroller = this.f1197;
                int scrollX = getScrollX();
                overScroller.startScroll(scrollX, scrollY, 0, Math.max(0, Math.min(i2 + scrollY, Math.max(0, ((childAt.getHeight() + layoutParams.topMargin) + layoutParams.bottomMargin) - ((getHeight() - getPaddingTop()) - getPaddingBottom())))) - scrollY, i3);
                m628(z);
            } else {
                if (!this.f1197.isFinished()) {
                    m620();
                }
                scrollBy(i, i2);
            }
            this.f1186 = AnimationUtils.currentAnimationTimeMillis();
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m624(int i, int i2, boolean z) {
        m616(i, i2, 250, z);
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m628(boolean z) {
        if (z) {
            m617(2, 1);
        } else {
            m618(1);
        }
        this.f1196 = getScrollY();
        C1729.m4449(this);
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m620() {
        this.f1197.abortAnimation();
        m618(1);
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m627(View view) {
        view.getDrawingRect(this.f1175);
        offsetDescendantRectToMyCoords(view, this.f1175);
        int r2 = m619(this.f1175);
        if (r2 != 0) {
            scrollBy(0, r2);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public int m619(Rect rect) {
        int i;
        int i2;
        if (getChildCount() == 0) {
            return 0;
        }
        int height = getHeight();
        int scrollY = getScrollY();
        int i3 = scrollY + height;
        int verticalFadingEdgeLength = getVerticalFadingEdgeLength();
        if (rect.top > 0) {
            scrollY += verticalFadingEdgeLength;
        }
        View childAt = getChildAt(0);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) childAt.getLayoutParams();
        int i4 = rect.bottom < (childAt.getHeight() + layoutParams.topMargin) + layoutParams.bottomMargin ? i3 - verticalFadingEdgeLength : i3;
        if (rect.bottom > i4 && rect.top > scrollY) {
            if (rect.height() > height) {
                i2 = rect.top - scrollY;
            } else {
                i2 = rect.bottom - i4;
            }
            return Math.min(i2 + 0, (childAt.getBottom() + layoutParams.bottomMargin) - i3);
        } else if (rect.top >= scrollY || rect.bottom >= i4) {
            return 0;
        } else {
            if (rect.height() > height) {
                i = 0 - (i4 - rect.bottom);
            } else {
                i = 0 - (scrollY - rect.top);
            }
            return Math.max(i, -getScrollY());
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public static boolean m610(View view, View view2) {
        if (view == view2) {
            return true;
        }
        ViewParent parent = view.getParent();
        if (!(parent instanceof ViewGroup) || !m610((View) parent, view2)) {
            return false;
        }
        return true;
    }
}
