package androidx.core.graphics.drawable;

import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.drawable.Icon;
import android.os.Build;
import android.os.Parcelable;
import android.util.Log;
import androidx.versionedparcelable.CustomVersionedParcelable;
import com.facebook.internal.security.CertificateUtil;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;

public class IconCompat extends CustomVersionedParcelable {

    /* renamed from: ᕣ  reason: contains not printable characters */
    public static final PorterDuff.Mode f1154 = PorterDuff.Mode.SRC_IN;

    /* renamed from: ʬ  reason: contains not printable characters */
    public byte[] f1155 = null;

    /* renamed from: ඓ  reason: contains not printable characters */
    public int f1156 = 0;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public String f1157 = null;

    /* renamed from: ῲ  reason: contains not printable characters */
    public Object f1158;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public ColorStateList f1159 = null;

    /* renamed from: K  reason: contains not printable characters */
    public int f1160 = -1;

    /* renamed from: 㳳  reason: contains not printable characters */
    public String f1161;

    /* renamed from: 㴹  reason: contains not printable characters */
    public int f1162 = 0;

    /* renamed from: 㸾  reason: contains not printable characters */
    public Parcelable f1163 = null;

    /* renamed from: 㿎  reason: contains not printable characters */
    public PorterDuff.Mode f1164 = f1154;

    public String toString() {
        String str;
        if (this.f1160 == -1) {
            return String.valueOf(this.f1158);
        }
        StringBuilder sb = new StringBuilder("Icon(typ=");
        switch (this.f1160) {
            case 1:
                str = "BITMAP";
                break;
            case 2:
                str = "RESOURCE";
                break;
            case 3:
                str = "DATA";
                break;
            case 4:
                str = "URI";
                break;
            case 5:
                str = "BITMAP_MASKABLE";
                break;
            case 6:
                str = "URI_MASKABLE";
                break;
            default:
                str = "UNKNOWN";
                break;
        }
        sb.append(str);
        switch (this.f1160) {
            case 1:
            case 5:
                sb.append(" size=");
                sb.append(((Bitmap) this.f1158).getWidth());
                sb.append("x");
                sb.append(((Bitmap) this.f1158).getHeight());
                break;
            case 2:
                sb.append(" pkg=");
                sb.append(this.f1161);
                sb.append(" id=");
                sb.append(String.format("0x%08x", Integer.valueOf(m607())));
                break;
            case 3:
                sb.append(" len=");
                sb.append(this.f1156);
                if (this.f1162 != 0) {
                    sb.append(" off=");
                    sb.append(this.f1162);
                    break;
                }
                break;
            case 4:
            case 6:
                sb.append(" uri=");
                sb.append(this.f1158);
                break;
        }
        if (this.f1159 != null) {
            sb.append(" tint=");
            sb.append(this.f1159);
        }
        if (this.f1164 != f1154) {
            sb.append(" mode=");
            sb.append(this.f1164);
        }
        sb.append(")");
        return sb.toString();
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public void m606() {
        this.f1164 = PorterDuff.Mode.valueOf(this.f1157);
        switch (this.f1160) {
            case -1:
                Parcelable parcelable = this.f1163;
                if (parcelable != null) {
                    this.f1158 = parcelable;
                    return;
                }
                throw new IllegalArgumentException("Invalid icon");
            case 0:
            default:
                return;
            case 1:
            case 5:
                Parcelable parcelable2 = this.f1163;
                if (parcelable2 != null) {
                    this.f1158 = parcelable2;
                    return;
                }
                byte[] bArr = this.f1155;
                this.f1158 = bArr;
                this.f1160 = 3;
                this.f1156 = 0;
                this.f1162 = bArr.length;
                return;
            case 2:
            case 4:
            case 6:
                this.f1158 = new String(this.f1155, Charset.forName("UTF-16"));
                if (this.f1160 == 2 && this.f1161 == null) {
                    this.f1161 = ((String) this.f1158).split(CertificateUtil.DELIMITER, -1)[0];
                    return;
                }
                return;
            case 3:
                this.f1158 = this.f1155;
                return;
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public int m607() {
        int i;
        if (this.f1160 == -1 && (i = Build.VERSION.SDK_INT) >= 23) {
            Icon icon = (Icon) this.f1158;
            if (i >= 28) {
                return icon.getResId();
            }
            try {
                return ((Integer) icon.getClass().getMethod("getResId", new Class[0]).invoke(icon, new Object[0])).intValue();
            } catch (IllegalAccessException e) {
                Log.e("IconCompat", "Unable to get icon resource", e);
                return 0;
            } catch (InvocationTargetException e2) {
                Log.e("IconCompat", "Unable to get icon resource", e2);
                return 0;
            } catch (NoSuchMethodException e3) {
                Log.e("IconCompat", "Unable to get icon resource", e3);
                return 0;
            }
        } else if (this.f1160 == 2) {
            return this.f1156;
        } else {
            throw new IllegalStateException("called getResId() on " + this);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m608(boolean z) {
        this.f1157 = this.f1164.name();
        switch (this.f1160) {
            case -1:
                if (!z) {
                    this.f1163 = (Parcelable) this.f1158;
                    return;
                }
                throw new IllegalArgumentException("Can't serialize Icon created with IconCompat#createFromIcon");
            case 0:
            default:
                return;
            case 1:
            case 5:
                if (z) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ((Bitmap) this.f1158).compress(Bitmap.CompressFormat.PNG, 90, byteArrayOutputStream);
                    this.f1155 = byteArrayOutputStream.toByteArray();
                    return;
                }
                this.f1163 = (Parcelable) this.f1158;
                return;
            case 2:
                this.f1155 = ((String) this.f1158).getBytes(Charset.forName("UTF-16"));
                return;
            case 3:
                this.f1155 = (byte[]) this.f1158;
                return;
            case 4:
            case 6:
                this.f1155 = this.f1158.toString().getBytes(Charset.forName("UTF-16"));
                return;
        }
    }
}
