package androidx.core.app;

import android.app.Service;
import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobServiceEngine;
import android.app.job.JobWorkItem;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Build;
import android.os.IBinder;
import android.os.PowerManager;
import com.facebook.places.internal.LocationPackageRequestParams;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class JobIntentService extends Service {

    /* renamed from: ᨨ  reason: contains not printable characters */
    public static final HashMap<ComponentName, AbstractC0162> f1114 = new HashMap<>();

    /* renamed from: 㿎  reason: contains not printable characters */
    public static final Object f1115 = new Object();

    /* renamed from: ʬ  reason: contains not printable characters */
    public AbstractC0162 f1116;

    /* renamed from: ඓ  reason: contains not printable characters */
    public boolean f1117 = false;

    /* renamed from: ῲ  reason: contains not printable characters */
    public AbstractC0156 f1118;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public final ArrayList<C0161> f1119;

    /* renamed from: 㴹  reason: contains not printable characters */
    public boolean f1120 = false;

    /* renamed from: 㸾  reason: contains not printable characters */
    public AsyncTaskC0158 f1121;

    /* renamed from: androidx.core.app.JobIntentService$ඓ  reason: contains not printable characters */
    public interface AbstractC0155 {
        Intent getIntent();

        /* renamed from: K  reason: contains not printable characters */
        void m592();
    }

    /* renamed from: androidx.core.app.JobIntentService$ῲ  reason: contains not printable characters */
    public interface AbstractC0156 {
    }

    /* renamed from: androidx.core.app.JobIntentService$ⁱ  reason: contains not printable characters */
    public static final class C0157 extends AbstractC0162 {

        /* renamed from: ඓ  reason: contains not printable characters */
        public final JobScheduler f1127;

        /* renamed from: 㸾  reason: contains not printable characters */
        public final JobInfo f1128;

        public C0157(Context context, ComponentName componentName, int i) {
            super(componentName);
            m600(i);
            this.f1128 = new JobInfo.Builder(i, this.f1140).setOverrideDeadline(0).build();
            this.f1127 = (JobScheduler) context.getApplicationContext().getSystemService("jobscheduler");
        }

        @Override // androidx.core.app.JobIntentService.AbstractC0162
        /* renamed from: K  reason: contains not printable characters */
        public void m593(Intent intent) {
            this.f1127.enqueue(this.f1128, new JobWorkItem(intent));
        }
    }

    /* renamed from: androidx.core.app.JobIntentService$K  reason: contains not printable characters */
    public final class AsyncTaskC0158 extends AsyncTask<Void, Void, Void> {
        public AsyncTaskC0158() {
        }

        /* Return type fixed from 'java.lang.Object' to match base method */
        /* JADX DEBUG: Method arguments types fixed to match base method, original types: [java.lang.Object[]] */
        @Override // android.os.AsyncTask
        public Void doInBackground(Void[] voidArr) {
            while (true) {
                AbstractC0155 r3 = JobIntentService.this.m584();
                if (r3 == null) {
                    return null;
                }
                JobIntentService.this.m585(r3.getIntent());
                r3.m592();
            }
        }

        /* JADX DEBUG: Method arguments types fixed to match base method, original types: [java.lang.Object] */
        @Override // android.os.AsyncTask
        public void onCancelled(Void r1) {
            JobIntentService.this.m587();
        }

        /* JADX DEBUG: Method arguments types fixed to match base method, original types: [java.lang.Object] */
        @Override // android.os.AsyncTask
        public void onPostExecute(Void r1) {
            JobIntentService.this.m587();
        }
    }

    /* renamed from: androidx.core.app.JobIntentService$㴹  reason: contains not printable characters */
    public static final class job.JobServiceEngineC0159 extends JobServiceEngine implements AbstractC0156 {

        /* renamed from: ʬ  reason: contains not printable characters */
        public JobParameters f1130;

        /* renamed from: ῲ  reason: contains not printable characters */
        public final Object f1131 = new Object();

        /* renamed from: K  reason: contains not printable characters */
        public final JobIntentService f1132;

        /* renamed from: androidx.core.app.JobIntentService$㴹$K  reason: contains not printable characters */
        public final class C0160 implements AbstractC0155 {

            /* renamed from: K  reason: contains not printable characters */
            public final JobWorkItem f1134;

            public C0160(JobWorkItem jobWorkItem) {
                this.f1134 = jobWorkItem;
            }

            @Override // androidx.core.app.JobIntentService.AbstractC0155
            public Intent getIntent() {
                return this.f1134.getIntent();
            }

            @Override // androidx.core.app.JobIntentService.AbstractC0155
            /* renamed from: K  reason: contains not printable characters */
            public void m595() {
                synchronized (job.JobServiceEngineC0159.this.f1131) {
                    if (job.JobServiceEngineC0159.this.f1130 != null) {
                        job.JobServiceEngineC0159.this.f1130.completeWork(this.f1134);
                    }
                }
            }
        }

        public job.JobServiceEngineC0159(JobIntentService jobIntentService) {
            super(jobIntentService);
            this.f1132 = jobIntentService;
        }

        public boolean onStartJob(JobParameters jobParameters) {
            this.f1130 = jobParameters;
            this.f1132.m586(false);
            return true;
        }

        public boolean onStopJob(JobParameters jobParameters) {
            boolean r3 = this.f1132.m583();
            synchronized (this.f1131) {
                this.f1130 = null;
            }
            return r3;
        }

        /* JADX WARNING: Code restructure failed: missing block: B:10:0x0013, code lost:
            r1.getIntent().setExtrasClassLoader(r3.f1132.getClassLoader());
         */
        /* JADX WARNING: Code restructure failed: missing block: B:11:0x0025, code lost:
            return new androidx.core.app.JobIntentService.job.JobServiceEngineC0159.C0160(r3, r1);
         */
        /* JADX WARNING: Code restructure failed: missing block: B:12:0x0026, code lost:
            return null;
         */
        /* JADX WARNING: Code restructure failed: missing block: B:9:0x0011, code lost:
            if (r1 == null) goto L_0x0026;
         */
        /* renamed from: K  reason: contains not printable characters */
        public AbstractC0155 m594() {
            synchronized (this.f1131) {
                if (this.f1130 == null) {
                    return null;
                }
                JobWorkItem dequeueWork = this.f1130.dequeueWork();
            }
        }
    }

    /* renamed from: androidx.core.app.JobIntentService$㸾  reason: contains not printable characters */
    public final class C0161 implements AbstractC0155 {

        /* renamed from: ῲ  reason: contains not printable characters */
        public final int f1136;

        /* renamed from: K  reason: contains not printable characters */
        public final Intent f1137;

        public C0161(Intent intent, int i) {
            this.f1137 = intent;
            this.f1136 = i;
        }

        @Override // androidx.core.app.JobIntentService.AbstractC0155
        public Intent getIntent() {
            return this.f1137;
        }

        @Override // androidx.core.app.JobIntentService.AbstractC0155
        /* renamed from: K  reason: contains not printable characters */
        public void m596() {
            JobIntentService.this.stopSelf(this.f1136);
        }
    }

    /* renamed from: androidx.core.app.JobIntentService$㿎  reason: contains not printable characters */
    public static abstract class AbstractC0162 {

        /* renamed from: ʬ  reason: contains not printable characters */
        public int f1138;

        /* renamed from: ῲ  reason: contains not printable characters */
        public boolean f1139;

        /* renamed from: K  reason: contains not printable characters */
        public final ComponentName f1140;

        public AbstractC0162(ComponentName componentName) {
            this.f1140 = componentName;
        }

        /* renamed from: ʬ  reason: contains not printable characters */
        public void m597() {
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public void m598() {
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m599() {
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m600(int i) {
            if (!this.f1139) {
                this.f1139 = true;
                this.f1138 = i;
            } else if (this.f1138 != i) {
                throw new IllegalArgumentException("Given job ID " + i + " is different than previous " + this.f1138);
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public abstract void m601(Intent intent);
    }

    public JobIntentService() {
        if (Build.VERSION.SDK_INT >= 26) {
            this.f1119 = null;
        } else {
            this.f1119 = new ArrayList<>();
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public static void m581(Context context, ComponentName componentName, int i, Intent intent) {
        if (intent != null) {
            synchronized (f1115) {
                AbstractC0162 r2 = m580(context, componentName, true, i);
                r2.m600(i);
                r2.m601(intent);
            }
            return;
        }
        throw new IllegalArgumentException("work must not be null");
    }

    public IBinder onBind(Intent intent) {
        AbstractC0156 r1 = this.f1118;
        if (r1 != null) {
            return ((job.JobServiceEngineC0159) r1).getBinder();
        }
        return null;
    }

    public void onCreate() {
        super.onCreate();
        if (Build.VERSION.SDK_INT >= 26) {
            this.f1118 = new job.JobServiceEngineC0159(this);
            this.f1116 = null;
            return;
        }
        this.f1118 = null;
        this.f1116 = m580((Context) this, new ComponentName(this, getClass()), false, 0);
    }

    public void onDestroy() {
        super.onDestroy();
        ArrayList<C0161> arrayList = this.f1119;
        if (arrayList != null) {
            synchronized (arrayList) {
                this.f1120 = true;
                this.f1116.m599();
            }
        }
    }

    public int onStartCommand(Intent intent, int i, int i2) {
        if (this.f1119 == null) {
            return 2;
        }
        this.f1116.m597();
        synchronized (this.f1119) {
            ArrayList<C0161> arrayList = this.f1119;
            if (intent == null) {
                intent = new Intent();
            }
            arrayList.add(new C0161(intent, i2));
            m586(true);
        }
        return 3;
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public boolean m582() {
        return true;
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public boolean m583() {
        AsyncTaskC0158 k = this.f1121;
        if (k != null) {
            k.cancel(this.f1117);
        }
        return m582();
    }

    /* renamed from: K  reason: contains not printable characters */
    public abstract void m585(Intent intent);

    /* renamed from: 㸾  reason: contains not printable characters */
    public void m587() {
        ArrayList<C0161> arrayList = this.f1119;
        if (arrayList != null) {
            synchronized (arrayList) {
                this.f1121 = null;
                if (this.f1119 != null && this.f1119.size() > 0) {
                    m586(false);
                } else if (!this.f1120) {
                    this.f1116.m599();
                }
            }
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public static AbstractC0162 m580(Context context, ComponentName componentName, boolean z, int i) {
        AbstractC0162 r4;
        AbstractC0162 r0 = f1114.get(componentName);
        if (r0 != null) {
            return r0;
        }
        if (Build.VERSION.SDK_INT < 26) {
            r4 = new C0154(context, componentName);
        } else if (z) {
            r4 = new C0157(context, componentName, i);
        } else {
            throw new IllegalArgumentException("Can't be here without a job id");
        }
        f1114.put(componentName, r4);
        return r4;
    }

    /* renamed from: androidx.core.app.JobIntentService$ʬ  reason: contains not printable characters */
    public static final class C0154 extends AbstractC0162 {

        /* renamed from: ඓ  reason: contains not printable characters */
        public final PowerManager.WakeLock f1122;

        /* renamed from: ⁱ  reason: contains not printable characters */
        public boolean f1123;

        /* renamed from: 㴹  reason: contains not printable characters */
        public final PowerManager.WakeLock f1124;

        /* renamed from: 㸾  reason: contains not printable characters */
        public final Context f1125;

        /* renamed from: 㿎  reason: contains not printable characters */
        public boolean f1126;

        public C0154(Context context, ComponentName componentName) {
            super(componentName);
            this.f1125 = context.getApplicationContext();
            PowerManager powerManager = (PowerManager) context.getSystemService("power");
            this.f1122 = powerManager.newWakeLock(1, componentName.getClassName() + ":launch");
            this.f1122.setReferenceCounted(false);
            this.f1124 = powerManager.newWakeLock(1, componentName.getClassName() + ":run");
            this.f1124.setReferenceCounted(false);
        }

        @Override // androidx.core.app.JobIntentService.AbstractC0162
        /* renamed from: ʬ  reason: contains not printable characters */
        public void m588() {
            synchronized (this) {
                this.f1123 = false;
            }
        }

        @Override // androidx.core.app.JobIntentService.AbstractC0162
        /* renamed from: ῲ  reason: contains not printable characters */
        public void m589() {
            synchronized (this) {
                if (!this.f1126) {
                    this.f1126 = true;
                    this.f1124.acquire(600000);
                    this.f1122.release();
                }
            }
        }

        @Override // androidx.core.app.JobIntentService.AbstractC0162
        /* renamed from: K  reason: contains not printable characters */
        public void m591(Intent intent) {
            Intent intent2 = new Intent(intent);
            intent2.setComponent(this.f1140);
            if (this.f1125.startService(intent2) != null) {
                synchronized (this) {
                    if (!this.f1123) {
                        this.f1123 = true;
                        if (!this.f1126) {
                            this.f1122.acquire(LocationPackageRequestParams.DEFAULT_LAST_LOCATION_MAX_AGE_MS);
                        }
                    }
                }
            }
        }

        @Override // androidx.core.app.JobIntentService.AbstractC0162
        /* renamed from: K  reason: contains not printable characters */
        public void m590() {
            synchronized (this) {
                if (this.f1126) {
                    if (this.f1123) {
                        this.f1122.acquire(LocationPackageRequestParams.DEFAULT_LAST_LOCATION_MAX_AGE_MS);
                    }
                    this.f1126 = false;
                    this.f1124.release();
                }
            }
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m586(boolean z) {
        if (this.f1121 == null) {
            this.f1121 = new AsyncTaskC0158();
            AbstractC0162 r0 = this.f1116;
            if (r0 != null && z) {
                r0.m598();
            }
            this.f1121.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public AbstractC0155 m584() {
        AbstractC0156 r0 = this.f1118;
        if (r0 != null) {
            return ((job.JobServiceEngineC0159) r0).m594();
        }
        synchronized (this.f1119) {
            if (this.f1119.size() <= 0) {
                return null;
            }
            return this.f1119.remove(0);
        }
    }
}
