package androidx.constraintlayout.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.View;
import androidx.constraintlayout.solver.widgets.ConstraintWidget;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.google.android.material.progressindicator.BaseProgressIndicator;

public class Placeholder extends View {

    /* renamed from: ʬ  reason: contains not printable characters */
    public View f1087 = null;

    /* renamed from: ῲ  reason: contains not printable characters */
    public int f1088 = -1;

    /* renamed from: 㸾  reason: contains not printable characters */
    public int f1089 = 4;

    public Placeholder(Context context) {
        super(context);
        m571((AttributeSet) null);
    }

    public View getContent() {
        return this.f1087;
    }

    public int getEmptyVisibility() {
        return this.f1089;
    }

    public void onDraw(Canvas canvas) {
        if (isInEditMode()) {
            canvas.drawRGB(223, 223, 223);
            Paint paint = new Paint();
            paint.setARGB(BaseProgressIndicator.MAX_ALPHA, 210, 210, 210);
            paint.setTextAlign(Paint.Align.CENTER);
            paint.setTypeface(Typeface.create(Typeface.DEFAULT, 0));
            Rect rect = new Rect();
            canvas.getClipBounds(rect);
            paint.setTextSize((float) rect.height());
            int height = rect.height();
            int width = rect.width();
            paint.setTextAlign(Paint.Align.LEFT);
            paint.getTextBounds("?", 0, 1, rect);
            canvas.drawText("?", ((((float) width) / 2.0f) - (((float) rect.width()) / 2.0f)) - ((float) rect.left), ((((float) rect.height()) / 2.0f) + (((float) height) / 2.0f)) - ((float) rect.bottom), paint);
        }
    }

    public void setContentId(int i) {
        View findViewById;
        if (this.f1088 != i) {
            View view = this.f1087;
            if (view != null) {
                view.setVisibility(0);
                ((ConstraintLayout.C0140) this.f1087.getLayoutParams()).f1062 = false;
                this.f1087 = null;
            }
            this.f1088 = i;
            if (i != -1 && (findViewById = ((View) getParent()).findViewById(i)) != null) {
                findViewById.setVisibility(8);
            }
        }
    }

    public void setEmptyVisibility(int i) {
        this.f1089 = i;
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m571(AttributeSet attributeSet) {
        super.setVisibility(this.f1089);
        this.f1088 = -1;
        if (attributeSet != null) {
            TypedArray obtainStyledAttributes = getContext().obtainStyledAttributes(attributeSet, R$styleable.ConstraintLayout_placeholder);
            int indexCount = obtainStyledAttributes.getIndexCount();
            for (int i = 0; i < indexCount; i++) {
                int index = obtainStyledAttributes.getIndex(i);
                if (index == R$styleable.ConstraintLayout_placeholder_content) {
                    this.f1088 = obtainStyledAttributes.getResourceId(index, this.f1088);
                } else if (index == R$styleable.ConstraintLayout_placeholder_placeholder_emptyVisibility) {
                    this.f1089 = obtainStyledAttributes.getInt(index, this.f1089);
                }
            }
            obtainStyledAttributes.recycle();
        }
    }

    public Placeholder(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        m571(attributeSet);
    }

    public Placeholder(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        m571(attributeSet);
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m572(ConstraintLayout constraintLayout) {
        if (this.f1088 == -1 && !isInEditMode()) {
            setVisibility(this.f1089);
        }
        this.f1087 = constraintLayout.findViewById(this.f1088);
        View view = this.f1087;
        if (view != null) {
            ((ConstraintLayout.C0140) view.getLayoutParams()).f1062 = true;
            this.f1087.setVisibility(0);
            setVisibility(0);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m570() {
        if (this.f1087 != null) {
            ConstraintLayout.C0140 k = (ConstraintLayout.C0140) getLayoutParams();
            ConstraintLayout.C0140 k2 = (ConstraintLayout.C0140) this.f1087.getLayoutParams();
            k2.f1025.f840 = 0;
            if (k.f1025.m508() != ConstraintWidget.DimensionBehaviour.FIXED) {
                k.f1025.m502(k2.f1025.m478());
            }
            if (k.f1025.m512() != ConstraintWidget.DimensionBehaviour.FIXED) {
                k.f1025.m479(k2.f1025.m473());
            }
            k2.f1025.f840 = 8;
        }
    }
}
