package androidx.constraintlayout.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.constraintlayout.solver.widgets.ConstraintWidget;
import androidx.constraintlayout.widget.ConstraintLayout;
import java.util.Arrays;
import java.util.HashMap;
import ῲ.ⁱ.ʬ.C2059;
import ῲ.ⁱ.ῲ.㿎.AbstractC2105;
import ῲ.ⁱ.ῲ.㿎.C2102;

public abstract class ConstraintHelper extends View {

    /* renamed from: ʬ  reason: contains not printable characters */
    public int f990;

    /* renamed from: ඓ  reason: contains not printable characters */
    public AbstractC2105 f991;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public HashMap<Integer, String> f992;

    /* renamed from: ῲ  reason: contains not printable characters */
    public int[] f993;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public String f994;

    /* renamed from: 㴹  reason: contains not printable characters */
    public boolean f995;

    /* renamed from: 㸾  reason: contains not printable characters */
    public Context f996;

    /* renamed from: 㿎  reason: contains not printable characters */
    public View[] f997;

    public ConstraintHelper(Context context) {
        super(context);
        this.f993 = new int[32];
        this.f995 = false;
        this.f997 = null;
        this.f992 = new HashMap<>();
        this.f996 = context;
        m557((AttributeSet) null);
    }

    public int[] getReferencedIds() {
        return Arrays.copyOf(this.f993, this.f990);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        String str = this.f994;
        if (str != null) {
            setIds(str);
        }
    }

    public void onDraw(Canvas canvas) {
    }

    public void onMeasure(int i, int i2) {
        if (this.f995) {
            super.onMeasure(i, i2);
        } else {
            setMeasuredDimension(0, 0);
        }
    }

    public void setIds(String str) {
        this.f994 = str;
        if (str != null) {
            int i = 0;
            this.f990 = 0;
            while (true) {
                int indexOf = str.indexOf(44, i);
                if (indexOf == -1) {
                    m560(str.substring(i));
                    return;
                } else {
                    m560(str.substring(i, indexOf));
                    i = indexOf + 1;
                }
            }
        }
    }

    public void setReferencedIds(int[] iArr) {
        this.f994 = null;
        this.f990 = 0;
        for (int i : iArr) {
            m556(i);
        }
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public void m548() {
        if (this.f991 != null) {
            ViewGroup.LayoutParams layoutParams = getLayoutParams();
            if (layoutParams instanceof ConstraintLayout.C0140) {
                ((ConstraintLayout.C0140) layoutParams).f1025 = (ConstraintWidget) this.f991;
            }
        }
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public void m549(ConstraintLayout constraintLayout) {
    }

    /* renamed from: ඓ  reason: contains not printable characters */
    public void m550(ConstraintLayout constraintLayout) {
        String str;
        int r3;
        if (isInEditMode()) {
            setIds(this.f994);
        }
        AbstractC2105 r0 = this.f991;
        if (r0 != null) {
            ((C2102) r0).m5559();
            for (int i = 0; i < this.f990; i++) {
                int i2 = this.f993[i];
                View viewById = constraintLayout.getViewById(i2);
                if (viewById == null && (r3 = m554(constraintLayout, (str = this.f992.get(Integer.valueOf(i2))))) != 0) {
                    this.f993[i] = r3;
                    this.f992.put(Integer.valueOf(r3), str);
                    viewById = constraintLayout.getViewById(r3);
                }
                if (viewById != null) {
                    ((C2102) this.f991).m5555(constraintLayout.getViewWidget(viewById));
                }
            }
            this.f991.m5572(constraintLayout.mLayoutWidget);
        }
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public final int m551(String str) {
        ConstraintLayout constraintLayout = getParent() instanceof ConstraintLayout ? (ConstraintLayout) getParent() : null;
        int i = 0;
        if (isInEditMode() && constraintLayout != null) {
            Object designInformation = constraintLayout.getDesignInformation(0, str);
            if (designInformation instanceof Integer) {
                i = ((Integer) designInformation).intValue();
            }
        }
        if (i == 0 && constraintLayout != null) {
            i = m554(constraintLayout, str);
        }
        if (i == 0) {
            try {
                i = R$id.class.getField(str).getInt(null);
            } catch (Exception unused) {
            }
        }
        return i == 0 ? this.f996.getResources().getIdentifier(str, "id", this.f996.getPackageName()) : i;
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public void m552() {
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m557(AttributeSet attributeSet) {
        if (attributeSet != null) {
            TypedArray obtainStyledAttributes = getContext().obtainStyledAttributes(attributeSet, R$styleable.ConstraintLayout_Layout);
            int indexCount = obtainStyledAttributes.getIndexCount();
            for (int i = 0; i < indexCount; i++) {
                int index = obtainStyledAttributes.getIndex(i);
                if (index == R$styleable.ConstraintLayout_Layout_constraint_referenced_ids) {
                    this.f994 = obtainStyledAttributes.getString(index);
                    setIds(this.f994);
                }
            }
            obtainStyledAttributes.recycle();
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m558(ConstraintWidget constraintWidget, boolean z) {
    }

    /* renamed from: 㸾  reason: contains not printable characters */
    public void m563(ConstraintLayout constraintLayout) {
    }

    public ConstraintHelper(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.f993 = new int[32];
        this.f995 = false;
        this.f997 = null;
        this.f992 = new HashMap<>();
        this.f996 = context;
        m557(attributeSet);
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m556(int i) {
        if (i != getId()) {
            int i2 = this.f990 + 1;
            int[] iArr = this.f993;
            if (i2 > iArr.length) {
                this.f993 = Arrays.copyOf(iArr, iArr.length * 2);
            }
            int[] iArr2 = this.f993;
            int i3 = this.f990;
            iArr2[i3] = i;
            this.f990 = i3 + 1;
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m560(String str) {
        if (str != null && str.length() != 0 && this.f996 != null) {
            String trim = str.trim();
            if (getParent() instanceof ConstraintLayout) {
                ConstraintLayout constraintLayout = (ConstraintLayout) getParent();
            }
            int r0 = m551(trim);
            if (r0 != 0) {
                this.f992.put(Integer.valueOf(r0), trim);
                m556(r0);
                return;
            }
            Log.w("ConstraintHelper", "Could not find id of \"" + trim + "\"");
        }
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public View[] m553(ConstraintLayout constraintLayout) {
        View[] viewArr = this.f997;
        if (viewArr == null || viewArr.length != this.f990) {
            this.f997 = new View[this.f990];
        }
        for (int i = 0; i < this.f990; i++) {
            this.f997[i] = constraintLayout.getViewById(this.f993[i]);
        }
        return this.f997;
    }

    public ConstraintHelper(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.f993 = new int[32];
        this.f995 = false;
        this.f997 = null;
        this.f992 = new HashMap<>();
        this.f996 = context;
        m557(attributeSet);
    }

    /* renamed from: K  reason: contains not printable characters */
    public final int m554(ConstraintLayout constraintLayout, String str) {
        Resources resources;
        if (str == null || constraintLayout == null || (resources = this.f996.getResources()) == null) {
            return 0;
        }
        int childCount = constraintLayout.getChildCount();
        for (int i = 0; i < childCount; i++) {
            View childAt = constraintLayout.getChildAt(i);
            if (childAt.getId() != -1) {
                String str2 = null;
                try {
                    str2 = resources.getResourceEntryName(childAt.getId());
                } catch (Resources.NotFoundException unused) {
                }
                if (str.equals(str2)) {
                    return childAt.getId();
                }
            }
        }
        return 0;
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m559(ConstraintLayout constraintLayout) {
        int visibility = getVisibility();
        int i = Build.VERSION.SDK_INT;
        float elevation = getElevation();
        for (int i2 = 0; i2 < this.f990; i2++) {
            View viewById = constraintLayout.getViewById(this.f993[i2]);
            if (viewById != null) {
                viewById.setVisibility(visibility);
                if (elevation > 0.0f) {
                    int i3 = Build.VERSION.SDK_INT;
                    viewById.setTranslationZ(viewById.getTranslationZ() + elevation);
                }
            }
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m555() {
        ViewParent parent = getParent();
        if (parent != null && (parent instanceof ConstraintLayout)) {
            m559((ConstraintLayout) parent);
        }
    }

    /* JADX WARN: Incorrect args count in method signature: (Lῲ/ⁱ/ῲ/㿎/ʬ;Lῲ/ⁱ/ῲ/㿎/㴹;Landroid/util/SparseArray<Landroidx/constraintlayout/solver/widgets/ConstraintWidget;>;)V */
    /* renamed from: K  reason: contains not printable characters */
    public void m562(AbstractC2105 r3, SparseArray sparseArray) {
        C2102 r32 = (C2102) r3;
        r32.m5559();
        for (int i = 0; i < this.f990; i++) {
            r32.m5555((ConstraintWidget) sparseArray.get(this.f993[i]));
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m561(C2059.C2063 k, C2102 r9, ConstraintLayout.C0140 k2, SparseArray<ConstraintWidget> sparseArray) {
        C2059.C2062 r10 = k.f7099;
        int[] iArr = r10.f7041;
        int i = 0;
        if (iArr != null) {
            setReferencedIds(iArr);
        } else {
            String str = r10.f7067;
            if (str != null && str.length() > 0) {
                C2059.C2062 r102 = k.f7099;
                String[] split = r102.f7067.split(",");
                getContext();
                int[] iArr2 = new int[split.length];
                int i2 = 0;
                for (String str2 : split) {
                    int r5 = m551(str2.trim());
                    if (r5 != 0) {
                        iArr2[i2] = r5;
                        i2++;
                    }
                }
                if (i2 != split.length) {
                    iArr2 = Arrays.copyOf(iArr2, i2);
                }
                r102.f7041 = iArr2;
            }
        }
        r9.m5559();
        if (k.f7099.f7041 != null) {
            while (true) {
                int[] iArr3 = k.f7099.f7041;
                if (i < iArr3.length) {
                    ConstraintWidget constraintWidget = sparseArray.get(iArr3[i]);
                    if (constraintWidget != null) {
                        r9.m5555(constraintWidget);
                    }
                    i++;
                } else {
                    return;
                }
            }
        }
    }
}
