package androidx.constraintlayout.utils.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import androidx.constraintlayout.widget.R$styleable;
import com.google.android.material.progressindicator.BaseProgressIndicator;

public class MockView extends View {

    /* renamed from: ʬ  reason: contains not printable characters */
    public Paint f961 = new Paint();

    /* renamed from: ඓ  reason: contains not printable characters */
    public boolean f962 = true;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public int f963 = Color.argb((int) BaseProgressIndicator.MAX_ALPHA, 50, 50, 50);

    /* renamed from: ᨨ  reason: contains not printable characters */
    public int f964 = Color.argb((int) BaseProgressIndicator.MAX_ALPHA, 0, 0, 0);

    /* renamed from: ῲ  reason: contains not printable characters */
    public Paint f965 = new Paint();

    /* renamed from: ⁱ  reason: contains not printable characters */
    public String f966 = null;

    /* renamed from: 㑃  reason: contains not printable characters */
    public int f967 = 4;

    /* renamed from: 㳳  reason: contains not printable characters */
    public int f968 = Color.argb((int) BaseProgressIndicator.MAX_ALPHA, 200, 200, 200);

    /* renamed from: 㴹  reason: contains not printable characters */
    public boolean f969 = true;

    /* renamed from: 㸾  reason: contains not printable characters */
    public Paint f970 = new Paint();

    /* renamed from: 㿎  reason: contains not printable characters */
    public Rect f971 = new Rect();

    public MockView(Context context) {
        super(context);
        m533(context, null);
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int width = getWidth();
        int height = getHeight();
        if (this.f962) {
            width--;
            height--;
            float f = (float) width;
            float f2 = (float) height;
            canvas.drawLine(0.0f, 0.0f, f, f2, this.f965);
            canvas.drawLine(0.0f, f2, f, 0.0f, this.f965);
            canvas.drawLine(0.0f, 0.0f, f, 0.0f, this.f965);
            canvas.drawLine(f, 0.0f, f, f2, this.f965);
            canvas.drawLine(f, f2, 0.0f, f2, this.f965);
            canvas.drawLine(0.0f, f2, 0.0f, 0.0f, this.f965);
        }
        String str = this.f966;
        if (str != null && this.f969) {
            this.f961.getTextBounds(str, 0, str.length(), this.f971);
            float width2 = ((float) (width - this.f971.width())) / 2.0f;
            float height2 = (((float) (height - this.f971.height())) / 2.0f) + ((float) this.f971.height());
            this.f971.offset((int) width2, (int) height2);
            Rect rect = this.f971;
            int i = rect.left;
            int i2 = this.f967;
            rect.set(i - i2, rect.top - i2, rect.right + i2, rect.bottom + i2);
            canvas.drawRect(this.f971, this.f970);
            canvas.drawText(this.f966, width2, height2, this.f961);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m533(Context context, AttributeSet attributeSet) {
        if (attributeSet != null) {
            TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, R$styleable.MockView);
            int indexCount = obtainStyledAttributes.getIndexCount();
            for (int i = 0; i < indexCount; i++) {
                int index = obtainStyledAttributes.getIndex(i);
                if (index == R$styleable.MockView_mock_label) {
                    this.f966 = obtainStyledAttributes.getString(index);
                } else if (index == R$styleable.MockView_mock_showDiagonals) {
                    this.f962 = obtainStyledAttributes.getBoolean(index, this.f962);
                } else if (index == R$styleable.MockView_mock_diagonalsColor) {
                    this.f964 = obtainStyledAttributes.getColor(index, this.f964);
                } else if (index == R$styleable.MockView_mock_labelBackgroundColor) {
                    this.f963 = obtainStyledAttributes.getColor(index, this.f963);
                } else if (index == R$styleable.MockView_mock_labelColor) {
                    this.f968 = obtainStyledAttributes.getColor(index, this.f968);
                } else if (index == R$styleable.MockView_mock_showLabel) {
                    this.f969 = obtainStyledAttributes.getBoolean(index, this.f969);
                }
            }
            obtainStyledAttributes.recycle();
        }
        if (this.f966 == null) {
            try {
                this.f966 = context.getResources().getResourceEntryName(getId());
            } catch (Exception unused) {
            }
        }
        this.f965.setColor(this.f964);
        this.f965.setAntiAlias(true);
        this.f961.setColor(this.f968);
        this.f961.setAntiAlias(true);
        this.f970.setColor(this.f963);
        this.f967 = Math.round((getResources().getDisplayMetrics().xdpi / 160.0f) * ((float) this.f967));
    }

    public MockView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        m533(context, attributeSet);
    }

    public MockView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        m533(context, attributeSet);
    }
}
